#pragma once

#include <atomic>
#include <memory>
#include <string>
#include <vector>

#include "tpch/tpch_benchmark_item_runner.hpp"

namespace hyrise {

// The generation of JCC-H items is based on top of that of the TPC-H. Instead of creating random values in the C++
// code, we use those generated by JCC-H's qgen. See _on_execute_item for details.

class JCCHBenchmarkItemRunner : public TPCHBenchmarkItemRunner {
 public:
  // Constructor for a JCCHBenchmarkItemRunner containing all TPC-H queries
  JCCHBenchmarkItemRunner(const bool skewed, const std::string& dbgen_path, const std::string& data_path,
                          const std::shared_ptr<BenchmarkConfig>& config, bool use_prepared_statements,
                          float scale_factor, ClusteringConfiguration clustering_configuration);

  // Constructor for a JCCHBenchmarkItemRunner containing a subset of TPC-H queries
  JCCHBenchmarkItemRunner(const bool skewed, const std::string& dbgen_path, const std::string& data_path,
                          const std::shared_ptr<BenchmarkConfig>& config, bool use_prepared_statements,
                          float scale_factor, ClusteringConfiguration clustering_configuration,
                          const std::vector<BenchmarkItemID>& items);

  std::string item_name(const BenchmarkItemID item_id) const override;

 protected:
  bool _on_execute_item(const BenchmarkItemID item_id, BenchmarkSQLExecutor& sql_executor) override;

  void _load_params();

  const bool _skewed;
  const std::string _dbgen_path;
  const std::string _data_path;
  std::array<std::vector<std::vector<std::string>>, 22> _all_params;
};

}  // namespace hyrise
