CREATE TABLE SUPPLIER (
  S_SUPPKEY  INTEGER PRIMARY KEY,
  S_NAME CHAR(25),
  S_ADDRESS VARCHAR(40),
  S_NATIONKEY INTEGER,
  S_PHONE CHAR(15),
  S_ACCTBAL REAL,
  S_COMMENT VARCHAR(101));

CREATE TABLE PART (
  P_PARTKEY INTEGER PRIMARY KEY,
  P_NAME VARCHAR(55),
  P_MFGR CHAR(25),
  P_BRAND CHAR(10),
  P_TYPE VARCHAR(25),
  P_SIZE INTEGER,
  P_CONTAINER CHAR(10),
  P_RETAILPRICE REAL,
  P_COMMENT VARCHAR(23));

CREATE TABLE PARTSUPP (
  PS_PARTKEY INTEGER,
  PS_SUPPKEY INTEGER,
  PS_AVAILQTY INTEGER,
  PS_SUPPLYCOST REAL,
  PS_COMMENT VARCHAR(199),
  PRIMARY KEY (PS_PARTKEY, PS_SUPPKEY));

CREATE TABLE CUSTOMER (
  C_CUSTKEY INTEGER PRIMARY KEY,
  C_NAME VARCHAR(25),
  C_ADDRESS VARCHAR(40),
  C_NATIONKEY INTEGER,
  C_PHONE CHAR(15),
  C_ACCTBAL REAL,
  C_MKTSEGMENT CHAR(10),
  C_COMMENT VARCHAR(117));

CREATE TABLE ORDERS (
  O_ORDERKEY INTEGER PRIMARY KEY,
  O_CUSTKEY INTEGER,
  O_ORDERSTATUS CHAR(1),
  O_TOTALPRICE REAL,
  O_ORDERDATE DATE,
  O_ORDERPRIORITY CHAR(15),
  O_CLERK CHAR(15),
  O_SHIPPRIORITY INTEGER,
  O_COMMENT VARCHAR(79));

CREATE TABLE LINEITEM (
  L_ORDERKEY INTEGER,
  L_PARTKEY INTEGER,
  L_SUPPKEY INTEGER,
  L_LINENUMBER INTEGER,
  L_QUANTITY REAL,
  L_EXTENDEDPRICE REAL,
  L_DISCOUNT REAL,
  L_TAX REAL,
  L_RETURNFLAG CHAR(1),
  L_LINESTATUS CHAR(1),
  L_SHIPDATE DATE,
  L_COMMITDATE DATE,
  L_RECEIPTDATE DATE,
  L_SHIPINSTRUCT CHAR(25),
  L_SHIPMODE CHAR(10),
  L_COMMENT VARCHAR(44),
  PRIMARY KEY (L_ORDERKEY, L_LINENUMBER));

CREATE TABLE NATION (
  N_NATIONKEY INTEGER PRIMARY KEY,
  N_NAME CHAR(25),
  N_REGIONKEY INTEGER,
  N_COMMENT VARCHAR(152));

CREATE TABLE REGION (
  R_REGIONKEY INTEGER PRIMARY KEY,
  R_NAME CHAR(25),
  R_COMMENT VARCHAR(152));