package Reservista.example.Backend.Validators;


import jakarta.validation.Constraint;
import jakarta.validation.Payload;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import static Reservista.example.Backend.Config.ValidationUtil.invalidPassword;

@Target({ElementType.FIELD, ElementType.PARAMETER})
@Retention(RetentionPolicy.RUNTIME)
@Constraint(validatedBy = StrongPasswordValidator.class)
public @interface StrongPassword {
    String message() default invalidPassword;
    Class<?>[] groups() default {};
    Class<? extends Payload>[] payload() default {};
}