﻿using System.Security.Claims;

namespace HsnSoft.Base.Security.Claims;

//TODO: Instead of directly using static properties, can we just create an BaseClaimOptions and pass these values as defaults?
/// <summary>
/// Used to get Base-specific claim type names.
/// </summary>
public static class BaseClaimTypes
{
    /// <summary>
    /// Default: <see cref="ClaimTypes.Name"/>
    /// </summary>
    public static string UserName { get; set; } = ClaimTypes.Name;

    /// <summary>
    /// Default: <see cref="ClaimTypes.GivenName"/>
    /// </summary>
    public static string Name { get; set; } = ClaimTypes.GivenName;

    /// <summary>
    /// Default: <see cref="ClaimTypes.Surname"/>
    /// </summary>
    public static string SurName { get; set; } = ClaimTypes.Surname;

    /// <summary>
    /// Default: <see cref="ClaimTypes.NameIdentifier"/>
    /// </summary>
    public static string UserId { get; set; } = ClaimTypes.NameIdentifier;

    /// <summary>
    /// Default: <see cref="ClaimTypes.Role"/>
    /// </summary>
    public static string Role { get; set; } = ClaimTypes.Role;

    /// <summary>
    /// Default: <see cref="ClaimTypes.Email"/>
    /// </summary>
    public static string Email { get; set; } = ClaimTypes.Email;

    /// <summary>
    /// Default: "email_verified".
    /// </summary>
    public static string EmailVerified { get; set; } = "email_verified";

    /// <summary>
    /// Default: "phone_number".
    /// </summary>
    public static string PhoneNumber { get; set; } = "phone_number";

    /// <summary>
    /// Default: "phone_number_verified".
    /// </summary>
    public static string PhoneNumberVerified { get; set; } = "phone_number_verified";

    /// <summary>
    /// Default: "tenantid".
    /// </summary>
    public static string TenantId { get; set; } = "tenantid";
    public static string TenantDomain { get; set; } = "tenantdomain";

    /// <summary>
    /// Default: "editionid".
    /// </summary>
    public static string EditionId { get; set; } = "editionid";

    /// <summary>
    /// Default: "client_id".
    /// </summary>
    public static string ClientId { get; set; } = "client_id";

    /// <summary>
    /// Default: "impersonator_tenantid".
    /// </summary>
    public static string ImpersonatorTenantId { get; set; } = "impersonator_tenantid";

    /// <summary>
    /// Default: "impersonator_userid".
    /// </summary>
    public static string ImpersonatorUserId { get; set; } = "impersonator_userid";

    /// <summary>
    /// Default: "impersonator_tenantname".
    /// </summary>
    public static string ImpersonatorTenantName { get; set; } = "impersonator_tenantname";

    /// <summary>
    /// Default: "impersonator_username".
    /// </summary>
    public static string ImpersonatorUserName { get; set; } = "impersonator_username";
}