namespace System;

/// <summary>
/// Extension methods for <see cref="IComparable{T}"/>.
/// </summary>
public static class BaseComparableExtensions
{
    /// <summary>
    /// Checks a value is between a minimum and maximum value.
    /// </summary>
    /// <param name="value">The value to be checked</param>
    /// <param name="minInclusiveValue">Minimum (inclusive) value</param>
    /// <param name="maxInclusiveValue">Maximum (inclusive) value</param>
    public static bool IsBetween<T>(this T value, T minInclusiveValue, T maxInclusiveValue) where T : IComparable<T>
    {
        return value.CompareTo(minInclusiveValue) >= 0 && value.CompareTo(maxInclusiveValue) <= 0;
    }
}