# BitlyApi 

## This package is not maintained
Check [phplicengine/bitly](https://packagist.org/packages/phplicengine/bitly) as a possible replacement.

[![Build Status](https://travis-ci.org/hpatoio/bitly-api.svg?branch=master)](https://travis-ci.org/hpatoio/bitly-api)
[![Total Downloads](https://poser.pugx.org/hpatoio/bitly-api/downloads.png)](https://packagist.org/packages/hpatoio/bitly-api)
[![Latest Stable Version](https://poser.pugx.org/hpatoio/bitly-api/v/stable.png)](https://packagist.org/packages/hpatoio/bitly-api)
[![SensioLabsInsight](https://insight.sensiolabs.com/projects/8d861d8b-3529-493d-b801-1a11a098492e/mini.png)](https://insight.sensiolabs.com/projects/8d861d8b-3529-493d-b801-1a11a098492e)

PHP Library based on Guzzle to consume Bit.ly API.

The biggest advantage in using Guzzle is that you can easely attach [Guzzle plugins](http://guzzle.readthedocs.org/en/latest/plugins/plugins-overview.html) to your client. [Here](#attach-guzzle-plugin), for example,you can see how to attach the log plugin and write all your requests to a file.

An [integration](#integrations) with Symfony2 is available as well.

## Versions

* branch `master` follows _psr4_ standards and get `2.x` tags
* branch `psr0` follows, of course, _psr0_ standards and get `1.x` tags - No new features only bugfix

This project follow [semantic versioning](http://semver.org/). 

## Installation

The recommended way to install this library is through Composer.
For information about Composer and how to install in [look here](http://getcomposer.org/doc/00-intro.md).

#### New project 

From the command line run 

```shell
./composer create-project hpatoio/bitly-api your_prj_dir '~2.0'
```

#### Existing project

Move into your project directory and run

```shell
./composer require hpatoio/bitly-api '~2.0'
```
or add to your `composer.json`
```json
{
    ...
    "require": {
        ...
        "hpatoio/bitly-api": "~2.0"
    }
}
```
and run 
```shell
./composer update
```

## Usage
```php
<?php

// This file is generated by Composer
require_once 'vendor/autoload.php';

# To find your bitly access token see here https://bitly.com/a/oauth_apps
$my_bitly = new \Hpatoio\Bitly\Client("insert_here_your_bitly_api_access_token");

$response = $my_bitly->Highvalue(array("limit" => 3));

print_r($response);

```
## cURL options

It might be that bit.ly is unreachable and you want to set a specific timeout.
Just set the cURL timeout options in the client:

```php

$my_bitly = new \Hpatoio\Bitly\Client("insert_here_your_bitly_api_access_token");
// set cURL timeout, you can specify any cURL options
$my_bitly->setConfig(array(
    'curl.options' => 
        array(
            CURLOPT_TIMEOUT => 2, 
            CURLOPT_CONNECTTIMEOUT => 2
        )
    ));

$response = $my_bitly->Highvalue(array("limit" => 3));

print_r($response);

```


## Methods names

To get the method name remove "v3" from the API url and camelize the other words removing the slashes.

Examples:

* /v3/highvalue -> Highvalue
* /v3/realtime/hot_phrases -> RealtimeHot_phrases
* /v3/link/content -> LinkContent

## Available methods
At the moment the library supports these APIs:

- [bitly Data APIs](http://dev.bitly.com/data_apis.html)
- [Links](http://dev.bitly.com/links.html)
- [Link Metrics](dev.bitly.com/link_metrics.html)
- [User Metrics](http://dev.bitly.com/user_metrics.html)

## [Behat](http://behat.org)
You need to copy Behat default configuration file and enter your ``access_token`` option there.
```bash
$ cp behat.yml.dist behat.yml
```
Now open `behat.yml` and change the string `your_bitly_access_token_here` with your access token.
Run the suite typing
```bash
$ bin/behat
```

## Integrations
A Symfony2 bundle that integrate this library is available [here](https://github.com/hpatoio/BitlyBundle)

## Attach Guzzle plugin

Here you can see how to attach Guzzle Log plug to your client and save all your requests to a file.

*NB:* To run this script you need `monolog/monolog`

```php
<?php
// This file is generated by Composer
require_once 'vendor/autoload.php';

use Guzzle\Log\MessageFormatter;
use Guzzle\Log\MonologLogAdapter;
use Guzzle\Plugin\Log\LogPlugin;
use Monolog\Handler\StreamHandler;
use Monolog\Logger;

$logger = new Logger('client');
$logger->pushHandler(new StreamHandler('/tmp/bitly_guzzle.log'));
$adapter = new MonologLogAdapter($logger);
$logPlugin = new LogPlugin($adapter, MessageFormatter::DEBUG_FORMAT);

# To find your bitly access token see here https://bitly.com/a/oauth_apps
$my_bitly = new \Hpatoio\Bitly\Client("your_bitly_access_token");
$my_bitly->addSubscriber($logPlugin);

$response = $my_bitly->Highvalue(array("limit" => 3));

print_r($response);
```

Now in `/tmp/bitly_guzzle.log` you can see all your requests.
