# 第七章 软件体系结构设计

## **1. 什么是软件体系结构？软件体系结构包括哪些设计视图？**

软件体系结构（architecture，也称“架构”）从高层抽象的角度刻画组成目标软件系统的设计元素（包括子系统、构件及类）以及它们之间的逻辑关联。软件体系结构从软件系统构成的角度，软件体系结构包括组件、连接件和约束(三大要素)，连接件表示组件之间的连接和交互关系，约束表示组件中的元素应满足的条件，以及组件经有连接件组装成更大模块时应满足的条件。

一个完整的软件体系结构应该包含以下视图：

逻辑视图：体系结构中各软件模块的逻辑功能划分（或曰职责分派），以及基于这种划分的协作行为。逻辑视图的UML图形机制主要是包图和构件图，有时还辅以类图。

开发视图：软件源代码的程序分包及目录结构，采用的类库、中间件或框架，它们与逻辑视图中各模块之间的映射关系。开发视图的表示可能会用到包图。

物理视图：安装部署的物理机器及其网络连接，逻辑视图及开发视图中模块或程序包的物理部署位置。物理视图表示为部署图。

运行视图：软件运行时进程、线程的划分，它们之间的并发与同步，瞬时快照——软件运行过程中某个特定时刻活跃的对象及其协作关系，以及它们与逻辑视图和开发视图之间的映射关系。运行视图表示为活动图与对象图。

数据视图：持久数据的存储方案，数据传递、备份、恢复、同步方案，与物理视图之间的映射关系。数据视图一般表示为类图或者实体-关系图。



## **2. 体系结构设计过程的主要活动有哪些？体系结构设计模式是什么？**

体系结构设计工作流

![](https://cdn.jsdelivr.net/gh/hongxiaCoder/Pictures@master/20230902201300.png)



体系结构设计模式指，以设计复用为目的，采用一种良好定义的、正规的、一致的方式记录的软件设计经验。每条模式关注在一般或特定设计环境中可能重复出现的设计问题，并给出经过充分实践考验的软件解决方案。



## **3. 通用的体系结构模式有哪三个，分别有什么含义？各有哪些正面和负面效应？**

通用的体系结构模式有分层、管道与过滤器、黑板3个通用的体系结构模式。

分层模式：该模式将软件系统按照抽象级别逐次递增或递减的顺序划分为若干层次，每层由一些抽象级别相同的构件组成。在严格的分层体系结构中，每层的构件仅为紧邻其上的抽象级别更高的层次提供服务，并且它们仅使用紧邻下层提供的服务。

管道与过滤器模式：将软件系统的功能实现为一系列处理步骤，每个步骤封装在一个过滤器构件中，相邻过滤器之间以管道连接，一个过滤器的输出数据借助管道流向后续过滤器，作为其输入数据。

黑板模式：将软件系统划分为黑板、知识源和控制器三类构件。黑板负责保存问题求解过程中的状态数据，并提供这些数据的读写服务；知识源负责根据黑板中存储的问题求解状态评价其自身的可应用性，进行部分问题求解工作，并将此工作的结果数据写入黑板；

控制器负责监视黑板中不断更新的状态数据，安排（多个）知识源的活动。



分层模式的正面效应：松耦合，通过层次划分和层间接口的规整，降低系统的耦合度，强化软件系统各模块之间依赖关系的局部化程度。可替换性，一个层次可以被实现了同样的对外服务接口的层次所替换。可复用性，具有良好定义的服务请求接口的层次可在不同的上下文环境中实现复用。标准化，可促进标准化构件和接口的开发。

分层模式的负面效应：性能开销：高层功能可能需逐层调用下层服务，返回值、报错信息又需逐级上传，比直接实现高层功能更耗时。如果低层服务还完成了最初的服务请求者所不需要的冗余功能，性能损耗会更严重



管道与过滤器模式的正面效应：可通过升级、更换部分过滤器构件以及处理步骤的重组来实现软件系统的扩展和进化。

管道与过滤器模式的负面效应：仅适用于批处理方式工作的软件，不适合于交互式、事件驱动式系统。



黑板模式的正面效应：可扩展，知识源和控制构件可灵活更换、升级，支持采用不同的知识源、不同的控制算法来试验各种问题求解方法。可复用，知识源之间没有互操作，知识源与控制构件和黑板之间均通过良好定义的接口进行交互，知识源的复用性较好。容错性和健壮性：知识源的每个问题求解动作都是探索性的，允许失败和试错

黑板模式的正面效应：问题求解性能较低，有时甚至无法预测求解时间。不能确保获得最优解。知识源和控制器两种模块的开发相当困难。问题求解路径不确定，造成软件测试困难。



## **4. 概念设计的作用是什么**

概念设计的主要目标是根据关键需求确定初始的软件体系结构雏形。

首先应该从软件需求模型中辨别出关键的软件需求项，然后再借鉴体系结构模式确定适合于实现这些需求项的体系结构雏形。



## 5. 何谓体系结构精化？  

体系结构精化的主要目标是，将概念体系结构精化成为全面的、设计适度的软件体系结构。软件体系结构一般包含逻辑、开发、运行、数据、物理五种视图。体系结构精化工作主要围绕这五种体系结构视图的精化或创立展开，重点是逻辑视图的精化。



## 6. 软件复用是什么?

软件复用是指在多次不同的软件开发过程中重复使用相同或相似软件元素的过程。软件元素包括源程序模块、目标代码模块、各类文档、测试用例甚至领域知识等。通常将这些可供复用的软件元素称为软部件。为便于复用，通常将可复用的软部件组织为软部件库。目前常见的软部件表现形式包括类和构件，它们对应的软部件库也就相应地称为类库和构件库。



## **7.  请描述MVC模式的结构、职责及运行流程。MVC模式有什么正面作用？**

MVC模式将系统划分为三类模块：模型（M）、视图（V）和控制器（C）。

模型的职责：存储业务数据并提供业务逻辑处理功能，一旦业务数据有变化，通知视图

视图的职责：呈现模型中的数据，在接获模型变化通知后从模型中获取新数据并更新视图，创建 (或绑定已存在的)控制器 ，初始化控制器，接受界面输入，转换为内部事件传递给控制器

控制器的职责：将来自视图的界面事件转换为对模型的业务逻辑处理请求，或者对视图的展示请求，在接获模型的业务逻辑处理结果后负责选择适当的视图作为软件系统对界面动作的响应。

MVC的运行流程如下：

创建视图，视图从模型中获取数据并呈现至界面

视图接受界面动作，将其转换为内部事件传递给控制器

控制器将界面事件转换为对模型的业务逻辑处理功能的调用

模型进行业务逻辑处理，完成后将结果回送给控制器，必要时将变化事件通知给所有现行视图

控制器根据模型的处理结果创建新的视图、选择其他视图或维持原有视图，传递处理结果给视图

所有视图在接获来自模型的变化通知后，向模型查询新的数据，并据此更新视图



正面效应：

将模型与视图分离以支持同一模型的多种呈现，界面的式样和观感可动态切换而不影响模型

将视图与控制器分离以支持在软件运行时根据业务逻辑处理结果选取最适当的视图

将模型与控制器分离以支持从界面动作到业务处理行为之间的映射的可配置性

模型与视图之间的变更—通知机制确保视图与业务数据的适时同步



## **8. 请描述发布—订阅模式的结构、职责。发布—订阅模式有什么正面作用？**

发布—订阅模式包含发布者和订阅者两个组件。

发布者的职责：接受订阅者的注册及撤销注册，一旦状态有变化，通知已注册的订阅者

订阅者的职责：向发布者注册 (不再感兴趣时撤销注册)，当状态变化事件到达时，处理该事件

正面效应：

从无目的的事件广播转变为定向事件通告，避免无效传播，降低性能开销

降低发布者、订阅者之间的耦合度

 

 