# 第六章 软件设计概论


## 1.什么是软件设计？

软件设计是针对需求工程给出的软件需求模型，综合考虑各种制约因素，探求切实可行的软件解决方案并最终给出方案的逻辑表示，这种表示称为设计模型。

软件设计的制约因素有资源和技术两个方面。资源制约因素是指在目标软件开发过程中可以获取的时间、人力、财力和开发辅助工具等；技术制约因素主要是指待开发目标软件系统可以使用的技术平台。



## **2. 典型的软件设计模型包括哪些内容？设计模型的质量要素有哪几个方面？**

典型的软件设计模型一般包括体系结构模型、用户界面模型、用例设计模型、数据模型、子系统/构件/类设计模型。

软件设计的目标是构建高质量的设计模型。设计模型的质量要素为正确性、充分性、优化性和简单性4个方面。



## **3. 软件设计的基本原则有哪些，各包括什么含义？**

软件设计原则包括： 抽象与逐步求精、强内聚及松耦合、信息隐藏及关注点分离。

1）抽象与逐步求精原则。软件设计的抽象原则指，软件设计一般要自顶向下地经历一系列抽象级别从高到低的设计阶段，后续阶段会在前一阶段的基础上引进更接近于软件实现的设计元素，这一过程称为“逐步求精”。

2）强内聚及松耦合原则(模块化)。强内聚要求一个软件模块由逻辑相关性很强的代码组成，仅负责单项职责，这与通常所说的单一职责原则相吻合；松耦合要求软件系统中各模块尽可能独立地完成各自的职责，模块之间的接口尽可能少而且简单。

3）信息隐藏原则。模块应该设计得使其所含信息（过程和数据）对于那些不需要这些信息的模块不可访问，模块之间仅交换那些为完成系统功能必须交换的信息。信息隐藏有助于强化模块独立性，消除模块之间不必要的依赖关系，从而支持强内聚、松耦合原则的实现。

4）关注点分离原则。关注点是指问题求解者针对概念、任务或目标的某个部分或侧面的聚焦。关注点分离原则要求设计师将若干性质不同的关注点分离开来，以便软件开发者能够在适当的时间分别处理不同的关注点，此后将这些关注点的实现整合起来，形成局部或者全局性的软件解。

抽象与逐步求精、模块化都是关注点分离原则的具体应用：前者分离“结构”和“细节”两类关注点，后者分离职责型或功能型关注点（即，每个模块代表一个职责或功能关注点）。可以沿“职责划分”、“结构－细节”及“通用－专用”三个维度来分离关注点。在具体的软件设计工作中，必须综合采用这些维度上的关注点分离方法。



## **4. 软件设计过程模型一般包括哪些活动？**

![](https://cdn.jsdelivr.net/gh/hongxiaCoder/Pictures@master/20230902201248.png)



## **5. 内聚度的表现形式有哪些？**

内聚度表示一个模块内部各成分彼此关联的紧密程度。其表现形式有：

⑴偶然性内聚(Coincidental Cohesion)：

模块内各成分为完成一组功能而组合在一起，它们相互之间即使有关系，也很松散。

⑵逻辑性内聚(Logical Cohesion)：

模块完成多项功能，这些功能在逻辑上具有某种相关性。

⑶时间性内聚(Temporal Cohesion)：

模块完成的诸任务必须在同一时间段内执行。

⑷过程性内聚(Procedural Cohesion)：

在逻辑性内聚的基础上，进一步要求模块内各功能必须按特定的次序执行。

⑸通信性内聚(Communicational Cohesion)：

模块中各成份对数据结构的同一区域进行操作，以达到通信的目的。

例如，如果类中若干方法（操作）对类中的相同属性数据施加操作，那么此类的内聚度至少在通信性内聚（含）以上。

⑹顺序性内聚(Sequential Cohesion)：

模块内各处理成份均与同一功能相关，且这些处理必须依序执行。

⑺功能性内聚(Functional Cohesion)：

模块内各成份协同完成单一功能。



## **6. 耦合度的表现形式有哪些？**

耦合度是指软件结构中多个模块之间的关联程度。其表现形式包括：

⑴非直接耦合（Nodirect Coupling）：两模块中任意一个都不依赖另一个而独立工作。

⑵数据耦合（Data Coupling）如果两模块通过参数交换信息，这些信息仅参与计算而不影响模块的功能或执行路径，则称这两个模块为数据耦合；

⑶控制耦合（Control Coupling）：如果模块间交换的参数会因为取值的不同而导致模块功能或执行路径的变化，则称它们为控制耦合。

⑷ 外部耦合（External Coupling）：

当若干模块均与同一外部设备或外部环境相关联（例如，I/O处理使所有I/O模块与特定的设备、格式和通信协议相关联），这些模块之间便存在外部耦合。

⑸ 公共耦合（Common Coupling）：

当若干模块通过公共的数据环境相互作用时，它们之间即存在公共耦合。



## **7. 强内聚、松耦合原则带来哪些优点？**

⑴强内聚和松耦合有利于促进软件系统的结构简单化、清晰化，从而强化软件设计模型的简单性。

⑵强内聚有利于软件模块的可复用性，因为模块的功能越单纯，其复用潜力往往越大；

⑶松耦合有利于软件系统的可修改性和可维护性，因为模块之间少而且有助于简化修改，影响传播范围的分析，有助于缩小传播范围；

⑷强内聚和松耦合还能够更好地支持模块的并行开发，因为前者保证每个模块的功能相对单纯，后者在编码、调试、测试阶段可以减少模块之间相互制约的情况。

 
