# 第五章 需求分析与验证

## **1. 交互图的作用？**

交互图描述一组对象通过消息传递而形成的协作行为。交互图经常用于描述单个用例功能的实现方式，或者软件系统在某种给定的使用场景下对象之间的交互协作流程，或者软件系统的某个复杂操作的逻辑实现模型。交互图包括顺序图和通信图两种，前者强调消息传递的时间序，后者突出交换消息的对象之间的合作关系。



## **2. 用例驱动的需求分析过程的主要活动包括哪几个步骤。**

\1) 需求优先级分析 2）用例分析 3）分析模型评审 4）为辅助需求分析而构建快速原型。

![](https://cdn.jsdelivr.net/gh/hongxiaCoder/Pictures@master/20230902201233.png)





## **3. 需求优先级分析的主要任务是什么？对需求优先级的含义有哪三种不同的诠释方法。**

**需求优先级取决于哪三个因素的综合作用，优先级的计算公式又会什么样？**

需求优先级分析的主要任务是为每项需求确定优先级，根据优先级可以安排待分析用例的优先次序。

需求优先级三种不同的诠释方法：⑴基于实现紧迫度的优先级：

高优先级表示在当前软件版本中必须实现的需求项；

中优先级表示最终必须实现的需求项，但在资源紧张时可以延至下一软件版本再实现；

低优先级表示“锦上添花”式的需求项，在资源充分时其实现会使软件产品更趋于完美。

⑵基于产品可接受度的优先级：

基本需求项表示软件产品为利益相关方接受所必需的需求项；

条件需求项表示可以增强其满意度的需求项，但是，即使不予实现，利益相关方仍可接受该软件产品；

可选需求项类似于条件需求项，其对软件产品的可接受度的影响更弱。

⑶基于需求实现度的优先级：

高优先级表示在当前软件版本中必须完整并尽可能完美实现的需求项；

中优先级表示在资源紧张时可有小部分不予实现的需求项，并且其实现允许出现无关紧要的瑕疵；

低优先级表示可以有部分甚至完全不予实现的需求项，其实现允许出现缺陷。

需求优先级取决于三个因素的综合作用：

需求项为利益相关方提供的价值、需求项的实现成本及实现过程中的风险。

可以将这些因素量化为若干级别，然后采用某种计算公式获得需求优先级排序，再结合项目可用资源约束，按照前述定义划分需求项的优先类别。

优先级计算公式：

优先级＝价值/(成本×成本权值＋风险×风险权值)



## **4. 用例分析的子活动包括哪几种活动？分析类的作用是什么，又有哪三种类型的分析类。**

用例分析的子活动归纳如下：

⑴精化领域概念模型；⑵设置分析类；⑶构思分析类之间协作关系(顺序图)；⑷导出分析类图。

分析类是指直接服务于软件的功能性需求的概念层面的类，它与待开发软件系统的具体实现技术无关。

从功能需求的角度看，用例的业务逻辑处理功能主要由边界类、控制类和实体类三种分析类协同完成。

边界类负责目标软件系统与外部执行者之间的交互，包括：

⑴界面控制⑵外部接口⑶环境隔离

控制类作为完成用例任务的责任承担者，负责协调、控制其他类共同完成用例规定的功能或行为。

实体类负责保存目标软件系统中具有持久意义的信息项并向其他类提供信息访问的操作。



## **5. 将用例表示为顺序图的基本思路？**

1）以“边界类”对象负责接收来自主动执行者（active actors）的消息

2）边界类对象向用例任务的主要承担者“控制类”对象发送命令

3）控制类对象独立完成命令要求的功能，或者分派子功能给其他对象

4）控制类对象综合处理结果，将最终结果发给负责与被动执行者交互的边界类对象



## **6. 顺序图中的消息分为哪两种？有什么区别？**

顺序图中的消息分为同步消息和异步消息

同步消息的发送者等待消息的接收方将消息处理任务完成后再继续自身任务，异步消息发送者在发送完消息后不等待接收方返回结果即继续自身任务。

 
