# 第十一章 软件测试

## 1. 软件测试的概念 

软件测试[IEEE软件工程标准术语， 1983]

使用人工或自动手段运行软件系统的过程，目的在于检验系统是否满足规定的需求，或确定预期结果与实际结果之间的差异.



## **2. 测试用例**

程序运行需要输入数据,为测试设计的输入数据称测试用例。

测试用例针对程序的某一功能或运行路径设计的，生成输入数据是关键。

测试用例包括程序执行条件、测试步骤和预期的输出，用于核实程序或指定路径是否满足预期目标。



## **3. 黑盒测试和白盒测试**

黑盒测试不考虑程序的内部结构和处理过程。通过程序运行，验证程序是否实现测试用例的场景。

白盒测试密切关注程序的运行细节,针对程序的每一条逻辑路径分别设计测试用例,检查分支和循环的执行状况。

白盒测试的技术：基本路径测试、控制结构测试、数据流测试、循环测试



## **4. 软件测试的过程**

软件工程的开发过程和测试过程应该是对应的。

![](https://cdn.jsdelivr.net/gh/hongxiaCoder/Pictures@master/20230902201324.png)

在软件项目初期，需要制订软件测试计划，以描述将要进行的软件测试活动、时间、人员、资源、工具环境等方面的内容；

当软件需求规约完成后，需要对需求进行测试（审查）；

而在软件设计规约完成后，同样需要对软件设计进行测试（审查）；

在软件实现后，需要对代码进行单元测试、集成测试，并在软件系统形成后，针对需求进行确认测试。

在对软件实现进行测试发现软件失效后，需要对软件进行调试，以发现问题的原因，并进行修复。

对代码修改后，还需要进行回归测试，以确定缺陷被修复且没有引入新的缺陷。

测试完成后，将对测试过程和结果进行评价，当认为测试已经达到预期的目标时，可以结束测试活动并交付软件制品。



## **5. 软件测试活动及实施策略**

测试策略应包含测试规划、测试用例设计、测试实施和测试结果收集评估等。

***\*单元测试\****的对象是软件设计的最小单位——模块。单元测试的依据是详细设计描述，单元测试应对模块内所有重要的控制路径设计测试用例,以便发现模块内部的缺陷。单元测试多采用白盒测试技术,系统内多个模块可以并行地进行测试。

***\*集成测试\****是组装软件的系统测试技术,按设计要求把通过单元测试的各个模块组装在一起之后,进行集成测试以便发现与接口有关的各种缺陷。增量式集成方法：自顶向下集成，自底向上集成。集成测试文档。

***\*确认测试\****应检查软件能否按合同要求进行工作,即是否满足软件需求说明书中的确认标准。实现软件确认要通过一系列黑盒测试。确认测试需要制订测试计划和过程。测试计划应规定测试的种类和测试进度。测试过程则定义一些特殊的测试用例,旨在说明软件与需求是否一致。α、β测试。

***\*系统测试\****应由若干不同测试组成，充分运行系统，验证系统各部件是否正常工作，完成赋予的任务。恢复测试主要检查系统的容错能力。当系统出错时，能否在指定的时间间隔内修正缺陷并重新启动系统。恢复测试首先要采用各种办法强迫系统失败，然后验证系统是否能尽快恢复。安全测试用来验证集成在系统内的保护机制是否能够在实际中保护系统不受到非法的侵入。强度测试检查程序对异常情况的抵抗能力。强度测试总是迫使系统在异常的资源配置下 运行。

性能测试只有当系统真正集成之后，在真实环境中才能全面、可靠地测试运行性能，系统性能测试是为了完成这一任务。性能测试有时与强度测试相结合，经常需要其他软、硬件的配套支持。



## **6. 什么是驱动模块？什么是桩模块？驱动模块和桩模块会在哪些测试环节用到？**

驱动模块：接收测试数据并将这些数据传递给被测模块，调用补测模块后，记录测试结果。

桩模块：替代被测模块所调用的模块，其接口与被替代的模块一致，但内部实现只做少量数据处理。

驱动模块和桩模块会在单元测试和集成测试环节用到。



## **7. 系统测试**

恢复测试、安全测试、强度测试、性能测试的概念。

 
