---
title: 操作系统经典问题
date: 2023/08/29
---

::: tip 介绍
这一篇文章总结了操作系统中常见的经典问题，举出了典型的例题并作出分析和解答。掌握这些经典问题，将对操作系统中的知识有更深刻的理解，
足以应对面试、考试。
:::

## 1.进程调度算法比较

已知系统上运行若干进程及各自的到达时间和服务时间。要求根据相应的进程调度算法求出各进程的执行顺序，平均周转时间和平均带权周转时间。参与比较的算法是：

① 先来先服务算法

② 最短作业优先算法

③ 最高响应比优先算法

④ 静态优先级调度算法

**注意：**

周转时间 = 结束时间 - 到达时间 = 等待时间 + 服务时间

带权周转时间 = 周转时间 / 服务时间

优先级R = （等待时间 + 服务时间）/ 服务时间 = 响应时间 / 服务时间

响应时间 = 结束时间 - 到达时间

（平均周转时间 = 作业周转总时间 / 作业个数）

### 例题

先根据算法思想，结合进程到达时间，确定进程执行顺序，计算每个进程的结束时间。最后再计算每个进程的周转时间和平均周转时间就很简单了。

高响应比中的优先级计算中，等待时间 = 此刻时间 - 到达时间，每一次调度都需要重新计算优先级（因为每一次调度的时间不同）

## 2.银行家算法

银行家算法（Banker's Algorithm）是一种用于避免死锁（Deadlock）的资源分配算法。

核心思想是：在为进程分配资源之前，模拟分配过程，判断该分配是否会导致系统进入不安全状态（即可能发生死锁）。如果分配资源后系统仍然处于安全状态，则允许分配；否则，推迟分配直到安全状态。

为了实现银行家算法，每个进程在进入系统时，都必须申明在运行过程中可能需要的每种资源类型的最大数目。

### 例题

> 设系统中有若干种类的资源和若干数量的进程，且各类资源数量已知。若系统采用了银行家算法，试回答某时刻系统是否处于安全状态。进程申请资源的行为，是否能实施并简述理由。

当前系统资源分配情况如下表所示，还剩余资源(1,6,2,2)，根据银行算法判断该状态是否为安全状态。若进程P2提出请求(1.2,2,2)，系统是否应该分配？

| 进程 | 资源分配Allocation | 资源需求MAX |
| ---- | :----------------- | ----------- |
| P0   | 0 0 3 2            | 0 0 1 2     |
| P1   | 1 0 0 0            | 1 7 5 0     |
| P2   | 1 3 5 4            | 2 3 5 6     |
| P3   | 0 3 3 2            | 0 6 5 2     |
| P4   | 0 0 1 4            | 0 6 5 6     |

### 分析

**注意：**

- 表格中的**资源分配**表示的是已经分配给该进程的资源，比如（0 0 3 2）表示已分配给进程P0第一种资源0个，第二种资源0个，第三种资源3个，第四种资源2个
- 表格中的**资源需求**表示该进程所需要的每种资源的最大数目
- 每当一个进程获得所需的所有资源，执行完毕后就会释放该进程所有资源。即该进程获得的所有资源归还给系统

如何判断该状态是否为安全状态？

若存在一种安全序列，则为安全状态，不存在安全序列则不为安全状态。

所谓安全状态，是系统能按某种进程推进顺序，为每个进程Pi分配其所需要的资源，直至满足每个进程对资源的最大需求，这样的状态就是安全状态。进程的执行顺序就是安全序列。

### 解题

(1)

实际上就是判断系统资源是否能满足进程的资源需求，我们可以先算出每个进程仍需要的资源

| 进程 | 资源分配Allocation | 资源需求Max | 仍需资源Need |
| ---- | :----------------- | ----------- | ------------ |
| P0   | 0 0 3 2            | 0 0 1 2     | 0 0 0 0      |
| P1   | 1 0 0 0            | 1 7 5 0     | 0 7 5 0      |
| P2   | 1 3 5 4            | 2 3 5 6     | 1 0 0 2      |
| P3   | 0 3 3 2            | 0 6 5 2     | 0 3 2 0      |
| P4   | 0 0 1 4            | 0 6 5 6     | 0 6 4 0      |

我们可以采用下面的表格形式来进行判断（当然你也可以使用别的计算形式，个人认为表格更直观一些）

| 安全序列       | P0      | P3      | P4       | P1       | P2         |
| -------------- | ------- | ------- | -------- | -------- | ---------- |
| 分配后系统资源 | 1 6 2 2 | 1 3 3 4 | 1 3 4 4  | 1 2 4 10 | 1 9 9 8    |
| 进程占用资源   | 0 0 3 2 | 0 6 5 2 | 0 6 5 6  | 1 7 5 0  | 2 3 5 6    |
| 归还后系统资源 | 1 6 5 4 | 1 9 8 6 | 1 9 9 10 | 2 9 9 10 | 3 12 14 14 |

最后我们可以得出一种安全序列P0,P3,P4,P1,P2。（安全序列不唯一）

(2)

将（1,6,2,2）的系统资源分配给P2的请求资源（1,2,2,2）后，剩余系统资源（0,4,0,0）不能满足其他进程的需求，会使得系统陷入不安全状态，所以不应分配。

## 3.分段/页存储管理的地址转换

在分段/页存储管理系统中，逻辑地址形式表述为（段/页号，段/页内地址）。已知系统的段/页表包含...，要求根据段/页表的内容完成逻辑地址到物理地址的转换。

### 例题

已知页面大小1024，某进程占了3个页面。页面分别对应页帧4,6,7。问逻辑地址1500（十进制），3090（十进制），0x404（十六进制）对应的物理地址是多少。

### 分析

分页存储管理中，将进程的地址空间分为若干页，并为每一个页面加以编号。相应的，也把内存空间分为若干块，并加以编号，称为物理块号，页帧。3个页面页号分别是0，1，2，分别对应着页帧4，6，7。（页号从0开始）。

所以需要计算逻辑地址在哪一个页面中，根据页号与物理块号（页帧）的对应，计算得出物理地址

![页表](https://cdn.jsdelivr.net/gh/hongxiaCoder/Pictures@master/20230901161515.png)

### 解题

（1）对于逻辑地址1500，页大小为1024，所以页号为1500 / 1024 = 1，对应页帧6，页面偏移量为 1500 % 1024 = 476，故物理地址为6 × 1024 + 476 = 6620

（2）对于逻辑地址3090，页大小为1024，所以页号为3090/1024 = 3，大于该进程的最大页号2，所以该逻辑地址不在该进程所在页，无法得知物理地址

（3）对于逻辑地址0x404，转化成十进制为1024（4×16^0 + 4×16^2 = 1024），所以页号为1024 / 1024 = 1，对应页帧4，页面偏移量为1024 % 1024 = 0，故物理地址为4 × 1024 = 4096

## 4.基于快表的内存有效访问时间

在分页存储管理的前提下，已知快表和内存的单次访问时间以及快表命中率，求内存的有效访问时间。

EAT = a × λ + （1 - a）×（λ + t）+ t

EAT：内存有效访问时间

a：命中率

λ：块表单次访问时间

t：内存单次访问时间

### 解析

内存有效访问时间，指从进程发出指定逻辑地址的访问请求，经地址变换，到内存中找到对应的实际物理地址单元并取出数据，这一过程所花费的时间。

在没有快表的情况下，需要两次访问内存。第一次访问内存中的页表获取对应物理块号，第二次访问内存是根据物理页框号和页内偏移量来计算最终的物理地址。所以EAT = t + t = 2t

引入了快表（也称联想寄存器）之后，直接去快表中匹配页号获取对应物理块号，若命中则可以省去一次访问内存时间，若没有命中还是要去访问内存中的页表获取对应物理块号。所以EAT = a × λ + （1 - λ）×（λ + t）+ t

## 5. 页面置换算法比较

系统为进程提供一定数量的页帧，且已知进程在运行过程中访问页面的序列。要求根据相应的置换算法，列出页面淘汰顺序并统计页面置换次数、缺页次数、缺页率指标。参与比较的算法是：

① 最佳置换算法

② 先进先出算法

③ 最近最久未使用算法

缺页次数=置换次数+页帧数，缺页率=缺页次数/访问序列长度。

## 6.阅览室登记（进程同步问题）

::: tip 知识补充
在信号量的上下文中，P（操作）和V（操作）是常用的术语，用于对信号量进行操作。

P 操作（也称为 down 操作、acquire 操作或 wait 操作）用于申请资源或进入临界区。它执行以下步骤：

1. 检查信号量的值。
2. 如果信号量的值大于 0，则将其减 1，并继续执行。
3. 如果信号量的值为 0，则进程或线程将被阻塞，直到信号量的值大于 0。

V 操作（也称为 up 操作、release 操作或 signal 操作）用于释放资源或离开临界区。它执行以下步骤：

1. 将信号量的值加 1。
2. 如果有其他进程或线程正在等待该信号量，则其中一个等待的进程或线程将被唤醒。
:::
1.有一阅览室，共有200个座位，读者进入时必须现在一张登记表上登记，改表位每一座位列一表项，包括读者名和座号等，读者离开时，要消掉登记信息，试问：

(1) 编写一个程序，设置几个进程？

(2) 用PV操作描述。

解：分析：类似于消费者生产者问题，座位相当于缓冲单元，登记表类似产品，读者进入时占一个座位和离开时腾出一个座位，这两件事（两个进程）应该要同步，做两件事因此需设置两个进程，登记表作为临界资源，被互斥使用。（纯属个人见解）

（1）需要两个进程

 (2)

```
Semaphore  seats=200,left=0,mutex=1;

Procedure A{ //进入阅览室阅读

  While (1){

		P(seats);  //申请座位

		P(mutex);  //占用登记表

		填写登记表；

		V（mutex）;

		开始读书；

		V（left）; // 读完离开，唤醒离开的进程B

	}

}

 

Procedure B{//离开阅览室

	While (1){

		P(left);  

		P(mutex);

        撤销登记；

		V(mutex);

		V(seats);  //腾出座位

	}

}
```

## 7.公交车行驶（进程同步问题）

设公共汽车上，司机和售票员的活动分别是：

 司机：启动车辆，正常行驶，到站停车

售票员：上下乘客，开关车门，售票。

在汽车不断地到站，停车，行使过程中，这两个活动有什么同步关系？并用 wait和signal 原语操作实现它们的同步。

```
sempahore stop = 0, run = 0;

Driver(){//司机
	wait(run);
	启动车辆；
	正常行驶；
	到站停车；
	signal(stop);

}

Conductot(){//售票员
	wait(stop);
	开车门；
	下乘客；
	上乘客；
	关车门；
	售票；
	signal(run);
}
```

## 8.打印机问题（进程同步问题）

系统运行有三个进程：输入进程、计算进程和打印进程，它们协同完成工作。

输入进程和计算进程之间共用缓冲区buffer1,计算进程和打印进程之间共用缓冲区buffer2。

输入进程接收外部数据放入buffer1中；计算进程从buffer1中取出数据进行计算，然后将结果放入buffer2；打印进程从buffer2取出数据打印输出。

用算法描述这三个进程的工作情况，并用wait和signal原语实现其同步操作。（共8分）

解：（共8分）

解答：输入进程、计算进程和打印进程之间的同步问题描述如下：

```
var: mutex1, mutex2, empty1, empty2, full1, full2 := 1, 1, 1, 1, 0, 0;

InP:（输入进程）
begin
  repeat
    wait(empty1);
    wait(mutex1);
    input a data from keyboard;
    Add to buffer1;
    signal(mutex1);
    signal(full1);
  until false
end

CalP:（计算进程）
begin
  repeat
    wait(full1);
    wait(mutex1);
    Take a data from buffer1;
    Add to ch1;
    signal(mutex1);
    signal(empty1);
    calculate ch1;
    wait(empty2);
    wait(mutex2);
    Take a data from ch1;
    Add to buffer2;
    signal(mutex2);
    signal(full2);
  until false
end

OutP:（输出进程）
begin
  repeat
    wait(full2);
    wait(mutex2);
    Take a data from buffer2;
    Add to printer controler;
    signal(mutex2);
    signal(empty2);
    start printer;
  until false
end

```



## 9.信号量问题

### 信号量实现互斥

```
semaphore mutex = 1;
PA(){
	while(1){
		wait(mutex);//加锁
		临界区;
		signal(mutex);//释放锁
	}
}
PB(){
	while(1){
		wait(mutex);
		临界区;
		signal(mutex);
	}
}
```

### 信号量实现同步

设S为同步型信号量，初值为0。C1,C2表示两段代码

```
semaphore S = 0;
PA(){
	while(1){
		C1;
		signal(S);
		...
	}
}
PB(){
	while(1){
		wait(S);
		C2;
		...
	}
}
```

### 信号量解决生产者消费者问题

假设生产者和消费者之间的公用缓冲区中，具有n个缓冲区。

利用信号量empty和full分别表示缓冲区中空缓冲区和满缓冲区的数量

```
sempahore mutex = 1, empty = n, full = 0;
Producer(){
	while(1){
		生产东西；
		wait(empty);
		wait(mutex);
		往缓冲区中放东西；
		signal(mutex);
		signal(full);
	}
}
Consumer(){
	while(1){
		wait(full);
		wait(mutex);
		从缓冲区中取东西;
		signal(mutex);
		signal(empty);
	}
}
```

