---
title: 存储器管理
date: 2023/08/23

---

# 存储器管理

## 存储器的层次结构

对于通用的计算机，存储层次至少应具有3层：最高层为CPU寄存器，中间层为主存储器，最低层为辅助存储器（简称辅存）。

对于较高档的计算机，存储层次可细分为：寄存器，高速缓存，主存储器，磁盘缓存，固定磁盘，可移动存储介质。层级越高，存储介质的访问速度越快，存储容量越小，价格也越高。

![存储器结构](https://cdn.jsdelivr.net/gh/hongxiaCoder/Pictures@master/20230901160254.png)

### 寄存器

由于内存的访问速度远低于CPU执行指令的速度，为了缓解内存访问速度与CPU执行速度不匹配这一矛盾，引入了寄存器。

寄存器是CPU内部的一种告诉存储器，用于暂时存放参与运算的指令，数据和运算结果等内容，因为与CPU的运算单元相连，所以寄存器的访问速度远快于主存储器。

### 高速缓存

为了缓和内存与CPU速度之间的矛盾，引入了高速缓存。

它是介于寄存器和内存之间的存储器，主要用于备份内存中较常用的数据，以减少处理机对内存的访问次数。通常，进程的程序和数据存放在内存中，每当要访问他们时，才会被临时复制到一个速度较快的高速缓存中。

### 主存储器

主存储器（Main Memory），简称主存或内存，也称为随机访问存储器（RAM），是计算机系统中的主要部件，用于保存进程运行时的程序和数据。通常由许多存储单元组成，每个存储单元都有唯一的地址。这些存储单元按字节（Byte）进行编址，每个字节都有一个唯一的地址，可以被读取或写入数据。

### 磁盘缓存

为了缓和内存和磁盘速度之间的矛盾，引入了磁盘缓存。

磁盘缓存和高速缓存不同，它本身并不是一种实际存在的存储器，而是利用内存中的部分存储空间，暂时存放从磁盘中读出或写入的信息。

## 进程运行的基本过程

一个用户程序要运行，需要将其装入内存中，然后将其转变成一个可执行的程序，一般需要经过三个步骤：编译->链接->装入。

编译器将源程序进行编译，形成若干模块，随后经过链接程序，将这些模块和运行所需要的库函数链接在一起，形成装入模块，最后通过装入程序将他们装入内存中。
![进程运行过程](https://cdn.jsdelivr.net/gh/hongxiaCoder/Pictures@master/20230901160314.png)

### 链接

分为静态链接、装入时动态链接、运行时动态链接

- 静态链接：编译器事先将程序所需的**所有**代码和库函数链接成一个装入模块，在运行时无需依赖于外部的库文件

- 装入时动态链接：采用边装入边链接的形式，即在**装入时**，若该模块中发生另一个外部模块调用事件，则装入程序会找出该外部模块，也把它装入到内存中。

- 运行时动态链接：一开始只链接和装入部分目标模块，当程序**运行时**发现需要其他模块时，再进行链接和装入（加快程序装入过程，节省内存空间）

| 分类 | 静态链接                                                     | 装入时动态链接                               | 运行时动态链接                                 |
| ---- | ------------------------------------------------------------ | -------------------------------------------- | ---------------------------------------------- |
| 特点 | 直接将所有代码和库函数链接形成一个装配模块，不再拆开         | 装入时根据模块调用事件找出并装入相应外部模块 | 对某些模块的链接推迟到程序执行时才进行         |
| 优点 | 程序运行时，不依赖外部的库文件，可以独立地在目标系统上运行。具有独立性和可移植性。 | 各目标模块分开存放，便于修改和更新目标模块   | 加快程序装入过程，可节省大量内存空间           |
| 缺点 | 可执行文件较大，占用更多存储空间。                           | 可能增加启动时间和管理工作                   | 当找不到额外的库函数时，需要额外的开销进行加载 |

### 装入

分为绝对装入、可重定位装入、动态运行时装入

- 绝对装入：程序被加载到内存的固定位置。程序的指令和数据的物理地址在编译和链接时就已经确定，并且在装入时不会发生重定位。
- 可重定位装入：允许程序被加载到内存的任意位置。在装入时，需要进行符号解析和重定位，将程序中的符号引用映射到实际的内存地址。
- 动态运行时装入：把相对地址转化为绝对地址的过程推迟到进程真正要执行的时候，而不是装入内存就变化，因此可以允许程序在运行时移动位置。

### 逻辑地址和物理地址

- 逻辑地址（相对地址）：指CPU生成的地址，是相对于进程而言的虚拟地址，一般从0开始

- 物理地址（绝对地址）：程序装入内存中，在内存中的实际的物理位置，处理器能够直接访问内存单元的地址

逻辑地址是相对于进程而言的，而物理地址是相对于计算机系统的物理内存而言的。逻辑地址一般由操作系统的内存管理单元(MMU)进行翻译，将其转化为物理地址。

### 地址绑定

在处理用户程序的三个步骤中（编译，链接，装入），每个步骤的地址可能有着不同的地址形式。地址绑定是指将程序中使用的逻辑地址（或虚拟地址）映射到计算机实际物理内存中的物理地址的过程。

### 内存保护

内存保护指的是两个方面

1. 保护OS内存空间不被用户访问
2. 保护进程所具有的独立内存空间，确保进程间不会相互影响。即一个进程只能访问合法的内存地址范围，而不能访问OS内存地址或其他用户进程内存地址。

内存保护通过CPU硬件实现。可以通过两个寄存器分别记录该进程在内存中的**起始物理地址**和该程序在内存中所需要的**大小**，即基地址寄存器和界限寄存器，此时该进程的合法地址范围就是（基地址，基地址+界限地址）区间，如果该进程访问合法地址以外的范围，就会陷入OS内核，而OS内核则会将其作为致命错误来处理。

## 2.内存扩充

当内存空间不足或者进程所需的空间大于系统能够提供的，系统应该如何处理？一是拒绝该进程的运行请求，二是使用内存扩充技术。

所谓内存扩充，**并不是增加系统的物理内存，而是指扩大内存的使用效率**。常用的内存扩充技术，包括交换，覆盖，紧凑，虚拟存储器等。

### 交换（对换）

指将内存中暂时不能运行的进程或暂时不用的程序和数据，转移到外存；再把已具备运行条件的进程或需要的程序和数据从外存装入内存中。

- 选择被换出进程：当内核执行某项操作时发现空间不足时，就换调用对换进程。在选择时，对换进程会检查所有驻留在内存中的进程，**首先选择**处于“阻塞”状态或者“睡眠”状态的进程，当有多个这样的进程时，优先选择优先级最低的。**如果没有**阻塞进程，就会选择优先级最低的就绪进程。
- 换出进程：在换出时，**首先**申请对换区，申请成功后将该进程的程序和数据传送到磁盘的对换区，**然后**回收该进程所占用的内存空间，**最后**对该进程的PCB和内存分配表等数据结构进行相应的修改。需注意的是，在对进程进行换出时，只能换出非共享的程序和数据段，对于共享的程序和数据段，只要有其他进程需要它，就不能被换出。
- 换入进程：在换入时，对换进程**首先**检查PCB集合中所有进程状态，找出处于“就绪”状态但已被换出的进程。当有多个这样的进程时，优先选择换出时间最久的。**然后**为它申请内存空间，便可直接将进程从外存换入内存。

![对换示意图](https://cdn.jsdelivr.net/gh/hongxiaCoder/Pictures@master/20230901160337.png)

### 覆盖

指在程序的执行过程中，根据需要加载不同的覆盖块到内存中，程序的不同部分相互替换。

在早期的计算机系统中，有限的内存无法装入整个程序，便将程序分割成多个部分（称为覆盖块或覆盖段），常用的部分常驻内存，不常用的根据需要再调入内存。

举个例子：

某程序由符号表（20KB）、公共例程（30KB）、分枝1（70KB）、分枝2（80KB）组成。如果只有150KB的内存空间，是无法将整个程序（200KB）装入内存的。因为分枝1和分枝2不会同时执行，所以两个分枝不必同时位于内存，可以使两个分枝共享一块存储区域，根据实际需要对这块共享存储区的内容进行替换。需要注意的是，使用覆盖技术须增加覆盖驱动程序（假设10KB），共享的存储区域为了能容纳分枝1和分枝2着两段代码，容量应该选择较大的那个，即分枝2的80KB。

![覆盖](https://cdn.jsdelivr.net/gh/hongxiaCoder/Pictures@master/20230901160357.png)

### 紧凑

当一台计算机运行了一段时间后，它的内存空间会被分割成许多小分区，而缺乏大的空闲空闲。即使这些小分区的容量总和大于要装入的程序，但因为这些小分区不连续、不相邻，所以程序无法被装入。

为了解决这一问题，我们可以通过移动内存中其他作业的位置，把原来分散的小分区拼接成一个大分区，这种方法就成为”紧凑“。

虽然思路简单，但会带来以下问题：

1. 数据搬移开销：需要移动大量的用户程序和数据，可能需要调整指针和更新相关数据结构，这些数据搬移的操作会消耗大量的时间和计算资源。
2. 系统暂停时间增加：通常需要暂停正在运行的进程或任务，以便进行数据搬移和内存重组。在这段时间内，进程无法执行任何操作，可能会导致系统响应变慢或出现停顿，对实时性要求较高的应用可能会受到影响。
3. 额外复杂性：需要对内存分配器和数据结构进行复杂的管理和维护。为了实现高效的紧凑操作，需要设计和实现一些算法和策略，以便选择合适的时机和方式来进行紧凑。这增加了内存管理的复杂性。

（所以，紧凑技术通过移动其他作业的位置，将多个小分区拼接成一个大的分区，使得内存能够连续分配，能够消除或减少内存碎片化，提高内存空间的使用效率。）

![紧凑前后](https://cdn.jsdelivr.net/gh/hongxiaCoder/Pictures@master/20230901160418.png)

|      | 特点                                                       | 区别                     |
| ---- | ---------------------------------------------------------- | ------------------------ |
| 交换 | 将不需要的程序从内存转移到外存；将需要的程序从外存装入内存 | 在不同进程或程序之间进行 |
| 覆盖 | 根据需要，程序的不同部分相互替换                           | 用于同一进程或程序       |



## 内存管理方式

为了能将用户程序装入内存，则需要为程序分配一定大小的内存空间。那么系统是如何对内存进行划分以及管理的呢？

### 1.连续分配存储管理方式

连续分配方式指的是为一个用户程序分配一个连续的内存空间，即程序中的代码或数据的逻辑地址相邻，体现在内存空间中则是为用户程序分配的物理地址相邻。

分为单一连续分配、固定分区分配、动态分区分配、动态重定位分区分配。

#### 单一连续分配

在早期的单道程序环境下，内存被分为系统区和用户区。系统区供OS使用，而用户区供用户使用，仅装有一道用户程序，即用户区中连续的内存空间都由**单个进程**独占。这样的存储器分配方式就称作单一连续分配。

因此，它具有以下特点：

1. 存储器的状态不是全部空闲，就是全部已分配
2. 当作业被调度时，就获得全部空间

同时，具有以下缺点：

1. 因为仅装入一道程序，程序大小和存储器的可用空间大小可能不相等，所以存储器空间未得到充分利用
2. 因为是单道处理，一旦作业提出I/O请求，CPU就会处于空闲，所以处理机的利用率较低

#### 固定分区分配

早期的多道程序环境下，为了能够在内存中装入多道程序，就将内存中的用户空间划分为若干个固定大小的区域（称作分区），而每个分区中只装入一道程序。不同分区的大小可以相等，也可以不相等。

为了便于内存的分配，需要有一张表记录着每个分区的起始地址，大小，使用状况（即是否已经被分配），称作固定分区使用表。当有用户程序需要装入内存时，就需要查询固定分区使用表，找到满足条件的分区后分配给该程序，若找不到满足条件的分区则拒绝为该程序分配内存。

固定分区分配是最早出现的、可用于多道程序系统的存储管理方式。由于每个分区的大小固定，必然会造成存储空间的浪费，所以现在很少将它用于通用的OS中，更多用于控制多个相同对象的控制系统中（比如工业自动化中的生产线控制系统）

#### 动态分区分配

根据进程的实际需要，动态为其分配内存空间。

为了记录内存的使用情况。需要设置一张空闲分区表或空闲分区链，记录每个空闲分区的情况（分区号、大小、起始地址、分区状态...），可分别用数组或链表的数据结构实现。

![空闲分区表](https://cdn.jsdelivr.net/gh/hongxiaCoder/Pictures@master/20230901160438.png)

![空闲分区链](https://cdn.jsdelivr.net/gh/hongxiaCoder/Pictures@master/20230901160520.png)

为了动态的把新作业存入内存，就需要按照一定的分配算法，从空闲分区表或空闲分区链中选出空闲分区并分配给进程。

下面就介绍几种分配算法，包括首次适应算法，循环首次适应算法，最佳适应算法，最坏适应算法，快速适应算法，伙伴匹配系统，哈希算法这六种算法。

##### 基于顺序搜索的分配算法

###### 首次适应算法（First Fit）

在空闲分区链中从低地址位置开始寻找空闲的分区，一找到合适的空闲分区就进行划分和分配。

具体的工作原理：

1.系统维护一个空闲内存块链表，按照地址递增的顺序排列。

2.当一个进程请求内存时，首次适应算法从链表的头部开始扫描，寻找第一个能够满足请求大小的空闲内存块。

3.如果找到了足够大的空闲块，将其分割成两部分：一部分用于分配给进程，另一部分则成为新的空闲块。

4.如果没有足够大的空闲块，则继续扫描链表，直到找到满足条件的空闲块或者扫描完整个链表。

5.如果链表中没有合适的空闲块，则内存分配失败，进程需要等待或者采取其他策略。



由于优先利用低地址空间，所以能保留高地址的大空闲分区，为以后大作业的分配保留空间。

但是每次都需要从低地址部分开始查找，增加查找的开销。

###### 循环首次适应算法（Next Fit）

也称作临近适应算法。在首次适应算法的基础上加以改进，改进点为从上一次查找结束的位置继续往下搜索，若到最后一个位置仍无法找到，则循环到链首。

###### 最佳适应算法（Best Fit）

优先使用最小的空闲分区。

由于优先使用最小的空闲分区，所以每次分配后切割下来的剩余部分总是最小的，在存储器中就会留下许多难以利用的碎片。但是能够尽可能留下大的空闲分区，为大进程保留较大的空间。

###### 最坏适应算法（Worst Fit）

优先使用最大的空闲分区。

由于优先使用最大的空闲分区，所以每次分割下来的空闲分区不至于太小，产生碎片的概率最小。但是会使较大的连续空闲分区被用完，不利于之后大进程的分配。

| 算法         | 思想                 | 分区排序 | 优点                               | 缺点                                       |
| ------------ | -------------------- | -------- | ---------------------------------- | ------------------------------------------ |
| 首次适应     | 从低地址查找合适空间 | 地址递增 | 优先利用低地址空间                 | 每次都需要从低地址开始，增加查找开销       |
| 循环首次适应 | 从上次查找处向后查找 | 地址递增 | 不用从头开始查找，减小查找开销     | 会使高地址大空闲分区也被用完               |
| 最佳适应     | 优先使用最小空闲空间 | 容量递增 | 保留大的空闲分区，以满足大进程需求 | 容易产生难以利用的小碎片                   |
| 最坏适应     | 优先使用最大空闲空间 | 容量递减 | 不容易产生小碎片，查找效率高       | 大的空闲分区容易被用完，不利于大进程的分配 |

##### 基于索引搜索的分配算法

###### 快速适应算法

快速适应算法的基本思想是为不同大小的内存请求维护多个预定义的空闲链表或分区。这些链表或分区根据其大小将可用内存块划分为不同的类别。每个类别的链表中存放着相应大小的可用内存块。

当有一个内存请求时，快速适应算法会先检查与请求大小最接近的类别的链表。如果链表中有足够大的内存块，则将请求分配给该块。如果找不到足够大的内存块，算法会继续检查更大或更小的类别链表，直到找到适合的内存块或遍历完所有链表。

###### 伙伴匹配系统

规定分区的大小都为2^k，对于具有相同大小的所有空闲分区，为其单独设立一个空闲分区双向链表。

当需要分配一个大小为n的空间时，首先计算一个值使得2^(i-1)<= n <= 2^i，然后在大小为2^i的空闲分区链表中进行查找，若大小为2^i的空闲分区已耗尽，则查找大小为2^（i+1）的空闲分区链，若存在则将这块空闲分区**分割为**两个相等大小的分区，这两个大小相等的分区就称为”一对伙伴“，其中一块分配给进程，另一块作为空闲分区添加到大小为2^i的空闲分区链中。

###### 哈希算法

利用哈希快速查找的优点，以及空闲分区在可利用空闲分区链表中的分布规律，建立哈希函数，构造一张以空闲分区大小为关键字的哈希表。该表的每个表项均记录了一个对应的空闲分区链表表头指针。

当进行空闲分区分配时，根据所需空闲分区的大小，通过哈希函数计算得到哈希表中的位置，从而得到相应的空闲分区链表，最终实现分配。

### 2.分页存储管理方式

> 在介绍分页存储管理方式之前，我们先来承上启下，为什么会有分页存储管理方式？

在前面介绍到的连续分配方式中，由于多个进程不断被加载到内存和从内存中卸载，会导致内存空间出现分散的未被使用的小块空间，这些小块空间就称为外部碎片。正是由于分配和释放内存空间的不连续性（一个进程的空间是连续的，但多个进程间可能不连续），使得内存中的可用空间不连续，无法满足大块连续内存的分配需求。

虽然可以通过“紧凑”等方式将许多碎片拼接成可用的大块空间，但是由于需要移动大量用户程序和数据，会带来时间和计算资源的开销，所以未必是好的选择。

如果**允许将一个进程直接分散地装入许多不相邻的分区**中，就可以充分利用内存空间而无需进行”紧凑“。因此就产生了**离散分配存储管理方式**，包括分页存储管理方式，分段存储管理方式，段页式存储管理方式。

#### 页面和物理块

分页存储管理方式将进程的地址空间分为若干个页，并为每个页加以编号，从0开始，如第0页，第1页。对应地，也将内存空间分为若干个块，也对每个块加以编号，从0开始。

在为进程分配内存时，以块为单位，将进程中的若干页分别装入多个可以不相邻的物理块中。由于进程的最后一页经常装不满一块，就形成了不可利用的碎片，称之为**”页内碎片“或”内碎片“**。

> 将进程分成了多个页，那么页面大小多少才合适呢？

如果页面过小，虽然可以减少内部碎片，有利于提高内存利用率，但是会使得每个进程占有较多的页面，导致进程的页表过长，占用大量内存，同时也会降低页面换入/换出的效率。

如果页面过大，虽然可以减少页表长度，提高页面换入/换出的效率，但又会使内部碎片增大。

因此，在内部碎片、页表长度、换入换出的综合影响下，页面的大小一般为1KB、2KB、4KB、8KB。

#### 地址结构

分页地址中的地址结构，包含两部分内容：页号P，位移量W，即页内地址。

![地址结构](https://cdn.jsdelivr.net/gh/hongxiaCoder/Pictures@master/20230901160546.png)

#### 页表

因为进程的多个页可以装入到不连续的块中，所以需要有一个表结构记录哪一个页装入到了内存中的哪一个块，即记录页和块的映射关系，这个表结构就称为**页表**。

系统为每个进程创建页表，实现了页号到物理块号的映射。

![页表](https://cdn.jsdelivr.net/gh/hongxiaCoder/Pictures@master/20230901160602.png)

#### 地址变换机构

> 系统是如何实现逻辑地址到物理地址的转换？

为了能将用户地址空间的逻辑地址变换为内存空间的物理地址，在系统中必须设置地址变化机构。该机构是一组硬件机构，能够实现从逻辑地址到物理地址的变换。

##### 基本的地址变换机构

进程在运行期间，经常需要对每条指令的地址进行变换，因此需要利用硬件实现。

虽然使用寄存器来存储页表有利于提高地址变换的速度，但是由于寄存器的价格昂贵、容量小，以及页表项总数可能达到几千甚至几十万，使用寄存器来存储所有页表是不现实的。

因此通常**页表驻留内存**，系统只设置一个**页表寄存器**（page-table register，PTR）来存放页表在内存中的**起始地址和页表长度**。平时，页表的起始地址和页表长度都存放在进程的PCB（进程控制块）中，当调度程序调度到某进程时，才将这两个数据装入页表寄存器。



地址变换机构的工作流程（逻辑地址如何转换为物理地址）：

当进程要访问某个逻辑地址的数据时，

- 首先，地址变换机构会自动将该地址分为页号和页内地址两部分

- 然后，将页号与页表长度进行比较

  - 如果页号大于或等于页表长度，则表示本次所访问的地址已超过进程的地址空间，

    这一错误将被系统发现，并产生一个地址越界中断。

  - 如果页号小于页表长度，则将页表起始地址与”页号和页表项长度乘积“相加，得到该表项在页表中的位置，进而得到物理块号

- 将物理块号装入物理地址寄存器中，将逻辑地址的页内地址装入物理地址寄存器中的块内地址。

![地址变换机构](https://cdn.jsdelivr.net/gh/hongxiaCoder/Pictures@master/20230901160622.png)

##### 具有快表的地址变换机构

> 什么是快表，为什么需要快表？有了快表之后地址是如何转换的？

由于页表存放在内存中，CPU每次存取一个数据就要访问两次内存。第一次访问内存是访问内存中的页表，从中找到指定页的物理块号，再将块号与页内偏移量拼接，形成物理地址，第二次访问内存则根据物理地址获得所需数据（或写入数据）。两次访问内存使得计算机的处理速度降低近50%。

为了提高地址变换速度，可在地址变换机构中增加一个**具有并行查找能力的高速缓冲寄存器，称为”联想寄存器“或”快表“**。该寄存器中（快表）通常只存放16~512个页表项，对于小型作业可能可以存放所有页表项，对于大型作业只能存放一部分页表项。

⭐地址变换机构的工作流程（逻辑地址到物理地址的转换过程）：

- 由地址变换机构将逻辑地址中的页号送入高速缓冲寄存器
- 将此页号与高速缓冲寄存器中的所有页号进行比较
  - 如果匹配（存在），则表示所访问的页表项在快表中，直接读出该页对应的物理块号
  - 如果不匹配（不存在），则表示所访问的页表项不在快表中，需要查找内存中的页表，直到找到并读出对应的物理块号。同时，将从内存中读取的页表项存入快表的一个寄存器单元中。

由于局部性原理，从快表中能找到所需页表项的概率可达90%以上（据统计）。同时，CPU对寄存器的访问速度远快于对内存的访问速度。这样一来，由增加了地址变换机构而造成的速度损失就可以减少到10%以下。

![引入快表的地址变换机构](https://cdn.jsdelivr.net/gh/hongxiaCoder/Pictures@master/20230901160702.png)

> 快表是地址变换机构增设的高速缓冲寄存器，存储了部分页表项。有了快表之后，CPU存取数据无需两次访问内存，而是先到快表中查找是否有与逻辑地址中相匹配的页号，进而获取对应的物理块号，从而转换成物理地址。这样做能够减少增设地址变换机构和两次访存带来的速度损失。

##### 内存有效访问时间

内存有效访问时间，指从进程发出指定逻辑地址的访问请求，经地址变换，到内存中找到对应的实际物理地址单元并取出数据，这一过程所花费的时间。

在没有快表的情况下，需要两次访问内存。第一次访问内存中的页表获取对应物理块号，第二次访问内存是根据物理页框号和页内偏移量来计算最终的物理地址。所以EAT = t + t = 2t

引入了快表之后，直接去快表中匹配页号获取对应物理块号，若命中则可以省去一次访问内存时间，若没有命中还是要去访问内存中的页表获取对应物理块号。所以EAT = a × λ + （1 - λ）×（λ + t）+ t

- EAT：内存有效访问时间


- a：命中率


- λ：快表单次访问时间


- t：内存单次访问时间

|                        | 特点                             | 访存次数                                   |
| ---------------------- | -------------------------------- | ------------------------------------------ |
| 基本地址变换机构       | 根据页号，查找位于内存的页表     | 两次                                       |
| 具有快表的地址变换机构 | 快表存储部分页表项，优先查找快表 | 快表若命中，一次访存；若未命中，两次访存。 |

#### 两级

> 什么是多级页表，为什么需要多级页表？

现代的大多数计算机系统，都支持非常大的逻辑空间地址（2^32~2^64），在这样的环境下，页表变得非常大，需要占用相当大的内存空间。

举个例子：

对于具有32位逻辑地址空间的分页系统，逻辑地址空间范围共有2^32（4GB）。规定页面的大小为4KB，那么每个进程页表中的页表项的数量可达到 4G / 4K = 2^20 =1,048,576个，假设每个页表项需要4个字节来存储（即4B），那么一个进程的一张页表在内存中就需要2^20*4 = 2 ^ 22 = 4 ^ 20 ，即4MB。

由此来看，在32位的系统下，一个进程的一张页表就需要在内存中占用4MB，如果是一百个进程那就需要400MB，需要占用大量的内存空间，而且需要连续的内存空间。

> 那么该如何解决页表占用大量连续内存空间这一问题呢？

有两种方法：

1. 对于页表所需要的内存空间，**采用离散分配的方式**，已解决难以找到一块连续的大内存空间的问题
2. 只将当前所需要的部分页表项调入内存，其余页表项仍驻留在磁盘上，需要时调入

对于离散分配的方式，有一种实现方式就是**将页表进行划分**，使得这些更小的部分能够装入不连续的内存空间。

利用页表进行分页的方法，使每个页面的大小与内存物理块的大小相同，并为他们编号，然后离散地将各个页面分别存放在不同的物理块中。同样，为离散分配的页表再建立一张页表，称之为外层页表，在每个页表项中记录页表页面的物理块号。

两级页表的逻辑地址结构：

![两级页表地址结构](https://cdn.jsdelivr.net/gh/hongxiaCoder/Pictures@master/20230901160722.png)
![二级页表](https://cdn.jsdelivr.net/gh/hongxiaCoder/Pictures@master/20230901160746.png)

外层页表的每个页表项中，存放的是某页表分页的起始地址，如第0页存放在1011物理块中。

⭐地址变换机构的工作流程（逻辑地址到物理地址的转换过程）：

在地址变换机构中，增设一个外层页表寄存器，用于存放外层页表的起始地址，并将逻辑地址中的外层页号作为外层页表的索引，从中找到指定页表分页的起始地址，再将P2作为指定页表分页的索引，找到指定的页表项，其中含有该页在内存中的物理块号，用该块号和页内地址d即可构成访问的内存物理地址。



对于离散分配的方式，只解决了无需连续内存空间的问题，但未解决减少页表占用大量的内存空间。

对于两级页表的结构，对于正在运行的进程，**必须将外层页表调入内存**，而对于页表**只须调入一页或几页**。为了表征某夜的页表是否调入内存，还应该在外层页表中增设一个状态位S，0表示该页表分页不在内存中，否则表示已调入内存。

### 3.分段存储管理方式

分段存储管理是计算机操作系统中一种内存管理技术，用于有效地将内存分割为不同大小的段，每个段用于存储不同类型的程序或数据。每个段都可以具有不同的长度，因此可以更好地适应不同大小的程序和数据结构。

在分段存储管理方式下，程序被划分为逻辑段，每个段代表一个独立的功能单元，如代码段、数据段、堆栈段等。每个段都有一个基地址和长度信息。分段允许程序员将程序和数据划分为更小的逻辑单元，从而使程序的组织更加模块化和灵活。

分段存储管理方式的主要优点包括：

1. **模块化：** 程序和数据可以按照功能模块进行划分，使得代码的维护和调试更加容易。

2. **适应性：** 不同大小的程序和数据可以被分配到适当大小的段中，避免了对连续内存块的严格要求。

3. **共享：** 多个程序可以共享同一个段，从而节省内存空间。

然而，分段存储管理方式也存在一些问题：

1. **内部碎片：** 当段的大小不恰当时，可能会导致内部碎片，浪费一些内存空间。

2. **外部碎片：** 由于不同大小的段被动态加载到内存中，可能会导致内存中出现不连续的空闲块，从而影响内存的利用率。

3. **地址转换复杂：** 分段存储管理需要进行逻辑地址到物理地址的转换，这需要一些额外的硬件支持和复杂的管理机制。

随着计算机技术的发展，分段存储管理方式逐渐被更高级的内存管理技术如分页存储管理和虚拟存储管理所取代。这些技术更好地解决了碎片问题，并提供了更高的内存管理灵活性。

# 虚拟内存管理

具有请求调入和置换功能，从逻辑上对内存容量加以扩充的一种存储器系统

![虚拟内存](https://cdn.jsdelivr.net/gh/hongxiaCoder/Pictures@master/20230901160802.png)

## 局部性原理

- 时间局部性：某条指令被执行，不久后可能会被再次执行
- 空间局部性：程序在一段时间内集中访问一定范围内的地址

## 虚拟内存的特征

- 多次性：一个作业中的程序和数据无需一次性全部装入内存，而是可以分成多次调入内存，需要时再调入
- 对换性：相对驻留性而言，指一个作业中的程序和数据无需一直驻留在内存当中，而是允许代码和数据从内存中换入和换出
- 虚拟性：指能从逻辑上扩大内存容量，以多次性和对换性为基础

## 虚拟内存的实现

- 请求分页系统
- 请求分段系统

### 请求分页的硬件支持

- 请求页表机制：作为数据结构，作用是将用户地址空间的逻辑地址映射为内存空间中的物理地址。

  - 页号：将进程地址空间分成若干页，并为每个页加以编号，从0开始
  - 物理块号：将内存空间分为若干块，并为每个块加以编号，从0开始
  - 状态位P（存在位）：指示该页是否已调入内存
  - 访问字段A：记录该页一段时间内的被访问次数
  - 修改位：标志该页在调入内存后是否被修改过。若修改过则需要将该页重写到外存
  - 外存地址：标志该页在外存中的地址，通常是物理地址

  > 页内碎片：
  >
  > 在为进程分配内存时，以块为单位，将进程中若干页分别装入多个可以不相邻的块中。由于最后一页经常装不满一块，进而形成不可利用的碎片，称为“页内碎片”或“内碎片”。
  >
  > 页面大小：
  >
  > 如果页面过小，可以减少内碎片，提高内存利用率。但会造成页表过长，占用大量内存。同时降低换入换出效率
  >
  > 如果页面过大，可以减小页表长度，减少页表内存占用，以及提高换入换出效率。但会造成内碎片增大。

- 缺页中断机构

## 抖动

当系统中同时运行的**进程太多**，导致分配给每个进程的物理块太少，致使每个进程在运行时会**频繁的出现缺页**，此时系统就需要不断的将进程所需要的页面调入，同时也要将暂时不需要的页面换出内存。这就会导致**进程的大部分时间都用于页面的换入换出**，而不能做有效的工作，导致处理机的利用率急剧下降，我们就称这种情况为“抖动”