# LeetCode Solutions

![Python](https://img.shields.io/badge/language-Python-blue.svg)
![C++](https://img.shields.io/badge/language-C++-orange.svg)
![JavaScript](https://img.shields.io/badge/language-JavaScript-yellow.svg)
![SQL](https://img.shields.io/badge/language-SQL-lightgrey.svg)
![TypeScript](https://img.shields.io/badge/language-TypeScript-blue.svg)

Welcome to a robust and versatile repository of LeetCode solutions! This repository is a treasure trove for coding enthusiasts, educators, students, and professionals who are preparing for technical interviews or enhancing their coding skills.

## What You'll Find Here

- **Wide Range of Problems:** Our collection includes an extensive range of LeetCode problems, covering various topics and difficulty levels – from Easy to Hard.
- **Multi-Language Support:** We offer solutions in several programming languages, including Python, C++, JavaScript, SQL, and TypeScript, catering to a diverse coding community.
- **Organized and Accessible:** Each solution is meticulously organized by difficulty and language, making it easy to navigate and find what you need.
- **In-Depth Explanations:** You'll find README files in each problem folder with detailed explanations of the problem, the approach taken, and a thorough walkthrough of the solution.

## Statistics

<img src="https://leetcard.jacoblin.cool/hogantech" alt="hogan-tech-leetcode" />

## Folder Structure

The solutions are organized as follows:

- **Difficulty:** Problems are categorized into Easy, Medium, and Hard.
- **Languages:** Solutions are available in multiple programming languages, including Python, C++, JavaScript, SQL, and TypeScript.
- **Problem Titles:** Each problem is named after its LeetCode title.

## Question List

| #    | Title                                                                                                                                                                                     | Solution                                                                                               | Difficulty & ReadMe                                                                                    |
| ---- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------ |
| 0001 | [Two Sum](https://leetcode.com/problems/two-sum/)                                                                                                                                         | [Python](./Python/0001-two-sum.py)                                                                     | [Easy](./Readme/0001-two-sum.md)                                                                       |
| 0002 | [Add Two Numbers](https://leetcode.com/problems/add-two-numbers/)                                                                                                                         | [Python](./C++/0002-add-two-numbers.py), [C++](./C++/0002-add-two-numbers.cpp)                         | [Medium](./Readme/0002-add-two-numbers.md)                                                             |
| 0003 | [Longest Substring Without Repeating Characters](https://leetcode.com/problems/longest-substring-without-repeating-characters/)                                                           | [Python](./Python/0003-longest-substring-without-repeating-characters.py)                              | [Medium](./Readme/0003-longest-substring-without-repeating-characters.md)                              |
| 0004 | [Median of Two Sorted Arrays](https://leetcode.com/problems/median-of-two-sorted-arrays/)                                                                                                 | [Python](./Python/0004-median-of-two-sorted-arrays.py)                                                 | [Hard](./Readme/0004-median-of-two-sorted-arrays.md)                                                   |
| 0005 | [Longest Palindromic Substring](https://leetcode.com/problems/longest-palindromic-substring/)                                                                                             | [Python](./Python/0005-longest-palindromic-substring.py)                                               | [Medium](./Readme/0005-longest-palindromic-substring.md)                                               |
| 0006 | [ZigZag Conversion](https://leetcode.com/problems/zigzag-conversion/)                                                                                                                     | [Python](./Python/0006-zigzag-conversion.py)                                                           | [Medium](./Readme/0006-zigzag-conversion.md)                                                           |
| 0007 | [Reverse Integer](https://leetcode.com/problems/reverse-integer/)                                                                                                                         | [Python](./Python/0007-reverse-integer.py)                                                             | [Medium](./Readme/0007-reverse-integer.md)                                                             |
| 0008 | [String to Integer (atoi)](https://leetcode.com/problems/string-to-integer-atoi/)                                                                                                         | [Python](./Python/0008-string-to-integer-atoi.py)                                                      | [Medium](./Readme/0008-string-to-integer-atoi.md)                                                      |
| 0009 | [Palindrome Number](https://leetcode.com/problems/palindrome-number/)                                                                                                                     | [C++](./C++/0009-palindrome-number.cpp)                                                                | [Easy](./Readme/0009-palindrome-number.md)                                                             |
| 0010 | [Regular Expression Matching](https://leetcode.com/problems/regular-expression-matching/)                                                                                                 | [Python](./Python/0010-regular-expression-matching.py)                                                 | [Hard](./Readme/0010-regular-expression-matching.md)                                                   |
| 0011 | [Container With Most Water](https://leetcode.com/problems/container-with-most-water/)                                                                                                     | [Python](./Python/0011-container-with-most-water.py)                                                   | [Medium](./Readme/0011-container-with-most-water.md)                                                   |
| 0012 | [Integer to Roman](https://leetcode.com/problems/integer-to-roman/)                                                                                                                       | [Python](./Python/0012-integer-to-roman.py)                                                            | [Medium](./Readme/0012-integer-to-roman.md)                                                            |
| 0013 | [Roman to Integer](https://leetcode.com/problems/roman-to-integer/)                                                                                                                       | [C++](./C++/0013-roman-to-integer.cpp)                                                                 | [Easy](./Readme/0013-roman-to-integer.md)                                                              |
| 0014 | [Longest Common Prefix](https://leetcode.com/problems/longest-common-prefix/)                                                                                                             | [C++](./C++/0014-longest-common-prefix.cpp)                                                            | [Easy](./Readme/0014-longest-common-prefix.md)                                                         |
| 0015 | [3Sum](https://leetcode.com/problems/3sum/)                                                                                                                                               | [Python](./Python/0015-3sum.py)                                                                        | [Medium](./Readme/0015-3sum.md)                                                                        |
| 0016 | [3Sum Closest](https://leetcode.com/problems/3sum-closest/)                                                                                                                               | [Python](./Python/0016-3sum-closest.py)                                                                | [Medium](./Readme/0016-3sum-closest.md)                                                                |
| 0017 | [Letter Combinations of a Phone Number](https://leetcode.com/problems/letter-combinations-of-a-phone-number/)                                                                             | [Python](./Python/0017-letter-combinations-of-a-phone-number.py)                                       | [Medium](./Readme/0017-letter-combinations-of-a-phone-number.md)                                       |
| 0018 | [4Sum](https://leetcode.com/problems/4sum/)                                                                                                                                               | [Python](./Python/0018-4sum.py)                                                                        | [Medium](./Readme/0018-4sum.md)                                                                        |
| 0019 | [Remove Nth Node From End of List](https://leetcode.com/problems/remove-nth-node-from-end-of-list/)                                                                                       | [Python](./Python/0019-remove-nth-node-from-end-of-list.py)                                            | [Medium](./Readme/0019-remove-nth-node-from-end-of-list.md)                                            |
| 0020 | [Valid Parentheses](https://leetcode.com/problems/valid-parentheses/)                                                                                                                     | [Python](./Python/0020-valid-parentheses.py)                                                           | [Easy](./Readme/0020-valid-parentheses.md)                                                             |
| 0021 | [Merge Two Sorted Lists](https://leetcode.com/problems/merge-two-sorted-lists/)                                                                                                           | [Python](./Python/0021-merge-two-sorted-lists.py)                                                      | [Easy](./Readme/0021-merge-two-sorted-lists.md)                                                        |
| 0022 | [Generate Parentheses](https://leetcode.com/problems/generate-parentheses/)                                                                                                               | [Python](./Python/0022-generate-parentheses.py)                                                        | [Medium](./Readme/0022-generate-parentheses.md)                                                        |
| 0023 | [Merge k Sorted Lists](https://leetcode.com/problems/merge-k-sorted-lists/)                                                                                                               | [Python](./Python/0023-merge-k-sorted-lists.py)                                                        | [Hard](./Readme/0023-merge-k-sorted-lists.md)                                                          |
| 0024 | [Swap Nodes in Pairs](https://leetcode.com/problems/swap-nodes-in-pairs/)                                                                                                                 | [Python](./Python/0024-swap-nodes-in-pairs.py)                                                         | [Medium](./Readme/0024-swap-nodes-in-pairs.md)                                                         |
| 0025 | [Reverse Nodes in k-Group](https://leetcode.com/problems/reverse-nodes-in-k-group/)                                                                                                       | [Python](./Python/0025-reverse-nodes-in-k-group.py)                                                    | [Hard](./Readme/0025-reverse-nodes-in-k-group.md)                                                      |
| 0026 | [Remove Duplicates from Sorted Array](https://leetcode.com/problems/remove-duplicates-from-sorted-array/)                                                                                 | [Python](./Python/0026-remove-duplicates-from-sorted-array.py)                                         | [Easy](./Readme/0026-remove-duplicates-from-sorted-array.md)                                           |
| 0027 | [Remove Element](https://leetcode.com/problems/remove-element/)                                                                                                                           | [Python](./Python/0027-remove-element.py)                                                              | [Easy](./Readme/0027-remove-element.md)                                                                |
| 0028 | [Implement strStr()](https://leetcode.com/problems/implement-strstr/)                                                                                                                     | [Python](./Python/0028-implement-strstr.py)                                                            | [Easy](./Readme/0028-implement-strstr.md)                                                              |
| 0029 | [Divide Two Integers](https://leetcode.com/problems/divide-two-integers/)                                                                                                                 | [Python](./Python/0029-divide-two-integers.py)                                                         | [Medium](./Readme/0029-divide-two-integers.md)                                                         |
| 0030 | [Substring with Concatenation of All Words](https://leetcode.com/problems/substring-with-concatenation-of-all-words/)                                                                     | [Python](./Python/0030-substring-with-concatenation-of-all-words.py)                                   | [Hard](./Readme/0030-substring-with-concatenation-of-all-words.md)                                     |
| 0031 | [Next Permutation](https://leetcode.com/problems/next-permutation/)                                                                                                                       | [Python](./Python/0031-next-permutation.py)                                                            | [Medium](./Readme/0031-next-permutation.md)                                                            |
| 0032 | [Longest Valid Parentheses](https://leetcode.com/problems/longest-valid-parentheses/)                                                                                                     | [Python](./Python/0032-longest-valid-parentheses.py)                                                   | [Hard](./Readme/0032-longest-valid-parentheses.md)                                                     |
| 0033 | [Search in Rotated Sorted Array](https://leetcode.com/problems/search-in-rotated-sorted-array/)                                                                                           | [Python](./Python/0033-search-in-rotated-sorted-array.py)                                              | [Medium](./Readme/0033-search-in-rotated-sorted-array.md)                                              |
| 0034 | [Find First and Last Position of Element in Sorted Array](https://leetcode.com/problems/find-first-and-last-position-of-element-in-sorted-array/)                                         | [Python](./Python/0034-find-first-and-last-position-of-element-in-sorted-array.py)                     | [Medium](./Readme/0034-find-first-and-last-position-of-element-in-sorted-array.md)                     |
| 0035 | [Search Insert Position](https://leetcode.com/problems/search-insert-position/)                                                                                                           | [Python](./Python/0035-search-insert-position.py)                                                      | [Easy](./Readme/0035-search-insert-position.md)                                                        |
| 0036 | [Valid Sudoku](https://leetcode.com/problems/valid-sudoku/)                                                                                                                               | [Python](./Python/0036-valid-sudoku.py)                                                                | [Medium](./Readme/0036-valid-sudoku.md)                                                                |
| 0037 | [Sudoku Solver](https://leetcode.com/problems/sudoku-solver/)                                                                                                                             | [Python](./Python/0037-sudoku-solver.py)                                                               | [Hard](./Readme/0037-sudoku-solver.md)                                                                 |
| 0038 | [Count and Say](https://leetcode.com/problems/count-and-say)                                                                                                                              | [Python](./Python/0038-count-and-say.py)                                                               | [Medium](./Readme/0038-count-and-say.md)                                                               |
| 0039 | [Combination Sum](https://leetcode.com/problems/combination-sum/)                                                                                                                         | [Python](./Python/0039-combination-sum.py)                                                             | [Medium](./Readme/0039-combination-sum.md)                                                             |
| 0040 | [Combination Sum II](https://leetcode.com/problems/combination-sum-ii/)                                                                                                                   | [Python](./Python/0040-combination-sum-ii.py)                                                          | [Medium](./Readme/0040-combination-sum-ii.md)                                                          |
| 0041 | [First Missing Positive](https://leetcode.com/problems/first-missing-positive/)                                                                                                           | [Python](./Python/0041-first-missing-positive.py)                                                      | [Hard](./Readme/0041-first-missing-positive.md)                                                        |
| 0042 | [Trapping Rain Water](https://leetcode.com/problems/trapping-rain-water/)                                                                                                                 | [Python](./Python/0042-trapping-rain-water.py)                                                         | [Hard](./Readme/0042-trapping-rain-water.md)                                                           |
| 0043 | [Multiply Strings](https://leetcode.com/problems/multiply-strings/)                                                                                                                       | [Python](./Python/0043-multiply-strings.py)                                                            | [Medium](./Readme/0043-multiply-strings.md)                                                            |
| 0045 | [Jump Game II](https://leetcode.com/problems/jump-game-ii/)                                                                                                                               | [C++](./C++/0045-jump-game-ii.cpp)                                                                     | [Hard](./Readme/0045-jump-game-ii.md)                                                                  |
| 0046 | [Permutations](https://leetcode.com/problems/permutations/)                                                                                                                               | [C++](./C++/0046-permutations.cpp)                                                                     | [Medium](./Readme/0046-permutations.md)                                                                |
| 0047 | [Permutations II](https://leetcode.com/problems/permutations-ii/)                                                                                                                         | [Python](./Python/0047-permutations-ii.py)                                                             | [Medium](./Readme/0047-permutations-ii.md)                                                             |
| 0048 | [Rotate Image](https://leetcode.com/problems/rotate-image/)                                                                                                                               | [C++](./C++/0048-rotate-image.cpp)                                                                     | [Medium](./Readme/0048-rotate-image.md)                                                                |
| 0049 | [Group Anagrams](https://leetcode.com/problems/group-anagrams/)                                                                                                                           | [Python](./Python/0049-group-anagrams.py)                                                              | [Medium](./Readme/0049-group-anagrams.md)                                                              |
| 0050 | [Pow(x, n)](https://leetcode.com/problems/powx-n/)                                                                                                                                        | [Python](./Python/0050-powx-n.py)                                                                      | [Medium](./Readme/0050-powx-n.md)                                                                      |
| 0051 | [N Queens](https://leetcode.com/problems/n-queens/)                                                                                                                                       | [Python](./Python/0051-n-queens.py)                                                                    | [Hard](./Readme/0051-n-queens.md)                                                                      |
| 0052 | [N Queens II](https://leetcode.com/problems/n-queens-ii/)                                                                                                                                 | [Python](./Python/0052-n-queens-ii.py)                                                                 | [Hard](./Readme/0052-n-queens-ii.md)                                                                   |
| 0053 | [Maximum Subarray](https://leetcode.com/problems/maximum-subarray/)                                                                                                                       | [Python](./Python/0053-maximum-subarray.py)                                                            | [Easy](./Readme/0053-maximum-subarray.md)                                                              |
| 0054 | [Spiral Matrix](https://leetcode.com/problems/spiral-matrix/)                                                                                                                             | [Python](./Python/0054-spiral-matrix.py)                                                               | [Medium](./Readme/0054-spiral-matrix.md)                                                               |
| 0055 | [Jump Game](https://leetcode.com/problems/jump-game/)                                                                                                                                     | [C++](./C++/0055-jump-game.cpp)                                                                        | [Medium](./Readme/0055-jump-game.md)                                                                   |
| 0056 | [Merge Intervals](https://leetcode.com/problems/merge-intervals/)                                                                                                                         | [Python](./Python/0056-merge-intervals.py)                                                             | [Medium](./Readme/0056-merge-intervals.md)                                                             |
| 0057 | [Insert Interval](https://leetcode.com/problems/insert-interval/)                                                                                                                         | [Python](./Python/0057-insert-interval.py)                                                             | [Hard](./Readme/0057-insert-interval.md)                                                               |
| 0058 | [Length of Last Word](https://leetcode.com/problems/length-of-last-word/)                                                                                                                 | [Python](./Python/0058-length-of-last-word.py)                                                         | [Easy](./Readme/0058-length-of-last-word.md)                                                           |
| 0059 | [Spiral Matrix II](https://leetcode.com/problems/spiral-matrix-ii/)                                                                                                                       | [C++](./C++/0059-spiral-matrix-ii.cpp)                                                                 | [Medium](./Readme/0059-spiral-matrix-ii.md)                                                            |
| 0061 | [Rotate List](https://leetcode.com/problems/rotate-list/)                                                                                                                                 | [Python](./Python/0061-rotate-list.py)                                                                 | [Medium](./Readme/0061-rotate-list.md)                                                                 |
| 0062 | [Unique Paths](https://leetcode.com/problems/unique-paths/)                                                                                                                               | [Python](./Python/0062-unique-paths.py)                                                                | [Medium](./Readme/0062-unique-paths.md)                                                                |
| 0063 | [Unique Paths II](https://leetcode.com/problems/unique-paths-ii/)                                                                                                                         | [Python](./Python/0063-unique-paths-ii.py)                                                             | [Medium](./Readme/0063-unique-paths-ii.md)                                                             |
| 0064 | [Minimum Path Sum](https://leetcode.com/problems/minimum-path-sum/)                                                                                                                       | [Python](./Python/0064-minimum-path-sum.py)                                                            | [Medium](./Readme/0064-minimum-path-sum.md)                                                            |
| 0066 | [Plus One](https://leetcode.com/problems/plus-one/)                                                                                                                                       | [Python](./Python/0066-plus-one.py)                                                                    | [Easy](./Readme/0066-plus-one.md)                                                                      |
| 0067 | [Add Binary](https://leetcode.com/problems/add-binary/)                                                                                                                                   | [Python](./Python/0067-add-binary.py)                                                                  | [Easy](./Readme/0067-add-binary.md)                                                                    |
| 0068 | [Text Justification](https://leetcode.com/problems/text-justification/)                                                                                                                   | [Python](./Python/0068-text-justification.py)                                                          | [Hard](./Readme/0068-text-justification.md)                                                            |
| 0069 | [Sqrt(x)](https://leetcode.com/problems/sqrtx/)                                                                                                                                           | [Python](./Python/0069-sqrtx.py)                                                                       | [Easy](./Readme/0069-sqrtx.md)                                                                         |
| 0070 | [Climbing Stairs](https://leetcode.com/problems/climbing-stairs/)                                                                                                                         | [Python](./Python/0070-climbing-stairs.py)                                                             | [Easy](./Readme/0070-climbing-stairs.md)                                                               |
| 0071 | [Simplify Path](https://leetcode.com/problems/simplify-path/)                                                                                                                             | [Python](./Python/0071-simplify-path.py)                                                               | [Medium](./Readme/0071-simplify-path.md)                                                               |
| 0072 | [Edit Distance](https://leetcode.com/problems/edit-distance/)                                                                                                                             | [Python](./Python/0072-edit-distance.py)                                                               | [Medium](./Readme/0072-edit-distance.md)                                                               |
| 0073 | [Set Matrix Zeroes](https://leetcode.com/problems/set-matrix-zeroes/)                                                                                                                     | [Python](./Python/0073-set-matrix-zeroes.py)                                                           | [Medium](./Readme/0073-set-matrix-zeroes.md)                                                           |
| 0074 | [Search a 2D Matrix](https://leetcode.com/problems/search-a-2d-matrix/)                                                                                                                   | [Python](./Python/0074-search-a-2d-matrix.py)                                                          | [Medium](./Readme/0074-search-a-2d-matrix.md)                                                          |
| 0075 | [Sort Colors](https://leetcode.com/problems/sort-colors/)                                                                                                                                 | [Python](./Python/0075-sort-colors.py)                                                                 | [Medium](./Readme/0075-sort-colors.md)                                                                 |
| 0076 | [Minimum Window Substring](https://leetcode.com/problems/minimum-window-substring/)                                                                                                       | [Python](./Python/0076-minimum-window-substring.py)                                                    | [Hard](./Readme/0076-minimum-window-substring.md)                                                      |
| 0077 | [Combinations](https://leetcode.com/problems/combinations/)                                                                                                                               | [Python](./Python/0077-combinations.py)                                                                | [Medium](./Readme/0077-combinations.md)                                                                |
| 0078 | [Subsets](https://leetcode.com/problems/subsets/)                                                                                                                                         | [Python](./Python/0078-subsets.py)                                                                     | [Medium](./Readme/0078-subsets.md)                                                                     |
| 0079 | [Word Search](https://leetcode.com/problems/word-search/)                                                                                                                                 | [Python](./Python/0079-word-search.py)                                                                 | [Medium](./Readme/0079-word-search.md)                                                                 |
| 0080 | [Remove Duplicates from Sorted Array II](https://leetcode.com/problems/remove-duplicates-from-sorted-array-ii/)                                                                           | [Python](./Python/0080-remove-duplicates-from-sorted-array-ii.py)                                      | [Medium](./Readme/0080-remove-duplicates-from-sorted-array-ii.md)                                      |
| 0081 | [Search in Rotated Sorted Array II](https://leetcode.com/problems/search-in-rotated-sorted-array-ii/)                                                                                     | [Python](./Python/0081-search-in-rotated-sorted-array-ii.py)                                           | [Medium](./Readme/0081-search-in-rotated-sorted-array-ii.md)                                           |
| 0082 | [Remove Duplicates from Sorted List II](https://leetcode.com/problems/remove-duplicates-from-sorted-list-ii/)                                                                             | [Python](./Python/0082-remove-duplicates-from-sorted-list-ii.py)                                       | [Medium](./Readme/0082-remove-duplicates-from-sorted-list-ii.md)                                       |
| 0083 | [Remove Duplicates from Sorted List](https://leetcode.com/problems/remove-duplicates-from-sorted-list/)                                                                                   | [C++](./C++/0083-remove-duplicates-from-sorted-list.cpp)                                               | [Easy](./Readme/0083-remove-duplicates-from-sorted-list.md)                                            |
| 0084 | [Largest Rectangle in Histogram](https://leetcode.com/problems/largest-rectangle-in-histogram/)                                                                                           | [Python](./Python/0084-largest-rectangle-in-histogram.py)                                              | [Hard](./Readme/0084-largest-rectangle-in-histogram.md)                                                |
| 0085 | [Maximal Rectangle](https://leetcode.com/problems/maximal-rectangle/)                                                                                                                     | [Python](./Python/0085-maximal-rectangle.py)                                                           | [Hard](./Readme/0085-maximal-rectangle.md)                                                             |
| 0086 | [Partition List](https://leetcode.com/problems/partition-list/)                                                                                                                           | [Python](./Python/0086-partition-list.py)                                                              | [Medium](./Readme/0086-partition-list.md)                                                              |
| 0088 | [Merge Sorted Array](https://leetcode.com/problems/merge-sorted-array/)                                                                                                                   | [C++](./C++/0088-merge-sorted-array.cpp)                                                               | [Easy](./Readme/0088-merge-sorted-array.md)                                                            |
| 0089 | [Gray Code](https://leetcode.com/problems/gray-code)                                                                                                                                      | [Python](./Python/0089-gray-code.py)                                                                   | [Medium](./Readme/0089-gray-code.md)                                                                   |
| 0090 | [Subsets II](https://leetcode.com/problems/subsets-ii/)                                                                                                                                   | [Python](./Python/0090-subsets-ii.py)                                                                  | [Medium](./Readme/0090-subsets-ii.md)                                                                  |
| 0091 | [Decode Ways](https://leetcode.com/problems/decode-ways/)                                                                                                                                 | [Python](./Python/0091-decode-ways.py)                                                                 | [Medium](./Readme/0091-decode-ways.md)                                                                 |
| 0092 | [Reverse Linked List II](https://leetcode.com/problems/reverse-linked-list-ii/)                                                                                                           | [Python](./Python/0092-reverse-linked-list-ii.py)                                                      | [Medium](./Readme/0092-reverse-linked-list-ii.md)                                                      |
| 0093 | [Restore IP Addresses](https://leetcode.com/problems/restore-ip-addresses/)                                                                                                               | [Python](./Python/0093-restore-ip-addresses.py)                                                        | [Medium](./Readme/0093-restore-ip-addresses.md)                                                        |
| 0094 | [Binary Tree Inorder Traversal](https://leetcode.com/problems/binary-tree-inorder-traversal/)                                                                                             | [Python](./Python/0094-binary-tree-inorder-traversal.py)                                               | [Easy](./Readme/0094-binary-tree-inorder-traversal.md)                                                 |
| 0095 | [Unique Binary Search Trees II](https://leetcode.com/problems/unique-binary-search-trees-ii/)                                                                                             | [Python](./Python/0095-unique-binary-search-trees-ii.py)                                               | [Medium](./Readme/0095-unique-binary-search-trees-ii.md)                                               |
| 0096 | [Unique Binary Search Trees](https://leetcode.com/problems/unique-binary-search-trees/)                                                                                                   | [Python](./Python/0096-unique-binary-search-trees.py)                                                  | [Medium](./Readme/0096-unique-binary-search-trees.md)                                                  |
| 0097 | [Interleaving String](https://leetcode.com/problems/interleaving-string/)                                                                                                                 | [Python](./Python/0097-interleaving-string.py)                                                         | [Medium](./Readme/0097-interleaving-string.md)                                                         |
| 0098 | [Validate Binary Search Tree](https://leetcode.com/problems/validate-binary-search-tree/)                                                                                                 | [Python](./Python/0098-validate-binary-search-tree.py)                                                 | [Medium](./Readme/0098-validate-binary-search-tree.md)                                                 |
| 0100 | [Same Tree](https://leetcode.com/problems/same-tree/)                                                                                                                                     | [Python](./Python/0100-same-tree.py)                                                                   | [Easy](./Readme/0100-same-tree.md)                                                                     |
| 0101 | [Symmetric Tree](https://leetcode.com/problems/symmetric-tree/)                                                                                                                           | [C++](./C++/0101-symmetric-tree.cpp)                                                                   | [Easy](./Readme/0101-symmetric-tree.md)                                                                |
| 0102 | [Binary Tree Level Order Traversal](https://leetcode.com/problems/binary-tree-level-order-traversal/)                                                                                     | [Python](./Python/0102-binary-tree-level-order-traversal.py)                                           | [Medium](./Readme/0102-binary-tree-level-order-traversal.md)                                           |
| 0103 | [Binary Tree Zigzag Level Order Traversal](https://leetcode.com/problems/binary-tree-zigzag-level-order-traversal/)                                                                       | [Python](./Python/0103-binary-tree-zigzag-level-order-traversal.py)                                    | [Medium](./Readme/0103-binary-tree-zigzag-level-order-traversal.md)                                    |
| 0104 | [Maximum Depth of Binary Tree](https://leetcode.com/problems/maximum-depth-of-binary-tree/)                                                                                               | [Python](./Python/0104-maximum-depth-of-binary-tree.py)                                                | [Easy](./Readme/0104-maximum-depth-of-binary-tree.md)                                                  |
| 0105 | [Construct Binary Tree from Preorder and Inorder Traversal](https://leetcode.com/problems/construct-binary-tree-from-preorder-and-inorder-traversal/)                                     | [Python](./Python/0105-construct-binary-tree-from-preorder-and-inorder-traversal.py)                   | [Medium](./Readme/0105-construct-binary-tree-from-preorder-and-inorder-traversal.md)                   |
| 0106 | [Construct Binary Tree from Inorder and Postorder Traversal](https://leetcode.com/problems/construct-binary-tree-from-inorder-and-postorder-traversal/)                                   | [Python](./Python/0106-construct-binary-tree-from-inorder-and-postorder-traversal.py)                  | [Medium](./Readme/0106-construct-binary-tree-from-inorder-and-postorder-traversal.md)                  |
| 0108 | [Convert Sorted Array to Binary Search Tree](https://leetcode.com/problems/convert-sorted-array-to-binary-search-tree/)                                                                   | [Python](./Python/0108-convert-sorted-array-to-binary-search-tree.py)                                  | [Easy](./Readme/0108-convert-sorted-array-to-binary-search-tree.md)                                    |
| 0110 | [Balanced Binary Tree](https://leetcode.com/problems/balanced-binary-tree/)                                                                                                               | [Python](./Python/0110-balanced-binary-tree.py)                                                        | [Easy](./Readme/0110-balanced-binary-tree.md)                                                          |
| 0111 | [Minimum Depth of Binary Tree](https://leetcode.com/problems/minimum-depth-of-binary-tree/)                                                                                               | [Python](./Python/0111-minimum-depth-of-binary-tree.py)                                                | [Easy](./Readme/0111-minimum-depth-of-binary-tree.md)                                                  |
| 0112 | [Path Sum](https://leetcode.com/problems/path-sum/)                                                                                                                                       | [Python](./Python/0112-path-sum.py)                                                                    | [Easy](./Readme/0112-path-sum.md)                                                                      |
| 0113 | [Path Sum II](https://leetcode.com/problems/path-sum-ii/)                                                                                                                                 | [Python](./Python/0113-path-sum-ii.py)                                                                 | [Medium](./Readme/0113-path-sum-ii.md)                                                                 |
| 0114 | [Flatten Binary Tree to Linked List](https://leetcode.com/problems/flatten-binary-tree-to-linked-list/)                                                                                   | [Python](./Python/0114-flatten-binary-tree-to-linked-list.py)                                          | [Medium](./Readme/0114-flatten-binary-tree-to-linked-list.md)                                          |
| 0115 | [Distinct Subsequences](https://leetcode.com/problems/distinct-subsequences/)                                                                                                             | [Python](./Python/0115-distinct-subsequences.py)                                                       | [Hard](./Readme/0115-distinct-subsequences.md)                                                         |
| 0116 | [Populating Next Right Pointers in Each Node](https://leetcode.com/problems/populating-next-right-pointers-in-each-node/)                                                                 | [C++](./C++/0116-populating-next-right-pointers-in-each-node.cpp)                                      | [Medium](./Readme/0116-populating-next-right-pointers-in-each-node.md)                                 |
| 0117 | [Populating Next Right Pointers in Each Node II](https://leetcode.com/problems/populating-next-right-pointers-in-each-node-ii/)                                                           | [Python](./Python/0117-populating-next-right-pointers-in-each-node-ii.py)                              | [Medium](./Readme/0117-populating-next-right-pointers-in-each-node-ii.md)                              |
| 0118 | [Pascal's Triangle](https://leetcode.com/problems/pascals-triangle/)                                                                                                                      | [Python](./Python/0118-pascals-triangle.py)                                                            | [Easy](./Readme/0118-pascals-triangle.md)                                                              |
| 0119 | [Pascal's Triangle II](https://leetcode.com/problems/pascals-triangle-ii/)                                                                                                                | [Python](./Python/0119-pascals-triangle-ii.py)                                                         | [Easy](./Readme/0119-pascals-triangle-ii.md)                                                           |
| 0120 | [Triangle](https://leetcode.com/problems/triangle/)                                                                                                                                       | [Python](./Python/0120-triangle.py)                                                                    | [Medium](./Readme/0120-triangle.md)                                                                    |
| 0121 | [Best Time to Buy and Sell Stock](https://leetcode.com/problems/best-time-to-buy-and-sell-stock/)                                                                                         | [Python](./Python/0121-best-time-to-buy-and-sell-stock.py)                                             | [Easy](./Readme/0121-best-time-to-buy-and-sell-stock.md)                                               |
| 0122 | [Best Time to Buy and Sell Stock II](https://leetcode.com/problems/best-time-to-buy-and-sell-stock-ii/)                                                                                   | [Python](./Python/0122-best-time-to-buy-and-sell-stock-ii.py)                                          | [Medium](./Readme/0122-best-time-to-buy-and-sell-stock-ii.md)                                          |
| 0123 | [Best Time to Buy and Sell Stock III](https://leetcode.com/problems/best-time-to-buy-and-sell-stock-iii/)                                                                                 | [Python](./Python/0123-best-time-to-buy-and-sell-stock-iii.py)                                         | [Hard](./Readme/0123-best-time-to-buy-and-sell-stock-iii.md)                                           |
| 0124 | [Binary Tree Maximum Path Sum](https://leetcode.com/problems/binary-tree-maximum-path-sum/)                                                                                               | [Python](./Python/0124-binary-tree-maximum-path-sum.py)                                                | [Medium](./Readme/0124-binary-tree-maximum-path-sum.md)                                                |
| 0125 | [Valid Palindrome](https://leetcode.com/problems/valid-palindrome/)                                                                                                                       | [Python](./Python/0125-valid-palindrome.py)                                                            | [Easy](./Readme/0125-valid-palindrome.md)                                                              |
| 0127 | [Word Ladder](https://leetcode.com/problems/word-ladder/)                                                                                                                                 | [Python](./Python/0127-word-ladder.py)                                                                 | [Medium](./Readme/0127-word-ladder.md)                                                                 |
| 0128 | [Longest Consecutive Sequence](https://leetcode.com/problems/longest-consecutive-sequence/)                                                                                               | [Python](./Python/0128-longest-consecutive-sequence.py)                                                | [Hard](./Readme/0128-longest-consecutive-sequence.md)                                                  |
| 0129 | [Sum Root to Leaf Numbers](https://leetcode.com/problems/sum-root-to-leaf-numbers/)                                                                                                       | [Python](./Python/0129-sum-root-to-leaf-numbers.py)                                                    | [Medium](./Readme/0129-sum-root-to-leaf-numbers.md)                                                    |
| 0130 | [Surrounded Regions](https://leetcode.com/problems/surrounded-regions/)                                                                                                                   | [Python](./Python/0130-surrounded-regions.py)                                                          | [Medium](./Readme/0130-surrounded-regions.md)                                                          |
| 0131 | [Palindrome Partitioning](https://leetcode.com/problems/palindrome-partitioning/)                                                                                                         | [Python](./Python/0131-palindrome-partitioning.py)                                                     | [Medium](./Readme/0131-palindrome-partitioning.md)                                                     |
| 0133 | [Clone Graph](https://leetcode.com/problems/clone-graph/)                                                                                                                                 | [Python](./Python/0133-clone-graph.py)                                                                 | [Medium](./Readme/0133-clone-graph.md)                                                                 |
| 0134 | [Gas Station](https://leetcode.com/problems/gas-station/)                                                                                                                                 | [Python](./Python/0134-gas-station.py)                                                                 | [Medium](./Readme/0134-gas-station.md)                                                                 |
| 0135 | [Candy](https://leetcode.com/problems/candy/)                                                                                                                                             | [Python](./Python/0135-candy.py)                                                                       | [Hard](./Readme/0135-candy.md)                                                                         |
| 0136 | [Single Number](https://leetcode.com/problems/single-number/)                                                                                                                             | [Python](./Python/0136-single-number.py)                                                               | [Easy](./Readme/0136-single-number.md)                                                                 |
| 0137 | [Single Number II](https://leetcode.com/problems/single-number-ii/)                                                                                                                       | [Python](./Python/0137-single-number-ii.py)                                                            | [Medium](./Readme/0137-single-number-ii.md)                                                            |
| 0138 | [Copy List with Random Pointer](https://leetcode.com/problems/copy-list-with-random-pointer/)                                                                                             | [Python](./Python/0138-copy-list-with-random-pointer.py)                                               | [Medium](./Readme/0138-copy-list-with-random-pointer.md)                                               |
| 0139 | [Word Break](https://leetcode.com/problems/word-break/)                                                                                                                                   | [Python](./Python/0139-word-break.py)                                                                  | [Medium](./Readme/0139-word-break.md)                                                                  |
| 0140 | [Word Break II](https://leetcode.com/problems/word-break-ii/)                                                                                                                             | [Python](./Python/0140-word-break-ii.py)                                                               | [Hard](./Readme/0140-word-break-ii.md)                                                                 |
| 0141 | [Linked List Cycle](https://leetcode.com/problems/linked-list-cycle/)                                                                                                                     | [Python](./Python/0141-linked-list-cycle.py)                                                           | [Easy](./Readme/0141-linked-list-cycle.md)                                                             |
| 0142 | [Linked List Cycle II](https://leetcode.com/problems/linked-list-cycle-ii/)                                                                                                               | [Python](./Python/0142-linked-list-cycle-ii.py)                                                        | [Medium](./Readme/0142-linked-list-cycle-ii.md)                                                        |
| 0143 | [Reorder List](https://leetcode.com/problems/reorder-list/)                                                                                                                               | [Python](./Python/0143-reorder-list.py)                                                                | [Medium](./Readme/0143-reorder-list.md)                                                                |
| 0144 | [Binary Tree Preorder Traversal](https://leetcode.com/problems/binary-tree-preorder-traversal/)                                                                                           | [Python](./Python/0144-binary-tree-preorder-traversal.py)                                              | [Easy](./Readme/0144-binary-tree-preorder-traversal.md)                                                |
| 0145 | [Binary Tree Postorder Traversal](https://leetcode.com/problems/binary-tree-postorder-traversal/)                                                                                         | [Python](./Python/0145-binary-tree-postorder-traversal.py)                                             | [Easy](./Readme/0145-binary-tree-postorder-traversal.md)                                               |
| 0146 | [LRU Cache](https://leetcode.com/problems/lru-cache/)                                                                                                                                     | [Python](./Python/0146-lru-cache.py)                                                                   | [Medium](./Readme/0146-lru-cache.md)                                                                   |
| 0148 | [Sort List](https://leetcode.com/problems/sort-list/)                                                                                                                                     | [Python](./Python/0148-sort-list.py)                                                                   | [Medium](./Readme/0148-sort-list.md)                                                                   |
| 0149 | [Max Points on a Line](https://leetcode.com/problems/max-points-on-a-line/)                                                                                                               | [Python](./Python/0149-max-points-on-a-line.py)                                                        | [Hard](./Readme/0149-max-points-on-a-line.md)                                                          |
| 0150 | [Evaluate Reverse Polish Notation](https://leetcode.com/problems/evaluate-reverse-polish-notation/)                                                                                       | [Python](./Python/0150-evaluate-reverse-polish-notation.py)                                            | [Medium](./Readme/0150-evaluate-reverse-polish-notation.md)                                            |
| 0151 | [Reverse Words in a String](https://leetcode.com/problems/reverse-words-in-a-string/)                                                                                                     | [Python](./Python/0151-reverse-words-in-a-string.py)                                                   | [Medium](./Readme/0151-reverse-words-in-a-string.md)                                                   |
| 0152 | [Maximum Product Subarray](https://leetcode.com/problems/maximum-product-subarray/)                                                                                                       | [Python](./Python/0152-maximum-product-subarray.py)                                                    | [Medium](./Readme/0152-maximum-product-subarray.md)                                                    |
| 0153 | [Find Minimum in Rotated Sorted Array](https://leetcode.com/problems/find-minimum-in-rotated-sorted-array/)                                                                               | [Python](./Python/0153-find-minimum-in-rotated-sorted-array.py)                                        | [Medium](./Readme/0153-find-minimum-in-rotated-sorted-array.md)                                        |
| 0155 | [Min Stack](https://leetcode.com/problems/min-stack/)                                                                                                                                     | [Python](./Python/0155-min-stack.py)                                                                   | [Easy](./Readme/0155-min-stack.md)                                                                     |
| 0159 | [Longest Substring with At Most Two Distinct Characters](https://leetcode.com/problems/longest-substring-with-at-most-two-distinct-characters/)                                           | [Python](./Python/0159-longest-substring-with-at-most-two-distinct-characters.py)                      | [Medium](./Readme/0159-longest-substring-with-at-most-two-distinct-characters.md)                      |
| 0160 | [Intersection of Two Linked Lists](https://leetcode.com/problems/intersection-of-two-linked-lists/)                                                                                       | [Python](./Python/0160-intersection-of-two-linked-lists.py)                                            | [Easy](./Readme/0160-intersection-of-two-linked-lists.md)                                              |
| 0162 | [Find Peak Element](https://leetcode.com/problems/find-peak-element/)                                                                                                                     | [Python](./Python/0162-find-peak-element.py)                                                           | [Medium](./Readme/0162-find-peak-element.md)                                                           |
| 0165 | [Compare Version Numbers](https://leetcode.com/problems/compare-version-numbers/)                                                                                                         | [Python](./Python/0165-compare-version-numbers.py)                                                     | [Medium](./Readme/0165-compare-version-numbers.md)                                                     |
| 0166 | [Fraction to Recurring Decimal](https://leetcode.com/problems/fraction-to-recurring-decimal)                                                                                              | [Python](./Python/0166-fraction-to-recurring-decimal.py)                                               | [Medium](./Readme/0166-fraction-to-recurring-decimal.md)                                               |
| 0167 | [Two Sum II - Input array is sorted](https://leetcode.com/problems/two-sum-ii-input-array-is-sorted/)                                                                                     | [Python](./Python/0167-two-sum-ii-input-array-is-sorted.py)                                            | [Easy](./Readme/0167-two-sum-ii-input-array-is-sorted.md)                                              |
| 0168 | [Excel Sheet Column Title](https://leetcode.com/problems/excel-sheet-column-title/)                                                                                                       | [Python](./Python/0168-excel-sheet-column-title.py)                                                    | [Easy](./Readme/0168-excel-sheet-column-title.md)                                                      |
| 0169 | [Majority Element](https://leetcode.com/problems/majority-element/)                                                                                                                       | [Python](./Python/0169-majority-element.py)                                                            | [Easy](./Readme/0169-majority-element.md)                                                              |
| 0172 | [Factorial Trailing Zeroes](https://leetcode.com/problems/factorial-trailing-zeroes/)                                                                                                     | [Python](./Python/0172-factorial-trailing-zeroes.py)                                                   | [Medium](./Readme/0172-factorial-trailing-zeroes.md)                                                   |
| 0173 | [Binary Search Tree Iterator](https://leetcode.com/problems/binary-search-tree-iterator/)                                                                                                 | [Python](./Python/0173-binary-search-tree-iterator.py)                                                 | [Medium](./Readme/0173-binary-search-tree-iterator.md)                                                 |
| 0179 | [Largest Number](https://leetcode.com/problems/largest-number/)                                                                                                                           | [Python](./Python/0179-largest-number.py)                                                              | [Medium](./Readme/0179-largest-number.md)                                                              |
| 0188 | [Best Time to Buy and Sell Stock IV](https://leetcode.com/problems/best-time-to-buy-and-sell-stock-iv/)                                                                                   | [Python](./Python/0188-best-time-to-buy-and-sell-stock-iv.py)                                          | [Hard](./Readme/0188-best-time-to-buy-and-sell-stock-iv.md)                                            |
| 0189 | [Rotate Array](https://leetcode.com/problems/rotate-array/)                                                                                                                               | [C++](./C++/0189-rotate-array.cpp)                                                                     | [Medium](./Readme/0189-rotate-array.md)                                                                |
| 0190 | [Reverse Bits](https://leetcode.com/problems/reverse-bits/)                                                                                                                               | [Python](./Python/0190-reverse-bits.py)                                                                | [Easy](./Readme/0190-reverse-bits.md)                                                                  |
| 0191 | [Number of 1 Bits](https://leetcode.com/problems/number-of-1-bits/)                                                                                                                       | [Python](./Python/0191-number-of-1-bits.py)                                                            | [Easy](./Readme/0191-number-of-1-bits.md)                                                              |
| 0198 | [House Robber](https://leetcode.com/problems/house-robber/)                                                                                                                               | [Python](./Python/0198-house-robber.py)                                                                | [Easy](./Readme/0198-house-robber.md)                                                                  |
| 0199 | [Binary Tree Right Side View](https://leetcode.com/problems/binary-tree-right-side-view/)                                                                                                 | [Python](./Python/0199-binary-tree-right-side-view.py)                                                 | [Medium](./Readme/0199-binary-tree-right-side-view.md)                                                 |
| 0200 | [Number of Islands](https://leetcode.com/problems/number-of-islands/)                                                                                                                     | [Python](./Python/0200-number-of-islands.py)                                                           | [Medium](./Readme/0200-number-of-islands.md)                                                           |
| 0201 | [Bitwise AND of Numbers Range](https://leetcode.com/problems/bitwise-and-of-numbers-range/)                                                                                               | [Python](./Python/0201-bitwise-and-of-numbers-range.py)                                                | [Medium](./Readme/0201-bitwise-and-of-numbers-range.md)                                                |
| 0202 | [Happy Number](https://leetcode.com/problems/happy-number/)                                                                                                                               | [Python](./Python/0202-happy-number.py)                                                                | [Easy](./Readme/0202-happy-number.md)                                                                  |
| 0203 | [Remove Linked List Elements](https://leetcode.com/problems/remove-linked-list-elements/)                                                                                                 | [C++](./C++/0203-remove-linked-list-elements.cpp)                                                      | [Easy](./Readme/0203-remove-linked-list-elements.md)                                                   |
| 0205 | [Isomorphic Strings](https://leetcode.com/problems/isomorphic-strings/)                                                                                                                   | [Python](./Python/0205-isomorphic-strings.py)                                                          | [Easy](./Readme/0205-isomorphic-strings.md)                                                            |
| 0206 | [Reverse Linked List](https://leetcode.com/problems/reverse-linked-list/)                                                                                                                 | [Python](./Python/0206-reverse-linked-list.py)                                                         | [Easy](./Readme/0206-reverse-linked-list.md)                                                           |
| 0207 | [Course Schedule](https://leetcode.com/problems/course-schedule/)                                                                                                                         | [Python](./Python/0207-course-schedule.py)                                                             | [Medium](./Readme/0207-course-schedule.md)                                                             |
| 0208 | [Implement Trie (Prefix Tree)](https://leetcode.com/problems/implement-trie-prefix-tree/)                                                                                                 | [Python](./Python/0208-implement-trie-prefix-tree.py)                                                  | [Medium](./Readme/0208-implement-trie-prefix-tree.md)                                                  |
| 0209 | [Minimum Size Subarray Sum](https://leetcode.com/problems/minimum-size-subarray-sum/)                                                                                                     | [Python](./Python/0209-minimum-size-subarray-sum.py)                                                   | [Medium](./Readme/0209-minimum-size-subarray-sum.md)                                                   |
| 0210 | [Course Schedule II](https://leetcode.com/problems/course-schedule-ii/)                                                                                                                   | [Python](./Python/0210-course-schedule-ii.py)                                                          | [Medium](./Readme/0210-course-schedule-ii.md)                                                          |
| 0211 | [Design Add and Search Words Data Structure](https://leetcode.com/problems/design-add-and-search-words-data-structure/)                                                                   | [Python](./Python/0211-design-add-and-search-words-data-structure.py)                                  | [Medium](./Readme/0211-design-add-and-search-words-data-structure.md)                                  |
| 0212 | [Word Search II](https://leetcode.com/problems/word-search-ii/)                                                                                                                           | [Python](./Python/0212-word-search-ii.py)                                                              | [Hard](./Readme/0212-word-search-ii.md)                                                                |
| 0213 | [House Robber II](https://leetcode.com/problems/house-robber-ii/)                                                                                                                         | [C++](./C++/0213-house-robber-ii.cpp)                                                                  | [Medium](./Readme/0213-house-robber-ii.md)                                                             |
| 0214 | [Shortest Palindrome](https://leetcode.com/problems/shortest-palindrome/)                                                                                                                 | [Python](./Python/0214-shortest-palindrome.py)                                                         | [Hard](./Readme/0214-shortest-palindrome.md)                                                           |
| 0215 | [Kth Largest Element in an Array](https://leetcode.com/problems/kth-largest-element-in-an-array/)                                                                                         | [Python](./Python/0215-kth-largest-element-in-an-array.py)                                             | [Medium](./Readme/0215-kth-largest-element-in-an-array.md)                                             |
| 0216 | [Combination Sum III](https://leetcode.com/problems/combination-sum-iii/)                                                                                                                 | [Python](./Python/0216-combination-sum-iii.py)                                                         | [Medium](./Readme/0216-combination-sum-iii.md)                                                         |
| 0217 | [Contains Duplicate](https://leetcode.com/problems/contains-duplicate/)                                                                                                                   | [Python](./Python/0217-contains-duplicate.py)                                                          | [Easy](./Readme/0217-contains-duplicate.md)                                                            |
| 0219 | [Contains Duplicate II](https://leetcode.com/problems/contains-duplicate-ii/)                                                                                                             | [Python](./Python/0219-contains-duplicate-ii.py)                                                       | [Easy](./Readme/0219-contains-duplicate-ii.md)                                                         |
| 0221 | [Maximal Square](https://leetcode.com/problems/maximal-square/)                                                                                                                           | [Python](./Python/0221-maximal-square.py)                                                              | [Medium](./Readme/0221-maximal-square.md)                                                              |
| 0222 | [Count Complete Tree Nodes](https://leetcode.com/problems/count-complete-tree-nodes/)                                                                                                     | [Python](./Python/0222-count-complete-tree-nodes.py)                                                   | [Easy](./Readme/0222-count-complete-tree-nodes.md)                                                     |
| 0224 | [Basic Calculator](https://leetcode.com/problems/basic-calculator/)                                                                                                                       | [Python](./Python/0224-basic-calculator.py)                                                            | [Hard](./Readme/0224-basic-calculator.md)                                                              |
| 0225 | [Implement Stack using Queues](https://leetcode.com/problems/implement-stack-using-queues/)                                                                                               | [Python](./Python/0225-implement-stack-using-queues.py)                                                | [Easy](./Readme/0225-implement-stack-using-queues.md)                                                  |
| 0226 | [Invert Binary Tree](https://leetcode.com/problems/invert-binary-tree/)                                                                                                                   | [Python](./Python/0226-invert-binary-tree.py)                                                          | [Easy](./Readme/0226-invert-binary-tree.md)                                                            |
| 0227 | [Basic Calculator II](https://leetcode.com/problems/basic-calculator-ii/)                                                                                                                 | [Python](./Python/0227-basic-calculator-ii.py)                                                         | [Medium](./Readme/0227-basic-calculator-ii.md)                                                         |
| 0228 | [Summary Ranges](https://leetcode.com/problems/summary-ranges/)                                                                                                                           | [Python](./Python/0228-summary-ranges.py)                                                              | [Easy](./Readme/0228-summary-ranges.md)                                                                |
| 0229 | [Majority Element II](https://leetcode.com/problems/majority-element-ii/)                                                                                                                 | [Python](./Python/0229-majority-element-ii.py)                                                         | [Medium](./Readme/0229-majority-element-ii.md)                                                         |
| 0230 | [Kth Smallest Element in a BST](https://leetcode.com/problems/kth-smallest-element-in-a-bst/)                                                                                             | [Python](./Python/0230-kth-smallest-element-in-a-bst.py)                                               | [Medium](./Readme/0230-kth-smallest-element-in-a-bst.md)                                               |
| 0231 | [Power of Two](https://leetcode.com/problems/power-of-two/)                                                                                                                               | [C++](./C++/0231-power-of-two.cpp)                                                                     | [Easy](./Readme/0231-power-of-two.md)                                                                  |
| 0232 | [Implement Queue using Stacks](https://leetcode.com/problems/implement-queue-using-stacks/)                                                                                               | [Python](./Python/0232-implement-queue-using-stacks.py)                                                | [Easy](./Readme/0232-implement-queue-using-stacks.md)                                                  |
| 0234 | [Palindrome Linked List](https://leetcode.com/problems/palindrome-linked-list/)                                                                                                           | [Python](./Python/0234-palindrome-linked-list.py)                                                      | [Easy](./Readme/0234-palindrome-linked-list.md)                                                        |
| 0235 | [Lowest Common Ancestor of a Binary Search Tree](https://leetcode.com/problems/lowest-common-ancestor-of-a-binary-search-tree/)                                                           | [Python](./Python/0235-lowest-common-ancestor-of-a-binary-search-tree.py)                              | [Easy](./Readme/0235-lowest-common-ancestor-of-a-binary-search-tree.md)                                |
| 0236 | [Lowest Common Ancestor of a Binary Tree](https://leetcode.com/problems/lowest-common-ancestor-of-a-binary-tree/)                                                                         | [Python](./Python/0236-lowest-common-ancestor-of-a-binary-tree.py)                                     | [Medium](./Readme/0236-lowest-common-ancestor-of-a-binary-tree.md)                                     |
| 0237 | [Delete Node in a Linked List](https://leetcode.com/problems/delete-node-in-a-linked-list/)                                                                                               | [Python](./Python/0237-delete-node-in-a-linked-list.py)                                                | [Medium](./Readme/0237-delete-node-in-a-linked-list.md)                                                |
| 0238 | [Product of Array Except Self](https://leetcode.com/problems/product-of-array-except-self/)                                                                                               | [Python](./Python/0238-product-of-array-except-self.py)                                                | [Medium](./Readme/0238-product-of-array-except-self.md)                                                |
| 0239 | [Sliding Window Maximum](https://leetcode.com/problems/sliding-window-maximum/)                                                                                                           | [Python](./Python/0239-sliding-window-maximum.py)                                                      | [Hard](./Readme/0239-sliding-window-maximum.md)                                                        |
| 0240 | [Search a 2D Matrix II](https://leetcode.com/problems/search-a-2d-matrix-ii/)                                                                                                             | [Python](./Python/0240-search-a-2d-matrix-ii.py)                                                       | [Medium](./Readme/0240-search-a-2d-matrix-ii.md)                                                       |
| 0241 | [Different Ways to Add Parentheses](https://leetcode.com/problems/different-ways-to-add-parentheses/)                                                                                     | [Python](./Python/0241-different-ways-to-add-parentheses.py)                                           | [Medium](./Readme/0241-different-ways-to-add-parentheses.md)                                           |
| 0242 | [Valid Anagram](https://leetcode.com/problems/valid-anagram/)                                                                                                                             | [Python](./Python/0242-valid-anagram.py)                                                               | [Easy](./Readme/0242-valid-anagram.md)                                                                 |
| 0249 | [Group Shifted Strings](https://leetcode.com/problems/group-shifted-strings)                                                                                                              | [Python](./Python/0249-group-shifted-strings.py)                                                       | [Medium](./Readme/0249-group-shifted-strings.md)                                                       |
| 0252 | [Meeting Rooms](https://leetcode.com/problems/meeting-rooms/)                                                                                                                             | [Python](./Python/0252-meeting-rooms.py)                                                               | [Easy](./Readme/0252-meeting-rooms.md)                                                                 |
| 0253 | [Meeting Rooms II](https://leetcode.com/problems/meeting-rooms-ii/)                                                                                                                       | [Python](./Python/0253-meeting-rooms-ii.py)                                                            | [Medium](./Readme/0253-meeting-rooms-ii.md)                                                            |
| 0255 | [Verify Preorder Sequence in Binary Search Tree](https://leetcode.com/problems/verify-preorder-sequence-in-binary-search-tree/)                                                           | [Python](./Python/0255-verify-preorder-sequence-in-binary-search-tree.py)                              | [Medium](./Readme/0255-verify-preorder-sequence-in-binary-search-tree.md)                              |
| 0256 | [Paint House](https://leetcode.com/problems/paint-house/)                                                                                                                                 | [Python](./Python/0256-paint-house.py)                                                                 | [Medium](./Readme/0256-paint-house.md)                                                                 |
| 0259 | [3Sum Smaller](https://leetcode.com/problems/3sum-smaller/)                                                                                                                               | [Python](./Python/0259-3sum-smaller.py)                                                                | [Medium](./Readme/0259-3sum-smaller.md)                                                                |
| 0260 | [Single Number III](https://leetcode.com/problems/single-number-iii/)                                                                                                                     | [Python](./Python/0260-single-number-iii.py)                                                           | [Medium](./Readme/0260-single-number-iii.md)                                                           |
| 0261 | [Graph Valid Tree](https://leetcode.com/problems/graph-valid-tree/)                                                                                                                       | [Python](./Python/0261-graph-valid-tree.py)                                                            | [Medium](./Readme/0261-graph-valid-tree.md)                                                            |
| 0263 | [Ugly Number](https://leetcode.com/problems/ugly-number/)                                                                                                                                 | [Python](./Python/0263-ugly-number.py)                                                                 | [Easy](./Readme/0263-ugly-number.md)                                                                   |
| 0264 | [Ugly Number II](https://leetcode.com/problems/ugly-number-ii/)                                                                                                                           | [Python](./Python/0264-ugly-number-ii.py)                                                              | [Medium](./Readme/0264-ugly-number-ii.md)                                                              |
| 0265 | [Paint House II](https://leetcode.com/problems/paint-house-ii)                                                                                                                            | [Python](./Python/0265-paint-house-ii.py)                                                              | [Hard](./Readme/0265-paint-house-ii.md)                                                                |
| 0268 | [Missing Number](https://leetcode.com/problems/missing-number/)                                                                                                                           | [Python](./Python/0268-missing-number.py)                                                              | [Easy](./Readme/0268-missing-number.md)                                                                |
| 0269 | [Alien Dictionary](https://leetcode.com/problems/alien-dictionary/)                                                                                                                       | [Python](./Python/0269-alien-dictionary.py)                                                            | [Hard](./Readme/0269-alien-dictionary.md)                                                              |
| 0271 | [Encode and Decode Strings](https://leetcode.com/problems/encode-and-decode-strings/)                                                                                                     | [Python](./Python/0271-encode-and-decode-strings.py)                                                   | [Medium](./Readme/0271-encode-and-decode-strings.md)                                                   |
| 0273 | [Integer to English Words](https://leetcode.com/problems/integer-to-english-words/)                                                                                                       | [Python](./Python/0273-integer-to-english-words.py)                                                    | [Hard](./Readme/0273-integer-to-english-words.md)                                                      |
| 0274 | [H-Index](https://leetcode.com/problems/h-index/)                                                                                                                                         | [Python](./Python/0274-h-index.py)                                                                     | [Medium](./Readme/0274-h-index.md)                                                                     |
| 0276 | [Paint Fence](https://leetcode.com/problems/paint-fence/)                                                                                                                                 | [Python](./Python/0276-paint-fence.py)                                                                 | [Medium](./Readme/0276-paint-fence.md)                                                                 |
| 0277 | [Find the Celebrity](https://leetcode.com/problems/find-the-celebrity)                                                                                                                    | [Python](./Python/0277-find-the-celebrity.py)                                                          | [Medium](./Readme/0277-find-the-celebrity.md)                                                          |
| 0278 | [First Bad Version](https://leetcode.com/problems/first-bad-version/)                                                                                                                     | [Python](./Python/0278-first-bad-version.py)                                                           | [Easy](./Readme/0278-first-bad-version.md)                                                             |
| 0279 | [Perfect Squares](https://leetcode.com/problems/perfect-squares/)                                                                                                                         | [Python](./Python/0279-perfect-squares.py)                                                             | [Medium](./Readme/0279-perfect-squares.md)                                                             |
| 0283 | [Move Zeroes](https://leetcode.com/problems/move-zeroes/)                                                                                                                                 | [C++](./C++/0283-move-zeroes.cpp)                                                                      | [Easy](./Readme/0283-move-zeroes.md)                                                                   |
| 0285 | [Inorder Successor in BST](https://leetcode.com/problems/inorder-successor-in-bst/)                                                                                                       | [Python](./Python/0285-inorder-successor-in-bst.py)                                                    | [Medium](./Readme/0285-inorder-successor-in-bst.md)                                                    |
| 0286 | [Walls and Gates](https://leetcode.com/problems/walls-and-gates/)                                                                                                                         | [Python](./Python/0286-walls-and-gates.py)                                                             | [Medium](./Readme/0286-walls-and-gates.md)                                                             |
| 0287 | [Find the Duplicate Number](https://leetcode.com/problems/find-the-duplicate-number/)                                                                                                     | [Python](./Python/0287-find-the-duplicate-number.py)                                                   | [Medium](./Readme/0287-find-the-duplicate-number.md)                                                   |
| 0290 | [Word Pattern](https://leetcode.com/problems/word-pattern/)                                                                                                                               | [Python](./Python/0290-word-pattern.py)                                                                | [Easy](./Readme/0290-word-pattern.md)                                                                  |
| 0291 | [Word Pattern II](https://leetcode.com/problems/word-pattern-ii/)                                                                                                                         | [Python](./Python/0291-word-pattern-ii.py)                                                             | [Medium](./Readme/0291-word-pattern-ii.md)                                                             |
| 0293 | [Flip Game](https://leetcode.com/problems/flip-game/)                                                                                                                                     | [Python](./Python/0293-flip-game.py)                                                                   | [Easy](./Readme/0293-flip-game.md)                                                                     |
| 0295 | [Find Median from Data Stream](https://leetcode.com/problems/find-median-from-data-stream/)                                                                                               | [Python](./Python/0295-find-median-from-data-stream.py)                                                | [Hard](./Readme/0295-find-median-from-data-stream.md)                                                  |
| 0296 | [Best Meeting Point](https://leetcode.com/problems/best-meeting-point/)                                                                                                                   | [Python](./Python/0296-best-meeting-point.py)                                                          | [Hard](./Readme/0296-best-meeting-point.md)                                                            |
| 0297 | [Serialize and Deserialize Binary Tree](https://leetcode.com/problems/serialize-and-deserialize-binary-tree/)                                                                             | [Python](./Python/0297-serialize-and-deserialize-binary-tree.py)                                       | [Hard](./Readme/0297-serialize-and-deserialize-binary-tree.md)                                         |
| 0299 | [Bulls and Cows](https://leetcode.com/problems/bulls-and-cows/)                                                                                                                           | [Python](./Python/0299-bulls-and-cows.py)                                                              | [Medium](./Readme/0299-bulls-and-cows.md)                                                              |
| 0300 | [Longest Increasing Subsequence](https://leetcode.com/problems/longest-increasing-subsequence/)                                                                                           | [Python](./Python/0300-longest-increasing-subsequence.py)                                              | [Medium](./Readme/0300-longest-increasing-subsequence.md)                                              |
| 0304 | [Range Sum Query 2D - Immutable](https://leetcode.com/problems/range-sum-query-2d-immutable)                                                                                              | [Python](./Python/0304-range-sum-query-2d-immutable.py)                                                | [Medium](./Readme/0304-range-sum-query-2d-immutable.md)                                                |
| 0305 | [Number of Islands II](https://leetcode.com/problems/number-of-islands-ii/)                                                                                                               | [Python](./Python/0305-number-of-islands-ii.py)                                                        | [Hard](./Readme/0305-number-of-islands-ii.md)                                                          |
| 0309 | [Best Time to Buy and Sell Stock with Cooldown](https://leetcode.com/problems/best-time-to-buy-and-sell-stock-with-cooldown/)                                                             | [Python](./Python/0309-best-time-to-buy-and-sell-stock-with-cooldown.py)                               | [Medium](./Readme/0309-best-time-to-buy-and-sell-stock-with-cooldown.md)                               |
| 0310 | [Minimum Height Trees](https://leetcode.com/problems/minimum-height-trees/)                                                                                                               | [Python](./Python/0310-minimum-height-trees.py)                                                        | [Medium](./Readme/0310-minimum-height-trees.md)                                                        |
| 0312 | [Burst Balloons](https://leetcode.com/problems/burst-balloons/)                                                                                                                           | [Python](./Python/0312-burst-balloons.py)                                                              | [Hard](./Readme/0312-burst-balloons.md)                                                                |
| 0316 | [Remove Duplicate Letters](https://leetcode.com/problems/remove-duplicate-letters/)                                                                                                       | [Python](./Python/0316-remove-duplicate-letters.py)                                                    | [Hard](./Readme/0316-remove-duplicate-letters.md)                                                      |
| 0320 | [Generalized Abbreviation](https://leetcode.com/problems/generalized-abbreviation/)                                                                                                       | [Python](./Python/0320-generalized-abbreviation.py)                                                    | [Medium](./Readme/0320-generalized-abbreviation.md)                                                    |
| 0322 | [Coin Change](https://leetcode.com/problems/coin-change/)                                                                                                                                 | [Python](./Python/0322-coin-change.py)                                                                 | [Medium](./Readme/0322-coin-change.md)                                                                 |
| 0323 | [Number of Connected Components in an Undirected Graph](https://leetcode.com/problems/number-of-connected-components-in-an-undirected-graph/)                                             | [Python](./Python/0323-number-of-connected-components-in-an-undirected-graph.py)                       | [Medium](./Readme/0323-number-of-connected-components-in-an-undirected-graph.md)                       |
| 0328 | [Odd Even Linked List](https://leetcode.com/problems/odd-even-linked-list/)                                                                                                               | [Python](./Python/0328-odd-even-linked-list.py)                                                        | [Medium](./Readme/0328-odd-even-linked-list.md)                                                        |
| 0329 | [Longest Increasing Path in a Matrix](https://leetcode.com/problems/longest-increasing-path-in-a-matrix/)                                                                                 | [Python](./Python/0329-longest-increasing-path-in-a-matrix.py)                                         | [Hard](./Readme/0329-longest-increasing-path-in-a-matrix.md)                                           |
| 0330 | [Patching Array](https://leetcode.com/problems/patching-array/)                                                                                                                           | [Python](./Python/0330-patching-array.py)                                                              | [Hard](./Readme/0330-patching-array.md)                                                                |
| 0332 | [Reconstruct Itinerary](https://leetcode.com/problems/reconstruct-itinerary/)                                                                                                             | [Python](./Python/0332-reconstruct-itinerary.py)                                                       | [Medium](./Readme/0332-reconstruct-itinerary.md)                                                       |
| 0334 | [Increasing Triplet Subsequence](https://leetcode.com/problems/increasing-triplet-subsequence/)                                                                                           | [Python](./Python/0334-increasing-triplet-subsequence.py)                                              | [Medium](./Readme/0334-increasing-triplet-subsequence.md)                                              |
| 0338 | [Counting Bits](https://leetcode.com/problems/counting-bits/)                                                                                                                             | [Python](./Python/0338-counting-bits.py)                                                               | [Medium](./Readme/0338-counting-bits.md)                                                               |
| 0340 | [Longest Substring with At Most K Distinct Characters](https://leetcode.com/problems/longest-substring-with-at-most-k-distinct-characters/)                                               | [Python](./Python/0340-longest-substring-with-at-most-k-distinct-characters.py)                        | [Medium](./Readme/0340-longest-substring-with-at-most-k-distinct-characters.md)                        |
| 0341 | [Flatten Nested List Iterator](https://leetcode.com/problems/flatten-nested-list-iterator/)                                                                                               | [Python](./Python/0341-flatten-nested-list-iterator.py)                                                | [Medium](./Readme/0341-flatten-nested-list-iterator.md)                                                |
| 0342 | [Power of Four](https://leetcode.com/problems/power-of-four/)                                                                                                                             | [Python](./Python/0342-power-of-four.py)                                                               | [Easy](./Readme/0342-power-of-four.md)                                                                 |
| 0343 | [Integer Break](https://leetcode.com/problems/integer-break/)                                                                                                                             | [Python](./Python/0343-integer-break.py)                                                               | [Medium](./Readme/0343-integer-break.md)                                                               |
| 0344 | [Reverse String](https://leetcode.com/problems/reverse-string/)                                                                                                                           | [Python](./Python/0344-reverse-string.py)                                                              | [Easy](./Readme/0344-reverse-string.md)                                                                |
| 0345 | [Reverse Vowels of a String](https://leetcode.com/problems/reverse-vowels-of-a-string/)                                                                                                   | [Python](./Python/0345-reverse-vowels-of-a-string.py)                                                  | [Easy](./Readme/0345-reverse-vowels-of-a-string.md)                                                    |
| 0346 | [Moving Average from Data Stream](https://leetcode.com/problems/moving-average-from-data-stream/)                                                                                         | [Python](./Python/0346-moving-average-from-data-stream.py)                                             | [Easy](./Readme/0346-moving-average-from-data-stream.md)                                               |
| 0347 | [Top K Frequent Elements](https://leetcode.com/problems/top-k-frequent-elements/)                                                                                                         | [Python](./Python/0347-top-k-frequent-elements.py)                                                     | [Medium](./Readme/0347-top-k-frequent-elements.md)                                                     |
| 0349 | [Intersection of Two Arrays](https://leetcode.com/problems/intersection-of-two-arrays/)                                                                                                   | [Python](./Python/0349-intersection-of-two-arrays.py)                                                  | [Easy](./Readme/0349-intersection-of-two-arrays.md)                                                    |
| 0350 | [Intersection of Two Arrays II](https://leetcode.com/problems/intersection-of-two-arrays-ii/)                                                                                             | [Python](./Python/0350-intersection-of-two-arrays-ii.py)                                               | [Easy](./Readme/0350-intersection-of-two-arrays-ii.md)                                                 |
| 0351 | [Android Unlock Patterns](https://leetcode.com/problems/android-unlock-patterns/)                                                                                                         | [Python](./Python/0351-android-unlock-patterns.py)                                                     | [Medium](./Readme/0351-android-unlock-patterns.md)                                                     |
| 0355 | [Design Twitter](https://leetcode.com/problems/design-twitter/)                                                                                                                           | [Python](./Python/0355-design-twitter.py)                                                              | [Medium](./Readme/0355-design-twitter.md)                                                              |
| 0358 | [Rearrange String k Distance Apart](https://leetcode.com/problems/rearrange-string-k-distance-apart/)                                                                                     | [Python](./Python/0358-rearrange-string-k-distance-apart.py)                                           | [Hard](./Readme/0358-rearrange-string-k-distance-apart.md)                                             |
| 0362 | [Design Hit Counter](https://leetcode.com/problems/design-hit-counter/)                                                                                                                   | [Python](./Python/0362-design-hit-counter.py)                                                          | [Medium](./Readme/0362-design-hit-counter.md)                                                          |
| 0366 | [Find Leaves of Binary Tree](https://leetcode.com/problems/find-leaves-of-binary-tree)                                                                                                    | [Python](./Python/0366-find-leaves-of-binary-tree.py)                                                  | [Medium](./Readme/0366-find-leaves-of-binary-tree.md)                                                  |
| 0368 | [Largest Divisible Subset](https://leetcode.com/problems/largest-divisible-subset/)                                                                                                       | [Python](./Python/0368-largest-divisible-subset.py)                                                    | [Medium](./Readme/0368-largest-divisible-subset.md)                                                    |
| 0371 | [Sum of Two Integers](https://leetcode.com/problems/sum-of-two-integers/)                                                                                                                 | [Python](./Python/0371-sum-of-two-integers.py)                                                         | [Medium](./Readme/0371-sum-of-two-integers.md)                                                         |
| 0373 | [Find K Pairs with Smallest Sums](https://leetcode.com/problems/find-k-pairs-with-smallest-sums/)                                                                                         | [Python](./Python/0373-find-k-pairs-with-smallest-sums.py)                                             | [Medium](./Readme/0373-find-k-pairs-with-smallest-sums.md)                                             |
| 0374 | [Guess Number Higher or Lower](https://leetcode.com/problems/guess-number-higher-or-lower/)                                                                                               | [Python](./Python/0374-guess-number-higher-or-lower.py)                                                | [Easy](./Readme/0374-guess-number-higher-or-lower.md)                                                  |
| 0377 | [Combination Sum IV](https://leetcode.com/problems/combination-sum-iv/)                                                                                                                   | [Python](./Python/0377-combination-sum-iv.py)                                                          | [Medium](./Readme/0377-combination-sum-iv.md)                                                          |
| 0380 | [Insert Delete GetRandom O(1)](https://leetcode.com/problems/insert-delete-getrandom-o1/)                                                                                                 | [Python](./Python/0380-insert-delete-getrandom-o1.py)                                                  | [Medium](./Readme/0380-insert-delete-getrandom-o1.md)                                                  |
| 0383 | [Ransom Note](https://leetcode.com/problems/ransom-note/)                                                                                                                                 | [Python](./Python/0383-ransom-note.py)                                                                 | [Easy](./Readme/0383-ransom-note.md)                                                                   |
| 0386 | [Lexicographical Numbers](https://leetcode.com/problems/lexicographical-numbers/)                                                                                                         | [Python](./Python/0386-lexicographical-numbers.py)                                                     | [Medium](./Readme/0386-lexicographical-numbers.md)                                                     |
| 0387 | [First Unique Character in a String](https://leetcode.com/problems/first-unique-character-in-a-string/)                                                                                   | [Python](./Python/0387-first-unique-character-in-a-string.py)                                          | [Easy](./Readme/0387-first-unique-character-in-a-string.md)                                            |
| 0388 | [Longest Absolute File Path](https://leetcode.com/problems/longest-absolute-file-path)                                                                                                    | [Python](./Python/0388-longest-absolute-file-path.py)                                                  | [Medium](./Readme/0388-longest-absolute-file-path.md)                                                  |
| 0389 | [Find the Difference](https://leetcode.com/problems/find-the-difference/)                                                                                                                 | [Python](./Python/0389-find-the-difference.py)                                                         | [Easy](./Readme/0389-find-the-difference.md)                                                           |
| 0390 | [Elimination Game](https://leetcode.com/problems/elimination-game)                                                                                                                        | [Python](./Python/0390-elimination-game.py)                                                            | [Medium](./Readme/0390-elimination-game.md)                                                            |
| 0391 | [Perfect Rectangle](https://leetcode.com/problems/perfect-rectangle)                                                                                                                      | [Python](./Python/0391-perfect-rectangle.py)                                                           | [Hard](./Readme/0391-perfect-rectangle.md)                                                             |
| 0392 | [Is Subsequence](https://leetcode.com/problems/is-subsequence/)                                                                                                                           | [Python](./Python/0392-is-subsequence.py)                                                              | [Easy](./Readme/0392-is-subsequence.md)                                                                |
| 0393 | [UTF-8 Validation](https://leetcode.com/problems/utf-8-validation)                                                                                                                        | [Python](./Python/0393-utf-8-validation.py)                                                            | [Medium](./Readme/0393-utf-8-validation.md)                                                            |
| 0394 | [Decode String](https://leetcode.com/problems/decode-string/)                                                                                                                             | [Python](./Python/0394-decode-string.py)                                                               | [Medium](./Readme/0394-decode-string.md)                                                               |
| 0395 | [Longest Substring with At Least K Repeating Characters](https://leetcode.com/problems/longest-substring-with-at-least-k-repeating-characters)                                            | [Python](./Python/0395-longest-substring-with-at-least-k-repeating-characters.py)                      | [Medium](./Readme/0395-longest-substring-with-at-least-k-repeating-characters.md)                      |
| 0396 | [Rotate Function](https://leetcode.com/problems/rotate-function)                                                                                                                          | [Python](./Python/0396-rotate-function.py)                                                             | [Medium](./Readme/0396-rotate-function.md)                                                             |
| 0397 | [Integer Replacement](https://leetcode.com/problems/integer-replacement)                                                                                                                  | [Python](./Python/0397-integer-replacement.py)                                                         | [Medium](./Readme/0397-integer-replacement.md)                                                         |
| 0398 | [Random Pick Index](https://leetcode.com/problems/random-pick-index)                                                                                                                      | [Python](./Python/0398-random-pick-index.py)                                                           | [Medium](./Readme/0398-random-pick-index.md)                                                           |
| 0399 | [Evaluate Division](https://leetcode.com/problems/evaluate-division/)                                                                                                                     | [Python](./Python/0399-evaluate-division.py)                                                           | [Medium](./Readme/0399-evaluate-division.md)                                                           |
| 0400 | [Nth Digit](https://leetcode.com/problems/nth-digit)                                                                                                                                      | [Python](./Python/0400-nth-digit.py)                                                                   | [Medium](./Readme/0400-nth-digit.md)                                                                   |
| 0401 | [Binary Watch](https://leetcode.com/problems/binary-watch)                                                                                                                                | [Python](./Python/0401-binary-watch.py)                                                                | [Easy](./Readme/0401-binary-watch.md)                                                                  |
| 0402 | [Remove K Digits](https://leetcode.com/problems/remove-k-digits/)                                                                                                                         | [Python](./Python/0402-remove-k-digits.py)                                                             | [Medium](./Readme/0402-remove-k-digits.md)                                                             |
| 0403 | [Frog Jump](https://leetcode.com/problems/frog-jump/)                                                                                                                                     | [Python](./Python/0403-frog-jump.py)                                                                   | [Hard](./Readme/0403-frog-jump.md)                                                                     |
| 0404 | [Sum of Left Leaves](https://leetcode.com/problems/sum-of-left-leaves/)                                                                                                                   | [Python](./Python/0404-sum-of-left-leaves.py)                                                          | [Easy](./Readme/0404-sum-of-left-leaves.md)                                                            |
| 0405 | [Convert a Number to Hexadecimal](https://leetcode.com/problems/convert-a-number-to-hexadecimal)                                                                                          | [Python](./Python/0405-convert-a-number-to-hexadecimal.py)                                             | [Easy](./Readme/0405-convert-a-number-to-hexadecimal.md)                                               |
| 0406 | [Queue Reconstruction by Height](https://leetcode.com/problems/queue-reconstruction-by-height)                                                                                            | [Python](./Python/0406-queue-reconstruction-by-height.py)                                              | [Medium](./Readme/0406-queue-reconstruction-by-height.md)                                              |
| 0407 | [Trapping Rain Water II](https://leetcode.com/problems/trapping-rain-water-ii)                                                                                                            | [Python](./Python/0407-trapping-rain-water-ii.py)                                                      | [Hard](./Readme/0407-trapping-rain-water-ii.md)                                                        |
| 0408 | [Valid Word Abbreviation](https://leetcode.com/problems/valid-word-abbreviation)                                                                                                          | [Python](./Python/0408-valid-word-abbreviation.py)                                                     | [Easy](./Readme/0408-valid-word-abbreviation.md)                                                       |
| 0409 | [Longest Palindrome](https://leetcode.com/problems/longest-palindrome/)                                                                                                                   | [Python](./Python/0409-longest-palindrome.py)                                                          | [Easy](./Readme/0409-longest-palindrome.md)                                                            |
| 0416 | [Partition Equal Subset Sum](https://leetcode.com/problems/partition-equal-subset-sum/)                                                                                                   | [Python](./Python/0416-partition-equal-subset-sum.py)                                                  | [Medium](./Readme/0416-partition-equal-subset-sum.md)                                                  |
| 0417 | [Pacific Atlantic Water Flow](https://leetcode.com/problems/pacific-atlantic-water-flow/)                                                                                                 | [Python](./Python/0417-pacific-atlantic-water-flow.py)                                                 | [Medium](./Readme/0417-pacific-atlantic-water-flow.md)                                                 |
| 0424 | [Longest Repeating Character Replacement](https://leetcode.com/problems/longest-repeating-character-replacement/)                                                                         | [Python](./Python/0424-longest-repeating-character-replacement.py)                                     | [Medium](./Readme/0424-longest-repeating-character-replacement.md)                                     |
| 0426 | [Convert Binary Search Tree to Sorted Doubly Linked List](https://leetcode.com/problems/convert-binary-search-tree-to-sorted-doubly-linked-list)                                          | [Python](./Python/0426-convert-binary-search-tree-to-sorted-doubly-linked-list.py)                     | [Medium](./Readme/0426-convert-binary-search-tree-to-sorted-doubly-linked-list.md)                     |
| 0427 | [Construct Quad Tree](https://leetcode.com/problems/construct-quad-tree/)                                                                                                                 | [Python](./Python/0427-construct-quad-tree.py)                                                         | [Medium](./Readme/0427-construct-quad-tree.md)                                                         |
| 0432 | [All O`one Data Structure](https://leetcode.com/problems/all-oone-data-structure/)                                                                                                        | [Python](./Python/0432-all-oone-data-structure.py)                                                     | [Hard](./Readme/0432-all-oone-data-structure.md)                                                       |
| 0433 | [Minimum Genetic Mutation](https://leetcode.com/problems/minimum-genetic-mutation/)                                                                                                       | [Python](./Python/0433-minimum-genetic-mutation.py)                                                    | [Medium](./Readme/0433-minimum-genetic-mutation.md)                                                    |
| 0435 | [Non-overlapping Intervals](https://leetcode.com/problems/non-overlapping-intervals/)                                                                                                     | [Python](./Python/0435-non-overlapping-intervals.py)                                                   | [Medium](./Readme/0435-non-overlapping-intervals.md)                                                   |
| 0437 | [Path Sum III](https://leetcode.com/problems/path-sum-iii/)                                                                                                                               | [Python](./Python/0437-path-sum-iii.py)                                                                | [Medium](./Readme/0437-path-sum-iii.md)                                                                |
| 0438 | [Find All Anagrams in a String](https://leetcode.com/problems/find-all-anagrams-in-a-string/)                                                                                             | [Python](./Python/0438-find-all-anagrams-in-a-string.py)                                               | [Medium](./Readme/0438-find-all-anagrams-in-a-string.md)                                               |
| 0439 | [Ternary Expression Parser](https://leetcode.com/problems/ternary-expression-parser/)                                                                                                     | [Python](./Python/0439-ternary-expression-parser.py)                                                   | [Medium](./Readme/0439-ternary-expression-parser.md)                                                   |
| 0440 | [K-th Smallest in Lexicographical Order](https://leetcode.com/problems/k-th-smallest-in-lexicographical-order/)                                                                           | [Python](./Python/0440-k-th-smallest-in-lexicographical-order.py)                                      | [Hard](./Readme/0440-k-th-smallest-in-lexicographical-order.md)                                        |
| 0442 | [Find All Duplicates in an Array](https://leetcode.com/problems/find-all-duplicates-in-an-array/)                                                                                         | [Python](./Python/0442-find-all-duplicates-in-an-array.py)                                             | [Medium](./Readme/0442-find-all-duplicates-in-an-array.md)                                             |
| 0443 | [String Compression](https://leetcode.com/problems/string-compression/)                                                                                                                   | [Python](./Python/0443-string-compression.py)                                                          | [Medium](./Readme/0443-string-compression.md)                                                          |
| 0446 | [Arithmetic Slices II - Subsequence](https://leetcode.com/problems/arithmetic-slices-ii-subsequence/)                                                                                     | [Python](./Python/0446-arithmetic-slices-ii-subsequence.py)                                            | [Hard](./Readme/0446-arithmetic-slices-ii-subsequence.md)                                              |
| 0450 | [Delete Node in a BST](https://leetcode.com/problems/delete-node-in-a-bst/)                                                                                                               | [Python](./Python/0450-delete-node-in-a-bst.py)                                                        | [Medium](./Readme/0450-delete-node-in-a-bst.md)                                                        |
| 0451 | [Sort Characters By Frequency](https://leetcode.com/problems/sort-characters-by-frequency/)                                                                                               | [Python](./Python/0451-sort-characters-by-frequency.py)                                                | [Medium](./Readme/0451-sort-characters-by-frequency.md)                                                |
| 0452 | [Minimum Number of Arrows to Burst Balloons](https://leetcode.com/problems/minimum-number-of-arrows-to-burst-balloons/)                                                                   | [Python](./Python/0452-minimum-number-of-arrows-to-burst-balloons.py)                                  | [Medium](./Readme/0452-minimum-number-of-arrows-to-burst-balloons.md)                                  |
| 0455 | [Assign Cookies](https://leetcode.com/problems/assign-cookies/)                                                                                                                           | [Python](./Python/0455-assign-cookies.py)                                                              | [Easy](./Readme/0455-assign-cookies.md)                                                                |
| 0456 | [132 Pattern](https://leetcode.com/problems/132-pattern/)                                                                                                                                 | [Python](./Python/0456-132-pattern.py)                                                                 | [Medium](./Readme/0456-132-pattern.md)                                                                 |
| 0458 | [Poor Pigs](https://leetcode.com/problems/poor-pigs/)                                                                                                                                     | [Python](./Python/0458-poor-pigs.py)                                                                   | [Hard](./Readme/0458-poor-pigs.md)                                                                     |
| 0459 | [Repeated Substring Pattern](https://leetcode.com/problems/repeated-substring-pattern/)                                                                                                   | [Python](./Python/0459-repeated-substring-pattern.py)                                                  | [Easy](./Readme/0459-repeated-substring-pattern.md)                                                    |
| 0463 | [Island Perimeter](https://leetcode.com/problems/island-perimeter/)                                                                                                                       | [Python](./Python/0463-island-perimeter.py)                                                            | [Easy](./Readme/0463-island-perimeter.md)                                                              |
| 0473 | [Matchsticks to Square](https://leetcode.com/problems/matchsticks-to-square/)                                                                                                             | [Python](./Python/0473-matchsticks-to-square.py)                                                       | [Medium](./Readme/0473-matchsticks-to-square.md)                                                       |
| 0476 | [Number Complement](https://leetcode.com/problems/number-complement/)                                                                                                                     | [Python](./Python/0476-number-complement.py)                                                           | [Easy](./Readme/0476-number-complement.md)                                                             |
| 0486 | [Predict the Winner](https://leetcode.com/problems/predict-the-winner/)                                                                                                                   | [Python](./Python/0486-predict-the-winner.py)                                                          | [Medium](./Readme/0486-predict-the-winner.md)                                                          |
| 0487 | [Max Consecutive Ones II](https://leetcode.com/problems/max-consecutive-ones-ii/)                                                                                                         | [Python](./Python/0487-max-consecutive-ones-ii.py)                                                     | [Medium](./Readme/0487-max-consecutive-ones-ii.md)                                                     |
| 0489 | [Robot Room Cleaner](https://leetcode.com/problems/robot-room-cleaner)                                                                                                                    | [Python](./Python/0489-robot-room-cleaner.py)                                                          | [Hard](./Readme/0489-robot-room-cleaner.md)                                                            |
| 0490 | [The Maze](https://leetcode.com/problems/the-maze/)                                                                                                                                       | [Python](./Python/0490-the-maze.py)                                                                    | [Medium](./Readme/0490-the-maze.md)                                                                    |
| 0494 | [Target Sum](https://leetcode.com/problems/target-sum/)                                                                                                                                   | [Python](./Python/0494-target-sum.py)                                                                  | [Medium](./Readme/0494-target-sum.md)                                                                  |
| 0501 | [Find Mode in Binary Search Tree](https://leetcode.com/problems/find-mode-in-binary-search-tree/)                                                                                         | [Python](./Python/0501-find-mode-in-binary-search-tree.py)                                             | [Easy](./Readme/0501-find-mode-in-binary-search-tree.md)                                               |
| 0502 | [IPO](https://leetcode.com/problems/ipo/)                                                                                                                                                 | [Python](./Python/0502-ipo.py)                                                                         | [Hard](./Readme/0502-ipo.md)                                                                           |
| 0505 | [The Maze II](https://leetcode.com/problems/the-maze-ii/)                                                                                                                                 | [Python](./Python/0505-the-maze-ii.py)                                                                 | [Medium](./Readme/0505-the-maze-ii.md)                                                                 |
| 0506 | [Relative Ranks](https://leetcode.com/problems/relative-ranks/)                                                                                                                           | [Python](./Python/0506-relative-ranks.py)                                                              | [Easy](./Readme/0506-relative-ranks.md)                                                                |
| 0509 | [Fibonacci Number](https://leetcode.com/problems/fibonacci-number/)                                                                                                                       | [Python](./Python/0509-fibonacci-number.py)                                                            | [Easy](./Readme/0509-fibonacci-number.md)                                                              |
| 0513 | [Find Bottom Left Tree Value](https://leetcode.com/problems/find-bottom-left-tree-value/)                                                                                                 | [Python](./Python/0513-find-bottom-left-tree-value.py)                                                 | [Medium](./Readme/0513-find-bottom-left-tree-value.md)                                                 |
| 0514 | [Freedom Trail](https://leetcode.com/problems/freedom-trail/)                                                                                                                             | [Python](./Python/0514-freedom-trail.py)                                                               | [Hard](./Readme/0514-freedom-trail.md)                                                                 |
| 0515 | [Find Largest Value in Each Tree Row](https://leetcode.com/problems/find-largest-value-in-each-tree-row/)                                                                                 | [Python](./Python/0515-find-largest-value-in-each-tree-row.py)                                         | [Medium](./Readme/0515-find-largest-value-in-each-tree-row.md)                                         |
| 0516 | [Longest Palindromic Subsequence](https://leetcode.com/problems/longest-palindromic-subsequence)                                                                                          | [Python](./Python/0516-longest-palindromic-subsequence.py)                                             | [Medium](./Readme/0516-longest-palindromic-subsequence.md)                                             |
| 0518 | [Coin Change 2](https://leetcode.com/problems/coin-change-2/)                                                                                                                             | [Python](./Python/0518-coin-change-2.py)                                                               | [Medium](./Readme/0518-coin-change-2.md)                                                               |
| 0523 | [Continuous Subarray Sum](https://leetcode.com/problems/continuous-subarray-sum/)                                                                                                         | [Python](./Python/0523-continuous-subarray-sum.py)                                                     | [Medium](./Readme/0523-continuous-subarray-sum.md)                                                     |
| 0525 | [Contiguous Array](https://leetcode.com/problems/contiguous-array/)                                                                                                                       | [Python](./Python/0525-contiguous-array.py)                                                            | [Medium](./Readme/0525-contiguous-array.md)                                                            |
| 0528 | [Random Pick with Weight](https://leetcode.com/problems/random-pick-with-weight/)                                                                                                         | [Python](./Python/0528-random-pick-with-weight.py)                                                     | [Medium](./Readme/0528-random-pick-with-weight.md)                                                     |
| 0530 | [Minimum Absolute Difference in BST](https://leetcode.com/problems/minimum-absolute-difference-in-bst/)                                                                                   | [Python](./Python/0530-minimum-absolute-difference-in-bst.py)                                          | [Easy](./Readme/0530-minimum-absolute-difference-in-bst.md)                                            |
| 0532 | [K-diff Pairs in an Array](https://leetcode.com/problems/k-diff-pairs-in-an-array/)                                                                                                       | [Python](./Python/0532-k-diff-pairs-in-an-array.py)                                                    | [Easy](./Readme/0532-k-diff-pairs-in-an-array.md)                                                      |
| 0539 | [Minimum Time Difference](https://leetcode.com/problems/minimum-time-difference/)                                                                                                         | [Python](./Python/0539-minimum-time-difference.py)                                                     | [Medium](./Readme/0539-minimum-time-difference.md)                                                     |
| 0540 | [Single Element in a Sorted Array](https://leetcode.com/problems/single-element-in-a-sorted-array/)                                                                                       | [Python](./Python/0540-single-element-in-a-sorted-array.py)                                            | [Medium](./Readme/0540-single-element-in-a-sorted-array.md)                                            |
| 0542 | [01 Matrix](https://leetcode.com/problems/01-matrix/)                                                                                                                                     | [Python](./Python/0542-01-matrix.py)                                                                   | [Medium](./Readme/0542-01-matrix.md)                                                                   |
| 0543 | [Diameter of Binary Tree](https://leetcode.com/problems/diameter-of-binary-tree/)                                                                                                         | [Python](./Python/0543-diameter-of-binary-tree.py)                                                     | [Easy](./Readme/0543-diameter-of-binary-tree.md)                                                       |
| 0545 | [Boundary of Binary Tree](https://leetcode.com/problems/boundary-of-binary-tree/)                                                                                                         | [Python](./Python/0545-boundary-of-binary-tree.py)                                                     | [Medium](./Readme/0545-boundary-of-binary-tree.md)                                                     |
| 0547 | [Number of Provinces](https://leetcode.com/problems/number-of-provinces/)                                                                                                                 | [Python](./Python/0547-number-of-provinces.py)                                                         | [Medium](./Readme/0547-number-of-provinces.md)                                                         |
| 0552 | [Student Attendance Record II](https://leetcode.com/problems/student-attendance-record-ii/)                                                                                               | [Python](./Python/0552-student-attendance-record-ii.py)                                                | [Hard](./Readme/0552-student-attendance-record-ii.md)                                                  |
| 0557 | [Reverse Words in a String III](https://leetcode.com/problems/reverse-words-in-a-string-iii/)                                                                                             | [C++](./C++/0557-reverse-words-in-a-string-iii.cpp)                                                    | [Easy](./Readme/0557-reverse-words-in-a-string-iii.md)                                                 |
| 0560 | [Subarray Sum Equals K](https://leetcode.com/problems/subarray-sum-equals-k/)                                                                                                             | [Python](./Python/0560-subarray-sum-equals-k.py)                                                       | [Medium](./Readme/0560-subarray-sum-equals-k.md)                                                       |
| 0561 | [Array Partition I](https://leetcode.com/problems/array-partition-i/)                                                                                                                     | [Python](./Python/0561-array-partition-i.py)                                                           | [Easy](./Readme/0561-array-partition-i.md)                                                             |
| 0564 | [Find the Closest Palindrome](https://leetcode.com/problems/find-the-closest-palindrome/)                                                                                                 | [Python](./Python/0564-find-the-closest-palindrome.py)                                                 | [Hard](./Readme/0564-find-the-closest-palindrome.md)                                                   |
| 0566 | [Reshape the Matrix](https://leetcode.com/problems/reshape-the-matrix/)                                                                                                                   | [C++](./C++/0566-reshape-the-matrix.cpp)                                                               | [Easy](./Readme/0566-reshape-the-matrix.md)                                                            |
| 0567 | [Permutation in String](https://leetcode.com/problems/permutation-in-string/)                                                                                                             | [Python](./Python/0567-permutation-in-string.py)                                                       | [Medium](./Readme/0567-permutation-in-string.md)                                                       |
| 0570 | [Managers with at Least 5 Direct Reports](https://leetcode.com/problems/managers-with-at-least-5-direct-reports/)                                                                         | [SQL](./SQL/0570-managers-with-at-least-5-direct-reports.sql)                                          | [Medium](./Readme/0570-managers-with-at-least-5-direct-reports.md)                                     |
| 0572 | [Subtree of Another Tree](https://leetcode.com/problems/subtree-of-another-tree/)                                                                                                         | [Python](./Python/0572-subtree-of-another-tree.py)                                                     | [Easy](./Readme/0572-subtree-of-another-tree.md)                                                       |
| 0573 | [Squirrel Simulation](https://leetcode.com/problems/squirrel-simulation/)                                                                                                                 | [Python](./Python/0573-squirrel-simulation.py)                                                         | [Medium](./Readme/0573-squirrel-simulation.md)                                                         |
| 0576 | [Out of Boundary Paths](https://leetcode.com/problems/out-of-boundary-paths/)                                                                                                             | [Python](./Python/0576-out-of-boundary-paths.py)                                                       | [Medium](./Readme/0576-out-of-boundary-paths.md)                                                       |
| 0577 | [Employee Bonus](https://leetcode.com/problems/employee-bonus/)                                                                                                                           | [SQL](./SQL/0577-employee-bonus.sql)                                                                   | [Easy](./Readme/0577-employee-bonus.md)                                                                |
| 0584 | [Find Customer Referee](https://leetcode.com/problems/find-customer-referee/)                                                                                                             | [SQL](./SQL/0584-find-customer-referee.sql)                                                            | [Easy](./Readme/0584-find-customer-referee.md)                                                         |
| 0588 | [Design In-Memory File System](https://leetcode.com/problems/design-in-memory-file-system/)                                                                                               | [Python](./Python/0588-design-in-memory-file-system.py)                                                | [Hard](./Readme/0588-design-in-memory-file-system.md)                                                  |
| 0590 | [N-ary Tree Postorder Traversal](https://leetcode.com/problems/n-ary-tree-postorder-traversal/)                                                                                           | [Python](./Python/0590-n-ary-tree-postorder-traversal.py)                                              | [Easy](./Readme/0590-n-ary-tree-postorder-traversal.md)                                                |
| 0592 | [Fraction Addition and Subtraction](https://leetcode.com/problems/fraction-addition-and-subtraction/)                                                                                     | [Python](./Python/0592-fraction-addition-and-subtraction.py)                                           | [Medium](./Readme/0592-fraction-addition-and-subtraction.md)                                           |
| 0595 | [Big Countries](https://leetcode.com/problems/big-countries/)                                                                                                                             | [SQL](./SQL/0595-big-countries.sql)                                                                    | [Easy](./Readme/0595-big-countries.md)                                                                 |
| 0605 | [Can Place Flowers](https://leetcode.com/problems/can-place-flowers/)                                                                                                                     | [Python](./Python/0605-can-place-flowers.py)                                                           | [Easy](./Readme/0605-can-place-flowers.md)                                                             |
| 0606 | [Construct String from Binary Tree](https://leetcode.com/problems/construct-string-from-binary-tree/)                                                                                     | [Python](./Python/0606-construct-string-from-binary-tree.py)                                           | [Easy](./Readme/0606-construct-string-from-binary-tree.md)                                             |
| 0617 | [Merge Two Binary Trees](https://leetcode.com/problems/merge-two-binary-trees/)                                                                                                           | [C++](./C++/0617-merge-two-binary-trees.cpp)                                                           | [Easy](./Readme/0617-merge-two-binary-trees.md)                                                        |
| 0620 | [Not Boring Movies](https://leetcode.com/problems/not-boring-movies/)                                                                                                                     | [SQL](./SQL/0620-not-boring-movies.sql)                                                                | [Easy](./Readme/0620-not-boring-movies.md)                                                             |
| 0621 | [Task Scheduler](https://leetcode.com/problems/task-scheduler/)                                                                                                                           | [Python](./Python/0621-task-scheduler.py)                                                              | [Medium](./Readme/0621-task-scheduler.md)                                                              |
| 0623 | [Add One Row to Tree](https://leetcode.com/problems/add-one-row-to-tree/)                                                                                                                 | [Python](./Python/0623-add-one-row-to-tree.py)                                                         | [Medium](./Readme/0623-add-one-row-to-tree.md)                                                         |
| 0624 | [Maximum Distance in Arrays](https://leetcode.com/problems/maximum-distance-in-arrays/)                                                                                                   | [Python](./Python/0624-maximum-distance-in-arrays.py)                                                  | [Easy](./Readme/0624-maximum-distance-in-arrays.md)                                                    |
| 0629 | [K Inverse Pairs Array](https://leetcode.com/problems/k-inverse-pairs-array/)                                                                                                             | [Python](./Python/0629-k-inverse-pairs-array.py)                                                       | [Hard](./Readme/0629-k-inverse-pairs-array.md)                                                         |
| 0632 | [Smallest Range Covering Elements from K Lists](https://leetcode.com/problems/smallest-range-covering-elements-from-k-lists/)                                                             | [Python](./Python/0632-smallest-range-covering-elements-from-k-lists.py)                               | [Hard](./                                                                                              |
| 0633 | [Sum of Square Numbers](https://leetcode.com/problems/sum-of-square-numbers/)                                                                                                             | [Python](./Python/0633-sum-of-square-numbers.py)                                                       | [Medium](./Readme/0633-sum-of-square-numbers.md)                                                       |
| 0637 | [Average of Levels in Binary Tree](https://leetcode.com/problems/average-of-levels-in-binary-tree/)                                                                                       | [Python](./Python/0637-average-of-levels-in-binary-tree.py)                                            | [Easy](./Readme/0637-average-of-levels-in-binary-tree.md)                                              |
| 0641 | [Design Circular Deque](https://leetcode.com/problems/design-circular-deque/)                                                                                                             | [Python](./Python/0641-design-circular-deque.py)                                                       | [Medium](./Readme/0641-design-circular-deque.md)                                                       |
| 0643 | [Maximum Average Subarray I](https://leetcode.com/problems/maximum-average-subarray-i/)                                                                                                   | [Python](./Python/0643-maximum-average-subarray-i.py)                                                  | [Easy](./Readme/0643-maximum-average-subarray-i.md)                                                    |
| 0645 | [Set Mismatch](https://leetcode.com/problems/set-mismatch/)                                                                                                                               | [Python](./Python/0645-set-mismatch.py)                                                                | [Easy](./Readme/0645-set-mismatch.md)                                                                  |
| 0646 | [Maximum Length of Pair Chain](https://leetcode.com/problems/maximum-length-of-pair-chain/)                                                                                               | [Python](./Python/0646-maximum-length-of-pair-chain.py)                                                | [Medium](./Readme/0646-maximum-length-of-pair-chain.md)                                                |
| 0647 | [Palindromic Substrings](https://leetcode.com/problems/palindromic-substrings/)                                                                                                           | [Python](./Python/0647-palindromic-substrings.py)                                                      | [Medium](./Readme/0647-palindromic-substrings.md)                                                      |
| 0648 | [Replace Words](https://leetcode.com/problems/replace-words/)                                                                                                                             | [Python](./Python/0648-replace-words.py)                                                               | [Medium](./Readme/0648-replace-words.md)                                                               |
| 0649 | [Dota2 Senate](https://leetcode.com/problems/dota2-senate/)                                                                                                                               | [Python](./Python/0649-dota2-senate.py)                                                                | [Medium](./Readme/0649-dota2-senate.md)                                                                |
| 0650 | [2 Keys Keyboard](https://leetcode.com/problems/2-keys-keyboard/)                                                                                                                         | [Python](./Python/0650-2-keys-keyboard.py)                                                             | [Medium](./Readme/0650-2-keys-keyboard.md)                                                             |
| 0653 | [Two Sum IV - Input is a BST](https://leetcode.com/problems/two-sum-iv-input-is-a-bst/)                                                                                                   | [C++](./C++/0653-two-sum-iv-input-is-a-bst.cpp)                                                        | [Easy](./Readme/0653-two-sum-iv-input-is-a-bst.md)                                                     |
| 0658 | [Find K Closest Elements](https://leetcode.com/problems/find-k-closest-elements/)                                                                                                         | [Python](./Python/0658-find-k-closest-elements.py)                                                     | [Medium](./Readme/0658-find-k-closest-elements.md)                                                     |
| 0661 | [Image Smoother](https://leetcode.com/problems/image-smoother/)                                                                                                                           | [Python](./Python/0661-image-smoother.py)                                                              | [Easy](./Readme/0661-image-smoother.md)                                                                |
| 0662 | [Maximum Width of Binary Tree](https://leetcode.com/problems/maximum-width-of-binary-tree/)                                                                                               | [Python](./Python/0662-maximum-width-of-binary-tree.py)                                                | [Medium](./Readme/0662-maximum-width-of-binary-tree.md)                                                |
| 0664 | [Strange Printer](https://leetcode.com/problems/strange-printer/)                                                                                                                         | [Python](./Python/0664-strange-printer.py)                                                             | [Hard](./Readme/0664-strange-printer.md)                                                               |
| 0666 | [Path Sum IV](https://leetcode.com/problems/path-sum-iv/)                                                                                                                                 | [Python](./Python/0666-path-sum-iv.py)                                                                 | [Medium](./Readme/0666-path-sum-iv.md)                                                                 |
| 0670 | [Maximum Swap](https://leetcode.com/problems/maximum-swap)                                                                                                                                | [Python](./Python/0670-maximum-swap.py)                                                                | [Medium](./Readme/0670-maximum-swap.md)                                                                |
| 0678 | [Valid Parenthesis String](https://leetcode.com/problems/valid-parenthesis-string/)                                                                                                       | [Python](./Python/0678-valid-parenthesis-string.py)                                                    | [Medium](./Readme/0678-valid-parenthesis-string.md)                                                    |
| 0684 | [Redundant Connection](https://leetcode.com/problems/redundant-connection/)                                                                                                               | [Python](./Python/0684-redundant-connection.py)                                                        | [Medium](./Readme/0684-redundant-connection.md)                                                        |
| 0692 | [Top K Frequent Words](https://leetcode.com/problems/top-k-frequent-words/)                                                                                                               | [Python](./Python/0692-top-k-frequent-words.py)                                                        | [Medium](./Readme/0692-top-k-frequent-words.md)                                                        |
| 0694 | [Number of Distinct Islands](https://leetcode.com/problems/number-of-distinct-islands/)                                                                                                   | [Python](./Python/0694-number-of-distinct-islands.py)                                                  | [Medium](./Readme/0694-number-of-distinct-islands.md)                                                  |
| 0695 | [Max Area of Island](https://leetcode.com/problems/max-area-of-island/)                                                                                                                   | [C++](./C++/0695-max-area-of-island.cpp)                                                               | [Medium](./Readme/0695-max-area-of-island.md)                                                          |
| 0700 | [Search in a Binary Search Tree](https://leetcode.com/problems/search-in-a-binary-search-tree/)                                                                                           | [C++](./C++/0700-search-in-a-binary-search-tree.cpp)                                                   | [Easy](./Readme/0700-search-in-a-binary-search-tree.md)                                                |
| 0701 | [Insert into a Binary Search Tree](https://leetcode.com/problems/insert-into-a-binary-search-tree/)                                                                                       | [C++](./C++/0701-insert-into-a-binary-search-tree.cpp)                                                 | [Medium](./Readme/0701-insert-into-a-binary-search-tree.md)                                            |
| 0703 | [Kth Largest Element in a Stream](https://leetcode.com/problems/kth-largest-element-in-a-stream/)                                                                                         | [Python](./Python/0703-kth-largest-element-in-a-stream.py)                                             | [Easy](./Readme/0703-kth-largest-element-in-a-stream.md)                                               |
| 0704 | [Binary Search](https://leetcode.com/problems/binary-search/)                                                                                                                             | [Pythoon](./Pythoon/0704-binary-search.py)                                                             | [Easy](./Readme/0704-binary-search.md)                                                                 |
| 0706 | [Design HashMap](https://leetcode.com/problems/design-hashmap/)                                                                                                                           | [Python](./Python/0706-design-hashmap.py)                                                              | [Easy](./Readme/0706-design-hashmap.md)                                                                |
| 0712 | [Minimum ASCII Delete Sum for Two Strings](https://leetcode.com/problems/minimum-ascii-delete-sum-for-two-strings/)                                                                       | [Python](./Python/0712-minimum-ascii-delete-sum-for-two-strings.py)                                    | [Medium](./Readme/0712-minimum-ascii-delete-sum-for-two-strings.md)                                    |
| 0713 | [Subarray Product Less Than K](https://leetcode.com/problems/subarray-product-less-than-k/)                                                                                               | [Python](./Python/0713-subarray-product-less-than-k.py)                                                | [Medium](./Readme/0713-subarray-product-less-than-k.md)                                                |
| 0714 | [Best Time to Buy and Sell Stock with Transaction Fee](https://leetcode.com/problems/best-time-to-buy-and-sell-stock-with-transaction-fee/)                                               | [Python](./Python/0714-best-time-to-buy-and-sell-stock-with-transaction-fee.py)                        | [Medium](./Readme/0714-best-time-to-buy-and-sell-stock-with-transaction-fee.md)                        |
| 0718 | [Maximum Length of Repeated Subarray](https://leetcode.com/problems/maximum-length-of-repeated-subarray/)                                                                                 | [Python](./Python/0718-maximum-length-of-repeated-subarray.py)                                         | [Medium](./Readme/0718-maximum-length-of-repeated-subarray.md)                                         |
| 0719 | [Find K-th Smallest Pair Distance](https://leetcode.com/problems/find-k-th-smallest-pair-distance/)                                                                                       | [Python](./Python/0719-find-k-th-smallest-pair-distance.py)                                            | [Hard](./Readme/0719-find-k-th-smallest-pair-distance.md)                                              |
| 0721 | [Accounts Merge](https://leetcode.com/problems/accounts-merge/)                                                                                                                           | [Python](./Python/0721-accounts-merge.py)                                                              | [Medium](./Readme/0721-accounts-merge.md)                                                              |
| 0723 | [Candy Crush](https://leetcode.com/problems/candy-crush/)                                                                                                                                 | [Python](./Python/0723-candy-crush.py)                                                                 | [Medium](./Readme/0723-candy-crush.md)                                                                 |
| 0724 | [Find Pivot Index](https://leetcode.com/problems/find-pivot-index/)                                                                                                                       | [Python](./Python/0724-find-pivot-index.py)                                                            | [Easy](./Readme/0724-find-pivot-index.md)                                                              |
| 0725 | [Split Linked List in Parts](https://leetcode.com/problems/split-linked-list-in-parts/)                                                                                                   | [Python](./Python/0725-split-linked-list-in-parts.py)                                                  | [Medium](./Readme/0725-split-linked-list-in-parts.md)                                                  |
| 0726 | [Number of Atoms](https://leetcode.com/problems/number-of-atoms/)                                                                                                                         | [Python](./Python/0726-number-of-atoms.py)                                                             | [Hard](./Readme/0726-number-of-atoms.md)                                                               |
| 0729 | [My Calendar I](https://leetcode.com/problems/my-calendar-i/)                                                                                                                             | [Python](./Python/0729-my-calendar-i.py)                                                               | [Medium](./Readme/0729-my-calendar-i.md)                                                               |
| 0731 | [My Calendar II](https://leetcode.com/problems/my-calendar-ii/)                                                                                                                           | [Python](./Python/0731-my-calendar-ii.py)                                                              | [Medium](./Readme/0731-my-calendar-ii.md)                                                              |
| 0733 | [Flood Fill](https://leetcode.com/problems/flood-fill/)                                                                                                                                   | [Python](./Python/0733-flood-fill.py)                                                                  | [Easy](./Readme/0733-flood-fill.md)                                                                    |
| 0734 | [Sentence Similarity](https://leetcode.com/problems/sentence-similarity/)                                                                                                                 | [Python](./Python/0734-sentence-similarity.py)                                                         | [Easy](./Readme/0734-sentence-similarity.md)                                                           |
| 0735 | [Asteroid Collision](https://leetcode.com/problems/asteroid-collision/)                                                                                                                   | [Python](./Python/0735-asteroid-collision.py)                                                          | [Medium](./Readme/0735-asteroid-collision.md)                                                          |
| 0737 | [Sentence Similarity II](https://leetcode.com/problems/sentence-similarity-ii/)                                                                                                           | [Python](./Python/0737-sentence-similarity-ii.py)                                                      | [Medium](./Readme/0737-sentence-similarity-ii.md)                                                      |
| 0739 | [Daily Temperatures](https://leetcode.com/problems/daily-temperatures/)                                                                                                                   | [Python](./Python/0739-daily-temperatures.py)                                                          | [Medium](./Readme/0739-daily-temperatures.md)                                                          |
| 0740 | [Delete and Earn](https://leetcode.com/problems/delete-and-earn/)                                                                                                                         | [Python](./Python/0740-delete-and-earn.py)                                                             | [Medium](./Readme/0740-delete-and-earn.md)                                                             |
| 0741 | [Cherry Pickup](https://leetcode.com/problems/cherry-pickup/)                                                                                                                             | [Python](./Python/0741-cherry-pickup.py)                                                               | [Hard](./Readme/0741-cherry-pickup.md)                                                                 |
| 0743 | [Network Delay Time](https://leetcode.com/problems/network-delay-time/)                                                                                                                   | [Python](./Python/0743-network-delay-time.py)                                                          | [Medium](./Readme/0743-network-delay-time.md)                                                          |
| 0744 | [Find Smallest Letter Greater Than Target](https://leetcode.com/problems/find-smallest-letter-greater-than-target/)                                                                       | [Python](./Python/0744-find-smallest-letter-greater-than-target.py)                                    | [Easy](./Readme/0744-find-smallest-letter-greater-than-target.md)                                      |
| 0746 | [Min Cost Climbing Stairs](https://leetcode.com/problems/min-cost-climbing-stairs/)                                                                                                       | [Python](./Python/0746-min-cost-climbing-stairs.py)                                                    | [Easy](./Readme/0746-min-cost-climbing-stairs.md)                                                      |
| 0752 | [Open the Lock](https://leetcode.com/problems/open-the-lock/)                                                                                                                             | [Python](./Python/0752-open-the-lock.py)                                                               | [Medium](./Readme/0752-open-the-lock.md)                                                               |
| 0759 | [Employee Free Time](https://leetcode.com/problems/employee-free-time)                                                                                                                    | [Python](./Python/0759-employee-free-time.py)                                                          | [Hard](./Readme/0759-employee-free-time.md)                                                            |
| 0767 | [Reorganize String](https://leetcode.com/problems/reorganize-string/)                                                                                                                     | [Python](./Python/0767-reorganize-string.py)                                                           | [Medium](./Readme/0767-reorganize-string.md)                                                           |
| 0773 | [Sliding Puzzle](https://leetcode.com/problems/sliding-puzzle)                                                                                                                            | [Python](./Python/0773-sliding-puzzle.py)                                                              | [Hard](./Readme/0773-sliding-puzzle.md)                                                                |
| 0776 | [Split BST](https://leetcode.com/problems/split-bst/)                                                                                                                                     | [Python](./Python/0776-split-bst.py)                                                                   | [Medium](./Readme/0776-split-bst.md)                                                                   |
| 0778 | [Swim in Rising Water](https://leetcode.com/problems/swim-in-rising-water/)                                                                                                               | [Python](./Python/0778-swim-in-rising-water.py)                                                        | [Hard](./Readme/0778-swim-in-rising-water.md)                                                          |
| 0779 | [K-th Symbol in Grammar](https://leetcode.com/problems/k-th-symbol-in-grammar/)                                                                                                           | [Python](./Python/0779-k-th-symbol-in-grammar.py)                                                      | [Medium](./Readme/0779-k-th-symbol-in-grammar.md)                                                      |
| 0784 | [Letter Case Permutation](https://leetcode.com/problems/letter-case-permutation/)                                                                                                         | [C++](./C++/0784-letter-case-permutation.cpp)                                                          | [Medium](./Readme/0784-letter-case-permutation.md)                                                     |
| 0786 | [K-th Smallest Prime Fraction](https://leetcode.com/problems/k-th-smallest-prime-fraction/)                                                                                               | [Python](./Python/0786-k-th-smallest-prime-fraction.py)                                                | [Medium](./Readme/0786-k-th-smallest-prime-fraction.md)                                                |
| 0787 | [Cheapest Flights Within K Stops](https://leetcode.com/problems/cheapest-flights-within-k-stops/)                                                                                         | [Python](./Python/0787-cheapest-flights-within-k-stops.py)                                             | [Medium](./Readme/0787-cheapest-flights-within-k-stops.md)                                             |
| 0790 | [Domino and Tromino Tiling](https://leetcode.com/problems/domino-and-tromino-tiling/)                                                                                                     | [Python](./Python/0790-domino-and-tromino-tiling.py)                                                   | [Medium](./Readme/0790-domino-and-tromino-tiling.md)                                                   |
| 0791 | [Custom Sort String](https://leetcode.com/problems/custom-sort-string/)                                                                                                                   | [Python](./Python/0791-custom-sort-string.py)                                                          | [Medium](./Readme/0791-custom-sort-string.md)                                                          |
| 0797 | [All Paths From Source to Target](https://leetcode.com/problems/all-paths-from-source-to-target/)                                                                                         | [Python](./Python/0797-all-paths-from-source-to-target.py)                                             | [Medium](./Readme/0797-all-paths-from-source-to-target.md)                                             |
| 0799 | [Champagne Tower](https://leetcode.com/problems/champagne-tower/)                                                                                                                         | [Python](./Python/0799-champagne-tower.py)                                                             | [Medium](./Readme/0799-champagne-tower.md)                                                             |
| 0808 | [Soup Servings](https://leetcode.com/problems/soup-servings/)                                                                                                                             | [Python](./Python/0808-soup-servings.py)                                                               | [Medium](./Readme/0808-soup-servings.md)                                                               |
| 0815 | [Bus Routes](https://leetcode.com/problems/bus-routes/)                                                                                                                                   | [Python](./Python/0815-bus-routes.py)                                                                  | [Hard](./Readme/0815-bus-routes.md)                                                                    |
| 0823 | [Binary Trees With Factors](https://leetcode.com/problems/binary-trees-with-factors/)                                                                                                     | [Python](./Python/0823-binary-trees-with-factors.py)                                                   | [Medium](./Readme/0823-binary-trees-with-factors.md)                                                   |
| 0826 | [Most Profit Assigning Work](https://leetcode.com/problems/most-profit-assigning-work/)                                                                                                   | [Python](./Python/0826-most-profit-assigning-work.py)                                                  | [Medium](./Readme/0826-most-profit-assigning-work.md)                                                  |
| 0834 | [Sum of Distances in Tree](https://leetcode.com/problems/sum-of-distances-in-tree/)                                                                                                       | [Python](./Python/0834-sum-of-distances-in-tree.py)                                                    | [Hard](./Readme/0834-sum-of-distances-in-tree.md)                                                      |
| 0840 | [Magic Squares In Grid](https://leetcode.com/problems/magic-squares-in-grid/)                                                                                                             | [Python](./Python/0840-magic-squares-in-grid.py)                                                       | [Medium](./Readme/0840-magic-squares-in-grid.md)                                                       |
| 0841 | [Keys and Rooms](https://leetcode.com/problems/keys-and-rooms/)                                                                                                                           | [Python](./Python/0841-keys-and-rooms.py)                                                              | [Medium](./Readme/0841-keys-and-rooms.md)                                                              |
| 0844 | [Backspace String Compare](https://leetcode.com/problems/backspace-string-compare/)                                                                                                       | [Python](./Python/0844-backspace-string-compare.py)                                                    | [Easy](./Readme/0844-backspace-string-compare.md)                                                      |
| 0846 | [Hand of Straights](https://leetcode.com/problems/hand-of-straights/)                                                                                                                     | [Python](./Python/0846-hand-of-straights.py)                                                           | [Medium](./Readme/0846-hand-of-straights.md)                                                           |
| 0847 | [Shortest Path Visiting All Nodes](https://leetcode.com/problems/shortest-path-visiting-all-nodes/)                                                                                       | [Python](./Python/0847-shortest-path-visiting-all-nodes.py)                                            | [Hard](./Readme/0847-shortest-path-visiting-all-nodes.md)                                              |
| 0852 | [Peak Index in a Mountain Array](https://leetcode.com/problems/peak-index-in-a-mountain-array/)                                                                                           | [Python](./Python/0852-peak-index-in-a-mountain-array.py)                                              | [Easy](./Readme/0852-peak-index-in-a-mountain-array.md)                                                |
| 0857 | [Minimum Cost to Hire K Workers](https://leetcode.com/problems/minimum-cost-to-hire-k-workers/)                                                                                           | [Python](./Python/0857-minimum-cost-to-hire-k-workers.py)                                              | [Hard](./Readme/0857-minimum-cost-to-hire-k-workers.md)                                                |
| 0860 | [Lemonade Change](https://leetcode.com/problems/lemonade-change/)                                                                                                                         | [Python](./Python/0860-lemonade-change.py)                                                             | [Easy](./Readme/0860-lemonade-change.md)                                                               |
| 0861 | [Score After Flipping Matrix](https://leetcode.com/problems/score-after-flipping-matrix/)                                                                                                 | [Python](./Python/0861-score-after-flipping-matrix.py)                                                 | [Medium](./Readme/0861-score-after-flipping-matrix.md)                                                 |
| 0862 | [Shortest Subarray with Sum at Least K](https://leetcode.com/problems/shortest-subarray-with-sum-at-least-k)                                                                              | [Python](./Python/0862-shortest-subarray-with-sum-at-least-k.py)                                       | [Hard](./Readme/0862-shortest-subarray-with-sum-at-least-k.md)                                         |
| 0863 | [All Nodes Distance K in Binary Tree](https://leetcode.com/problems/all-nodes-distance-k-in-binary-tree/)                                                                                 | [Python](./Python/0863-all-nodes-distance-k-in-binary-tree.py)                                         | [Medium](./Readme/0863-all-nodes-distance-k-in-binary-tree.md)                                         |
| 0867 | [Transpose Matrix](https://leetcode.com/problems/transpose-matrix/)                                                                                                                       | [Python](./Python/0867-transpose-matrix.py)                                                            | [Easy](./Readme/0867-transpose-matrix.md)                                                              |
| 0872 | [Leaf-Similar Trees](https://leetcode.com/problems/leaf-similar-trees/)                                                                                                                   | [Python](./Python/0872-leaf-similar-trees.py)                                                          | [Easy](./Readme/0872-leaf-similar-trees.md)                                                            |
| 0874 | [Walking Robot Simulation](https://leetcode.com/problems/walking-robot-simulation/)                                                                                                       | [Python](./Python/0874-walking-robot-simulation.py)                                                    | [Medium](./Readme/0874-walking-robot-simulation.md)                                                    |
| 0875 | [Koko Eating Bananas](https://leetcode.com/problems/koko-eating-bananas/)                                                                                                                 | [Python](./Python/0875-koko-eating-bananas.py)                                                         | [Medium](./Readme/0875-koko-eating-bananas.md)                                                         |
| 0876 | [Middle of the Linked List](https://leetcode.com/problems/middle-of-the-linked-list/)                                                                                                     | [Python](./Python/0876-middle-of-the-linked-list.py)                                                   | [Easy](./Readme/0876-middle-of-the-linked-list.md)                                                     |
| 0880 | [Decoded String at Index](https://leetcode.com/problems/decoded-string-at-index/)                                                                                                         | [Python](./Python/0880-decoded-string-at-index.py)                                                     | [Medium](./Readme/0880-decoded-string-at-index.md)                                                     |
| 0881 | [Boats to Save People](https://leetcode.com/problems/boats-to-save-people/)                                                                                                               | [Python](./Python/0881-boats-to-save-people.py)                                                        | [Medium](./Readme/0881-boats-to-save-people.md)                                                        |
| 0884 | [Uncommon Words from Two Sentences](https://leetcode.com/problems/uncommon-words-from-two-sentences/)                                                                                     | [Python](./Python/0884-uncommon-words-from-two-sentences.py)                                           | [Easy](./Readme/0884-uncommon-words-from-two-sentences.md)                                             |
| 0885 | [Spiral Matrix III](https://leetcode.com/problems/spiral-matrix-iii/)                                                                                                                     | [Python](./Python/0885-spiral-matrix-iii.py)                                                           | [Medium](./Readme/0885-spiral-matrix-iii.md)                                                           |
| 0888 | [Fair Candy Swap](https://leetcode.com/problems/fair-candy-swap/)                                                                                                                         | [Python](./Python/0888-fair-candy-swap.py)                                                             | [Easy](./Readme/0888-fair-candy-swap.md)                                                               |
| 0894 | [All Possible Full Binary Trees](https://leetcode.com/problems/all-possible-full-binary-trees/)                                                                                           | [Python](./Python/0894-all-possible-full-binary-trees.py)                                              | [Medium](./Readme/0894-all-possible-full-binary-trees.md)                                              |
| 0895 | [Maximum Frequency Stack](https://leetcode.com/problems/maximum-frequency-stack/)                                                                                                         | [Python](./Python/0895-maximum-frequency-stack.py)                                                     | [Hard](./Readme/0895-maximum-frequency-stack.md)                                                       |
| 0896 | [Monotonic Array](https://leetcode.com/problems/monotonic-array/)                                                                                                                         | [Python](./Python/0896-monotonic-array.py)                                                             | [Easy](./Readme/0896-monotonic-array.md)                                                               |
| 0901 | [Online Stock Span](https://leetcode.com/problems/online-stock-span/)                                                                                                                     | [Python](./Python/0901-online-stock-span.py)                                                           | [Medium](./Readme/0901-online-stock-span.md)                                                           |
| 0905 | [Sort Array By Parity](https://leetcode.com/problems/sort-array-by-parity/)                                                                                                               | [Python](./Python/0905-sort-array-by-parity.py)                                                        | [Easy](./Readme/0905-sort-array-by-parity.md)                                                          |
| 0907 | [Sum of Subarray Minimums](https://leetcode.com/problems/sum-of-subarray-minimums/)                                                                                                       | [Python](./Python/0907-sum-of-subarray-minimums.py)                                                    | [Medium](./Readme/0907-sum-of-subarray-minimums.md)                                                    |
| 0909 | [Snakes and Ladders](https://leetcode.com/problems/snakes-and-ladders/)                                                                                                                   | [Python](./Python/0909-snakes-and-ladders.py)                                                          | [Medium](./Readme/0909-snakes-and-ladders.md)                                                          |
| 0912 | [Sort an Array](https://leetcode.com/problems/sort-an-array/)                                                                                                                             | [Python](./Python/0912-sort-an-array.py)                                                               | [Medium](./Readme/0912-sort-an-array.md)                                                               |
| 0918 | [Maximum Sum Circular Subarray](https://leetcode.com/problems/maximum-sum-circular-subarray/)                                                                                             | [Python](./Python/0918-maximum-sum-circular-subarray.py)                                               | [Medium](./Readme/0918-maximum-sum-circular-subarray.md)                                               |
| 0920 | [Number of Music Playlists](https://leetcode.com/problems/number-of-music-playlists/)                                                                                                     | [Python](./Python/0920-number-of-music-playlists.py)                                                   | [Hard](./Readme/0920-number-of-music-playlists.md)                                                     |
| 0921 | [Minimum Add to Make Parentheses Valid](https://leetcode.com/problems/minimum-add-to-make-parentheses-valid/)                                                                             | [Python](./Python/0921-minimum-add-to-make-parentheses-valid.py)                                       | [Medium](./Readme/0921-minimum-add-to-make-parentheses-valid.md)                                       |
| 0924 | [Minimize Malware Spread](https://leetcode.com/problems/minimize-malware-spread/)                                                                                                         | [Python](./Python/0924-minimize-malware-spread.py)                                                     | [Hard](./Readme/0924-minimize-malware-spread.md)                                                       |
| 0930 | [Binary Subarrays With Sum](https://leetcode.com/problems/binary-subarrays-with-sum/)                                                                                                     | [Python](./Python/0930-binary-subarrays-with-sum.py)                                                   | [Medium](./Readme/0930-binary-subarrays-with-sum.md)                                                   |
| 0931 | [Minimum Falling Path Sum](https://leetcode.com/problems/minimum-falling-path-sum/)                                                                                                       | [Python](./Python/0931-minimum-falling-path-sum.py)                                                    | [Medium](./Readme/0931-minimum-falling-path-sum.md)                                                    |
| 0933 | [Number of Recent Calls](https://leetcode.com/problems/number-of-recent-calls/)                                                                                                           | [Python](./Python/0933-number-of-recent-calls.py)                                                      | [Easy](./Readme/0933-number-of-recent-calls.md)                                                        |
| 0935 | [Knight Dialer](https://leetcode.com/problems/knight-dialer/)                                                                                                                             | [Python](./Python/0935-knight-dialer.py)                                                               | [Medium](./Readme/0935-knight-dialer.md)                                                               |
| 0938 | [Range Sum of BST](https://leetcode.com/problems/range-sum-of-bst/)                                                                                                                       | [Python](./Python/0938-range-sum-of-bst.py)                                                            | [Easy](./Readme/0938-range-sum-of-bst.md)                                                              |
| 0939 | [Minimum Area Rectangle](https://leetcode.com/problems/minimum-area-rectangle)                                                                                                            | [Python](./Python/0939-minimum-area-rectangle.py)                                                      | [Medium](./Readme/0939-minimum-area-rectangle.md)                                                      |
| 0945 | [Minimum Increment to Make Array Unique](https://leetcode.com/problems/minimum-increment-to-make-array-unique/)                                                                           | [Python](./Python/0945-minimum-increment-to-make-array-unique.py)                                      | [Medium](./Readme/0945-minimum-increment-to-make-array-unique.md)                                      |
| 0947 | [Most Stones Removed with Same Row or Column](https://leetcode.com/problems/most-stones-removed-with-same-row-or-column/)                                                                 | [Python](./Python/0947-most-stones-removed-with-same-row-or-column.py)                                 | [Medium](./Readme/0947-most-stones-removed-with-same-row-or-column.md)                                 |
| 0948 | [Bag of Tokens](https://leetcode.com/problems/bag-of-tokens/)                                                                                                                             | [Python](./Python/0948-bag-of-tokens.py)                                                               | [Medium](./Readme/0948-bag-of-tokens.md)                                                               |
| 0950 | [Reveal Cards In Increasing Order](https://leetcode.com/problems/reveal-cards-in-increasing-order/)                                                                                       | [Python](./Python/0950-reveal-cards-in-increasing-order.py)                                            | [Medium](./Readme/0950-reveal-cards-in-increasing-order.md)                                            |
| 0951 | [Flip Equivalent Binary Trees](https://leetcode.com/problems/flip-equivalent-binary-trees)                                                                                                | [Python](./Python/0951-flip-equivalent-binary-trees.py)                                                | [Medium](./Readme/0951-flip-equivalent-binary-trees.md)                                                |
| 0959 | [Regions Cut By Slashes](https://leetcode.com/problems/regions-cut-by-slashes/)                                                                                                           | [Python](./Python/0959-regions-cut-by-slashes.py)                                                      | [Medium](./Readme/0959-regions-cut-by-slashes.md)                                                      |
| 0962 | [Maximum Width Ramp](https://leetcode.com/problems/maximum-width-ramp/)                                                                                                                   | [Python](./Python/0962-maximum-width-ramp.py)                                                          | [Medium](./Readme/0962-maximum-width-ramp.md)                                                          |
| 0973 | [K Closest Points to Origin](https://leetcode.com/problems/k-closest-points-to-origin/)                                                                                                   | [Python](./Python/0973-k-closest-points-to-origin.py)                                                  | [Medium](./Readme/0973-k-closest-points-to-origin.md)                                                  |
| 0974 | [Subarray Sums Divisible by K](https://leetcode.com/problems/subarray-sums-divisible-by-k/)                                                                                               | [Python](./Python/0974-subarray-sums-divisible-by-k.py)                                                | [Medium](./Readme/0974-subarray-sums-divisible-by-k.md)                                                |
| 0977 | [Squares of a Sorted Array](https://leetcode.com/problems/squares-of-a-sorted-array/)                                                                                                     | [Python](./Python/0977-squares-of-a-sorted-array.py)                                                   | [Easy](./Readme/0977-squares-of-a-sorted-array.md)                                                     |
| 0979 | [Distribute Coins in Binary Tree](https://leetcode.com/problems/distribute-coins-in-binary-tree/)                                                                                         | [Python](./Python/0979-distribute-coins-in-binary-tree.py)                                             | [Medium](./Readme/0979-distribute-coins-in-binary-tree.md)                                             |
| 0981 | [Time Based Key-Value Store](https://leetcode.com/problems/time-based-key-value-store/)                                                                                                   | [Python](./Python/0981-time-based-key-value-store.py)                                                  | [Medium](./Readme/0981-time-based-key-value-store.md)                                                  |
| 0988 | [Smallest String Starting From Leaf](https://leetcode.com/problems/smallest-string-starting-from-leaf/)                                                                                   | [Python](./Python/0988-smallest-string-starting-from-leaf.py)                                          | [Medium](./Readme/0988-smallest-string-starting-from-leaf.md)                                          |
| 0992 | [Subarrays with K Different Integers](https://leetcode.com/problems/subarrays-with-k-different-integers/)                                                                                 | [Python](./Python/0992-subarrays-with-k-different-integers.py)                                         | [Hard](./Readme/0992-subarrays-with-k-different-integers.md)                                           |
| 0993 | [Cousins in Binary Tree](https://leetcode.com/problems/cousins-in-binary-tree)                                                                                                            | [Python](./Python/0993-cousins-in-binary-tree.py)                                                      | [Easy](./Readme/0993-cousins-in-binary-tree.md)                                                        |
| 0994 | [Rotting Oranges](https://leetcode.com/problems/rotting-oranges/)                                                                                                                         | [Python](./Python/0994-rotting-oranges.py)                                                             | [Medium](./Readme/0994-rotting-oranges.md)                                                             |
| 0995 | [Minimum Number of K Consecutive Bit Flips](https://leetcode.com/problems/minimum-number-of-k-consecutive-bit-flips/)                                                                     | [Python](./Python/0995-minimum-number-of-k-consecutive-bit-flips.py)                                   | [Hard](./Readme/0995-minimum-number-of-k-consecutive-bit-flips.md)                                     |
| 0997 | [Find the Town Judge](https://leetcode.com/problems/find-the-town-judge/)                                                                                                                 | [Python](./Python/0997-find-the-town-judge.py)                                                         | [Easy](./Readme/0997-find-the-town-judge.md)                                                           |
| 1002 | [Find Common Characters](https://leetcode.com/problems/find-common-characters/)                                                                                                           | [Python](./Python/1002-find-common-characters.py)                                                      | [Easy](./Readme/1002-find-common-characters.md)                                                        |
| 1004 | [Max Consecutive Ones III](https://leetcode.com/problems/max-consecutive-ones-iii/)                                                                                                       | [Python](./Python/1004-max-consecutive-ones-iii.py)                                                    | [Medium](./Readme/1004-max-consecutive-ones-iii.md)                                                    |
| 1010 | [Pairs of Songs With Total Durations Divisible by 60](https://leetcode.com/problems/pairs-of-songs-with-total-durations-divisible-by-60/)                                                 | [Python](./Python/1010-pairs-of-songs-with-total-durations-divisible-by-60.py)                         | [Medium](./Readme/1010-pairs-of-songs-with-total-durations-divisible-by-60.md)                         |
| 1011 | [Capacity To Ship Packages Within D Days](https://leetcode.com/problems/capacity-to-ship-packages-within-d-days/)                                                                         | [Python](./Python/1011-capacity-to-ship-packages-within-d-days.py)                                     | [Medium](./Readme/1011-capacity-to-ship-packages-within-d-days.md)                                     |
| 1026 | [Maximum Difference Between Node and Ancestor](https://leetcode.com/problems/maximum-difference-between-node-and-ancestor/)                                                               | [Python](./Python/1026-maximum-difference-between-node-and-ancestor.py)                                | [Medium](./Readme/1026-maximum-difference-between-node-and-ancestor.md)                                |
| 1038 | [Binary Search Tree to Greater Sum Tree](https://leetcode.com/problems/binary-search-tree-to-greater-sum-tree/)                                                                           | [Python](./Python/1038-binary-search-tree-to-greater-sum-tree.py)                                      | [Medium](./Readme/1038-binary-search-tree-to-greater-sum-tree.md)                                      |
| 1043 | [Partition Array for Maximum Sum](https://leetcode.com/problems/partition-array-for-maximum-sum/)                                                                                         | [Python](./Python/1043-partition-array-for-maximum-sum.py)                                             | [Medium](./Readme/1043-partition-array-for-maximum-sum.md)                                             |
| 1046 | [Last Stone Weight](https://leetcode.com/problems/last-stone-weight/)                                                                                                                     | [Python](./Python/1046-last-stone-weight.py)                                                           | [Easy](./Readme/1046-last-stone-weight.md)                                                             |
| 1048 | [Longest String Chain](https://leetcode.com/problems/longest-string-chain/)                                                                                                               | [Python](./Python/1048-longest-string-chain.py)                                                        | [Medium](./Readme/1048-longest-string-chain.md)                                                        |
| 1051 | [Height Checker](https://leetcode.com/problems/height-checker/)                                                                                                                           | [Python](./Python/1051-height-checker.py)                                                              | [Easy](./Readme/1051-height-checker.md)                                                                |
| 1052 | [Grumpy Bookstore Owner](https://leetcode.com/problems/grumpy-bookstore-owner/)                                                                                                           | [Python](./Python/1052-grumpy-bookstore-owner.py)                                                      | [Medium](./Readme/1052-grumpy-bookstore-owner.md)                                                      |
| 1057 | [Campus Bikes](https://leetcode.com/problems/campus-bikes/)                                                                                                                               | [Python](./Python/1057-campus-bikes.py)                                                                | [Medium](./Readme/1057-campus-bikes.md)                                                                |
| 1060 | [Missing Element in Sorted Array](https://leetcode.com/problems/missing-element-in-sorted-array/)                                                                                         | [Python](./Python/1060-missing-element-in-sorted-array.py)                                             | [Medium](./Readme/1060-missing-element-in-sorted-array.md)                                             |
| 1062 | [Longest Repeating Substring](https://leetcode.com/problems/longest-repeating-substring/)                                                                                                 | [Python](./Python/1062-longest-repeating-substring.py)                                                 | [Medium](./Readme/1062-longest-repeating-substring.md)                                                 |
| 1063 | [Number of Valid Subarrays](https://leetcode.com/problems/number-of-valid-subarrays/)                                                                                                     | [Python](./Python/1063-number-of-valid-subarrays.py)                                                   | [Hard](./Readme/1063-number-of-valid-subarrays.md)                                                     |
| 1066 | [Campus Bikes II](https://leetcode.com/problems/campus-bikes-ii/)                                                                                                                         | [Python](./Python/1066-campus-bikes-ii.py)                                                             | [Medium](./Readme/1066-campus-bikes-ii.md)                                                             |
| 1068 | [Product Sales Analysis I](https://leetcode.com/problems/product-sales-analysis-i/)                                                                                                       | [SQL](./SQL/1068-product-sales-analysis-i.sql)                                                         | [Easy](./Readme/1068-product-sales-analysis-i.md)                                                      |
| 1071 | [Greatest Common Divisor of Strings](https://leetcode.com/problems/greatest-common-divisor-of-strings/)                                                                                   | [Python](./Python/1071-greatest-common-divisor-of-strings.py)                                          | [Easy](./Readme/1071-greatest-common-divisor-of-strings.md)                                            |
| 1072 | [Flip Columns For Maximum Number of Equal Rows](https://leetcode.com/problems/flip-columns-for-maximum-number-of-equal-rows)                                                              | [Python](./Python/1072-flip-columns-for-maximum-number-of-equal-rows.py)                               | [Medium](./Readme/1072-flip-columns-for-maximum-number-of-equal-rows.md)                               |
| 1074 | [Number of Submatrices That Sum to Target](https://leetcode.com/problems/number-of-submatrices-that-sum-to-target/)                                                                       | [Python](./Python/1074-number-of-submatrices-that-sum-to-target.py)                                    | [Hard](./Readme/1074-number-of-submatrices-that-sum-to-target.md)                                      |
| 1075 | [Project Employees I](https://leetcode.com/problems/project-employees-i/)                                                                                                                 | [SQL](./SQL/1075-project-employees-i.sql)                                                              | [Easy](./Readme/1075-project-employees-i.md)                                                           |
| 1092 | [Shortest Common Supersequence](https://leetcode.com/problems/shortest-common-supersequence)                                                                                              | [Python](./Python/1092-shortest-common-supersequence.py)                                               | [Hard](./Readme/1092-shortest-common-supersequence.md)                                                 |
| 1095 | [Find in Mountain Array](https://leetcode.com/problems/find-in-mountain-array/)                                                                                                           | [Python](./Python/1095-find-in-mountain-array.py)                                                      | [Hard](./Readme/1095-find-in-mountain-array.md)                                                        |
| 1099 | [Two Sum Less Than K](https://leetcode.com/problems/two-sum-less-than-k/)                                                                                                                 | [Python](./Python/1099-two-sum-less-than-k.py)                                                         | [Easy](./Readme/1099-two-sum-less-than-k.md)                                                           |
| 1101 | [The Earliest Moment When Everyone Become Friends](https://leetcode.com/problems/the-earliest-moment-when-everyone-become-friends/)                                                       | [Python](./Python/1101-the-earliest-moment-when-everyone-become-friends.py)                            | [Medium](./Readme/1101-the-earliest-moment-when-everyone-become-friends.md)                            |
| 1105 | [Filling Bookcase Shelves](https://leetcode.com/problems/filling-bookcase-shelves/)                                                                                                       | [Python](./Python/1105-filling-bookcase-shelves.py)                                                    | [Medium](./Readme/1105-filling-bookcase-shelves.md)                                                    |
| 1106 | [Parsing A Boolean Expression](https://leetcode.com/problems/parsing-a-boolean-expression)                                                                                                | [Python](./Python/1106-parsing-a-boolean-expression.py)                                                | [Hard](./Readme/1106-parsing-a-boolean-expression.md)                                                  |
| 1110 | [Delete Nodes And Return Forest](https://leetcode.com/problems/delete-nodes-and-return-forest/)                                                                                           | [Python](./Python/1110-delete-nodes-and-return-forest.py)                                              | [Medium](./Readme/1110-delete-nodes-and-return-forest.md)                                              |
| 1119 | [Remove Vowels from a String](https://leetcode.com/problems/remove-vowels-from-a-string/)                                                                                                 | [Python](./Python/1119-remove-vowels-from-a-string.py)                                                 | [Easy](./Readme/1119-remove-vowels-from-a-string.md)                                                   |
| 1120 | [Maximum Average Subtree](https://leetcode.com/problems/maximum-average-subtree/)                                                                                                         | [Python](./Python/1120-maximum-average-subtree.py)                                                     | [Medium](./Readme/1120-maximum-average-subtree.md)                                                     |
| 1122 | [Relative Sort Array](https://leetcode.com/problems/relative-sort-array/)                                                                                                                 | [Python](./Python/1122-relative-sort-array.py)                                                         | [Easy](./Readme/1122-relative-sort-array.md)                                                           |
| 1133 | [Largest Unique Number](https://leetcode.com/problems/largest-unique-number/)                                                                                                             | [Python](./Python/1133-largest-unique-number.py)                                                       | [Easy](./Readme/1133-largest-unique-number.md)                                                         |
| 1136 | [Parallel Courses](https://leetcode.com/problems/parallel-courses/)                                                                                                                       | [Python](./Python/1136-parallel-courses.py)                                                            | [Hard](./Readme/1136-parallel-courses.md)                                                              |
| 1137 | [N-th Tribonacci Number](https://leetcode.com/problems/n-th-tribonacci-number/)                                                                                                           | [Python](./Python/1137-n-th-tribonacci-number.py)                                                      | [Easy](./Readme/1137-n-th-tribonacci-number.md)                                                        |
| 1140 | [Stone Game II](https://leetcode.com/problems/stone-game-ii/)                                                                                                                             | [Python](./Python/1140-stone-game-ii.py)                                                               | [Medium](./Readme/1140-stone-game-ii.md)                                                               |
| 1143 | [Longest Common Subsequence](https://leetcode.com/problems/longest-common-subsequence/)                                                                                                   | [Python](./Python/1143-longest-common-subsequence.py)                                                  | [Medium](./Readme/1143-longest-common-subsequence.md)                                                  |
| 1146 | [Snapshot Array](https://leetcode.com/problems/snapshot-array)                                                                                                                            | [Python](./Python/1146-snapshot-array.py)                                                              | [Medium](./Readme/1146-snapshot-array.md)                                                              |
| 1148 | [Article Views I](https://leetcode.com/problems/article-views-i/)                                                                                                                         | [SQL](./SQL/1148-article-views-i.sql)                                                                  | [Easy](./Readme/1148-article-views-i.md)                                                               |
| 1151 | [Minimum Swaps to Group All 1's Together](https://leetcode.com/problems/minimum-swaps-to-group-all-1s-together/)                                                                          | [Python](./Python/1151-minimum-swaps-to-group-all-1s-together.py)                                      | [Medium](./Readme/1151-minimum-swaps-to-group-all-1s-together.md)                                      |
| 1155 | [Number of Dice Rolls With Target Sum](https://leetcode.com/problems/number-of-dice-rolls-with-target-sum/)                                                                               | [Python](./Python/1155-number-of-dice-rolls-with-target-sum.py)                                        | [Medium](./Readme/1155-number-of-dice-rolls-with-target-sum.md)                                        |
| 1160 | [Find Words That Can Be Formed by Characters](https://leetcode.com/problems/find-words-that-can-be-formed-by-characters/)                                                                 | [Python](./Python/1160-find-words-that-can-be-formed-by-characters.py)                                 | [Easy](./Readme/1160-find-words-that-can-be-formed-by-characters.md)                                   |
| 1161 | [Maximum Level Sum of a Binary Tree](https://leetcode.com/problems/maximum-level-sum-of-a-binary-tree/)                                                                                   | [Python](./Python/1161-maximum-level-sum-of-a-binary-tree.py)                                          | [Medium](./Readme/1161-maximum-level-sum-of-a-binary-tree.md)                                          |
| 1165 | [Single Row Keyboard](https://leetcode.com/problems/single-row-keyboard/)                                                                                                                 | [Python](./Python/1165-single-row-keyboard.py)                                                         | [Easy](./Readme/1165-single-row-keyboard.md)                                                           |
| 1167 | [Minimum Cost to Connect Sticks](https://leetcode.com/problems/minimum-cost-to-connect-sticks/)                                                                                           | [Python](./Python/1167-minimum-cost-to-connect-sticks.py)                                              | [Medium](./Readme/1167-minimum-cost-to-connect-sticks.md)                                              |
| 1168 | [Optimize Water Distribution in a Village](https://leetcode.com/problems/optimize-water-distribution-in-a-village/)                                                                       | [Python](./Python/1168-optimize-water-distribution-in-a-village.py)                                    | [Hard](./Readme/1168-optimize-water-distribution-in-a-village.md)                                      |
| 1171 | [Remove Zero Sum Consecutive Nodes from Linked List](https://leetcode.com/problems/remove-zero-sum-consecutive-nodes-from-linked-list/)                                                   | [Python](./Python/1171-remove-zero-sum-consecutive-nodes-from-linked-list.py)                          | [Medium](./Readme/1171-remove-zero-sum-consecutive-nodes-from-linked-list.md)                          |
| 1183 | [Maximum Number of Ones](https://leetcode.com/problems/maximum-number-of-ones/)                                                                                                           | [Python](./Python/1183-maximum-number-of-ones.py)                                                      | [Hard](./Readme/1183-maximum-number-of-ones.md)                                                        |
| 1190 | [Reverse Substrings Between Each Pair of Parentheses](https://leetcode.com/problems/reverse-substrings-between-each-pair-of-parentheses/)                                                 | [Python](./Python/1190-reverse-substrings-between-each-pair-of-parentheses.py)                         | [Medium](./Readme/1190-reverse-substrings-between-each-pair-of-parentheses.md)                         |
| 1197 | [Minimum Knight Moves](https://leetcode.com/problems/minimum-knight-moves/)                                                                                                               | [Python](./Python/1197-minimum-knight-moves.py)                                                        | [Medium](./Readme/1197-minimum-knight-moves.md)                                                        |
| 1199 | [Minimum Time to Build Blocks](https://leetcode.com/problems/minimum-time-to-build-blocks/)                                                                                               | [Python](./Python/1199-minimum-time-to-build-blocks.py)                                                | [Hard](./Readme/1199-minimum-time-to-build-blocks.md)                                                  |
| 1202 | [Smallest String With Swaps](https://leetcode.com/problems/smallest-string-with-swaps/)                                                                                                   | [Python](./Python/1202-smallest-string-with-swaps.py)                                                  | [Medium](./Readme/1202-smallest-string-with-swaps.md)                                                  |
| 1203 | [Sort Items by Groups Respecting Dependencies](https://leetcode.com/problems/sort-items-by-groups-respecting-dependencies/)                                                               | [Python](./Python/1203-sort-items-by-groups-respecting-dependencies.py)                                | [Hard](./Readme/1203-sort-items-by-groups-respecting-dependencies.md)                                  |
| 1207 | [Unique Number of Occurrences](https://leetcode.com/problems/unique-number-of-occurrences/)                                                                                               | [Python](./Python/1207-unique-number-of-occurrences.py)                                                | [Easy](./Readme/1207-unique-number-of-occurrences.md)                                                  |
| 1208 | [Get Equal Substrings Within Budget](https://leetcode.com/problems/get-equal-substrings-within-budget/)                                                                                   | [Python](./Python/1208-get-equal-substrings-within-budget.py)                                          | [Medium](./Readme/1208-get-equal-substrings-within-budget.md)                                          |
| 1216 | [Valid Palindrome III](https://leetcode.com/problems/valid-palindrome-iii/)                                                                                                               | [Python](./Python/1216-valid-palindrome-iii.py)                                                        | [Hard](./Readme/1216-valid-palindrome-iii.md)                                                          |
| 1219 | [Path with Maximum Gold](https://leetcode.com/problems/path-with-maximum-gold/)                                                                                                           | [Python](./Python/1219-path-with-maximum-gold.py)                                                      | [Medium](./Readme/1219-path-with-maximum-gold.md)                                                      |
| 1220 | [Count Vowels Permutation](https://leetcode.com/problems/count-vowels-permutation/)                                                                                                       | [Python](./Python/1220-count-vowels-permutation.py)                                                    | [Hard](./Readme/1220-count-vowels-permutation.md)                                                      |
| 1230 | [Toss Strange Coins](https://leetcode.com/problems/toss-strange-coins/)                                                                                                                   | [Python](./Python/1230-toss-strange-coins.py)                                                          | [Medium](./Readme/1230-toss-strange-coins.md)                                                          |
| 1233 | [Remove Sub-Folders from the Filesystem](https://leetcode.com/problems/remove-sub-folders-from-the-filesystem)                                                                            | [Python](./Python/1233-remove-sub-folders-from-the-filesystem.py)                                      | [Medium](./Readme/1233-remove-sub-folders-from-the-filesystem.md)                                      |
| 1235 | [Maximum Profit in Job Scheduling](https://leetcode.com/problems/maximum-profit-in-job-scheduling/)                                                                                       | [Python](./Python/1235-maximum-profit-in-job-scheduling.py)                                            | [Hard](./Readme/1235-maximum-profit-in-job-scheduling.md)                                              |
| 1239 | [Maximum Length of a Concatenated String with Unique Characters](https://leetcode.com/problems/maximum-length-of-a-concatenated-string-with-unique-characters/)                           | [Python](./Python/1239-maximum-length-of-a-concatenated-string-with-unique-characters.py)              | [Medium](./Readme/1239-maximum-length-of-a-concatenated-string-with-unique-characters.md)              |
| 1245 | [Tree Diameter](https://leetcode.com/problems/tree-diameter/)                                                                                                                             | [Python](./Python/1245-tree-diameter.py)                                                               | [Medium](./Readme/1245-tree-diameter.md)                                                               |
| 1248 | [Count Number of Nice Subarrays](https://leetcode.com/problems/count-number-of-nice-subarrays/)                                                                                           | [Python](./Python/1248-count-number-of-nice-subarrays.py)                                              | [Medium](./Readme/1248-count-number-of-nice-subarrays.md)                                              |
| 1249 | [Minimum Remove to Make Valid Parentheses](https://leetcode.com/problems/minimum-remove-to-make-valid-parentheses/)                                                                       | [Python](./Python/1249-minimum-remove-to-make-valid-parentheses.py)                                    | [Medium](./Readme/1249-minimum-remove-to-make-valid-parentheses.md)                                    |
| 1251 | [Average Selling Price](https://leetcode.com/problems/average-selling-price/)                                                                                                             | [SQL](./SQL/1251-average-selling-price.sql)                                                            | [Easy](./Readme/1251-average-selling-price.md)                                                         |
| 1254 | [Number of Closed Islands](https://leetcode.com/problems/number-of-closed-islands)                                                                                                        | [Python](./Python/1254-number-of-closed-islands.py)                                                    | [Medium](./Readme/1254-number-of-closed-islands.md)                                                    |
| 1255 | [Maximum Score Words Formed by Letters](https://leetcode.com/problems/maximum-score-words-formed-by-letters/)                                                                             | [Python](./Python/1255-maximum-score-words-formed-by-letters.py)                                       | [Hard](./Readme/1255-maximum-score-words-formed-by-letters.md)                                         |
| 1257 | [Smallest Common Region](https://leetcode.com/problems/smallest-common-region/)                                                                                                           | [Python](./Python/1257-smallest-common-region.py)                                                      | [Medium](./Readme/1257-smallest-common-region.md)                                                      |
| 1265 | [Print Immutable Linked List in Reverse](https://leetcode.com/problems/print-immutable-linked-list-in-reverse/)                                                                           | [C++](./C++/1265-print-immutable-linked-list-in-reverse.cpp)                                           | [Medium](./Readme/1265-print-immutable-linked-list-in-reverse.md)                                      |
| 1266 | [Minimum Time Visiting All Points](https://leetcode.com/problems/minimum-time-visiting-all-points/)                                                                                       | [Python](./Python/1266-minimum-time-visiting-all-points.py)                                            | [Easy](./Readme/1266-minimum-time-visiting-all-points.md)                                              |
| 1268 | [Search Suggestions System](https://leetcode.com/problems/search-suggestions-system/)                                                                                                     | [Python](./Python/1268-search-suggestions-system.py)                                                   | [Medium](./Readme/1268-search-suggestions-system.md)                                                   |
| 1269 | [Number of Ways to Stay in the Same Place After Some Steps](https://leetcode.com/problems/number-of-ways-to-stay-in-the-same-place-after-some-steps/)                                     | [Python](./Python/1269-number-of-ways-to-stay-in-the-same-place-after-some-steps.py)                   | [Hard](./Readme/1269-number-of-ways-to-stay-in-the-same-place-after-some-steps.md)                     |
| 1272 | [Remove Interval](https://leetcode.com/problems/remove-interval/)                                                                                                                         | [Python](./Python/1272-remove-interval.py)                                                             | [Medium](./Readme/1272-remove-interval.md)                                                             |
| 1277 | [Count Square Submatrices with All Ones](https://leetcode.com/problems/count-square-submatrices-with-all-ones)                                                                            | [Python](./Python/1277-count-square-submatrices-with-all-ones.py)                                      | [Medium](./Readme/1277-count-square-submatrices-with-all-ones.md)                                      |
| 1280 | [Students and Examinations](https://leetcode.com/problems/students-and-examinations/)                                                                                                     | [SQL](./SQL/1280-students-and-examinations.sql)                                                        | [Easy](./Readme/1280-students-and-examinations.md)                                                     |
| 1282 | [Group the People Given the Group Size They Belong To](https://leetcode.com/problems/group-the-people-given-the-group-size-they-belong-to/)                                               | [Python](./Python/1282-group-the-people-given-the-group-size-they-belong-to.py)                        | [Medium](./Readme/1282-group-the-people-given-the-group-size-they-belong-to.md)                        |
| 1287 | [Element Appearing More Than 25% In Sorted Array](https://leetcode.com/problems/element-appearing-more-than-25-in-sorted-array/)                                                          | [Python](./Python/1287-element-appearing-more-than-25-in-sorted-array.py)                              | [Easy](./Readme/1287-element-appearing-more-than-25-in-sorted-array.md)                                |
| 1289 | [Minimum Falling Path Sum II](https://leetcode.com/problems/minimum-falling-path-sum-ii/)                                                                                                 | [Python](./Python/1289-minimum-falling-path-sum-ii.py)                                                 | [Hard](./Readme/1289-minimum-falling-path-sum-ii.md)                                                   |
| 1291 | [Sequential Digits](https://leetcode.com/problems/sequential-digits/)                                                                                                                     | [Python](./Python/1291-sequential-digits.py)                                                           | [Medium](./Readme/1291-sequential-digits.md)                                                           |
| 1310 | [XOR Queries of a Subarray](https://leetcode.com/problems/xor-queries-of-a-subarray/)                                                                                                     | [Python](./Python/1310-xor-queries-of-a-subarray.py)                                                   | [Medium](./Readme/1310-xor-queries-of-a-subarray.md)                                                   |
| 1318 | [Minimum Flips to Make A or B Equal to C](https://leetcode.com/problems/minimum-flips-to-make-a-or-b-equal-to-c/)                                                                         | [Python](./Python/1318-minimum-flips-to-make-a-or-b-equal-to-c.py)                                     | [Medium](./Readme/1318-minimum-flips-to-make-a-or-b-equal-to-c.md)                                     |
| 1325 | [Delete Leaves With a Given Value](https://leetcode.com/problems/delete-leaves-with-a-given-value/)                                                                                       | [Python](./Python/1325-delete-leaves-with-a-given-value.py)                                            | [Medium](./Readme/1325-delete-leaves-with-a-given-value.md)                                            |
| 1326 | [Minimum Number of Taps to Open to Water a Garden](https://leetcode.com/problems/minimum-number-of-taps-to-open-to-water-a-garden/)                                                       | [Python](./Python/1326-minimum-number-of-taps-to-open-to-water-a-garden.py)                            | [Hard](./Readme/1326-minimum-number-of-taps-to-open-to-water-a-garden.md)                              |
| 1331 | [Rank Transform of an Array](https://leetcode.com/problems/rank-transform-of-an-array/)                                                                                                   | [Python](./Python/1331-rank-transform-of-an-array.py)                                                  | [Easy](./Readme/1331-rank-transform-of-an-array.md)                                                    |
| 1334 | [Find the City With the Smallest Number of Neighbors at a Threshold Distance](https://leetcode.com/problems/find-the-city-with-the-smallest-number-of-neighbors-at-a-threshold-distance/) | [Python](./Python/1334-find-the-city-with-the-smallest-number-of-neighbors-at-a-threshold-distance.py) | [Medium](./Readme/1334-find-the-city-with-the-smallest-number-of-neighbors-at-a-threshold-distance.md) |
| 1335 | [Minimum Difficulty of a Job Schedule](https://leetcode.com/problems/minimum-difficulty-of-a-job-schedule/)                                                                               | [Python](./Python/1335-minimum-difficulty-of-a-job-schedule.py)                                        | [Hard](./Readme/1335-minimum-difficulty-of-a-job-schedule.md)                                          |
| 1337 | [The K Weakest Rows in a Matrix](https://leetcode.com/problems/the-k-weakest-rows-in-a-matrix/)                                                                                           | [Python](./Python/1337-the-k-weakest-rows-in-a-matrix.py)                                              | [Easy](./Readme/1337-the-k-weakest-rows-in-a-matrix.md)                                                |
| 1346 | [Check If N and Its Double Exist](https://leetcode.com/problems/check-if-n-and-its-double-exist)                                                                                          | [Python](./Python/1346-check-if-n-and-its-double-exist.py)                                             | [Easy](./Readme/1346-check-if-n-and-its-double-exist.md)                                               |
| 1347 | [Minimum Number of Steps to Make Two Strings Anagram](https://leetcode.com/problems/minimum-number-of-steps-to-make-two-strings-anagram/)                                                 | [Python](./Python/1347-minimum-number-of-steps-to-make-two-strings-anagram.py)                         | [Medium](./Readme/1347-minimum-number-of-steps-to-make-two-strings-anagram.md)                         |
| 1351 | [Count Negative Numbers in a Sorted Matrix](https://leetcode.com/problems/count-negative-numbers-in-a-sorted-matrix/)                                                                     | [Python](./Python/1351-count-negative-numbers-in-a-sorted-matrix.py)                                   | [Easy](./Readme/1351-count-negative-numbers-in-a-sorted-matrix.md)                                     |
| 1356 | [Sort Integers by The Number of 1 Bits](https://leetcode.com/problems/sort-integers-by-the-number-of-1-bits/)                                                                             | [Python](./Python/1356-sort-integers-by-the-number-of-1-bits.py)                                       | [Easy](./Readme/1356-sort-integers-by-the-number-of-1-bits.md)                                         |
| 1359 | [Count All Valid Pickup and Delivery Options](https://leetcode.com/problems/count-all-valid-pickup-and-delivery-options/)                                                                 | [Python](./Python/1359-count-all-valid-pickup-and-delivery-options.py)                                 | [Hard](./Readme/1359-count-all-valid-pickup-and-delivery-options.md)                                   |
| 1360 | [Number of Days Between Two Dates](https://leetcode.com/problems/number-of-days-between-two-dates/)                                                                                       | [Python](./Python/1360-number-of-days-between-two-dates.py)                                            | [Easy](./Readme/1360-number-of-days-between-two-dates.md)                                              |
| 1361 | [Validate Binary Tree Nodes](https://leetcode.com/problems/validate-binary-tree-nodes/)                                                                                                   | [Python](./Python/1361-validate-binary-tree-nodes.py)                                                  | [Medium](./Readme/1361-validate-binary-tree-nodes.md)                                                  |
| 1367 | [Linked List in Binary Tree](https://leetcode.com/problems/linked-list-in-binary-tree/)                                                                                                   | [Python](./Python/1367-linked-list-in-binary-tree.py)                                                  | [Medium](./Readme/1367-linked-list-in-binary-tree.md)                                                  |
| 1371 | [Find the Longest Substring Containing Vowels in Even Counts](https://leetcode.com/problems/find-the-longest-substring-containing-vowels-in-even-counts/)                                 | [Python](./Python/1371-find-the-longest-substring-containing-vowels-in-even-counts.py)                 | [Medium](./Readme/1371-find-the-longest-substring-containing-vowels-in-even-counts.md)                 |
| 1372 | [Longest ZigZag Path in a Binary Tree](https://leetcode.com/problems/longest-zigzag-path-in-a-binary-tree/)                                                                               | [Python](./Python/1372-longest-zigzag-path-in-a-binary-tree.py)                                        | [Medium](./Readme/1372-longest-zigzag-path-in-a-binary-tree.md)                                        |
| 1378 | [Replace Employee ID With The Unique Identifier](https://leetcode.com/problems/replace-employee-id-with-the-unique-identifier/)                                                           | [SQL](./SQL/1378-replace-employee-id-with-the-unique-identifier.sql)                                   | [Easy](./Readme/1378-replace-employee-id-with-the-unique-identifier.md)                                |
| 1380 | [Lucky Numbers in a Matrix](https://leetcode.com/problems/lucky-numbers-in-a-matrix/)                                                                                                     | [Python](./Python/1380-lucky-numbers-in-a-matrix.py)                                                   | [Easy](./Readme/1380-lucky-numbers-in-a-matrix.md)                                                     |
| 1381 | [Design a Stack With Increment Operation](https://leetcode.com/problems/design-a-stack-with-increment-operation/)                                                                         | [Python](./Python/1381-design-a-stack-with-increment-operation.py)                                     | [Medium](./Readme/1381-design-a-stack-with-increment-operation.md)                                     |
| 1382 | [Balance a Binary Search Tree](https://leetcode.com/problems/balance-a-binary-search-tree/)                                                                                               | [Python](./Python/1382-balance-a-binary-search-tree.py)                                                | [Medium](./Readme/1382-balance-a-binary-search-tree.md)                                                |
| 1395 | [Count Number of Teams](https://leetcode.com/problems/count-number-of-teams/)                                                                                                             | [Python](./Python/1395-count-number-of-teams.py)                                                       | [Medium](./Readme/1395-count-number-of-teams.md)                                                       |
| 1404 | [Number of Steps to Reduce a Number in Binary Representation to One](https://leetcode.com/problems/number-of-steps-to-reduce-a-number-in-binary-representation-to-one/)                   | [Python](./Python/1404-number-of-steps-to-reduce-a-number-in-binary-representation-to-one.py)          | [Medium](./Readme/1404-number-of-steps-to-reduce-a-number-in-binary-representation-to-one.md)          |
| 1405 | [Longest Happy String](https://leetcode.com/problems/longest-happy-string)                                                                                                                | [Python](./Python/1405-longest-happy-string.py)                                                        | [Medium](./Readme/1405-longest-happy-string.md)                                                        |
| 1420 | [Build Array Where You Can Find The Maximum Exactly K Comparisons](https://leetcode.com/problems/build-array-where-you-can-find-the-maximum-exactly-k-comparisons/)                       | [Python](./Python/1420-build-array-where-you-can-find-the-maximum-exactly-k-comparisons.py)            | [Hard](./Readme/1420-build-array-where-you-can-find-the-maximum-exactly-k-comparisons.md)              |
| 1422 | [Maximum Score After Splitting a String](https://leetcode.com/problems/maximum-score-after-splitting-a-string/)                                                                           | [Python](./Python/1422-maximum-score-after-splitting-a-string.py)                                      | [Easy](./Readme/1422-maximum-score-after-splitting-a-string.md)                                        |
| 1424 | [Diagonal Traverse II](https://leetcode.com/problems/diagonal-traverse-ii/)                                                                                                               | [Python](./Python/1424-diagonal-traverse-ii.py)                                                        | [Medium](./Readme/1424-diagonal-traverse-ii.md)                                                        |
| 1425 | [Constrained Subsequence Sum](https://leetcode.com/problems/constrained-subsequence-sum/)                                                                                                 | [Python](./Python/1425-constrained-subsequence-sum.py)                                                 | [Hard](./Readme/1425-constrained-subsequence-sum.md)                                                   |
| 1428 | [Leftmost Column with at Least a One](https://leetcode.com/problems/leftmost-column-with-at-least-a-one/)                                                                                 | [Python](./Python/1428-leftmost-column-with-at-least-a-one.py)                                         | [Medium](./Readme/1428-leftmost-column-with-at-least-a-one.md)                                         |
| 1429 | [First Unique Number](https://leetcode.com/problems/first-unique-number)                                                                                                                  | [Python](./Python/1429-first-unique-number.py)                                                         | [Medium](./Readme/1429-first-unique-number.md)                                                         |
| 1431 | [Kids With the Greatest Number of Candies](https://leetcode.com/problems/kids-with-the-greatest-number-of-candies/)                                                                       | [Python](./Python/1431-kids-with-the-greatest-number-of-candies.py)                                    | [Easy](./Readme/1431-kids-with-the-greatest-number-of-candies.md)                                      |
| 1436 | [Destination City](https://leetcode.com/problems/destination-city/)                                                                                                                       | [Python](./Python/1436-destination-city.py)                                                            | [Easy](./Readme/1436-destination-city.md)                                                              |
| 1438 | [Longest Continuous Subarray With Absolute Diff Less Than or Equal to Limit](https://leetcode.com/problems/longest-continuous-subarray-with-absolute-diff-less-than-or-equal-to-limit/)   | [Python](./Python/1438-longest-continuous-subarray-with-absolute-diff-less-than-or-equal-to-limit.py)  | [Medium](./Readme/1438-longest-continuous-subarray-with-absolute-diff-less-than-or-equal-to-limit.md)  |
| 1441 | [Build an Array With Stack Operations](https://leetcode.com/problems/build-an-array-with-stack-operations/)                                                                               | [Python](./Python/1441-build-an-array-with-stack-operations.py)                                        | [Easy](./Readme/1441-build-an-array-with-stack-operations.md)                                          |
| 1442 | [Count Triplets That Can Form Two Arrays of Equal XOR](https://leetcode.com/problems/count-triplets-that-can-form-two-arrays-of-equal-xor/)                                               | [Python](./Python/1442-count-triplets-that-can-form-two-arrays-of-equal-xor.py)                        | [Medium](./Readme/1442-count-triplets-that-can-form-two-arrays-of-equal-xor.md)                        |
| 1448 | [Count Good Nodes in Binary Tree](https://leetcode.com/problems/count-good-nodes-in-binary-tree/)                                                                                         | [Python](./Python/1448-count-good-nodes-in-binary-tree.py)                                             | [Medium](./Readme/1448-count-good-nodes-in-binary-tree.md)                                             |
| 1455 | [Check If a Word Occurs as a Prefix of Any Word in a Sentence](https://leetcode.com/problems/check-if-a-word-occurs-as-a-prefix-of-any-word-in-a-sentence)                                | [Python](./Python/1455-check-if-a-word-occurs-as-a-prefix-of-any-word-in-a-sentence.py)                | [Easy](./Readme/1455-check-if-a-word-occurs-as-a-prefix-of-any-word-in-a-sentence.md)                  |
| 1456 | [Maximum Number of Vowels in a Substring of Given Length](https://leetcode.com/problems/maximum-number-of-vowels-in-a-substring-of-given-length/)                                         | [Python](./Python/1456-maximum-number-of-vowels-in-a-substring-of-given-length.py)                     | [Medium](./Readme/1456-maximum-number-of-vowels-in-a-substring-of-given-length.md)                     |
| 1457 | [Pseudo-Palindromic Paths in a Binary Tree](https://leetcode.com/problems/pseudo-palindromic-paths-in-a-binary-tree/)                                                                     | [Python](./Python/1457-pseudo-palindromic-paths-in-a-binary-tree.py)                                   | [Medium](./Readme/1457-pseudo-palindromic-paths-in-a-binary-tree.md)                                   |
| 1458 | [Max Dot Product of Two Subsequences](https://leetcode.com/problems/max-dot-product-of-two-subsequences/)                                                                                 | [Python](./Python/1458-max-dot-product-of-two-subsequences.py)                                         | [Hard](./Readme/1458-max-dot-product-of-two-subsequences.md)                                           |
| 1460 | [Make Two Arrays Equal by Reversing Subarrays](https://leetcode.com/problems/make-two-arrays-equal-by-reversing-subarrays/)                                                               | [Python](./Python/1460-make-two-arrays-equal-by-reversing-subarrays.py)                                | [Easy](./Readme/1460-make-two-arrays-equal-by-reversing-subarrays.md)                                  |
| 1463 | [Cherry Pickup II](https://leetcode.com/problems/cherry-pickup-ii/)                                                                                                                       | [Python](./Python/1463-cherry-pickup-ii.py)                                                            | [Hard](./Readme/1463-cherry-pickup-ii.md)                                                              |
| 1464 | [Maximum Product of Two Elements in an Array](https://leetcode.com/problems/maximum-product-of-two-elements-in-an-array/)                                                                 | [Python](./Python/1464-maximum-product-of-two-elements-in-an-array.py)                                 | [Easy](./Readme/1464-maximum-product-of-two-elements-in-an-array.md)                                   |
| 1466 | [Reorder Routes to Make All Paths Lead to the City Zero](https://leetcode.com/problems/reorder-routes-to-make-all-paths-lead-to-the-city-zero/)                                           | [Python](./Python/1466-reorder-routes-to-make-all-paths-lead-to-the-city-zero.py)                      | [Medium](./Readme/1466-reorder-routes-to-make-all-paths-lead-to-the-city-zero.md)                      |
| 1469 | [Find All The Lonely Nodes](https://leetcode.com/problems/find-all-the-lonely-nodes/)                                                                                                     | [Python](./Python/1469-find-all-the-lonely-nodes.py)                                                   | [Easy](./Readme/1469-find-all-the-lonely-nodes.md)                                                     |
| 1470 | [Shuffle the Array](https://leetcode.com/problems/shuffle-the-array/)                                                                                                                     | [Python](./Python/1470-shuffle-the-array.py)                                                           | [Easy](./Readme/1470-shuffle-the-array.md)                                                             |
| 1481 | [Least Number of Unique Integers after K Removals](https://leetcode.com/problems/least-number-of-unique-integers-after-k-removals/)                                                       | [Python](./Python/1481-least-number-of-unique-integers-after-k-removals.py)                            | [Medium](./Readme/1481-least-number-of-unique-integers-after-k-removals.md)                            |
| 1482 | [Minimum Number of Days to Make m Bouquets](https://leetcode.com/problems/minimum-number-of-days-to-make-m-bouquets/)                                                                     | [Python](./Python/1482-minimum-number-of-days-to-make-m-bouquets.py)                                   | [Medium](./Readme/1482-minimum-number-of-days-to-make-m-bouquets.md)                                   |
| 1489 | [Find Critical and Pseudo-Critical Edges in Minimum Spanning Tree](https://leetcode.com/problems/find-critical-and-pseudo-critical-edges-in-minimum-spanning-tree/)                       | [Python](./Python/1489-find-critical-and-pseudo-critical-edges-in-minimum-spanning-tree.py)            | [Hard](./Readme/1489-find-critical-and-pseudo-critical-edges-in-minimum-spanning-tree.md)              |
| 1493 | [Longest Subarray of 1's After Deleting One Element](https://leetcode.com/problems/longest-subarray-of-1s-after-deleting-one-element/)                                                    | [Python](./Python/1493-longest-subarray-of-1s-after-deleting-one-element.py)                           | [Medium](./Readme/1493-longest-subarray-of-1s-after-deleting-one-element.md)                           |
| 1496 | [Path Crossing](https://leetcode.com/problems/path-crossing/)                                                                                                                             | [Python](./Python/1496-path-crossing.py)                                                               | [Easy](./Readme/1496-path-crossing.md)                                                                 |
| 1497 | [Check If Array Pairs Are Divisible by k](https://leetcode.com/problems/check-if-array-pairs-are-divisible-by-k/)                                                                         | [Python](./Python/1497-check-if-array-pairs-are-divisible-by-k.py)                                     | [Medium](./Readme/1497-check-if-array-pairs-are-divisible-by-k.md)                                     |
| 1508 | [Range Sum of Sorted Subarray Sums](https://leetcode.com/problems/range-sum-of-sorted-subarray-sums/)                                                                                     | [Python](./Python/1508-range-sum-of-sorted-subarray-sums.py)                                           | [Medium](./Readme/1508-range-sum-of-sorted-subarray-sums.md)                                           |
| 1509 | [Minimum Difference Between Largest and Smallest Value in Three Moves](https://leetcode.com/problems/minimum-difference-between-largest-and-smallest-value-in-three-moves/)               | [Python](./Python/1509-minimum-difference-between-largest-and-smallest-value-in-three-moves.py)        | [Medium](./Readme/1509-minimum-difference-between-largest-and-smallest-value-in-three-moves.md)        |
| 1512 | [Number of Good Pairs](https://leetcode.com/problems/number-of-good-pairs/)                                                                                                               | [Python](./Python/1512-number-of-good-pairs.py)                                                        | [Easy](./Readme/1512-number-of-good-pairs.md)                                                          |
| 1514 | [Path with Maximum Probability](https://leetcode.com/problems/path-with-maximum-probability/)                                                                                             | [Python](./Python/1514-path-with-maximum-probability.py)                                               | [Medium](./Readme/1514-path-with-maximum-probability.md)                                               |
| 1518 | [Water Bottles](https://leetcode.com/problems/water-bottles/)                                                                                                                             | [Python](./Python/1518-water-bottles.py)                                                               | [Easy](./Readme/1518-water-bottles.md)                                                                 |
| 1530 | [Number of Good Leaf Nodes Pairs](https://leetcode.com/problems/number-of-good-leaf-nodes-pairs/)                                                                                         | [Python](./Python/1530-number-of-good-leaf-nodes-pairs.py)                                             | [Medium](./Readme/1530-number-of-good-leaf-nodes-pairs.md)                                             |
| 1531 | [String Compression II](https://leetcode.com/problems/string-compression-ii/)                                                                                                             | [Python](./Python/1531-string-compression-ii.py)                                                       | [Hard](./Readme/1531-string-compression-ii.md)                                                         |
| 1535 | [Find the Winner of an Array Game](https://leetcode.com/problems/find-the-winner-of-an-array-game/)                                                                                       | [Python](./Python/1535-find-the-winner-of-an-array-game.py)                                            | [Medium](./Readme/1535-find-the-winner-of-an-array-game.md)                                            |
| 1544 | [Make The String Great](https://leetcode.com/problems/make-the-string-great/)                                                                                                             | [Python](./Python/1544-make-the-string-great.py)                                                       | [Easy](./Readme/1544-make-the-string-great.md)                                                         |
| 1545 | [Find Kth Bit in Nth Binary String](https://leetcode.com/problems/find-kth-bit-in-nth-binary-string)                                                                                      | [Python](./Python/1545-find-kth-bit-in-nth-binary-string.py)                                           | [Medium](./Readme/1545-find-kth-bit-in-nth-binary-string.md)                                           |
| 1550 | [Three Consecutive Odds](https://leetcode.com/problems/three-consecutive-odds/)                                                                                                           | [Python](./Python/1550-three-consecutive-odds.py)                                                      | [Medium](./Readme/1550-three-consecutive-odds.md)                                                      |
| 1552 | [Magnetic Force Between Two Balls](https://leetcode.com/problems/magnetic-force-between-two-balls/)                                                                                       | [Python](./Python/1552-magnetic-force-between-two-balls.py)                                            | [Medium](./Readme/1552-magnetic-force-between-two-balls.md)                                            |
| 1561 | [Maximum Number of Coins You Can Get](https://leetcode.com/problems/maximum-number-of-coins-you-can-get/)                                                                                 | [Python](./Python/1561-maximum-number-of-coins-you-can-get.py)                                         | [Medium](./Readme/1561-maximum-number-of-coins-you-can-get.md)                                         |
| 1568 | [Minimum Number of Days to Disconnect Island](https://leetcode.com/problems/minimum-number-of-days-to-disconnect-island/)                                                                 | [Python](./Python/1568-minimum-number-of-days-to-disconnect-island.py)                                 | [Hard](./Readme/1568-minimum-number-of-days-to-disconnect-island.md)                                   |
| 1574 | [Shortest Subarray to be Removed to Make Array Sorted](https://leetcode.com/problems/shortest-subarray-to-be-removed-to-make-array-sorted)                                                | [Python](./Python/1574-shortest-subarray-to-be-removed-to-make-array-sorted.py)                        | [Medium](./Readme/1574-shortest-subarray-to-be-removed-to-make-array-sorted.md)                        |
| 1578 | [Minimum Deletion Cost to Avoid Repeating Letters](https://leetcode.com/problems/minimum-deletion-cost-to-avoid-repeating-letters/)                                                       | [Python](./Python/1578-minimum-deletion-cost-to-avoid-repeating-letters.py)                            | [Medium](./Readme/1578-minimum-deletion-cost-to-avoid-repeating-letters.md)                            |
| 1579 | [Remove Max Number of Edges to Keep Graph Fully Traversable](https://leetcode.com/problems/remove-max-number-of-edges-to-keep-graph-fully-traversable/)                                   | [Python](./Python/1579-remove-max-number-of-edges-to-keep-graph-fully-traversable.py)                  | [Hard](./Readme/1579-remove-max-number-of-edges-to-keep-graph-fully-traversable.md)                    |
| 1580 | [Put Boxes Into the Warehouse II](https://leetcode.com/problems/put-boxes-into-the-warehouse-ii/)                                                                                         | [Python](./Python/1580-put-boxes-into-the-warehouse-ii.py)                                             | [Medium](./Readme/1580-put-boxes-into-the-warehouse-ii.md)                                             |
| 1581 | [Customer Who Visited but Did Not Make Any Transactions](https://leetcode.com/problems/customer-who-visited-but-did-not-make-any-transactions/)                                           | [SQL](./SQL/1581-customer-who-visited-but-did-not-make-any-transactions.sql)                           | [Easy](./Readme/1581-customer-who-visited-but-did-not-make-any-transactions.md)                        |
| 1582 | [Special Positions in a Binary Matrix](https://leetcode.com/problems/special-positions-in-a-binary-matrix/)                                                                               | [Python](./Python/1582-special-positions-in-a-binary-matrix.py)                                        | [Easy](./Readme/1582-special-positions-in-a-binary-matrix.md)                                          |
| 1584 | [Min Cost to Connect All Points](https://leetcode.com/problems/min-cost-to-connect-all-points/)                                                                                           | [Python](./Python/1584-min-cost-to-connect-all-points.py)                                              | [Medium](./Readme/1584-min-cost-to-connect-all-points.md)                                              |
| 1590 | [Make Sum Divisible by P](https://leetcode.com/problems/make-sum-divisible-by-p/)                                                                                                         | [Python](./Python/1590-make-sum-divisible-by-p.py)                                                     | [Medium](./Readme/1590-make-sum-divisible-by-p.md)                                                     |
| 1593 | [Split a String Into the Max Number of Unique Substrings](https://leetcode.com/problems/split-a-string-into-the-max-number-of-unique-substrings)                                          | [Python](./Python/1593-split-a-string-into-the-max-number-of-unique-substrings.py)                     | [Medium](./Readme/1593-split-a-string-into-the-max-number-of-unique-substrings.md)                     |
| 1598 | [Crawler Log Folder](https://leetcode.com/problems/crawler-log-folder/)                                                                                                                   | [Python](./Python/1598-crawler-log-folder.py)                                                          | [Easy](./Readme/1598-crawler-log-folder.md)                                                            |
| 1605 | [Find Valid Matrix Given Row and Column Sums](https://leetcode.com/problems/find-valid-matrix-given-row-and-column-sums/)                                                                 | [Python](./Python/1605-find-valid-matrix-given-row-and-column-sums.py)                                 | [Medium](./Readme/1605-find-valid-matrix-given-row-and-column-sums.md)                                 |
| 1608 | [Special Array With X Elements Greater Than or Equal X](https://leetcode.com/problems/special-array-with-x-elements-greater-than-or-equal-x/)                                             | [Python](./Python/1608-special-array-with-x-elements-greater-than-or-equal-x.py)                       | [Easy](./Readme/1608-special-array-with-x-elements-greater-than-or-equal-x.md)                         |
| 1609 | [Even Odd Tree](https://leetcode.com/problems/even-odd-tree/)                                                                                                                             | [Python](./Python/1609-even-odd-tree.py)                                                               | [Medium](./Readme/1609-even-odd-tree.md)                                                               |
| 1611 | [Minimum One Bit Operations to Make Integers Zero](https://leetcode.com/problems/minimum-one-bit-operations-to-make-integers-zero/)                                                       | [Python](./Python/1611-minimum-one-bit-operations-to-make-integers-zero.py)                            | [Hard](./Readme/1611-minimum-one-bit-operations-to-make-integers-zero.md)                              |
| 1614 | [Maximum Nesting Depth of the Parentheses](https://leetcode.com/problems/maximum-nesting-depth-of-the-parentheses/)                                                                       | [Python](./Python/1614-maximum-nesting-depth-of-the-parentheses.py)                                    | [Easy](./Readme/1614-maximum-nesting-depth-of-the-parentheses.md)                                      |
| 1615 | [Maximal Network Rank](https://leetcode.com/problems/maximal-network-rank/)                                                                                                               | [Python](./Python/1615-maximal-network-rank.py)                                                        | [Medium](./Readme/1615-maximal-network-rank.md)                                                        |
| 1630 | [Arithmetic Subarrays](https://leetcode.com/problems/arithmetic-subarrays/)                                                                                                               | [Python](./Python/1630-arithmetic-subarrays.py)                                                        | [Medium](./Readme/1630-arithmetic-subarrays.md)                                                        |
| 1631 | [Path With Minimum Effort](https://leetcode.com/problems/path-with-minimum-effort/)                                                                                                       | [Python](./Python/1631-path-with-minimum-effort.py)                                                    | [Medium](./Readme/1631-path-with-minimum-effort.md)                                                    |
| 1633 | [Percentage of Users Attended a Contest](https://leetcode.com/problems/percentage-of-users-attended-a-contest/)                                                                           | [SQL](./SQL/1633-percentage-of-users-attended-a-contest.sql)                                           | [Easy](./Readme/1633-percentage-of-users-attended-a-contest.md)                                        |
| 1634 | [Add Two Polynomials Represented as Linked Lists](https://leetcode.com/problems/add-two-polynomials-represented-as-linked-lists/)                                                         | [Python](./Python/1634-add-two-polynomials-represented-as-linked-lists.py)                             | [Medium](./Readme/1634-add-two-polynomials-represented-as-linked-lists.md)                             |
| 1636 | [Sort Array by Increasing Frequency](https://leetcode.com/problems/sort-array-by-increasing-frequency/)                                                                                   | [Python](./Python/1636-sort-array-by-increasing-frequency.py)                                          | [Easy](./Readme/1636-sort-array-by-increasing-frequency.md)                                            |
| 1637 | [Widest Vertical Area Between Two Points Containing No Points](https://leetcode.com/problems/widest-vertical-area-between-two-points-containing-no-points/)                               | [Python](./Python/1637-widest-vertical-area-between-two-points-containing-no-points.py)                | [Medium](./Readme/1637-widest-vertical-area-between-two-points-containing-no-points.md)                |
| 1639 | [Number of Ways to Form a Target String Given a Dictionary](https://leetcode.com/problems/number-of-ways-to-form-a-target-string-given-a-dictionary)                                      | [Python](./Python/1639-number-of-ways-to-form-a-target-string-given-a-dictionary.py)                   | [Hard](./Readme/1639-number-of-ways-to-form-a-target-string-given-a-dictionary.md)                     |
| 1642 | [Furthest Building You Can Reach](https://leetcode.com/problems/furthest-building-you-can-reach/)                                                                                         | [Python](./Python/1642-furthest-building-you-can-reach.py)                                             | [Medium](./Readme/1642-furthest-building-you-can-reach.md)                                             |
| 1647 | [Minimum Deletions to Make Character Frequencies Unique](https://leetcode.com/problems/minimum-deletions-to-make-character-frequencies-unique/)                                           | [Python](./Python/1647-minimum-deletions-to-make-character-frequencies-unique.py)                      | [Medium](./Readme/1647-minimum-deletions-to-make-character-frequencies-unique.md)                      |
| 1652 | [Defuse the Bomb](https://leetcode.com/problems/defuse-the-bomb)                                                                                                                          | [Python](./Python/1652-defuse-the-bomb.py)                                                             | [Easy](./Readme/1652-defuse-the-bomb.md)                                                               |
| 1653 | [Minimum Deletions to Make String Balanced](https://leetcode.com/problems/minimum-deletions-to-make-string-balanced/)                                                                     | [Python](./Python/1653-minimum-deletions-to-make-string-balanced.py)                                   | [Medium](./Readme/1653-minimum-deletions-to-make-string-balanced.md)                                   |
| 1657 | [Determine if Two Strings Are Close](https://leetcode.com/problems/determine-if-two-strings-are-close/)                                                                                   | [Python](./Python/1657-determine-if-two-strings-are-close.py)                                          | [Medium](./Readme/1657-determine-if-two-strings-are-close.md)                                          |
| 1658 | [Minimum Operations to Reduce X to Zero](https://leetcode.com/problems/minimum-operations-to-reduce-x-to-zero/)                                                                           | [Python](./Python/1658-minimum-operations-to-reduce-x-to-zero.py)                                      | [Medium](./Readme/1658-minimum-operations-to-reduce-x-to-zero.md)                                      |
| 1660 | [Correct a Binary Tree](https://leetcode.com/problems/correct-a-binary-tree/)                                                                                                             | [Python](./Python/1660-correct-a-binary-tree.py)                                                       | [Medium](./Readme/1660-correct-a-binary-tree.md)                                                       |
| 1661 | [Average Time of Process per Machine](https://leetcode.com/problems/average-time-of-process-per-machine/)                                                                                 | [SQL](./SQL/1661-average-time-of-process-per-machine.sql)                                              | [Easy](./Readme/1661-average-time-of-process-per-machine.md)                                           |
| 1662 | [Check If Two String Arrays are Equivalent](https://leetcode.com/problems/check-if-two-string-arrays-are-equivalent/)                                                                     | [Python](./Python/1662-check-if-two-string-arrays-are-equivalent.py)                                   | [Easy](./Readme/1662-check-if-two-string-arrays-are-equivalent.md)                                     |
| 1669 | [Merge In Between Linked Lists](https://leetcode.com/problems/merge-in-between-linked-lists/)                                                                                             | [Python](./Python/1669-merge-in-between-linked-lists.py)                                               | [Medium](./Readme/1669-merge-in-between-linked-lists.md)                                               |
| 1671 | [Minimum Number of Removals to Make Mountain Array](https://leetcode.com/problems/minimum-number-of-removals-to-make-mountain-array)                                                      | [Python](./Python/1671-minimum-number-of-removals-to-make-mountain-array.py)                           | [Hard](./Readme/1671-minimum-number-of-removals-to-make-mountain-array.md)                             |
| 1679 | [Max Number of K-Sum Pairs](https://leetcode.com/problems/max-number-of-k-sum-pairs/)                                                                                                     | [Python](./Python/1679-max-number-of-k-sum-pairs.py)                                                   | [Medium](./Readme/1679-max-number-of-k-sum-pairs.md)                                                   |
| 1683 | [Invalid Tweets](https://leetcode.com/problems/invalid-tweets/)                                                                                                                           | [SQL](./SQL/1683-invalid-tweets.sql)                                                                   | [Easy](./Readme/1683-invalid-tweets.md)                                                                |
| 1684 | [Count the Number of Consistent Strings](https://leetcode.com/problems/count-the-number-of-consistent-strings/)                                                                           | [Python](./Python/1684-count-the-number-of-consistent-strings.py)                                      | [Easy](./Readme/1684-count-the-number-of-consistent-strings.md)                                        |
| 1685 | [Sum of Absolute Differences in a Sorted Array](https://leetcode.com/problems/sum-of-absolute-differences-in-a-sorted-array/)                                                             | [Python](./Python/1685-sum-of-absolute-differences-in-a-sorted-array.py)                               | [Medium](./Readme/1685-sum-of-absolute-differences-in-a-sorted-array.md)                               |
| 1688 | [Count of Matches in Tournament](https://leetcode.com/problems/count-of-matches-in-tournament/)                                                                                           | [Python](./Python/1688-count-of-matches-in-tournament.py)                                              | [Easy](./Readme/1688-count-of-matches-in-tournament.md)                                                |
| 1700 | [Number of Students Unable to Eat Lunch](https://leetcode.com/problems/number-of-students-unable-to-eat-lunch/)                                                                           | [Python](./Python/1700-number-of-students-unable-to-eat-lunch.py)                                      | [Easy](./Readme/1700-number-of-students-unable-to-eat-lunch.md)                                        |
| 1701 | [Average Waiting Time](https://leetcode.com/problems/average-waiting-time/)                                                                                                               | [Python](./Python/1701-average-waiting-time.py)                                                        | [Medium](./Readme/1701-average-waiting-time.md)                                                        |
| 1704 | [Determine if String Halves Are Alike](https://leetcode.com/problems/determine-if-string-halves-are-alike/)                                                                               | [Python](./Python/1704-determine-if-string-halves-are-alike.py)                                        | [Easy](./Readme/1704-determine-if-string-halves-are-alike.md)                                          |
| 1716 | [Calculate Money in Leetcode Bank](https://leetcode.com/problems/calculate-money-in-leetcode-bank/)                                                                                       | [Python](./Python/1716-calculate-money-in-leetcode-bank.py)                                            | [Easy](./Readme/1716-calculate-money-in-leetcode-bank.md)                                              |
| 1717 | [Maximum Score From Removing Substrings](https://leetcode.com/problems/maximum-score-from-removing-substrings/)                                                                           | [Python](./Python/1717-maximum-score-from-removing-substrings.py)                                      | [Medium](./Readme/1717-maximum-score-from-removing-substrings.md)                                      |
| 1721 | [Swapping Nodes in a Linked List](https://leetcode.com/problems/swapping-nodes-in-a-linked-list)                                                                                          | [Python](./Python/1721-swapping-nodes-in-a-linked-list.py)                                             | [Medium](./Readme/1721-swapping-nodes-in-a-linked-list.md)                                             |
| 1727 | [Largest Submatrix With Rearrangements](https://leetcode.com/problems/largest-submatrix-with-rearrangements/)                                                                             | [Python](./Python/1727-largest-submatrix-with-rearrangements.py)                                       | [Medium](./Readme/1727-largest-submatrix-with-rearrangements.md)                                       |
| 1730 | [Shortest Path to Get Food](https://leetcode.com/problems/shortest-path-to-get-food/)                                                                                                     | [Python](./Python/1730-shortest-path-to-get-food.py)                                                   | [Medium](./Readme/1730-shortest-path-to-get-food.md)                                                   |
| 1732 | [Find the Highest Altitude](https://leetcode.com/problems/find-the-highest-altitude/)                                                                                                     | [Python](./Python/1732-find-the-highest-altitude.py)                                                   | [Easy](./Readme/1732-find-the-highest-altitude.md)                                                     |
| 1740 | [Find Distance in a Binary Tree](https://leetcode.com/problems/find-distance-in-a-binary-tree/)                                                                                           | [Python](./Python/1740-find-distance-in-a-binary-tree.py)                                              | [Medium](./Readme/1740-find-distance-in-a-binary-tree.md)                                              |
| 1743 | [Restore the Array From Adjacent Pairs](https://leetcode.com/problems/restore-the-array-from-adjacent-pairs/)                                                                             | [Python](./Python/1743-restore-the-array-from-adjacent-pairs.py)                                       | [Medium](./Readme/1743-restore-the-array-from-adjacent-pairs.md)                                       |
| 1750 | [Minimum Length of String After Deleting Similar Ends](https://leetcode.com/problems/minimum-length-of-string-after-deleting-similar-ends/)                                               | [Python](./Python/1750-minimum-length-of-string-after-deleting-similar-ends.py)                        | [Medium](./Readme/1750-minimum-length-of-string-after-deleting-similar-ends.md)                        |
| 1757 | [Recyclable and Low Fat Products](https://leetcode.com/problems/recyclable-and-low-fat-products/)                                                                                         | [SQL](./SQL/1757-recyclable-and-low-fat-products.sql)                                                  | [Medium](./Readme/1757-recyclable-and-low-fat-products.md)                                             |
| 1758 | [Minimum Changes To Make Alternating Binary String](https://leetcode.com/problems/minimum-changes-to-make-alternating-binary-string/)                                                     | [Python](./Python/1758-minimum-changes-to-make-alternating-binary-string.py)                           | [Easy](./Readme/1758-minimum-changes-to-make-alternating-binary-string.md)                             |
| 1759 | [Count Number of Homogenous Substrings](https://leetcode.com/problems/count-number-of-homogenous-substrings/)                                                                             | [Python](./Python/1759-count-number-of-homogenous-substrings.py)                                       | [Medium](./Readme/1759-count-number-of-homogenous-substrings.md)                                       |
| 1760 | [Minimum Limit of Balls in a Bag](https://leetcode.com/problems/minimum-limit-of-balls-in-a-bag)                                                                                          | [Python](./Python/1760-minimum-limit-of-balls-in-a-bag.py)                                             | [Medium](./Readme/1760-minimum-limit-of-balls-in-a-bag.md)                                             |
| 1768 | [Merge Strings Alternately](https://leetcode.com/problems/merge-strings-alternately/)                                                                                                     | [Python](./Python/1768-merge-strings-alternately.py)                                                   | [Easy](./Readme/1768-merge-strings-alternately.md)                                                     |
| 1770 | [Maximum Score from Performing Multiplication Operations](https://leetcode.com/problems/maximum-score-from-performing-multiplication-operations/)                                         | [Python](./Python/1770-maximum-score-from-performing-multiplication-operations.py)                     | [Hard](./Readme/1770-maximum-score-from-performing-multiplication-operations.md)                       |
| 1791 | [Find Center of Star Graph](https://leetcode.com/problems/find-center-of-star-graph/)                                                                                                     | [Python](./Python/1791-find-center-of-star-graph.py)                                                   | [Easy](./Readme/1791-find-center-of-star-graph.md)                                                     |
| 1793 | [Maximum Score of a Good Subarray](https://leetcode.com/problems/maximum-score-of-a-good-subarray/)                                                                                       | [Python](./Python/1793-maximum-score-of-a-good-subarray.py)                                            | [Hard](./Readme/1793-maximum-score-of-a-good-subarray.md)                                              |
| 1802 | [Maximum Value at a Given Index in a Bounded Array](https://leetcode.com/problems/maximum-value-at-a-given-index-in-a-bounded-array/)                                                     | [Python](./Python/1802-maximum-value-at-a-given-index-in-a-bounded-array.py)                           | [Medium](./Readme/1802-maximum-value-at-a-given-index-in-a-bounded-array.md)                           |
| 1804 | [Implement Trie II (Prefix Tree)](https://leetcode.com/problems/implement-trie-ii-prefix-tree/)                                                                                           | [Python](./Python/1804-implement-trie-ii-prefix-tree.py)                                               | [Medium](./Readme/1804-implement-trie-ii-prefix-tree.md)                                               |
| 1813 | [Sentence Similarity III](https://leetcode.com/problems/sentence-similarity-iii/)                                                                                                         | [Python](./Python/1813-sentence-similarity-iii.py)                                                     | [Medium](./Readme/1813-sentence-similarity-iii.md)                                                     |
| 1814 | [Count Nice Pairs in an Array](https://leetcode.com/problems/count-nice-pairs-in-an-array/)                                                                                               | [Python](./Python/1814-count-nice-pairs-in-an-array.py)                                                | [Medium](./Readme/1814-count-nice-pairs-in-an-array.md)                                                |
| 1829 | [Maximum XOR for Each Query](https://leetcode.com/problems/maximum-xor-for-each-query)                                                                                                    | [Python](./Python/1829-maximum-xor-for-each-query.py)                                                  | [Medium](./Readme/1829-maximum-xor-for-each-query.md)                                                  |
| 1834 | [Single-Threaded CPU](https://leetcode.com/problems/single-threaded-cpu)                                                                                                                  | [Python](./Python/1834-single-threaded-cpu.py)                                                         | [Medium](./Readme/1834-single-threaded-cpu.md)                                                         |
| 1836 | [Remove Duplicates from an Unsorted Linked List](https://leetcode.com/problems/remove-duplicates-from-an-unsorted-linked-list/)                                                           | [Python](./Python/1836-remove-duplicates-from-an-unsorted-linked-list.py)                              | [Medium](./Readme/1836-remove-duplicates-from-an-unsorted-linked-list.md)                              |
| 1838 | [Frequency of the Most Frequent Element](https://leetcode.com/problems/frequency-of-the-most-frequent-element/)                                                                           | [Python](./Python/1838-frequency-of-the-most-frequent-element.py)                                      | [Medium](./Readme/1838-frequency-of-the-most-frequent-element.md)                                      |
| 1845 | [Seat Reservation Manager](https://leetcode.com/problems/seat-reservation-manager/)                                                                                                       | [Python](./Python/1845-seat-reservation-manager.py)                                                    | [Medium](./Readme/1845-seat-reservation-manager.md)                                                    |
| 1846 | [Maximum Element After Decreasing and Rearranging](https://leetcode.com/problems/maximum-element-after-decreasing-and-rearranging/)                                                       | [Python](./Python/1846-maximum-element-after-decreasing-and-rearranging.py)                            | [Medium](./Readme/1846-maximum-element-after-decreasing-and-rearranging.md)                            |
| 1858 | [Longest Word With All Prefixes](https://leetcode.com/problems/longest-word-with-all-prefixes/)                                                                                           | [Python](./Python/1858-longest-word-with-all-prefixes.py)                                              | [Medium](./Readme/1858-longest-word-with-all-prefixes.md)                                              |
| 1861 | [Rotating the Box](https://leetcode.com/problems/rotating-the-box)                                                                                                                        | [Python](./Python/1861-rotating-the-box.py)                                                            | [Medium](./Readme/1861-rotating-the-box.md)                                                            |
| 1863 | [Sum of All Subset XOR Totals](https://leetcode.com/problems/sum-of-all-subset-xor-totals/)                                                                                               | [Python](./Python/1863-sum-of-all-subset-xor-totals.py)                                                | [Easy](./Readme/1863-sum-of-all-subset-xor-totals.md)                                                  |
| 1870 | [Minimum Speed to Arrive on Time](https://leetcode.com/problems/minimum-speed-to-arrive-on-time/)                                                                                         | [Python](./Python/1870-minimum-speed-to-arrive-on-time.py)                                             | [Medium](./Readme/1870-minimum-speed-to-arrive-on-time.md)                                             |
| 1877 | [Minimize Maximum Pair Sum in Array](https://leetcode.com/problems/minimize-maximum-pair-sum-in-array/)                                                                                   | [Python](./Python/1877-minimize-maximum-pair-sum-in-array.py)                                          | [Medium](./Readme/1877-minimize-maximum-pair-sum-in-array.md)                                          |
| 1885 | [Count Pairs in Two Arrays](https://leetcode.com/problems/count-pairs-in-two-arrays/)                                                                                                     | [Python](./Python/1885-count-pairs-in-two-arrays.py)                                                   | [Medium](./Readme/1885-count-pairs-in-two-arrays.md)                                                   |
| 1887 | [Reduction Operations to Make the Array Elements Equal](https://leetcode.com/problems/reduction-operations-to-make-the-array-elements-equal/)                                             | [Python](./Python/1887-reduction-operations-to-make-the-array-elements-equal.py)                       | [Medium](./Readme/1887-reduction-operations-to-make-the-array-elements-equal.md)                       |
| 1891 | [Cutting Ribbons](https://leetcode.com/problems/cutting-ribbons)                                                                                                                          | [Python](./Python/1891-cutting-ribbons.py)                                                             | [Medium](./Readme/1891-cutting-ribbons.md)                                                             |
| 1894 | [Find the Student That Will Replace the Chalk](https://leetcode.com/problems/find-the-student-that-will-replace-the-chalk/)                                                               | [Python](./Python/1894-find-the-student-that-will-replace-the-chalk.py)                                | [Medium](./Readme/1894-find-the-student-that-will-replace-the-chalk.md)                                |
| 1897 | [Redistribute Characters to Make All Strings Equal](https://leetcode.com/problems/redistribute-characters-to-make-all-strings-equal/)                                                     | [Python](./Python/1897-redistribute-characters-to-make-all-strings-equal.py)                           | [Easy](./Readme/1897-redistribute-characters-to-make-all-strings-equal.md)                             |
| 1898 | [Maximum Number of Removable Characters](https://leetcode.com/problems/maximum-number-of-removable-characters)                                                                            | [Python](./Python/1898-maximum-number-of-removable-characters.py)                                      | [Medium](./Readme/1898-maximum-number-of-removable-characters.md)                                      |
| 1899 | [Merge Triplets to Form Target Triplet](https://leetcode.com/problems/merge-triplets-to-form-target-triplet/)                                                                             | [Python](./Python/1899-merge-triplets-to-form-target-triplet.py)                                       | [Medium](./Readme/1899-merge-triplets-to-form-target-triplet.md)                                       |
| 1903 | [Largest Odd Number in String](https://leetcode.com/problems/largest-odd-number-in-string/)                                                                                               | [Python](./Python/1903-largest-odd-number-in-string.py)                                                | [Easy](./Readme/1903-largest-odd-number-in-string.md)                                                  |
| 1905 | [Count Sub Islands](https://leetcode.com/problems/count-sub-islands/)                                                                                                                     | [Python](./Python/1905-count-sub-islands.py)                                                           | [Medium](./Readme/1905-count-sub-islands.md)                                                           |
| 1913 | [Maximum Product Difference Between Two Pairs](https://leetcode.com/problems/maximum-product-difference-between-two-pairs/)                                                               | [Python](./Python/1913-maximum-product-difference-between-two-pairs.py)                                | [Easy](./Readme/1913-maximum-product-difference-between-two-pairs.md)                                  |
| 1915 | [Number of Wonderful Substrings](https://leetcode.com/problems/number-of-wonderful-substrings/)                                                                                           | [Python](./Python/1915-number-of-wonderful-substrings.py)                                              | [Medium](./Readme/1915-number-of-wonderful-substrings.md)                                              |
| 1920 | [Build Array from Permutation](https://leetcode.com/problems/build-array-from-permutation/)                                                                                               | [C++](./C++/1920-build-array-from-permutation.cpp)                                                     | [Easy](./Readme/1920-build-array-from-permutation.md)                                                  |
| 1921 | [Eliminate Maximum Number of Monsters](https://leetcode.com/problems/eliminate-maximum-number-of-monsters/)                                                                               | [Python](./Python/1921-eliminate-maximum-number-of-monsters.py)                                        | [Medium](./Readme/1921-eliminate-maximum-number-of-monsters.md)                                        |
| 1926 | [Nearest Exit from Entrance in Maze](https://leetcode.com/problems/nearest-exit-from-entrance-in-maze/)                                                                                   | [Python](./Python/1926-nearest-exit-from-entrance-in-maze.py)                                          | [Medium](./Readme/1926-nearest-exit-from-entrance-in-maze.md)                                          |
| 1930 | [Unique Length-3 Palindromic Subsequences](https://leetcode.com/problems/unique-length-3-palindromic-subsequences/)                                                                       | [Python](./Python/1930-unique-length-3-palindromic-subsequences.py)                                    | [Medium](./Readme/1930-unique-length-3-palindromic-subsequences.md)                                    |
| 1934 | [Confirmation Rate](https://leetcode.com/problems/confirmation-rate/)                                                                                                                     | [SQL](./SQL/1934-confirmation-rate.sql)                                                                | [Medium](./Readme/1934-confirmation-rate.md)                                                           |
| 1937 | [Maximum Number of Points with Cost](https://leetcode.com/problems/maximum-number-of-points-with-cost/)                                                                                   | [Python](./Python/1937-maximum-number-of-points-with-cost.py)                                          | [Medium](./Readme/1937-maximum-number-of-points-with-cost.md)                                          |
| 1940 | [Longest Common Subsequence Between Sorted Arrays](https://leetcode.com/problems/longest-common-subsequence-between-sorted-arrays/)                                                       | [Python](./Python/1940-longest-common-subsequence-between-sorted-arrays.py)                            | [Medium](./Readme/1940-longest-common-subsequence-between-sorted-arrays.md)                            |
| 1942 | [The Number of the Smallest Unoccupied Chair](https://leetcode.com/problems/the-number-of-the-smallest-unoccupied-chair/)                                                                 | [Python](./Python/1942-the-number-of-the-smallest-unoccupied-chair.py)                                 | [Medium](./Readme/1942-the-number-of-the-smallest-unoccupied-chair.md)                                 |
| 1945 | [Sum of Digits of String After Convert](https://leetcode.com/problems/sum-of-digits-of-string-after-convert/)                                                                             | [Python](./Python/1945-sum-of-digits-of-string-after-convert.py)                                       | [Easy](./Readme/1945-sum-of-digits-of-string-after-convert.md)                                         |
| 1957 | [Delete Characters to Make Fancy String](https://leetcode.com/problems/delete-characters-to-make-fancy-string)                                                                            | [Python](./Python/1957-delete-characters-to-make-fancy-string.py)                                      | [Easy](./Readme/1957-delete-characters-to-make-fancy-string.md)                                        |
| 1963 | [Minimum Number of Swaps to Make the String Balanced](https://leetcode.com/problems/minimum-number-of-swaps-to-make-the-string-balanced/)                                                 | [Python](./Python/1963-minimum-number-of-swaps-to-make-the-string-balanced.py)                         | [Medium](./Readme/1963-minimum-number-of-swaps-to-make-the-string-balanced.md)                         |
| 1971 | [Find if Path Exists in Graph](https://leetcode.com/problems/find-if-path-exists-in-graph/)                                                                                               | [Python](./Python/1971-find-if-path-exists-in-graph.py)                                                | [Easy](./Readme/1971-find-if-path-exists-in-graph.md)                                                  |
| 1973 | [Count Nodes Equal to Sum of Descendants](https://leetcode.com/problems/count-nodes-equal-to-sum-of-descendants/)                                                                         | [Python](./Python/1973-count-nodes-equal-to-sum-of-descendants.py)                                     | [Medium](./Readme/1973-count-nodes-equal-to-sum-of-descendants.md)                                     |
| 1975 | [Maximum Matrix Sum](https://leetcode.com/problems/maximum-matrix-sum)                                                                                                                    | [Python](./Python/1975-maximum-matrix-sum.py)                                                          | [Medium](./Readme/1975-maximum-matrix-sum.md)                                                          |
| 1980 | [Find Unique Binary String](https://leetcode.com/problems/find-unique-binary-string/)                                                                                                     | [Python](./Python/1980-find-unique-binary-string.py)                                                   | [Medium](./Readme/1980-find-unique-binary-string.md)                                                   |
| 1992 | [Find All Groups of Farmland](https://leetcode.com/problems/find-all-groups-of-farmland/)                                                                                                 | [Python](./Python/1992-find-all-groups-of-farmland.py)                                                 | [Medium](./Readme/1992-find-all-groups-of-farmland.md)                                                 |
| 2000 | [Reverse Prefix of Word](https://leetcode.com/problems/reverse-prefix-of-word/)                                                                                                           | [Python](./Python/2000-reverse-prefix-of-word.py)                                                      | [Easy](./Readme/2000-reverse-prefix-of-word.md)                                                        |
| 2002 | [Maximum Product of the Length of Two Palindromic Subsequences](https://leetcode.com/problems/maximum-product-of-the-length-of-two-palindromic-subsequences)                              | [Python](./Python/2002-maximum-product-of-the-length-of-two-palindromic-subsequences.py)               | [Medium](./Readme/2002-maximum-product-of-the-length-of-two-palindromic-subsequences.md)               |
| 2009 | [Minimum Number of Operations to Make Array Continuous](https://leetcode.com/problems/minimum-number-of-operations-to-make-array-continuous/)                                             | [Python](./Python/2009-minimum-number-of-operations-to-make-array-continuous.py)                       | [Hard](./Readme/2009-minimum-number-of-operations-to-make-array-continuous.md)                         |
| 2013 | [Detect Squares](https://leetcode.com/problems/detect-squares/)                                                                                                                           | [Python](./Python/2013-detect-squares.py)                                                              | [Medium](./Readme/2013-detect-squares.md)                                                              |
| 2022 | [Convert 1D Array Into 2D Array](https://leetcode.com/problems/convert-1d-array-into-2d-array/)                                                                                           | [Python](./Python/2022-convert-1d-array-into-2d-array.py)                                              | [Easy](./Readme/2022-convert-1d-array-into-2d-array.md)                                                |
| 2028 | [Find Missing Observations](https://leetcode.com/problems/find-missing-observations/)                                                                                                     | [Python](./Python/2028-find-missing-observations.py)                                                   | [Medium](./Readme/2028-find-missing-observations.md)                                                   |
| 2037 | [Minimum Number of Moves to Seat Everyone](https://leetcode.com/problems/minimum-number-of-moves-to-seat-everyone/)                                                                       | [Python](./Python/2037-minimum-number-of-moves-to-seat-everyone.py)                                    | [Easy](./Readme/2037-minimum-number-of-moves-to-seat-everyone.md)                                      |
| 2038 | [Remove Colored Pieces if Both Neighbors are the Same Color](https://leetcode.com/problems/remove-colored-pieces-if-both-neighbors-are-the-same-color/)                                   | [Python](./Python/2038-remove-colored-pieces-if-both-neighbors-are-the-same-color.py)                  | [Medium](./Readme/2038-remove-colored-pieces-if-both-neighbors-are-the-same-color.md)                  |
| 2044 | [Count Number of Maximum Bitwise OR Subsets](https://leetcode.com/problems/count-number-of-maximum-bitwise-or-subsets)                                                                    | [Python](./Python/2044-count-number-of-maximum-bitwise-or-subsets.py)                                  | [Medium](./Readme/2044-count-number-of-maximum-bitwise-or-subsets.md)                                  |
| 2045 | [Second Minimum Time to Reach Destination](https://leetcode.com/problems/second-minimum-time-to-reach-destination/)                                                                       | [Python](./Python/2045-second-minimum-time-to-reach-destination.py)                                    | [Hard](./Readme/2045-second-minimum-time-to-reach-destination.md)                                      |
| 2050 | [Number of Different Integers in a String](https://leetcode.com/problems/number-of-different-integers-in-a-string/)                                                                       | [Python](./Python/2050-number-of-different-integers-in-a-string.py)                                    | [Easy](./Readme/2050-number-of-different-integers-in-a-string.md)                                      |
| 2053 | [Kth Distinct String in an Array](https://leetcode.com/problems/kth-distinct-string-in-an-array/)                                                                                         | [Python](./Python/2053-kth-distinct-string-in-an-array.py)                                             | [Easy](./Readme/2053-kth-distinct-string-in-an-array.md)                                               |
| 2054 | [Two Best Non-Overlapping Events](https://leetcode.com/problems/two-best-non-overlapping-events)                                                                                          | [Python](./Python/2054-two-best-non-overlapping-events.py)                                             | [Medium](./Readme/2054-two-best-non-overlapping-events.md)                                             |
| 2058 | [Find the Minimum and Maximum Number of Nodes Between Critical Points](https://leetcode.com/problems/find-the-minimum-and-maximum-number-of-nodes-between-critical-points/)               | [Python](./Python/2058-find-the-minimum-and-maximum-number-of-nodes-between-critical-points.py)        | [Medium](./Readme/2058-find-the-minimum-and-maximum-number-of-nodes-between-critical-points.md)        |
| 2061 | [Number of Spaces Cleaning Robot Cleaned](https://leetcode.com/problems/number-of-spaces-cleaning-robot-cleaned/)                                                                         | [Python](./Python/2061-number-of-spaces-cleaning-robot-cleaned.py)                                     | [Medium](./Readme/2061-number-of-spaces-cleaning-robot-cleaned.md)                                     |
| 2062 | [Count Vowel Substrings of a String](https://leetcode.com/problems/count-vowel-substrings-of-a-string)                                                                                    | [Python](./Python/2062-count-vowel-substrings-of-a-string.py)                                          | [Easy](./Readme/2062-count-vowel-substrings-of-a-string.md)                                            |
| 2064 | [Minimized Maximum of Products Distributed to Any Store](https://leetcode.com/problems/minimized-maximum-of-products-distributed-to-any-store)                                            | [Python](./Python/2064-minimized-maximum-of-products-distributed-to-any-store.py)                      | [Medium](./Readme/2064-minimized-maximum-of-products-distributed-to-any-store.md)                      |
| 2070 | [Most Beautiful Item for Each Query](https://leetcode.com/problems/most-beautiful-item-for-each-query)                                                                                    | [Python](./Python/2070-most-beautiful-item-for-each-query.py)                                          | [Medium](./Readme/2070-most-beautiful-item-for-each-query.md)                                          |
| 2073 | [Time Needed to Buy Tickets](https://leetcode.com/problems/time-needed-to-buy-tickets/)                                                                                                   | [Python](./Python/2073-time-needed-to-buy-tickets.py)                                                  | [Easy](./Readme/2073-time-needed-to-buy-tickets.md)                                                    |
| 2083 | [Substrings That Begin and End With the Same Letter](https://leetcode.com/problems/substrings-that-begin-and-end-with-the-same-letter/)                                                   | [Python](./Python/2083-substrings-that-begin-and-end-with-the-same-letter.py)                          | [Medium](./Readme/2083-substrings-that-begin-and-end-with-the-same-letter.md)                          |
| 2092 | [Find All People With Secret](https://leetcode.com/problems/find-all-people-with-secret/)                                                                                                 | [Python](./Python/2092-find-all-people-with-secret.py)                                                 | [Hard](./Readme/2092-find-all-people-with-secret.md)                                                   |
| 2093 | [Minimum Cost to Reach City With Discounts](https://leetcode.com/problems/minimum-cost-to-reach-city-with-discounts/)                                                                     | [Python](./Python/2093-minimum-cost-to-reach-city-with-discounts.py)                                   | [Medium](./Readme/2093-minimum-cost-to-reach-city-with-discounts.md)                                   |
| 2095 | [Delete the Middle Node of a Linked List](https://leetcode.com/problems/delete-the-middle-node-of-a-linked-list/)                                                                         | [Python](./Python/2095-delete-the-middle-node-of-a-linked-list.py)                                     | [Medium](./Readme/2095-delete-the-middle-node-of-a-linked-list.md)                                     |
| 2096 | [Step-By-Step Directions From a Binary Tree Node to Another](https://leetcode.com/problems/step-by-step-directions-from-a-binary-tree-node-to-another/)                                   | [Python](./Python/2096-step-by-step-directions-from-a-binary-tree-node-to-another.py)                  | [Medium](./Readme/2096-step-by-step-directions-from-a-binary-tree-node-to-another.md)                  |
| 2097 | [Valid Arrangement of Pairs](https://leetcode.com/problems/valid-arrangement-of-pairs)                                                                                                    | [Python](./Python/2097-valid-arrangement-of-pairs.py)                                                  | [Hard](./Readme/2097-valid-arrangement-of-pairs.md)                                                    |
| 2101 | [Detonate the Maximum Bombs](https://leetcode.com/problems/detonate-the-maximum-bombs)                                                                                                    | [Python](./Python/2101-detonate-the-maximum-bombs.py)                                                  | [Medium](./Readme/2101-detonate-the-maximum-bombs.md)                                                  |
| 2107 | [Number of Unique Flavors After Sharing K Candies](https://leetcode.com/problems/number-of-unique-flavors-after-sharing-k-candies)                                                        | [Python](./Python/2107-number-of-unique-flavors-after-sharing-k-candies.py)                            | [Medium](./Readme/2107-number-of-unique-flavors-after-sharing-k-candies.md)                            |
| 2108 | [Find First Palindromic String in the Array](https://leetcode.com/problems/find-first-palindromic-string-in-the-array/)                                                                   | [Python](./Python/2108-find-first-palindromic-string-in-the-array.py)                                  | [Medium](./Readme/2108-find-first-palindromic-string-in-the-array.md)                                  |
| 2109 | [Adding Spaces to a String](https://leetcode.com/problems/adding-spaces-to-a-string)                                                                                                      | [Python](./Python/2109-adding-spaces-to-a-string.py)                                                   | [Medium](./Readme/2109-adding-spaces-to-a-string.md)                                                   |
| 2125 | [Number of Laser Beams in a Bank](https://leetcode.com/problems/number-of-laser-beams-in-a-bank/)                                                                                         | [Python](./Python/2125-number-of-laser-beams-in-a-bank.py)                                             | [Medium](./Readme/2125-number-of-laser-beams-in-a-bank.md)                                             |
| 2130 | [Maximum Twin Sum of a Linked List](https://leetcode.com/problems/maximum-twin-sum-of-a-linked-list/)                                                                                     | [Python](./Python/2130-maximum-twin-sum-of-a-linked-list.py)                                           | [Medium](./Readme/2130-maximum-twin-sum-of-a-linked-list.md)                                           |
| 2134 | [Minimum Swaps to Group All 1's Together II](https://leetcode.com/problems/minimum-swaps-to-group-all-1s-together-ii/)                                                                    | [Python](./Python/2134-minimum-swaps-to-group-all-1s-together-ii.py)                                   | [Medium](./Readme/2134-minimum-swaps-to-group-all-1s-together-ii.md)                                   |
| 2141 | [Maximum Running Time of N Computers](https://leetcode.com/problems/maximum-running-time-of-n-computers/)                                                                                 | [Python](./Python/2141-maximum-running-time-of-n-computers.py)                                         | [Hard](./Readme/2141-maximum-running-time-of-n-computers.md)                                           |
| 2147 | [Number of Ways to Divide a Long Corridor](https://leetcode.com/problems/number-of-ways-to-divide-a-long-corridor/)                                                                       | [Python](./Python/2147-number-of-ways-to-divide-a-long-corridor.py)                                    | [Hard](./Readme/2147-number-of-ways-to-divide-a-long-corridor.md)                                      |
| 2149 | [Rearrange Array Elements by Sign](https://leetcode.com/problems/rearrange-array-elements-by-sign/)                                                                                       | [Python](./Python/2149-rearrange-array-elements-by-sign.py)                                            | [Medium](./Readme/2149-rearrange-array-elements-by-sign.md)                                            |
| 2181 | [Merge Nodes in Between Zeros](https://leetcode.com/problems/merge-nodes-in-between-zeros/)                                                                                               | [Python](./Python/2181-merge-nodes-in-between-zeros.py)                                                | [Medium](./Readme/2181-merge-nodes-in-between-zeros.md)                                                |
| 2192 | [All Ancestors of a Node in a Directed Acyclic Graph](https://leetcode.com/problems/all-ancestors-of-a-node-in-a-directed-acyclic-graph/)                                                 | [Python](./Python/2192-all-ancestors-of-a-node-in-a-directed-acyclic-graph.py)                         | [Medium](./Readme/2192-all-ancestors-of-a-node-in-a-directed-acyclic-graph.md)                         |
| 2196 | [Create Binary Tree From Descriptions](https://leetcode.com/problems/create-binary-tree-from-descriptions/)                                                                               | [Python](./Python/2196-create-binary-tree-from-descriptions.py)                                        | [Medium](./Readme/2196-create-binary-tree-from-descriptions.md)                                        |
| 2204 | [Distance to a Cycle in Undirected Graph](https://leetcode.com/problems/distance-to-a-cycle-in-undirected-graph)                                                                          | [Python](./Python/2204-distance-to-a-cycle-in-undirected-graph.py)                                     | [Hard](./Readme/2204-distance-to-a-cycle-in-undirected-graph.md)                                       |
| 2215 | [Find the Difference of Two Arrays](https://leetcode.com/problems/find-the-difference-of-two-arrays/)                                                                                     | [Python](./Python/2215-find-the-difference-of-two-arrays.py)                                           | [Easy](./Readme/2215-find-the-difference-of-two-arrays.md)                                             |
| 2220 | [Minimum Bit Flips to Convert Number](https://leetcode.com/problems/minimum-bit-flips-to-convert-number/)                                                                                 | [Python](./Python/2220-minimum-bit-flips-to-convert-number.py)                                         | [Easy](./Readme/2220-minimum-bit-flips-to-convert-number.md)                                           |
| 2225 | [Find Players With Zero or One Losses](https://leetcode.com/problems/find-players-with-zero-or-one-losses/)                                                                               | [Python](./Python/2225-find-players-with-zero-or-one-losses.py)                                        | [Medium](./Readme/2225-find-players-with-zero-or-one-losses.md)                                        |
| 2251 | [Number of Flowers in Full Bloom](https://leetcode.com/problems/number-of-flowers-in-full-bloom/)                                                                                         | [Python](./Python/2251-number-of-flowers-in-full-bloom.py)                                             | [Hard](./Readme/2251-number-of-flowers-in-full-bloom.md)                                               |
| 2257 | [Count Unguarded Cells in the Grid](https://leetcode.com/problems/count-unguarded-cells-in-the-grid)                                                                                      | [Python](./Python/2257-count-unguarded-cells-in-the-grid.py)                                           | [Medium](./Readme/2257-count-unguarded-cells-in-the-grid.md)                                           |
| 2264 | [Largest 3-Same-Digit Number in String](https://leetcode.com/problems/largest-3-same-digit-number-in-string/)                                                                             | [Python](./Python/2264-largest-3-same-digit-number-in-string.py)                                       | [Easy](./Readme/2264-largest-3-same-digit-number-in-string.md)                                         |
| 2265 | [Count Nodes Equal to Average of Subtree](https://leetcode.com/problems/count-nodes-equal-to-average-of-subtree/)                                                                         | [Python](./Python/2265-count-nodes-equal-to-average-of-subtree.py)                                     | [Medium](./Readme/2265-count-nodes-equal-to-average-of-subtree.md)                                     |
| 2275 | [Largest Combination With Bitwise AND Greater Than Zero](https://leetcode.com/problems/largest-combination-with-bitwise-and-greater-than-zero)                                            | [Python](./Python/2275-largest-combination-with-bitwise-and-greater-than-zero.py)                      | [Medium](./Readme/2275-largest-combination-with-bitwise-and-greater-than-zero.md)                      |
| 2285 | [Maximum Total Importance of Roads](https://leetcode.com/problems/maximum-total-importance-of-roads/)                                                                                     | [Python](./Python/2285-maximum-total-importance-of-roads.py)                                           | [Medium](./Readme/2285-maximum-total-importance-of-roads.md)                                           |
| 2290 | [Minimum Obstacle Removal to Reach Corner](https://leetcode.com/problems/minimum-obstacle-removal-to-reach-corner)                                                                        | [Python](./Python/2290-minimum-obstacle-removal-to-reach-corner.py)                                    | [Hard](./Readme/2290-minimum-obstacle-removal-to-reach-corner.md)                                      |
| 2291 | [Maximum Profit From Trading Stocks](https://leetcode.com/problems/maximum-profit-from-trading-stocks)                                                                                    | [Python](./Python/2291-maximum-profit-from-trading-stocks.py)                                          | [Medium](./Readme/2291-maximum-profit-from-trading-stocks.md)                                          |
| 2300 | [Successful Pairs of Spells and Potions](https://leetcode.com/problems/successful-pairs-of-spells-and-potions/)                                                                           | [Python](./Python/2300-successful-pairs-of-spells-and-potions.py)                                      | [Medium](./Readme/2300-successful-pairs-of-spells-and-potions.md)                                      |
| 2303 | [Calculate Amount Paid in Taxes](https://leetcode.com/problems/calculate-amount-paid-in-taxes/)                                                                                           | [Python](./Python/2303-calculate-amount-paid-in-taxes.py)                                              | [Easy](./Readme/2303-calculate-amount-paid-in-taxes.md)                                                |
| 2331 | [Evaluate Boolean Binary Tree](https://leetcode.com/problems/evaluate-boolean-binary-tree/)                                                                                               | [Python](./Python/2331-evaluate-boolean-binary-tree.py)                                                | [Easy](./Readme/2331-evaluate-boolean-binary-tree.md)                                                  |
| 2334 | [Subarray With Elements Greater Than Varying Threshold](https://leetcode.com/problems/subarray-with-elements-greater-than-varying-threshold/)                                             | [Python](./Python/2334-subarray-with-elements-greater-than-varying-threshold.py)                       | [Hard](./Readme/2334-subarray-with-elements-greater-than-varying-threshold.md)                         |
| 2336 | [Smallest Number in Infinite Set](https://leetcode.com/problems/smallest-number-in-infinite-set/)                                                                                         | [Python](./Python/2336-smallest-number-in-infinite-set.py)                                             | [Medium](./Readme/2336-smallest-number-in-infinite-set.md)                                             |
| 2337 | [Move Pieces to Obtain a String](https://leetcode.com/problems/move-pieces-to-obtain-a-string)                                                                                            | [Python](./Python/2337-move-pieces-to-obtain-a-string.py)                                              | [Medium](./Readme/2337-move-pieces-to-obtain-a-string.md)                                              |
| 2352 | [Equal Row and Column Pairs](https://leetcode.com/problems/equal-row-and-column-pairs/)                                                                                                   | [Python](./Python/2352-equal-row-and-column-pairs.py)                                                  | [Medium](./Readme/2352-equal-row-and-column-pairs.md)                                                  |
| 2353 | [Design a Food Rating System](https://leetcode.com/problems/design-a-food-rating-system/)                                                                                                 | [Python](./Python/2353-design-a-food-rating-system.py)                                                 | [Medium](./Readme/2353-design-a-food-rating-system.md)                                                 |
| 2355 | [Maximum Number of Books You Can Take](https://leetcode.com/problems/maximum-number-of-books-you-can-take/)                                                                               | [Python](./Python/2355-maximum-number-of-books-you-can-take.py)                                        | [Hard](./Readme/2355-maximum-number-of-books-you-can-take.md)                                          |
| 2361 | [Minimum Costs Using the Train Line](https://leetcode.com/problems/minimum-costs-using-the-train-line/)                                                                                   | [Python](./Python/2361-minimum-costs-using-the-train-line.py)                                          | [Hard](./Readme/2361-minimum-costs-using-the-train-line.md)                                            |
| 2366 | [Minimum Replacements to Sort the Array](https://leetcode.com/problems/minimum-replacements-to-sort-the-array/)                                                                           | [Python](./Python/2366-minimum-replacements-to-sort-the-array.py)                                      | [Hard](./Readme/2366-minimum-replacements-to-sort-the-array.md)                                        |
| 2369 | [Check If There Is a Valid Partition for the Array](https://leetcode.com/problems/check-if-there-is-a-valid-partition-for-the-array/)                                                     | [Python](./Python/2369-check-if-there-is-a-valid-partition-for-the-array.py)                           | [Medium](./Readme/2369-check-if-there-is-a-valid-partition-for-the-array.md)                           |
| 2370 | [Longest Ideal Subsequence](https://leetcode.com/problems/longest-ideal-subsequence/)                                                                                                     | [Python](./Python/2370-longest-ideal-subsequence.py)                                                   | [Medium](./Readme/2370-longest-ideal-subsequence.md)                                                   |
| 2371 | [Minimize Maximum Value in a Grid](https://leetcode.com/problems/minimize-maximum-value-in-a-grid)                                                                                        | [Python](./Python/2371-minimize-maximum-value-in-a-grid.py)                                            | [Hard](./Readme/2371-minimize-maximum-value-in-a-grid.md)                                              |
| 2373 | [Largest Local Values in a Matrix](https://leetcode.com/problems/largest-local-values-in-a-matrix/)                                                                                       | [Python](./Python/2373-largest-local-values-in-a-matrix.py)                                            | [Easy](./Readme/2373-largest-local-values-in-a-matrix.md)                                              |
| 2385 | [Amount of Time for Binary Tree to be Infected](https://leetcode.com/problems/amount-of-time-for-binary-tree-to-be-infected/)                                                             | [Python](./Python/2385-amount-of-time-for-binary-tree-to-be-infected.py)                               | [Medium](./Readme/2385-amount-of-time-for-binary-tree-to-be-infected.md)                               |
| 2390 | [Removing Stars From a String](https://leetcode.com/problems/removing-stars-from-a-string/)                                                                                               | [Python](./Python/2390-removing-stars-from-a-string.py)                                                | [Medium](./Readme/2390-removing-stars-from-a-string.md)                                                |
| 2391 | [Minimum Amount of Time to Collect Garbage](https://leetcode.com/problems/minimum-amount-of-time-to-collect-garbage/)                                                                     | [Python](./Python/2391-minimum-amount-of-time-to-collect-garbage.py)                                   | [Medium](./Readme/2391-minimum-amount-of-time-to-collect-garbage.md)                                   |
| 2392 | [Build a Matrix With Conditions](https://leetcode.com/problems/build-a-matrix-with-conditions/)                                                                                           | [Python](./Python/2392-build-a-matrix-with-conditions.py)                                              | [Hard](./Readme/2392-build-a-matrix-with-conditions.md)                                                |
| 2393 | [Count Strictly Increasing Subarrays](https://leetcode.com/problems/count-strictly-increasing-subarrays/)                                                                                 | [Python](./Python/2393-count-strictly-increasing-subarrays.py)                                         | [Medium](./Readme/2393-count-strictly-increasing-subarrays.md)                                         |
| 2402 | [Meeting Rooms III](https://leetcode.com/problems/meeting-rooms-iii/)                                                                                                                     | [Python](./Python/2402-meeting-rooms-iii.py)                                                           | [Hard](./Readme/2402-meeting-rooms-iii.md)                                                             |
| 2406 | [Divide Intervals Into Minimum Number of Groups](https://leetcode.com/problems/divide-intervals-into-minimum-number-of-groups/)                                                           | [Python](./Python/2406-divide-intervals-into-minimum-number-of-groups.py)                              | [Medium](./Readme/2406-divide-intervals-into-minimum-number-of-groups.md)                              |
| 2416 | [Sum of Prefix Scores of Strings](https://leetcode.com/problems/sum-of-prefix-scores-of-strings/)                                                                                         | [Python](./Python/2416-sum-of-prefix-scores-of-strings.py)                                             | [Hard](./Readme/2416-sum-of-prefix-scores-of-strings.md)                                               |
| 2418 | [Sort the People](https://leetcode.com/problems/sort-the-people/)                                                                                                                         | [Python](./Python/2418-sort-the-people.py)                                                             | [Easy](./Readme/2418-sort-the-people.md)                                                               |
| 2419 | [Longest Subarray With Maximum Bitwise AND](https://leetcode.com/problems/longest-subarray-with-maximum-bitwise-and/)                                                                     | [Python](./Python/2419-longest-subarray-with-maximum-bitwise-and.py)                                   | [Medium](./Readme/2419-longest-subarray-with-maximum-bitwise-and.md)                                   |
| 2433 | [Find the Original Array of Prefix XOR](https://leetcode.com/problems/find-the-original-array-of-prefix-xor/)                                                                             | [Python](./Python/2433-find-the-original-array-of-prefix-xor.py)                                       | [Medium](./Readme/2433-find-the-original-array-of-prefix-xor.md)                                       |
| 2439 | [Minimize Maximum of Array](https://leetcode.com/problems/minimize-maximum-of-array)                                                                                                      | [Python](./Python/2439-minimize-maximum-of-array.py)                                                   | [Medium](./Readme/2439-minimize-maximum-of-array.md)                                                   |
| 2441 | [Largest Positive Integer That Exists With Its Negative](https://leetcode.com/problems/largest-positive-integer-that-exists-with-its-negative/)                                           | [Python](./Python/2441-largest-positive-integer-that-exists-with-its-negative.py)                      | [Easy](./Readme/2441-largest-positive-integer-that-exists-with-its-negative.md)                        |
| 2444 | [Count Subarrays with Fixed Bounds](https://leetcode.com/problems/count-subarrays-with-fixed-bounds/)                                                                                     | [Python](./Python/2444-count-subarrays-with-fixed-bounds.py)                                           | [Hard](./Readme/2444-count-subarrays-with-fixed-bounds.md)                                             |
| 2458 | [Height of Binary Tree After Subtree Removal Queries](https://leetcode.com/problems/height-of-binary-tree-after-subtree-removal-queries)                                                  | [Python](./Python/2458-height-of-binary-tree-after-subtree-removal-queries.py)                         | [Hard](./Readme/2458-height-of-binary-tree-after-subtree-removal-queries.md)                           |
| 2461 | [Maximum Sum of Distinct Subarrays With Length K](https://leetcode.com/problems/maximum-sum-of-distinct-subarrays-with-length-k)                                                          | [Python](./Python/2461-maximum-sum-of-distinct-subarrays-with-length-k.py)                             | [Medium](./Readme/2461-maximum-sum-of-distinct-subarrays-with-length-k.md)                             |
| 2462 | [Total Cost to Hire K Workers](https://leetcode.com/problems/total-cost-to-hire-k-workers/)                                                                                               | [Python](./Python/2462-total-cost-to-hire-k-workers.py)                                                | [Medium](./Readme/2462-total-cost-to-hire-k-workers.md)                                                |
| 2463 | [Minimum Total Distance Traveled](https://leetcode.com/problems/minimum-total-distance-traveled)                                                                                          | [Python](./Python/2463-minimum-total-distance-traveled.py)                                             | [Hard](./Readme/2463-minimum-total-distance-traveled.md)                                               |
| 2473 | [Minimum Cost to Buy Apples](https://leetcode.com/problems/minimum-cost-to-buy-apples/)                                                                                                   | [Python](./Python/2473-minimum-cost-to-buy-apples.py)                                                  | [Medium](./Readme/2473-minimum-cost-to-buy-apples.md)                                                  |
| 2482 | [Difference Between Ones and Zeros in Row and Column](https://leetcode.com/problems/difference-between-ones-and-zeros-in-row-and-column/)                                                 | [Python](./Python/2482-difference-between-ones-and-zeros-in-row-and-column.py)                         | [Medium](./Readme/2482-difference-between-ones-and-zeros-in-row-and-column.md)                         |
| 2483 | [Minimum Penalty for a Shop](https://leetcode.com/problems/minimum-penalty-for-a-shop/)                                                                                                   | [Python](./Python/2483-minimum-penalty-for-a-shop.py)                                                  | [Medium](./Readme/2483-minimum-penalty-for-a-shop.md)                                                  |
| 2485 | [Find the Pivot Integer](https://leetcode.com/problems/find-the-pivot-integer/)                                                                                                           | [Python](./Python/2485-find-the-pivot-integer.py)                                                      | [Easy](./Readme/2485-find-the-pivot-integer.md)                                                        |
| 2486 | [Append Characters to String to Make Subsequence](https://leetcode.com/problems/append-characters-to-string-to-make-subsequence/)                                                         | [Python](./Python/2486-append-characters-to-string-to-make-subsequence.py)                             | [Medium](./Readme/2486-append-characters-to-string-to-make-subsequence.md)                             |
| 2487 | [Remove Nodes from Linked List](https://leetcode.com/problems/remove-nodes-from-linked-list/)                                                                                             | [Python](./Python/2487-remove-nodes-from-linked-list.py)                                               | [Medium](./Readme/2487-remove-nodes-from-linked-list.md)                                               |
| 2490 | [Circular Sentence](https://leetcode.com/problems/circular-sentence)                                                                                                                      | [Python](./Python/2490-circular-sentence.py)                                                           | [Easy](./Readme/2490-circular-sentence.md)                                                             |
| 2491 | [Divide Players Into Teams of Equal Skill](https://leetcode.com/problems/divide-players-into-teams-of-equal-skill/)                                                                       | [Python](./Python/2491-divide-players-into-teams-of-equal-skill.py)                                    | [Medium](./Readme/2491-divide-players-into-teams-of-equal-skill.md)                                    |
| 2501 | [Longest Square Streak in an Array](https://leetcode.com/problems/longest-square-streak-in-an-array)                                                                                      | [Python](./Python/2501-longest-square-streak-in-an-array.py)                                           | [Medium](./Readme/2501-longest-square-streak-in-an-array.md)                                           |
| 2505 | [Bitwise OR of All Subarrays](https://leetcode.com/problems/bitwise-or-of-all-subarrays/)                                                                                                 | [Python](./Python/2505-bitwise-or-of-all-subsequence-sums.py)                                          | [Medium](./Readme/2505-bitwise-or-of-all-subsequence-sums.md)                                          |
| 2516 | [Take K of Each Character From Left and Right](https://leetcode.com/problems/take-k-of-each-character-from-left-and-right)                                                                | [Python](./Python/2516-take-k-of-each-character-from-left-and-right.py)                                | [Medium](./Readme/2516-take-k-of-each-character-from-left-and-right.md)                                |
| 2530 | [Maximal Score After Applying K Operations](https://leetcode.com/problems/maximal-score-after-applying-k-operations)                                                                      | [Python](./Python/2530-maximal-score-after-applying-k-operations.py)                                   | [Medium](./Readme/2530-maximal-score-after-applying-k-operations.md)                                   |
| 2540 | [Minimum Common Value](https://leetcode.com/problems/minimum-common-value/)                                                                                                               | [Python](./Python/2540-minimum-common-value.py)                                                        | [Easy](./Readme/2540-minimum-common-value.md)                                                          |
| 2542 | [Maximum Subsequence Score](https://leetcode.com/problems/maximum-subsequence-score/)                                                                                                     | [Python](./Python/2542-maximum-subsequence-score.py)                                                   | [Medium](./Readme/2542-maximum-subsequence-score.md)                                                   |
| 2554 | [Maximum Number of Integers to Choose From a Range I](https://leetcode.com/problems/maximum-number-of-integers-to-choose-from-a-range-i)                                                  | [Python](./Python/2554-maximum-number-of-integers-to-choose-from-a-range-i.py)                         | [Medium](./Readme/2554-maximum-number-of-integers-to-choose-from-a-range-i.md)                         |
| 2558 | [Take Gifts From the Richest Pile](https://leetcode.com/problems/take-gifts-from-the-richest-pile/)                                                                                       | [Python](./Python/2558-take-gifts-from-the-richest-pile.py)                                            | [Easy](./Readme/2558-take-gifts-from-the-richest-pile.md)                                              |
| 2563 | [Count the Number of Fair Pairs](https://leetcode.com/problems/count-the-number-of-fair-pairs)                                                                                            | [Python](./Python/2563-count-the-number-of-fair-pairs.py)                                              | [Medium](./Readme/2563-count-the-number-of-fair-pairs.md)                                              |
| 2577 | [Minimum Time to Visit a Cell in a Grid](https://leetcode.com/problems/minimum-time-to-visit-a-cell-in-a-grid)                                                                            | [Python](./Python/2577-minimum-time-to-visit-a-cell-in-a-grid.py)                                      | [Hard](./Readme/2577-minimum-time-to-visit-a-cell-in-a-grid.md)                                        |
| 2582 | [Pass the Pillow](https://leetcode.com/problems/pass-the-pillow/)                                                                                                                         | [Python](./Python/2582-pass-the-pillow.py)                                                             | [Easy](./Readme/2582-pass-the-pillow.md)                                                               |
| 2583 | [Kth Largest Sum in a Binary Tree](https://leetcode.com/problems/kth-largest-sum-in-a-binary-tree)                                                                                        | [Python](./Python/2583-kth-largest-sum-in-a-binary-tree.py)                                            | [Medium](./Readme/2583-kth-largest-sum-in-a-binary-tree.md)                                            |
| 2592 | [Maximize Greatness of an Array](https://leetcode.com/problems/maximize-greatness-of-an-array/)                                                                                           | [Python](./Python/2592-maximize-greatness-of-an-array.py)                                              | [Medium](./Readme/2592-maximize-greatness-of-an-array.md)                                              |
| 2597 | [The Number of Beautiful Subsets](https://leetcode.com/problems/the-number-of-beautiful-subsets/)                                                                                         | [Python](./Python/2597-the-number-of-beautiful-subsets.py)                                             | [Medium](./Readme/2597-the-number-of-beautiful-subsets.md)                                             |
| 2601 | [Prime Subtraction Operation](https://leetcode.com/problems/prime-subtraction-operation)                                                                                                  | [Python](./Python/2601-prime-subtraction-operation.py)                                                 | [Medium](./Readme/2601-prime-subtraction-operation.md)                                                 |
| 2610 | [Convert an Array into a 2D Array with Conditions](https://leetcode.com/problems/convert-an-array-into-a-2d-array-with-conditions/)                                                       | [Python](./Python/2610-convert-an-array-into-a-2d-array-with-conditions.py)                            | [Medium](./Readme/2610-convert-an-array-into-a-2d-array-with-conditions.md)                            |
| 2616 | [Minimize the Maximum Difference of Pairs](https://leetcode.com/problems/minimize-the-maximum-difference-of-pairs/)                                                                       | [Python](./Python/2616-minimize-the-maximum-difference-of-pairs.py)                                    | [Medium](./Readme/2616-minimize-the-maximum-difference-of-pairs.md)                                    |
| 2618 | [Check if Object Instance of Class](https://leetcode.com/problems/check-if-object-instance-of-class/)                                                                                     | [TypeScript](./TypeScript/2618-check-if-object-instance-of-class.ts)                                   | [Medium](./Readme/2618-check-if-object-instance-of-class.md)                                           |
| 2619 | [Array.prototype.last](https://leetcode.com/problems/array-prototype-last/)                                                                                                               | [JavaScript](./JavaScript/2619-array-prototype-last.js)                                                | [Easy](./Readme/2619-array-prototype-last.md)                                                          |
| 2620 | [Counter](https://leetcode.com/problems/counter/)                                                                                                                                         | [JavaScript](./JavaScript/2620-counter.js)                                                             | [Easy](./Readme/2620-counter.md)                                                                       |
| 2621 | [Sleep](https://leetcode.com/problems/sleep/)                                                                                                                                             | [JavaScript](./JavaScript/2621-sleep.js)                                                               | [Easy](./Readme/2621-sleep.md)                                                                         |
| 2622 | [Cache with Time Limit](https://leetcode.com/problems/cache-with-time-limit/)                                                                                                             | [JavaScript](./JavaScript/2622-cache-with-time-limit.js)                                               | [Medium](./Readme/2622-cache-with-time-limit.md)                                                       |
| 2623 | [Memoize](https://leetcode.com/problems/memoize/)                                                                                                                                         | [JavaScript](./JavaScript/2623-memoize.js)                                                             | [Medium](./Readme/2623-memoize.md)                                                                     |
| 2624 | [Snail Traversal](https://leetcode.com/problems/snail-traversal/)                                                                                                                         | [TypeScript](./TypeScript/2624-snail-traversal.ts)                                                     | [Medium](./Readme/2624-snail-traversal.md)                                                             |
| 2625 | [Flatten Deeply Nested Array](https://leetcode.com/problems/flatten-deeply-nested-array/)                                                                                                 | [JavaScript](./JavaScript/2625-flatten-deeply-nested-array.js)                                         | [Medium](./Readme/2625-flatten-deeply-nested-array.md)                                                 |
| 2626 | [Array Reduce Transformation](https://leetcode.com/problems/array-reduce-transformation/)                                                                                                 | [JavaScript](./JavaScript/2626-array-reduce-transformation.js)                                         | [Easy](./Readme/2626-array-reduce-transformation.md)                                                   |
| 2627 | [Debounce](https://leetcode.com/problems/debounce/)                                                                                                                                       | [JavaScript](./JavaScript/2627-debounce.js)                                                            | [Medium](./Readme/2627-debounce.md)                                                                    |
| 2628 | [JSON Deep Equal](https://leetcode.com/problems/json-deep-equal/)                                                                                                                         | [JavaScript](./JavaScript/2628-json-deep-equal.js)                                                     | [Medium](./Readme/2628-json-deep-equal.md)                                                             |
| 2629 | [Function Composition](https://leetcode.com/problems/function-composition/)                                                                                                               | [JavaScript](./JavaScript/2629-function-composition.js)                                                | [Easy](./Readme/2629-function-composition.md)                                                          |
| 2630 | [Memoize II](https://leetcode.com/problems/memoize-ii/)                                                                                                                                   | [TypeScript](./TypeScript/2630-memoize-ii.ts)                                                          | [Hard](./Readme/2630-memoize-ii.md)                                                                    |
| 2631 | [Group By](https://leetcode.com/problems/group-by/)                                                                                                                                       | [JavaScript](./JavaScript/2631-group-by.js)                                                            | [Medium](./Readme/2631-group-by.md)                                                                    |
| 2632 | [Curry](https://leetcode.com/problems/curry/)                                                                                                                                             | [JavaScript](./JavaScript/2632-curry.js)                                                               | [Medium](./Readme/2632-curry.md)                                                                       |
| 2633 | [Convert Object to JSON String](https://leetcode.com/problems/convert-object-to-json-string/)                                                                                             | [JavaScript](./JavaScript/2633-convert-object-to-json-string.js)                                       | [Medium](./Readme/2633-convert-object-to-json-string.md)                                               |
| 2634 | [Filter Elements from Array](https://leetcode.com/problems/filter-elements-from-array/)                                                                                                   | [JavaScript](./JavaScript/2634-filter-elements-from-array.js)                                          | [Easy](./Readme/2634-filter-elements-from-array.md)                                                    |
| 2635 | [Apply Transform over Each Element in Array](https://leetcode.com/problems/apply-transform-over-each-element-in-array/)                                                                   | [JavaScript](./JavaScript/2635-apply-transform-over-each-element-in-array.js)                          | [Easy](./Readme/2635-apply-transform-over-each-element-in-array.md)                                    |
| 2636 | [Promise Pool](https://leetcode.com/problems/promise-pool/)                                                                                                                               | [JavaScript](./JavaScript/2636-promise-pool.js)                                                        | [Medium](./Readme/2636-promise-pool.md)                                                                |
| 2637 | [Promise Time Limit](https://leetcode.com/problems/promise-time-limit/)                                                                                                                   | [JavaScript](./JavaScript/2637-promise-time-limit.js)                                                  | [Medium](./Readme/2637-promise-time-limit.md)                                                          |
| 2641 | [Cousins in Binary Tree II](https://leetcode.com/problems/cousins-in-binary-tree-ii)                                                                                                      | [Python](./Python/2641-cousins-in-binary-tree-ii.py)                                                   | [Medium](./Readme/2641-cousins-in-binary-tree-ii.md)                                                   |
| 2642 | [Design Graph with Shortest Path Calculator](https://leetcode.com/problems/design-graph-with-shortest-path-calculator/)                                                                   | [Python](./Python/2642-design-graph-with-shortest-path-calculator.py)                                  | [Hard](./Readme/2642-design-graph-with-shortest-path-calculator.md)                                    |
| 2648 | [Generate Fibonacci Sequence](https://leetcode.com/problems/generate-fibonacci-sequence/)                                                                                                 | [TypeScript](./TypeScript/2648-generate-fibonacci-sequence.ts)                                         | [Easy](./Readme/2648-generate-fibonacci-sequence.md)                                                   |
| 2649 | [Nested Array Generator](https://leetcode.com/problems/nested-array-generator/)                                                                                                           | [TypeScript](./TypeScript/2649-nested-array-generator.ts)                                              | [Medium](./Readme/2649-nested-array-generator.md)                                                      |
| 2650 | [Design Cancellable Function](https://leetcode.com/problems/design-cancellable-function/)                                                                                                 | [TypeScript](./TypeScript/2650-design-cancellable-function.ts)                                         | [Hard](./Readme/2650-design-cancellable-function.md)                                                   |
| 2664 | [The Knight's Tour](https://leetcode.com/problems/the-knights-tour)                                                                                                                       | [Python](./Python/2664-the-knights-tour.py)                                                            | [Medium](./Readme/2664-the-knights-tour.md)                                                            |
| 2665 | [Counter II](https://leetcode.com/problems/counter-ii/)                                                                                                                                   | [JavaScript](./JavaScript/2665-counter-ii.js)                                                          | [Easy](./Readme/2665-counter-ii.md)                                                                    |
| 2666 | [Allow One Function Call](https://leetcode.com/problems/allow-one-function-call/)                                                                                                         | [JavaScript](./JavaScript/2666-allow-one-function-call.js)                                             | [Easy](./Readme/2666-allow-one-function-call.md)                                                       |
| 2667 | [Create Hello World Function](https://leetcode.com/problems/create-hello-world-function/)                                                                                                 | [JavaScript](./JavaScript/2667-create-hello-world-function.js)                                         | [Easy](./Readme/2667-create-hello-world-function.md)                                                   |
| 2675 | [Array of Objects to Matrix](https://leetcode.com/problems/array-of-objects-to-matrix/)                                                                                                   | [TypeScript](./TypeScript/2675-array-of-objects-to-matrix.ts)                                          | [Hard](./Readme/2675-array-of-objects-to-matrix.md)                                                    |
| 2676 | [Throttle](https://leetcode.com/problems/throttle/)                                                                                                                                       | [JavaScript](./JavaScript/2676-throttle.js)                                                            | [Medium](./Readme/2676-throttle.md)                                                                    |
| 2677 | [Chunk Array](https://leetcode.com/problems/chunk-array/)                                                                                                                                 | [JavaScript](./JavaScript/2677-chunk-array.js)                                                         | [Easy](./Readme/2677-chunk-array.md)                                                                   |
| 2678 | [Number of Senior Citizens](https://leetcode.com/problems/number-of-senior-citizens/)                                                                                                     | [Python](./Python/2678-number-of-senior-citizens.py)                                                   | [Easy](./Readme/2678-number-of-senior-citizens.md)                                                     |
| 2684 | [Maximum Number of Moves in a Grid](https://leetcode.com/problems/maximum-number-of-moves-in-a-grid)                                                                                      | [Python](./Python/2684-maximum-number-of-moves-in-a-grid.py)                                           | [Medium](./Readme/2684-maximum-number-of-moves-in-a-grid.md)                                           |
| 2690 | [Infinite Method Object](https://leetcode.com/problems/infinite-method-object/)                                                                                                           | [TypeScript](./TypeScript/2690-infinite-method-object.ts)                                              | [Easy](./Readme/2690-infinite-method-object.md)                                                        |
| 2692 | [Make Object Immutable](https://leetcode.com/problems/make-object-immutable/)                                                                                                             | [TypeScript](./TypeScript/2692-make-object-immutable.ts)                                               | [Medium](./Readme/2692-make-object-immutable.md)                                                       |
| 2694 | [Event Emitter](https://leetcode.com/problems/event-emitter/)                                                                                                                             | [JavaScript](./JavaScript/2694-event-emitter.js)                                                       | [Medium](./Readme/2694-event-emitter.md)                                                               |
| 2695 | [Array Wrapper](https://leetcode.com/problems/array-wrapper/)                                                                                                                             | [JavaScript](./JavaScript/2695-array-wrapper.js)                                                       | [Easy](./Readme/2695-array-wrapper.md)                                                                 |
| 2696 | [Minimum String Length After Removing Substrings](https://leetcode.com/problems/minimum-string-length-after-removing-substrings/)                                                         | [Python](./Python/2696-minimum-string-length-after-removing-substrings.py)                             | [Easy](./Readme/2696-minimum-string-length-after-removing-substrings.md)                               |
| 2699 | [Modify Graph Edge Weights](https://leetcode.com/problems/modify-graph-edge-weights/)                                                                                                     | [Python](./Python/2699-modify-graph-edge-weights.py)                                                   | [Hard](./Readme/2699-modify-graph-edge-weights.md)                                                     |
| 2703 | [Return Length of Arguments Passed](https://leetcode.com/problems/return-length-of-arguments-passed/)                                                                                     | [JavaScript](./JavaScript/2703-return-length-of-arguments-passed.js)                                   | [Easy](./Readme/2703-return-length-of-arguments-passed.md)                                             |
| 2704 | [To Be or Not To Be](https://leetcode.com/problems/to-be-or-not-to-be/)                                                                                                                   | [JavaScript](./JavaScript/2704-to-be-or-not-to-be.js)                                                  | [Easy](./Readme/2704-to-be-or-not-to-be.md)                                                            |
| 2705 | [Compact Object](https://leetcode.com/problems/compact-object/)                                                                                                                           | [JavaScript](./JavaScript/2705-compact-object.js)                                                      | [Medium](./Readme/2705-compact-object.md)                                                              |
| 2706 | [Buy Two Chocolates](https://leetcode.com/problems/buy-two-chocolates/)                                                                                                                   | [Python](./Python/2706-buy-two-chocolates.py)                                                          | [Easy](./Readme/2706-buy-two-chocolates.md)                                                            |
| 2707 | [Extra Characters in a String](https://leetcode.com/problems/extra-characters-in-a-string/)                                                                                               | [Python](./Python/2707-extra-characters-in-a-string.py)                                                | [Medium](./Readme/2707-extra-characters-in-a-string.md)                                                |
| 2709 | [Greatest Common Divisor Traversal](https://leetcode.com/problems/greatest-common-divisor-traversal/)                                                                                     | [Python](./Python/2709-greatest-common-divisor-traversal.py)                                           | [Hard](./Readme/2709-greatest-common-divisor-traversal.md)                                             |
| 2715 | [Execute Cancellable Function with Delay](https://leetcode.com/problems/execute-cancellable-function-with-delay/)                                                                         | [JavaScript](./JavaScript/2715-execute-cancellable-function-with-delay.js)                             | [Easy](./Readme/2715-execute-cancellable-function-with-delay.md)                                       |
| 2721 | [Execute Asynchronous Functions in Parallel](https://leetcode.com/problems/execute-asynchronous-functions-in-parallel/)                                                                   | [JavaScript](./JavaScript/2721-execute-asynchronous-functions-in-parallel.js)                          | [Medium](./Readme/2721-execute-asynchronous-functions-in-parallel.md)                                  |
| 2722 | [Join Two Arrays by ID](https://leetcode.com/problems/join-two-arrays-by-id/)                                                                                                             | [JavaScript](./JavaScript/2722-join-two-arrays-by-id.js)                                               | [Medium](./Readme/2722-join-two-arrays-by-id.md)                                                       |
| 2723 | [Add Two Promises](https://leetcode.com/problems/add-two-promises/)                                                                                                                       | [JavaScript](./JavaScript/2723-add-two-promises.js)                                                    | [Easy](./Readme/2723-add-two-promises.md)                                                              |
| 2724 | [Sort By](https://leetcode.com/problems/sort-by/)                                                                                                                                         | [JavaScript](./JavaScript/2724-sort-by.js)                                                             | [Easy](./Readme/2724-sort-by.md)                                                                       |
| 2725 | [Interval Cancellation](https://leetcode.com/problems/interval-cancellation/)                                                                                                             | [JavaScript](./JavaScript/2725-interval-cancellation.js)                                               | [Easy](./Readme/2725-interval-cancellation.md)                                                         |
| 2726 | [Calculator with Method Chaining](https://leetcode.com/problems/calculator-with-method-chaining/)                                                                                         | [JavaScript](./JavaScript/2726-calculator-with-method-chaining.js)                                     | [Easy](./Readme/2726-calculator-with-method-chaining.md)                                               |
| 2727 | [Is Object Empty](https://leetcode.com/problems/is-object-empty/)                                                                                                                         | [JavaScript](./JavaScript/2727-is-object-empty.js)                                                     | [Easy](./Readme/2727-is-object-empty.md)                                                               |
| 2742 | [Painting the Walls](https://leetcode.com/problems/painting-the-walls/)                                                                                                                   | [Python](./Python/2742-painting-the-walls.py)                                                          | [Hard](./Readme/2742-painting-the-walls.md)                                                            |
| 2743 | [Count Substrings Without Repeating Character](https://leetcode.com/problems/count-substrings-without-repeating-character/)                                                               | [Python](./Python/2743-count-substrings-without-repeating-character.py)                                | [Medium](./Readme/2743-count-substrings-without-repeating-character.md)                                |
| 2751 | [Robot Collisions](https://leetcode.com/problems/robot-collisions/)                                                                                                                       | [Python](./Python/2751-robot-collisions.py)                                                            | [Hard](./Readme/2751-robot-collisions.md)                                                              |
| 2762 | [Continuous Subarrays](https://leetcode.com/problems/continuous-subarrays/)                                                                                                               | [Python](./Python/2762-continuous-subarrays.py)                                                        | [Medium](./Readme/2762-continuous-subarrays.md)                                                        |
| 2771 | [Longest Non-decreasing Subarray From Two Arrays](https://leetcode.com/problems/longest-non-decreasing-subarray-from-two-arrays/)                                                         | [Python](./Python/2771-longest-non-decreasing-subarray-from-two-arrays.py)                             | [Medium](./Readme/2771-longest-non-decreasing-subarray-from-two-arrays.md)                             |
| 2778 | [Sum of Squares of Special Elements](https://leetcode.com/problems/sum-of-squares-of-special-elements/)                                                                                   | [Python](./Python/2778-sum-of-squares-of-special-elements.py)                                          | [Easy](./Readme/2778-sum-of-squares-of-special-elements.md)                                            |
| 2779 | [Maximum Beauty of an Array After Applying Operation](https://leetcode.com/problems/maximum-beauty-of-an-array-after-applying-operation)                                                  | [Python](./Python/2779-maximum-beauty-of-an-array-after-applying-operation.py)                         | [Medium](./Readme/2779-maximum-beauty-of-an-array-after-applying-operation.md)                         |
| 2784 | [Check if Array is Good](https://leetcode.com/problems/check-if-array-is-good/)                                                                                                           | [Python](./Python/2784-check-if-array-is-good.py)                                                      | [Easy](./Readme/2784-check-if-array-is-good.md)                                                        |
| 2785 | [Sort Vowels in a String](https://leetcode.com/problems/sort-vowels-in-a-string/)                                                                                                         | [Python](./Python/2785-sort-vowels-in-a-string.py)                                                     | [Medium](./Readme/2785-sort-vowels-in-a-string.md)                                                     |
| 2788 | [Split Strings by Separator](https://leetcode.com/problems/split-strings-by-separator/)                                                                                                   | [Python](./Python/2788-split-strings-by-separator.py)                                                  | [Easy](./Readme/2788-split-strings-by-separator.md)                                                    |
| 2789 | [Largest Element in an Array after Merge Operations](https://leetcode.com/problems/largest-element-in-an-array-after-merge-operations/)                                                   | [Python](./Python/2789-largest-element-in-an-array-after-merge-operations.py)                          | [Medium](./Readme/2789-largest-element-in-an-array-after-merge-operations.md)                          |
| 2798 | [Number of Employees Who Met the Target](https://leetcode.com/problems/number-of-employees-who-met-the-target/)                                                                           | [Python](./Python/2798-number-of-employees-who-met-the-target.py)                                      | [Easy](./Readme/2798-number-of-employees-who-met-the-target.md)                                        |
| 2802 | [Find the K-th Lucky Number](https://leetcode.com/problems/find-the-k-th-lucky-number/)                                                                                                   | [Python](./Python/2802-find-the-k-th-lucky-number.py)                                                  | [Medium](./Readme/2802-find-the-k-th-lucky-number.md)                                                  |
| 2806 | [Account Balance after Rounded Purchase](https://leetcode.com/problems/account-balance-after-rounded-purchase/)                                                                           | [Python](./Python/2806-account-balance-after-rounded-purchase.py)                                      | [Easy](./Readme/2806-account-balance-after-rounded-purchase.md)                                        |
| 2807 | [Insert Greatest Common Divisors in Linked List](https://leetcode.com/problems/insert-greatest-common-divisors-in-linked-list/)                                                           | [Python](./Python/2807-insert-greatest-common-divisors-in-linked-list.py)                              | [Medium](./Readme/2807-insert-greatest-common-divisors-in-linked-list.md)                              |
| 2810 | [Faulty Keyboard](https://leetcode.com/problems/faulty-keyboard/)                                                                                                                         | [Python](./Python/2810-faulty-keyboard.py)                                                             | [Easy](./Readme/2810-faulty-keyboard.md)                                                               |
| 2811 | [Check If It Is Possible to Split Array](https://leetcode.com/problems/check-if-it-is-possible-to-split-array/)                                                                           | [Python](./Python/2811-check-if-it-is-possible-to-split-array.py)                                      | [Medium](./Readme/2811-check-if-it-is-possible-to-split-array.md)                                      |
| 2812 | [Find the Safest Path in a Grid](https://leetcode.com/problems/find-the-safest-path-in-a-grid/)                                                                                           | [Python](./Python/2812-find-the-safest-path-in-a-grid.py)                                              | [Medium](./Readme/2812-find-the-safest-path-in-a-grid.md)                                              |
| 2816 | [Double a Number Represented as a Linked List](https://leetcode.com/problems/double-a-number-represented-as-a-linked-list/)                                                               | [Python](./Python/2816-double-a-number-represented-as-a-linked-list.py)                                | [Medium](./Readme/2816-double-a-number-represented-as-a-linked-list.md)                                |
| 2824 | [Count Pairs Whose Sum Is Less Than Target](https://leetcode.com/problems/count-pairs-whose-sum-is-less-than-target/)                                                                     | [Python](./Python/2824-count-pairs-whose-sum-is-less-than-target.py)                                   | [Easy](./Readme/2824-count-pairs-whose-sum-is-less-than-target.md)                                     |
| 2825 | [Make String A Subsequence Using Cyclic Increments](https://leetcode.com/problems/make-string-a-subsequence-using-cyclic-increments/)                                                     | [Python](./Python/2825-make-string-a-subsequence-using-cyclic-increments.py)                           | [Medium](./Readme/2825-make-string-a-subsequence-using-cyclic-increments.md)                           |
| 2833 | [Furthest Point from Origin](https://leetcode.com/problems/furthest-point-from-origin/)                                                                                                   | [Python](./Python/2833-furthest-point-from-origin.py)                                                  | [Easy](./Readme/2833-furthest-point-from-origin.md)                                                    |
| 2834 | [Find the Minimum Possible Sum of a Beautiful Array](https://leetcode.com/problems/find-the-minimum-possible-sum-of-a-beautiful-array/)                                                   | [Python](./Python/2834-find-the-minimum-possible-sum-of-a-beautiful-array.py)                          | [Medium](./Readme/2834-find-the-minimum-possible-sum-of-a-beautiful-array.md)                          |
| 2838 | [Maximum Coins Heroes Can Collect](https://leetcode.com/problems/maximum-coins-heroes-can-collect/)                                                                                       | [Python](./Python/2838-maximum-coins-heroes-can-collect.py)                                            | [Medium](./Readme/2838-maximum-coins-heroes-can-collect.md)                                            |
| 2849 | [Determine if a Cell is Reachable at a Given Time](https://leetcode.com/problems/determine-if-a-cell-is-reachable-at-a-given-time/)                                                       | [Python](./Python/2849-determine-if-a-cell-is-reachable-at-a-given-time.py)                            | [Medium](./Readme/2849-determine-if-a-cell-is-reachable-at-a-given-time.md)                            |
| 2856 | [Minimum Array Length After Pair Removals](https://leetcode.com/problems/minimum-array-length-after-pair-removals/)                                                                       | [Python](./Python/2856-minimum-array-length-after-pair-removals.py)                                    | [Medium](./Readme/2856-minimum-array-length-after-pair-removals.md)                                    |
| 2864 | [Maximum Odd Binary Number](https://leetcode.com/problems/maximum-odd-binary-number/)                                                                                                     | [Python](./Python/2864-maximum-odd-binary-number.py)                                                   | [Easy](./Readme/2864-maximum-odd-binary-number.md)                                                     |
| 2870 | [Minimum Number of Operations to Make Array Empty](https://leetcode.com/problems/minimum-number-of-operations-to-make-array-empty/)                                                       | [Python](./Python/2870-minimum-number-of-operations-to-make-array-empty.py)                            | [Medium](./Readme/2870-minimum-number-of-operations-to-make-array-empty.md)                            |
| 2877 | [Create a DataFrame From List](https://leetcode.com/problems/create-a-dataframe-from-list)                                                                                                | [Python](./Python/2877-create-a-dataframe-from-list.py)                                                | [Easy](./Readme/2877-create-a-dataframe-from-list.md)                                                  |
| 2878 | [Get the Size of a DataFrame](https://leetcode.com/problems/get-the-size-of-a-dataframe)                                                                                                  | [Python](./Python/2878-get-the-size-of-a-dataframe.py)                                                 | [Easy](./Readme/2878-get-the-size-of-a-dataframe.md)                                                   |
| 2879 | [Display the First Three Rows](https://leetcode.com/problems/display-the-first-three-rows)                                                                                                | [Python](./Python/2879-display-the-first-three-rows.py)                                                | [Easy](./Readme/2879-display-the-first-three-rows.md)                                                  |
| 2880 | [Select Data](https://leetcode.com/problems/select-data)                                                                                                                                  | [Python](./Python/2880-select-data.py)                                                                 | [Easy](./Readme/2880-select-data.md)                                                                   |
| 2881 | [Create a New Column](https://leetcode.com/problems/create-a-new-column)                                                                                                                  | [Python](./Python/2881-create-a-new-column.py)                                                         | [Easy](./Readme/2881-create-a-new-column.md)                                                           |
| 2882 | [Drop Duplicate Rows](https://leetcode.com/problems/drop-duplicate-rows)                                                                                                                  | [Python](./Python/2882-drop-duplicate-rows.py)                                                         | [Easy](./Readme/2882-drop-duplicate-rows.md)                                                           |
| 2883 | [Drop Missing Data](https://leetcode.com/problems/drop-missing-data)                                                                                                                      | [Python](./Python/2883-drop-missing-data.py)                                                           | [Easy](./Readme/2883-drop-missing-data.md)                                                             |
| 2884 | [Modify Columns](https://leetcode.com/problems/modify-columns)                                                                                                                            | [Python](./Python/2884-modify-columns.py)                                                              | [Easy](./Readme/2884-modify-columns.md)                                                                |
| 2885 | [Rename Columns](https://leetcode.com/problems/rename-columns)                                                                                                                            | [Python](./Python/2885-rename-columns.py)                                                              | [Easy](./Readme/2885-rename-columns.md)                                                                |
| 2886 | [Change Data Type](https://leetcode.com/problems/change-data-type)                                                                                                                        | [Python](./Python/2886-change-data-type.py)                                                            | [Easy](./Readme/2886-change-data-type.md)                                                              |
| 2887 | [Fill Missing Data](https://leetcode.com/problems/fill-missing-data)                                                                                                                      | [Python](./Python/2887-fill-missing-data.py)                                                           | [Easy](./Readme/2887-fill-missing-data.md)                                                             |
| 2888 | [Reshape Data: Concatenate](https://leetcode.com/problems/reshape-data-concatenate)                                                                                                       | [Python](./Python/2888-reshape-data-concatenate.py)                                                    | [Easy](./Readme/2888-reshape-data-concatenate.md)                                                      |
| 2889 | [Reshape Data: Pivot](https://leetcode.com/problems/reshape-data-pivot)                                                                                                                   | [Python](./Python/2889-reshape-data-pivot.py)                                                          | [Easy](./Readme/2889-reshape-data-pivot.md)                                                            |
| 2890 | [Reshape Data: Melt](https://leetcode.com/problems/reshape-data-melt)                                                                                                                     | [Python](./Python/2890-reshape-data-melt.py)                                                           | [Easy](./Readme/2890-reshape-data-melt.md)                                                             |
| 2891 | [Method Chaining](https://leetcode.com/problems/method-chaining)                                                                                                                          | [Python](./Python/2881-method-chaining.py)                                                             | [Easy](./Readme/2881-method-chaining.md)                                                               |
| 2914 | [Minimum Number of Changes to Make Binary String Beautiful](https://leetcode.com/problems/minimum-number-of-changes-to-make-binary-string-beautiful)                                      | [Python](./Python/2914-minimum-number-of-changes-to-make-binary-string-beautiful.py)                   | [Medium](./Readme/2914-minimum-number-of-changes-to-make-binary-string-beautiful.md)                   |
| 2923 | [Find Champion I](https://leetcode.com/problems/find-champion-i)                                                                                                                          | [Python](./Python/2923-find-champion-i.py)                                                             | [Easy](./Readme/2923-find-champion-i.md)                                                               |
| 2924 | [Find Champion II](https://leetcode.com/problems/find-champion-ii)                                                                                                                        | [Python](./Python/2924-find-champion-ii.py)                                                            | [Medium](./Readme/2924-find-champion-ii.md)                                                            |
| 2938 | [Separate Black and White Balls](https://leetcode.com/problems/separate-black-and-white-balls)                                                                                            | [Python](./Python/2938-separate-black-and-white-balls.py)                                              | [Medium](./Readme/2938-separate-black-and-white-balls.md)                                              |
| 2955 | [Number of Same-End Substrings](https://leetcode.com/problems/number-of-same-end-substrings)                                                                                              | [Python](./Python/2955-number-of-same-end-substrings.py)                                               | [Medium](./Readme/2955-number-of-same-end-substrings.md)                                               |
| 2958 | [Length of Longest Subarray with at Most K Frequency](https://leetcode.com/problems/length-of-longest-subarray-with-at-most-k-frequencies/)                                               | [Python](./Python/2958-length-of-longest-subarray-with-at-most-k-frequency.py)                         | [Medium](./Readme/2958-length-of-longest-subarray-with-at-most-k-frequency.md)                         |
| 2962 | [Count Subarrays Where Max Element Appears at Least K Times](https://leetcode.com/problems/count-subarrays-where-maximum-element-appears-at-least-k-times/)                               | [Python](./Python/2962-count-subarrays-where-max-element-appears-at-least-k-times.py)                  | [Medium](./Readme/2962-count-subarrays-where-max-element-appears-at-least-k-times.md)                  |
| 2966 | [Divide Array into Arrays with Max Difference](https://leetcode.com/problems/divide-array-into-arrays-with-max-difference/)                                                               | [Python](./Python/2966-divide-array-into-arrays-with-max-difference.py)                                | [Medium](./Readme/2966-divide-array-into-arrays-with-max-difference.md)                                |
| 2971 | [Find Polygon with the Largest Perimeter](https://leetcode.com/problems/find-polygon-with-the-largest-perimeter/)                                                                         | [Python](./Python/2971-find-polygon-with-the-largest-perimeter.py)                                     | [Medium](./Readme/2971-find-polygon-with-the-largest-perimeter.md)                                     |
| 2976 | [Minimum Cost to Convert String I](https://leetcode.com/problems/minimum-cost-to-convert-string-i/)                                                                                       | [Python](./Python/2976-minimum-cost-to-convert-string-i.py)                                            | [Medium](./Readme/2976-minimum-cost-to-convert-string-i.md)                                            |
| 2981 | [Find Longest Special Substring That Occurs Thrice I](https://leetcode.com/problems/find-longest-special-substring-that-occurs-thrice-i)                                                  | [Python](./Python/2981-find-longest-special-substring-that-occurs-thrice-i.py)                         | [Medium](./Readme/2981-find-longest-special-substring-that-occurs-thrice-i.md)                         |
| 2985 | [Calculate Compressed Mean](https://leetcode.com/problems/calculate-compressed-mean/)                                                                                                     | [SQL](./SQL/2985-calculate-compressed-mean.sql)                                                        | [Easy](./Readme/2985-calculate-compressed-mean.md)                                                     |
| 2997 | [Minimum Number of Operations to Make Array XOR Equal to Zero](https://leetcode.com/problems/minimum-number-of-operations-to-make-array-xor-equal-to-k/)                                  | [Python](./Python/2997-minimum-number-of-operations-to-make-array-xor-equal-to-k.py)                   | [Medium](./Readme/2997-minimum-number-of-operations-to-make-array-xor-equal-to-k.md)                   |
| 3005 | [Count Elements with Maximum Frequency](https://leetcode.com/problems/count-elements-with-maximum-frequency/)                                                                             | [Python](./Python/3005-count-elements-with-maximum-frequency.py)                                       | [Easy](./Readme/3005-count-elements-with-maximum-frequency.md)                                         |
| 3011 | [Find if Array Can Be Sorted](https://leetcode.com/problems/find-if-array-can-be-sorted)                                                                                                  | [Python](./Python/3011-find-if-array-can-be-sorted.py)                                                 | [Medium](./Readme/3011-find-if-array-can-be-sorted.md)                                                 |
| 3016 | [Minimum Number of Pushes to Type Word II](https://leetcode.com/problems/minimum-number-of-pushes-to-type-word-ii/)                                                                       | [Python](./Python/3016-minimum-number-of-pushes-to-type-word-ii.py)                                    | [Medium](./Readme/3016-minimum-number-of-pushes-to-type-word-ii.md)                                    |
| 3020 | [Find the Maximum Number of Elements in Subset](https://leetcode.com/problems/find-the-maximum-number-of-elements-in-subset)                                                              | [Python](./Python/3020-find-the-maximum-number-of-elements-in-subset.py)                               | [Medium](./Readme/3020-find-the-maximum-number-of-elements-in-subset.md)                               |
| 3043 | [Find the Length of the Longest Common Prefix](https://leetcode.com/problems/find-the-length-of-the-longest-common-prefix/)                                                               | [Python](./Python/3043-find-the-length-of-the-longest-common-prefix.py)                                | [Medium](./Readme/3043-find-the-length-of-the-longest-common-prefix.md)                                |
| 3062 | [Winner of the Linked List Game](https://leetcode.com/problems/winner-of-the-linked-list-game/)                                                                                           | [Python](./Python/3062-winner-of-the-linked-list-game.py)                                              | [Easy](./Readme/3062-winner-of-the-linked-list-game.md)                                                |
| 3063 | [Linked List Frequency](https://leetcode.com/problems/linked-list-frequency/)                                                                                                             | [Python](./Python/3063-linked-list-frequency.py)                                                       | [Medium](./Readme/3063-linked-list-frequency.md)                                                       |
| 3068 | [Find the Maximum Sum of Node Values](https://leetcode.com/problems/find-the-maximum-sum-of-node-values/)                                                                                 | [Python](./Python/3068-find-the-maximum-sum-of-node-values.py)                                         | [Hard](./Readme/3068-find-the-maximum-sum-of-node-values.md)                                           |
| 3075 | [Maximize Happiness of Selected Children](https://leetcode.com/problems/maximize-happiness-of-selected-children/)                                                                         | [Python](./Python/3075-maximize-happiness-of-selected-children.py)                                     | [Medium](./Readme/3075-maximize-happiness-of-selected-children.md)                                     |
| 3095 | [Shortest Subarray with OR at Least K I](https://leetcode.com/problems/shortest-subarray-with-or-at-least-k-i)                                                                            | [Python](./Python/3095-shortest-subarray-with-or-at-least-k-i.py)                                      | [Easy](./Readme/3095-shortest-subarray-with-or-at-least-k-i.md)                                        |
| 3097 | [Shortest Subarray with OR at Least K II](https://leetcode.com/problems/shortest-subarray-with-or-at-least-k-ii)                                                                          | [Python](./Python/3097-shortest-subarray-with-or-at-least-k-ii.py)                                     | [Medium](./Readme/3097-shortest-subarray-with-or-at-least-k-ii.md)                                     |
| 3110 | [Score of a String](https://leetcode.com/problems/score-of-a-string/)                                                                                                                     | [Python](./Python/3110-score-of-a-string.py)                                                           | [Easy](./Readme/3110-score-of-a-string.md)                                                             |
| 3133 | [Minimum Array End](https://leetcode.com/problems/minimum-array-end)                                                                                                                      | [Python](./Python/3133-minimum-array-end.py)                                                           | [Medium](./Readme/3133-minimum-array-end.md)                                                           |
| 3152 | [Special Array II](https://leetcode.com/problems/special-array-ii)                                                                                                                        | [Python](./Python/3152-special-array-ii.py)                                                            | [Medium](./Readme/3152-special-array-ii.md)                                                            |
| 3155 | [Maximum Number of Upgradable Servers](https://leetcode.com/problems/maximum-number-of-upgradable-servers/)                                                                               | [Python](./Python/3155-maximum-number-of-upgradable-servers.py)                                        | [Medium](./Readme/3155-maximum-number-of-upgradable-servers.md)                                        |
| 3163 | [String Compression III](https://leetcode.com/problems/string-compression-iii)                                                                                                            | [Python](./Python/3163-string-compression-iii.py)                                                      | [Medium](./Readme/3163-string-compression-iii.md)                                                      |
| 3176 | [Find the Maximum Length of a Good Subsequence I](https://leetcode.com/problems/find-the-maximum-length-of-a-good-subsequence-i/)                                                         | [Python](./Python/3176-find-the-maximum-length-of-a-good-subsequence-i.py)                             | [Medium](./Readme/3176-find-the-maximum-length-of-a-good-subsequence-i.md)                             |
| 3177 | [Find the Maximum Length of a Good Subsequence II](https://leetcode.com/problems/find-the-maximum-length-of-a-good-subsequence-ii)                                                        | [Python](./Python/3177-find-the-maximum-length-of-a-good-subsequence-ii.py)                            | [Medium](./Readme/3177-find-the-maximum-length-of-a-good-subsequence-ii.md)                            |
| 3189 | [Minimum Moves to Get a Peaceful Board](https://leetcode.com/problems/minimum-moves-to-get-a-peaceful-board/)                                                                             | [Python](./Python/3189-minimum-moves-to-get-a-peaceful-board.py)                                       | [Medium](./Readme/3189-minimum-moves-to-get-a-peaceful-board.md)                                       |
| 3217 | [Delete Nodes From Linked List Present In Array](https://leetcode.com/problems/delete-nodes-from-linked-list-present-in-array/)                                                           | [Python](./Python/3217-delete-nodes-from-linked-list-present-in-array.py)                              | [Medium](./Readme/3217-delete-nodes-from-linked-list-present-in-array.md)                              |
| 3243 | [Shortest Distance After Road Addition Queries I](https://leetcode.com/problems/shortest-distance-after-road-addition-queries-i)                                                          | [Python](./Python/3243-shortest-distance-after-road-addition-queries-i.py)                             | [Medium](./Readme/3243-shortest-distance-after-road-addition-queries-i.md)                             |
| 3280 | [Convert Date to Binary](https://leetcode.com/problems/convert-date-to-binary/)                                                                                                           | [Python](./Python/3280-convert-date-to-binary.py)                                                      | [Easy](./Readme/3280-convert-date-to-binary.md)                                                        |
| 3281 | [Maximize Score of Numbers in Ranges](https://leetcode.com/problems/maximize-score-of-numbers-in-ranges/)                                                                                 | [Python](./Python/3281-maximize-score-of-numbers-in-ranges.py)                                         | [Medium](./Readme/3281-maximize-score-of-numbers-in-ranges.md)                                         |
| 3282 | [Reach End of Array with Max Score](https://leetcode.com/problems/reach-end-of-array-with-max-score/)                                                                                     | [Python](./Python/3282-reach-end-of-array-with-max-score.py)                                           | [Medium](./Readme/3282-reach-end-of-array-with-max-score.md)                                           |
| 3285 | [Find Indices of Stable Mountains](https://leetcode.com/problems/find-indices-of-stable-mountains/)                                                                                       | [Python](./Python/3285-find-indices-of-stable-mountains.py)                                            | [Easy](./Readme/3285-find-indices-of-stable-mountains.md)                                              |
| 3286 | [Find a Safe Walk Through a Grid](https://leetcode.com/problems/find-a-safe-walk-through-a-grid/)                                                                                         | [Python](./Python/3286-find-a-safe-walk-through-a-grid.py)                                             | [Medium](./Readme/3286-find-a-safe-walk-through-a-grid.md)                                             |
| 3289 | [The Two Sneaky Numbers of Digitville](https://leetcode.com/problems/the-two-sneaky-numbers-of-digitville/)                                                                               | [Python](./Python/3289-the-two-sneaky-numbers-of-digitville.py)                                        | [Easy](./Readme/3289-the-two-sneaky-numbers-of-digitville.md)                                          |
| 3290 | [Maximum Multiplication Score](https://leetcode.com/problems/maximum-multiplication-score/)                                                                                               | [Python](./Python/3290-maximum-multiplication-score.py)                                                | [Medium](./Readme/3290-maximum-multiplication-score.md)                                                |
| 3295 | [Report Spam Message](https://leetcode.com/problems/report-spam-message/)                                                                                                                 | [Python](./Python/3295-report-spam-message.py)                                                         | [Medium](./Readme/3295-report-spam-message.md)                                                         |
| 3296 | [Minimum Number of Seconds to Make Mountain Height Zero](https://leetcode.com/problems/minimum-number-of-seconds-to-make-mountain-height-zero/)                                           | [Python](./Python/3296-minimum-number-of-seconds-to-make-mountain-height-zero.py)                      | [Medium](./Readme/3296-minimum-number-of-seconds-to-make-mountain-height-zero.md)                      |
| 3300 | [Minimum Element After Replacement With Digit Sum](https://leetcode.com/problems/minimum-element-after-replacement-with-digit-sum/)                                                       | [Python](./Python/3300-minimum-element-after-replacement-with-digit-sum.py)                            | [Easy](./Readme/3300-minimum-element-after-replacement-with-digit-sum.md)                              |
| 3301 | [Maximize the Total Height of Unique Towers](https://leetcode.com/problems/maximize-the-total-height-of-unique-towers/)                                                                   | [Python](./Python/3301-maximize-the-total-height-of-unique-towers.py)                                  | [Medium](./Readme/3301-maximize-the-total-height-of-unique-towers.md)                                  |
| 3304 | [Find the K-th Character in String Game I](https://leetcode.com/problems/find-the-k-th-character-in-string-game-i/)                                                                       | [Python](./Python/3304-find-the-k-th-character-in-string-game-i.py)                                    | [Easy](./Readme/3304-find-the-k-th-character-in-string-game-i.md)                                      |
| 3305 | [Count of Substrings Containing Every Vowel and K Consonants I](https://leetcode.com/problems/count-of-substrings-containing-every-vowel-and-k-consonants-i/)                             | [Python](./Python/3305-count-of-substrings-containing-every-vowel-and-k-consonants-i.py)               | [Medium](./Readme/3305-count-of-substrings-containing-every-vowel-and-k-consonants-i.md)               |
| 3309 | [Maximum Possible Number by Binary Concatenation](https://leetcode.com/problems/maximum-possible-number-by-binary-concatenation/)                                                         | [Python](./Python/3309-maximum-possible-number-by-binary-concatenation.py)                             | [Medium](./Readme/3309-maximum-possible-number-by-binary-concatenation.md)                             |
| 3310 | [Remove Methods from Project](https://leetcode.com/problems/remove-methods-from-project/)                                                                                                 | [Python](./Python/3310-remove-methods-from-project.py)                                                 | [Medium](./Readme/3310-remove-methods-from-project.md)                                                 |
| 3314 | [Construct the Minimum Bitwise Array I](https://leetcode.com/problems/construct-the-minimum-bitwise-array-i/)                                                                             | [Python](./Python/3314-construct-the-minimum-bitwise-array-i.py)                                       | [Easy](./Readme/3314-construct-the-minimum-bitwise-array-i.md)                                         |
| 3315 | [Construct the Minimum Bitwise Array II](https://leetcode.com/problems/construct-the-minimum-bitwise-array-ii/)                                                                           | [Python](./Python/3315-construct-the-minimum-bitwise-array-ii.py)                                      | [Medium](./Readme/3315-construct-the-minimum-bitwise-array-ii.md)                                      |
| 3318 | [Find X Sum of All K Long Subarrays I](https://leetcode.com/problems/find-x-sum-of-all-k-long-subarrays-i/)                                                                               | [Python](./Python/3318-find-x-sum-of-all-k-long-subarrays-i.py)                                        | [Easy](./Readme/3318-find-x-sum-of-all-k-long-subarrays-i.md)                                          |
| 3319 | [K-th Largest Perfect Subtree Size in Binary Tree](https://leetcode.com/problems/k-th-largest-perfect-subtree-size-in-binary-tree/)                                                       | [Python](./Python/3319-k-th-largest-perfect-subtree-size-in-binary-tree.py)                            | [Medium](./Readme/3319-k-th-largest-perfect-subtree-size-in-binary-tree.md)                            |
| 3324 | [Find the Sequence of Strings Appeared on the Screen](https://leetcode.com/problems/find-the-sequence-of-strings-appeared-on-the-screen)                                                  | [Python](./Python/3324-find-the-sequence-of-strings-appeared-on-the-screen.py)                         | [Medium](./Readme/3324-find-the-sequence-of-strings-appeared-on-the-screen.md)                         |
| 3325 | [Count Substrings with K Frequency Characters I](https://leetcode.com/problems/count-substrings-with-k-frequency-characters-i)                                                            | [Python](./Python/3325-count-substrings-with-k-frequency-characters-i.py)                              | [Medium](./Readme/3325-count-substrings-with-k-frequency-characters-i.md)                              |
| 3330 | [Find the Original Typed String I](https://leetcode.com/problems/find-the-original-typed-string-i)                                                                                        | [Python](./Python/3330-find-the-original-typed-string-i.py)                                            | [Easy](./Readme/3330-find-the-original-typed-string-i.md)                                              |
| 3331 | [Find Subtree Sizes After Changes](https://leetcode.com/problems/find-subtree-sizes-after-changes)                                                                                        | [Python](./Python/3331-find-subtree-sizes-after-changes.py)                                            | [Medium](./Readme/3331-find-subtree-sizes-after-changes.md)                                            |
| 3334 | [Find the Maximum Factor Score of Array](https://leetcode.com/problems/find-the-maximum-factor-score-of-array)                                                                            | [Python](./Python/3334-find-the-maximum-factor-score-of-array.py)                                      | [Medium](./Readme/3334-find-the-maximum-factor-score-of-array.md)                                      |
| 3335 | [Total Characters in String After Transformations I](https://leetcode.com/problems/total-characters-in-string-after-transformations-i)                                                    | [Python](./Python/3335-total-characters-in-string-after-transformations-i.py)                          | [Medium](./Readme/3335-total-characters-in-string-after-transformations-i.md)                          |
| 3340 | [Check Balanced String](https://leetcode.com/problems/check-balanced-string)                                                                                                              | [Python](./Python/3340-check-balanced-string.py)                                                       | [Easy](./Readme/3340-check-balanced-string.md)                                                         |
| 3341 | [Find Minimum Time to Reach Last Room I](https://leetcode.com/problems/find-minimum-time-to-reach-last-room-i)                                                                            | [Python](./Python/3341-find-minimum-time-to-reach-last-room-i.py)                                      | [Medium](./Readme/3341-find-minimum-time-to-reach-last-room-i.md)                                      |
| 3342 | [Find Minimum Time to Reach Last Room II](https://leetcode.com/problems/find-minimum-time-to-reach-last-room-ii)                                                                          | [Python](./Python/3342-find-minimum-time-to-reach-last-room-ii.py)                                     | [Medium](./Readme/3342-find-minimum-time-to-reach-last-room-ii.md)                                     |
| 3345 | [Smallest Divisible Digit Product I](https://leetcode.com/problems/smallest-divisible-digit-product-i)                                                                                    | [Python](./Python/3345-smallest-divisible-digit-product-i.py)                                          | [Easy](./Readme/3345-smallest-divisible-digit-product-i.md)                                            |
| 3349 | [Adjacent Increasing Subarrays Detection I](https://leetcode.com/problems/adjacent-increasing-subarrays-detection-i)                                                                      | [Python](./Python/3349-adjacent-increasing-subarrays-detection-i.py)                                   | [Easy](./Readme/3349-adjacent-increasing-subarrays-detection-i.md)                                     |
| 3350 | [Adjacent Increasing Subarrays Detection II](https://leetcode.com/problems/adjacent-increasing-subarrays-detection-ii)                                                                    | [Python](./Python/3350-adjacent-increasing-subarrays-detection-ii.py)                                  | [Medium](./Readme/3350-adjacent-increasing-subarrays-detection-ii.md)                                  |
| 3354 | [Make Array Elements Equal to Zero](https://leetcode.com/problems/make-array-elements-equal-to-zero)                                                                                      | [Python](./Python/3354-make-array-elements-equal-to-zero.py)                                           | [Easy](./Readme/3354-make-array-elements-equal-to-zero.md)                                             |
| 3355 | [Zero Array Transformation I](https://leetcode.com/problems/zero-array-transformation-i)                                                                                                  | [Python](./Python/3355-zero-array-transformation-i.py)                                                 | [Medium](./Readme/3355-zero-array-transformation-i.md)                                                 |
| 3360 | [Stone Removal Game](https://leetcode.com/problems/stone-removal-game)                                                                                                                    | [Python](./Python/3360-stone-removal-game.py)                                                          | [Easy](./Readme/3360-stone-removal-game.md)                                                            |
| 3361 | [Shift Distance Between Two Strings](https://leetcode.com/problems/shift-distance-between-two-strings)                                                                                    | [Python](./Python/3361-shift-distance-between-two-strings.py)                                          | [Medium](./Readme/3361-shift-distance-between-two-strings.md)                                          |
| 3364 | [Minimum Positive Sum Subarray](https://leetcode.com/problems/minimum-positive-sum-subarray)                                                                                              | [Python](./Python/3364-minimum-positive-sum-subarray.py)                                               | [Easy](./Readme/3364-minimum-positive-sum-subarray.md)                                                 |
| 3365 | [Rearrange K Substrings to Form Target String](https://leetcode.com/problems/rearrange-k-substrings-to-form-target-string)                                                                | [Python](./Python/3365-rearrange-k-substrings-to-form-target-string.py)                                | [Medium](./Readme/3365-rearrange-k-substrings-to-form-target-string.md)                                |
| 3370 | [Smallest Number with All Set Bits](https://leetcode.com/problems/smallest-number-with-all-set-bits)                                                                                      | [Python](./Python/3370-smallest-number-with-all-set-bits.py)                                           | [Easy](./Readme/3370-smallest-number-with-all-set-bits.md)                                             |
| 3371 | [Identify the Largest Outlier in an Array](https://leetcode.com/problems/identify-the-largest-outlier-in-an-array)                                                                        | [Python](./Python/3371-identify-the-largest-outlier-in-an-array.py)                                    | [Medium](./Readme/3371-identify-the-largest-outlier-in-an-array.md)                                    |
| 3372 | [Maximize the Number of Target Nodes After Connecting Trees I](https://leetcode.com/problems/maximize-the-number-of-target-nodes-after-connecting-trees-i)                                | [Python](./Python/3372-maximize-the-number-of-target-nodes-after-connecting-trees-i.py)                | [Medium](./Readme/3372-maximize-the-number-of-target-nodes-after-connecting-trees-i.md)                |
| 3379 | [Transformed Array](https://leetcode.com/problems/transformed-array)                                                                                                                      | [Python](./Python/3379-transformed-array.py)                                                           | [Easy](./Readme/3379-transformed-array.md)                                                             |
| 3380 | [Maximum Area Rectangle With Point Constraints I](https://leetcode.com/problems/maximum-area-rectangle-with-point-constraints-i)                                                          | [Python](./Python/3380-maximum-area-rectangle-with-point-constraints-i.py)                             | [Medium](./Readme/3380-maximum-area-rectangle-with-point-constraints-i.md)                             |

## How to Use

1. Clone the repository:

```bash
git clone https://github.com/hogan.tech/leetcode-solutions.git
```

2. Choose a Problem:

Browse the folders to find the LeetCode problem you want to solve.

3. Select a Language:

Inside each problem folder, you'll find solutions in various programming languages. Choose the language you prefer.

4. Read the ReadMe:

Each problem folder contains a README file with a problem description, approach, and code explanation. Read this to understand the solution.

5. Explore the Code:

Open the code file to view the implementation. Study the code and adapt it as needed for your use case.

6. Run the Code:

You can run the code on your local machine to test and modify it as needed.

7. Contribute:

If you have a better solution or want to contribute in any way, feel free to submit a pull request.

8. Share Your Feedback:

Welcome feedback and suggestions. If you have any ideas to improve the solutions or find any errors, please let me know.

Happy coding! 🚀

By following these steps, users can easily navigate and utilize your LeetCode solutions repository for their coding needs.
