# A first glance at back-end with Django

I'm currently learning the fundamentals of Web Development and most of what I'm doing recently is
related to Front-End development (HTML & CSS). As my goal is to become a full-stack web developer,
it's obvious I'll also learn about the back-end.

When I was learning Python, there was a section about back-end and I was introduced to the [Flask
framework](https://flask.palletsprojects.com/), and briefly touched upon back-end development.

However, it seems like Django is used more prominently than Flask which is why I wanted to know more
about it.  So I installed Django and started the tutorial. To this day, I managed to finish step 4
out of 7.

## My second time with Django

Truth be told, this is probably the third time I'm trying to learn how to use Django to develop web
applications. In the past, I've been unsuccessful in learning Django, certainly because what I was
learning was unrelated to web development.

Now that I'm fully invested in web development, I feel ready to tackle this new challenge. But at
the moment, it's not a priority, I'm mostly doing it on my free time.

I still have a little bit of trouble understanding the hierarchy between project and apps, and its
related folder structure. Though it should become easier the more I use it. 

So far I can sum up the 4 steps this way:

1. Project creation and file management
2. Database creation and management
3. Front-end development via the back-end (HTML only)
4. Adding more functionality to the application

In this tutorial application, we're only dealing with one database so it's rather simple, but larger
apps certainly use various databases. That makes me think of social media apps, where there's a
database for each user and/or page. And they look different because of the needs.

What fascinated me is that, through Django, we can interact with the database using Python instead
of SQL. There are bindings to be known still, but with Python only we can completely manage
databases. Fascinating.

When I moved to step 3, I was not using a front-end framework (which is something I'll want to learn
in the future). I was generating _views_ through the Django framework that would be displayed to the
user. Templating is the way to programmatically generate web pages based on the database content.

But the content was only HTML, I wanted to integrate some CSS into it, but simply adding the CSS
file in the same folder didn't work. So I looked it up on StackOverflow, and successfully added CSS
to the poll app. But I believe that'd be done in the subsequent tutorial steps.

## What I'm doing so far

Although I haven't touched Django in almost two weeks, doing back-end development is still at the
back of my mind. However, my priority is on finishing the courses and reaching the goals I set for
myself, which is why I leave it to my free time.

Django seems quite hard at the beginning, so pacing yourself is essential instead of rushing through
the tutorial, unless you're already a seasoned back-end engineer. In my case, there are still many
things I do not understand well, but step-by-step, I'll be skilled in that aspect.

I'd like to do a different app to showcase my understanding and skills. The [course on
Upskill](https://upskillcourses.com/courses/essential-web-developer-course) teaches full-stack web
development as well, and building a full-fledged app too, just like Udemy's bootcamp.

None of them use Django however, so I feel like I'm taking advantage of that gap to build my future
tech stack.

To complete my learning and see how it's used for another type of application, I'm planning on
following [this video](https://www.youtube.com/watch?v=xSUm6iMtREA) from FreeCodeCamp. This way, I
believe I'll have a more complete understanding of Django.

<hr>

I'm ambitious, and I need to consider how long it'll take me to reach my goals. I'm looking forward
to get familiar with Django and the back-end in general. If my story has inspired you, let me know
in the comments below. See you in the next post.
