# Goals for February 2023 + Week 3 log

When I [wrote about learning Web Development again](https://hobyr.github.io/2023/02/13/restarting_web_dev.html), I described my strategy to ideally become a Full-Stack Web Developer by August 2023. Nonetheless, getting a chance to work as a Front-End or Back-End engineer at first is something I'd be happy with, as a stepping stone.

I managed to complete all my goals for January 2023, and I'd like to share in this post more details
about my strategy for February.

## Monthly Goals

As a reminder, here are my goals for this month:

1. ☑️ **Finish CSS Foundations section on The Odin Project**: I'd be able to design pages and content,
   ideally make my resume look good online.
2. **Finish the Tribute Page project on FreeCodeCamp**: I'll have another project to show on my
    GitHub, with a larger tech stack hopefully.
3. **Complete the CSS sections on Colt Steele's Udemy bootcamp**: A second resource to cement my
    CSS knowledge, as well as learning about Flexbox and Bootstrap.

Monthly goals are great, but I believe weekly goals are better to make sure I stay on track and
regularly review my progress. I can then see if I'm behind or not.

## Weekly Goals

These are goals I write in my notebook, and I even have daily goals, or simply daily tasks. I put a
lot of emphasis on Colt Steele's course on my notebook. However, I'll add other resources here
because I have more space. Here they are for the February:

- **Week 2 (01.30 to 02.05)**: Finish sections 5 & 6 of Colt Steele's Udemy bootcamp.
- **Week 3 (02.06 to 02.12)**: Finish sections 7 & 8 of Colt Steele's Udemy bootcamp + finish Survey
    Form project from FreeCodeCamp.
- **Week 4 (02.13 to 02.19)**: Finish sections 9 & 10 of Colt Steele's Udemy bootcamp + get to
    Flexbox project from FreeCodeCamp.
- **Week 5 (02.20 to 02.26)**: Finish sections 11 & 12 of Colt Steele's Udemy bootcamp + start
    section 13.

Although in the previous post, I wrote about my weekly progress since I started, I want to make it a
regular occurence. I can reflect on what I did, as well as prove to myself I'm progressing.
Frequently, I may be so deep in my learning that I'd forget stepping back and get an overview of
what I accomplished until now.

Since I described the first two weeks of my learning before, and we're midway through the 3rd week
of February which is actually my fourth week of learning, I'll share what I did during week 3.

### Week 3 (02.06 to 02.12)

This week was a bit hectic as I spent a lot of time away from my computer doing more creative work.
I still managed to complete some sections as I planned.

I gave myself several days to complete the Survey Form project on FreeCodeCamp, but I surprised
myself by completing it in less than an hour. You can check [my project
here](https://www.github.com/hobyr/survey_form). It's not functional so submitting will result in a _405
error_. I need to make a page so it looks better. The goal was to use HTML and CSS to make an
elegant page. And I believe I managed quite well, I really copied FreeCodeCamp's aesthetics though.

And while I postponed many daily tasks, by catching up, I managed to complete section 7 on time, but
it took 2 more days to finish section 8. Again, not trying to overwhelm myself, I decided to not put
too much on my daily plate.

I haven't done much Django this week, but I'm getting close to more complex CSS topics on all three
resources so that's pretty good.

#### Finding Git a little easier

Most of the resources but TOP encourage the use of Git and GitHub for project management and version
control. That's one reason I really enjoy learning through TOP.

In the past, I tried using Git locally and GitHub. Reading about it makes me feel like knowing how
to use it is essential as a developer. So every "substantial" project I complete, on whichever
platform, I upload it to my GitHub through the terminal.

I'm getting the hang of it, but I know it's much more complex than what I'm currently doing. Since
I'm the sole developer right now, I'm not dealing with _pull requests_, _branch management_, etc. So
I'm still at the basics, but that seems like enough for now.

Right now, `git pull`, `git log`, `git diff`, `git status`, `git commit`, `git push`, `git add`,
`git restore` are commands I'm familiar with. Also, using `gh repo clone` or `gh repo create` is
something I'm slowly getting used to. When creating a remote repository, I still have to look at the
repository creation page on GitHub. **It's only a matter of time until it becomes second nature**.

#### HTML and CSS are quite fun but I want to get to JavaScript

I'm already familiar with HTML and CSS, so I do find some of the classes boring. In particular,
since I'm pacing myself, I do find my progress slow, but it's a marathon, not a sprint.

I'm eager to get to the JavaScript sections and doing more interactive stuff. This is one reason I
started looking at Django. Not only it's a widely used framework, there's some programming involved.
I can't wait until I get to Front-End frameworks like React or Vue, I've seen these names way too
often.

<hr>

I think I've made quite good progress this week despite postponing many of the tasks. I can keep
going. If my story has inspired you so far, please leave a comment below. See you in the next post.
