package control;

import dao.DAO;
import model.Category;
import model.Product;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(name = "SearchControl", urlPatterns = {"/search"})
public class SearchControl extends HttpServlet {

    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        DAO dao = new DAO();
        request.setCharacterEncoding("UTF8");
        String search = request.getParameter("txt");
        List<Category> listC = dao.getAllCategory();
        Product last = dao.getLastDog();
        List<Product> listSearch = dao.getProductBySearch(search);
        request.setAttribute("listP", listSearch);
        request.setAttribute("listCC", listC);
        request.setAttribute("p", last);
        request.setAttribute("tim", search);
        request.setAttribute("contextPath", request.getContextPath());
        request.getRequestDispatcher("Home.jsp").forward(request, response);
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        processRequest(request, response);
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        processRequest(request, response);
    }

    @Override
    public String getServletInfo() {
        return "Short description";
    }
}
