# 🎨 Flutter UI Designs

A comprehensive collection of beautifully crafted Flutter UI implementations supporting web, mobile, and desktop platforms. ✨

## ⭐ Features

- 🌐 Cross-platform support (Web, Android, iOS, Windows, macOS, Linux)
- 📱 Responsive layouts that adapt to different screen sizes
- 🎬 Complex animations and transitions
- 🌍 Internationalization (English, Chinese, Arabic)
- 🌓 Dark/Light theme support
- 🔥 Firebase integration for analytics and crash reporting
- 📦 State management with Provider pattern
- 🏗️ Clean and modular architecture

## 💫 UI Implementations

1. **Healthy Food Delivery** 🥗

   - Food listing with parallax effects
   - Detailed food item view
   - Nutritional information display
   - Rating system

2. **Hot Air Balloon** 🎈

   - Booking interface
   - Flight details and scheduling
   - Interactive balloon animations
   - Multi-step booking process

3. **Sky View** 🌌

   - Planet/Star viewing interface
   - Interactive space exploration
   - Celestial body details
   - Parallax star field effects

4. **Asics Shoes Concept** 👟

   - Product showcase
   - Color variants
   - Size selection
   - Product details presentation

5. **Egg Timer Concept** ⏲️

   - Circular timer interface
   - Gesture-based controls
   - Visual time tracking
   - Start/pause/reset functionality

6. **Chef Craft** 👨‍🍳
   - Recipe browsing
   - Cooking instructions
   - Ingredient lists
   - Chef profiles

## 🛠️ Setup

1. **Last Tested Version**

```bash
Flutter 3.24.4 • channel stable
Dart 3.5.4
DevTools 2.37.3
```

2. **Enable Platforms** 🖥️

```bash
flutter config --enable-web
flutter config --enable-macos-desktop
flutter config --enable-linux-desktop
flutter config --enable-windows-desktop
```

3. **Installation** 📥

```bash
# Clone repository
git clone https://github.com/hmziqrs/flutter-ui-designs.git

# Install dependencies
flutter pub get

# Run app
flutter run
```

## 📁 Project Structure

```
lib/
├── MiniApps/              # Individual UI implementations
├── configs/               # App-wide configuration
├── Providers/             # State management
├── screens/              # Main app screens
├── services/             # Firebase & platform services
├── statics/             # Static data & models
├── utils/               # Utility functions
└── widgets/             # Reusable widgets
```

## 🔑 Key Components

### Core Architecture 🏛️

- `Navigator.dart` - Custom navigation handling with transitions
- `AppDimensions.dart` - Responsive sizing system
- `AppTheme.dart` - Theme management
- `AppLocalizations.dart` - Internationalization support

### Widget System 🧩

- Screen - Base widget for all screens
- Custom animations
- Reusable UI components
- Platform-specific adaptations

### State Management 📊

- Provider pattern implementation
- Screen-level state isolation
- App-wide state management
- Animation state handling

## 🤝 Contributing

1. Fork repository
2. Create feature branch
3. Commit changes
4. Push to branch
5. Create pull request

## 📲 Download

<div id="downloads">
  <a href="https://play.google.com/store/apps/details?id=com.onemdev.flutter_ui_challenges">
    <img src="https://raw.githubusercontent.com/hmziqrs/flutter-ui-designs/master/.github/assets/google-play.png" alt="Play Store badge" width="200" />
  </a>
  <a href="https://github.com/hmziqrs/flutter-ui-designs/releases/latest/download/app-release.apk">
    <img src="https://raw.githubusercontent.com/hmziqrs/flutter-ui-designs/master/.github/assets/android.png" alt="Android badge" width="200" />
  </a>
  <a href="https://github.com/hmziqrs/flutter-ui-designs/releases/latest/download/windows-release.zip">
    <img src="https://raw.githubusercontent.com/hmziqrs/flutter-ui-designs/master/.github/assets/windows.png" alt="Windows badge" width="200" />
  </a>
  <a href="https://github.com/hmziqrs/flutter-ui-designs/releases/latest/download/macos-release.zip">
    <img src="https://raw.githubusercontent.com/hmziqrs/flutter-ui-designs/master/.github/assets/macos.png" alt="MacOS badge"  width="200" />
  </a>
  <a href="https://github.com/hmziqrs/flutter-ui-designs/releases/latest/download/linux-release.zip">
    <img src="https://raw.githubusercontent.com/hmziqrs/flutter-ui-designs/master/.github/assets/linux.png" alt="Linux badge"  width="200"/>
  </a>
</div>

## 📄 License

This project is licensed under the MIT License. See [LICENSE](LICENSE) for details.

## 🙏 Acknowledgments

- 🎨 UI designs are property of their respective designers
- 👥 Contributors and maintainers
- 💙 Flutter and Dart teams

## 🐛 Found a bug?

Please file an issue with a detailed description on the [GitHub repository](https://github.com/hmziqrs/flutter-ui-designs/issues).

## ⭐ Show Your Support

If you found this project helpful or learned something from it, consider:

- Starring the repository
- Sharing it with others
- Following the contributors

## 🌟 More Open Source Projects

- [Movie Concept App](https://github.com/hmziqrs/invmovieconcept1) - An innovative movie browsing experience built with Flutter
- [React Native Loop Game](https://github.com/hmziqrs/react-native-loop-game) - An engaging mobile game created with React Native
- [CV Template](https://github.com/hmziqrs/cv) - A modern, customizable CV/resume template

## 🔗 Connect With Me

### Social Links

- 𝕏 (Twitter): [@hmziqrs](https://x.com/hmziqrs)
- Telegram: [@hmziqrs](https://t.me/hmziqrs)

### Personal Website

🌐 Visit my personal site [hmziq.rs](https://hmziq.rs/)
