/*
Resorder使用的 ogg格式解码编码器
https://github.com/xiangyuecn/Recorder

由此源码改动而来 （2023-09-25 大幅精简代码，移除了未调用的函数，但asm里面的代码未做任何精简，原因是精简了200kb的asm代码后需经过大量测试才能偶尔发现精简错误）
ogg-vorbis-encoder-js 这个版本的代码
https://github.com/higuma/ogg-vorbis-encoder-js/blob/7a872423f416e330e925f5266d2eb66cff63c1b6/lib/OggVorbisEncoder.js
*/
(function(factory){
	var browser=typeof window=="object" && !!window.document;
	var win=browser?window:Object; //非浏览器环境，Recorder挂载在Object下面
	var rec=win.Recorder;
	factory(rec);
}(function(Recorder){ //需要在Worker中运行，不能使用Recorder里的方法，包括$T
"use strict";

function Create(){

var Module={};
//精简

var Runtime = {
  //精简
  staticAlloc: function (size) { var ret = STATICTOP;STATICTOP = (STATICTOP + size)|0;STATICTOP = (((STATICTOP)+15)&-16); return ret; },
  dynamicAlloc: function (size) { var ret = DYNAMICTOP;DYNAMICTOP = (DYNAMICTOP + size)|0;DYNAMICTOP = (((DYNAMICTOP)+15)&-16); if (DYNAMICTOP >= TOTAL_MEMORY) { var success = enlargeMemory(); if (!success) { DYNAMICTOP = ret; return 0; } }; return ret; },
  alignMemory: function (size,quantum) { var ret = size = Math.ceil((size)/(quantum ? quantum : 16))*(quantum ? quantum : 16); return ret; },
  GLOBAL_BASE: 8
  //精简
}


Module['Runtime'] = Runtime;
var ABORT = false;
//精简

function assert(condition, text) {
  if (!condition) {
    abort("Assertion failed: " + text)
  }
}

//精简
var ALLOC_STATIC = 2; // Cannot be freed
var ALLOC_NONE = 4; // Do not allocate
Module['ALLOC_STATIC'] = ALLOC_STATIC;
Module['ALLOC_NONE'] = ALLOC_NONE;

function allocate(slab, types, allocator, ptr) {
  var zeroinit, size;
  if (typeof slab === 'number') {
    zeroinit = true;
    size = slab;
  } else {
    zeroinit = false;
    size = slab.length;
  }

  var singleType = typeof types === 'string' ? types : null;

  var ret;
  if (allocator == ALLOC_NONE) {
    ret = ptr;
  } else {
    if(allocator!=ALLOC_STATIC)abort("fix !ALLOC_STATIC");//精简
    ret = Runtime.staticAlloc(Math.max(size, singleType ? 1 : types.length));
  }

  if (zeroinit) {
    var ptr = ret, stop;
    assert((ret & 3) == 0);
    stop = ret + (size & ~3);
    for (; ptr < stop; ptr += 4) {
      HEAP32[((ptr)>>2)]=0;
    }
    stop = ret + size;
    while (ptr < stop) {
      HEAP8[((ptr++)>>0)]=0;
    }
    return ret;
  }

  if (singleType === 'i8') {
    if (slab.subarray || slab.slice) {
      HEAPU8.set(slab, ret);
    } else {
      HEAPU8.set(new Uint8Array(slab), ret);
    }
    return ret;
  }

  abort("fix allocate")
}
Module['allocate'] = allocate;

//精简

var PAGE_SIZE = 4096;

function alignMemoryPage(x) {
  if (x % 4096 > 0) {
    x += (4096 - (x % 4096));
  }
  return x;
}

var HEAP;
var HEAP8, HEAPU8, HEAP16, HEAPU16, HEAP32, HEAPU32, HEAPF32, HEAPF64;

var STATIC_BASE = 0, STATICTOP = 0, staticSealed = false; // static area
var STACK_BASE = 0, STACKTOP = 0, STACK_MAX = 0; // stack area
var DYNAMIC_BASE = 0, DYNAMICTOP = 0; // dynamic area handled by sbrk


function enlargeMemory() {
  abort('enlargeMemory');
}


var TOTAL_STACK = Module['TOTAL_STACK'] || 5242880;
var TOTAL_MEMORY = Module['TOTAL_MEMORY'] || 16777216;

var totalMemory = 64*1024;
while (totalMemory < TOTAL_MEMORY || totalMemory < 2*TOTAL_STACK) {
  if (totalMemory < 16*1024*1024) {
    totalMemory *= 2;
  } else {
    totalMemory += 16*1024*1024
  }
}
if (totalMemory !== TOTAL_MEMORY) {
  abort('fix t!==T')
}
//精简
var buffer;
buffer = new ArrayBuffer(TOTAL_MEMORY);
HEAP8 = new Int8Array(buffer);
HEAP16 = new Int16Array(buffer);
HEAP32 = new Int32Array(buffer);
HEAPU8 = new Uint8Array(buffer);
HEAPU16 = new Uint16Array(buffer);
HEAPU32 = new Uint32Array(buffer);
HEAPF32 = new Float32Array(buffer);
HEAPF64 = new Float64Array(buffer);
HEAP32[0] = 255;
assert(HEAPU8[0] === 255 && HEAPU8[3] === 0, 'fix !LE');
Module['HEAP'] = HEAP;
Module['buffer'] = buffer;
Module['HEAP8'] = HEAP8;
Module['HEAP16'] = HEAP16;
Module['HEAP32'] = HEAP32;
Module['HEAPU8'] = HEAPU8;
Module['HEAPU16'] = HEAPU16;
Module['HEAPU32'] = HEAPU32;
Module['HEAPF32'] = HEAPF32;
Module['HEAPF64'] = HEAPF64;

//精简

if (!Math['imul'] || Math['imul'](0xffffffff, 5) !== -5) Math['imul'] = function imul(a, b) {
  var ah  = a >>> 16;
  var al = a & 0xffff;
  var bh  = b >>> 16;
  var bl = b & 0xffff;
  return (al*bl + ((ah*bl + al*bh) << 16))|0;
};
Math.imul = Math['imul'];


if (!Math['clz32']) Math['clz32'] = function(x) {
  x = x >>> 0;
  for (var i = 0; i < 32; i++) {
    if (x & (1 << (31 - i))) return i;
  }
  return 32;
};
Math.clz32 = Math['clz32']

var Math_abs = Math.abs;
var Math_cos = Math.cos;
var Math_sin = Math.sin;
var Math_tan = Math.tan;
var Math_acos = Math.acos;
var Math_asin = Math.asin;
var Math_atan = Math.atan;
var Math_atan2 = Math.atan2;
var Math_exp = Math.exp;
var Math_log = Math.log;
var Math_sqrt = Math.sqrt;
var Math_ceil = Math.ceil;
var Math_floor = Math.floor;
var Math_pow = Math.pow;
var Math_imul = Math.imul;
var Math_fround = Math.fround;
var Math_min = Math.min;
var Math_clz32 = Math.clz32;

//精简

STATIC_BASE = 8;
STATICTOP = STATIC_BASE + 553552;

//精简 负优化
Module.b64Zip="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";
Module.b64Dic={"size":448462,"bits":8,"b0":157,"bs":[[157],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0],[13,13,13,13,13,13,13,13,13,13,13,13,13,13,13],[9,9,9,9,9,9,9,9,9,9,9,9,9,9,9],[0,0,0],[11,11,11,11,11,11,11,11,11,11,11,11,11,11,11],[194,0,0],[192,121,196,0,192,121,196,0,192,121,196,0,192,121,196],[121,196,0,192,121,196,0,192,121,196,0,192,121,196,0],[16,16,16,16,16,16,16,16,16,16,16,16,16,16,16],[0,192,121,196,0,192,121,196,0,192,121,196,0,192,121],[10,10,10,10,10,10,10,10,10,10,10,10,10,10,10],[12,12,12,12,12,12,12,12,12,12,12,12,12,12,12],[196,0,192,121,196,0,192,121,196,0,192,121,196,0,192],[2,0,0,0],[0,0,2,0,0,0],[255,255,255],[4,0,0,0,0,0,0,0],[4,0,0,0],[12,12,12,12,12,12],[9,9,9,9,9,9],[1,0,0,0,0,0],[3,0,0,0],[3,0,0,0,0,0,0,0],[7,0,0,0],[10,10,10,10,10,10,10],[6,0,0,0],[5,0,0,0],[9,0,0,0,2,0,0,0,10,0,0,0,1,0,0],[0,11,0,0,0,0,0,0,0,12,0,0,0,0,0],[0,48,224,0,0,16,96,3,0,0,0,0,0,0,0],[2,0,1,0,0,0,0],[8,8,8,8],[226,255,255,255,226,255,255,255,226,255,255,255],[8,0,0,0],[194,0,192,121,196,0,192,121,196,0,192,121,196,0,192],[11,11,11,11],[0,2,0,0,0],[0,1,0,0,0],[11,11,12,12],[1,0,0,0],[11,12,12],[10,10,11,11],[12,12,11,12,12,12,12],[9,9,9,9],[0,16,224,0,0,16,96,2,0,0,0,0,0,0,0],[12,12,12],[9,9,10,10],[12,12,13,13],[10,10,10,10],[12,13,13],[9,10,10],[7,7,8,8],[15,15,15],[7,7,7,7,7,7,7,7,7,7,7,7,7,7,7],[10,11,11],[8,8,8,8,8,8,8,8,8,8],[8,8,9,9],[10,0,0,0],[0,0,4,0,0,0],[246,255,255,255,246,255,255,255,246,255,255,255],[236,255,255,255,236,255,255,255,236,255,255,255],[4,0,1,0,0,0,0],[0,0,1,0,0,0],[13,0,0,0,2,0,0,0,14,0,0,0,1,0,0],[0,15,0,0,0,0,0,0,0,16,0,0,0,0,0],[18,0,0,0],[9,0,0,0,0,0,0],[64,0,0,0,0,0],[7,7,7,7],[13,13,13,13,13,13,13],[0,0,5,0,0,0],[13,14,14],[8,9,9],[13,13,12,12],[96,4,0,0,0,0,0,0,0],[13,0,0,0,0,0,0,0],[220,194,0,192,121,196,0,192,121,196,0,192,121,196,0],[226,255,255,255,230,255,255,255,234,255,255,255,236,255,255],[13,12,13,13],[13,13,13],[7,0,1,0,0,0,0],[241,255,255,255,241,255,255,255,241,255,255,255],[240,255,255,255,240,255,255,255,240,255,255,255],[14,14,14],[15,14,14],[10,10,0,0,0,0,0,0],[3,0,1,0,0,0,0,0],[14,15,15],[12,0,0,0],[15,16,16],[12,13,12],[0,80,224,0,0,16,96,4,0,0,0,0,0,0,0],[19,0,0,0],[13,13,12,13,13,13,13],[14,0,0,0,0,0,0,0],[12,11,12,12,12,12],[7,8,8],[12,12,0,0,0],[13,13,11,12,12,12,12,12,12,12],[6,0,1,0,0,0,0],[9,11,11],[0,12,12],[0,84,224,0,0,16,96,4,0,0,0,0,0,0,0],[17,15,15],[14,14,13,13],[16,16,0],[14,14,12,12],[10,10,10],[13,13,0,0,0,0,0],[0,158,224,0,0,84,96,4,0,0,0,0,0,0,0],[6,6,0,0,0,0,0,0,0],[13,12,12,12],[11,0,0,0],[7,9,9],[96,2,0,0,0,0,0,0,0],[11,11,10,11,11],[12,12,10,11,11],[8,8,0,0,0,0,0,0],[6,8,8],[246,255,255,255],[20,0,0,0],[8,10,10],[17,17,0],[224,0,0,16,96,5,0,0,0,0,0,0,0],[16,15,15],[9,9,0,0,0,0,0,0],[17,0,0,0],[11,11,11],[9,0,0,0],[7,8,8,8,8],[9,10,11],[14,0,0,0,9,0,0,0,15,0,0,0,8,0,0],[21,0,0,0,2,0,0,0,22,0,0,0,1,0,0],[0,23,0,0,0,0,0,0,0,24,0,0,0,0,0],[0,13,13],[11,13,13],[7,7,0,0,0,0,0,0],[12,12,11,11],[81,0,0,0],[0,8,0,0,0],[10,12,12],[5,5,7,7],[14,15,14],[0,112,224,0,0,16,96,5,0,0,0,0,0,0,0],[16,16,16],[10,10,12,12],[15,12,13,13,15],[15,15,14,14],[12,10,10],[17,17,17],[8,8,10,10],[232,255,255,255,232,255,255,255,232,255,255,255],[10,11,10],[0,11,11],[0,0,198,66,0,0,198,66,0,0,198,66,0,0,198],[0,0,48,224,0,0,16,96,3,0,0,0,0,0,0],[11,10,11,11],[13,0,0,0],[17,14,15,15],[12,11,11],[16,16,17],[14,14,12,13,13],[5,5,6,6],[236,255,255,255,242,255,255,255,246,255,255,255],[7,7,7,8,8],[15,16,15],[15,15,13,13],[12,0,0,0,0,0,0,0],[5,7,7],[4,4,6,6,7,7],[16,14,14],[12,12,13,12],[250,255,255,255,250,255,255,255],[10,12,11],[6,6,7,7],[15,14,15,15],[11,12,11],[8,9,9,9,9],[13,13,14],[15,15,12,12],[15,15,0],[0,198,66,0,0,198,66,0,0,198,66,0,0,198,66],[198,66,0,0,198,66,0,0,198,66,0,0,198,66,0],[66,0,0,198,66,0,0,198,66,0,0,198,66,0,0],[0,8,8,0],[0,8,8,8,8,9,9,9,9,10,10,11,11],[13,12,12,13],[12,12,11,12],[13,14,13],[10,9,10,10],[16,13,14,14],[9,8,9,9],[11,0,0,0,0,0,0,0],[9,11,10],[14,14,15],[16,0,0,0],[13,13,12,13,12,13],[216,255,255,255,216,255,255,255,216,255,255,255,216,255,255],[11,12,13],[15,13,13],[0,14,14],[11,11,0,0,0,0,0,0,0],[5,5,0,0,0,0,0,0,0],[16,17,17],[13,13,10],[9,9,11,11],[9,9,9,10,10],[248,255,255,255,248,255,255,255],[10,11,12],[12,11,12,12],[230,255,255,255,230,255,255,255,230,255,255,255,230,255,255],[0,118,224,0,0,118,96,2,0,0,0,0,0,0,0],[14,12,12],[48,224,0,0,16,96,3,0,0,0,0,0,0,0],[0,10,10],[15,0,0,0],[8,7,8,8,8,8,8,8,8,8,8,8],[9,9,0,0,0],[14,14,0,0,0,0,0,0,0],[11,13,12],[0,15,15],[11,10,10],[16,15,16,16],[8,8,8,9,9],[10,9,9],[13,14,15],[9,10,9],[5,6,6],[0,10,0,0,0],[11,11,13,13],[13,13,15],[13,11,11],[12,10,11,11],[14,14,14,14,14,14,14,14,14,14,14,14,14,14,14],[0,0,80,224,0,0,16,96,4,0,0,0,0,0,0],[242,255,255,255,242,255,255,255],[255,230,255,255,255,230,255,255,255,230,255,255,255],[16,14,15,15],[12,12,9,10,10],[10,10,11],[11,11,10,10],[0,1,4,4],[16,16,14,15],[5,5,5,5,5,5,5,5,5,5],[8,8,8],[14,13,13],[6,6,6],[14,11,12,12],[5,5,5,5],[0,4,0,0,0],[0,0,16,224,0,0,16,96,2,0,0,0,0,0,0],[12,13,14],[14,14,16],[11,9,9]]};
Module.b64Bytes=0;
//本代码由assets/node-codes/emcc-memory-zip.js生成，强力压缩Emscripten编译出来的静态内存初始化数据

Module.b64Atob=function(input) {
	//低版本Worker里面没有atob https://developer.mozilla.org/en-US/docs/Web/API/atob
	//测试： s=new Array(1024*10).fill();s=s.map(v=>String.fromCharCode(~~(Math.random()*256)));t=s.join("");s=btoa(t);b64Atob(s)==atob(s)
	var bc = 0, bs, buffer, idx = 0, output = '';
	while(true){
		buffer = input.charCodeAt(idx++);
		if(!buffer || buffer==61) break //""||"="
		if(buffer>64&&buffer<91) buffer-=65;
		else if(buffer>96&&buffer<123) buffer-=71; //97-26
		else if(buffer>47&&buffer<58) buffer+=4; //48-26-26
		else if(buffer==43) buffer=62;// +
		else if(buffer==47) buffer=63;// /
		else continue;
		bs = bc % 4 ? bs * 64 + buffer : buffer;
		if(bc++ % 4) output += String.fromCharCode(255 & bs >> (-2 * bc & 6));
	}
	return output;
};
Module.b64UnZip=function(b64,dic){
	var b0=dic.b0,bits=dic.bits,b2=(bits==8?0:bits==7?128:192)-1,mask=bits==8?255:bits==7?127:63;
	var s=typeof atob=="function"?atob(b64):Module.b64Atob(b64);
	var buf=new Uint8Array(dic.size),n=0;
	for(var i=0;i<s.length;i++){
		var v=s.charCodeAt(i);
		if(v==b0){
			var v2=s.charCodeAt(i+1)||0;
			if(v2>b2){//查找字典替换
				var iD=v2&mask,vD=dic.bs[iD];
				for(var j=0;j<vD.length;j++){
					buf[n++]=vD[j];
				}
				i++; continue;
			}
		}
		buf[n++]=v;
	}
	return buf;
};
if(!Module.b64Bytes)Module.b64Bytes=Module.b64UnZip(Module.b64Zip,Module.b64Dic);
Module.b64Val=function(offset,size){
	if(offset+size>Module.b64Bytes.length)abort("b64Val OB");
	return Module.b64Bytes.subarray(offset,offset+size);
};
/* memory initializer */ allocate(Module.b64Val(0,10240), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE);
/* memory initializer */ allocate(Module.b64Val(10240,10240), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+10240);
/* memory initializer */ allocate(Module.b64Val(20480,10240), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+20480);
/* memory initializer */ allocate(Module.b64Val(30720,10185), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+30720);
/* memory initializer */ allocate(Module.b64Val(40905,5305), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+41032);
/* memory initializer */ allocate([1], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+49544);
/* memory initializer */ allocate(Module.b64Val(46210,65), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+50572);
/* memory initializer */ allocate(Module.b64Val(46275,348), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+52752);
/* memory initializer */ allocate(Module.b64Val(46623,5016), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+55148);
/* memory initializer */ allocate(Module.b64Val(51639,10223), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+62212);
/* memory initializer */ allocate(Module.b64Val(61862,5297), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+72464);
/* memory initializer */ allocate([1], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+78916);
/* memory initializer */ allocate(Module.b64Val(67159,1025), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+79944);
/* memory initializer */ allocate(Module.b64Val(68184,129), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+81996);
/* memory initializer */ allocate(Module.b64Val(68313,1372), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+83152);
/* memory initializer */ allocate(Module.b64Val(69685,5773), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+86572);
/* memory initializer */ allocate(Module.b64Val(75458,5257), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+97272);
/* memory initializer */ allocate(Module.b64Val(80715,10237), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+107456);
/* memory initializer */ allocate(Module.b64Val(90952,4596), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+117696);
/* memory initializer */ allocate(Module.b64Val(95548,10240), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+124340);
/* memory initializer */ allocate(Module.b64Val(105788,10240), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+134580);
/* memory initializer */ allocate(Module.b64Val(116028,10215), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+144820);
/* memory initializer */ allocate(Module.b64Val(126243,10240), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+155104);
/* memory initializer */ allocate(Module.b64Val(136483,7956), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+165344);
/* memory initializer */ allocate(Module.b64Val(144439,10240), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+175348);
/* memory initializer */ allocate(Module.b64Val(154679,10239), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+185588);
/* memory initializer */ allocate(Module.b64Val(164918,6507), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+195830);
/* memory initializer */ allocate(Module.b64Val(171425,6225), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+207264);
/* memory initializer */ allocate(Module.b64Val(177650,6057), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+218416);
/* memory initializer */ allocate(Module.b64Val(183707,5993), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+229400);
/* memory initializer */ allocate(Module.b64Val(189700,404), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+240320);
/* memory initializer */ allocate(Module.b64Val(190104,6029), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+242772);
/* memory initializer */ allocate(Module.b64Val(196133,4817), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+253728);
/* memory initializer */ allocate(Module.b64Val(200950,5609), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+263472);
/* memory initializer */ allocate(Module.b64Val(206559,5241), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+274008);
/* memory initializer */ allocate(Module.b64Val(211800,5609), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+284176);
/* memory initializer */ allocate(Module.b64Val(217409,5241), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+294712);
/* memory initializer */ allocate(Module.b64Val(222650,10240), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+304880);
/* memory initializer */ allocate(Module.b64Val(232890,10240), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+315120);
/* memory initializer */ allocate(Module.b64Val(243130,9033), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+325360);
/* memory initializer */ allocate(Module.b64Val(252163,5257), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+339320);
/* memory initializer */ allocate(Module.b64Val(257420,8873), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+349504);
/* memory initializer */ allocate(Module.b64Val(266293,1097), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+360488);
/* memory initializer */ allocate(Module.b64Val(267390,764), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+363696);
/* memory initializer */ allocate(Module.b64Val(268154,1064), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+366508);
/* memory initializer */ allocate(Module.b64Val(269218,10240), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+369616);
/* memory initializer */ allocate(Module.b64Val(279458,10237), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+379856);
/* memory initializer */ allocate(Module.b64Val(289695,10240), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+390097);
/* memory initializer */ allocate(Module.b64Val(299935,10240), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+400337);
/* memory initializer */ allocate(Module.b64Val(310175,10240), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+410577);
/* memory initializer */ allocate(Module.b64Val(320415,10240), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+420817);
/* memory initializer */ allocate(Module.b64Val(330655,10240), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+431057);
/* memory initializer */ allocate(Module.b64Val(340895,2955), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+441297);
/* memory initializer */ allocate(Module.b64Val(343850,10239), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+446300);
/* memory initializer */ allocate(Module.b64Val(354089,10240), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+456540);
/* memory initializer */ allocate(Module.b64Val(364329,10240), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+466780);
/* memory initializer */ allocate(Module.b64Val(374569,10023), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+477020);
/* memory initializer */ allocate(Module.b64Val(384592,364), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+487288);
/* memory initializer */ allocate(Module.b64Val(384956,10199), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+489700);
/* memory initializer */ allocate(Module.b64Val(395155,10227), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+500144);
/* memory initializer */ allocate(Module.b64Val(405382,10240), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+510456);
/* memory initializer */ allocate(Module.b64Val(415622,10240), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+520696);
/* memory initializer */ allocate(Module.b64Val(425862,10240), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+530936);
/* memory initializer */ allocate(Module.b64Val(436102,10240), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+541176);
/* memory initializer */ allocate(Module.b64Val(446342,2120), "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+551416);

/* no memory initializer */
var tempDoublePtr = Runtime.alignMemory(allocate(12, "i8", ALLOC_STATIC), 8);
assert(tempDoublePtr % 8 == 0);

//精简

  
  
  var ___errno_state=0;
  
  function _sysconf(name) {
      if(name==30) return PAGE_SIZE;
      abort("fix _sysconf"); //精简
    }

   
  Module["_memset"] = _memset;
  Module["_strlen"] = _strlen; 
  Module["_strcat"] = _strcat;
  Module["_bitshift64Shl"] = _bitshift64Shl;

  function abort(what) {
    throw new Error("abort(" + what + ")")
  }
  Module.abort = abort;
  function _abort(what) {
      Module['abort'](what);
  }


   
  Module["_i64Add"] = _i64Add;

  var _floor=Math_floor;

  
  function _fflush(stream) {} //精简
  
  
  function _emscripten_set_main_loop_timing(mode, value) {
      //精简
    }function _emscripten_set_main_loop(func, fps, simulateInfiniteLoop, arg, noSetTiming) {
      //精简
    }

  var _llvm_sqrt_f64=Math_sqrt;

  
  function _exit(status) {
      abort('fix _exit')
    }

  var _sin=Math_sin;

   
  Module["_bitshift64Lshr"] = _bitshift64Lshr;

  var _atan=Math_atan;

  var _BDtoIHigh=true;

  var _ceil=Math_ceil;

  var _sinf=Math_sin;

  
  function _emscripten_memcpy_big(dest, src, num) {
      HEAPU8.set(HEAPU8.subarray(src, src+num), dest);
      return dest;
    } 
  Module["_memcpy"] = _memcpy;

  var _log=Math_log;

  var _cos=Math_cos;

  var _llvm_pow_f64=Math_pow;

  function _sbrk(bytes) {
      var self = _sbrk;
      if (!self.called) {
        DYNAMICTOP = alignMemoryPage(DYNAMICTOP); // make sure we start out aligned
        self.called = true;
        assert(Runtime.dynamicAlloc);
        self.alloc = Runtime.dynamicAlloc;
        Runtime.dynamicAlloc = function() { abort('cannot dynamically allocate, sbrk now has control') };
      }
      var ret = DYNAMICTOP;
      if (bytes != 0) {
        var success = self.alloc(bytes);
        if (!success) return -1 >>> 0; // sbrk failure code
      }
      return ret;  // Previous break location.
    }

   
  Module["_memmove"] = _memmove;

  function ___errno_location() {
      return ___errno_state;
    }


   
  Module["_strcpy"] = _strcpy;

  var _exp=Math_exp;

  function _time(ptr) {
      if(!Module.StaticSeed){//每次生成的帧头不一样
        var ret = (Date.now()/1000)|0;
      }else{
        var ret = (1262390400000/1000)|0;
      }
      if (ptr) {
        HEAP32[((ptr)>>2)]=ret;
      }
      return ret;
    }

___errno_state = Runtime.staticAlloc(4); HEAP32[((___errno_state)>>2)]=0;
  
  //精简
  

STACK_BASE = STACKTOP = Runtime.alignMemory(STATICTOP);

staticSealed = true; // seal the static portion of memory

STACK_MAX = STACK_BASE + TOTAL_STACK;

DYNAMIC_BASE = DYNAMICTOP = Runtime.alignMemory(STACK_MAX);

assert(DYNAMIC_BASE < TOTAL_MEMORY, "TOTAL_MEMORY not big enough for stack");
//精简

Module.asmGlobalArg = { "Math": Math, "Int8Array": Int8Array, "Int16Array": Int16Array, "Int32Array": Int32Array, "Uint8Array": Uint8Array, "Uint16Array": Uint16Array, "Uint32Array": Uint32Array, "Float32Array": Float32Array, "Float64Array": Float64Array, "NaN": NaN, "Infinity": Infinity };
Module.asmLibraryArg = { "abort": abort, "assert": assert,
  //精简
  "_sin": _sin, "_exp": _exp, "_floor": _floor, "_fflush": _fflush,
  "_llvm_sqrt_f64": _llvm_sqrt_f64, "_llvm_pow_f64": _llvm_pow_f64, "_emscripten_set_main_loop_timing": _emscripten_set_main_loop_timing, "_sbrk": _sbrk,
  "_atan": _atan, "_emscripten_memcpy_big": _emscripten_memcpy_big, "_sysconf": _sysconf, "_sinf": _sinf, "_cos": _cos, "_log": _log, "_emscripten_set_main_loop": _emscripten_set_main_loop, "___errno_location": ___errno_location, "_abort": _abort, "_time": _time, "_ceil": _ceil,
  "_exit": _exit, "STACKTOP": STACKTOP, "STACK_MAX": STACK_MAX, "tempDoublePtr": tempDoublePtr, "ABORT": ABORT };
// EMSCRIPTEN_START_ASM
var asm = (function(global, env, buffer) {
  'use asm';
  
  var HEAP8 = new global.Int8Array(buffer);
  var HEAP16 = new global.Int16Array(buffer);
  var HEAP32 = new global.Int32Array(buffer);
  var HEAPU8 = new global.Uint8Array(buffer);
  var HEAPU16 = new global.Uint16Array(buffer);
  var HEAPU32 = new global.Uint32Array(buffer);
  var HEAPF32 = new global.Float32Array(buffer);
  var HEAPF64 = new global.Float64Array(buffer);


  var STACKTOP=env.STACKTOP|0;
  var STACK_MAX=env.STACK_MAX|0;
  var tempDoublePtr=env.tempDoublePtr|0;
  var ABORT=env.ABORT|0;
  //精简

  var __THREW__ = 0;
  var threwValue = 0;
  var setjmpId = 0;
  var undef = 0;
  var nan = global.NaN, inf = global.Infinity;
  var tempInt = 0, tempBigInt = 0, tempBigIntP = 0, tempBigIntS = 0, tempBigIntR = 0.0, tempBigIntI = 0, tempBigIntD = 0, tempValue = 0, tempDouble = 0.0;

  var tempRet0 = 0;
  var tempRet1 = 0;
  var tempRet2 = 0;
  var tempRet3 = 0;
  var tempRet4 = 0;
  var tempRet5 = 0;
  var tempRet6 = 0;
  var tempRet7 = 0;
  var tempRet8 = 0;
  var tempRet9 = 0;
  var Math_floor=global.Math.floor;
  var Math_abs=global.Math.abs;
  var Math_sqrt=global.Math.sqrt;
  var Math_pow=global.Math.pow;
  var Math_cos=global.Math.cos;
  var Math_sin=global.Math.sin;
  var Math_tan=global.Math.tan;
  var Math_acos=global.Math.acos;
  var Math_asin=global.Math.asin;
  var Math_atan=global.Math.atan;
  var Math_atan2=global.Math.atan2;
  var Math_exp=global.Math.exp;
  var Math_log=global.Math.log;
  var Math_ceil=global.Math.ceil;
  var Math_imul=global.Math.imul;
  var Math_min=global.Math.min;
  var Math_clz32=global.Math.clz32;
  var abort=env.abort;
  var assert=env.assert;
  //var invoke_iiiii=env.invoke_iiiii;
  //var invoke_vi=env.invoke_vi;
  //var invoke_vii=env.invoke_vii;
  //var invoke_ii=env.invoke_ii;
  //var invoke_viii=env.invoke_viii;
  //var invoke_iiiiiiiii=env.invoke_iiiiiiiii;
  //var invoke_iii=env.invoke_iii;
  //var invoke_iiiiii=env.invoke_iiiiii;
  var _sin=env._sin;
  var _exp=env._exp;
  //var _cosf=env._cosf;
  //var ___setErrNo=env.___setErrNo;
  var _floor=env._floor;
  var _fflush=env._fflush;
  var _llvm_sqrt_f64=env._llvm_sqrt_f64;
  var _llvm_pow_f64=env._llvm_pow_f64;
  var _emscripten_set_main_loop_timing=env._emscripten_set_main_loop_timing;
  //var _fabsf=env._fabsf;
  var _sbrk=env._sbrk;
  var _atan=env._atan;
  var _emscripten_memcpy_big=env._emscripten_memcpy_big;
  var _sysconf=env._sysconf;
  var _sinf=env._sinf;
  var _cos=env._cos;
  var _log=env._log;
  var _emscripten_set_main_loop=env._emscripten_set_main_loop;
  var ___errno_location=env.___errno_location;
  //var __exit=env.__exit;
  var _abort=env._abort;
  var _time=env._time;
  var _ceil=env._ceil;
  var _exit=env._exit;
  var tempFloat = 0.0;

//精简

function _oggpack_writeinit($b) {
 $b = $b|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 ;HEAP32[$b>>2]=0|0;HEAP32[$b+4>>2]=0|0;HEAP32[$b+8>>2]=0|0;HEAP32[$b+12>>2]=0|0;
 $0 = (_malloc(256)|0);
 $1 = ((($b)) + 8|0);
 HEAP32[$1>>2] = $0;
 $2 = ((($b)) + 12|0);
 HEAP32[$2>>2] = $0;
 HEAP8[$0>>0] = 0;
 $3 = ((($b)) + 16|0);
 HEAP32[$3>>2] = 256;
 return;
}
function _oggpack_writetrunc($b,$bits) {
 $b = $b|0;
 $bits = $bits|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = $bits >> 3;
 $1 = ((($b)) + 12|0);
 $2 = HEAP32[$1>>2]|0;
 $3 = ($2|0)==(0|0);
 if ($3) {
  return;
 }
 $4 = $0 << 3;
 $5 = (($bits) - ($4))|0;
 $6 = ((($b)) + 8|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = (($7) + ($0)|0);
 HEAP32[$1>>2] = $8;
 $9 = ((($b)) + 4|0);
 HEAP32[$9>>2] = $5;
 HEAP32[$b>>2] = $0;
 $10 = (8 + ($5<<2)|0);
 $11 = HEAP32[$10>>2]|0;
 $12 = HEAP8[$8>>0]|0;
 $13 = $12&255;
 $14 = $13 & $11;
 $15 = $14&255;
 HEAP8[$8>>0] = $15;
 return;
}
function _oggpack_write($b,$value,$bits) {
 $b = $b|0;
 $value = $value|0;
 $bits = $bits|0;
 var $$phi$trans$insert = 0, $$pre = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0;
 var $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0;
 var $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0;
 var $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ($bits>>>0)>(32);
 do {
  if (!($0)) {
   $1 = HEAP32[$b>>2]|0;
   $2 = ((($b)) + 16|0);
   $3 = HEAP32[$2>>2]|0;
   $4 = (($3) + -4)|0;
   $5 = ($1|0)<($4|0);
   $$phi$trans$insert = ((($b)) + 12|0);
   $$pre = HEAP32[$$phi$trans$insert>>2]|0;
   if ($5) {
    $25 = $$pre;
   } else {
    $6 = ($$pre|0)==(0|0);
    if ($6) {
     return;
    }
    $7 = ($3|0)>(2147483391);
    if ($7) {
     break;
    }
    $8 = ((($b)) + 8|0);
    $9 = HEAP32[$8>>2]|0;
    $10 = (($3) + 256)|0;
    $11 = (_realloc($9,$10)|0);
    $12 = ($11|0)==(0|0);
    if ($12) {
     break;
    }
    HEAP32[$8>>2] = $11;
    $13 = HEAP32[$2>>2]|0;
    $14 = (($13) + 256)|0;
    HEAP32[$2>>2] = $14;
    $15 = HEAP32[$b>>2]|0;
    $16 = (($11) + ($15)|0);
    HEAP32[$$phi$trans$insert>>2] = $16;
    $25 = $16;
   }
   $17 = (8 + ($bits<<2)|0);
   $18 = HEAP32[$17>>2]|0;
   $19 = $18 & $value;
   $20 = ((($b)) + 4|0);
   $21 = HEAP32[$20>>2]|0;
   $22 = (($21) + ($bits))|0;
   $23 = $19 << $21;
   $24 = HEAP8[$25>>0]|0;
   $26 = $24&255;
   $27 = $26 | $23;
   $28 = $27&255;
   HEAP8[$25>>0] = $28;
   $29 = ($22|0)>(7);
   do {
    if ($29) {
     $30 = HEAP32[$20>>2]|0;
     $31 = (8 - ($30))|0;
     $32 = $19 >>> $31;
     $33 = $32&255;
     $34 = HEAP32[$$phi$trans$insert>>2]|0;
     $35 = ((($34)) + 1|0);
     HEAP8[$35>>0] = $33;
     $36 = ($22|0)>(15);
     if ($36) {
      $37 = HEAP32[$20>>2]|0;
      $38 = (16 - ($37))|0;
      $39 = $19 >>> $38;
      $40 = $39&255;
      $41 = HEAP32[$$phi$trans$insert>>2]|0;
      $42 = ((($41)) + 2|0);
      HEAP8[$42>>0] = $40;
      $43 = ($22|0)>(23);
      if ($43) {
       $44 = HEAP32[$20>>2]|0;
       $45 = (24 - ($44))|0;
       $46 = $19 >>> $45;
       $47 = $46&255;
       $48 = HEAP32[$$phi$trans$insert>>2]|0;
       $49 = ((($48)) + 3|0);
       HEAP8[$49>>0] = $47;
       $50 = ($22|0)>(31);
       if ($50) {
        $51 = HEAP32[$20>>2]|0;
        $52 = ($51|0)==(0);
        if ($52) {
         $58 = HEAP32[$$phi$trans$insert>>2]|0;
         $59 = ((($58)) + 4|0);
         HEAP8[$59>>0] = 0;
         break;
        } else {
         $53 = (32 - ($51))|0;
         $54 = $19 >>> $53;
         $55 = $54&255;
         $56 = HEAP32[$$phi$trans$insert>>2]|0;
         $57 = ((($56)) + 4|0);
         HEAP8[$57>>0] = $55;
         break;
        }
       }
      }
     }
    }
   } while(0);
   $60 = (($22|0) / 8)&-1;
   $61 = HEAP32[$b>>2]|0;
   $62 = (($61) + ($60))|0;
   HEAP32[$b>>2] = $62;
   $63 = HEAP32[$$phi$trans$insert>>2]|0;
   $64 = (($63) + ($60)|0);
   HEAP32[$$phi$trans$insert>>2] = $64;
   $65 = $22 & 7;
   HEAP32[$20>>2] = $65;
   return;
  }
 } while(0);
 $66 = ((($b)) + 8|0);
 $67 = HEAP32[$66>>2]|0;
 $68 = ($67|0)==(0|0);
 if (!($68)) {
  _free($67);
 }
 ;HEAP32[$b>>2]=0|0;HEAP32[$b+4>>2]=0|0;HEAP32[$b+8>>2]=0|0;HEAP32[$b+12>>2]=0|0;HEAP32[$b+16>>2]=0|0;
 return;
}
function _oggpack_writeclear($b) {
 $b = $b|0;
 var $0 = 0, $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($b)) + 8|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ($1|0)==(0|0);
 if (!($2)) {
  _free($1);
 }
 ;HEAP32[$b>>2]=0|0;HEAP32[$b+4>>2]=0|0;HEAP32[$b+8>>2]=0|0;HEAP32[$b+12>>2]=0|0;HEAP32[$b+16>>2]=0|0;
 return;
}
function _oggpack_reset($b) {
 $b = $b|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($b)) + 12|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ($1|0)==(0|0);
 if ($2) {
  return;
 }
 $3 = ((($b)) + 8|0);
 $4 = HEAP32[$3>>2]|0;
 HEAP32[$0>>2] = $4;
 $5 = $4;
 HEAP8[$5>>0] = 0;
 HEAP32[$b>>2] = 0;
 $6 = ((($b)) + 4|0);
 HEAP32[$6>>2] = 0;
 return;
}
function _oggpack_look($b,$bits) {
 $b = $b|0;
 $bits = $bits|0;
 var $$0 = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0;
 var $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0;
 var $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $or$cond = 0, $ret$0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ($bits>>>0)>(32);
 if ($0) {
  $$0 = -1;
  return ($$0|0);
 }
 $1 = (8 + ($bits<<2)|0);
 $2 = HEAP32[$1>>2]|0;
 $3 = ((($b)) + 4|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = (($4) + ($bits))|0;
 $6 = HEAP32[$b>>2]|0;
 $7 = ((($b)) + 16|0);
 $8 = HEAP32[$7>>2]|0;
 $9 = (($8) + -4)|0;
 $10 = ($6|0)<($9|0);
 if (!($10)) {
  $11 = (($5) + 7)|0;
  $12 = $11 >> 3;
  $13 = (($8) - ($12))|0;
  $14 = ($6|0)>($13|0);
  if ($14) {
   $$0 = -1;
   return ($$0|0);
  }
  $15 = ($5|0)==(0);
  if ($15) {
   $$0 = 0;
   return ($$0|0);
  }
 }
 $16 = ((($b)) + 12|0);
 $17 = HEAP32[$16>>2]|0;
 $18 = HEAP8[$17>>0]|0;
 $19 = $18&255;
 $20 = $19 >>> $4;
 $21 = ($5|0)>(8);
 if ($21) {
  $22 = ((($17)) + 1|0);
  $23 = HEAP8[$22>>0]|0;
  $24 = $23&255;
  $25 = (8 - ($4))|0;
  $26 = $24 << $25;
  $27 = $26 | $20;
  $28 = ($5|0)>(16);
  if ($28) {
   $29 = ((($17)) + 2|0);
   $30 = HEAP8[$29>>0]|0;
   $31 = $30&255;
   $32 = (16 - ($4))|0;
   $33 = $31 << $32;
   $34 = $33 | $27;
   $35 = ($5|0)>(24);
   if ($35) {
    $36 = ((($17)) + 3|0);
    $37 = HEAP8[$36>>0]|0;
    $38 = $37&255;
    $39 = (24 - ($4))|0;
    $40 = $38 << $39;
    $41 = $40 | $34;
    $42 = ($5|0)<(33);
    $43 = ($4|0)==(0);
    $or$cond = $42 | $43;
    if ($or$cond) {
     $ret$0 = $41;
    } else {
     $44 = ((($17)) + 4|0);
     $45 = HEAP8[$44>>0]|0;
     $46 = $45&255;
     $47 = (32 - ($4))|0;
     $48 = $46 << $47;
     $49 = $48 | $41;
     $ret$0 = $49;
    }
   } else {
    $ret$0 = $34;
   }
  } else {
   $ret$0 = $27;
  }
 } else {
  $ret$0 = $20;
 }
 $50 = $ret$0 & $2;
 $$0 = $50;
 return ($$0|0);
}
function _oggpack_adv($b,$bits) {
 $b = $b|0;
 $bits = $bits|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $storemerge = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($b)) + 4|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = (($1) + ($bits))|0;
 $3 = HEAP32[$b>>2]|0;
 $4 = ((($b)) + 16|0);
 $5 = HEAP32[$4>>2]|0;
 $6 = (($2) + 7)|0;
 $7 = $6 >> 3;
 $8 = (($5) - ($7))|0;
 $9 = ($3|0)>($8|0);
 if ($9) {
  $16 = ((($b)) + 12|0);
  HEAP32[$16>>2] = 0;
  HEAP32[$b>>2] = $5;
  $storemerge = 1;
  HEAP32[$0>>2] = $storemerge;
  return;
 } else {
  $10 = (($2|0) / 8)&-1;
  $11 = ((($b)) + 12|0);
  $12 = HEAP32[$11>>2]|0;
  $13 = (($12) + ($10)|0);
  HEAP32[$11>>2] = $13;
  $14 = (($3) + ($10))|0;
  HEAP32[$b>>2] = $14;
  $15 = $2 & 7;
  $storemerge = $15;
  HEAP32[$0>>2] = $storemerge;
  return;
 }
}
function _oggpack_read($b,$bits) {
 $b = $b|0;
 $bits = $bits|0;
 var $$0 = 0, $$phi$trans$insert = 0, $$pre = 0, $$pre$phi3Z2D = 0, $$pre$phi5Z2D = 0, $$pre4 = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0;
 var $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0;
 var $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $6 = 0;
 var $7 = 0, $8 = 0, $9 = 0, $or$cond = 0, $ret$0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ($bits>>>0)>(32);
 do {
  if ($0) {
   $$phi$trans$insert = ((($b)) + 16|0);
   $$pre = HEAP32[$$phi$trans$insert>>2]|0;
   $$pre4 = ((($b)) + 4|0);
   $$pre$phi3Z2D = $b;$$pre$phi5Z2D = $$pre4;$56 = $$pre;
  } else {
   $1 = (8 + ($bits<<2)|0);
   $2 = HEAP32[$1>>2]|0;
   $3 = ((($b)) + 4|0);
   $4 = HEAP32[$3>>2]|0;
   $5 = (($4) + ($bits))|0;
   $6 = HEAP32[$b>>2]|0;
   $7 = ((($b)) + 16|0);
   $8 = HEAP32[$7>>2]|0;
   $9 = (($8) + -4)|0;
   $10 = ($6|0)<($9|0);
   if (!($10)) {
    $11 = (($5) + 7)|0;
    $12 = $11 >> 3;
    $13 = (($8) - ($12))|0;
    $14 = ($6|0)>($13|0);
    if ($14) {
     $$pre$phi3Z2D = $b;$$pre$phi5Z2D = $3;$56 = $8;
     break;
    }
    $15 = ($5|0)==(0);
    if ($15) {
     $$0 = 0;
     return ($$0|0);
    }
   }
   $16 = ((($b)) + 12|0);
   $17 = HEAP32[$16>>2]|0;
   $18 = HEAP8[$17>>0]|0;
   $19 = $18&255;
   $20 = $19 >>> $4;
   $21 = ($5|0)>(8);
   if ($21) {
    $22 = ((($17)) + 1|0);
    $23 = HEAP8[$22>>0]|0;
    $24 = $23&255;
    $25 = (8 - ($4))|0;
    $26 = $24 << $25;
    $27 = $26 | $20;
    $28 = ($5|0)>(16);
    if ($28) {
     $29 = ((($17)) + 2|0);
     $30 = HEAP8[$29>>0]|0;
     $31 = $30&255;
     $32 = (16 - ($4))|0;
     $33 = $31 << $32;
     $34 = $33 | $27;
     $35 = ($5|0)>(24);
     if ($35) {
      $36 = ((($17)) + 3|0);
      $37 = HEAP8[$36>>0]|0;
      $38 = $37&255;
      $39 = (24 - ($4))|0;
      $40 = $38 << $39;
      $41 = $40 | $34;
      $42 = ($5|0)<(33);
      $43 = ($4|0)==(0);
      $or$cond = $42 | $43;
      if ($or$cond) {
       $ret$0 = $41;
      } else {
       $44 = ((($17)) + 4|0);
       $45 = HEAP8[$44>>0]|0;
       $46 = $45&255;
       $47 = (32 - ($4))|0;
       $48 = $46 << $47;
       $49 = $48 | $41;
       $ret$0 = $49;
      }
     } else {
      $ret$0 = $34;
     }
    } else {
     $ret$0 = $27;
    }
   } else {
    $ret$0 = $20;
   }
   $50 = $ret$0 & $2;
   $51 = (($5|0) / 8)&-1;
   $52 = (($17) + ($51)|0);
   HEAP32[$16>>2] = $52;
   $53 = (($6) + ($51))|0;
   HEAP32[$b>>2] = $53;
   $54 = $5 & 7;
   HEAP32[$3>>2] = $54;
   $$0 = $50;
   return ($$0|0);
  }
 } while(0);
 $55 = ((($b)) + 12|0);
 HEAP32[$55>>2] = 0;
 HEAP32[$$pre$phi3Z2D>>2] = $56;
 HEAP32[$$pre$phi5Z2D>>2] = 1;
 $$0 = -1;
 return ($$0|0);
}
function _oggpack_bytes($b) {
 $b = $b|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = HEAP32[$b>>2]|0;
 $1 = ((($b)) + 4|0);
 $2 = HEAP32[$1>>2]|0;
 $3 = (($2) + 7)|0;
 $4 = (($3|0) / 8)&-1;
 $5 = (($4) + ($0))|0;
 return ($5|0);
}
function _oggpack_get_buffer($b) {
 $b = $b|0;
 var $0 = 0, $1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($b)) + 8|0);
 $1 = HEAP32[$0>>2]|0;
 return ($1|0);
}
function _ogg_stream_init($os,$serialno) {
 $os = $os|0;
 $serialno = $serialno|0;
 var $$0 = 0, $$pre = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $or$cond = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 $0 = ($os|0)==(0|0);
 if ($0) {
  $$0 = -1;
  return ($$0|0);
 }
 _memset(($os|0),0,360)|0;
 $1 = ((($os)) + 4|0);
 HEAP32[$1>>2] = 16384;
 $2 = ((($os)) + 24|0);
 HEAP32[$2>>2] = 1024;
 $3 = (_malloc(16384)|0);
 HEAP32[$os>>2] = $3;
 $4 = (_malloc(4096)|0);
 $5 = ((($os)) + 16|0);
 HEAP32[$5>>2] = $4;
 $6 = (_malloc(8192)|0);
 $7 = ((($os)) + 20|0);
 HEAP32[$7>>2] = $6;
 $8 = ($3|0)==(0|0);
 do {
  if ($8) {
   $11 = $4;
  } else {
   $9 = ($4|0)==(0|0);
   $10 = ($6|0)==(0|0);
   $or$cond = $10 | $9;
   if ($or$cond) {
    _free($3);
    $$pre = HEAP32[$5>>2]|0;
    $11 = $$pre;
    break;
   }
   $15 = ((($os)) + 336|0);
   HEAP32[$15>>2] = $serialno;
   $$0 = 0;
   return ($$0|0);
  }
 } while(0);
 $12 = ($11|0)==(0|0);
 if (!($12)) {
  _free($11);
 }
 $13 = HEAP32[$7>>2]|0;
 $14 = ($13|0)==(0|0);
 if (!($14)) {
  _free($13);
 }
 _memset(($os|0),0,360)|0;
 $$0 = -1;
 return ($$0|0);
}
function _ogg_stream_clear($os) {
 $os = $os|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ($os|0)==(0|0);
 if ($0) {
  return 0;
 }
 $1 = HEAP32[$os>>2]|0;
 $2 = ($1|0)==(0|0);
 if (!($2)) {
  _free($1);
 }
 $3 = ((($os)) + 16|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = ($4|0)==(0|0);
 if (!($5)) {
  _free($4);
 }
 $6 = ((($os)) + 20|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = ($7|0)==(0|0);
 if (!($8)) {
  _free($7);
 }
 _memset(($os|0),0,360)|0;
 return 0;
}
function _ogg_page_checksum_set($og) {
 $og = $og|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $crc_reg$0$lcssa = 0, $crc_reg$03 = 0, $crc_reg$1$lcssa = 0, $crc_reg$11 = 0, $i$04 = 0;
 var $i$12 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ($og|0)==(0|0);
 if ($0) {
  return;
 }
 $1 = HEAP32[$og>>2]|0;
 $2 = ((($1)) + 22|0);
 HEAP8[$2>>0] = 0;
 $3 = HEAP32[$og>>2]|0;
 $4 = ((($3)) + 23|0);
 HEAP8[$4>>0] = 0;
 $5 = HEAP32[$og>>2]|0;
 $6 = ((($5)) + 24|0);
 HEAP8[$6>>0] = 0;
 $7 = HEAP32[$og>>2]|0;
 $8 = ((($7)) + 25|0);
 HEAP8[$8>>0] = 0;
 $9 = ((($og)) + 4|0);
 $10 = HEAP32[$9>>2]|0;
 $11 = ($10|0)>(0);
 if ($11) {
  $12 = HEAP32[$og>>2]|0;
  $crc_reg$03 = 0;$i$04 = 0;
  while(1) {
   $18 = $crc_reg$03 << 8;
   $19 = $crc_reg$03 >>> 24;
   $20 = (($12) + ($i$04)|0);
   $21 = HEAP8[$20>>0]|0;
   $22 = $21&255;
   $23 = $22 ^ $19;
   $24 = (144 + ($23<<2)|0);
   $25 = HEAP32[$24>>2]|0;
   $26 = $25 ^ $18;
   $27 = (($i$04) + 1)|0;
   $28 = ($27|0)<($10|0);
   if ($28) {
    $crc_reg$03 = $26;$i$04 = $27;
   } else {
    $crc_reg$0$lcssa = $26;
    break;
   }
  }
 } else {
  $crc_reg$0$lcssa = 0;
 }
 $13 = ((($og)) + 12|0);
 $14 = HEAP32[$13>>2]|0;
 $15 = ($14|0)>(0);
 if ($15) {
  $16 = ((($og)) + 8|0);
  $17 = HEAP32[$16>>2]|0;
  $crc_reg$11 = $crc_reg$0$lcssa;$i$12 = 0;
  while(1) {
   $29 = $crc_reg$11 << 8;
   $30 = $crc_reg$11 >>> 24;
   $31 = (($17) + ($i$12)|0);
   $32 = HEAP8[$31>>0]|0;
   $33 = $32&255;
   $34 = $33 ^ $30;
   $35 = (144 + ($34<<2)|0);
   $36 = HEAP32[$35>>2]|0;
   $37 = $36 ^ $29;
   $38 = (($i$12) + 1)|0;
   $39 = ($38|0)<($14|0);
   if ($39) {
    $crc_reg$11 = $37;$i$12 = $38;
   } else {
    $crc_reg$1$lcssa = $37;
    break;
   }
  }
 } else {
  $crc_reg$1$lcssa = $crc_reg$0$lcssa;
 }
 $40 = $crc_reg$1$lcssa&255;
 $41 = HEAP32[$og>>2]|0;
 $42 = ((($41)) + 22|0);
 HEAP8[$42>>0] = $40;
 $43 = $crc_reg$1$lcssa >>> 8;
 $44 = $43&255;
 $45 = HEAP32[$og>>2]|0;
 $46 = ((($45)) + 23|0);
 HEAP8[$46>>0] = $44;
 $47 = $crc_reg$1$lcssa >>> 16;
 $48 = $47&255;
 $49 = HEAP32[$og>>2]|0;
 $50 = ((($49)) + 24|0);
 HEAP8[$50>>0] = $48;
 $51 = $crc_reg$1$lcssa >>> 24;
 $52 = $51&255;
 $53 = HEAP32[$og>>2]|0;
 $54 = ((($53)) + 25|0);
 HEAP8[$54>>0] = $52;
 return;
}
function _ogg_stream_iovecin($os,$iov,$count,$e_o_s,$0,$1) {
 $os = $os|0;
 $iov = $iov|0;
 $count = $count|0;
 $e_o_s = $e_o_s|0;
 $0 = $0|0;
 $1 = $1|0;
 var $$$i2 = 0, $$0 = 0, $$phi$trans$insert21 = 0, $$pre = 0, $$pre$phi28Z2D = 0, $$pre22 = 0, $$pre27 = 0, $$pre30 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0;
 var $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0;
 var $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0;
 var $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0;
 var $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0;
 var $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0;
 var $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $bytes$0$lcssa = 0, $bytes$012 = 0, $exitcond = 0, $i$013 = 0, $i$110 = 0, $i$2$lcssa = 0, $i$29 = 0, $or$cond = 0, $smax = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $2 = ($os|0)==(0|0);
 if ($2) {
  $$0 = -1;
  return ($$0|0);
 }
 $3 = HEAP32[$os>>2]|0;
 $4 = ($3|0)==(0|0);
 if ($4) {
  $$0 = -1;
  return ($$0|0);
 }
 $5 = ($iov|0)==(0|0);
 if ($5) {
  $$0 = 0;
  return ($$0|0);
 }
 $6 = ($count|0)>(0);
 L10: do {
  if ($6) {
   $bytes$012 = 0;$i$013 = 0;
   while(1) {
    $7 = (((($iov) + ($i$013<<3)|0)) + 4|0);
    $8 = HEAP32[$7>>2]|0;
    $9 = ($8|0)<(0);
    $10 = (2147483647 - ($8))|0;
    $11 = ($bytes$012|0)>($10|0);
    $or$cond = $9 | $11;
    if ($or$cond) {
     $$0 = -1;
     break;
    }
    $12 = (($8) + ($bytes$012))|0;
    $13 = (($i$013) + 1)|0;
    $14 = ($13|0)<($count|0);
    if ($14) {
     $bytes$012 = $12;$i$013 = $13;
    } else {
     $bytes$0$lcssa = $12;
     break L10;
    }
   }
   return ($$0|0);
  } else {
   $bytes$0$lcssa = 0;
  }
 } while(0);
 $15 = (($bytes$0$lcssa|0) / 255)&-1;
 $16 = (($15) + 1)|0;
 $17 = ((($os)) + 12|0);
 $18 = HEAP32[$17>>2]|0;
 $19 = ($18|0)==(0);
 $$pre30 = ((($os)) + 8|0);
 if (!($19)) {
  $20 = HEAP32[$$pre30>>2]|0;
  $21 = (($20) - ($18))|0;
  HEAP32[$$pre30>>2] = $21;
  $22 = ($20|0)==($18|0);
  if (!($22)) {
   $23 = (($3) + ($18)|0);
   _memmove(($3|0),($23|0),($21|0))|0;
  }
  HEAP32[$17>>2] = 0;
 }
 $24 = ((($os)) + 4|0);
 $25 = HEAP32[$24>>2]|0;
 $26 = (($25) - ($bytes$0$lcssa))|0;
 $27 = HEAP32[$$pre30>>2]|0;
 $28 = ($26|0)>($27|0);
 do {
  if (!($28)) {
   $29 = (2147483647 - ($bytes$0$lcssa))|0;
   $30 = ($25|0)>($29|0);
   if ($30) {
    $31 = HEAP32[$os>>2]|0;
    $32 = ($31|0)==(0|0);
    if (!($32)) {
     _free($31);
    }
    $33 = ((($os)) + 16|0);
    $34 = HEAP32[$33>>2]|0;
    $35 = ($34|0)==(0|0);
    if (!($35)) {
     _free($34);
    }
    $36 = ((($os)) + 20|0);
    $37 = HEAP32[$36>>2]|0;
    $38 = ($37|0)==(0|0);
    if (!($38)) {
     _free($37);
    }
    _memset(($os|0),0,360)|0;
    $$0 = -1;
    return ($$0|0);
   }
   $39 = (($25) + ($bytes$0$lcssa))|0;
   $40 = ($39|0)<(2147482623);
   $41 = (($39) + 1024)|0;
   $$$i2 = $40 ? $41 : $39;
   $42 = HEAP32[$os>>2]|0;
   $43 = (_realloc($42,$$$i2)|0);
   $44 = ($43|0)==(0|0);
   if (!($44)) {
    HEAP32[$24>>2] = $$$i2;
    HEAP32[$os>>2] = $43;
    break;
   }
   $45 = HEAP32[$os>>2]|0;
   $46 = ($45|0)==(0|0);
   if (!($46)) {
    _free($45);
   }
   $47 = ((($os)) + 16|0);
   $48 = HEAP32[$47>>2]|0;
   $49 = ($48|0)==(0|0);
   if (!($49)) {
    _free($48);
   }
   $50 = ((($os)) + 20|0);
   $51 = HEAP32[$50>>2]|0;
   $52 = ($51|0)==(0|0);
   if (!($52)) {
    _free($51);
   }
   _memset(($os|0),0,360)|0;
   $$0 = -1;
   return ($$0|0);
  }
 } while(0);
 $53 = (__os_lacing_expand($os,$16)|0);
 $54 = ($53|0)==(0);
 if (!($54)) {
  $$0 = -1;
  return ($$0|0);
 }
 if ($6) {
  $$pre = HEAP32[$$pre30>>2]|0;
  $66 = $$pre;$i$110 = 0;
  while(1) {
   $64 = HEAP32[$os>>2]|0;
   $65 = (($64) + ($66)|0);
   $67 = (($iov) + ($i$110<<3)|0);
   $68 = HEAP32[$67>>2]|0;
   $69 = (((($iov) + ($i$110<<3)|0)) + 4|0);
   $70 = HEAP32[$69>>2]|0;
   _memcpy(($65|0),($68|0),($70|0))|0;
   $71 = HEAP32[$69>>2]|0;
   $72 = HEAP32[$$pre30>>2]|0;
   $73 = (($72) + ($71))|0;
   HEAP32[$$pre30>>2] = $73;
   $74 = (($i$110) + 1)|0;
   $exitcond = ($74|0)==($count|0);
   if ($exitcond) {
    break;
   } else {
    $66 = $73;$i$110 = $74;
   }
  }
 }
 $55 = ($bytes$0$lcssa|0)>(254);
 $56 = ((($os)) + 28|0);
 $57 = HEAP32[$56>>2]|0;
 $58 = ((($os)) + 16|0);
 $59 = HEAP32[$58>>2]|0;
 if ($55) {
  $60 = ((($os)) + 352|0);
  $61 = ((($os)) + 20|0);
  $62 = HEAP32[$61>>2]|0;
  $63 = ($15|0)>(1);
  $i$29 = 0;
  while(1) {
   $75 = (($57) + ($i$29))|0;
   $76 = (($59) + ($75<<2)|0);
   HEAP32[$76>>2] = 255;
   $77 = $60;
   $78 = $77;
   $79 = HEAP32[$78>>2]|0;
   $80 = (($77) + 4)|0;
   $81 = $80;
   $82 = HEAP32[$81>>2]|0;
   $83 = (($62) + ($75<<3)|0);
   $84 = $83;
   $85 = $84;
   HEAP32[$85>>2] = $79;
   $86 = (($84) + 4)|0;
   $87 = $86;
   HEAP32[$87>>2] = $82;
   $88 = (($i$29) + 1)|0;
   $89 = ($88|0)<($15|0);
   if ($89) {
    $i$29 = $88;
   } else {
    break;
   }
  }
  $smax = $63 ? $15 : 1;
  $$pre$phi28Z2D = $60;$94 = $62;$i$2$lcssa = $smax;
 } else {
  $$phi$trans$insert21 = ((($os)) + 20|0);
  $$pre22 = HEAP32[$$phi$trans$insert21>>2]|0;
  $$pre27 = ((($os)) + 352|0);
  $$pre$phi28Z2D = $$pre27;$94 = $$pre22;$i$2$lcssa = 0;
 }
 $90 = (($bytes$0$lcssa|0) % 255)&-1;
 $91 = (($57) + ($i$2$lcssa))|0;
 $92 = (($59) + ($91<<2)|0);
 HEAP32[$92>>2] = $90;
 $93 = (($94) + ($91<<3)|0);
 $95 = $93;
 $96 = $95;
 HEAP32[$96>>2] = $0;
 $97 = (($95) + 4)|0;
 $98 = $97;
 HEAP32[$98>>2] = $1;
 $99 = $$pre$phi28Z2D;
 $100 = $99;
 HEAP32[$100>>2] = $0;
 $101 = (($99) + 4)|0;
 $102 = $101;
 HEAP32[$102>>2] = $1;
 $103 = (($59) + ($57<<2)|0);
 $104 = HEAP32[$103>>2]|0;
 $105 = $104 | 256;
 HEAP32[$103>>2] = $105;
 $106 = (($57) + ($16))|0;
 HEAP32[$56>>2] = $106;
 $107 = ((($os)) + 344|0);
 $108 = $107;
 $109 = $108;
 $110 = HEAP32[$109>>2]|0;
 $111 = (($108) + 4)|0;
 $112 = $111;
 $113 = HEAP32[$112>>2]|0;
 $114 = (_i64Add(($110|0),($113|0),1,0)|0);
 $115 = tempRet0;
 $116 = $107;
 $117 = $116;
 HEAP32[$117>>2] = $114;
 $118 = (($116) + 4)|0;
 $119 = $118;
 HEAP32[$119>>2] = $115;
 $120 = ($e_o_s|0)==(0);
 if ($120) {
  $$0 = 0;
  return ($$0|0);
 }
 $121 = ((($os)) + 328|0);
 HEAP32[$121>>2] = 1;
 $$0 = 0;
 return ($$0|0);
}
function _ogg_stream_packetin($os,$op) {
 $os = $os|0;
 $op = $op|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $iov = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $iov = sp;
 $0 = HEAP32[$op>>2]|0;
 HEAP32[$iov>>2] = $0;
 $1 = ((($op)) + 4|0);
 $2 = HEAP32[$1>>2]|0;
 $3 = ((($iov)) + 4|0);
 HEAP32[$3>>2] = $2;
 $4 = ((($op)) + 12|0);
 $5 = HEAP32[$4>>2]|0;
 $6 = ((($op)) + 16|0);
 $7 = $6;
 $8 = $7;
 $9 = HEAP32[$8>>2]|0;
 $10 = (($7) + 4)|0;
 $11 = $10;
 $12 = HEAP32[$11>>2]|0;
 $13 = (_ogg_stream_iovecin($os,$iov,1,$5,$9,$12)|0);
 STACKTOP = sp;return ($13|0);
}
function _ogg_stream_flush($os,$og) {
 $os = $os|0;
 $og = $og|0;
 var $0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = (_ogg_stream_flush_i($os,$og,1,4096)|0);
 return ($0|0);
}
function _ogg_stream_pageout($os,$og) {
 $os = $os|0;
 $og = $og|0;
 var $$0 = 0, $$phi$trans$insert = 0, $$pre = 0, $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $force$0 = 0, $phitmp = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ($os|0)==(0|0);
 if ($0) {
  $$0 = 0;
  return ($$0|0);
 }
 $1 = HEAP32[$os>>2]|0;
 $2 = ($1|0)==(0|0);
 if ($2) {
  $$0 = 0;
  return ($$0|0);
 }
 $3 = ((($os)) + 328|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = ($4|0)==(0);
 $$phi$trans$insert = ((($os)) + 28|0);
 $$pre = HEAP32[$$phi$trans$insert>>2]|0;
 $phitmp = ($$pre|0)==(0);
 if ($5) {
  if ($phitmp) {
   $force$0 = 0;
  } else {
   $6 = ((($os)) + 332|0);
   $7 = HEAP32[$6>>2]|0;
   $8 = ($7|0)==(0);
   if ($8) {
    label = 7;
   } else {
    $force$0 = 0;
   }
  }
 } else {
  if ($phitmp) {
   $force$0 = 0;
  } else {
   label = 7;
  }
 }
 if ((label|0) == 7) {
  $force$0 = 1;
 }
 $9 = (_ogg_stream_flush_i($os,$og,$force$0,4096)|0);
 $$0 = $9;
 return ($$0|0);
}
function __os_lacing_expand($os,$needed) {
 $os = $os|0;
 $needed = $needed|0;
 var $$ = 0, $$0 = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0;
 var $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($os)) + 24|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = (($1) - ($needed))|0;
 $3 = ((($os)) + 28|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = ($2|0)>($4|0);
 if ($5) {
  $$0 = 0;
  return ($$0|0);
 }
 $6 = (2147483647 - ($needed))|0;
 $7 = ($1|0)>($6|0);
 if ($7) {
  $8 = HEAP32[$os>>2]|0;
  $9 = ($8|0)==(0|0);
  if (!($9)) {
   _free($8);
  }
  $10 = ((($os)) + 16|0);
  $11 = HEAP32[$10>>2]|0;
  $12 = ($11|0)==(0|0);
  if (!($12)) {
   _free($11);
  }
  $13 = ((($os)) + 20|0);
  $14 = HEAP32[$13>>2]|0;
  $15 = ($14|0)==(0|0);
  if (!($15)) {
   _free($14);
  }
  _memset(($os|0),0,360)|0;
  $$0 = -1;
  return ($$0|0);
 }
 $16 = (($1) + ($needed))|0;
 $17 = ($16|0)<(2147483615);
 $18 = (($16) + 32)|0;
 $$ = $17 ? $18 : $16;
 $19 = ((($os)) + 16|0);
 $20 = HEAP32[$19>>2]|0;
 $21 = $$ << 2;
 $22 = (_realloc($20,$21)|0);
 $23 = ($22|0)==(0|0);
 if ($23) {
  $24 = HEAP32[$os>>2]|0;
  $25 = ($24|0)==(0|0);
  if (!($25)) {
   _free($24);
  }
  $26 = HEAP32[$19>>2]|0;
  $27 = ($26|0)==(0|0);
  if (!($27)) {
   _free($26);
  }
  $28 = ((($os)) + 20|0);
  $29 = HEAP32[$28>>2]|0;
  $30 = ($29|0)==(0|0);
  if (!($30)) {
   _free($29);
  }
  _memset(($os|0),0,360)|0;
  $$0 = -1;
  return ($$0|0);
 }
 HEAP32[$19>>2] = $22;
 $31 = ((($os)) + 20|0);
 $32 = HEAP32[$31>>2]|0;
 $33 = $$ << 3;
 $34 = (_realloc($32,$33)|0);
 $35 = ($34|0)==(0|0);
 if (!($35)) {
  HEAP32[$31>>2] = $34;
  HEAP32[$0>>2] = $$;
  $$0 = 0;
  return ($$0|0);
 }
 $36 = HEAP32[$os>>2]|0;
 $37 = ($36|0)==(0|0);
 if (!($37)) {
  _free($36);
 }
 $38 = HEAP32[$19>>2]|0;
 $39 = ($38|0)==(0|0);
 if (!($39)) {
  _free($38);
 }
 $40 = HEAP32[$31>>2]|0;
 $41 = ($40|0)==(0|0);
 if (!($41)) {
  _free($40);
 }
 _memset(($os|0),0,360)|0;
 $$0 = -1;
 return ($$0|0);
}
function _ogg_stream_flush_i($os,$og,$force,$nfill) {
 $os = $os|0;
 $og = $og|0;
 $force = $force|0;
 $nfill = $nfill|0;
 var $$ = 0, $$0 = 0, $$02 = 0, $$1 = 0, $$157 = 0, $$158 = 0, $$lcssa = 0, $$lobit = 0, $$pre = 0, $$pre38 = 0, $$pre39 = 0, $$pre40 = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0;
 var $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0;
 var $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0;
 var $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0;
 var $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0;
 var $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0;
 var $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0;
 var $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0;
 var $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $acc$018 = 0, $bytes$0$lcssa = 0, $exitcond = 0, $exitcond160 = 0, $granule_pos$0$lcssa$off0 = 0, $granule_pos$0$lcssa$off16 = 0, $granule_pos$0$lcssa$off24 = 0, $granule_pos$0$lcssa$off32 = 0, $granule_pos$0$lcssa$off40 = 0, $granule_pos$0$lcssa$off48 = 0, $granule_pos$0$lcssa$off56 = 0, $granule_pos$0$lcssa$off8 = 0, $granule_pos$019$off0 = 0, $granule_pos$019$off16 = 0, $granule_pos$019$off24 = 0;
 var $granule_pos$019$off32 = 0, $granule_pos$019$off40 = 0, $granule_pos$019$off48 = 0, $granule_pos$019$off56 = 0, $granule_pos$019$off8 = 0, $granule_pos$1$off0 = 0, $granule_pos$1$off16 = 0, $granule_pos$1$off24 = 0, $granule_pos$1$off32 = 0, $granule_pos$1$off40 = 0, $granule_pos$1$off48 = 0, $granule_pos$1$off56 = 0, $granule_pos$1$off8 = 0, $granule_pos$2$off0 = 0, $granule_pos$2$off16 = 0, $granule_pos$2$off24 = 0, $granule_pos$2$off32 = 0, $granule_pos$2$off40 = 0, $granule_pos$2$off48 = 0, $granule_pos$2$off56 = 0;
 var $granule_pos$2$off8 = 0, $granule_pos$27$off0 = 0, $granule_pos$27$off16 = 0, $granule_pos$27$off24 = 0, $granule_pos$27$off32 = 0, $granule_pos$27$off40 = 0, $granule_pos$27$off48 = 0, $granule_pos$27$off56 = 0, $granule_pos$27$off8 = 0, $or$cond = 0, $or$cond159 = 0, $or$cond4 = 0, $packet_just_done$021 = 0, $packet_just_done$1 = 0, $packets_done$020 = 0, $packets_done$1 = 0, $storemerge = 0, $vals$0 = 0, $vals$1$lcssa = 0, $vals$117 = 0;
 var $vals$2 = 0, $vals$26 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($os)) + 28|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ($1|0)>(255);
 $$ = $2 ? 255 : $1;
 $3 = ($os|0)==(0|0);
 if ($3) {
  $$0 = 0;
  return ($$0|0);
 }
 $4 = HEAP32[$os>>2]|0;
 $5 = ($4|0)==(0|0);
 $6 = ($$|0)==(0);
 $or$cond4 = $6 | $5;
 if ($or$cond4) {
  $$0 = 0;
  return ($$0|0);
 }
 $7 = ((($os)) + 332|0);
 $8 = HEAP32[$7>>2]|0;
 $9 = ($8|0)==(0);
 L7: do {
  if ($9) {
   $13 = ((($os)) + 16|0);
   $vals$0 = 0;
   while(1) {
    $14 = ($vals$0|0)<($$|0);
    if (!($14)) {
     $$1 = $force;$granule_pos$2$off0 = 0;$granule_pos$2$off16 = 0;$granule_pos$2$off24 = 0;$granule_pos$2$off32 = 0;$granule_pos$2$off40 = 0;$granule_pos$2$off48 = 0;$granule_pos$2$off56 = 0;$granule_pos$2$off8 = 0;$vals$2 = $vals$0;
     label = 14;
     break L7;
    }
    $15 = HEAP32[$13>>2]|0;
    $16 = (($15) + ($vals$0<<2)|0);
    $17 = HEAP32[$16>>2]|0;
    $18 = $17 & 255;
    $19 = ($18|0)==(255);
    $20 = (($vals$0) + 1)|0;
    if ($19) {
     $vals$0 = $20;
    } else {
     $$1 = $force;$granule_pos$2$off0 = 0;$granule_pos$2$off16 = 0;$granule_pos$2$off24 = 0;$granule_pos$2$off32 = 0;$granule_pos$2$off40 = 0;$granule_pos$2$off48 = 0;$granule_pos$2$off56 = 0;$granule_pos$2$off8 = 0;$vals$2 = $20;
     label = 14;
     break;
    }
   }
  } else {
   $10 = ($$|0)>(0);
   if ($10) {
    $11 = ((($os)) + 16|0);
    $12 = ((($os)) + 20|0);
    $acc$018 = 0;$granule_pos$019$off0 = -1;$granule_pos$019$off16 = -1;$granule_pos$019$off24 = -1;$granule_pos$019$off32 = -1;$granule_pos$019$off40 = -1;$granule_pos$019$off48 = -1;$granule_pos$019$off56 = -1;$granule_pos$019$off8 = -1;$packet_just_done$021 = 0;$packets_done$020 = 0;$vals$117 = 0;
    while(1) {
     $21 = ($acc$018|0)>($nfill|0);
     $22 = ($packet_just_done$021|0)>(3);
     $or$cond = $21 & $22;
     if ($or$cond) {
      $$02 = 1;$granule_pos$0$lcssa$off0 = $granule_pos$019$off0;$granule_pos$0$lcssa$off16 = $granule_pos$019$off16;$granule_pos$0$lcssa$off24 = $granule_pos$019$off24;$granule_pos$0$lcssa$off32 = $granule_pos$019$off32;$granule_pos$0$lcssa$off40 = $granule_pos$019$off40;$granule_pos$0$lcssa$off48 = $granule_pos$019$off48;$granule_pos$0$lcssa$off56 = $granule_pos$019$off56;$granule_pos$0$lcssa$off8 = $granule_pos$019$off8;$vals$1$lcssa = $vals$117;
      break;
     }
     $23 = HEAP32[$11>>2]|0;
     $24 = (($23) + ($vals$117<<2)|0);
     $25 = HEAP32[$24>>2]|0;
     $26 = $25 & 255;
     $27 = (($26) + ($acc$018))|0;
     $28 = ($26|0)==(255);
     if ($28) {
      $granule_pos$1$off0 = $granule_pos$019$off0;$granule_pos$1$off16 = $granule_pos$019$off16;$granule_pos$1$off24 = $granule_pos$019$off24;$granule_pos$1$off32 = $granule_pos$019$off32;$granule_pos$1$off40 = $granule_pos$019$off40;$granule_pos$1$off48 = $granule_pos$019$off48;$granule_pos$1$off56 = $granule_pos$019$off56;$granule_pos$1$off8 = $granule_pos$019$off8;$packet_just_done$1 = 0;$packets_done$1 = $packets_done$020;
     } else {
      $29 = HEAP32[$12>>2]|0;
      $30 = (($29) + ($vals$117<<3)|0);
      $31 = $30;
      $32 = $31;
      $33 = HEAP32[$32>>2]|0;
      $34 = (($31) + 4)|0;
      $35 = $34;
      $36 = HEAP32[$35>>2]|0;
      $37 = (($packets_done$020) + 1)|0;
      $38 = $33&255;
      $39 = (_bitshift64Lshr(($33|0),($36|0),8)|0);
      $40 = tempRet0;
      $41 = $39&255;
      $42 = (_bitshift64Lshr(($33|0),($36|0),16)|0);
      $43 = tempRet0;
      $44 = $42&255;
      $45 = (_bitshift64Lshr(($33|0),($36|0),24)|0);
      $46 = tempRet0;
      $47 = $45&255;
      $48 = $36&255;
      $49 = (_bitshift64Lshr(($33|0),($36|0),40)|0);
      $50 = tempRet0;
      $51 = $49&255;
      $52 = (_bitshift64Lshr(($33|0),($36|0),48)|0);
      $53 = tempRet0;
      $54 = $52&255;
      $55 = (_bitshift64Lshr(($33|0),($36|0),56)|0);
      $56 = tempRet0;
      $57 = $55&255;
      $granule_pos$1$off0 = $38;$granule_pos$1$off16 = $44;$granule_pos$1$off24 = $47;$granule_pos$1$off32 = $48;$granule_pos$1$off40 = $51;$granule_pos$1$off48 = $54;$granule_pos$1$off56 = $57;$granule_pos$1$off8 = $41;$packet_just_done$1 = $37;$packets_done$1 = $37;
     }
     $58 = (($vals$117) + 1)|0;
     $59 = ($58|0)<($$|0);
     if ($59) {
      $acc$018 = $27;$granule_pos$019$off0 = $granule_pos$1$off0;$granule_pos$019$off16 = $granule_pos$1$off16;$granule_pos$019$off24 = $granule_pos$1$off24;$granule_pos$019$off32 = $granule_pos$1$off32;$granule_pos$019$off40 = $granule_pos$1$off40;$granule_pos$019$off48 = $granule_pos$1$off48;$granule_pos$019$off56 = $granule_pos$1$off56;$granule_pos$019$off8 = $granule_pos$1$off8;$packet_just_done$021 = $packet_just_done$1;$packets_done$020 = $packets_done$1;$vals$117 = $58;
     } else {
      $$02 = $force;$granule_pos$0$lcssa$off0 = $granule_pos$1$off0;$granule_pos$0$lcssa$off16 = $granule_pos$1$off16;$granule_pos$0$lcssa$off24 = $granule_pos$1$off24;$granule_pos$0$lcssa$off32 = $granule_pos$1$off32;$granule_pos$0$lcssa$off40 = $granule_pos$1$off40;$granule_pos$0$lcssa$off48 = $granule_pos$1$off48;$granule_pos$0$lcssa$off56 = $granule_pos$1$off56;$granule_pos$0$lcssa$off8 = $granule_pos$1$off8;$vals$1$lcssa = $58;
      break;
     }
    }
    $60 = ($vals$1$lcssa|0)==(255);
    if ($60) {
     $granule_pos$27$off0 = $granule_pos$0$lcssa$off0;$granule_pos$27$off16 = $granule_pos$0$lcssa$off16;$granule_pos$27$off24 = $granule_pos$0$lcssa$off24;$granule_pos$27$off32 = $granule_pos$0$lcssa$off32;$granule_pos$27$off40 = $granule_pos$0$lcssa$off40;$granule_pos$27$off48 = $granule_pos$0$lcssa$off48;$granule_pos$27$off56 = $granule_pos$0$lcssa$off56;$granule_pos$27$off8 = $granule_pos$0$lcssa$off8;$vals$26 = 255;
    } else {
     $$1 = $$02;$granule_pos$2$off0 = $granule_pos$0$lcssa$off0;$granule_pos$2$off16 = $granule_pos$0$lcssa$off16;$granule_pos$2$off24 = $granule_pos$0$lcssa$off24;$granule_pos$2$off32 = $granule_pos$0$lcssa$off32;$granule_pos$2$off40 = $granule_pos$0$lcssa$off40;$granule_pos$2$off48 = $granule_pos$0$lcssa$off48;$granule_pos$2$off56 = $granule_pos$0$lcssa$off56;$granule_pos$2$off8 = $granule_pos$0$lcssa$off8;$vals$2 = $vals$1$lcssa;
     label = 14;
    }
   } else {
    $$1 = $force;$granule_pos$2$off0 = -1;$granule_pos$2$off16 = -1;$granule_pos$2$off24 = -1;$granule_pos$2$off32 = -1;$granule_pos$2$off40 = -1;$granule_pos$2$off48 = -1;$granule_pos$2$off56 = -1;$granule_pos$2$off8 = -1;$vals$2 = 0;
    label = 14;
   }
  }
 } while(0);
 if ((label|0) == 14) {
  $61 = ($$1|0)==(0);
  if ($61) {
   $$0 = 0;
   return ($$0|0);
  } else {
   $granule_pos$27$off0 = $granule_pos$2$off0;$granule_pos$27$off16 = $granule_pos$2$off16;$granule_pos$27$off24 = $granule_pos$2$off24;$granule_pos$27$off32 = $granule_pos$2$off32;$granule_pos$27$off40 = $granule_pos$2$off40;$granule_pos$27$off48 = $granule_pos$2$off48;$granule_pos$27$off56 = $granule_pos$2$off56;$granule_pos$27$off8 = $granule_pos$2$off8;$vals$26 = $vals$2;
  }
 }
 $62 = ((($os)) + 40|0);
 HEAP8[$62>>0]=1399285583&255;HEAP8[$62+1>>0]=(1399285583>>8)&255;HEAP8[$62+2>>0]=(1399285583>>16)&255;HEAP8[$62+3>>0]=1399285583>>24;
 $63 = ((($os)) + 44|0);
 HEAP8[$63>>0] = 0;
 $64 = ((($os)) + 45|0);
 HEAP8[$64>>0] = 0;
 $65 = ((($os)) + 16|0);
 $66 = HEAP32[$65>>2]|0;
 $67 = HEAP32[$66>>2]|0;
 $68 = $67 >>> 8;
 $$lobit = $68 & 1;
 $69 = $$lobit ^ 1;
 $70 = $69 | 2;
 $$157 = $9 ? $70 : $69;
 $storemerge = $$157&255;
 HEAP8[$64>>0] = $storemerge;
 $71 = ((($os)) + 328|0);
 $72 = HEAP32[$71>>2]|0;
 $73 = ($72|0)!=(0);
 $74 = ($1|0)==($vals$26|0);
 $or$cond159 = $73 & $74;
 if ($or$cond159) {
  $$158 = $9 ? $70 : $69;
  $75 = $$158 | 4;
  $76 = $75&255;
  HEAP8[$64>>0] = $76;
 }
 HEAP32[$7>>2] = 1;
 $77 = ((($os)) + 46|0);
 HEAP8[$77>>0] = $granule_pos$27$off0;
 $78 = ((($os)) + 47|0);
 HEAP8[$78>>0] = $granule_pos$27$off8;
 $79 = ((($os)) + 48|0);
 HEAP8[$79>>0] = $granule_pos$27$off16;
 $80 = ((($os)) + 49|0);
 HEAP8[$80>>0] = $granule_pos$27$off24;
 $81 = ((($os)) + 50|0);
 HEAP8[$81>>0] = $granule_pos$27$off32;
 $82 = ((($os)) + 51|0);
 HEAP8[$82>>0] = $granule_pos$27$off40;
 $83 = ((($os)) + 52|0);
 HEAP8[$83>>0] = $granule_pos$27$off48;
 $84 = ((($os)) + 53|0);
 HEAP8[$84>>0] = $granule_pos$27$off56;
 $85 = ((($os)) + 336|0);
 $86 = HEAP32[$85>>2]|0;
 $87 = $86&255;
 $88 = ((($os)) + 54|0);
 HEAP8[$88>>0] = $87;
 $89 = $86 >>> 8;
 $90 = $89&255;
 $91 = ((($os)) + 55|0);
 HEAP8[$91>>0] = $90;
 $92 = $86 >>> 16;
 $93 = $92&255;
 $94 = ((($os)) + 56|0);
 HEAP8[$94>>0] = $93;
 $95 = $86 >>> 24;
 $96 = $95&255;
 $97 = ((($os)) + 57|0);
 HEAP8[$97>>0] = $96;
 $98 = ((($os)) + 340|0);
 $99 = HEAP32[$98>>2]|0;
 $100 = ($99|0)==(-1);
 if ($100) {
  HEAP32[$98>>2] = 0;
  $102 = 0;
 } else {
  $102 = $99;
 }
 $101 = (($102) + 1)|0;
 HEAP32[$98>>2] = $101;
 $103 = $102&255;
 $104 = ((($os)) + 58|0);
 HEAP8[$104>>0] = $103;
 $105 = $102 >>> 8;
 $106 = $105&255;
 $107 = ((($os)) + 59|0);
 HEAP8[$107>>0] = $106;
 $108 = $102 >>> 16;
 $109 = $108&255;
 $110 = ((($os)) + 60|0);
 HEAP8[$110>>0] = $109;
 $111 = $102 >>> 24;
 $112 = $111&255;
 $113 = ((($os)) + 61|0);
 HEAP8[$113>>0] = $112;
 $114 = ((($os)) + 62|0);
 $115 = $vals$26&255;
 $116 = ((($os)) + 66|0);
 HEAP8[$114>>0]=0&255;HEAP8[$114+1>>0]=(0>>8)&255;HEAP8[$114+2>>0]=(0>>16)&255;HEAP8[$114+3>>0]=0>>24;
 HEAP8[$116>>0] = $115;
 $117 = ($vals$26|0)>(0);
 if ($117) {
  $118 = HEAP32[$66>>2]|0;
  $119 = $118&255;
  $120 = ((($os)) + 67|0);
  HEAP8[$120>>0] = $119;
  $121 = $118 & 255;
  $exitcond160 = ($vals$26|0)==(1);
  if ($exitcond160) {
   $$lcssa = $121;
  } else {
   $123 = 1;$130 = $121;
   while(1) {
    $$pre = HEAP32[$65>>2]|0;
    $122 = (($$pre) + ($123<<2)|0);
    $124 = HEAP32[$122>>2]|0;
    $125 = $124&255;
    $126 = (($123) + 27)|0;
    $127 = (((($os)) + 40|0) + ($126)|0);
    HEAP8[$127>>0] = $125;
    $128 = $124 & 255;
    $129 = (($128) + ($130))|0;
    $131 = (($123) + 1)|0;
    $exitcond = ($131|0)==($vals$26|0);
    if ($exitcond) {
     $$lcssa = $129;
     break;
    } else {
     $123 = $131;$130 = $129;
    }
   }
  }
  $$pre38 = HEAP32[$os>>2]|0;
  $$pre39 = HEAP32[$0>>2]|0;
  $$pre40 = HEAP32[$65>>2]|0;
  $138 = $$pre38;$142 = $$pre39;$144 = $$pre40;$bytes$0$lcssa = $$lcssa;
 } else {
  $138 = $4;$142 = $1;$144 = $66;$bytes$0$lcssa = 0;
 }
 HEAP32[$og>>2] = $62;
 $132 = (($vals$26) + 27)|0;
 $133 = ((($os)) + 324|0);
 HEAP32[$133>>2] = $132;
 $134 = ((($og)) + 4|0);
 HEAP32[$134>>2] = $132;
 $135 = ((($os)) + 12|0);
 $136 = HEAP32[$135>>2]|0;
 $137 = (($138) + ($136)|0);
 $139 = ((($og)) + 8|0);
 HEAP32[$139>>2] = $137;
 $140 = ((($og)) + 12|0);
 HEAP32[$140>>2] = $bytes$0$lcssa;
 $141 = (($142) - ($vals$26))|0;
 HEAP32[$0>>2] = $141;
 $143 = (($144) + ($vals$26<<2)|0);
 $145 = $141 << 2;
 _memmove(($144|0),($143|0),($145|0))|0;
 $146 = ((($os)) + 20|0);
 $147 = HEAP32[$146>>2]|0;
 $148 = (($147) + ($vals$26<<3)|0);
 $149 = HEAP32[$0>>2]|0;
 $150 = $149 << 3;
 _memmove(($147|0),($148|0),($150|0))|0;
 $151 = HEAP32[$135>>2]|0;
 $152 = (($151) + ($bytes$0$lcssa))|0;
 HEAP32[$135>>2] = $152;
 _ogg_page_checksum_set($og);
 $$0 = 1;
 return ($$0|0);
}
function _vorbis_analysis($vb,$op) {
 $vb = $vb|0;
 $op = $op|0;
 var $$0 = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0;
 var $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0;
 var $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0;
 var $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($vb)) + 104|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($vb)) + 88|0);
 $3 = ((($1)) + 12|0);
 ;HEAP32[$2>>2]=0|0;HEAP32[$2+4>>2]=0|0;HEAP32[$2+8>>2]=0|0;HEAP32[$2+12>>2]=0|0;
 $4 = HEAP32[$3>>2]|0;
 _oggpack_reset($4);
 $5 = ((($1)) + 16|0);
 $6 = HEAP32[$5>>2]|0;
 _oggpack_reset($6);
 $7 = ((($1)) + 20|0);
 $8 = HEAP32[$7>>2]|0;
 _oggpack_reset($8);
 $9 = ((($1)) + 24|0);
 $10 = HEAP32[$9>>2]|0;
 _oggpack_reset($10);
 $11 = ((($1)) + 28|0);
 $12 = HEAP32[$11>>2]|0;
 _oggpack_reset($12);
 $13 = ((($1)) + 32|0);
 $14 = HEAP32[$13>>2]|0;
 _oggpack_reset($14);
 $15 = ((($1)) + 36|0);
 $16 = HEAP32[$15>>2]|0;
 _oggpack_reset($16);
 $17 = ((($1)) + 40|0);
 $18 = HEAP32[$17>>2]|0;
 _oggpack_reset($18);
 $19 = ((($1)) + 44|0);
 $20 = HEAP32[$19>>2]|0;
 _oggpack_reset($20);
 $21 = ((($1)) + 48|0);
 $22 = HEAP32[$21>>2]|0;
 _oggpack_reset($22);
 $23 = ((($1)) + 52|0);
 $24 = HEAP32[$23>>2]|0;
 _oggpack_reset($24);
 $25 = ((($1)) + 56|0);
 $26 = HEAP32[$25>>2]|0;
 _oggpack_reset($26);
 $27 = ((($1)) + 60|0);
 $28 = HEAP32[$27>>2]|0;
 _oggpack_reset($28);
 $29 = ((($1)) + 64|0);
 $30 = HEAP32[$29>>2]|0;
 _oggpack_reset($30);
 $31 = ((($1)) + 68|0);
 $32 = HEAP32[$31>>2]|0;
 _oggpack_reset($32);
 $33 = HEAP32[25664>>2]|0;
 $34 = ((($33)) + 12|0);
 $35 = HEAP32[$34>>2]|0;
 $36 = (FUNCTION_TABLE_ii[$35 & 1]($vb)|0);
 $37 = ($36|0)==(0);
 if (!($37)) {
  $$0 = $36;
  return ($$0|0);
 }
 $38 = ($op|0)==(0|0);
 if ($38) {
  $$0 = 0;
  return ($$0|0);
 }
 $39 = (_vorbis_bitrate_managed($vb)|0);
 $40 = ($39|0)==(0);
 if (!($40)) {
  $$0 = -131;
  return ($$0|0);
 }
 $41 = ((($vb)) + 4|0);
 $42 = (_oggpack_get_buffer($41)|0);
 HEAP32[$op>>2] = $42;
 $43 = (_oggpack_bytes($41)|0);
 $44 = ((($op)) + 4|0);
 HEAP32[$44>>2] = $43;
 $45 = ((($op)) + 8|0);
 HEAP32[$45>>2] = 0;
 $46 = ((($vb)) + 44|0);
 $47 = HEAP32[$46>>2]|0;
 $48 = ((($op)) + 12|0);
 HEAP32[$48>>2] = $47;
 $49 = ((($vb)) + 48|0);
 $50 = $49;
 $51 = $50;
 $52 = HEAP32[$51>>2]|0;
 $53 = (($50) + 4)|0;
 $54 = $53;
 $55 = HEAP32[$54>>2]|0;
 $56 = ((($op)) + 16|0);
 $57 = $56;
 $58 = $57;
 HEAP32[$58>>2] = $52;
 $59 = (($57) + 4)|0;
 $60 = $59;
 HEAP32[$60>>2] = $55;
 $61 = ((($vb)) + 56|0);
 $62 = $61;
 $63 = $62;
 $64 = HEAP32[$63>>2]|0;
 $65 = (($62) + 4)|0;
 $66 = $65;
 $67 = HEAP32[$66>>2]|0;
 $68 = ((($op)) + 24|0);
 $69 = $68;
 $70 = $69;
 HEAP32[$70>>2] = $64;
 $71 = (($69) + 4)|0;
 $72 = $71;
 HEAP32[$72>>2] = $67;
 $$0 = 0;
 return ($$0|0);
}
function _vorbis_bitrate_init($vi,$bm) {
 $vi = $vi|0;
 $bm = $bm|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0.0, $16 = 0.0, $17 = 0.0, $18 = 0.0, $19 = 0.0, $2 = 0, $20 = 0.0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0.0, $26 = 0.0;
 var $27 = 0.0, $28 = 0.0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0.0, $34 = 0.0, $35 = 0.0, $36 = 0.0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0.0, $41 = 0, $42 = 0.0, $43 = 0.0, $44 = 0;
 var $45 = 0, $46 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, dest = 0, label = 0, sp = 0, stop = 0;
 sp = STACKTOP;
 $0 = ((($vi)) + 28|0);
 $1 = HEAP32[$0>>2]|0;
 dest=$bm; stop=dest+48|0; do { HEAP32[dest>>2]=0|0; dest=dest+4|0; } while ((dest|0) < (stop|0));
 $2 = ((($1)) + 3372|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ($3|0)>(0);
 if (!($4)) {
  return;
 }
 $5 = ((($vi)) + 8|0);
 $6 = HEAP32[$5>>2]|0;
 $7 = HEAP32[$1>>2]|0;
 $8 = $7 >> 1;
 $9 = ((($1)) + 4|0);
 $10 = HEAP32[$9>>2]|0;
 $11 = (($10|0) / ($7|0))&-1;
 $12 = ((($bm)) + 24|0);
 HEAP32[$12>>2] = $11;
 HEAP32[$bm>>2] = 1;
 $13 = ((($1)) + 3360|0);
 $14 = HEAP32[$13>>2]|0;
 $15 = (+($14|0));
 $16 = (+($8|0));
 $17 = $15 * $16;
 $18 = (+($6|0));
 $19 = $17 / $18;
 $20 = (+_rint($19));
 $21 = (~~(($20)));
 $22 = ((($bm)) + 12|0);
 HEAP32[$22>>2] = $21;
 $23 = ((($1)) + 3364|0);
 $24 = HEAP32[$23>>2]|0;
 $25 = (+($24|0));
 $26 = $25 * $16;
 $27 = $26 / $18;
 $28 = (+_rint($27));
 $29 = (~~(($28)));
 $30 = ((($bm)) + 16|0);
 HEAP32[$30>>2] = $29;
 $31 = ((($1)) + 3368|0);
 $32 = HEAP32[$31>>2]|0;
 $33 = (+($32|0));
 $34 = $33 * $16;
 $35 = $34 / $18;
 $36 = (+_rint($35));
 $37 = (~~(($36)));
 $38 = ((($bm)) + 20|0);
 HEAP32[$38>>2] = $37;
 $39 = ((($bm)) + 32|0);
 HEAPF64[$39>>3] = 7.0;
 $40 = (+($3|0));
 $41 = ((($1)) + 3376|0);
 $42 = +HEAPF64[$41>>3];
 $43 = $40 * $42;
 $44 = (~~(($43)));
 $45 = ((($bm)) + 8|0);
 HEAP32[$45>>2] = $44;
 $46 = ((($bm)) + 4|0);
 HEAP32[$46>>2] = $44;
 return;
}
function _vorbis_bitrate_clear($bm) {
 $bm = $bm|0;
 var dest = 0, label = 0, sp = 0, stop = 0;
 sp = STACKTOP;
 dest=$bm; stop=dest+48|0; do { HEAP32[dest>>2]=0|0; dest=dest+4|0; } while ((dest|0) < (stop|0));
 return;
}
function _vorbis_bitrate_managed($vb) {
 $vb = $vb|0;
 var $$0 = 0, $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $not$ = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($vb)) + 64|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 104|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ((($3)) + 80|0);
 $5 = HEAP32[$4>>2]|0;
 $not$ = ($5|0)!=(0);
 $$0 = $not$&1;
 return ($$0|0);
}
function _vorbis_bitrate_addblock($vb) {
 $vb = $vb|0;
 var $$ = 0, $$0 = 0, $$9 = 0, $$choice$7 = 0, $$lcssa = 0, $$pre = 0, $$pre68 = 0, $$pre69 = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0.0, $101 = 0, $102 = 0, $103 = 0.0, $104 = 0.0, $105 = 0.0, $106 = 0, $107 = 0, $108 = 0.0;
 var $109 = 0.0, $11 = 0.0, $110 = 0.0, $111 = 0.0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0.0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0;
 var $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0;
 var $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0;
 var $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0;
 var $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0, $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0;
 var $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0, $206 = 0, $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0;
 var $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0, $224 = 0, $225 = 0, $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0.0, $37 = 0, $38 = 0.0, $39 = 0.0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0;
 var $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0.0, $55 = 0.0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0;
 var $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0;
 var $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0.0, $96 = 0.0, $97 = 0.0, $98 = 0.0, $99 = 0.0, $choice$03980 = 0;
 var $choice$2 = 0, $choice$3 = 0, $choice$430 = 0, $choice$5 = 0, $choice$622 = 0, $choice$7 = 0, $minsize$020 = 0, $or$cond = 0, $or$cond37 = 0, $or$cond4 = 0, $or$cond444 = 0, $or$cond5 = 0, $or$cond6 = 0, $or$cond7 = 0, $or$cond8 = 0, $slew$0 = 0.0, $slew$1 = 0.0, $this_bits$2 = 0, $this_bits$329 = 0, $this_bits$4 = 0;
 var $this_bits$521 = 0, $this_bits$6 = 0, $this_bits$7 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($vb)) + 104|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($vb)) + 64|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ((($3)) + 104|0);
 $5 = HEAP32[$4>>2]|0;
 $6 = ((($3)) + 4|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = ((($7)) + 28|0);
 $9 = HEAP32[$8>>2]|0;
 $10 = ((($5)) + 112|0);
 $11 = +HEAPF64[$10>>3];
 $12 = (+_rint($11));
 $13 = (~~(($12)));
 $14 = (((($1)) + 12|0) + ($13<<2)|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = (_oggpack_bytes($15)|0);
 $17 = $16 << 3;
 $18 = ((($vb)) + 28|0);
 $19 = HEAP32[$18>>2]|0;
 $20 = ($19|0)==(0);
 $21 = ((($5)) + 96|0);
 $22 = HEAP32[$21>>2]|0;
 if ($20) {
  $23 = ((($5)) + 100|0);
  $24 = HEAP32[$23>>2]|0;
  $120 = $22;$137 = $23;$140 = $24;
 } else {
  $25 = ((($5)) + 104|0);
  $26 = HEAP32[$25>>2]|0;
  $27 = ((($5)) + 100|0);
  $28 = HEAP32[$27>>2]|0;
  $29 = Math_imul($26, $22)|0;
  $30 = Math_imul($26, $28)|0;
  $120 = $29;$137 = $27;$140 = $30;
 }
 $31 = (($9) + ($19<<2)|0);
 $32 = HEAP32[$31>>2]|0;
 $33 = $32 >> 1;
 $34 = ((($9)) + 3372|0);
 $35 = HEAP32[$34>>2]|0;
 $36 = (+($35|0));
 $37 = ((($9)) + 3376|0);
 $38 = +HEAPF64[$37>>3];
 $39 = $36 * $38;
 $40 = (~~(($39)));
 $41 = ((($5)) + 80|0);
 $42 = HEAP32[$41>>2]|0;
 $43 = ($42|0)==(0);
 $44 = ((($5)) + 120|0);
 if ($43) {
  $45 = HEAP32[$44>>2]|0;
  $46 = ($45|0)==(0|0);
  if (!($46)) {
   $$0 = -1;
   return ($$0|0);
  }
  HEAP32[$44>>2] = $vb;
  $$0 = 0;
  return ($$0|0);
 }
 HEAP32[$44>>2] = $vb;
 $47 = ((($5)) + 92|0);
 $48 = HEAP32[$47>>2]|0;
 $49 = ($48|0)>(0);
 if ($49) {
  if ($20) {
   $59 = $48;
  } else {
   $50 = ((($5)) + 104|0);
   $51 = HEAP32[$50>>2]|0;
   $52 = Math_imul($51, $48)|0;
   $59 = $52;
  }
  $53 = ((($9)) + 3384|0);
  $54 = +HEAPF64[$53>>3];
  $55 = 15.0 / $54;
  $56 = ((($5)) + 84|0);
  $57 = HEAP32[$56>>2]|0;
  $58 = (($17) - ($59))|0;
  $60 = (($57) + ($58))|0;
  $61 = ($60|0)>($40|0);
  L17: do {
   if ($61) {
    $62 = ($13|0)>(0);
    $63 = ($17|0)>($59|0);
    $or$cond37 = $63 & $62;
    if ($or$cond37) {
     $64 = (($17) - ($59))|0;
     $65 = (($64) + ($57))|0;
     $66 = ($65|0)>($40|0);
     if ($66) {
      $choice$03980 = $13;
      while(1) {
       $67 = (($choice$03980) + -1)|0;
       $68 = (((($1)) + 12|0) + ($67<<2)|0);
       $69 = HEAP32[$68>>2]|0;
       $70 = (_oggpack_bytes($69)|0);
       $71 = $70 << 3;
       $72 = ($choice$03980|0)>(1);
       $73 = ($71|0)>($59|0);
       $or$cond = $73 & $72;
       if (!($or$cond)) {
        $choice$2 = $67;
        break L17;
       }
       $$pre68 = HEAP32[$56>>2]|0;
       $74 = (($71) - ($59))|0;
       $75 = (($74) + ($$pre68))|0;
       $76 = ($75|0)>($40|0);
       if ($76) {
        $choice$03980 = $67;
       } else {
        $choice$2 = $67;
        break;
       }
      }
     } else {
      $choice$2 = $13;
     }
    } else {
     $choice$2 = $13;
    }
   } else {
    $77 = ($60|0)<($40|0);
    if ($77) {
     $78 = (($13) + 1)|0;
     $79 = ($78|0)<(15);
     $80 = ($17|0)<($59|0);
     $or$cond444 = $80 & $79;
     if ($or$cond444) {
      $81 = (($17) - ($59))|0;
      $82 = (($81) + ($57))|0;
      $83 = ($82|0)<($40|0);
      if ($83) {
       $85 = $78;
       while(1) {
        $84 = (((($1)) + 12|0) + ($85<<2)|0);
        $86 = HEAP32[$84>>2]|0;
        $87 = (_oggpack_bytes($86)|0);
        $88 = $87 << 3;
        $89 = (($85) + 1)|0;
        $90 = ($89|0)<(15);
        $91 = ($88|0)<($59|0);
        $or$cond4 = $91 & $90;
        if (!($or$cond4)) {
         $choice$2 = $85;
         break L17;
        }
        $$pre = HEAP32[$56>>2]|0;
        $92 = (($88) - ($59))|0;
        $93 = (($92) + ($$pre))|0;
        $94 = ($93|0)<($40|0);
        if ($94) {
         $85 = $89;
        } else {
         $choice$2 = $85;
         break;
        }
       }
      } else {
       $choice$2 = $13;
      }
     } else {
      $choice$2 = $13;
     }
    } else {
     $choice$2 = $13;
    }
   }
  } while(0);
  $95 = (+($choice$2|0));
  $96 = +HEAPF64[$10>>3];
  $97 = $95 - $96;
  $98 = (+_rint($97));
  $99 = (+($33|0));
  $100 = $98 / $99;
  $101 = ((($7)) + 8|0);
  $102 = HEAP32[$101>>2]|0;
  $103 = (+($102|0));
  $104 = $103 * $100;
  $105 = -$55;
  $106 = $104 < $105;
  $slew$0 = $106 ? $105 : $104;
  $107 = $slew$0 > $55;
  $slew$1 = $107 ? $55 : $slew$0;
  $108 = $slew$1 / $103;
  $109 = $108 * $99;
  $110 = $109 + $96;
  HEAPF64[$10>>3] = $110;
  $111 = (+_rint($110));
  $112 = (~~(($111)));
  $113 = (((($1)) + 12|0) + ($112<<2)|0);
  $114 = HEAP32[$113>>2]|0;
  $115 = (_oggpack_bytes($114)|0);
  $116 = $115 << 3;
  $$pre69 = HEAP32[$21>>2]|0;
  $117 = $$pre69;$choice$3 = $112;$this_bits$2 = $116;
 } else {
  $117 = $22;$choice$3 = $13;$this_bits$2 = $17;
 }
 $118 = ($117|0)>(0);
 $119 = ($this_bits$2|0)<($120|0);
 $or$cond5 = $119 & $118;
 L31: do {
  if ($or$cond5) {
   $121 = ((($5)) + 88|0);
   $122 = HEAP32[$121>>2]|0;
   $123 = (($this_bits$2) - ($120))|0;
   $124 = (($123) + ($122))|0;
   $125 = ($124|0)<(0);
   if ($125) {
    $choice$430 = $choice$3;$this_bits$329 = $this_bits$2;
    while(1) {
     $126 = (($choice$430) + 1)|0;
     $127 = ($choice$430|0)>(13);
     if ($127) {
      $choice$5 = $126;$this_bits$4 = $this_bits$329;
      break L31;
     }
     $128 = (((($1)) + 12|0) + ($126<<2)|0);
     $129 = HEAP32[$128>>2]|0;
     $130 = (_oggpack_bytes($129)|0);
     $131 = $130 << 3;
     $132 = HEAP32[$121>>2]|0;
     $133 = (($131) - ($120))|0;
     $134 = (($133) + ($132))|0;
     $135 = ($134|0)<(0);
     if ($135) {
      $choice$430 = $126;$this_bits$329 = $131;
     } else {
      $choice$5 = $126;$this_bits$4 = $131;
      break;
     }
    }
   } else {
    $choice$5 = $choice$3;$this_bits$4 = $this_bits$2;
   }
  } else {
   $choice$5 = $choice$3;$this_bits$4 = $this_bits$2;
  }
 } while(0);
 $136 = HEAP32[$137>>2]|0;
 $138 = ($136|0)>(0);
 $139 = ($this_bits$4|0)>($140|0);
 $or$cond6 = $139 & $138;
 L37: do {
  if ($or$cond6) {
   $141 = ((($5)) + 88|0);
   $142 = HEAP32[$141>>2]|0;
   $143 = (($this_bits$4) - ($140))|0;
   $144 = (($143) + ($142))|0;
   $145 = HEAP32[$34>>2]|0;
   $146 = ($144|0)>($145|0);
   if ($146) {
    $choice$622 = $choice$5;$this_bits$521 = $this_bits$4;
    while(1) {
     $147 = (($choice$622) + -1)|0;
     $148 = ($choice$622|0)<(1);
     if ($148) {
      $choice$7 = $147;$this_bits$6 = $this_bits$521;
      break L37;
     }
     $149 = (((($1)) + 12|0) + ($147<<2)|0);
     $150 = HEAP32[$149>>2]|0;
     $151 = (_oggpack_bytes($150)|0);
     $152 = $151 << 3;
     $153 = HEAP32[$141>>2]|0;
     $154 = (($152) - ($140))|0;
     $155 = (($154) + ($153))|0;
     $156 = HEAP32[$34>>2]|0;
     $157 = ($155|0)>($156|0);
     if ($157) {
      $choice$622 = $147;$this_bits$521 = $152;
     } else {
      $choice$7 = $147;$this_bits$6 = $152;
      break;
     }
    }
   } else {
    $choice$7 = $choice$5;$this_bits$6 = $this_bits$4;
   }
  } else {
   $choice$7 = $choice$5;$this_bits$6 = $this_bits$4;
  }
 } while(0);
 $158 = ($choice$7|0)<(0);
 if ($158) {
  $159 = HEAP32[$34>>2]|0;
  $160 = ((($5)) + 88|0);
  $161 = HEAP32[$160>>2]|0;
  $162 = (($159) + ($140))|0;
  $163 = (($162) - ($161))|0;
  $164 = (($163|0) / 8)&-1;
  $165 = ((($5)) + 124|0);
  HEAP32[$165>>2] = 0;
  $166 = ((($1)) + 12|0);
  $167 = HEAP32[$166>>2]|0;
  $168 = (_oggpack_bytes($167)|0);
  $169 = ($168|0)>($164|0);
  if ($169) {
   $170 = HEAP32[$166>>2]|0;
   $171 = $164 << 3;
   _oggpack_writetrunc($170,$171);
   $172 = HEAP32[$166>>2]|0;
   $173 = (_oggpack_bytes($172)|0);
   $174 = $173 << 3;
   $this_bits$7 = $174;
  } else {
   $this_bits$7 = $this_bits$6;
  }
 } else {
  $175 = ((($5)) + 88|0);
  $176 = HEAP32[$175>>2]|0;
  $177 = (($120) + 7)|0;
  $178 = (($177) - ($176))|0;
  $179 = (($178|0) / 8)&-1;
  $180 = ($choice$7|0)>(14);
  $$choice$7 = $180 ? 14 : $choice$7;
  $181 = ((($5)) + 124|0);
  HEAP32[$181>>2] = $$choice$7;
  $182 = (((($1)) + 12|0) + ($$choice$7<<2)|0);
  $183 = HEAP32[$182>>2]|0;
  $184 = (_oggpack_bytes($183)|0);
  $185 = (($179) - ($184))|0;
  $186 = ($185|0)>(0);
  $187 = HEAP32[$182>>2]|0;
  if ($186) {
   $189 = $187;$minsize$020 = $185;
   while(1) {
    $188 = (($minsize$020) + -1)|0;
    _oggpack_write($189,0,8);
    $190 = ($minsize$020|0)>(1);
    $191 = HEAP32[$182>>2]|0;
    if ($190) {
     $189 = $191;$minsize$020 = $188;
    } else {
     $$lcssa = $191;
     break;
    }
   }
  } else {
   $$lcssa = $187;
  }
  $192 = (_oggpack_bytes($$lcssa)|0);
  $193 = $192 << 3;
  $this_bits$7 = $193;
 }
 $194 = HEAP32[$21>>2]|0;
 $195 = ($194|0)>(0);
 if ($195) {
  label = 37;
 } else {
  $196 = HEAP32[$137>>2]|0;
  $197 = ($196|0)>(0);
  if ($197) {
   label = 37;
  }
 }
 do {
  if ((label|0) == 37) {
   $198 = ($140|0)>(0);
   $199 = ($this_bits$7|0)>($140|0);
   $or$cond7 = $198 & $199;
   if ($or$cond7) {
    $200 = (($this_bits$7) - ($140))|0;
    $201 = ((($5)) + 88|0);
    $202 = HEAP32[$201>>2]|0;
    $203 = (($200) + ($202))|0;
    HEAP32[$201>>2] = $203;
    break;
   }
   $204 = ($120|0)>(0);
   $205 = ($this_bits$7|0)<($120|0);
   $or$cond8 = $204 & $205;
   if ($or$cond8) {
    $206 = (($this_bits$7) - ($120))|0;
    $207 = ((($5)) + 88|0);
    $208 = HEAP32[$207>>2]|0;
    $209 = (($206) + ($208))|0;
    HEAP32[$207>>2] = $209;
    break;
   }
   $210 = ((($5)) + 88|0);
   $211 = HEAP32[$210>>2]|0;
   $212 = ($211|0)>($40|0);
   if ($212) {
    if ($198) {
     $213 = (($this_bits$7) - ($140))|0;
     $214 = (($211) + ($213))|0;
     $215 = ($214|0)<($40|0);
     $$ = $215 ? $40 : $214;
     HEAP32[$210>>2] = $$;
     break;
    } else {
     HEAP32[$210>>2] = $40;
     break;
    }
   } else {
    if ($204) {
     $216 = (($this_bits$7) - ($120))|0;
     $217 = (($211) + ($216))|0;
     $218 = ($217|0)>($40|0);
     $$9 = $218 ? $40 : $217;
     HEAP32[$210>>2] = $$9;
     break;
    } else {
     HEAP32[$210>>2] = $40;
     break;
    }
   }
  }
 } while(0);
 $219 = HEAP32[$47>>2]|0;
 $220 = ($219|0)>(0);
 if (!($220)) {
  $$0 = 0;
  return ($$0|0);
 }
 $221 = HEAP32[$18>>2]|0;
 $222 = ($221|0)==(0);
 if ($222) {
  $227 = $219;
 } else {
  $223 = ((($5)) + 104|0);
  $224 = HEAP32[$223>>2]|0;
  $225 = Math_imul($224, $219)|0;
  $227 = $225;
 }
 $226 = (($this_bits$7) - ($227))|0;
 $228 = ((($5)) + 84|0);
 $229 = HEAP32[$228>>2]|0;
 $230 = (($226) + ($229))|0;
 HEAP32[$228>>2] = $230;
 $$0 = 0;
 return ($$0|0);
}
function _vorbis_bitrate_flushpacket($vd,$op) {
 $vd = $vd|0;
 $op = $op|0;
 var $$0 = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0;
 var $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0;
 var $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $choice$0 = 0, $not$$i = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($vd)) + 104|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 120|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ($3|0)==(0|0);
 if ($4) {
  $$0 = 0;
  return ($$0|0);
 }
 $5 = ($op|0)==(0|0);
 if (!($5)) {
  $6 = ((($3)) + 104|0);
  $7 = HEAP32[$6>>2]|0;
  $8 = ((($3)) + 64|0);
  $9 = HEAP32[$8>>2]|0;
  $10 = ((($9)) + 104|0);
  $11 = HEAP32[$10>>2]|0;
  $12 = ((($11)) + 80|0);
  $13 = HEAP32[$12>>2]|0;
  $not$$i = ($13|0)==(0);
  if ($not$$i) {
   $choice$0 = 7;
  } else {
   $14 = ((($1)) + 124|0);
   $15 = HEAP32[$14>>2]|0;
   $choice$0 = $15;
  }
  $16 = (((($7)) + 12|0) + ($choice$0<<2)|0);
  $17 = HEAP32[$16>>2]|0;
  $18 = (_oggpack_get_buffer($17)|0);
  HEAP32[$op>>2] = $18;
  $19 = HEAP32[$16>>2]|0;
  $20 = (_oggpack_bytes($19)|0);
  $21 = ((($op)) + 4|0);
  HEAP32[$21>>2] = $20;
  $22 = ((($op)) + 8|0);
  HEAP32[$22>>2] = 0;
  $23 = ((($3)) + 44|0);
  $24 = HEAP32[$23>>2]|0;
  $25 = ((($op)) + 12|0);
  HEAP32[$25>>2] = $24;
  $26 = ((($3)) + 48|0);
  $27 = $26;
  $28 = $27;
  $29 = HEAP32[$28>>2]|0;
  $30 = (($27) + 4)|0;
  $31 = $30;
  $32 = HEAP32[$31>>2]|0;
  $33 = ((($op)) + 16|0);
  $34 = $33;
  $35 = $34;
  HEAP32[$35>>2] = $29;
  $36 = (($34) + 4)|0;
  $37 = $36;
  HEAP32[$37>>2] = $32;
  $38 = ((($3)) + 56|0);
  $39 = $38;
  $40 = $39;
  $41 = HEAP32[$40>>2]|0;
  $42 = (($39) + 4)|0;
  $43 = $42;
  $44 = HEAP32[$43>>2]|0;
  $45 = ((($op)) + 24|0);
  $46 = $45;
  $47 = $46;
  HEAP32[$47>>2] = $41;
  $48 = (($46) + 4)|0;
  $49 = $48;
  HEAP32[$49>>2] = $44;
 }
 HEAP32[$2>>2] = 0;
 $$0 = 1;
 return ($$0|0);
}
function _vorbis_block_init($v,$vb) {
 $v = $v|0;
 $vb = $vb|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $exitcond = 0, $i$01 = 0, dest = 0, label = 0, sp = 0;
 var stop = 0;
 sp = STACKTOP;
 dest=$vb; stop=dest+112|0; do { HEAP32[dest>>2]=0|0; dest=dest+4|0; } while ((dest|0) < (stop|0));
 $0 = ((($vb)) + 64|0);
 HEAP32[$0>>2] = $v;
 $1 = ((($vb)) + 76|0);
 HEAP32[$1>>2] = 0;
 $2 = ((($vb)) + 68|0);
 HEAP32[$2>>2] = 0;
 $3 = HEAP32[$v>>2]|0;
 $4 = ($3|0)==(0);
 if ($4) {
  return 0;
 }
 $5 = (_calloc(1,72)|0);
 $6 = ((($vb)) + 104|0);
 HEAP32[$6>>2] = $5;
 $7 = ((($5)) + 4|0);
 HEAPF32[$7>>2] = -9999.0;
 $8 = ((($vb)) + 4|0);
 $9 = ((($5)) + 12|0);
 $10 = ((($5)) + 40|0);
 $i$01 = 0;
 while(1) {
  $11 = ($i$01|0)==(7);
  if ($11) {
   HEAP32[$10>>2] = $8;
   _oggpack_writeinit($8);
   $i$01 = 8;
   continue;
  } else {
   $12 = (_calloc(1,20)|0);
   $13 = (($9) + ($i$01<<2)|0);
   HEAP32[$13>>2] = $12;
   _oggpack_writeinit($12);
   $14 = (($i$01) + 1)|0;
   $exitcond = ($14|0)==(15);
   if ($exitcond) {
    break;
   } else {
    $i$01 = $14;
    continue;
   }
  }
 }
 return 0;
}
function __vorbis_block_alloc($vb,$bytes) {
 $vb = $vb|0;
 $bytes = $bytes|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $3 = 0, $4 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = (($bytes) + 7)|0;
 $1 = $0 & -8;
 $2 = ((($vb)) + 72|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = (($3) + ($1))|0;
 $5 = ((($vb)) + 76|0);
 $6 = HEAP32[$5>>2]|0;
 $7 = ($4|0)>($6|0);
 $8 = ((($vb)) + 68|0);
 $9 = HEAP32[$8>>2]|0;
 if (!($7)) {
  $21 = $9;$22 = $3;
  $20 = (($21) + ($22)|0);
  $23 = (($22) + ($1))|0;
  HEAP32[$2>>2] = $23;
  return ($20|0);
 }
 $10 = ($9|0)==(0|0);
 if (!($10)) {
  $11 = $9;
  $12 = (_malloc(8)|0);
  $13 = ((($vb)) + 80|0);
  $14 = HEAP32[$13>>2]|0;
  $15 = (($14) + ($3))|0;
  HEAP32[$13>>2] = $15;
  $16 = ((($vb)) + 84|0);
  $17 = HEAP32[$16>>2]|0;
  $18 = ((($12)) + 4|0);
  HEAP32[$18>>2] = $17;
  HEAP32[$12>>2] = $11;
  HEAP32[$16>>2] = $12;
 }
 HEAP32[$5>>2] = $1;
 $19 = (_malloc($1)|0);
 HEAP32[$8>>2] = $19;
 HEAP32[$2>>2] = 0;
 $21 = $19;$22 = 0;
 $20 = (($21) + ($22)|0);
 $23 = (($22) + ($1))|0;
 HEAP32[$2>>2] = $23;
 return ($20|0);
}
function _vorbis_block_clear($vb) {
 $vb = $vb|0;
 var $$phi$trans$insert = 0, $$pre = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0;
 var $25 = 0, $26 = 0, $27 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $exitcond = 0, $i$01 = 0, $reap$01$i = 0, dest = 0, label = 0, sp = 0, stop = 0;
 sp = STACKTOP;
 $0 = ((($vb)) + 104|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($vb)) + 84|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ($3|0)==(0|0);
 if (!($4)) {
  $reap$01$i = $3;
  while(1) {
   $5 = ((($reap$01$i)) + 4|0);
   $6 = HEAP32[$5>>2]|0;
   $7 = HEAP32[$reap$01$i>>2]|0;
   _free($7);
   _free($reap$01$i);
   $8 = ($6|0)==(0|0);
   if ($8) {
    break;
   } else {
    $reap$01$i = $6;
   }
  }
 }
 $9 = ((($vb)) + 80|0);
 $10 = HEAP32[$9>>2]|0;
 $11 = ($10|0)==(0);
 $$phi$trans$insert = ((($vb)) + 68|0);
 $$pre = HEAP32[$$phi$trans$insert>>2]|0;
 if ($11) {
  $20 = $$pre;
 } else {
  $12 = ((($vb)) + 76|0);
  $13 = HEAP32[$12>>2]|0;
  $14 = (($13) + ($10))|0;
  $15 = (_realloc($$pre,$14)|0);
  HEAP32[$$phi$trans$insert>>2] = $15;
  $16 = HEAP32[$9>>2]|0;
  $17 = HEAP32[$12>>2]|0;
  $18 = (($17) + ($16))|0;
  HEAP32[$12>>2] = $18;
  HEAP32[$9>>2] = 0;
  $20 = $15;
 }
 $19 = ((($vb)) + 72|0);
 HEAP32[$19>>2] = 0;
 HEAP32[$2>>2] = 0;
 $21 = ($20|0)==(0|0);
 if (!($21)) {
  _free($20);
 }
 $22 = ($1|0)==(0|0);
 if ($22) {
  dest=$vb; stop=dest+112|0; do { HEAP32[dest>>2]=0|0; dest=dest+4|0; } while ((dest|0) < (stop|0));
  return 0;
 } else {
  $i$01 = 0;
 }
 while(1) {
  $23 = (((($1)) + 12|0) + ($i$01<<2)|0);
  $24 = HEAP32[$23>>2]|0;
  _oggpack_writeclear($24);
  $25 = ($i$01|0)==(7);
  if ($25) {
   $i$01 = 8;
   continue;
  }
  $26 = HEAP32[$23>>2]|0;
  _free($26);
  $27 = (($i$01) + 1)|0;
  $exitcond = ($27|0)==(15);
  if ($exitcond) {
   break;
  } else {
   $i$01 = $27;
  }
 }
 _free($1);
 dest=$vb; stop=dest+112|0; do { HEAP32[dest>>2]=0|0; dest=dest+4|0; } while ((dest|0) < (stop|0));
 return 0;
}
function _vorbis_analysis_init($v,$vi) {
 $v = $v|0;
 $vi = $vi|0;
 var $$0 = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = (__vds_shared_init($v,$vi,1)|0);
 $1 = ($0|0)==(0);
 if (!($1)) {
  $$0 = 1;
  return ($$0|0);
 }
 $2 = ((($v)) + 104|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = (__vp_global_look($vi)|0);
 $5 = ((($3)) + 60|0);
 HEAP32[$5>>2] = $4;
 $6 = (_calloc(1,180)|0);
 HEAP32[$3>>2] = $6;
 __ve_envelope_init($6,$vi);
 $7 = ((($3)) + 80|0);
 _vorbis_bitrate_init($vi,$7);
 $8 = ((($v)) + 64|0);
 $9 = $8;
 $10 = $9;
 HEAP32[$10>>2] = 3;
 $11 = (($9) + 4)|0;
 $12 = $11;
 HEAP32[$12>>2] = 0;
 $$0 = 0;
 return ($$0|0);
}
function _vorbis_dsp_clear($v) {
 $v = $v|0;
 var $$pre = 0, $$pre14$pre = 0, $$pre16 = 0, $$pre18$pre = 0, $$pre20 = 0, $$pre22$pre = 0, $$pre24 = 0, $$pre25 = 0, $$pre27$pre = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0;
 var $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0;
 var $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0;
 var $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0;
 var $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0;
 var $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0;
 var $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0;
 var $98 = 0, $99 = 0, $i$37 = 0, dest = 0, label = 0, sp = 0, stop = 0;
 sp = STACKTOP;
 $0 = ($v|0)==(0|0);
 if ($0) {
  return;
 }
 $1 = ((($v)) + 4|0);
 $2 = HEAP32[$1>>2]|0;
 $3 = ($2|0)!=(0|0);
 if ($3) {
  $4 = ((($2)) + 28|0);
  $5 = HEAP32[$4>>2]|0;
  $29 = $5;
 } else {
  $29 = 0;
 }
 $6 = ((($v)) + 104|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = ($7|0)!=(0|0);
 if ($8) {
  $9 = HEAP32[$7>>2]|0;
  $10 = ($9|0)==(0|0);
  if (!($10)) {
   __ve_envelope_clear($9);
   $11 = HEAP32[$7>>2]|0;
   _free($11);
  }
  $12 = ((($7)) + 12|0);
  $13 = HEAP32[$12>>2]|0;
  $14 = ($13|0)==(0|0);
  if (!($14)) {
   $15 = HEAP32[$13>>2]|0;
   _mdct_clear($15);
   $16 = HEAP32[$12>>2]|0;
   $17 = HEAP32[$16>>2]|0;
   _free($17);
   $18 = HEAP32[$12>>2]|0;
   _free($18);
  }
  $19 = ((($7)) + 16|0);
  $20 = HEAP32[$19>>2]|0;
  $21 = ($20|0)==(0|0);
  if (!($21)) {
   $22 = HEAP32[$20>>2]|0;
   _mdct_clear($22);
   $23 = HEAP32[$19>>2]|0;
   $24 = HEAP32[$23>>2]|0;
   _free($24);
   $25 = HEAP32[$19>>2]|0;
   _free($25);
  }
  $26 = ((($7)) + 48|0);
  $27 = HEAP32[$26>>2]|0;
  $28 = ($27|0)==(0|0);
  if (!($28)) {
   $30 = ($29|0)==(0|0);
   if ($30) {
    $55 = $27;
   } else {
    $31 = ((($29)) + 16|0);
    $32 = HEAP32[$31>>2]|0;
    $33 = ($32|0)>(0);
    if ($33) {
     $34 = ((($29)) + 800|0);
     $35 = HEAP32[$34>>2]|0;
     $36 = (25640 + ($35<<2)|0);
     $37 = HEAP32[$36>>2]|0;
     $38 = ((($37)) + 16|0);
     $39 = HEAP32[$38>>2]|0;
     $40 = HEAP32[$27>>2]|0;
     FUNCTION_TABLE_vi[$39 & 7]($40);
     $41 = HEAP32[$31>>2]|0;
     $42 = ($41|0)>(1);
     if ($42) {
      $44 = 1;
      while(1) {
       $$pre = HEAP32[$26>>2]|0;
       $43 = (($34) + ($44<<2)|0);
       $45 = HEAP32[$43>>2]|0;
       $46 = (25640 + ($45<<2)|0);
       $47 = HEAP32[$46>>2]|0;
       $48 = ((($47)) + 16|0);
       $49 = HEAP32[$48>>2]|0;
       $50 = (($$pre) + ($44<<2)|0);
       $51 = HEAP32[$50>>2]|0;
       FUNCTION_TABLE_vi[$49 & 7]($51);
       $52 = (($44) + 1)|0;
       $53 = HEAP32[$31>>2]|0;
       $54 = ($52|0)<($53|0);
       if ($54) {
        $44 = $52;
       } else {
        break;
       }
      }
     }
     $$pre14$pre = HEAP32[$26>>2]|0;
     $55 = $$pre14$pre;
    } else {
     $55 = $27;
    }
   }
   _free($55);
  }
  $56 = ((($7)) + 52|0);
  $57 = HEAP32[$56>>2]|0;
  $58 = ($57|0)==(0|0);
  if (!($58)) {
   $59 = ($29|0)==(0|0);
   if ($59) {
    $84 = $57;
   } else {
    $60 = ((($29)) + 20|0);
    $61 = HEAP32[$60>>2]|0;
    $62 = ($61|0)>(0);
    if ($62) {
     $63 = ((($29)) + 1312|0);
     $64 = HEAP32[$63>>2]|0;
     $65 = (25648 + ($64<<2)|0);
     $66 = HEAP32[$65>>2]|0;
     $67 = ((($66)) + 16|0);
     $68 = HEAP32[$67>>2]|0;
     $69 = HEAP32[$57>>2]|0;
     FUNCTION_TABLE_vi[$68 & 7]($69);
     $70 = HEAP32[$60>>2]|0;
     $71 = ($70|0)>(1);
     if ($71) {
      $73 = 1;
      while(1) {
       $$pre16 = HEAP32[$56>>2]|0;
       $72 = (($63) + ($73<<2)|0);
       $74 = HEAP32[$72>>2]|0;
       $75 = (25648 + ($74<<2)|0);
       $76 = HEAP32[$75>>2]|0;
       $77 = ((($76)) + 16|0);
       $78 = HEAP32[$77>>2]|0;
       $79 = (($$pre16) + ($73<<2)|0);
       $80 = HEAP32[$79>>2]|0;
       FUNCTION_TABLE_vi[$78 & 7]($80);
       $81 = (($73) + 1)|0;
       $82 = HEAP32[$60>>2]|0;
       $83 = ($81|0)<($82|0);
       if ($83) {
        $73 = $81;
       } else {
        break;
       }
      }
     }
     $$pre18$pre = HEAP32[$56>>2]|0;
     $84 = $$pre18$pre;
    } else {
     $84 = $57;
    }
   }
   _free($84);
  }
  $85 = ((($7)) + 56|0);
  $86 = HEAP32[$85>>2]|0;
  $87 = ($86|0)==(0|0);
  if (!($87)) {
   $88 = ($29|0)==(0|0);
   if ($88) {
    $99 = $86;
   } else {
    $89 = ((($29)) + 28|0);
    $90 = HEAP32[$89>>2]|0;
    $91 = ($90|0)>(0);
    if ($91) {
     __vp_psy_clear($86);
     $92 = HEAP32[$89>>2]|0;
     $93 = ($92|0)>(1);
     if ($93) {
      $95 = 1;
      while(1) {
       $$pre20 = HEAP32[$85>>2]|0;
       $94 = (($$pre20) + (($95*52)|0)|0);
       __vp_psy_clear($94);
       $96 = (($95) + 1)|0;
       $97 = HEAP32[$89>>2]|0;
       $98 = ($96|0)<($97|0);
       if ($98) {
        $95 = $96;
       } else {
        break;
       }
      }
     }
     $$pre22$pre = HEAP32[$85>>2]|0;
     $99 = $$pre22$pre;
    } else {
     $99 = $86;
    }
   }
   _free($99);
  }
  $100 = ((($7)) + 60|0);
  $101 = HEAP32[$100>>2]|0;
  $102 = ($101|0)==(0|0);
  if (!($102)) {
   __vp_global_free($101);
  }
  $103 = ((($7)) + 80|0);
  _vorbis_bitrate_clear($103);
  $104 = ((($7)) + 20|0);
  _drft_clear($104);
  $105 = ((($7)) + 32|0);
  _drft_clear($105);
 }
 $106 = ((($v)) + 8|0);
 $107 = HEAP32[$106>>2]|0;
 $108 = ($107|0)==(0|0);
 if (!($108)) {
  if ($3) {
   $109 = ((($2)) + 4|0);
   $110 = HEAP32[$109>>2]|0;
   $111 = ($110|0)>(0);
   if ($111) {
    $113 = $107;$132 = $110;$i$37 = 0;
    while(1) {
     $112 = (($113) + ($i$37<<2)|0);
     $114 = HEAP32[$112>>2]|0;
     $115 = ($114|0)==(0|0);
     if ($115) {
      $118 = $132;
     } else {
      _free($114);
      $$pre25 = HEAP32[$109>>2]|0;
      $118 = $$pre25;
     }
     $116 = (($i$37) + 1)|0;
     $117 = ($116|0)<($118|0);
     if (!($117)) {
      break;
     }
     $$pre24 = HEAP32[$106>>2]|0;
     $113 = $$pre24;$132 = $118;$i$37 = $116;
    }
    $$pre27$pre = HEAP32[$106>>2]|0;
    $119 = $$pre27$pre;
   } else {
    $119 = $107;
   }
  } else {
   $119 = $107;
  }
  _free($119);
  $120 = ((($v)) + 12|0);
  $121 = HEAP32[$120>>2]|0;
  $122 = ($121|0)==(0|0);
  if (!($122)) {
   _free($121);
  }
 }
 if ($8) {
  $123 = ((($7)) + 64|0);
  $124 = HEAP32[$123>>2]|0;
  $125 = ($124|0)==(0|0);
  if (!($125)) {
   _free($124);
  }
  $126 = ((($7)) + 68|0);
  $127 = HEAP32[$126>>2]|0;
  $128 = ($127|0)==(0|0);
  if (!($128)) {
   _free($127);
  }
  $129 = ((($7)) + 72|0);
  $130 = HEAP32[$129>>2]|0;
  $131 = ($130|0)==(0|0);
  if (!($131)) {
   _free($130);
  }
  _free($7);
 }
 dest=$v; stop=dest+112|0; do { HEAP32[dest>>2]=0|0; dest=dest+4|0; } while ((dest|0) < (stop|0));
 return;
}
function _vorbis_analysis_buffer($v,$vals) {
 $v = $v|0;
 $vals = $vals|0;
 var $$phi$trans$insert = 0, $$pre = 0, $$pre$phi8Z2D = 0, $$pre6 = 0, $$pre7 = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0;
 var $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0;
 var $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $6 = 0, $7 = 0;
 var $8 = 0, $9 = 0, $i$11 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($v)) + 4|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($v)) + 104|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ((($3)) + 64|0);
 $5 = HEAP32[$4>>2]|0;
 $6 = ($5|0)==(0|0);
 if (!($6)) {
  _free($5);
 }
 HEAP32[$4>>2] = 0;
 $7 = ((($3)) + 68|0);
 $8 = HEAP32[$7>>2]|0;
 $9 = ($8|0)==(0|0);
 if (!($9)) {
  _free($8);
 }
 HEAP32[$7>>2] = 0;
 $10 = ((($3)) + 72|0);
 $11 = HEAP32[$10>>2]|0;
 $12 = ($11|0)==(0|0);
 if (!($12)) {
  _free($11);
 }
 HEAP32[$10>>2] = 0;
 $13 = ((($v)) + 20|0);
 $14 = HEAP32[$13>>2]|0;
 $15 = (($14) + ($vals))|0;
 $16 = ((($v)) + 16|0);
 $17 = HEAP32[$16>>2]|0;
 $18 = ($15|0)<($17|0);
 if ($18) {
  $$phi$trans$insert = ((($1)) + 4|0);
  $$pre6 = HEAP32[$$phi$trans$insert>>2]|0;
  $32 = $$pre6;
  label = 11;
 } else {
  $19 = $vals << 1;
  $20 = (($14) + ($19))|0;
  HEAP32[$16>>2] = $20;
  $21 = ((($1)) + 4|0);
  $22 = HEAP32[$21>>2]|0;
  $23 = ($22|0)>(0);
  if ($23) {
   $24 = ((($v)) + 8|0);
   $25 = HEAP32[$24>>2]|0;
   $26 = HEAP32[$25>>2]|0;
   $27 = $20 << 2;
   $28 = (_realloc($26,$27)|0);
   $29 = HEAP32[$24>>2]|0;
   HEAP32[$29>>2] = $28;
   $30 = HEAP32[$21>>2]|0;
   $31 = ($30|0)>(1);
   if ($31) {
    $39 = 1;
    while(1) {
     $$pre = HEAP32[$16>>2]|0;
     $37 = HEAP32[$24>>2]|0;
     $38 = (($37) + ($39<<2)|0);
     $40 = HEAP32[$38>>2]|0;
     $41 = $$pre << 2;
     $42 = (_realloc($40,$41)|0);
     $43 = HEAP32[$24>>2]|0;
     $44 = (($43) + ($39<<2)|0);
     HEAP32[$44>>2] = $42;
     $45 = (($39) + 1)|0;
     $46 = HEAP32[$21>>2]|0;
     $47 = ($45|0)<($46|0);
     if ($47) {
      $39 = $45;
     } else {
      $32 = $46;
      label = 11;
      break;
     }
    }
   } else {
    $32 = $30;
    label = 11;
   }
  }
 }
 if ((label|0) == 11) {
  $33 = ($32|0)>(0);
  if ($33) {
   $34 = ((($v)) + 8|0);
   $35 = HEAP32[$13>>2]|0;
   $36 = ((($v)) + 12|0);
   $i$11 = 0;
   while(1) {
    $48 = HEAP32[$34>>2]|0;
    $49 = (($48) + ($i$11<<2)|0);
    $50 = HEAP32[$49>>2]|0;
    $51 = (($50) + ($35<<2)|0);
    $52 = HEAP32[$36>>2]|0;
    $53 = (($52) + ($i$11<<2)|0);
    HEAP32[$53>>2] = $51;
    $54 = (($i$11) + 1)|0;
    $55 = ($54|0)<($32|0);
    if ($55) {
     $i$11 = $54;
    } else {
     $$pre$phi8Z2D = $36;
     break;
    }
   }
   $56 = HEAP32[$$pre$phi8Z2D>>2]|0;
   return ($56|0);
  }
 }
 $$pre7 = ((($v)) + 12|0);
 $$pre$phi8Z2D = $$pre7;
 $56 = HEAP32[$$pre$phi8Z2D>>2]|0;
 return ($56|0);
}
function _vorbis_analysis_wrote($v,$vals) {
 $v = $v|0;
 $vals = $vals|0;
 var $$ = 0, $$0 = 0, $$pre = 0, $$sum = 0, $$sum1 = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0;
 var $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0;
 var $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0;
 var $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $7 = 0, $8 = 0, $9 = 0, $i$02 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($v)) + 4|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 28|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ($vals|0)<(1);
 if (!($4)) {
  $48 = ((($v)) + 20|0);
  $49 = HEAP32[$48>>2]|0;
  $50 = (($49) + ($vals))|0;
  $51 = ((($v)) + 16|0);
  $52 = HEAP32[$51>>2]|0;
  $53 = ($50|0)>($52|0);
  if ($53) {
   $$0 = -131;
   STACKTOP = sp;return ($$0|0);
  }
  HEAP32[$48>>2] = $50;
  $54 = ((($v)) + 28|0);
  $55 = HEAP32[$54>>2]|0;
  $56 = ($55|0)==(0);
  if (!($56)) {
   $$0 = 0;
   STACKTOP = sp;return ($$0|0);
  }
  $57 = ((($v)) + 48|0);
  $58 = HEAP32[$57>>2]|0;
  $59 = (($50) - ($58))|0;
  $60 = ((($3)) + 4|0);
  $61 = HEAP32[$60>>2]|0;
  $62 = ($59|0)>($61|0);
  if (!($62)) {
   $$0 = 0;
   STACKTOP = sp;return ($$0|0);
  }
  __preextrapolate_helper($v);
  $$0 = 0;
  STACKTOP = sp;return ($$0|0);
 }
 $5 = STACKTOP; STACKTOP = STACKTOP + 128|0;;
 $6 = ((($v)) + 28|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = ($7|0)==(0);
 if ($8) {
  __preextrapolate_helper($v);
 }
 $9 = ((($3)) + 4|0);
 $10 = HEAP32[$9>>2]|0;
 $11 = ($10*3)|0;
 (_vorbis_analysis_buffer($v,$11)|0);
 $12 = ((($v)) + 20|0);
 $13 = HEAP32[$12>>2]|0;
 $14 = ((($v)) + 32|0);
 HEAP32[$14>>2] = $13;
 $15 = HEAP32[$9>>2]|0;
 $16 = ($15*3)|0;
 $17 = (($13) + ($16))|0;
 HEAP32[$12>>2] = $17;
 $18 = ((($1)) + 4|0);
 $19 = HEAP32[$18>>2]|0;
 $20 = ($19|0)>(0);
 if (!($20)) {
  $$0 = 0;
  STACKTOP = sp;return ($$0|0);
 }
 $21 = ((($v)) + 8|0);
 $22 = $13;$i$02 = 0;
 while(1) {
  $23 = ($22|0)>(64);
  if ($23) {
   $24 = HEAP32[$9>>2]|0;
   $25 = ($22|0)>($24|0);
   $$ = $25 ? $24 : $22;
   $26 = HEAP32[$21>>2]|0;
   $27 = (($26) + ($i$02<<2)|0);
   $28 = HEAP32[$27>>2]|0;
   $$sum = (($22) - ($$))|0;
   $29 = (($28) + ($$sum<<2)|0);
   (+_vorbis_lpc_from_data($29,$5,$$,32));
   $30 = HEAP32[$21>>2]|0;
   $31 = (($30) + ($i$02<<2)|0);
   $32 = HEAP32[$31>>2]|0;
   $33 = HEAP32[$14>>2]|0;
   $34 = (($32) + ($33<<2)|0);
   $$sum1 = (($33) + -32)|0;
   $35 = (($32) + ($$sum1<<2)|0);
   $36 = HEAP32[$12>>2]|0;
   $37 = (($36) - ($33))|0;
   _vorbis_lpc_predict($5,$35,32,$34,$37);
  } else {
   $38 = HEAP32[$21>>2]|0;
   $39 = (($38) + ($i$02<<2)|0);
   $40 = HEAP32[$39>>2]|0;
   $41 = (($40) + ($22<<2)|0);
   $42 = HEAP32[$12>>2]|0;
   $43 = (($42) - ($22))|0;
   $44 = $43 << 2;
   _memset(($41|0),0,($44|0))|0;
  }
  $45 = (($i$02) + 1)|0;
  $46 = HEAP32[$18>>2]|0;
  $47 = ($45|0)<($46|0);
  if (!($47)) {
   $$0 = 0;
   break;
  }
  $$pre = HEAP32[$14>>2]|0;
  $22 = $$pre;$i$02 = $45;
 }
 STACKTOP = sp;return ($$0|0);
}
function _vorbis_analysis_blockout($v,$vb) {
 $v = $v|0;
 $vb = $vb|0;
 var $$ = 0, $$0 = 0, $$pre = 0, $$pre$phiZ2D = 0, $$pre10 = 0, $$pre11 = 0, $$pre12 = 0, $$pre13 = 0, $$pre15 = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0;
 var $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0.0, $121 = 0.0, $122 = 0, $123 = 0.0, $124 = 0.0, $125 = 0;
 var $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0;
 var $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0;
 var $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0;
 var $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0, $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0;
 var $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0, $206 = 0, $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0;
 var $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0, $224 = 0, $225 = 0, $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0;
 var $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0, $242 = 0, $243 = 0, $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0;
 var $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0, $260 = 0, $261 = 0, $262 = 0, $263 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0, $27 = 0;
 var $270 = 0, $271 = 0, $272 = 0, $273 = 0, $274 = 0, $275 = 0, $276 = 0, $277 = 0, $278 = 0, $279 = 0, $28 = 0, $280 = 0, $281 = 0, $282 = 0, $283 = 0, $284 = 0, $285 = 0, $286 = 0, $287 = 0, $288 = 0;
 var $289 = 0, $29 = 0, $290 = 0, $291 = 0, $292 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0;
 var $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0;
 var $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0;
 var $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0;
 var $98 = 0, $99 = 0, $i$07 = 0, $or$cond = 0, $reap$01$i = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($v)) + 4|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 28|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ((($v)) + 104|0);
 $5 = HEAP32[$4>>2]|0;
 $6 = ((($5)) + 60|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = ((($v)) + 48|0);
 $9 = HEAP32[$8>>2]|0;
 $10 = ((($v)) + 40|0);
 $11 = HEAP32[$10>>2]|0;
 $12 = (($3) + ($11<<2)|0);
 $13 = HEAP32[$12>>2]|0;
 $14 = (($13|0) / 2)&-1;
 $15 = (($9) - ($14))|0;
 $16 = ((($vb)) + 104|0);
 $17 = HEAP32[$16>>2]|0;
 $18 = ((($v)) + 28|0);
 $19 = HEAP32[$18>>2]|0;
 $20 = ($19|0)==(0);
 if ($20) {
  $$0 = 0;
  return ($$0|0);
 }
 $21 = ((($v)) + 32|0);
 $22 = HEAP32[$21>>2]|0;
 $23 = ($22|0)==(-1);
 if ($23) {
  $$0 = 0;
  return ($$0|0);
 }
 $24 = (__ve_envelope_search($v)|0);
 $25 = ($24|0)==(-1);
 do {
  if ($25) {
   $26 = HEAP32[$21>>2]|0;
   $27 = ($26|0)==(0);
   if ($27) {
    $$0 = 0;
    return ($$0|0);
   } else {
    $28 = ((($v)) + 44|0);
    HEAP32[$28>>2] = 0;
    $$pre$phiZ2D = $28;$41 = 0;
    break;
   }
  } else {
   $29 = HEAP32[$3>>2]|0;
   $30 = ((($3)) + 4|0);
   $31 = HEAP32[$30>>2]|0;
   $32 = ($29|0)==($31|0);
   $33 = ((($v)) + 44|0);
   if ($32) {
    HEAP32[$33>>2] = 0;
    $$pre$phiZ2D = $33;$41 = 0;
    break;
   } else {
    HEAP32[$33>>2] = $24;
    $$pre$phiZ2D = $33;$41 = $24;
    break;
   }
  }
 } while(0);
 $34 = HEAP32[$8>>2]|0;
 $35 = HEAP32[$10>>2]|0;
 $36 = (($3) + ($35<<2)|0);
 $37 = HEAP32[$36>>2]|0;
 $38 = (($37|0) / 4)&-1;
 $39 = (($38) + ($34))|0;
 $40 = (($3) + ($41<<2)|0);
 $42 = HEAP32[$40>>2]|0;
 $43 = (($42|0) / 4)&-1;
 $44 = (($39) + ($43))|0;
 $45 = (($42|0) / 2)&-1;
 $46 = (($44) + ($45))|0;
 $47 = ((($v)) + 20|0);
 $48 = HEAP32[$47>>2]|0;
 $49 = ($48|0)<($46|0);
 if ($49) {
  $$0 = 0;
  return ($$0|0);
 }
 $50 = ((($vb)) + 84|0);
 $51 = HEAP32[$50>>2]|0;
 $52 = ($51|0)==(0|0);
 if (!($52)) {
  $reap$01$i = $51;
  while(1) {
   $53 = ((($reap$01$i)) + 4|0);
   $54 = HEAP32[$53>>2]|0;
   $55 = HEAP32[$reap$01$i>>2]|0;
   _free($55);
   _free($reap$01$i);
   $56 = ($54|0)==(0|0);
   if ($56) {
    break;
   } else {
    $reap$01$i = $54;
   }
  }
 }
 $57 = ((($vb)) + 80|0);
 $58 = HEAP32[$57>>2]|0;
 $59 = ($58|0)==(0);
 if (!($59)) {
  $60 = ((($vb)) + 68|0);
  $61 = HEAP32[$60>>2]|0;
  $62 = ((($vb)) + 76|0);
  $63 = HEAP32[$62>>2]|0;
  $64 = (($63) + ($58))|0;
  $65 = (_realloc($61,$64)|0);
  HEAP32[$60>>2] = $65;
  $66 = HEAP32[$57>>2]|0;
  $67 = HEAP32[$62>>2]|0;
  $68 = (($67) + ($66))|0;
  HEAP32[$62>>2] = $68;
  HEAP32[$57>>2] = 0;
 }
 $69 = ((($vb)) + 72|0);
 HEAP32[$69>>2] = 0;
 HEAP32[$50>>2] = 0;
 $70 = ((($v)) + 36|0);
 $71 = HEAP32[$70>>2]|0;
 $72 = ((($vb)) + 24|0);
 HEAP32[$72>>2] = $71;
 $73 = HEAP32[$10>>2]|0;
 $74 = ((($vb)) + 28|0);
 HEAP32[$74>>2] = $73;
 $75 = HEAP32[$$pre$phiZ2D>>2]|0;
 $76 = ((($vb)) + 32|0);
 HEAP32[$76>>2] = $75;
 $77 = ($73|0)==(0);
 do {
  if ($77) {
   $81 = (__ve_envelope_mark($v)|0);
   $82 = ($81|0)==(0);
   $83 = ((($17)) + 8|0);
   if ($82) {
    HEAP32[$83>>2] = 1;
    break;
   } else {
    HEAP32[$83>>2] = 0;
    break;
   }
  } else {
   $78 = ($71|0)==(0);
   $79 = ($75|0)==(0);
   $or$cond = $78 | $79;
   $80 = ((($17)) + 8|0);
   if ($or$cond) {
    HEAP32[$80>>2] = 0;
    break;
   } else {
    HEAP32[$80>>2] = 1;
    break;
   }
  }
 } while(0);
 $84 = ((($vb)) + 64|0);
 HEAP32[$84>>2] = $v;
 $85 = ((($v)) + 64|0);
 $86 = $85;
 $87 = $86;
 $88 = HEAP32[$87>>2]|0;
 $89 = (($86) + 4)|0;
 $90 = $89;
 $91 = HEAP32[$90>>2]|0;
 $92 = (_i64Add(($88|0),($91|0),1,0)|0);
 $93 = tempRet0;
 $94 = $85;
 $95 = $94;
 HEAP32[$95>>2] = $92;
 $96 = (($94) + 4)|0;
 $97 = $96;
 HEAP32[$97>>2] = $93;
 $98 = ((($vb)) + 56|0);
 $99 = $98;
 $100 = $99;
 HEAP32[$100>>2] = $88;
 $101 = (($99) + 4)|0;
 $102 = $101;
 HEAP32[$102>>2] = $91;
 $103 = ((($v)) + 56|0);
 $104 = $103;
 $105 = $104;
 $106 = HEAP32[$105>>2]|0;
 $107 = (($104) + 4)|0;
 $108 = $107;
 $109 = HEAP32[$108>>2]|0;
 $110 = ((($vb)) + 48|0);
 $111 = $110;
 $112 = $111;
 HEAP32[$112>>2] = $106;
 $113 = (($111) + 4)|0;
 $114 = $113;
 HEAP32[$114>>2] = $109;
 $115 = HEAP32[$10>>2]|0;
 $116 = (($3) + ($115<<2)|0);
 $117 = HEAP32[$116>>2]|0;
 $118 = ((($vb)) + 36|0);
 HEAP32[$118>>2] = $117;
 $119 = ((($17)) + 4|0);
 $120 = +HEAPF32[$119>>2];
 $121 = +HEAPF32[$7>>2];
 $122 = $120 > $121;
 if ($122) {
  HEAPF32[$7>>2] = $120;
  $123 = $120;
 } else {
  $123 = $121;
 }
 $124 = (+__vp_ampmax_decay($123,$v));
 HEAPF32[$7>>2] = $124;
 HEAPF32[$119>>2] = $124;
 $125 = ((($1)) + 4|0);
 $126 = HEAP32[$125>>2]|0;
 $127 = $126 << 2;
 $128 = (($127) + 7)|0;
 $129 = $128 & -8;
 $130 = HEAP32[$69>>2]|0;
 $131 = (($129) + ($130))|0;
 $132 = ((($vb)) + 76|0);
 $133 = HEAP32[$132>>2]|0;
 $134 = ($131|0)>($133|0);
 $135 = ((($vb)) + 68|0);
 $136 = HEAP32[$135>>2]|0;
 if ($134) {
  $137 = ($136|0)==(0|0);
  if (!($137)) {
   $138 = $136;
   $139 = (_malloc(8)|0);
   $140 = HEAP32[$57>>2]|0;
   $141 = (($140) + ($130))|0;
   HEAP32[$57>>2] = $141;
   $142 = HEAP32[$50>>2]|0;
   $143 = ((($139)) + 4|0);
   HEAP32[$143>>2] = $142;
   HEAP32[$139>>2] = $138;
   HEAP32[$50>>2] = $139;
  }
  HEAP32[$132>>2] = $129;
  $144 = (_malloc($129)|0);
  HEAP32[$135>>2] = $144;
  HEAP32[$69>>2] = 0;
  $$pre = HEAP32[$125>>2]|0;
  $146 = $144;$147 = 0;$150 = $$pre;$155 = $129;
 } else {
  $146 = $136;$147 = $130;$150 = $126;$155 = $133;
 }
 $145 = (($146) + ($147)|0);
 $148 = (($147) + ($129))|0;
 HEAP32[$69>>2] = $148;
 HEAP32[$vb>>2] = $145;
 $149 = $150 << 2;
 $151 = (($149) + 7)|0;
 $152 = $151 & -8;
 $153 = (($152) + ($148))|0;
 $154 = ($153|0)>($155|0);
 if ($154) {
  $156 = ($146|0)==(0|0);
  if (!($156)) {
   $157 = $146;
   $158 = (_malloc(8)|0);
   $159 = HEAP32[$57>>2]|0;
   $160 = (($159) + ($148))|0;
   HEAP32[$57>>2] = $160;
   $161 = HEAP32[$50>>2]|0;
   $162 = ((($158)) + 4|0);
   HEAP32[$162>>2] = $161;
   HEAP32[$158>>2] = $157;
   HEAP32[$50>>2] = $158;
  }
  HEAP32[$132>>2] = $152;
  $163 = (_malloc($152)|0);
  HEAP32[$135>>2] = $163;
  HEAP32[$69>>2] = 0;
  $$pre10 = HEAP32[$125>>2]|0;
  $165 = $163;$166 = 0;$168 = $$pre10;$292 = $152;
 } else {
  $165 = $146;$166 = $148;$168 = $150;$292 = $155;
 }
 $164 = (($165) + ($166)|0);
 $167 = (($166) + ($152))|0;
 HEAP32[$69>>2] = $167;
 HEAP32[$17>>2] = $164;
 $169 = ($168|0)>(0);
 L52: do {
  if ($169) {
   $170 = ((($v)) + 8|0);
   $177 = $167;$179 = $292;$180 = $165;$i$07 = 0;
   while(1) {
    $171 = HEAP32[$118>>2]|0;
    $172 = (($171) + ($15))|0;
    $173 = $172 << 2;
    $174 = (($173) + 7)|0;
    $175 = $174 & -8;
    $176 = (($175) + ($177))|0;
    $178 = ($176|0)>($179|0);
    if ($178) {
     $181 = ($180|0)==(0|0);
     if (!($181)) {
      $182 = $180;
      $183 = (_malloc(8)|0);
      $184 = HEAP32[$57>>2]|0;
      $185 = (($184) + ($177))|0;
      HEAP32[$57>>2] = $185;
      $186 = HEAP32[$50>>2]|0;
      $187 = ((($183)) + 4|0);
      HEAP32[$187>>2] = $186;
      HEAP32[$183>>2] = $182;
      HEAP32[$50>>2] = $183;
     }
     HEAP32[$132>>2] = $175;
     $188 = (_malloc($175)|0);
     HEAP32[$135>>2] = $188;
     HEAP32[$69>>2] = 0;
     $190 = $188;$191 = 0;
    } else {
     $190 = $180;$191 = $177;
    }
    $189 = (($190) + ($191)|0);
    $192 = (($191) + ($175))|0;
    HEAP32[$69>>2] = $192;
    $193 = HEAP32[$17>>2]|0;
    $194 = (($193) + ($i$07<<2)|0);
    HEAP32[$194>>2] = $189;
    $195 = HEAP32[$17>>2]|0;
    $196 = (($195) + ($i$07<<2)|0);
    $197 = HEAP32[$196>>2]|0;
    $198 = HEAP32[$170>>2]|0;
    $199 = (($198) + ($i$07<<2)|0);
    $200 = HEAP32[$199>>2]|0;
    _memcpy(($197|0),($200|0),($173|0))|0;
    $201 = HEAP32[$17>>2]|0;
    $202 = (($201) + ($i$07<<2)|0);
    $203 = HEAP32[$202>>2]|0;
    $204 = (($203) + ($15<<2)|0);
    $205 = HEAP32[$vb>>2]|0;
    $206 = (($205) + ($i$07<<2)|0);
    HEAP32[$206>>2] = $204;
    $207 = (($i$07) + 1)|0;
    $208 = HEAP32[$125>>2]|0;
    $209 = ($207|0)<($208|0);
    if (!($209)) {
     break L52;
    }
    $$pre11 = HEAP32[$69>>2]|0;
    $$pre12 = HEAP32[$132>>2]|0;
    $$pre13 = HEAP32[$135>>2]|0;
    $177 = $$pre11;$179 = $$pre12;$180 = $$pre13;$i$07 = $207;
   }
  }
 } while(0);
 $210 = HEAP32[$21>>2]|0;
 $211 = ($210|0)==(0);
 if (!($211)) {
  $212 = HEAP32[$8>>2]|0;
  $213 = ($212|0)<($210|0);
  if (!($213)) {
   HEAP32[$21>>2] = -1;
   $214 = ((($vb)) + 44|0);
   HEAP32[$214>>2] = 1;
   $$0 = 1;
   return ($$0|0);
  }
 }
 $215 = ((($3)) + 4|0);
 $216 = HEAP32[$215>>2]|0;
 $217 = (($216|0) / 2)&-1;
 $218 = (($44) - ($217))|0;
 $219 = ($218|0)>(0);
 if (!($219)) {
  $$0 = 1;
  return ($$0|0);
 }
 $220 = HEAP32[$5>>2]|0;
 __ve_envelope_shift($220,$218);
 $221 = HEAP32[$47>>2]|0;
 $222 = (($221) - ($218))|0;
 HEAP32[$47>>2] = $222;
 $223 = HEAP32[$125>>2]|0;
 $224 = ($223|0)>(0);
 if ($224) {
  $225 = ((($v)) + 8|0);
  $226 = HEAP32[$225>>2]|0;
  $227 = HEAP32[$226>>2]|0;
  $228 = (($227) + ($218<<2)|0);
  $229 = $222 << 2;
  _memmove(($227|0),($228|0),($229|0))|0;
  $230 = HEAP32[$125>>2]|0;
  $231 = ($230|0)>(1);
  if ($231) {
   $234 = 1;
   while(1) {
    $$pre15 = HEAP32[$47>>2]|0;
    $232 = HEAP32[$225>>2]|0;
    $233 = (($232) + ($234<<2)|0);
    $235 = HEAP32[$233>>2]|0;
    $236 = (($235) + ($218<<2)|0);
    $237 = $$pre15 << 2;
    _memmove(($235|0),($236|0),($237|0))|0;
    $238 = (($234) + 1)|0;
    $239 = HEAP32[$125>>2]|0;
    $240 = ($238|0)<($239|0);
    if ($240) {
     $234 = $238;
    } else {
     break;
    }
   }
  }
 }
 $241 = HEAP32[$10>>2]|0;
 HEAP32[$70>>2] = $241;
 $242 = HEAP32[$$pre$phiZ2D>>2]|0;
 HEAP32[$10>>2] = $242;
 HEAP32[$8>>2] = $217;
 $243 = HEAP32[$21>>2]|0;
 $244 = ($243|0)==(0);
 if ($244) {
  $278 = ($218|0)<(0);
  $279 = $278 << 31 >> 31;
  $280 = $103;
  $281 = $280;
  $282 = HEAP32[$281>>2]|0;
  $283 = (($280) + 4)|0;
  $284 = $283;
  $285 = HEAP32[$284>>2]|0;
  $286 = (_i64Add(($282|0),($285|0),($218|0),($279|0))|0);
  $287 = tempRet0;
  $288 = $103;
  $289 = $288;
  HEAP32[$289>>2] = $286;
  $290 = (($288) + 4)|0;
  $291 = $290;
  HEAP32[$291>>2] = $287;
  $$0 = 1;
  return ($$0|0);
 }
 $245 = (($243) - ($218))|0;
 $246 = ($245|0)<(1);
 $$ = $246 ? -1 : $245;
 HEAP32[$21>>2] = $$;
 $247 = ($$|0)>($217|0);
 if ($247) {
  $264 = ($218|0)<(0);
  $265 = $264 << 31 >> 31;
  $266 = $103;
  $267 = $266;
  $268 = HEAP32[$267>>2]|0;
  $269 = (($266) + 4)|0;
  $270 = $269;
  $271 = HEAP32[$270>>2]|0;
  $272 = (_i64Add(($268|0),($271|0),($218|0),($265|0))|0);
  $273 = tempRet0;
  $274 = $103;
  $275 = $274;
  HEAP32[$275>>2] = $272;
  $276 = (($274) + 4)|0;
  $277 = $276;
  HEAP32[$277>>2] = $273;
  $$0 = 1;
  return ($$0|0);
 } else {
  $248 = (($$) + ($218))|0;
  $249 = (($248) - ($217))|0;
  $250 = ($249|0)<(0);
  $251 = $250 << 31 >> 31;
  $252 = $103;
  $253 = $252;
  $254 = HEAP32[$253>>2]|0;
  $255 = (($252) + 4)|0;
  $256 = $255;
  $257 = HEAP32[$256>>2]|0;
  $258 = (_i64Add(($254|0),($257|0),($249|0),($251|0))|0);
  $259 = tempRet0;
  $260 = $103;
  $261 = $260;
  HEAP32[$261>>2] = $258;
  $262 = (($260) + 4)|0;
  $263 = $262;
  HEAP32[$263>>2] = $259;
  $$0 = 1;
  return ($$0|0);
 }
 return (0)|0;
}
function __vds_shared_init($v,$vi,$encp) {
 $v = $v|0;
 $vi = $vi|0;
 $encp = $encp|0;
 var $$0 = 0, $$pre = 0, $$pre26 = 0, $$pre28 = 0, $$pre29 = 0, $$pre30 = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0;
 var $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0;
 var $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0;
 var $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0;
 var $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0;
 var $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0;
 var $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0;
 var $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0;
 var $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0;
 var $98 = 0, $99 = 0, $i$117 = 0, $i$214 = 0, $i$37 = 0, $i$45 = 0, $i$54 = 0, dest = 0, label = 0, sp = 0, stop = 0;
 sp = STACKTOP;
 $0 = ((($vi)) + 28|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ($1|0)==(0|0);
 if ($2) {
  $$0 = 1;
  return ($$0|0);
 }
 $3 = ((($1)) + 8|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = ($4|0)<(1);
 if ($5) {
  $$0 = 1;
  return ($$0|0);
 }
 $6 = HEAP32[$1>>2]|0;
 $7 = ($6|0)<(64);
 if ($7) {
  $$0 = 1;
  return ($$0|0);
 }
 $8 = ((($1)) + 4|0);
 $9 = HEAP32[$8>>2]|0;
 $10 = ($9|0)<($6|0);
 if ($10) {
  $$0 = 1;
  return ($$0|0);
 }
 $11 = ((($1)) + 3656|0);
 $12 = HEAP32[$11>>2]|0;
 dest=$v; stop=dest+112|0; do { HEAP32[dest>>2]=0|0; dest=dest+4|0; } while ((dest|0) < (stop|0));
 $13 = (_calloc(1,136)|0);
 $14 = ((($v)) + 104|0);
 HEAP32[$14>>2] = $13;
 $15 = ((($v)) + 4|0);
 HEAP32[$15>>2] = $vi;
 $16 = HEAP32[$3>>2]|0;
 $17 = (($16) + -1)|0;
 $18 = (_ov_ilog($17)|0);
 $19 = ((($13)) + 44|0);
 HEAP32[$19>>2] = $18;
 $20 = (_calloc(1,4)|0);
 $21 = ((($13)) + 12|0);
 HEAP32[$21>>2] = $20;
 $22 = (_calloc(1,4)|0);
 $23 = ((($13)) + 16|0);
 HEAP32[$23>>2] = $22;
 $24 = (_calloc(1,20)|0);
 HEAP32[$20>>2] = $24;
 $25 = (_calloc(1,20)|0);
 HEAP32[$22>>2] = $25;
 $26 = HEAP32[$1>>2]|0;
 $27 = $26 >> $12;
 _mdct_init($24,$27);
 $28 = HEAP32[$23>>2]|0;
 $29 = HEAP32[$28>>2]|0;
 $30 = HEAP32[$8>>2]|0;
 $31 = $30 >> $12;
 _mdct_init($29,$31);
 $32 = HEAP32[$1>>2]|0;
 $33 = (_ov_ilog($32)|0);
 $34 = (($33) + -7)|0;
 $35 = ((($13)) + 4|0);
 HEAP32[$35>>2] = $34;
 $36 = HEAP32[$8>>2]|0;
 $37 = (_ov_ilog($36)|0);
 $38 = (($37) + -7)|0;
 $39 = ((($13)) + 8|0);
 HEAP32[$39>>2] = $38;
 $40 = ($encp|0)==(0);
 L13: do {
  if ($40) {
   $84 = ((($1)) + 2848|0);
   $85 = HEAP32[$84>>2]|0;
   $86 = ($85|0)==(0|0);
   if ($86) {
    $87 = ((($1)) + 24|0);
    $88 = HEAP32[$87>>2]|0;
    $89 = (_calloc($88,56)|0);
    HEAP32[$84>>2] = $89;
    $90 = HEAP32[$87>>2]|0;
    $91 = ($90|0)>(0);
    if ($91) {
     $174 = $90;$i$214 = 0;
     while(1) {
      $92 = (((($1)) + 1824|0) + ($i$214<<2)|0);
      $93 = HEAP32[$92>>2]|0;
      $94 = ($93|0)==(0|0);
      if ($94) {
       $95 = $174;
       break;
      }
      $97 = HEAP32[$84>>2]|0;
      $98 = (($97) + (($i$214*56)|0)|0);
      $99 = (_vorbis_book_init_decode($98,$93)|0);
      $100 = ($99|0)==(0);
      if (!($100)) {
       label = 20;
       break;
      }
      $101 = HEAP32[$92>>2]|0;
      _vorbis_staticbook_destroy($101);
      HEAP32[$92>>2] = 0;
      $102 = (($i$214) + 1)|0;
      $103 = HEAP32[$87>>2]|0;
      $104 = ($102|0)<($103|0);
      if ($104) {
       $174 = $103;$i$214 = $102;
      } else {
       break L13;
      }
     }
     if ((label|0) == 20) {
      $$pre29 = HEAP32[$87>>2]|0;
      $95 = $$pre29;
     }
     $96 = ($95|0)>(0);
     if ($96) {
      $175 = $95;$i$54 = 0;
      while(1) {
       $168 = (((($1)) + 1824|0) + ($i$54<<2)|0);
       $169 = HEAP32[$168>>2]|0;
       $170 = ($169|0)==(0|0);
       if ($170) {
        $173 = $175;
       } else {
        _vorbis_staticbook_destroy($169);
        HEAP32[$168>>2] = 0;
        $$pre30 = HEAP32[$87>>2]|0;
        $173 = $$pre30;
       }
       $171 = (($i$54) + 1)|0;
       $172 = ($171|0)<($173|0);
       if ($172) {
        $175 = $173;$i$54 = $171;
       } else {
        break;
       }
      }
     }
     _vorbis_dsp_clear($v);
     $$0 = -1;
     return ($$0|0);
    }
   }
  } else {
   $41 = ((($13)) + 20|0);
   $42 = HEAP32[$1>>2]|0;
   _drft_init($41,$42);
   $43 = ((($13)) + 32|0);
   $44 = HEAP32[$8>>2]|0;
   _drft_init($43,$44);
   $45 = ((($1)) + 2848|0);
   $46 = HEAP32[$45>>2]|0;
   $47 = ($46|0)==(0|0);
   if ($47) {
    $48 = ((($1)) + 24|0);
    $49 = HEAP32[$48>>2]|0;
    $50 = (_calloc($49,56)|0);
    HEAP32[$45>>2] = $50;
    $51 = HEAP32[$48>>2]|0;
    $52 = ($51|0)>(0);
    if ($52) {
     $53 = ((($1)) + 1824|0);
     $54 = HEAP32[$53>>2]|0;
     (_vorbis_book_init_encode($50,$54)|0);
     $55 = HEAP32[$48>>2]|0;
     $56 = ($55|0)>(1);
     if ($56) {
      $58 = 1;
      while(1) {
       $$pre = HEAP32[$45>>2]|0;
       $57 = (($$pre) + (($58*56)|0)|0);
       $59 = (((($1)) + 1824|0) + ($58<<2)|0);
       $60 = HEAP32[$59>>2]|0;
       (_vorbis_book_init_encode($57,$60)|0);
       $61 = (($58) + 1)|0;
       $62 = HEAP32[$48>>2]|0;
       $63 = ($61|0)<($62|0);
       if ($63) {
        $58 = $61;
       } else {
        break;
       }
      }
     }
    }
   }
   $64 = ((($1)) + 28|0);
   $65 = HEAP32[$64>>2]|0;
   $66 = (_calloc($65,52)|0);
   $67 = ((($13)) + 56|0);
   HEAP32[$67>>2] = $66;
   $68 = HEAP32[$64>>2]|0;
   $69 = ($68|0)>(0);
   L38: do {
    if ($69) {
     $70 = ((($1)) + 2868|0);
     $71 = ((($vi)) + 8|0);
     $73 = $66;$i$117 = 0;
     while(1) {
      $72 = (($73) + (($i$117*52)|0)|0);
      $74 = (((($1)) + 2852|0) + ($i$117<<2)|0);
      $75 = HEAP32[$74>>2]|0;
      $76 = HEAP32[$75>>2]|0;
      $77 = (($1) + ($76<<2)|0);
      $78 = HEAP32[$77>>2]|0;
      $79 = (($78|0) / 2)&-1;
      $80 = HEAP32[$71>>2]|0;
      __vp_psy_init($72,$75,$70,$79,$80);
      $81 = (($i$117) + 1)|0;
      $82 = HEAP32[$64>>2]|0;
      $83 = ($81|0)<($82|0);
      if (!($83)) {
       break L38;
      }
      $$pre26 = HEAP32[$67>>2]|0;
      $73 = $$pre26;$i$117 = $81;
     }
    }
   } while(0);
   HEAP32[$v>>2] = 1;
  }
 } while(0);
 $105 = HEAP32[$8>>2]|0;
 $106 = ((($v)) + 16|0);
 HEAP32[$106>>2] = $105;
 $107 = ((($vi)) + 4|0);
 $108 = HEAP32[$107>>2]|0;
 $109 = $108 << 2;
 $110 = (_malloc($109)|0);
 $111 = ((($v)) + 8|0);
 HEAP32[$111>>2] = $110;
 $112 = (_malloc($109)|0);
 $113 = ((($v)) + 12|0);
 HEAP32[$113>>2] = $112;
 $114 = ($108|0)>(0);
 if ($114) {
  $115 = (_calloc($105,4)|0);
  HEAP32[$110>>2] = $115;
  $116 = ($108|0)>(1);
  if ($116) {
   $119 = 1;
   while(1) {
    $$pre28 = HEAP32[$111>>2]|0;
    $117 = (_calloc($105,4)|0);
    $118 = (($$pre28) + ($119<<2)|0);
    HEAP32[$118>>2] = $117;
    $120 = (($119) + 1)|0;
    $121 = ($120|0)<($108|0);
    if ($121) {
     $119 = $120;
    } else {
     break;
    }
   }
  }
 }
 $122 = ((($v)) + 36|0);
 HEAP32[$122>>2] = 0;
 $123 = ((($v)) + 40|0);
 HEAP32[$123>>2] = 0;
 $124 = HEAP32[$8>>2]|0;
 $125 = (($124|0) / 2)&-1;
 $126 = ((($v)) + 48|0);
 HEAP32[$126>>2] = $125;
 $127 = ((($v)) + 20|0);
 HEAP32[$127>>2] = $125;
 $128 = ((($1)) + 16|0);
 $129 = HEAP32[$128>>2]|0;
 $130 = (_calloc($129,4)|0);
 $131 = ((($13)) + 48|0);
 HEAP32[$131>>2] = $130;
 $132 = ((($1)) + 20|0);
 $133 = HEAP32[$132>>2]|0;
 $134 = (_calloc($133,4)|0);
 $135 = ((($13)) + 52|0);
 HEAP32[$135>>2] = $134;
 $136 = HEAP32[$128>>2]|0;
 $137 = ($136|0)>(0);
 if ($137) {
  $i$37 = 0;
  while(1) {
   $140 = (((($1)) + 800|0) + ($i$37<<2)|0);
   $141 = HEAP32[$140>>2]|0;
   $142 = (25640 + ($141<<2)|0);
   $143 = HEAP32[$142>>2]|0;
   $144 = ((($143)) + 8|0);
   $145 = HEAP32[$144>>2]|0;
   $146 = (((($1)) + 1056|0) + ($i$37<<2)|0);
   $147 = HEAP32[$146>>2]|0;
   $148 = (FUNCTION_TABLE_iii[$145 & 15]($v,$147)|0);
   $149 = HEAP32[$131>>2]|0;
   $150 = (($149) + ($i$37<<2)|0);
   HEAP32[$150>>2] = $148;
   $151 = (($i$37) + 1)|0;
   $152 = HEAP32[$128>>2]|0;
   $153 = ($151|0)<($152|0);
   if ($153) {
    $i$37 = $151;
   } else {
    break;
   }
  }
 }
 $138 = HEAP32[$132>>2]|0;
 $139 = ($138|0)>(0);
 if ($139) {
  $i$45 = 0;
 } else {
  $$0 = 0;
  return ($$0|0);
 }
 while(1) {
  $154 = (((($1)) + 1312|0) + ($i$45<<2)|0);
  $155 = HEAP32[$154>>2]|0;
  $156 = (25648 + ($155<<2)|0);
  $157 = HEAP32[$156>>2]|0;
  $158 = ((($157)) + 8|0);
  $159 = HEAP32[$158>>2]|0;
  $160 = (((($1)) + 1568|0) + ($i$45<<2)|0);
  $161 = HEAP32[$160>>2]|0;
  $162 = (FUNCTION_TABLE_iii[$159 & 15]($v,$161)|0);
  $163 = HEAP32[$135>>2]|0;
  $164 = (($163) + ($i$45<<2)|0);
  HEAP32[$164>>2] = $162;
  $165 = (($i$45) + 1)|0;
  $166 = HEAP32[$132>>2]|0;
  $167 = ($165|0)<($166|0);
  if ($167) {
   $i$45 = $165;
  } else {
   $$0 = 0;
   break;
  }
 }
 return ($$0|0);
}
function __preextrapolate_helper($v) {
 $v = $v|0;
 var $$alloca_mul = 0, $$sum = 0, $$sum1 = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0;
 var $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0;
 var $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $i$08 = 0, $j$03 = 0, $j$14 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0;
 $0 = sp;
 $1 = ((($v)) + 20|0);
 $2 = HEAP32[$1>>2]|0;
 $3 = $2 << 2;
 $$alloca_mul = $3;
 $4 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul)|0)+15)&-16)|0;;
 $5 = ((($v)) + 28|0);
 HEAP32[$5>>2] = 1;
 $6 = ((($v)) + 48|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = (($2) - ($7))|0;
 $9 = ($8|0)>(32);
 if (!($9)) {
  STACKTOP = sp;return;
 }
 $10 = ((($v)) + 4|0);
 $11 = HEAP32[$10>>2]|0;
 $12 = ((($11)) + 4|0);
 $13 = HEAP32[$12>>2]|0;
 $14 = ($13|0)>(0);
 if (!($14)) {
  STACKTOP = sp;return;
 }
 $15 = ((($v)) + 8|0);
 $16 = $2;$i$08 = 0;
 while(1) {
  $17 = ($16|0)>(0);
  if ($17) {
   $18 = HEAP32[$15>>2]|0;
   $19 = (($18) + ($i$08<<2)|0);
   $20 = HEAP32[$19>>2]|0;
   $j$03 = 0;
   while(1) {
    $21 = $j$03 ^ -1;
    $22 = (($16) + ($21))|0;
    $23 = (($20) + ($22<<2)|0);
    $24 = HEAP32[$23>>2]|0;
    $25 = (($4) + ($j$03<<2)|0);
    HEAP32[$25>>2] = $24;
    $26 = (($j$03) + 1)|0;
    $27 = ($16|0)>($26|0);
    if ($27) {
     $j$03 = $26;
    } else {
     break;
    }
   }
  }
  $28 = HEAP32[$6>>2]|0;
  $29 = (($16) - ($28))|0;
  (+_vorbis_lpc_from_data($4,$0,$29,16));
  $30 = HEAP32[$1>>2]|0;
  $31 = HEAP32[$6>>2]|0;
  $$sum = (($30) - ($31))|0;
  $32 = (($4) + ($$sum<<2)|0);
  $$sum1 = (($$sum) + -16)|0;
  $33 = (($4) + ($$sum1<<2)|0);
  _vorbis_lpc_predict($0,$33,16,$32,$31);
  $34 = HEAP32[$1>>2]|0;
  $35 = ($34|0)>(0);
  if ($35) {
   $36 = HEAP32[$15>>2]|0;
   $37 = (($36) + ($i$08<<2)|0);
   $38 = HEAP32[$37>>2]|0;
   $j$14 = 0;
   while(1) {
    $39 = (($4) + ($j$14<<2)|0);
    $40 = HEAP32[$39>>2]|0;
    $41 = $j$14 ^ -1;
    $42 = (($34) + ($41))|0;
    $43 = (($38) + ($42<<2)|0);
    HEAP32[$43>>2] = $40;
    $44 = (($j$14) + 1)|0;
    $45 = ($34|0)>($44|0);
    if ($45) {
     $j$14 = $44;
    } else {
     break;
    }
   }
  }
  $46 = (($i$08) + 1)|0;
  $47 = HEAP32[$10>>2]|0;
  $48 = ((($47)) + 4|0);
  $49 = HEAP32[$48>>2]|0;
  $50 = ($46|0)<($49|0);
  if ($50) {
   $16 = $34;$i$08 = $46;
  } else {
   break;
  }
 }
 STACKTOP = sp;return;
}
function _vorbis_staticbook_pack($c,$opb) {
 $c = $c|0;
 $opb = $opb|0;
 var $$0 = 0, $$lcssa = 0, $$pre = 0, $$pre49$pre = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0;
 var $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0;
 var $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0;
 var $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0;
 var $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0;
 var $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $count$0$lcssa = 0, $count$08 = 0, $count$16 = 0, $count$2 = 0, $exitcond = 0, $exitcond45 = 0, $i$0$lcssa = 0, $i$029 = 0, $i$1$lcssa = 0, $i$19 = 0;
 var $i$2$lcssa = 0, $i$222 = 0, $i$316 = 0, $i$419 = 0, $i$54 = 0, $ispos = 0, $j$05 = 0, $neg = 0, $quantvals$0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 _oggpack_write($opb,5653314,24);
 $0 = HEAP32[$c>>2]|0;
 _oggpack_write($opb,$0,16);
 $1 = ((($c)) + 4|0);
 $2 = HEAP32[$1>>2]|0;
 _oggpack_write($opb,$2,24);
 $3 = HEAP32[$1>>2]|0;
 $4 = ($3|0)>(1);
 L1: do {
  if ($4) {
   $5 = ((($c)) + 8|0);
   $6 = HEAP32[$5>>2]|0;
   $$pre = HEAP8[$6>>0]|0;
   $7 = $$pre;$i$029 = 1;
   while(1) {
    $8 = ($7<<24>>24)==(0);
    if ($8) {
     $i$0$lcssa = $i$029;
     break L1;
    }
    $9 = (($6) + ($i$029)|0);
    $10 = HEAP8[$9>>0]|0;
    $11 = ($10<<24>>24)<($7<<24>>24);
    if ($11) {
     $i$0$lcssa = $i$029;
     break L1;
    }
    $12 = (($i$029) + 1)|0;
    $13 = ($12|0)<($3|0);
    if ($13) {
     $7 = $10;$i$029 = $12;
    } else {
     $i$0$lcssa = $12;
     break;
    }
   }
  } else {
   $i$0$lcssa = 1;
  }
 } while(0);
 $14 = ($i$0$lcssa|0)==($3|0);
 L8: do {
  if ($14) {
   _oggpack_write($opb,1,1);
   $15 = ((($c)) + 8|0);
   $16 = HEAP32[$15>>2]|0;
   $17 = HEAP8[$16>>0]|0;
   $18 = $17 << 24 >> 24;
   $19 = (($18) + -1)|0;
   _oggpack_write($opb,$19,5);
   $20 = HEAP32[$1>>2]|0;
   $21 = ($20|0)>(1);
   if ($21) {
    $105 = $20;$count$08 = 0;$i$19 = 1;
    while(1) {
     $22 = HEAP32[$15>>2]|0;
     $23 = (($22) + ($i$19)|0);
     $24 = HEAP8[$23>>0]|0;
     $25 = (($i$19) + -1)|0;
     $26 = (($22) + ($25)|0);
     $27 = HEAP8[$26>>0]|0;
     $28 = ($24<<24>>24)>($27<<24>>24);
     if ($28) {
      $29 = $27 << 24 >> 24;
      $30 = $24 << 24 >> 24;
      $33 = $105;$count$16 = $count$08;$j$05 = $29;
      while(1) {
       $31 = (($i$19) - ($count$16))|0;
       $32 = (($33) - ($count$16))|0;
       $34 = (_ov_ilog($32)|0);
       _oggpack_write($opb,$31,$34);
       $35 = (($j$05) + 1)|0;
       $exitcond45 = ($35|0)==($30|0);
       $$pre49$pre = HEAP32[$1>>2]|0;
       if ($exitcond45) {
        $38 = $$pre49$pre;$count$2 = $i$19;
        break;
       } else {
        $33 = $$pre49$pre;$count$16 = $i$19;$j$05 = $35;
       }
      }
     } else {
      $38 = $105;$count$2 = $count$08;
     }
     $36 = (($i$19) + 1)|0;
     $37 = ($36|0)<($38|0);
     if ($37) {
      $105 = $38;$count$08 = $count$2;$i$19 = $36;
     } else {
      $$lcssa = $38;$count$0$lcssa = $count$2;$i$1$lcssa = $36;
      break;
     }
    }
   } else {
    $$lcssa = $20;$count$0$lcssa = 0;$i$1$lcssa = 1;
   }
   $39 = (($i$1$lcssa) - ($count$0$lcssa))|0;
   $40 = (($$lcssa) - ($count$0$lcssa))|0;
   $41 = (_ov_ilog($40)|0);
   _oggpack_write($opb,$39,$41);
  } else {
   _oggpack_write($opb,0,1);
   $42 = HEAP32[$1>>2]|0;
   $43 = ($42|0)>(0);
   L20: do {
    if ($43) {
     $44 = ((($c)) + 8|0);
     $45 = HEAP32[$44>>2]|0;
     $i$222 = 0;
     while(1) {
      $46 = (($45) + ($i$222)|0);
      $47 = HEAP8[$46>>0]|0;
      $48 = ($47<<24>>24)==(0);
      if ($48) {
       $i$2$lcssa = $i$222;
       break L20;
      }
      $49 = (($i$222) + 1)|0;
      $50 = ($49|0)<($42|0);
      if ($50) {
       $i$222 = $49;
      } else {
       $i$2$lcssa = $49;
       break;
      }
     }
    } else {
     $i$2$lcssa = 0;
    }
   } while(0);
   $51 = ($i$2$lcssa|0)==($42|0);
   if ($51) {
    _oggpack_write($opb,0,1);
    $52 = HEAP32[$1>>2]|0;
    $53 = ($52|0)>(0);
    if (!($53)) {
     break;
    }
    $54 = ((($c)) + 8|0);
    $i$316 = 0;
    while(1) {
     $55 = HEAP32[$54>>2]|0;
     $56 = (($55) + ($i$316)|0);
     $57 = HEAP8[$56>>0]|0;
     $58 = $57 << 24 >> 24;
     $59 = (($58) + -1)|0;
     _oggpack_write($opb,$59,5);
     $60 = (($i$316) + 1)|0;
     $61 = HEAP32[$1>>2]|0;
     $62 = ($60|0)<($61|0);
     if ($62) {
      $i$316 = $60;
     } else {
      break L8;
     }
    }
   }
   _oggpack_write($opb,1,1);
   $63 = HEAP32[$1>>2]|0;
   $64 = ($63|0)>(0);
   if ($64) {
    $65 = ((($c)) + 8|0);
    $i$419 = 0;
    while(1) {
     $66 = HEAP32[$65>>2]|0;
     $67 = (($66) + ($i$419)|0);
     $68 = HEAP8[$67>>0]|0;
     $69 = ($68<<24>>24)==(0);
     if ($69) {
      _oggpack_write($opb,0,1);
     } else {
      _oggpack_write($opb,1,1);
      $70 = HEAP32[$65>>2]|0;
      $71 = (($70) + ($i$419)|0);
      $72 = HEAP8[$71>>0]|0;
      $73 = $72 << 24 >> 24;
      $74 = (($73) + -1)|0;
      _oggpack_write($opb,$74,5);
     }
     $75 = (($i$419) + 1)|0;
     $76 = HEAP32[$1>>2]|0;
     $77 = ($75|0)<($76|0);
     if ($77) {
      $i$419 = $75;
     } else {
      break;
     }
    }
   }
  }
 } while(0);
 $78 = ((($c)) + 12|0);
 $79 = HEAP32[$78>>2]|0;
 _oggpack_write($opb,$79,4);
 $80 = HEAP32[$78>>2]|0;
 if ((($80|0) == 2) | (($80|0) == 1)) {
  label = 28;
 } else if (!((($80|0) == 0))) {
  $$0 = -1;
  return ($$0|0);
 }
 do {
  if ((label|0) == 28) {
   $81 = ((($c)) + 32|0);
   $82 = HEAP32[$81>>2]|0;
   $83 = ($82|0)==(0|0);
   if ($83) {
    $$0 = -1;
    return ($$0|0);
   }
   $84 = ((($c)) + 16|0);
   $85 = HEAP32[$84>>2]|0;
   _oggpack_write($opb,$85,32);
   $86 = ((($c)) + 20|0);
   $87 = HEAP32[$86>>2]|0;
   _oggpack_write($opb,$87,32);
   $88 = ((($c)) + 24|0);
   $89 = HEAP32[$88>>2]|0;
   $90 = (($89) + -1)|0;
   _oggpack_write($opb,$90,4);
   $91 = ((($c)) + 28|0);
   $92 = HEAP32[$91>>2]|0;
   _oggpack_write($opb,$92,1);
   $93 = HEAP32[$78>>2]|0;
   if ((($93|0) == 1)) {
    $94 = (__book_maptype1_quantvals($c)|0);
    $quantvals$0 = $94;
   } else if ((($93|0) == 2)) {
    $95 = HEAP32[$1>>2]|0;
    $96 = HEAP32[$c>>2]|0;
    $97 = Math_imul($96, $95)|0;
    $quantvals$0 = $97;
   } else {
    break;
   }
   $98 = ($quantvals$0|0)>(0);
   if ($98) {
    $i$54 = 0;
    while(1) {
     $99 = HEAP32[$81>>2]|0;
     $100 = (($99) + ($i$54<<2)|0);
     $101 = HEAP32[$100>>2]|0;
     $ispos = ($101|0)>(-1);
     $neg = (0 - ($101))|0;
     $102 = $ispos ? $101 : $neg;
     $103 = HEAP32[$88>>2]|0;
     _oggpack_write($opb,$102,$103);
     $104 = (($i$54) + 1)|0;
     $exitcond = ($104|0)==($quantvals$0|0);
     if ($exitcond) {
      break;
     } else {
      $i$54 = $104;
     }
    }
   }
  }
 } while(0);
 $$0 = 0;
 return ($$0|0);
}
function _vorbis_book_encode($book,$a,$b) {
 $book = $book|0;
 $a = $a|0;
 $b = $b|0;
 var $$0 = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0;
 var $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ($a|0)<(0);
 if ($0) {
  $$0 = 0;
  return ($$0|0);
 }
 $1 = ((($book)) + 12|0);
 $2 = HEAP32[$1>>2]|0;
 $3 = ((($2)) + 4|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = ($4|0)>($a|0);
 if (!($5)) {
  $$0 = 0;
  return ($$0|0);
 }
 $6 = ((($book)) + 20|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = (($7) + ($a<<2)|0);
 $9 = HEAP32[$8>>2]|0;
 $10 = ((($2)) + 8|0);
 $11 = HEAP32[$10>>2]|0;
 $12 = (($11) + ($a)|0);
 $13 = HEAP8[$12>>0]|0;
 $14 = $13 << 24 >> 24;
 _oggpack_write($b,$9,$14);
 $15 = HEAP32[$1>>2]|0;
 $16 = ((($15)) + 8|0);
 $17 = HEAP32[$16>>2]|0;
 $18 = (($17) + ($a)|0);
 $19 = HEAP8[$18>>0]|0;
 $20 = $19 << 24 >> 24;
 $$0 = $20;
 return ($$0|0);
}
function _vorbis_book_decode($book,$b) {
 $book = $book|0;
 $b = $b|0;
 var $$0 = 0, $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($book)) + 8|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ($1|0)>(0);
 if (!($2)) {
  $$0 = -1;
  return ($$0|0);
 }
 $3 = (_decode_packed_entry_number($book,$b)|0);
 $4 = ($3|0)>(-1);
 if (!($4)) {
  $$0 = -1;
  return ($$0|0);
 }
 $5 = ((($book)) + 24|0);
 $6 = HEAP32[$5>>2]|0;
 $7 = (($6) + ($3<<2)|0);
 $8 = HEAP32[$7>>2]|0;
 $$0 = $8;
 return ($$0|0);
}
function _vorbis_book_decodevs_add($book,$a,$b,$n) {
 $book = $book|0;
 $a = $a|0;
 $b = $b|0;
 $n = $n|0;
 var $$0 = 0, $$alloca_mul = 0, $$not = 0, $$not10 = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0.0, $17 = 0, $18 = 0, $19 = 0.0, $2 = 0, $20 = 0.0, $21 = 0, $22 = 0;
 var $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $brmerge = 0, $exitcond = 0, $i$06 = 0, $i$14$us = 0, $j$03$us = 0;
 var $o$05$us = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($book)) + 8|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ($1|0)>(0);
 if (!($2)) {
  $$0 = 0;
  STACKTOP = sp;return ($$0|0);
 }
 $3 = HEAP32[$book>>2]|0;
 $4 = (($n|0) / ($3|0))&-1;
 $5 = $4 << 2;
 $$alloca_mul = $5;
 $6 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul)|0)+15)&-16)|0;;
 $7 = ($4|0)>(0);
 L4: do {
  if ($7) {
   $8 = ((($book)) + 16|0);
   $i$06 = 0;
   while(1) {
    $22 = (_decode_packed_entry_number($book,$b)|0);
    $23 = ($22|0)==(-1);
    if ($23) {
     $$0 = -1;
     break;
    }
    $24 = HEAP32[$8>>2]|0;
    $25 = HEAP32[$book>>2]|0;
    $26 = Math_imul($25, $22)|0;
    $27 = (($24) + ($26<<2)|0);
    $28 = (($6) + ($i$06<<2)|0);
    HEAP32[$28>>2] = $27;
    $29 = (($i$06) + 1)|0;
    $30 = ($29|0)<($4|0);
    if ($30) {
     $i$06 = $29;
    } else {
     $9 = $25;
     break L4;
    }
   }
   STACKTOP = sp;return ($$0|0);
  } else {
   $9 = $3;
  }
 } while(0);
 $$not = ($9|0)<(1);
 $$not10 = $7 ^ 1;
 $brmerge = $$not | $$not10;
 if ($brmerge) {
  $$0 = 0;
  STACKTOP = sp;return ($$0|0);
 } else {
  $i$14$us = 0;$o$05$us = 0;
 }
 while(1) {
  $j$03$us = 0;
  while(1) {
   $13 = (($6) + ($j$03$us<<2)|0);
   $14 = HEAP32[$13>>2]|0;
   $15 = (($14) + ($i$14$us<<2)|0);
   $16 = +HEAPF32[$15>>2];
   $17 = (($j$03$us) + ($o$05$us))|0;
   $18 = (($a) + ($17<<2)|0);
   $19 = +HEAPF32[$18>>2];
   $20 = $19 + $16;
   HEAPF32[$18>>2] = $20;
   $21 = (($j$03$us) + 1)|0;
   $exitcond = ($21|0)==($4|0);
   if ($exitcond) {
    break;
   } else {
    $j$03$us = $21;
   }
  }
  $10 = (($i$14$us) + 1)|0;
  $11 = (($o$05$us) + ($4))|0;
  $12 = ($10|0)<($9|0);
  if ($12) {
   $i$14$us = $10;$o$05$us = $11;
  } else {
   $$0 = 0;
   break;
  }
 }
 STACKTOP = sp;return ($$0|0);
}
function _vorbis_book_decodev_add($book,$a,$b,$n) {
 $book = $book|0;
 $a = $a|0;
 $b = $b|0;
 $n = $n|0;
 var $$0 = 0, $$lcssa = 0, $$lcssa134 = 0, $$lcssa135 = 0, $$lcssa136 = 0, $$lcssa137 = 0, $$lcssa138 = 0, $$lcssa139 = 0, $$lcssa140 = 0, $$lcssa142 = 0, $$lcssa143 = 0, $$lcssa144 = 0, $$lcssa145 = 0, $$lcssa146 = 0, $$lcssa147 = 0, $$sum = 0, $$sum1 = 0, $$sum2 = 0, $$sum3 = 0, $$sum4 = 0;
 var $$sum5 = 0, $$sum6 = 0, $$sum7 = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0.0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0;
 var $19 = 0, $2 = 0, $20 = 0.0, $21 = 0, $22 = 0, $23 = 0.0, $24 = 0.0, $25 = 0, $26 = 0, $27 = 0, $28 = 0.0, $29 = 0, $3 = 0, $30 = 0, $31 = 0.0, $32 = 0.0, $33 = 0, $34 = 0, $35 = 0, $36 = 0;
 var $37 = 0, $38 = 0.0, $39 = 0, $4 = 0, $40 = 0, $41 = 0.0, $42 = 0.0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0.0, $49 = 0, $5 = 0, $50 = 0, $51 = 0.0, $52 = 0.0, $53 = 0, $54 = 0;
 var $55 = 0, $56 = 0, $57 = 0, $58 = 0.0, $59 = 0, $6 = 0, $60 = 0, $61 = 0.0, $62 = 0.0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0.0, $69 = 0, $7 = 0, $70 = 0, $71 = 0.0, $72 = 0.0;
 var $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0.0, $79 = 0, $8 = 0, $80 = 0, $81 = 0.0, $82 = 0.0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0.0, $89 = 0, $9 = 0, $90 = 0;
 var $91 = 0.0, $92 = 0.0, $93 = 0, $94 = 0, $95 = 0, $96 = 0.0, $97 = 0, $98 = 0, $99 = 0.0, $i$036 = 0, $i$1$lcssa = 0, $i$134 = 0, $i$2$ph116 = 0, $i$3 = 0, $i$4 = 0, $i$5 = 0, $i$6 = 0, $i$7 = 0, $i$8 = 0, $i$9 = 0;
 var $j$035 = 0, $j$1 = 0, $j$2 = 0, $j$3 = 0, $j$4 = 0, $j$5 = 0, $j$6 = 0, $j$7 = 0, $smax = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($book)) + 8|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ($1|0)>(0);
 if (!($2)) {
  $$0 = 0;
  return ($$0|0);
 }
 $3 = HEAP32[$book>>2]|0;
 $4 = ($3|0)>(8);
 if ($4) {
  $7 = ($n|0)>(0);
  if (!($7)) {
   $$0 = 0;
   return ($$0|0);
  }
  $8 = ((($book)) + 16|0);
  $i$036 = 0;
  while(1) {
   $11 = (_decode_packed_entry_number($book,$b)|0);
   $12 = ($11|0)==(-1);
   if ($12) {
    $$0 = -1;
    label = 29;
    break;
   }
   $13 = HEAP32[$8>>2]|0;
   $14 = HEAP32[$book>>2]|0;
   $15 = Math_imul($14, $11)|0;
   $16 = ($14|0)>(0);
   if ($16) {
    $17 = ($14|0)>(1);
    $smax = $17 ? $14 : 1;
    $i$134 = $i$036;$j$035 = 0;
    while(1) {
     $18 = (($j$035) + 1)|0;
     $$sum7 = (($j$035) + ($15))|0;
     $19 = (($13) + ($$sum7<<2)|0);
     $20 = +HEAPF32[$19>>2];
     $21 = (($i$134) + 1)|0;
     $22 = (($a) + ($i$134<<2)|0);
     $23 = +HEAPF32[$22>>2];
     $24 = $23 + $20;
     HEAPF32[$22>>2] = $24;
     $25 = ($18|0)<($14|0);
     if ($25) {
      $i$134 = $21;$j$035 = $18;
     } else {
      break;
     }
    }
    $9 = (($i$036) + ($smax))|0;
    $i$1$lcssa = $9;
   } else {
    $i$1$lcssa = $i$036;
   }
   $10 = ($i$1$lcssa|0)<($n|0);
   if ($10) {
    $i$036 = $i$1$lcssa;
   } else {
    $$0 = 0;
    label = 29;
    break;
   }
  }
  if ((label|0) == 29) {
   return ($$0|0);
  }
 }
 $5 = ((($book)) + 16|0);
 $6 = ($n|0)>(0);
 if ($6) {
  $i$2$ph116 = 0;
 } else {
  $$0 = 0;
  return ($$0|0);
 }
 L24: while(1) {
  L26: while(1) {
   $102 = (_decode_packed_entry_number($book,$b)|0);
   $103 = ($102|0)==(-1);
   if ($103) {
    $$0 = -1;
    label = 29;
    break L24;
   }
   $104 = HEAP32[$5>>2]|0;
   $105 = HEAP32[$book>>2]|0;
   switch ($105|0) {
   case 4:  {
    $$lcssa138 = $102;$$lcssa145 = $104;
    label = 19;
    break L26;
    break;
   }
   case 3:  {
    $$lcssa139 = $102;$$lcssa146 = $104;
    label = 21;
    break L26;
    break;
   }
   case 7:  {
    $$lcssa135 = $102;$$lcssa142 = $104;
    label = 13;
    break L26;
    break;
   }
   case 6:  {
    $$lcssa136 = $102;$$lcssa143 = $104;
    label = 15;
    break L26;
    break;
   }
   case 8:  {
    $$lcssa = $104;$$lcssa134 = $102;
    label = 12;
    break L26;
    break;
   }
   case 5:  {
    $$lcssa137 = $102;$$lcssa144 = $104;
    label = 17;
    break L26;
    break;
   }
   case 1:  {
    $93 = $102;$95 = $104;$i$9 = $i$2$ph116;$j$7 = 0;
    break L26;
    break;
   }
   case 2:  {
    $$lcssa140 = $102;$$lcssa147 = $104;
    label = 23;
    break L26;
    break;
   }
   default: {
   }
   }
  }
  if ((label|0) == 12) {
   label = 0;
   $26 = $$lcssa134 << 3;
   $27 = (($$lcssa) + ($26<<2)|0);
   $28 = +HEAPF32[$27>>2];
   $29 = (($i$2$ph116) + 1)|0;
   $30 = (($a) + ($i$2$ph116<<2)|0);
   $31 = +HEAPF32[$30>>2];
   $32 = $31 + $28;
   HEAPF32[$30>>2] = $32;
   $35 = $26;$37 = $$lcssa;$i$3 = $29;$j$1 = 1;
   label = 14;
  }
  else if ((label|0) == 13) {
   label = 0;
   $33 = ($$lcssa135*7)|0;
   $35 = $33;$37 = $$lcssa142;$i$3 = $i$2$ph116;$j$1 = 0;
   label = 14;
  }
  else if ((label|0) == 15) {
   label = 0;
   $43 = ($$lcssa136*6)|0;
   $45 = $43;$47 = $$lcssa143;$i$4 = $i$2$ph116;$j$2 = 0;
   label = 16;
  }
  else if ((label|0) == 17) {
   label = 0;
   $53 = ($$lcssa137*5)|0;
   $55 = $53;$57 = $$lcssa144;$i$5 = $i$2$ph116;$j$3 = 0;
   label = 18;
  }
  else if ((label|0) == 19) {
   label = 0;
   $63 = $$lcssa138 << 2;
   $65 = $63;$67 = $$lcssa145;$i$6 = $i$2$ph116;$j$4 = 0;
   label = 20;
  }
  else if ((label|0) == 21) {
   label = 0;
   $73 = ($$lcssa139*3)|0;
   $75 = $73;$77 = $$lcssa146;$i$7 = $i$2$ph116;$j$5 = 0;
   label = 22;
  }
  else if ((label|0) == 23) {
   label = 0;
   $83 = $$lcssa140 << 1;
   $85 = $83;$87 = $$lcssa147;$i$8 = $i$2$ph116;$j$6 = 0;
   label = 24;
  }
  if ((label|0) == 14) {
   label = 0;
   $34 = (($j$1) + 1)|0;
   $$sum6 = (($j$1) + ($35))|0;
   $36 = (($37) + ($$sum6<<2)|0);
   $38 = +HEAPF32[$36>>2];
   $39 = (($i$3) + 1)|0;
   $40 = (($a) + ($i$3<<2)|0);
   $41 = +HEAPF32[$40>>2];
   $42 = $41 + $38;
   HEAPF32[$40>>2] = $42;
   $45 = $35;$47 = $37;$i$4 = $39;$j$2 = $34;
   label = 16;
  }
  if ((label|0) == 16) {
   label = 0;
   $44 = (($j$2) + 1)|0;
   $$sum5 = (($j$2) + ($45))|0;
   $46 = (($47) + ($$sum5<<2)|0);
   $48 = +HEAPF32[$46>>2];
   $49 = (($i$4) + 1)|0;
   $50 = (($a) + ($i$4<<2)|0);
   $51 = +HEAPF32[$50>>2];
   $52 = $51 + $48;
   HEAPF32[$50>>2] = $52;
   $55 = $45;$57 = $47;$i$5 = $49;$j$3 = $44;
   label = 18;
  }
  if ((label|0) == 18) {
   label = 0;
   $54 = (($j$3) + 1)|0;
   $$sum4 = (($j$3) + ($55))|0;
   $56 = (($57) + ($$sum4<<2)|0);
   $58 = +HEAPF32[$56>>2];
   $59 = (($i$5) + 1)|0;
   $60 = (($a) + ($i$5<<2)|0);
   $61 = +HEAPF32[$60>>2];
   $62 = $61 + $58;
   HEAPF32[$60>>2] = $62;
   $65 = $55;$67 = $57;$i$6 = $59;$j$4 = $54;
   label = 20;
  }
  if ((label|0) == 20) {
   label = 0;
   $64 = (($j$4) + 1)|0;
   $$sum3 = (($j$4) + ($65))|0;
   $66 = (($67) + ($$sum3<<2)|0);
   $68 = +HEAPF32[$66>>2];
   $69 = (($i$6) + 1)|0;
   $70 = (($a) + ($i$6<<2)|0);
   $71 = +HEAPF32[$70>>2];
   $72 = $71 + $68;
   HEAPF32[$70>>2] = $72;
   $75 = $65;$77 = $67;$i$7 = $69;$j$5 = $64;
   label = 22;
  }
  if ((label|0) == 22) {
   label = 0;
   $74 = (($j$5) + 1)|0;
   $$sum2 = (($j$5) + ($75))|0;
   $76 = (($77) + ($$sum2<<2)|0);
   $78 = +HEAPF32[$76>>2];
   $79 = (($i$7) + 1)|0;
   $80 = (($a) + ($i$7<<2)|0);
   $81 = +HEAPF32[$80>>2];
   $82 = $81 + $78;
   HEAPF32[$80>>2] = $82;
   $85 = $75;$87 = $77;$i$8 = $79;$j$6 = $74;
   label = 24;
  }
  if ((label|0) == 24) {
   label = 0;
   $84 = (($j$6) + 1)|0;
   $$sum1 = (($j$6) + ($85))|0;
   $86 = (($87) + ($$sum1<<2)|0);
   $88 = +HEAPF32[$86>>2];
   $89 = (($i$8) + 1)|0;
   $90 = (($a) + ($i$8<<2)|0);
   $91 = +HEAPF32[$90>>2];
   $92 = $91 + $88;
   HEAPF32[$90>>2] = $92;
   $93 = $85;$95 = $87;$i$9 = $89;$j$7 = $84;
  }
  $$sum = (($j$7) + ($93))|0;
  $94 = (($95) + ($$sum<<2)|0);
  $96 = +HEAPF32[$94>>2];
  $97 = (($i$9) + 1)|0;
  $98 = (($a) + ($i$9<<2)|0);
  $99 = +HEAPF32[$98>>2];
  $100 = $99 + $96;
  HEAPF32[$98>>2] = $100;
  $101 = ($97|0)<($n|0);
  if ($101) {
   $i$2$ph116 = $97;
  } else {
   $$0 = 0;
   label = 29;
   break;
  }
 }
 if ((label|0) == 29) {
  return ($$0|0);
 }
 return (0)|0;
}
function _vorbis_book_decodevv_add($book,$a,$offset,$ch,$b,$n) {
 $book = $book|0;
 $a = $a|0;
 $offset = $offset|0;
 $ch = $ch|0;
 $b = $b|0;
 $n = $n|0;
 var $$ = 0, $$0 = 0, $$i$1 = 0, $$sum = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0.0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0.0, $22 = 0.0;
 var $23 = 0, $24 = 0, $25 = 0, $26 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $chptr$07 = 0, $chptr$1$lcssa = 0, $chptr$14 = 0, $i$06 = 0, $i$1$lcssa = 0, $i$13 = 0, $j$02 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($book)) + 8|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ($1|0)>(0);
 if (!($2)) {
  $$0 = 0;
  return ($$0|0);
 }
 $3 = (($offset|0) / ($ch|0))&-1;
 $4 = (($n) + ($offset))|0;
 $5 = (($4|0) / ($ch|0))&-1;
 $6 = ($3|0)<($5|0);
 if (!($6)) {
  $$0 = 0;
  return ($$0|0);
 }
 $7 = ((($book)) + 16|0);
 $chptr$07 = 0;$i$06 = $3;
 while(1) {
  $9 = (_decode_packed_entry_number($book,$b)|0);
  $10 = ($9|0)==(-1);
  if ($10) {
   $$0 = -1;
   label = 8;
   break;
  }
  $11 = HEAP32[$7>>2]|0;
  $12 = HEAP32[$book>>2]|0;
  $13 = Math_imul($12, $9)|0;
  $14 = ($12|0)>(0);
  if ($14) {
   $chptr$14 = $chptr$07;$i$13 = $i$06;$j$02 = 0;
   while(1) {
    $$sum = (($j$02) + ($13))|0;
    $15 = (($11) + ($$sum<<2)|0);
    $16 = +HEAPF32[$15>>2];
    $17 = (($chptr$14) + 1)|0;
    $18 = (($a) + ($chptr$14<<2)|0);
    $19 = HEAP32[$18>>2]|0;
    $20 = (($19) + ($i$13<<2)|0);
    $21 = +HEAPF32[$20>>2];
    $22 = $21 + $16;
    HEAPF32[$20>>2] = $22;
    $23 = ($17|0)==($ch|0);
    $24 = $23&1;
    $$i$1 = (($24) + ($i$13))|0;
    $$ = $23 ? 0 : $17;
    $25 = (($j$02) + 1)|0;
    $26 = ($25|0)<($12|0);
    if ($26) {
     $chptr$14 = $$;$i$13 = $$i$1;$j$02 = $25;
    } else {
     $chptr$1$lcssa = $$;$i$1$lcssa = $$i$1;
     break;
    }
   }
  } else {
   $chptr$1$lcssa = $chptr$07;$i$1$lcssa = $i$06;
  }
  $8 = ($i$1$lcssa|0)<($5|0);
  if ($8) {
   $chptr$07 = $chptr$1$lcssa;$i$06 = $i$1$lcssa;
  } else {
   $$0 = 0;
   label = 8;
   break;
  }
 }
 if ((label|0) == 8) {
  return ($$0|0);
 }
 return (0)|0;
}
function _decode_packed_entry_number($book,$b) {
 $book = $book|0;
 $b = $b|0;
 var $$0 = 0, $$lcssa = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0;
 var $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0;
 var $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0;
 var $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $8 = 0;
 var $9 = 0, $hi$0 = 0, $hi$11 = 0, $lo$0 = 0, $lo$1$lcssa = 0, $lo$12 = 0, $lok$0$lcssa = 0, $read$0$lcssa = 0, $read$03 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($book)) + 40|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($book)) + 36|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = (_oggpack_look($b,$3)|0);
 $5 = ($4|0)>(-1);
 do {
  if ($5) {
   $6 = ((($book)) + 32|0);
   $7 = HEAP32[$6>>2]|0;
   $8 = (($7) + ($4<<2)|0);
   $9 = HEAP32[$8>>2]|0;
   $10 = ($9|0)<(0);
   if ($10) {
    $11 = $9 >>> 15;
    $12 = $11 & 32767;
    $13 = ((($book)) + 8|0);
    $14 = HEAP32[$13>>2]|0;
    $15 = $9 & 32767;
    $16 = (($14) - ($15))|0;
    $hi$0 = $16;$lo$0 = $12;
    break;
   }
   $17 = (($9) + -1)|0;
   $18 = ((($book)) + 28|0);
   $19 = HEAP32[$18>>2]|0;
   $20 = (($19) + ($17)|0);
   $21 = HEAP8[$20>>0]|0;
   $22 = $21 << 24 >> 24;
   _oggpack_adv($b,$22);
   $$0 = $17;
   return ($$0|0);
  } else {
   $23 = ((($book)) + 8|0);
   $24 = HEAP32[$23>>2]|0;
   $hi$0 = $24;$lo$0 = 0;
  }
 } while(0);
 $25 = (_oggpack_look($b,$1)|0);
 $26 = ($25|0)<(0);
 $27 = ($1|0)>(1);
 $28 = $26 & $27;
 if ($28) {
  $read$03 = $1;
  while(1) {
   $29 = (($read$03) + -1)|0;
   $30 = (_oggpack_look($b,$29)|0);
   $31 = ($30|0)<(0);
   $32 = ($29|0)>(1);
   $33 = $31 & $32;
   if ($33) {
    $read$03 = $29;
   } else {
    $$lcssa = $31;$lok$0$lcssa = $30;$read$0$lcssa = $29;
    break;
   }
  }
 } else {
  $$lcssa = $26;$lok$0$lcssa = $25;$read$0$lcssa = $1;
 }
 if ($$lcssa) {
  $$0 = -1;
  return ($$0|0);
 }
 $34 = $lok$0$lcssa >>> 16;
 $35 = $lok$0$lcssa << 16;
 $36 = $34 | $35;
 $37 = $36 >>> 8;
 $38 = $37 & 16711935;
 $39 = $36 << 8;
 $40 = $39 & -16711936;
 $41 = $38 | $40;
 $42 = $41 >>> 4;
 $43 = $42 & 252645135;
 $44 = $41 << 4;
 $45 = $44 & -252645136;
 $46 = $43 | $45;
 $47 = $46 >>> 2;
 $48 = $47 & 858993459;
 $49 = $46 << 2;
 $50 = $49 & -858993460;
 $51 = $48 | $50;
 $52 = $51 >>> 1;
 $53 = $52 & 1431655765;
 $54 = $51 << 1;
 $55 = $54 & -1431655766;
 $56 = $53 | $55;
 $57 = (($hi$0) - ($lo$0))|0;
 $58 = ($57|0)>(1);
 if ($58) {
  $59 = ((($book)) + 20|0);
  $60 = HEAP32[$59>>2]|0;
  $62 = $57;$hi$11 = $hi$0;$lo$12 = $lo$0;
  while(1) {
   $61 = $62 >> 1;
   $63 = (($61) + ($lo$12))|0;
   $64 = (($60) + ($63<<2)|0);
   $65 = HEAP32[$64>>2]|0;
   $66 = ($65>>>0)>($56>>>0);
   $67 = $66 ? 0 : $61;
   $68 = (($67) + ($lo$12))|0;
   $69 = $66 ? $61 : 0;
   $70 = (($hi$11) - ($69))|0;
   $71 = (($70) - ($68))|0;
   $72 = ($71|0)>(1);
   if ($72) {
    $62 = $71;$hi$11 = $70;$lo$12 = $68;
   } else {
    $lo$1$lcssa = $68;
    break;
   }
  }
 } else {
  $lo$1$lcssa = $lo$0;
 }
 $73 = ((($book)) + 28|0);
 $74 = HEAP32[$73>>2]|0;
 $75 = (($74) + ($lo$1$lcssa)|0);
 $76 = HEAP8[$75>>0]|0;
 $77 = $76 << 24 >> 24;
 $78 = ($77|0)>($read$0$lcssa|0);
 if ($78) {
  _oggpack_adv($b,$read$0$lcssa);
  $$0 = -1;
  return ($$0|0);
 } else {
  _oggpack_adv($b,$77);
  $$0 = $lo$1$lcssa;
  return ($$0|0);
 }
 return (0)|0;
}
function __ve_envelope_init($e,$vi) {
 $e = $e|0;
 $vi = $vi|0;
 var $$lcssa = 0.0, $$phi$trans$insert = 0, $$phi$trans$insert8 = 0, $$pre = 0, $$pre$phiZ2D = 0, $$pre9 = 0.0, $$promoted = 0.0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0.0, $19 = 0.0, $2 = 0;
 var $20 = 0.0, $21 = 0.0, $22 = 0, $23 = 0.0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0;
 var $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0.0, $45 = 0, $46 = 0.0, $47 = 0.0, $48 = 0.0, $49 = 0.0, $5 = 0, $50 = 0.0, $51 = 0.0, $52 = 0, $53 = 0.0, $54 = 0.0, $55 = 0, $56 = 0.0;
 var $57 = 0.0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $7 = 0, $8 = 0, $9 = 0, $exitcond = 0, $exitcond4 = 0, $exitcond5 = 0, $i$03 = 0, $i$11 = 0, $j$02 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($vi)) + 28|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($vi)) + 4|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ((($e)) + 4|0);
 HEAP32[$4>>2] = 128;
 $5 = ((($e)) + 8|0);
 HEAP32[$5>>2] = 64;
 $6 = ((($1)) + 2932|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = ((($e)) + 12|0);
 HEAP32[$8>>2] = $7;
 HEAP32[$e>>2] = $3;
 $9 = ((($e)) + 164|0);
 HEAP32[$9>>2] = 128;
 $10 = ((($1)) + 4|0);
 $11 = HEAP32[$10>>2]|0;
 $12 = (($11|0) / 2)&-1;
 $13 = ((($e)) + 176|0);
 HEAP32[$13>>2] = $12;
 $14 = (_calloc(128,4)|0);
 $15 = ((($e)) + 36|0);
 HEAP32[$15>>2] = $14;
 $16 = ((($e)) + 16|0);
 _mdct_init($16,128);
 $17 = HEAP32[$15>>2]|0;
 $i$03 = 0;
 while(1) {
  $18 = (+($i$03|0));
  $19 = $18 * 0.024736950028266088;
  $20 = (+Math_sin((+$19)));
  $21 = $20;
  $22 = (($17) + ($i$03<<2)|0);
  $23 = $21 * $21;
  HEAPF32[$22>>2] = $23;
  $24 = (($i$03) + 1)|0;
  $exitcond5 = ($24|0)==(128);
  if ($exitcond5) {
   break;
  } else {
   $i$03 = $24;
  }
 }
 $25 = ((($e)) + 40|0);
 HEAP32[$25>>2] = 2;
 $26 = ((($e)) + 44|0);
 HEAP32[$26>>2] = 4;
 $27 = ((($e)) + 56|0);
 HEAP32[$27>>2] = 4;
 $28 = ((($e)) + 60|0);
 HEAP32[$28>>2] = 5;
 $29 = ((($e)) + 72|0);
 HEAP32[$29>>2] = 6;
 $30 = ((($e)) + 76|0);
 HEAP32[$30>>2] = 6;
 $31 = ((($e)) + 88|0);
 HEAP32[$31>>2] = 9;
 $32 = ((($e)) + 92|0);
 HEAP32[$32>>2] = 8;
 $33 = ((($e)) + 104|0);
 HEAP32[$33>>2] = 13;
 $34 = ((($e)) + 108|0);
 HEAP32[$34>>2] = 8;
 $35 = ((($e)) + 120|0);
 HEAP32[$35>>2] = 17;
 $36 = ((($e)) + 124|0);
 HEAP32[$36>>2] = 8;
 $37 = ((($e)) + 136|0);
 HEAP32[$37>>2] = 22;
 $38 = ((($e)) + 140|0);
 HEAP32[$38>>2] = 8;
 $40 = 4;$j$02 = 0;
 while(1) {
  $39 = $40 << 2;
  $41 = (_malloc($39)|0);
  $42 = (((((($e)) + 40|0) + ($j$02<<4)|0)) + 8|0);
  HEAP32[$42>>2] = $41;
  $43 = ($40|0)>(0);
  if ($43) {
   $44 = (+($40|0));
   $45 = (((((($e)) + 40|0) + ($j$02<<4)|0)) + 12|0);
   $$promoted = +HEAPF32[$45>>2];
   $54 = $$promoted;$i$11 = 0;
   while(1) {
    $46 = (+($i$11|0));
    $47 = $46 + 0.5;
    $48 = $47 / $44;
    $49 = $48 * 3.1415926535897931;
    $50 = (+Math_sin((+$49)));
    $51 = $50;
    $52 = (($41) + ($i$11<<2)|0);
    HEAPF32[$52>>2] = $51;
    $53 = $54 + $51;
    $55 = (($i$11) + 1)|0;
    $exitcond = ($55|0)==($40|0);
    if ($exitcond) {
     $$lcssa = $53;
     break;
    } else {
     $54 = $53;$i$11 = $55;
    }
   }
   HEAPF32[$45>>2] = $$lcssa;
   $$pre$phiZ2D = $45;$57 = $$lcssa;
  } else {
   $$phi$trans$insert8 = (((((($e)) + 40|0) + ($j$02<<4)|0)) + 12|0);
   $$pre9 = +HEAPF32[$$phi$trans$insert8>>2];
   $$pre$phiZ2D = $$phi$trans$insert8;$57 = $$pre9;
  }
  $56 = 1.0 / $57;
  HEAPF32[$$pre$phiZ2D>>2] = $56;
  $58 = (($j$02) + 1)|0;
  $exitcond4 = ($58|0)==(7);
  if ($exitcond4) {
   break;
  }
  $$phi$trans$insert = (((((($e)) + 40|0) + ($58<<4)|0)) + 4|0);
  $$pre = HEAP32[$$phi$trans$insert>>2]|0;
  $40 = $$pre;$j$02 = $58;
 }
 $59 = ($3*7)|0;
 $60 = (_calloc($59,144)|0);
 $61 = ((($e)) + 152|0);
 HEAP32[$61>>2] = $60;
 $62 = HEAP32[$9>>2]|0;
 $63 = (_calloc($62,4)|0);
 $64 = ((($e)) + 160|0);
 HEAP32[$64>>2] = $63;
 return;
}
function __ve_envelope_clear($e) {
 $e = $e|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0;
 var $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($e)) + 16|0);
 _mdct_clear($0);
 $1 = ((($e)) + 48|0);
 $2 = HEAP32[$1>>2]|0;
 _free($2);
 $3 = ((($e)) + 64|0);
 $4 = HEAP32[$3>>2]|0;
 _free($4);
 $5 = ((($e)) + 80|0);
 $6 = HEAP32[$5>>2]|0;
 _free($6);
 $7 = ((($e)) + 96|0);
 $8 = HEAP32[$7>>2]|0;
 _free($8);
 $9 = ((($e)) + 112|0);
 $10 = HEAP32[$9>>2]|0;
 _free($10);
 $11 = ((($e)) + 128|0);
 $12 = HEAP32[$11>>2]|0;
 _free($12);
 $13 = ((($e)) + 144|0);
 $14 = HEAP32[$13>>2]|0;
 _free($14);
 $15 = ((($e)) + 36|0);
 $16 = HEAP32[$15>>2]|0;
 _free($16);
 $17 = ((($e)) + 152|0);
 $18 = HEAP32[$17>>2]|0;
 _free($18);
 $19 = ((($e)) + 160|0);
 $20 = HEAP32[$19>>2]|0;
 _free($20);
 _memset(($e|0),0,180)|0;
 return;
}
function __ve_envelope_search($v) {
 $v = $v|0;
 var $$ = 0, $$0 = 0, $$1 = 0, $$lcssa = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0;
 var $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0;
 var $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0;
 var $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0;
 var $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0;
 var $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $exitcond = 0, $i$08 = 0, $j$011 = 0, $j$14 = 0, $j$14$lcssa23 = 0, $or$cond = 0, $ret$07 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($v)) + 4|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 28|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ((($3)) + 2868|0);
 $5 = ((($v)) + 104|0);
 $6 = HEAP32[$5>>2]|0;
 $7 = HEAP32[$6>>2]|0;
 $8 = ((($7)) + 168|0);
 $9 = HEAP32[$8>>2]|0;
 $10 = ((($7)) + 8|0);
 $11 = HEAP32[$10>>2]|0;
 $12 = (($9|0) / ($11|0))&-1;
 $13 = ((($v)) + 20|0);
 $14 = HEAP32[$13>>2]|0;
 $15 = (($14|0) / ($11|0))&-1;
 $16 = (($15) + -4)|0;
 $17 = ($12|0)<(0);
 $$ = $17 ? 0 : $12;
 $18 = (($15) + 2)|0;
 $19 = ((($7)) + 164|0);
 $20 = HEAP32[$19>>2]|0;
 $21 = ($18|0)>($20|0);
 if ($21) {
  HEAP32[$19>>2] = $18;
  $22 = ((($7)) + 160|0);
  $23 = HEAP32[$22>>2]|0;
  $24 = $18 << 2;
  $25 = (_realloc($23,$24)|0);
  HEAP32[$22>>2] = $25;
 }
 $26 = ($$|0)<($16|0);
 if ($26) {
  $27 = ((($7)) + 156|0);
  $28 = ((($7)) + 160|0);
  $29 = ((($v)) + 8|0);
  $30 = ((($7)) + 40|0);
  $31 = ((($7)) + 152|0);
  $j$011 = $$;
  while(1) {
   $32 = HEAP32[$27>>2]|0;
   $33 = (($32) + 1)|0;
   $34 = ($32|0)>(23);
   $$1 = $34 ? 24 : $33;
   HEAP32[$27>>2] = $$1;
   $35 = HEAP32[$7>>2]|0;
   $36 = ($35|0)>(0);
   if ($36) {
    $i$08 = 0;$ret$07 = 0;
    while(1) {
     $40 = HEAP32[$29>>2]|0;
     $41 = (($40) + ($i$08<<2)|0);
     $42 = HEAP32[$41>>2]|0;
     $43 = HEAP32[$10>>2]|0;
     $44 = Math_imul($43, $j$011)|0;
     $45 = (($42) + ($44<<2)|0);
     $46 = HEAP32[$31>>2]|0;
     $47 = ($i$08*7)|0;
     $48 = (($46) + (($47*144)|0)|0);
     $49 = (__ve_amp($7,$4,$45,$30,$48)|0);
     $50 = $49 | $ret$07;
     $51 = (($i$08) + 1)|0;
     $52 = HEAP32[$7>>2]|0;
     $53 = ($51|0)<($52|0);
     if ($53) {
      $i$08 = $51;$ret$07 = $50;
     } else {
      $$lcssa = $50;
      break;
     }
    }
    $54 = (($j$011) + 2)|0;
    $55 = HEAP32[$28>>2]|0;
    $56 = (($55) + ($54<<2)|0);
    HEAP32[$56>>2] = 0;
    $57 = $$lcssa & 1;
    $58 = ($57|0)==(0);
    if (!($58)) {
     $59 = (($55) + ($j$011<<2)|0);
     HEAP32[$59>>2] = 1;
     $60 = (($j$011) + 1)|0;
     $61 = (($55) + ($60<<2)|0);
     HEAP32[$61>>2] = 1;
    }
    $62 = $$lcssa & 2;
    $63 = ($62|0)==(0);
    if (!($63)) {
     $64 = (($55) + ($j$011<<2)|0);
     HEAP32[$64>>2] = 1;
     $65 = ($j$011|0)>(0);
     if ($65) {
      $66 = (($j$011) + -1)|0;
      $67 = (($55) + ($66<<2)|0);
      HEAP32[$67>>2] = 1;
     }
    }
    $68 = $$lcssa & 4;
    $69 = ($68|0)==(0);
    if (!($69)) {
     HEAP32[$27>>2] = -1;
    }
   } else {
    $37 = (($j$011) + 2)|0;
    $38 = HEAP32[$28>>2]|0;
    $39 = (($38) + ($37<<2)|0);
    HEAP32[$39>>2] = 0;
   }
   $70 = (($j$011) + 1)|0;
   $exitcond = ($70|0)==($16|0);
   if ($exitcond) {
    break;
   } else {
    $j$011 = $70;
   }
  }
 }
 $71 = HEAP32[$10>>2]|0;
 $72 = Math_imul($71, $16)|0;
 HEAP32[$8>>2] = $72;
 $73 = ((($v)) + 48|0);
 $74 = HEAP32[$73>>2]|0;
 $75 = ((($v)) + 40|0);
 $76 = HEAP32[$75>>2]|0;
 $77 = (($3) + ($76<<2)|0);
 $78 = HEAP32[$77>>2]|0;
 $79 = (($78|0) / 4)&-1;
 $80 = (($79) + ($74))|0;
 $81 = ((($3)) + 4|0);
 $82 = HEAP32[$81>>2]|0;
 $83 = (($82|0) / 2)&-1;
 $84 = (($80) + ($83))|0;
 $85 = HEAP32[$3>>2]|0;
 $86 = (($85|0) / 4)&-1;
 $87 = (($84) + ($86))|0;
 $88 = ((($7)) + 176|0);
 $89 = HEAP32[$88>>2]|0;
 $90 = (($72) - ($71))|0;
 $91 = ($89|0)<($90|0);
 if (!($91)) {
  $$0 = -1;
  return ($$0|0);
 }
 $92 = ((($7)) + 160|0);
 $j$14 = $89;
 while(1) {
  $95 = ($j$14|0)<($87|0);
  if (!($95)) {
   $$0 = 1;
   label = 22;
   break;
  }
  HEAP32[$88>>2] = $j$14;
  $96 = (($j$14|0) / ($71|0))&-1;
  $97 = HEAP32[$92>>2]|0;
  $98 = (($97) + ($96<<2)|0);
  $99 = HEAP32[$98>>2]|0;
  $100 = ($99|0)!=(0);
  $101 = ($j$14|0)>($74|0);
  $or$cond = $101 & $100;
  $93 = (($71) + ($j$14))|0;
  if ($or$cond) {
   $j$14$lcssa23 = $j$14;
   label = 21;
   break;
  }
  $94 = ($93|0)<($90|0);
  if ($94) {
   $j$14 = $93;
  } else {
   $$0 = -1;
   label = 22;
   break;
  }
 }
 if ((label|0) == 21) {
  $102 = ((($7)) + 172|0);
  HEAP32[$102>>2] = $j$14$lcssa23;
  $$0 = 0;
  return ($$0|0);
 }
 else if ((label|0) == 22) {
  return ($$0|0);
 }
 return (0)|0;
}
function __ve_envelope_mark($v) {
 $v = $v|0;
 var $$0 = 0, $$pn = 0, $$pn1 = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0;
 var $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0;
 var $42 = 0, $43 = 0, $44 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $beginW$0 = 0, $endW$0 = 0, $i$02 = 0, $or$cond = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($v)) + 104|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = HEAP32[$1>>2]|0;
 $3 = ((($v)) + 4|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = ((($4)) + 28|0);
 $6 = HEAP32[$5>>2]|0;
 $7 = ((($v)) + 48|0);
 $8 = HEAP32[$7>>2]|0;
 $9 = ((($v)) + 40|0);
 $10 = HEAP32[$9>>2]|0;
 $11 = (($6) + ($10<<2)|0);
 $12 = HEAP32[$11>>2]|0;
 $13 = (($12|0) / 4)&-1;
 $14 = (($8) - ($13))|0;
 $15 = (($13) + ($8))|0;
 $16 = ($10|0)==(0);
 if ($16) {
  $27 = HEAP32[$6>>2]|0;
  $28 = (($27|0) / 4)&-1;
  $$pn = $28;$$pn1 = $28;
 } else {
  $17 = ((($v)) + 36|0);
  $18 = HEAP32[$17>>2]|0;
  $19 = (($6) + ($18<<2)|0);
  $20 = HEAP32[$19>>2]|0;
  $21 = (($20|0) / 4)&-1;
  $22 = ((($v)) + 44|0);
  $23 = HEAP32[$22>>2]|0;
  $24 = (($6) + ($23<<2)|0);
  $25 = HEAP32[$24>>2]|0;
  $26 = (($25|0) / 4)&-1;
  $$pn = $26;$$pn1 = $21;
 }
 $beginW$0 = (($14) - ($$pn1))|0;
 $endW$0 = (($15) + ($$pn))|0;
 $29 = ((($2)) + 172|0);
 $30 = HEAP32[$29>>2]|0;
 $31 = ($30|0)>=($beginW$0|0);
 $32 = ($30|0)<($endW$0|0);
 $or$cond = $31 & $32;
 if ($or$cond) {
  $$0 = 1;
  return ($$0|0);
 }
 $33 = ((($2)) + 8|0);
 $34 = HEAP32[$33>>2]|0;
 $35 = (($beginW$0|0) / ($34|0))&-1;
 $36 = (($endW$0|0) / ($34|0))&-1;
 $37 = ($35|0)<($36|0);
 if (!($37)) {
  $$0 = 0;
  return ($$0|0);
 }
 $38 = ((($2)) + 160|0);
 $39 = HEAP32[$38>>2]|0;
 $i$02 = $35;
 while(1) {
  $42 = (($39) + ($i$02<<2)|0);
  $43 = HEAP32[$42>>2]|0;
  $44 = ($43|0)==(0);
  $40 = (($i$02) + 1)|0;
  if (!($44)) {
   $$0 = 1;
   label = 9;
   break;
  }
  $41 = ($40|0)<($36|0);
  if ($41) {
   $i$02 = $40;
  } else {
   $$0 = 0;
   label = 9;
   break;
  }
 }
 if ((label|0) == 9) {
  return ($$0|0);
 }
 return (0)|0;
}
function __ve_envelope_shift($e,$shift) {
 $e = $e|0;
 $shift = $shift|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0;
 var $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($e)) + 168|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($e)) + 8|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = (($1|0) / ($3|0))&-1;
 $5 = (($4) + 2)|0;
 $6 = (($shift|0) / ($3|0))&-1;
 $7 = ((($e)) + 160|0);
 $8 = HEAP32[$7>>2]|0;
 $9 = (($8) + ($6<<2)|0);
 $10 = (($5) - ($6))|0;
 $11 = $10 << 2;
 _memmove(($8|0),($9|0),($11|0))|0;
 $12 = HEAP32[$0>>2]|0;
 $13 = (($12) - ($shift))|0;
 HEAP32[$0>>2] = $13;
 $14 = ((($e)) + 172|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = ($15|0)>(-1);
 if (!($16)) {
  $18 = ((($e)) + 176|0);
  $19 = HEAP32[$18>>2]|0;
  $20 = (($19) - ($shift))|0;
  HEAP32[$18>>2] = $20;
  return;
 }
 $17 = (($15) - ($shift))|0;
 HEAP32[$14>>2] = $17;
 $18 = ((($e)) + 176|0);
 $19 = HEAP32[$18>>2]|0;
 $20 = (($19) - ($shift))|0;
 HEAP32[$18>>2] = $20;
 return;
}
function __ve_amp($ve,$gi,$data,$bands,$filters) {
 $ve = $ve|0;
 $gi = $gi|0;
 $data = $data|0;
 $bands = $bands|0;
 $filters = $filters|0;
 var $$ = 0, $$2 = 0, $$3 = 0, $$3$us = 0, $$3$v = 0, $$3$v$us = 0, $$4 = 0.0, $$4$us = 0.0, $$5$us = 0, $$5$v$us = 0, $$6 = 0, $$6$us = 0, $$alloca_mul = 0, $$in724 = 0.0, $$lcssa48 = 0.0, $$phi$trans$insert = 0, $$pre = 0.0, $$pre$phiZ2D = 0, $$premin$0$us = 0.0, $$premin$0$us$lcssa = 0.0;
 var $$v = 0.0, $$v8 = 0.0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0.0, $104 = 0, $105 = 0.0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0.0, $110 = 0, $111 = 0.0, $112 = 0, $113 = 0;
 var $114 = 0.0, $115 = 0.0, $116 = 0.0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0.0, $123 = 0, $124 = 0, $125 = 0.0, $126 = 0, $127 = 0, $128 = 0.0, $129 = 0.0, $13 = 0.0, $130 = 0, $131 = 0;
 var $132 = 0.0, $133 = 0.0, $134 = 0.0, $135 = 0, $136 = 0, $137 = 0.0, $138 = 0.0, $139 = 0.0, $14 = 0.0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0.0, $147 = 0, $148 = 0, $149 = 0, $15 = 0;
 var $150 = 0, $151 = 0, $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0.0, $157 = 0, $158 = 0.0, $159 = 0.0, $16 = 0, $160 = 0.0, $161 = 0, $162 = 0, $163 = 0, $164 = 0.0, $165 = 0.0, $166 = 0, $167 = 0, $168 = 0;
 var $169 = 0, $17 = 0, $170 = 0.0, $171 = 0, $172 = 0.0, $173 = 0, $174 = 0.0, $175 = 0.0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0.0, $182 = 0.0, $183 = 0, $184 = 0, $185 = 0, $186 = 0.0;
 var $187 = 0.0, $188 = 0, $189 = 0, $19 = 0, $190 = 0, $2 = 0, $20 = 0, $21 = 0.0, $22 = 0, $23 = 0.0, $24 = 0.0, $25 = 0, $26 = 0, $27 = 0, $28 = 0.0, $29 = 0.0, $3 = 0.0, $30 = 0.0, $31 = 0, $32 = 0.0;
 var $33 = 0.0, $34 = 0.0, $35 = 0.0, $36 = 0.0, $37 = 0, $38 = 0.0, $39 = 0.0, $4 = 0, $40 = 0.0, $41 = 0.0, $42 = 0.0, $43 = 0.0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0.0, $49 = 0.0, $5 = 0, $50 = 0;
 var $51 = 0, $52 = 0.0, $53 = 0.0, $54 = 0, $55 = 0.0, $56 = 0.0, $57 = 0, $58 = 0.0, $59 = 0.0, $6 = 0, $60 = 0.0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0.0, $67 = 0, $68 = 0, $69 = 0.0;
 var $7 = 0, $70 = 0.0, $71 = 0.0, $72 = 0.0, $73 = 0.0, $74 = 0.0, $75 = 0.0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0.0, $81 = 0.0, $82 = 0.0, $83 = 0, $84 = 0, $85 = 0.0, $86 = 0, $87 = 0;
 var $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0.0, $92 = 0.0, $93 = 0, $94 = 0, $95 = 0, $96 = 0.0, $97 = 0.0, $98 = 0, $99 = 0, $acc$0$lcssa = 0.0, $acc$0$lcssa$us = 0.0, $acc$010 = 0.0, $acc$010$us = 0.0, $exitcond = 0, $exitcond34 = 0, $exitcond35 = 0;
 var $exitcond36 = 0, $i$028 = 0, $i$125 = 0, $i$211 = 0, $i$211$us = 0, $i$313$us = 0, $j$021 = 0, $j$021$us = 0, $p$112$us = 0, $penalty$0 = 0.0, $penalty$1 = 0.0, $premax$014$us = 0.0, $premin$015$us = 0.0, $ret$0$lcssa = 0, $ret$023 = 0, $ret$023$us = 0, $ret$1 = 0, $ret$1$us = 0, $ret$2 = 0, $ret$2$us = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($ve)) + 4|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($ve)) + 12|0);
 $3 = +HEAPF32[$2>>2];
 $4 = $1 << 2;
 $$alloca_mul = $4;
 $5 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul)|0)+15)&-16)|0;;
 $6 = ((($ve)) + 156|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = ($7|0)>(5);
 $9 = (($7|0) / 2)&-1;
 $$ = $8 ? $9 : 2;
 $10 = ((($gi)) + 60|0);
 $11 = +HEAPF32[$10>>2];
 $12 = (($9) + -2)|0;
 $13 = (+($12|0));
 $14 = $11 - $13;
 $15 = $14 < 0.0;
 $penalty$0 = $15 ? 0.0 : $14;
 $16 = $penalty$0 > $11;
 $penalty$1 = $16 ? $11 : $penalty$0;
 $17 = ($1|0)>(0);
 if ($17) {
  $18 = ((($ve)) + 36|0);
  $19 = HEAP32[$18>>2]|0;
  $i$028 = 0;
  while(1) {
   $20 = (($data) + ($i$028<<2)|0);
   $21 = +HEAPF32[$20>>2];
   $22 = (($19) + ($i$028<<2)|0);
   $23 = +HEAPF32[$22>>2];
   $24 = $23 * $21;
   $25 = (($5) + ($i$028<<2)|0);
   HEAPF32[$25>>2] = $24;
   $26 = (($i$028) + 1)|0;
   $exitcond34 = ($26|0)==($1|0);
   if ($exitcond34) {
    break;
   } else {
    $i$028 = $26;
   }
  }
 }
 $27 = ((($ve)) + 16|0);
 _mdct_forward($27,$5,$5);
 $28 = +HEAPF32[$5>>2];
 $29 = $28 * $28;
 $30 = $29;
 $31 = ((($5)) + 4|0);
 $32 = +HEAPF32[$31>>2];
 $33 = $32;
 $34 = $33 * $33;
 $35 = $34 * 0.69999999999999996;
 $36 = $35 + $30;
 $37 = ((($5)) + 8|0);
 $38 = +HEAPF32[$37>>2];
 $39 = $38;
 $40 = $39 * $39;
 $41 = $40 * 0.20000000000000001;
 $42 = $36 + $41;
 $43 = $42;
 $44 = ((($filters)) + 140|0);
 $45 = HEAP32[$44>>2]|0;
 $46 = ($45|0)==(0);
 if ($46) {
  $47 = ((($filters)) + 136|0);
  $48 = +HEAPF32[$47>>2];
  $49 = $48 + $43;
  $50 = ((($filters)) + 132|0);
  HEAPF32[$50>>2] = $49;
  HEAPF32[$47>>2] = $43;
  $$pre$phiZ2D = $50;$60 = $49;
 } else {
  $51 = ((($filters)) + 132|0);
  $52 = +HEAPF32[$51>>2];
  $53 = $52 + $43;
  HEAPF32[$51>>2] = $53;
  $54 = ((($filters)) + 136|0);
  $55 = +HEAPF32[$54>>2];
  $56 = $55 + $43;
  HEAPF32[$54>>2] = $56;
  $$pre$phiZ2D = $51;$60 = $53;
 }
 $57 = (((($filters)) + 72|0) + ($45<<2)|0);
 $58 = +HEAPF32[$57>>2];
 $59 = $60 - $58;
 HEAPF32[$$pre$phiZ2D>>2] = $59;
 HEAPF32[$57>>2] = $43;
 $61 = HEAP32[$44>>2]|0;
 $62 = (($61) + 1)|0;
 $63 = ($61|0)>(13);
 $$2 = $63 ? 0 : $62;
 HEAP32[$44>>2] = $$2;
 $64 = (($1|0) / 2)&-1;
 $65 = ($1|0)>(1);
 L10: do {
  if ($65) {
   $66 = $60 * 0.0625;
   $67 = (HEAPF32[tempDoublePtr>>2]=$66,HEAP32[tempDoublePtr>>2]|0);
   $68 = $67 & 2147483647;
   $69 = (+($68>>>0));
   $70 = $69 * 7.1771142984289327E-7;
   $71 = $70 + -764.6162109375;
   $72 = $71;
   $73 = $72 * 0.5;
   $74 = $73 + -15.0;
   $75 = $74;
   $$in724 = $75;$129 = $28;$i$125 = 0;
   while(1) {
    $128 = $129 * $129;
    $130 = $i$125 | 1;
    $131 = (($5) + ($130<<2)|0);
    $132 = +HEAPF32[$131>>2];
    $133 = $132 * $132;
    $134 = $133 + $128;
    $135 = (HEAPF32[tempDoublePtr>>2]=$134,HEAP32[tempDoublePtr>>2]|0);
    $136 = $135 & 2147483647;
    $137 = (+($136>>>0));
    $138 = $137 * 3.5885571492144663E-7;
    $139 = $138 + -382.30810546875;
    $140 = $139 < $$in724;
    $$v = $140 ? $$in724 : $139;
    $141 = $$v < $3;
    $$v8 = $141 ? $3 : $$v;
    $142 = $i$125 >> 1;
    $143 = (($5) + ($142<<2)|0);
    HEAPF32[$143>>2] = $$v8;
    $144 = (($i$125) + 2)|0;
    $145 = ($144|0)<($64|0);
    if (!($145)) {
     break L10;
    }
    $146 = $$in724 + -8.0;
    $$phi$trans$insert = (($5) + ($144<<2)|0);
    $$pre = +HEAPF32[$$phi$trans$insert>>2];
    $$in724 = $146;$129 = $$pre;$i$125 = $144;
   }
  }
 } while(0);
 $76 = ($$|0)>(0);
 if ($76) {
  $j$021$us = 0;$ret$023$us = 0;
 } else {
  $j$021 = 0;$ret$023 = 0;
  while(1) {
   $147 = (((($bands) + ($j$021<<4)|0)) + 4|0);
   $148 = HEAP32[$147>>2]|0;
   $149 = ($148|0)>(0);
   if ($149) {
    $150 = (($bands) + ($j$021<<4)|0);
    $151 = HEAP32[$150>>2]|0;
    $152 = (((($bands) + ($j$021<<4)|0)) + 8|0);
    $153 = HEAP32[$152>>2]|0;
    $acc$010 = 0.0;$i$211 = 0;
    while(1) {
     $154 = (($151) + ($i$211))|0;
     $155 = (($5) + ($154<<2)|0);
     $156 = +HEAPF32[$155>>2];
     $157 = (($153) + ($i$211<<2)|0);
     $158 = +HEAPF32[$157>>2];
     $159 = $158 * $156;
     $160 = $159 + $acc$010;
     $161 = (($i$211) + 1)|0;
     $162 = ($161|0)<($148|0);
     if ($162) {
      $acc$010 = $160;$i$211 = $161;
     } else {
      $acc$0$lcssa = $160;
      break;
     }
    }
   } else {
    $acc$0$lcssa = 0.0;
   }
   $163 = (((($bands) + ($j$021<<4)|0)) + 12|0);
   $164 = +HEAPF32[$163>>2];
   $165 = $164 * $acc$0$lcssa;
   $166 = (((($filters) + (($j$021*144)|0)|0)) + 68|0);
   $167 = HEAP32[$166>>2]|0;
   $168 = ($167|0)<(1);
   $$3$v = $168 ? 16 : -1;
   $$3 = (($$3$v) + ($167))|0;
   $169 = ((($filters) + (($j$021*144)|0)|0) + ($$3<<2)|0);
   $170 = +HEAPF32[$169>>2];
   $171 = $165 < $170;
   $172 = $171 ? $170 : $165;
   $173 = $165 > $170;
   $$4 = $173 ? $170 : $165;
   $174 = $$4 + -99999.0;
   $175 = $172 + 99999.0;
   $176 = ((($filters) + (($j$021*144)|0)|0) + ($167<<2)|0);
   HEAPF32[$176>>2] = $165;
   $177 = HEAP32[$166>>2]|0;
   $178 = (($177) + 1)|0;
   $179 = ($177|0)>(15);
   $$6 = $179 ? 0 : $178;
   HEAP32[$166>>2] = $$6;
   $180 = (((($gi)) + 4|0) + ($j$021<<2)|0);
   $181 = +HEAPF32[$180>>2];
   $182 = $181 + $penalty$1;
   $183 = $175 > $182;
   $184 = $ret$023 | 5;
   $ret$1 = $183 ? $184 : $ret$023;
   $185 = (((($gi)) + 32|0) + ($j$021<<2)|0);
   $186 = +HEAPF32[$185>>2];
   $187 = $186 - $penalty$1;
   $188 = $174 < $187;
   $189 = $ret$1 | 2;
   $ret$2 = $188 ? $189 : $ret$1;
   $190 = (($j$021) + 1)|0;
   $exitcond = ($190|0)==(7);
   if ($exitcond) {
    $ret$0$lcssa = $ret$2;
    break;
   } else {
    $j$021 = $190;$ret$023 = $ret$2;
   }
  }
  STACKTOP = sp;return ($ret$0$lcssa|0);
 }
 while(1) {
  $77 = (((($bands) + ($j$021$us<<4)|0)) + 4|0);
  $78 = HEAP32[$77>>2]|0;
  $79 = ($78|0)>(0);
  if ($79) {
   $119 = (($bands) + ($j$021$us<<4)|0);
   $109 = HEAP32[$119>>2]|0;
   $120 = (((($bands) + ($j$021$us<<4)|0)) + 8|0);
   $113 = HEAP32[$120>>2]|0;
   $acc$010$us = 0.0;$i$211$us = 0;
   while(1) {
    $108 = (($109) + ($i$211$us))|0;
    $110 = (($5) + ($108<<2)|0);
    $111 = +HEAPF32[$110>>2];
    $112 = (($113) + ($i$211$us<<2)|0);
    $114 = +HEAPF32[$112>>2];
    $115 = $114 * $111;
    $116 = $115 + $acc$010$us;
    $117 = (($i$211$us) + 1)|0;
    $118 = ($117|0)<($78|0);
    if ($118) {
     $acc$010$us = $116;$i$211$us = $117;
    } else {
     $acc$0$lcssa$us = $116;
     break;
    }
   }
  } else {
   $acc$0$lcssa$us = 0.0;
  }
  $121 = (((($bands) + ($j$021$us<<4)|0)) + 12|0);
  $122 = +HEAPF32[$121>>2];
  $85 = $122 * $acc$0$lcssa$us;
  $87 = (((($filters) + (($j$021$us*144)|0)|0)) + 68|0);
  $84 = HEAP32[$87>>2]|0;
  $123 = ($84|0)<(1);
  $$3$v$us = $123 ? 16 : -1;
  $$3$us = (($$3$v$us) + ($84))|0;
  $124 = ((($filters) + (($j$021$us*144)|0)|0) + ($$3$us<<2)|0);
  $125 = +HEAPF32[$124>>2];
  $126 = $85 < $125;
  $82 = $126 ? $125 : $85;
  $127 = $85 > $125;
  $$4$us = $127 ? $125 : $85;
  $i$313$us = 0;$p$112$us = $$3$us;$premax$014$us = -99999.0;$premin$015$us = 99999.0;
  while(1) {
   $101 = ($p$112$us|0)<(1);
   $$5$v$us = $101 ? 16 : -1;
   $$5$us = (($$5$v$us) + ($p$112$us))|0;
   $102 = ((($filters) + (($j$021$us*144)|0)|0) + ($$5$us<<2)|0);
   $103 = +HEAPF32[$102>>2];
   $104 = $premax$014$us < $103;
   $105 = $104 ? $103 : $premax$014$us;
   $106 = $premin$015$us > $103;
   $$premin$0$us = $106 ? $103 : $premin$015$us;
   $107 = (($i$313$us) + 1)|0;
   $exitcond35 = ($107|0)==($$|0);
   if ($exitcond35) {
    $$lcssa48 = $105;$$premin$0$us$lcssa = $$premin$0$us;
    break;
   } else {
    $i$313$us = $107;$p$112$us = $$5$us;$premax$014$us = $105;$premin$015$us = $$premin$0$us;
   }
  }
  $80 = $$4$us - $$premin$0$us$lcssa;
  $81 = $82 - $$lcssa48;
  $83 = ((($filters) + (($j$021$us*144)|0)|0) + ($84<<2)|0);
  HEAPF32[$83>>2] = $85;
  $86 = HEAP32[$87>>2]|0;
  $88 = (($86) + 1)|0;
  $89 = ($86|0)>(15);
  $$6$us = $89 ? 0 : $88;
  HEAP32[$87>>2] = $$6$us;
  $90 = (((($gi)) + 4|0) + ($j$021$us<<2)|0);
  $91 = +HEAPF32[$90>>2];
  $92 = $91 + $penalty$1;
  $93 = $81 > $92;
  $94 = $ret$023$us | 5;
  $ret$1$us = $93 ? $94 : $ret$023$us;
  $95 = (((($gi)) + 32|0) + ($j$021$us<<2)|0);
  $96 = +HEAPF32[$95>>2];
  $97 = $96 - $penalty$1;
  $98 = $80 < $97;
  $99 = $ret$1$us | 2;
  $ret$2$us = $98 ? $99 : $ret$1$us;
  $100 = (($j$021$us) + 1)|0;
  $exitcond36 = ($100|0)==(7);
  if ($exitcond36) {
   $ret$0$lcssa = $ret$2$us;
   break;
  } else {
   $j$021$us = $100;$ret$023$us = $ret$2$us;
  }
 }
 STACKTOP = sp;return ($ret$0$lcssa|0);
}
function _floor1_fit($vb,$look,$logmdct,$logmask) {
 $vb = $vb|0;
 $look = $look|0;
 $logmdct = $logmdct|0;
 $logmask = $logmask|0;
 var $$$0$i = 0, $$$i$i = 0, $$$i$i27 = 0, $$$i$i58 = 0, $$$i5$i = 0, $$0$i = 0, $$0$i$i = 0, $$0$i$i28 = 0, $$0$i$i59 = 0, $$0$i10 = 0, $$0$i54 = 0, $$0$i6$i = 0, $$0$i63 = 0, $$0$i7 = 0, $$0$i8 = 0, $$0$p$i = 0, $$pn$i = 0, $$pre = 0, $$pre116 = 0, $$pre117 = 0;
 var $$val$i = 0.0, $$val$i26 = 0.0, $$val$i61 = 0.0, $$val4$i = 0.0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0;
 var $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0;
 var $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0;
 var $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0;
 var $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $171 = 0, $172 = 0.0, $173 = 0.0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0.0, $184 = 0.0;
 var $185 = 0.0, $186 = 0, $187 = 0.0, $188 = 0.0, $189 = 0.0, $19 = 0, $190 = 0.0, $191 = 0, $192 = 0.0, $193 = 0.0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0;
 var $202 = 0, $203 = 0.0, $204 = 0.0, $205 = 0, $206 = 0, $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0.0, $214 = 0.0, $215 = 0, $216 = 0, $217 = 0.0, $218 = 0.0, $219 = 0.0, $22 = 0;
 var $220 = 0.0, $221 = 0, $222 = 0.0, $223 = 0.0, $224 = 0, $225 = 0, $226 = 0, $227 = 0.0, $228 = 0.0, $229 = 0.0, $23 = 0, $230 = 0.0, $231 = 0.0, $232 = 0, $233 = 0.0, $234 = 0.0, $235 = 0.0, $236 = 0, $237 = 0, $238 = 0.0;
 var $239 = 0, $24 = 0.0, $240 = 0, $241 = 0, $242 = 0, $243 = 0, $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0.0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0;
 var $257 = 0, $258 = 0, $259 = 0, $26 = 0, $260 = 0, $261 = 0, $262 = 0, $263 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0, $27 = 0, $270 = 0, $271 = 0, $272 = 0, $273 = 0, $274 = 0;
 var $275 = 0, $276 = 0, $277 = 0, $278 = 0, $279 = 0, $28 = 0, $280 = 0, $281 = 0, $282 = 0, $283 = 0, $284 = 0, $285 = 0, $286 = 0, $287 = 0, $288 = 0, $289 = 0, $29 = 0, $290 = 0, $291 = 0, $292 = 0;
 var $293 = 0, $294 = 0, $295 = 0, $296 = 0, $297 = 0, $298 = 0, $299 = 0, $3 = 0, $30 = 0, $300 = 0, $301 = 0, $302 = 0, $303 = 0, $304 = 0, $305 = 0, $306 = 0, $307 = 0, $308 = 0, $309 = 0, $31 = 0.0;
 var $310 = 0, $311 = 0, $312 = 0, $313 = 0, $314 = 0, $315 = 0, $316 = 0, $317 = 0, $318 = 0, $319 = 0, $32 = 0.0, $320 = 0, $321 = 0, $322 = 0, $323 = 0, $324 = 0, $325 = 0, $326 = 0, $327 = 0, $328 = 0;
 var $33 = 0.0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0;
 var $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0;
 var $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0.0, $76 = 0.0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0.0, $83 = 0.0, $84 = 0.0, $85 = 0, $86 = 0, $87 = 0;
 var $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $err$010$i = 0, $err$1$i = 0, $exitcond = 0, $exitcond109 = 0, $exitcond110 = 0, $exitcond112 = 0, $exitcond114 = 0;
 var $exitcond115 = 0, $fit_valueA = 0, $fit_valueB = 0, $fits = 0, $hineighbor = 0, $hy0 = 0, $hy1 = 0, $i$01$i = 0, $i$01$i25 = 0, $i$0104 = 0, $i$1102 = 0, $i$398 = 0, $i$593 = 0, $i$687 = 0, $i$778 = 0, $ispos$i = 0, $ispos$i56 = 0, $ispos2$i = 0, $j$080 = 0, $j$080$in = 0;
 var $j$1 = 0, $j$183 = 0, $j$184 = 0, $loneighbor = 0, $ly0 = 0, $ly1 = 0, $memo = 0, $mse$0$lcssa$i = 0, $mse$011$i = 0, $n$0$lcssa$i = 0, $n$012$i = 0, $na$0$lcssa$i = 0, $na$0$lcssa$i47 = 0, $na$07$i = 0, $na$07$i19 = 0, $na$1$i = 0, $na$1$i34 = 0, $nb$0$lcssa$i = 0, $nb$0$lcssa$i41 = 0, $nb$013$i = 0;
 var $nb$013$i13 = 0, $nb$1$i = 0, $nb$1$i40 = 0, $neg$i = 0, $neg$i57 = 0, $neg3$i = 0, $nonzero$092 = 0, $nonzero$1 = 0, $or$cond = 0, $or$cond$i = 0, $or$cond6 = 0, $output$0 = 0, $x1$$i = 0, $x2a$0$lcssa$i = 0, $x2a$0$lcssa$i50 = 0, $x2a$04$i = 0, $x2a$04$i22 = 0, $x2a$1$i = 0, $x2a$1$i31 = 0, $x2b$0$lcssa$i = 0;
 var $x2b$0$lcssa$i44 = 0, $x2b$010$i = 0, $x2b$010$i16 = 0, $x2b$1$i = 0, $x2b$1$i37 = 0, $xa$0$lcssa$i = 0, $xa$0$lcssa$i52 = 0, $xa$02$i = 0, $xa$02$i24 = 0, $xa$1$i = 0, $xa$1$i29 = 0, $xb$0$lcssa$i = 0, $xb$0$lcssa$i46 = 0, $xb$08$i = 0, $xb$08$i18 = 0, $xb$1$i = 0, $xb$1$i35 = 0, $xya$0$lcssa$i = 0, $xya$0$lcssa$i48 = 0, $xya$06$i = 0;
 var $xya$06$i20 = 0, $xya$1$i = 0, $xya$1$i33 = 0, $xyb$0$lcssa$i = 0, $xyb$0$lcssa$i42 = 0, $xyb$012$i = 0, $xyb$012$i14 = 0, $xyb$1$i = 0, $xyb$1$i39 = 0, $y$09$i = 0, $y$1$i = 0, $y0 = 0, $y1 = 0, $y2a$0$lcssa$i = 0, $y2a$0$lcssa$i49 = 0, $y2a$05$i = 0, $y2a$05$i21 = 0, $y2a$1$i = 0, $y2a$1$i32 = 0, $y2b$0$lcssa$i = 0;
 var $y2b$0$lcssa$i43 = 0, $y2b$011$i = 0, $y2b$011$i15 = 0, $y2b$1$i = 0, $y2b$1$i38 = 0, $ya$0$lcssa$i = 0, $ya$0$lcssa$i51 = 0, $ya$03$i = 0, $ya$03$i23 = 0, $ya$1$i = 0, $ya$1$i30 = 0, $yb$0$lcssa$i = 0, $yb$0$lcssa$i45 = 0, $yb$09$i = 0, $yb$09$i17 = 0, $yb$1$i = 0, $yb$1$i36 = 0, dest = 0, label = 0, sp = 0;
 var stop = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 4912|0;
 $fits = sp + 1328|0;
 $fit_valueA = sp + 1064|0;
 $fit_valueB = sp + 804|0;
 $loneighbor = sp + 544|0;
 $hineighbor = sp + 284|0;
 $memo = sp + 24|0;
 $y0 = sp + 20|0;
 $y1 = sp + 16|0;
 $ly0 = sp + 12|0;
 $ly1 = sp + 8|0;
 $hy0 = sp + 4|0;
 $hy1 = sp;
 $0 = ((($look)) + 1296|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($look)) + 1288|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ((($look)) + 1284|0);
 $5 = HEAP32[$4>>2]|0;
 $6 = ($5|0)>(0);
 if ($6) {
  $i$0104 = 0;
  while(1) {
   $7 = (($fit_valueA) + ($i$0104<<2)|0);
   HEAP32[$7>>2] = -200;
   $8 = (($i$0104) + 1)|0;
   $exitcond115 = ($8|0)==($5|0);
   if ($exitcond115) {
    break;
   } else {
    $i$0104 = $8;
   }
  }
  if ($6) {
   $i$1102 = 0;
   while(1) {
    $9 = (($fit_valueB) + ($i$1102<<2)|0);
    HEAP32[$9>>2] = -200;
    $10 = (($i$1102) + 1)|0;
    $exitcond114 = ($10|0)==($5|0);
    if ($exitcond114) {
     break;
    } else {
     $i$1102 = $10;
    }
   }
   if ($6) {
    $11 = $5 << 2;
    _memset(($loneighbor|0),0,($11|0))|0;
    $i$398 = 0;
    while(1) {
     $12 = (($hineighbor) + ($i$398<<2)|0);
     HEAP32[$12>>2] = 1;
     $13 = (($i$398) + 1)|0;
     $exitcond112 = ($13|0)==($5|0);
     if ($exitcond112) {
      break;
     } else {
      $i$398 = $13;
     }
    }
    if ($6) {
     $15 = $5 << 2;
     _memset(($memo|0),-1,($15|0))|0;
     $16 = ($5|0)>(1);
     if (!($16)) {
      $output$0 = 0;
      STACKTOP = sp;return ($output$0|0);
     }
     $17 = (($3) + -1)|0;
     $18 = ((($1)) + 1112|0);
     $19 = (($5) + -1)|0;
     $$pre = HEAP32[$look>>2]|0;
     $70 = $$pre;$i$593 = 0;$nonzero$092 = 0;
     while(1) {
      $66 = (($i$593) + 1)|0;
      $67 = (($look) + ($66<<2)|0);
      $68 = HEAP32[$67>>2]|0;
      $69 = (($fits) + (($i$593*56)|0)|0);
      dest=$69; stop=dest+56|0; do { HEAP32[dest>>2]=0|0; dest=dest+4|0; } while ((dest|0) < (stop|0));
      HEAP32[$69>>2] = $70;
      $71 = (((($fits) + (($i$593*56)|0)|0)) + 4|0);
      HEAP32[$71>>2] = $68;
      $72 = ($68|0)<($3|0);
      $x1$$i = $72 ? $68 : $17;
      $73 = ($x1$$i|0)<($70|0);
      if ($73) {
       $na$0$lcssa$i47 = 0;$nb$0$lcssa$i41 = 0;$x2a$0$lcssa$i50 = 0;$x2b$0$lcssa$i44 = 0;$xa$0$lcssa$i52 = 0;$xb$0$lcssa$i46 = 0;$xya$0$lcssa$i48 = 0;$xyb$0$lcssa$i42 = 0;$y2a$0$lcssa$i49 = 0;$y2b$0$lcssa$i43 = 0;$ya$0$lcssa$i51 = 0;$yb$0$lcssa$i45 = 0;
      } else {
       $i$01$i25 = $70;$na$07$i19 = 0;$nb$013$i13 = 0;$x2a$04$i22 = 0;$x2b$010$i16 = 0;$xa$02$i24 = 0;$xb$08$i18 = 0;$xya$06$i20 = 0;$xyb$012$i14 = 0;$y2a$05$i21 = 0;$y2b$011$i15 = 0;$ya$03$i23 = 0;$yb$09$i17 = 0;
       while(1) {
        $74 = (($logmask) + ($i$01$i25<<2)|0);
        $$val$i26 = +HEAPF32[$74>>2];
        $75 = $$val$i26 * 7.3142857551574707;
        $76 = $75 + 1023.5;
        $77 = (~~(($76)));
        $78 = ($77|0)>(1023);
        $79 = ($77|0)<(0);
        $$$i$i27 = $79 ? 0 : $77;
        $$0$i$i28 = $78 ? 1023 : $$$i$i27;
        $80 = ($$0$i$i28|0)==(0);
        do {
         if ($80) {
          $na$1$i34 = $na$07$i19;$nb$1$i40 = $nb$013$i13;$x2a$1$i31 = $x2a$04$i22;$x2b$1$i37 = $x2b$010$i16;$xa$1$i29 = $xa$02$i24;$xb$1$i35 = $xb$08$i18;$xya$1$i33 = $xya$06$i20;$xyb$1$i39 = $xyb$012$i14;$y2a$1$i32 = $y2a$05$i21;$y2b$1$i38 = $y2b$011$i15;$ya$1$i30 = $ya$03$i23;$yb$1$i36 = $yb$09$i17;
         } else {
          $81 = (($logmdct) + ($i$01$i25<<2)|0);
          $82 = +HEAPF32[$81>>2];
          $83 = +HEAPF32[$18>>2];
          $84 = $83 + $82;
          $85 = !($84 >= $$val$i26);
          if ($85) {
           $95 = (($i$01$i25) + ($xb$08$i18))|0;
           $96 = (($$0$i$i28) + ($yb$09$i17))|0;
           $97 = Math_imul($i$01$i25, $i$01$i25)|0;
           $98 = (($97) + ($x2b$010$i16))|0;
           $99 = Math_imul($$0$i$i28, $$0$i$i28)|0;
           $100 = (($99) + ($y2b$011$i15))|0;
           $101 = Math_imul($$0$i$i28, $i$01$i25)|0;
           $102 = (($101) + ($xyb$012$i14))|0;
           $103 = (($nb$013$i13) + 1)|0;
           $na$1$i34 = $na$07$i19;$nb$1$i40 = $103;$x2a$1$i31 = $x2a$04$i22;$x2b$1$i37 = $98;$xa$1$i29 = $xa$02$i24;$xb$1$i35 = $95;$xya$1$i33 = $xya$06$i20;$xyb$1$i39 = $102;$y2a$1$i32 = $y2a$05$i21;$y2b$1$i38 = $100;$ya$1$i30 = $ya$03$i23;$yb$1$i36 = $96;
           break;
          } else {
           $86 = (($i$01$i25) + ($xa$02$i24))|0;
           $87 = (($$0$i$i28) + ($ya$03$i23))|0;
           $88 = Math_imul($i$01$i25, $i$01$i25)|0;
           $89 = (($88) + ($x2a$04$i22))|0;
           $90 = Math_imul($$0$i$i28, $$0$i$i28)|0;
           $91 = (($90) + ($y2a$05$i21))|0;
           $92 = Math_imul($$0$i$i28, $i$01$i25)|0;
           $93 = (($92) + ($xya$06$i20))|0;
           $94 = (($na$07$i19) + 1)|0;
           $na$1$i34 = $94;$nb$1$i40 = $nb$013$i13;$x2a$1$i31 = $89;$x2b$1$i37 = $x2b$010$i16;$xa$1$i29 = $86;$xb$1$i35 = $xb$08$i18;$xya$1$i33 = $93;$xyb$1$i39 = $xyb$012$i14;$y2a$1$i32 = $91;$y2b$1$i38 = $y2b$011$i15;$ya$1$i30 = $87;$yb$1$i36 = $yb$09$i17;
           break;
          }
         }
        } while(0);
        $104 = (($i$01$i25) + 1)|0;
        $105 = ($i$01$i25|0)<($x1$$i|0);
        if ($105) {
         $i$01$i25 = $104;$na$07$i19 = $na$1$i34;$nb$013$i13 = $nb$1$i40;$x2a$04$i22 = $x2a$1$i31;$x2b$010$i16 = $x2b$1$i37;$xa$02$i24 = $xa$1$i29;$xb$08$i18 = $xb$1$i35;$xya$06$i20 = $xya$1$i33;$xyb$012$i14 = $xyb$1$i39;$y2a$05$i21 = $y2a$1$i32;$y2b$011$i15 = $y2b$1$i38;$ya$03$i23 = $ya$1$i30;$yb$09$i17 = $yb$1$i36;
        } else {
         $na$0$lcssa$i47 = $na$1$i34;$nb$0$lcssa$i41 = $nb$1$i40;$x2a$0$lcssa$i50 = $x2a$1$i31;$x2b$0$lcssa$i44 = $x2b$1$i37;$xa$0$lcssa$i52 = $xa$1$i29;$xb$0$lcssa$i46 = $xb$1$i35;$xya$0$lcssa$i48 = $xya$1$i33;$xyb$0$lcssa$i42 = $xyb$1$i39;$y2a$0$lcssa$i49 = $y2a$1$i32;$y2b$0$lcssa$i43 = $y2b$1$i38;$ya$0$lcssa$i51 = $ya$1$i30;$yb$0$lcssa$i45 = $yb$1$i36;
         break;
        }
       }
      }
      $106 = (((($fits) + (($i$593*56)|0)|0)) + 8|0);
      HEAP32[$106>>2] = $xa$0$lcssa$i52;
      $107 = (((($fits) + (($i$593*56)|0)|0)) + 12|0);
      HEAP32[$107>>2] = $ya$0$lcssa$i51;
      $108 = (((($fits) + (($i$593*56)|0)|0)) + 16|0);
      HEAP32[$108>>2] = $x2a$0$lcssa$i50;
      $109 = (((($fits) + (($i$593*56)|0)|0)) + 20|0);
      HEAP32[$109>>2] = $y2a$0$lcssa$i49;
      $110 = (((($fits) + (($i$593*56)|0)|0)) + 24|0);
      HEAP32[$110>>2] = $xya$0$lcssa$i48;
      $111 = (((($fits) + (($i$593*56)|0)|0)) + 28|0);
      HEAP32[$111>>2] = $na$0$lcssa$i47;
      $112 = (((($fits) + (($i$593*56)|0)|0)) + 32|0);
      HEAP32[$112>>2] = $xb$0$lcssa$i46;
      $113 = (((($fits) + (($i$593*56)|0)|0)) + 36|0);
      HEAP32[$113>>2] = $yb$0$lcssa$i45;
      $114 = (((($fits) + (($i$593*56)|0)|0)) + 40|0);
      HEAP32[$114>>2] = $x2b$0$lcssa$i44;
      $115 = (((($fits) + (($i$593*56)|0)|0)) + 44|0);
      HEAP32[$115>>2] = $y2b$0$lcssa$i43;
      $116 = (((($fits) + (($i$593*56)|0)|0)) + 48|0);
      HEAP32[$116>>2] = $xyb$0$lcssa$i42;
      $117 = (((($fits) + (($i$593*56)|0)|0)) + 52|0);
      HEAP32[$117>>2] = $nb$0$lcssa$i41;
      $118 = (($na$0$lcssa$i47) + ($nonzero$092))|0;
      $exitcond110 = ($66|0)==($19|0);
      if ($exitcond110) {
       $nonzero$1 = $118;
       break;
      } else {
       $70 = $68;$i$593 = $66;$nonzero$092 = $118;
      }
     }
    } else {
     label = 9;
    }
   } else {
    label = 9;
   }
  } else {
   label = 9;
  }
 } else {
  label = 9;
 }
 if ((label|0) == 9) {
  $14 = ($5|0)==(0);
  if (!($14)) {
   $output$0 = 0;
   STACKTOP = sp;return ($output$0|0);
  }
  $20 = ((($fits)) + 4|0);
  dest=$fits; stop=dest+56|0; do { HEAP32[dest>>2]=0|0; dest=dest+4|0; } while ((dest|0) < (stop|0));
  HEAP32[$20>>2] = $3;
  $21 = ($3|0)<(1);
  if ($21) {
   $na$0$lcssa$i = 0;$nb$0$lcssa$i = 0;$x2a$0$lcssa$i = 0;$x2b$0$lcssa$i = 0;$xa$0$lcssa$i = 0;$xb$0$lcssa$i = 0;$xya$0$lcssa$i = 0;$xyb$0$lcssa$i = 0;$y2a$0$lcssa$i = 0;$y2b$0$lcssa$i = 0;$ya$0$lcssa$i = 0;$yb$0$lcssa$i = 0;
  } else {
   $22 = ((($1)) + 1112|0);
   $i$01$i = 0;$na$07$i = 0;$nb$013$i = 0;$x2a$04$i = 0;$x2b$010$i = 0;$xa$02$i = 0;$xb$08$i = 0;$xya$06$i = 0;$xyb$012$i = 0;$y2a$05$i = 0;$y2b$011$i = 0;$ya$03$i = 0;$yb$09$i = 0;
   while(1) {
    $23 = (($logmask) + ($i$01$i<<2)|0);
    $$val$i = +HEAPF32[$23>>2];
    $24 = $$val$i * 7.3142857551574707;
    $25 = $24 + 1023.5;
    $26 = (~~(($25)));
    $27 = ($26|0)>(1023);
    $28 = ($26|0)<(0);
    $$$i$i = $28 ? 0 : $26;
    $$0$i$i = $27 ? 1023 : $$$i$i;
    $29 = ($$0$i$i|0)==(0);
    do {
     if ($29) {
      $na$1$i = $na$07$i;$nb$1$i = $nb$013$i;$x2a$1$i = $x2a$04$i;$x2b$1$i = $x2b$010$i;$xa$1$i = $xa$02$i;$xb$1$i = $xb$08$i;$xya$1$i = $xya$06$i;$xyb$1$i = $xyb$012$i;$y2a$1$i = $y2a$05$i;$y2b$1$i = $y2b$011$i;$ya$1$i = $ya$03$i;$yb$1$i = $yb$09$i;
     } else {
      $30 = (($logmdct) + ($i$01$i<<2)|0);
      $31 = +HEAPF32[$30>>2];
      $32 = +HEAPF32[$22>>2];
      $33 = $32 + $31;
      $34 = !($33 >= $$val$i);
      if ($34) {
       $44 = (($i$01$i) + ($xb$08$i))|0;
       $45 = (($$0$i$i) + ($yb$09$i))|0;
       $46 = Math_imul($i$01$i, $i$01$i)|0;
       $47 = (($46) + ($x2b$010$i))|0;
       $48 = Math_imul($$0$i$i, $$0$i$i)|0;
       $49 = (($48) + ($y2b$011$i))|0;
       $50 = Math_imul($$0$i$i, $i$01$i)|0;
       $51 = (($50) + ($xyb$012$i))|0;
       $52 = (($nb$013$i) + 1)|0;
       $na$1$i = $na$07$i;$nb$1$i = $52;$x2a$1$i = $x2a$04$i;$x2b$1$i = $47;$xa$1$i = $xa$02$i;$xb$1$i = $44;$xya$1$i = $xya$06$i;$xyb$1$i = $51;$y2a$1$i = $y2a$05$i;$y2b$1$i = $49;$ya$1$i = $ya$03$i;$yb$1$i = $45;
       break;
      } else {
       $35 = (($i$01$i) + ($xa$02$i))|0;
       $36 = (($$0$i$i) + ($ya$03$i))|0;
       $37 = Math_imul($i$01$i, $i$01$i)|0;
       $38 = (($37) + ($x2a$04$i))|0;
       $39 = Math_imul($$0$i$i, $$0$i$i)|0;
       $40 = (($39) + ($y2a$05$i))|0;
       $41 = Math_imul($$0$i$i, $i$01$i)|0;
       $42 = (($41) + ($xya$06$i))|0;
       $43 = (($na$07$i) + 1)|0;
       $na$1$i = $43;$nb$1$i = $nb$013$i;$x2a$1$i = $38;$x2b$1$i = $x2b$010$i;$xa$1$i = $35;$xb$1$i = $xb$08$i;$xya$1$i = $42;$xyb$1$i = $xyb$012$i;$y2a$1$i = $40;$y2b$1$i = $y2b$011$i;$ya$1$i = $36;$yb$1$i = $yb$09$i;
       break;
      }
     }
    } while(0);
    $53 = (($i$01$i) + 1)|0;
    $exitcond109 = ($53|0)==($3|0);
    if ($exitcond109) {
     $na$0$lcssa$i = $na$1$i;$nb$0$lcssa$i = $nb$1$i;$x2a$0$lcssa$i = $x2a$1$i;$x2b$0$lcssa$i = $x2b$1$i;$xa$0$lcssa$i = $xa$1$i;$xb$0$lcssa$i = $xb$1$i;$xya$0$lcssa$i = $xya$1$i;$xyb$0$lcssa$i = $xyb$1$i;$y2a$0$lcssa$i = $y2a$1$i;$y2b$0$lcssa$i = $y2b$1$i;$ya$0$lcssa$i = $ya$1$i;$yb$0$lcssa$i = $yb$1$i;
     break;
    } else {
     $i$01$i = $53;$na$07$i = $na$1$i;$nb$013$i = $nb$1$i;$x2a$04$i = $x2a$1$i;$x2b$010$i = $x2b$1$i;$xa$02$i = $xa$1$i;$xb$08$i = $xb$1$i;$xya$06$i = $xya$1$i;$xyb$012$i = $xyb$1$i;$y2a$05$i = $y2a$1$i;$y2b$011$i = $y2b$1$i;$ya$03$i = $ya$1$i;$yb$09$i = $yb$1$i;
    }
   }
  }
  $54 = ((($fits)) + 8|0);
  HEAP32[$54>>2] = $xa$0$lcssa$i;
  $55 = ((($fits)) + 12|0);
  HEAP32[$55>>2] = $ya$0$lcssa$i;
  $56 = ((($fits)) + 16|0);
  HEAP32[$56>>2] = $x2a$0$lcssa$i;
  $57 = ((($fits)) + 20|0);
  HEAP32[$57>>2] = $y2a$0$lcssa$i;
  $58 = ((($fits)) + 24|0);
  HEAP32[$58>>2] = $xya$0$lcssa$i;
  $59 = ((($fits)) + 28|0);
  HEAP32[$59>>2] = $na$0$lcssa$i;
  $60 = ((($fits)) + 32|0);
  HEAP32[$60>>2] = $xb$0$lcssa$i;
  $61 = ((($fits)) + 36|0);
  HEAP32[$61>>2] = $yb$0$lcssa$i;
  $62 = ((($fits)) + 40|0);
  HEAP32[$62>>2] = $x2b$0$lcssa$i;
  $63 = ((($fits)) + 44|0);
  HEAP32[$63>>2] = $y2b$0$lcssa$i;
  $64 = ((($fits)) + 48|0);
  HEAP32[$64>>2] = $xyb$0$lcssa$i;
  $65 = ((($fits)) + 52|0);
  HEAP32[$65>>2] = $nb$0$lcssa$i;
  $nonzero$1 = $na$0$lcssa$i;
 }
 $119 = ($nonzero$1|0)==(0);
 if ($119) {
  $output$0 = 0;
  STACKTOP = sp;return ($output$0|0);
 }
 HEAP32[$y0>>2] = -200;
 HEAP32[$y1>>2] = -200;
 $120 = (($5) + -1)|0;
 (_fit_line($fits,$120,$y0,$y1,$1)|0);
 $121 = HEAP32[$y0>>2]|0;
 HEAP32[$fit_valueA>>2] = $121;
 HEAP32[$fit_valueB>>2] = $121;
 $122 = HEAP32[$y1>>2]|0;
 $123 = ((($fit_valueB)) + 4|0);
 HEAP32[$123>>2] = $122;
 $124 = ((($fit_valueA)) + 4|0);
 HEAP32[$124>>2] = $122;
 $125 = ($5|0)>(2);
 do {
  if ($125) {
   $126 = ((($1)) + 1112|0);
   $127 = ((($1)) + 1096|0);
   $128 = ((($1)) + 1100|0);
   $129 = ((($1)) + 1104|0);
   $i$687 = 2;
   L50: while(1) {
    $130 = (((($look)) + 520|0) + ($i$687<<2)|0);
    $131 = HEAP32[$130>>2]|0;
    $132 = (($loneighbor) + ($131<<2)|0);
    $133 = HEAP32[$132>>2]|0;
    $134 = (($hineighbor) + ($131<<2)|0);
    $135 = HEAP32[$134>>2]|0;
    $136 = (($memo) + ($133<<2)|0);
    $137 = HEAP32[$136>>2]|0;
    $138 = ($137|0)==($135|0);
    L52: do {
     if (!($138)) {
      $139 = (((($look)) + 520|0) + ($133<<2)|0);
      $140 = HEAP32[$139>>2]|0;
      $141 = (((($look)) + 520|0) + ($135<<2)|0);
      $142 = HEAP32[$141>>2]|0;
      HEAP32[$136>>2] = $135;
      $143 = (((($1)) + 836|0) + ($133<<2)|0);
      $144 = HEAP32[$143>>2]|0;
      $145 = (((($1)) + 836|0) + ($135<<2)|0);
      $146 = HEAP32[$145>>2]|0;
      $147 = (($fit_valueA) + ($133<<2)|0);
      $148 = HEAP32[$147>>2]|0;
      $149 = ($148|0)<(0);
      $150 = (($fit_valueB) + ($133<<2)|0);
      $151 = HEAP32[$150>>2]|0;
      if ($149) {
       $$0$i54 = $151;
      } else {
       $152 = ($151|0)<(0);
       if ($152) {
        $$0$i54 = $148;
       } else {
        $153 = (($151) + ($148))|0;
        $154 = $153 >> 1;
        $$0$i54 = $154;
       }
      }
      $155 = (($fit_valueA) + ($135<<2)|0);
      $156 = HEAP32[$155>>2]|0;
      $157 = ($156|0)<(0);
      $158 = (($fit_valueB) + ($135<<2)|0);
      $159 = HEAP32[$158>>2]|0;
      if ($157) {
       $$0$i63 = $159;
      } else {
       $160 = ($159|0)<(0);
       if ($160) {
        $$0$i63 = $156;
       } else {
        $161 = (($159) + ($156))|0;
        $162 = $161 >> 1;
        $$0$i63 = $162;
       }
      }
      $163 = ($$0$i54|0)==(-1);
      $164 = ($$0$i63|0)==(-1);
      $or$cond = $163 | $164;
      if ($or$cond) {
       label = 38;
       break L50;
      }
      $165 = (($$0$i63) - ($$0$i54))|0;
      $166 = (($146) - ($144))|0;
      $ispos$i56 = ($165|0)>(-1);
      $neg$i57 = (0 - ($165))|0;
      $167 = $ispos$i56 ? $165 : $neg$i57;
      $168 = (($165|0) / ($166|0))&-1;
      $169 = $165 >> 31;
      $170 = $169 | 1;
      $171 = (($logmask) + ($144<<2)|0);
      $$val4$i = +HEAPF32[$171>>2];
      $172 = $$val4$i * 7.3142857551574707;
      $173 = $172 + 1023.5;
      $174 = (~~(($173)));
      $175 = ($174|0)>(1023);
      $176 = ($174|0)<(0);
      $$$i$i58 = $176 ? 0 : $174;
      $$0$i$i59 = $175 ? 1023 : $$$i$i58;
      $177 = Math_imul($168, $166)|0;
      $ispos2$i = ($177|0)>(-1);
      $neg3$i = (0 - ($177))|0;
      $178 = $ispos2$i ? $177 : $neg3$i;
      $179 = (($167) - ($178))|0;
      $180 = (($$0$i54) - ($$0$i$i59))|0;
      $181 = Math_imul($180, $180)|0;
      $182 = (($logmdct) + ($144<<2)|0);
      $183 = +HEAPF32[$182>>2];
      $184 = +HEAPF32[$126>>2];
      $185 = $184 + $183;
      $186 = !($185 >= $$val4$i);
      if ($186) {
       label = 42;
      } else {
       $187 = (+($$0$i54|0));
       $188 = +HEAPF32[$127>>2];
       $189 = $188 + $187;
       $190 = (+($$0$i$i59|0));
       $191 = $189 < $190;
       if (!($191)) {
        $192 = +HEAPF32[$128>>2];
        $193 = $187 - $192;
        $194 = $193 > $190;
        if (!($194)) {
         label = 42;
        }
       }
      }
      L66: do {
       if ((label|0) == 42) {
        label = 0;
        $195 = (($144) + 1)|0;
        $196 = ($195|0)<($146|0);
        if ($196) {
         $202 = $195;$err$010$i = 0;$mse$011$i = $181;$n$012$i = 1;$y$09$i = $$0$i54;
         while(1) {
          $197 = (($err$010$i) + ($179))|0;
          $198 = ($197|0)<($166|0);
          $199 = $198 ? 0 : $170;
          $200 = $198 ? 0 : $166;
          $err$1$i = (($197) - ($200))|0;
          $$pn$i = (($y$09$i) + ($168))|0;
          $y$1$i = (($$pn$i) + ($199))|0;
          $201 = (($logmask) + ($202<<2)|0);
          $$val$i61 = +HEAPF32[$201>>2];
          $203 = $$val$i61 * 7.3142857551574707;
          $204 = $203 + 1023.5;
          $205 = (~~(($204)));
          $206 = ($205|0)>(1023);
          $207 = ($205|0)<(0);
          $$$i5$i = $207 ? 0 : $205;
          $$0$i6$i = $206 ? 1023 : $$$i5$i;
          $208 = (($y$1$i) - ($$0$i6$i))|0;
          $209 = Math_imul($208, $208)|0;
          $210 = (($209) + ($mse$011$i))|0;
          $211 = (($n$012$i) + 1)|0;
          $212 = (($logmdct) + ($202<<2)|0);
          $213 = +HEAPF32[$212>>2];
          $214 = $213 + $184;
          $215 = $214 >= $$val$i61;
          $216 = ($$0$i6$i|0)!=(0);
          $or$cond$i = $215 & $216;
          if ($or$cond$i) {
           $217 = (+($y$1$i|0));
           $218 = +HEAPF32[$127>>2];
           $219 = $218 + $217;
           $220 = (+($$0$i6$i|0));
           $221 = $219 < $220;
           if ($221) {
            break L66;
           }
           $222 = +HEAPF32[$128>>2];
           $223 = $217 - $222;
           $224 = $223 > $220;
           if ($224) {
            break L66;
           }
          }
          $225 = (($202) + 1)|0;
          $226 = ($225|0)<($146|0);
          if ($226) {
           $202 = $225;$err$010$i = $err$1$i;$mse$011$i = $210;$n$012$i = $211;$y$09$i = $y$1$i;
          } else {
           $mse$0$lcssa$i = $210;$n$0$lcssa$i = $211;
           break;
          }
         }
        } else {
         $mse$0$lcssa$i = $181;$n$0$lcssa$i = 1;
        }
        $227 = +HEAPF32[$127>>2];
        $228 = $227 * $227;
        $229 = (+($n$0$lcssa$i|0));
        $230 = $228 / $229;
        $231 = +HEAPF32[$129>>2];
        $232 = $230 > $231;
        if (!($232)) {
         $233 = +HEAPF32[$128>>2];
         $234 = $233 * $233;
         $235 = $234 / $229;
         $236 = $235 > $231;
         if (!($236)) {
          $237 = (($mse$0$lcssa$i|0) / ($n$0$lcssa$i|0))&-1;
          $238 = (+($237|0));
          $239 = $238 > $231;
          if ($239) {
           break;
          }
         }
        }
        $272 = (($fit_valueA) + ($i$687<<2)|0);
        HEAP32[$272>>2] = -200;
        $273 = (($fit_valueB) + ($i$687<<2)|0);
        HEAP32[$273>>2] = -200;
        break L52;
       }
      } while(0);
      HEAP32[$ly0>>2] = -200;
      HEAP32[$ly1>>2] = -200;
      HEAP32[$hy0>>2] = -200;
      HEAP32[$hy1>>2] = -200;
      $240 = (($fits) + (($140*56)|0)|0);
      $241 = (($131) - ($140))|0;
      $242 = (_fit_line($240,$241,$ly0,$ly1,$1)|0);
      $243 = (($fits) + (($131*56)|0)|0);
      $244 = (($142) - ($131))|0;
      $245 = (_fit_line($243,$244,$hy0,$hy1,$1)|0);
      $246 = ($242|0)!=(0);
      if ($246) {
       HEAP32[$ly0>>2] = $$0$i54;
       $247 = HEAP32[$hy0>>2]|0;
       HEAP32[$ly1>>2] = $247;
      }
      $248 = ($245|0)==(0);
      if (!($248)) {
       $249 = HEAP32[$ly1>>2]|0;
       HEAP32[$hy0>>2] = $249;
       HEAP32[$hy1>>2] = $$0$i63;
       if ($246) {
        $250 = (($fit_valueA) + ($i$687<<2)|0);
        HEAP32[$250>>2] = -200;
        $251 = (($fit_valueB) + ($i$687<<2)|0);
        HEAP32[$251>>2] = -200;
        break;
       }
      }
      $252 = HEAP32[$ly0>>2]|0;
      HEAP32[$150>>2] = $252;
      $253 = ($133|0)==(0);
      if ($253) {
       HEAP32[$fit_valueA>>2] = $252;
      }
      $254 = HEAP32[$ly1>>2]|0;
      $255 = (($fit_valueA) + ($i$687<<2)|0);
      HEAP32[$255>>2] = $254;
      $256 = HEAP32[$hy0>>2]|0;
      $257 = (($fit_valueB) + ($i$687<<2)|0);
      HEAP32[$257>>2] = $256;
      $258 = HEAP32[$hy1>>2]|0;
      HEAP32[$155>>2] = $258;
      $259 = ($135|0)==(1);
      if ($259) {
       HEAP32[$123>>2] = $258;
      }
      $260 = $256 & $254;
      $261 = ($260|0)>(-1);
      if ($261) {
       $262 = ($131|0)>(0);
       L95: do {
        if ($262) {
         $j$080$in = $131;
         while(1) {
          $j$080 = (($j$080$in) + -1)|0;
          $264 = (($hineighbor) + ($j$080<<2)|0);
          $265 = HEAP32[$264>>2]|0;
          $266 = ($265|0)==($135|0);
          if (!($266)) {
           break L95;
          }
          HEAP32[$264>>2] = $i$687;
          $267 = ($j$080$in|0)>(1);
          if ($267) {
           $j$080$in = $j$080;
          } else {
           break;
          }
         }
        }
       } while(0);
       $j$183 = (($131) + 1)|0;
       $263 = ($j$183|0)<($5|0);
       if ($263) {
        $j$184 = $j$183;
        while(1) {
         $268 = (($loneighbor) + ($j$184<<2)|0);
         $269 = HEAP32[$268>>2]|0;
         $270 = ($269|0)==($133|0);
         if (!($270)) {
          break L52;
         }
         HEAP32[$268>>2] = $i$687;
         $j$1 = (($j$184) + 1)|0;
         $271 = ($j$1|0)<($5|0);
         if ($271) {
          $j$184 = $j$1;
         } else {
          break;
         }
        }
       }
      }
     }
    } while(0);
    $274 = (($i$687) + 1)|0;
    $275 = ($274|0)<($5|0);
    if ($275) {
     $i$687 = $274;
    } else {
     label = 68;
     break;
    }
   }
   if ((label|0) == 38) {
    _exit(1);
    // unreachable;
   }
   else if ((label|0) == 68) {
    $$pre116 = HEAP32[$fit_valueA>>2]|0;
    $$pre117 = HEAP32[$fit_valueB>>2]|0;
    $278 = $$pre116;$280 = $$pre117;
    break;
   }
  } else {
   $278 = $121;$280 = $121;
  }
 } while(0);
 $276 = $5 << 2;
 $277 = (__vorbis_block_alloc($vb,$276)|0);
 $279 = ($278|0)<(0);
 if ($279) {
  $$0$i10 = $280;
 } else {
  $281 = ($280|0)<(0);
  if ($281) {
   $$0$i10 = $278;
  } else {
   $282 = (($280) + ($278))|0;
   $283 = $282 >> 1;
   $$0$i10 = $283;
  }
 }
 HEAP32[$277>>2] = $$0$i10;
 $284 = HEAP32[$124>>2]|0;
 $285 = ($284|0)<(0);
 $286 = HEAP32[$123>>2]|0;
 if ($285) {
  $$0$i8 = $286;
 } else {
  $287 = ($286|0)<(0);
  if ($287) {
   $$0$i8 = $284;
  } else {
   $288 = (($286) + ($284))|0;
   $289 = $288 >> 1;
   $$0$i8 = $289;
  }
 }
 $290 = ((($277)) + 4|0);
 HEAP32[$290>>2] = $$0$i8;
 if ($125) {
  $i$778 = 2;
 } else {
  $output$0 = $277;
  STACKTOP = sp;return ($output$0|0);
 }
 while(1) {
  $291 = (($i$778) + -2)|0;
  $292 = (((($look)) + 1032|0) + ($291<<2)|0);
  $293 = HEAP32[$292>>2]|0;
  $294 = (((($look)) + 780|0) + ($291<<2)|0);
  $295 = HEAP32[$294>>2]|0;
  $296 = (((($1)) + 836|0) + ($293<<2)|0);
  $297 = HEAP32[$296>>2]|0;
  $298 = (((($1)) + 836|0) + ($295<<2)|0);
  $299 = HEAP32[$298>>2]|0;
  $300 = (($277) + ($293<<2)|0);
  $301 = HEAP32[$300>>2]|0;
  $302 = (($277) + ($295<<2)|0);
  $303 = HEAP32[$302>>2]|0;
  $304 = (((($1)) + 836|0) + ($i$778<<2)|0);
  $305 = HEAP32[$304>>2]|0;
  $306 = $301 & 32767;
  $307 = $303 & 32767;
  $308 = (($307) - ($306))|0;
  $309 = (($299) - ($297))|0;
  $ispos$i = ($308|0)>(-1);
  $neg$i = (0 - ($308))|0;
  $310 = $ispos$i ? $308 : $neg$i;
  $311 = (($305) - ($297))|0;
  $312 = Math_imul($310, $311)|0;
  $313 = (($312|0) / ($309|0))&-1;
  $314 = ($308|0)<(0);
  $315 = (0 - ($313))|0;
  $$0$p$i = $314 ? $315 : $313;
  $$0$i7 = (($$0$p$i) + ($306))|0;
  $316 = (($fit_valueA) + ($i$778<<2)|0);
  $317 = HEAP32[$316>>2]|0;
  $318 = ($317|0)<(0);
  $319 = (($fit_valueB) + ($i$778<<2)|0);
  $320 = HEAP32[$319>>2]|0;
  if ($318) {
   $$0$i = $320;
  } else {
   $321 = ($320|0)<(0);
   if ($321) {
    $$0$i = $317;
   } else {
    $322 = (($320) + ($317))|0;
    $323 = $322 >> 1;
    $$0$i = $323;
   }
  }
  $324 = ($$0$i|0)<(0);
  $325 = ($$0$i7|0)==($$0$i|0);
  $or$cond6 = $324 | $325;
  $326 = $$0$i7 | 32768;
  $$$0$i = $or$cond6 ? $326 : $$0$i;
  $327 = (($277) + ($i$778<<2)|0);
  HEAP32[$327>>2] = $$$0$i;
  $328 = (($i$778) + 1)|0;
  $exitcond = ($328|0)==($5|0);
  if ($exitcond) {
   $output$0 = $277;
   break;
  } else {
   $i$778 = $328;
  }
 }
 STACKTOP = sp;return ($output$0|0);
}
function _floor1_interpolate_fit($vb,$look,$A,$B,$del) {
 $vb = $vb|0;
 $look = $look|0;
 $A = $A|0;
 $B = $B|0;
 $del = $del|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $exitcond = 0, $i$02 = 0, $or$cond = 0, $output$0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($look)) + 1284|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ($A|0)!=(0|0);
 $3 = ($B|0)!=(0|0);
 $or$cond = $2 & $3;
 if (!($or$cond)) {
  $output$0 = 0;
  return ($output$0|0);
 }
 $4 = $1 << 2;
 $5 = (__vorbis_block_alloc($vb,$4)|0);
 $6 = ($1|0)>(0);
 if (!($6)) {
  $output$0 = $5;
  return ($output$0|0);
 }
 $7 = (65536 - ($del))|0;
 $i$02 = 0;
 while(1) {
  $8 = (($A) + ($i$02<<2)|0);
  $9 = HEAP32[$8>>2]|0;
  $10 = $9 & 32767;
  $11 = Math_imul($10, $7)|0;
  $12 = (($B) + ($i$02<<2)|0);
  $13 = HEAP32[$12>>2]|0;
  $14 = $13 & 32767;
  $15 = Math_imul($14, $del)|0;
  $16 = (($11) + 32768)|0;
  $17 = (($16) + ($15))|0;
  $18 = $17 >> 16;
  $19 = (($5) + ($i$02<<2)|0);
  HEAP32[$19>>2] = $18;
  $20 = HEAP32[$8>>2]|0;
  $21 = $20 & 32768;
  $22 = ($21|0)==(0);
  if (!($22)) {
   $23 = HEAP32[$12>>2]|0;
   $24 = $23 & 32768;
   $25 = ($24|0)==(0);
   if (!($25)) {
    $26 = $18 | 32768;
    HEAP32[$19>>2] = $26;
   }
  }
  $27 = (($i$02) + 1)|0;
  $exitcond = ($27|0)==($1|0);
  if ($exitcond) {
   $output$0 = $5;
   break;
  } else {
   $i$02 = $27;
  }
 }
 return ($output$0|0);
}
function _floor1_encode($opb,$vb,$look,$post,$ilogmask) {
 $opb = $opb|0;
 $vb = $vb|0;
 $look = $look|0;
 $post = $post|0;
 $ilogmask = $ilogmask|0;
 var $$ = 0, $$0 = 0, $$0$i = 0, $$0$p$i = 0, $$phi$trans$insert = 0, $$pn$i = 0, $$pre = 0, $$pre50 = 0, $$pre51 = 0, $$sink = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0;
 var $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0;
 var $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0;
 var $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0;
 var $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0;
 var $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0, $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0;
 var $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0, $206 = 0, $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0;
 var $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0, $224 = 0, $225 = 0, $226 = 0, $227 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0;
 var $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0;
 var $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0;
 var $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $bookas = 0, $cshift$021 = 0;
 var $cshift$021$us = 0, $cval$0$lcssa = 0, $cval$020 = 0, $cval$020$us = 0, $err$04$i = 0, $err$1$i = 0, $exitcond = 0, $exitcond$i = 0, $exitcond46 = 0, $exitcond47 = 0, $exitcond48 = 0, $exitcond49 = 0, $hx$0$lcssa = 0, $hx$011 = 0, $hx$1 = 0, $i$040 = 0, $i$135 = 0, $i$231 = 0, $ispos$i = 0, $ispos$i1 = 0;
 var $ispos1$i = 0, $j$027 = 0, $j$110 = 0, $j$29 = 0, $k$016 = 0, $k$122 = 0, $k$122$us = 0, $k$224 = 0, $l$018$us = 0, $l$018$us$lcssa = 0, $lx$012 = 0, $lx$1 = 0, $ly$0$lcssa = 0, $ly$013 = 0, $ly$1 = 0, $maxval = 0, $neg$i = 0, $neg$i2 = 0, $neg2$i = 0, $or$cond = 0;
 var $out = 0, $val$0 = 0, $val1$0 = 0, $x1$n$i = 0, $y$03$i = 0, $y$1$i = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 336|0;
 $out = sp + 64|0;
 $bookas = sp + 32|0;
 $maxval = sp;
 $0 = ((($look)) + 1296|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($look)) + 1284|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ((($vb)) + 64|0);
 $5 = HEAP32[$4>>2]|0;
 $6 = ((($5)) + 4|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = ((($7)) + 28|0);
 $9 = HEAP32[$8>>2]|0;
 $10 = ((($9)) + 2848|0);
 $11 = HEAP32[$10>>2]|0;
 $12 = ($post|0)==(0|0);
 if ($12) {
  _oggpack_write($opb,0,1);
  $224 = ((($vb)) + 36|0);
  $225 = HEAP32[$224>>2]|0;
  $226 = (($225|0) / 2)&-1;
  $227 = $226 << 2;
  _memset(($ilogmask|0),0,($227|0))|0;
  $$0 = 0;
  STACKTOP = sp;return ($$0|0);
 }
 $13 = ($3|0)>(0);
 if ($13) {
  $14 = ((($1)) + 832|0);
  $i$040 = 0;
  while(1) {
   $15 = (($post) + ($i$040<<2)|0);
   $16 = HEAP32[$15>>2]|0;
   $17 = $16 & 32767;
   $18 = HEAP32[$14>>2]|0;
   if ((($18|0) == 4)) {
    $22 = $17 >>> 4;
    $val$0 = $22;
   } else if ((($18|0) == 1)) {
    $19 = $17 >>> 2;
    $val$0 = $19;
   } else if ((($18|0) == 2)) {
    $20 = $17 >>> 3;
    $val$0 = $20;
   } else if ((($18|0) == 3)) {
    $21 = (($17>>>0) / 12)&-1;
    $val$0 = $21;
   } else {
    $val$0 = $17;
   }
   $23 = $16 & 32768;
   $24 = $23 | $val$0;
   HEAP32[$15>>2] = $24;
   $25 = (($i$040) + 1)|0;
   $exitcond49 = ($25|0)==($3|0);
   if ($exitcond49) {
    break;
   } else {
    $i$040 = $25;
   }
  }
 }
 $26 = HEAP32[$post>>2]|0;
 HEAP32[$out>>2] = $26;
 $27 = ((($post)) + 4|0);
 $28 = HEAP32[$27>>2]|0;
 $29 = ((($out)) + 4|0);
 HEAP32[$29>>2] = $28;
 $30 = ($3|0)>(2);
 $31 = ((($look)) + 1292|0);
 if ($30) {
  $i$135 = 2;
  while(1) {
   $32 = (($i$135) + -2)|0;
   $33 = (((($look)) + 1032|0) + ($32<<2)|0);
   $34 = HEAP32[$33>>2]|0;
   $35 = (((($look)) + 780|0) + ($32<<2)|0);
   $36 = HEAP32[$35>>2]|0;
   $37 = (((($1)) + 836|0) + ($34<<2)|0);
   $38 = HEAP32[$37>>2]|0;
   $39 = (((($1)) + 836|0) + ($36<<2)|0);
   $40 = HEAP32[$39>>2]|0;
   $41 = (($post) + ($34<<2)|0);
   $42 = HEAP32[$41>>2]|0;
   $43 = (($post) + ($36<<2)|0);
   $44 = HEAP32[$43>>2]|0;
   $45 = (((($1)) + 836|0) + ($i$135<<2)|0);
   $46 = HEAP32[$45>>2]|0;
   $47 = $42 & 32767;
   $48 = $44 & 32767;
   $49 = (($48) - ($47))|0;
   $50 = (($40) - ($38))|0;
   $ispos$i = ($49|0)>(-1);
   $neg$i = (0 - ($49))|0;
   $51 = $ispos$i ? $49 : $neg$i;
   $52 = (($46) - ($38))|0;
   $53 = Math_imul($51, $52)|0;
   $54 = (($53|0) / ($50|0))&-1;
   $55 = ($49|0)<(0);
   $56 = (0 - ($54))|0;
   $$0$p$i = $55 ? $56 : $54;
   $$0$i = (($$0$p$i) + ($47))|0;
   $57 = (($post) + ($i$135<<2)|0);
   $58 = HEAP32[$57>>2]|0;
   $59 = $58 & 32768;
   $60 = ($59|0)!=(0);
   $61 = ($58|0)==($$0$i|0);
   $or$cond = $60 | $61;
   if ($or$cond) {
    $62 = $$0$i | 32768;
    HEAP32[$57>>2] = $62;
    $63 = (($out) + ($i$135<<2)|0);
    HEAP32[$63>>2] = 0;
   } else {
    $64 = HEAP32[$31>>2]|0;
    $65 = (($64) - ($$0$i))|0;
    $66 = ($65|0)<($$0$i|0);
    $$ = $66 ? $65 : $$0$i;
    $67 = (($58) - ($$0$i))|0;
    $68 = ($67|0)<(0);
    do {
     if ($68) {
      $69 = (0 - ($$))|0;
      $70 = ($67|0)<($69|0);
      if ($70) {
       $71 = $67 ^ -1;
       $72 = (($$) + ($71))|0;
       $val1$0 = $72;
       break;
      } else {
       $73 = $67 << 1;
       $74 = $73 ^ -1;
       $val1$0 = $74;
       break;
      }
     } else {
      $75 = ($$|0)>($67|0);
      if ($75) {
       $77 = $67 << 1;
       $val1$0 = $77;
       break;
      } else {
       $76 = (($$) + ($67))|0;
       $val1$0 = $76;
       break;
      }
     }
    } while(0);
    $78 = (($out) + ($i$135<<2)|0);
    HEAP32[$78>>2] = $val1$0;
    HEAP32[$41>>2] = $47;
    $79 = HEAP32[$43>>2]|0;
    $80 = $79 & 32767;
    HEAP32[$43>>2] = $80;
   }
   $81 = (($i$135) + 1)|0;
   $exitcond48 = ($81|0)==($3|0);
   if ($exitcond48) {
    break;
   } else {
    $i$135 = $81;
   }
  }
  $$pre = HEAP32[$out>>2]|0;
  $$pre50 = HEAP32[$29>>2]|0;
  $95 = $$pre;$99 = $$pre50;
 } else {
  $95 = $26;$99 = $28;
 }
 _oggpack_write($opb,1,1);
 $82 = ((($look)) + 1308|0);
 $83 = HEAP32[$82>>2]|0;
 $84 = (($83) + 1)|0;
 HEAP32[$82>>2] = $84;
 $85 = HEAP32[$31>>2]|0;
 $86 = (($85) + -1)|0;
 $87 = (_ov_ilog($86)|0);
 $88 = $87 << 1;
 $89 = ((($look)) + 1304|0);
 $90 = HEAP32[$89>>2]|0;
 $91 = (($90) + ($88))|0;
 HEAP32[$89>>2] = $91;
 $92 = HEAP32[$31>>2]|0;
 $93 = (($92) + -1)|0;
 $94 = (_ov_ilog($93)|0);
 _oggpack_write($opb,$95,$94);
 $96 = HEAP32[$31>>2]|0;
 $97 = (($96) + -1)|0;
 $98 = (_ov_ilog($97)|0);
 _oggpack_write($opb,$99,$98);
 $100 = HEAP32[$1>>2]|0;
 $101 = ($100|0)>(0);
 if ($101) {
  $102 = ((($look)) + 1300|0);
  $i$231 = 0;$j$027 = 2;
  while(1) {
   $103 = (((($1)) + 4|0) + ($i$231<<2)|0);
   $104 = HEAP32[$103>>2]|0;
   $105 = (((($1)) + 128|0) + ($104<<2)|0);
   $106 = HEAP32[$105>>2]|0;
   $107 = (((($1)) + 192|0) + ($104<<2)|0);
   $108 = HEAP32[$107>>2]|0;
   $109 = 1 << $108;
   ;HEAP32[$bookas>>2]=0|0;HEAP32[$bookas+4>>2]=0|0;HEAP32[$bookas+8>>2]=0|0;HEAP32[$bookas+12>>2]=0|0;HEAP32[$bookas+16>>2]=0|0;HEAP32[$bookas+20>>2]=0|0;HEAP32[$bookas+24>>2]=0|0;HEAP32[$bookas+28>>2]=0|0;
   $110 = ($108|0)==(0);
   if (!($110)) {
    ;HEAP32[$maxval>>2]=0|0;HEAP32[$maxval+4>>2]=0|0;HEAP32[$maxval+8>>2]=0|0;HEAP32[$maxval+12>>2]=0|0;HEAP32[$maxval+16>>2]=0|0;HEAP32[$maxval+20>>2]=0|0;HEAP32[$maxval+24>>2]=0|0;HEAP32[$maxval+28>>2]=0|0;
    $111 = ($108|0)==(31);
    if (!($111)) {
     $k$016 = 0;
     while(1) {
      $127 = ((((($1)) + 320|0) + ($104<<5)|0) + ($k$016<<2)|0);
      $128 = HEAP32[$127>>2]|0;
      $129 = ($128|0)<(0);
      if ($129) {
       $$sink = 1;
      } else {
       $130 = (((($9)) + 1824|0) + ($128<<2)|0);
       $131 = HEAP32[$130>>2]|0;
       $132 = ((($131)) + 4|0);
       $133 = HEAP32[$132>>2]|0;
       $$sink = $133;
      }
      $134 = (($maxval) + ($k$016<<2)|0);
      HEAP32[$134>>2] = $$sink;
      $135 = (($k$016) + 1)|0;
      $136 = ($135|0)<($109|0);
      if ($136) {
       $k$016 = $135;
      } else {
       break;
      }
     }
    }
    $112 = ($106|0)>(0);
    L48: do {
     if ($112) {
      if ($111) {
       $cshift$021 = 0;$cval$020 = 0;$k$122 = 0;
       while(1) {
        $137 = (($bookas) + ($k$122<<2)|0);
        $138 = HEAP32[$137>>2]|0;
        $139 = $138 << $cshift$021;
        $140 = $139 | $cval$020;
        $141 = (($cshift$021) + 31)|0;
        $142 = (($k$122) + 1)|0;
        $exitcond = ($142|0)==($106|0);
        if ($exitcond) {
         $cval$0$lcssa = $140;
         break L48;
        } else {
         $cshift$021 = $141;$cval$020 = $140;$k$122 = $142;
        }
       }
      } else {
       $cshift$021$us = 0;$cval$020$us = 0;$k$122$us = 0;
      }
      while(1) {
       $125 = (($k$122$us) + ($j$027))|0;
       $126 = (($out) + ($125<<2)|0);
       $115 = HEAP32[$126>>2]|0;
       $l$018$us = 0;
       while(1) {
        $113 = (($maxval) + ($l$018$us<<2)|0);
        $114 = HEAP32[$113>>2]|0;
        $116 = ($115|0)<($114|0);
        if ($116) {
         $l$018$us$lcssa = $l$018$us;
         label = 31;
         break;
        }
        $117 = (($l$018$us) + 1)|0;
        $118 = ($117|0)<($109|0);
        if ($118) {
         $l$018$us = $117;
        } else {
         label = 33;
         break;
        }
       }
       if ((label|0) == 31) {
        label = 0;
        $119 = (($bookas) + ($k$122$us<<2)|0);
        HEAP32[$119>>2] = $l$018$us$lcssa;
        $121 = $l$018$us$lcssa;
       }
       else if ((label|0) == 33) {
        label = 0;
        $$phi$trans$insert = (($bookas) + ($k$122$us<<2)|0);
        $$pre51 = HEAP32[$$phi$trans$insert>>2]|0;
        $121 = $$pre51;
       }
       $120 = $121 << $cshift$021$us;
       $122 = $120 | $cval$020$us;
       $123 = (($cshift$021$us) + ($108))|0;
       $124 = (($k$122$us) + 1)|0;
       $exitcond47 = ($124|0)==($106|0);
       if ($exitcond47) {
        $cval$0$lcssa = $122;
        break;
       } else {
        $cshift$021$us = $123;$cval$020$us = $122;$k$122$us = $124;
       }
      }
     } else {
      $cval$0$lcssa = 0;
     }
    } while(0);
    $143 = (((($1)) + 256|0) + ($104<<2)|0);
    $144 = HEAP32[$143>>2]|0;
    $145 = (($11) + (($144*56)|0)|0);
    $146 = (_vorbis_book_encode($145,$cval$0$lcssa,$opb)|0);
    $147 = HEAP32[$102>>2]|0;
    $148 = (($147) + ($146))|0;
    HEAP32[$102>>2] = $148;
   }
   $149 = ($106|0)>(0);
   if ($149) {
    $k$224 = 0;
    while(1) {
     $150 = (($bookas) + ($k$224<<2)|0);
     $151 = HEAP32[$150>>2]|0;
     $152 = ((((($1)) + 320|0) + ($104<<5)|0) + ($151<<2)|0);
     $153 = HEAP32[$152>>2]|0;
     $154 = ($153|0)>(-1);
     if ($154) {
      $155 = (($k$224) + ($j$027))|0;
      $156 = (($out) + ($155<<2)|0);
      $157 = HEAP32[$156>>2]|0;
      $158 = (((($11) + (($153*56)|0)|0)) + 4|0);
      $159 = HEAP32[$158>>2]|0;
      $160 = ($157|0)<($159|0);
      if ($160) {
       $161 = (($11) + (($153*56)|0)|0);
       $162 = (_vorbis_book_encode($161,$157,$opb)|0);
       $163 = HEAP32[$89>>2]|0;
       $164 = (($163) + ($162))|0;
       HEAP32[$89>>2] = $164;
      }
     }
     $165 = (($k$224) + 1)|0;
     $exitcond46 = ($165|0)==($106|0);
     if ($exitcond46) {
      break;
     } else {
      $k$224 = $165;
     }
    }
   }
   $166 = (($106) + ($j$027))|0;
   $167 = (($i$231) + 1)|0;
   $168 = HEAP32[$1>>2]|0;
   $169 = ($167|0)<($168|0);
   if ($169) {
    $i$231 = $167;$j$027 = $166;
   } else {
    break;
   }
  }
 }
 $170 = HEAP32[$post>>2]|0;
 $171 = ((($1)) + 832|0);
 $172 = HEAP32[$171>>2]|0;
 $173 = Math_imul($172, $170)|0;
 $174 = ((($vb)) + 28|0);
 $175 = HEAP32[$174>>2]|0;
 $176 = (($9) + ($175<<2)|0);
 $177 = HEAP32[$176>>2]|0;
 $178 = (($177|0) / 2)&-1;
 $179 = HEAP32[$2>>2]|0;
 $180 = ($179|0)>(1);
 if ($180) {
  $hx$011 = 0;$j$110 = 1;$lx$012 = 0;$ly$013 = $173;
  while(1) {
   $185 = (((($look)) + 260|0) + ($j$110<<2)|0);
   $186 = HEAP32[$185>>2]|0;
   $187 = (($post) + ($186<<2)|0);
   $188 = HEAP32[$187>>2]|0;
   $189 = $188 & 32767;
   $190 = ($189|0)==($188|0);
   if ($190) {
    $191 = HEAP32[$171>>2]|0;
    $192 = Math_imul($191, $188)|0;
    $193 = (((($1)) + 836|0) + ($186<<2)|0);
    $194 = HEAP32[$193>>2]|0;
    $195 = (($192) - ($ly$013))|0;
    $196 = (($194) - ($lx$012))|0;
    $ispos$i1 = ($195|0)>(-1);
    $neg$i2 = (0 - ($195))|0;
    $197 = $ispos$i1 ? $195 : $neg$i2;
    $198 = (($195|0) / ($196|0))&-1;
    $199 = $195 >> 31;
    $200 = $199 | 1;
    $201 = Math_imul($198, $196)|0;
    $ispos1$i = ($201|0)>(-1);
    $neg2$i = (0 - ($201))|0;
    $202 = $ispos1$i ? $201 : $neg2$i;
    $203 = (($197) - ($202))|0;
    $204 = ($178|0)>($194|0);
    $x1$n$i = $204 ? $194 : $178;
    $205 = ($x1$n$i|0)>($lx$012|0);
    if ($205) {
     $206 = (($ilogmask) + ($lx$012<<2)|0);
     HEAP32[$206>>2] = $ly$013;
    }
    $207 = (($lx$012) + 1)|0;
    $208 = ($207|0)<($x1$n$i|0);
    if ($208) {
     $214 = $207;$err$04$i = 0;$y$03$i = $ly$013;
     while(1) {
      $209 = (($err$04$i) + ($203))|0;
      $210 = ($209|0)<($196|0);
      $211 = $210 ? 0 : $200;
      $212 = $210 ? 0 : $196;
      $err$1$i = (($209) - ($212))|0;
      $$pn$i = (($y$03$i) + ($198))|0;
      $y$1$i = (($$pn$i) + ($211))|0;
      $213 = (($ilogmask) + ($214<<2)|0);
      HEAP32[$213>>2] = $y$1$i;
      $215 = (($214) + 1)|0;
      $exitcond$i = ($215|0)==($x1$n$i|0);
      if ($exitcond$i) {
       $hx$1 = $194;$lx$1 = $194;$ly$1 = $192;
       break;
      } else {
       $214 = $215;$err$04$i = $err$1$i;$y$03$i = $y$1$i;
      }
     }
    } else {
     $hx$1 = $194;$lx$1 = $194;$ly$1 = $192;
    }
   } else {
    $hx$1 = $hx$011;$lx$1 = $lx$012;$ly$1 = $ly$013;
   }
   $216 = (($j$110) + 1)|0;
   $217 = HEAP32[$2>>2]|0;
   $218 = ($216|0)<($217|0);
   if ($218) {
    $hx$011 = $hx$1;$j$110 = $216;$lx$012 = $lx$1;$ly$013 = $ly$1;
   } else {
    $hx$0$lcssa = $hx$1;$ly$0$lcssa = $ly$1;
    break;
   }
  }
 } else {
  $hx$0$lcssa = 0;$ly$0$lcssa = $173;
 }
 $181 = ((($vb)) + 36|0);
 $182 = HEAP32[$181>>2]|0;
 $183 = (($182|0) / 2)&-1;
 $184 = ($hx$0$lcssa|0)<($183|0);
 if ($184) {
  $j$29 = $hx$0$lcssa;
 } else {
  $$0 = 1;
  STACKTOP = sp;return ($$0|0);
 }
 while(1) {
  $219 = (($ilogmask) + ($j$29<<2)|0);
  HEAP32[$219>>2] = $ly$0$lcssa;
  $220 = (($j$29) + 1)|0;
  $221 = HEAP32[$181>>2]|0;
  $222 = (($221|0) / 2)&-1;
  $223 = ($220|0)<($222|0);
  if ($223) {
   $j$29 = $220;
  } else {
   $$0 = 1;
   break;
  }
 }
 STACKTOP = sp;return ($$0|0);
}
function _fit_line($a,$fits,$y0,$y1,$info) {
 $a = $a|0;
 $fits = $fits|0;
 $y0 = $y0|0;
 $y1 = $y1|0;
 $info = $info|0;
 var $$0 = 0, $$pr = 0, $$pre = 0, $$pre15 = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0.0, $101 = 0.0, $102 = 0.0, $103 = 0, $104 = 0.0, $105 = 0.0, $106 = 0.0, $107 = 0.0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0;
 var $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0, $118 = 0, $12 = 0.0, $13 = 0.0, $14 = 0, $15 = 0.0, $16 = 0.0, $17 = 0.0, $18 = 0.0, $19 = 0, $2 = 0, $20 = 0, $21 = 0.0, $22 = 0, $23 = 0;
 var $24 = 0.0, $25 = 0.0, $26 = 0.0, $27 = 0.0, $28 = 0, $29 = 0, $3 = 0, $30 = 0.0, $31 = 0, $32 = 0, $33 = 0.0, $34 = 0.0, $35 = 0.0, $36 = 0.0, $37 = 0, $38 = 0, $39 = 0.0, $4 = 0, $40 = 0, $41 = 0;
 var $42 = 0.0, $43 = 0.0, $44 = 0.0, $45 = 0.0, $46 = 0, $47 = 0, $48 = 0.0, $49 = 0, $5 = 0, $50 = 0, $51 = 0.0, $52 = 0.0, $53 = 0.0, $54 = 0.0, $55 = 0.0, $56 = 0.0, $57 = 0.0, $58 = 0.0, $59 = 0.0, $6 = 0.0;
 var $60 = 0, $61 = 0, $62 = 0, $63 = 0.0, $64 = 0.0, $65 = 0.0, $66 = 0.0, $67 = 0, $68 = 0.0, $69 = 0.0, $7 = 0, $70 = 0, $71 = 0.0, $72 = 0.0, $73 = 0.0, $74 = 0, $75 = 0, $76 = 0.0, $77 = 0.0, $78 = 0.0;
 var $79 = 0.0, $8 = 0, $80 = 0, $81 = 0.0, $82 = 0.0, $83 = 0, $84 = 0.0, $85 = 0.0, $86 = 0.0, $87 = 0.0, $88 = 0.0, $89 = 0.0, $9 = 0, $90 = 0, $91 = 0.0, $92 = 0.0, $93 = 0.0, $94 = 0.0, $95 = 0.0, $96 = 0.0;
 var $97 = 0.0, $98 = 0.0, $99 = 0.0, $bn$0$lcssa = 0.0, $bn$01 = 0.0, $bn$1 = 0.0, $bn$2 = 0.0, $exitcond = 0, $i$02 = 0, $x2b$0$lcssa = 0.0, $x2b$04 = 0.0, $x2b$1 = 0.0, $x2b$2 = 0.0, $xb$0$lcssa = 0.0, $xb$06 = 0.0, $xb$1 = 0.0, $xb$2 = 0.0, $xyb$0$lcssa = 0.0, $xyb$03 = 0.0, $xyb$1 = 0.0;
 var $xyb$2 = 0.0, $yb$0$lcssa = 0.0, $yb$05 = 0.0, $yb$1 = 0.0, $yb$2 = 0.0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = HEAP32[$a>>2]|0;
 $1 = (($fits) + -1)|0;
 $2 = (((($a) + (($1*56)|0)|0)) + 4|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ($fits|0)>(0);
 if ($4) {
  $5 = ((($info)) + 1108|0);
  $6 = +HEAPF32[$5>>2];
  $bn$01 = 0.0;$i$02 = 0;$x2b$04 = 0.0;$xb$06 = 0.0;$xyb$03 = 0.0;$yb$05 = 0.0;
  while(1) {
   $7 = (((($a) + (($i$02*56)|0)|0)) + 52|0);
   $8 = HEAP32[$7>>2]|0;
   $9 = (((($a) + (($i$02*56)|0)|0)) + 28|0);
   $10 = HEAP32[$9>>2]|0;
   $11 = (($10) + ($8))|0;
   $12 = (+($11|0));
   $13 = $12 * $6;
   $14 = (($10) + 1)|0;
   $15 = (+($14|0));
   $16 = $13 / $15;
   $17 = $16;
   $18 = $17 + 1.0;
   $19 = (((($a) + (($i$02*56)|0)|0)) + 32|0);
   $20 = HEAP32[$19>>2]|0;
   $21 = (+($20|0));
   $22 = (((($a) + (($i$02*56)|0)|0)) + 8|0);
   $23 = HEAP32[$22>>2]|0;
   $24 = (+($23|0));
   $25 = $24 * $18;
   $26 = $21 + $xb$06;
   $27 = $26 + $25;
   $28 = (((($a) + (($i$02*56)|0)|0)) + 36|0);
   $29 = HEAP32[$28>>2]|0;
   $30 = (+($29|0));
   $31 = (((($a) + (($i$02*56)|0)|0)) + 12|0);
   $32 = HEAP32[$31>>2]|0;
   $33 = (+($32|0));
   $34 = $33 * $18;
   $35 = $30 + $yb$05;
   $36 = $35 + $34;
   $37 = (((($a) + (($i$02*56)|0)|0)) + 40|0);
   $38 = HEAP32[$37>>2]|0;
   $39 = (+($38|0));
   $40 = (((($a) + (($i$02*56)|0)|0)) + 16|0);
   $41 = HEAP32[$40>>2]|0;
   $42 = (+($41|0));
   $43 = $42 * $18;
   $44 = $39 + $x2b$04;
   $45 = $44 + $43;
   $46 = (((($a) + (($i$02*56)|0)|0)) + 48|0);
   $47 = HEAP32[$46>>2]|0;
   $48 = (+($47|0));
   $49 = (((($a) + (($i$02*56)|0)|0)) + 24|0);
   $50 = HEAP32[$49>>2]|0;
   $51 = (+($50|0));
   $52 = $51 * $18;
   $53 = $48 + $xyb$03;
   $54 = $53 + $52;
   $55 = (+($8|0));
   $56 = (+($10|0));
   $57 = $18 * $56;
   $58 = $55 + $bn$01;
   $59 = $58 + $57;
   $60 = (($i$02) + 1)|0;
   $exitcond = ($60|0)==($fits|0);
   if ($exitcond) {
    $bn$0$lcssa = $59;$x2b$0$lcssa = $45;$xb$0$lcssa = $27;$xyb$0$lcssa = $54;$yb$0$lcssa = $36;
    break;
   } else {
    $bn$01 = $59;$i$02 = $60;$x2b$04 = $45;$xb$06 = $27;$xyb$03 = $54;$yb$05 = $36;
   }
  }
 } else {
  $bn$0$lcssa = 0.0;$x2b$0$lcssa = 0.0;$xb$0$lcssa = 0.0;$xyb$0$lcssa = 0.0;$yb$0$lcssa = 0.0;
 }
 $61 = HEAP32[$y0>>2]|0;
 $62 = ($61|0)>(-1);
 if ($62) {
  $63 = (+($0|0));
  $64 = $xb$0$lcssa + $63;
  $65 = (+($61|0));
  $66 = $65 + $yb$0$lcssa;
  $67 = Math_imul($0, $0)|0;
  $68 = (+($67|0));
  $69 = $x2b$0$lcssa + $68;
  $70 = Math_imul($61, $0)|0;
  $71 = (+($70|0));
  $72 = $71 + $xyb$0$lcssa;
  $73 = $bn$0$lcssa + 1.0;
  $bn$1 = $73;$x2b$1 = $69;$xb$1 = $64;$xyb$1 = $72;$yb$1 = $66;
 } else {
  $bn$1 = $bn$0$lcssa;$x2b$1 = $x2b$0$lcssa;$xb$1 = $xb$0$lcssa;$xyb$1 = $xyb$0$lcssa;$yb$1 = $yb$0$lcssa;
 }
 $74 = HEAP32[$y1>>2]|0;
 $75 = ($74|0)>(-1);
 if ($75) {
  $76 = (+($3|0));
  $77 = $xb$1 + $76;
  $78 = (+($74|0));
  $79 = $78 + $yb$1;
  $80 = Math_imul($3, $3)|0;
  $81 = (+($80|0));
  $82 = $x2b$1 + $81;
  $83 = Math_imul($74, $3)|0;
  $84 = (+($83|0));
  $85 = $84 + $xyb$1;
  $86 = $bn$1 + 1.0;
  $bn$2 = $86;$x2b$2 = $82;$xb$2 = $77;$xyb$2 = $85;$yb$2 = $79;
 } else {
  $bn$2 = $bn$1;$x2b$2 = $x2b$1;$xb$2 = $xb$1;$xyb$2 = $xyb$1;$yb$2 = $yb$1;
 }
 $87 = $x2b$2 * $bn$2;
 $88 = $xb$2 * $xb$2;
 $89 = $87 - $88;
 $90 = $89 > 0.0;
 if (!($90)) {
  HEAP32[$y0>>2] = 0;
  HEAP32[$y1>>2] = 0;
  $$0 = 1;
  return ($$0|0);
 }
 $91 = $yb$2 * $x2b$2;
 $92 = $xb$2 * $xyb$2;
 $93 = $91 - $92;
 $94 = $93 / $89;
 $95 = $xyb$2 * $bn$2;
 $96 = $xb$2 * $yb$2;
 $97 = $95 - $96;
 $98 = $97 / $89;
 $99 = (+($0|0));
 $100 = $98 * $99;
 $101 = $100 + $94;
 $102 = (+_rint($101));
 $103 = (~~(($102)));
 HEAP32[$y0>>2] = $103;
 $104 = (+($3|0));
 $105 = $98 * $104;
 $106 = $105 + $94;
 $107 = (+_rint($106));
 $108 = (~~(($107)));
 HEAP32[$y1>>2] = $108;
 $109 = HEAP32[$y0>>2]|0;
 $110 = ($109|0)>(1023);
 if ($110) {
  HEAP32[$y0>>2] = 1023;
  $$pr = HEAP32[$y1>>2]|0;
  $111 = $$pr;$117 = 1023;
 } else {
  $111 = $108;$117 = $109;
 }
 $112 = ($111|0)>(1023);
 if ($112) {
  HEAP32[$y1>>2] = 1023;
  $$pre = HEAP32[$y0>>2]|0;
  $113 = $$pre;$118 = 1023;
 } else {
  $113 = $117;$118 = $111;
 }
 $114 = ($113|0)<(0);
 if ($114) {
  HEAP32[$y0>>2] = 0;
  $$pre15 = HEAP32[$y1>>2]|0;
  $115 = $$pre15;
 } else {
  $115 = $118;
 }
 $116 = ($115|0)<(0);
 if (!($116)) {
  $$0 = 0;
  return ($$0|0);
 }
 HEAP32[$y1>>2] = 0;
 $$0 = 0;
 return ($$0|0);
}
function _floor1_pack($i,$opb) {
 $i = $i|0;
 $opb = $opb|0;
 var $$maxclass$0 = 0, $$maxclass$0$lcssa = 0, $$pre = 0, $$pre22 = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0;
 var $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0;
 var $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0;
 var $6 = 0, $60 = 0, $7 = 0, $8 = 0, $9 = 0, $count$03 = 0, $exitcond = 0, $exitcond21 = 0, $j$016 = 0, $j$112 = 0, $j$25 = 0, $k$09 = 0, $k$14 = 0, $k$2$lcssa = 0, $k$22 = 0, $maxclass$017 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($i)) + 836|0);
 $1 = ((($i)) + 840|0);
 $2 = HEAP32[$1>>2]|0;
 $3 = HEAP32[$i>>2]|0;
 _oggpack_write($opb,$3,5);
 $4 = HEAP32[$i>>2]|0;
 $5 = ($4|0)>(0);
 if ($5) {
  $6 = ((($i)) + 4|0);
  $j$016 = 0;$maxclass$017 = -1;
  while(1) {
   $12 = (($6) + ($j$016<<2)|0);
   $13 = HEAP32[$12>>2]|0;
   _oggpack_write($opb,$13,4);
   $14 = HEAP32[$12>>2]|0;
   $15 = ($maxclass$017|0)<($14|0);
   $$maxclass$0 = $15 ? $14 : $maxclass$017;
   $16 = (($j$016) + 1)|0;
   $17 = HEAP32[$i>>2]|0;
   $18 = ($16|0)<($17|0);
   if ($18) {
    $j$016 = $16;$maxclass$017 = $$maxclass$0;
   } else {
    $$maxclass$0$lcssa = $$maxclass$0;
    break;
   }
  }
  $7 = ($$maxclass$0$lcssa|0)>(-1);
  if ($7) {
   $8 = ((($i)) + 128|0);
   $9 = ((($i)) + 192|0);
   $10 = ((($i)) + 256|0);
   $11 = ((($i)) + 320|0);
   $j$112 = 0;
   while(1) {
    $19 = (($8) + ($j$112<<2)|0);
    $20 = HEAP32[$19>>2]|0;
    $21 = (($20) + -1)|0;
    _oggpack_write($opb,$21,3);
    $22 = (($9) + ($j$112<<2)|0);
    $23 = HEAP32[$22>>2]|0;
    _oggpack_write($opb,$23,2);
    $24 = HEAP32[$22>>2]|0;
    $25 = ($24|0)==(0);
    if ($25) {
     $k$09 = 0;
     label = 8;
    } else {
     $26 = (($10) + ($j$112<<2)|0);
     $27 = HEAP32[$26>>2]|0;
     _oggpack_write($opb,$27,8);
     $$pre = HEAP32[$22>>2]|0;
     $28 = ($$pre|0)==(31);
     if (!($28)) {
      $k$09 = 0;
      label = 8;
     }
    }
    if ((label|0) == 8) {
     while(1) {
      label = 0;
      $29 = ((($11) + ($j$112<<5)|0) + ($k$09<<2)|0);
      $30 = HEAP32[$29>>2]|0;
      $31 = (($30) + 1)|0;
      _oggpack_write($opb,$31,8);
      $32 = (($k$09) + 1)|0;
      $33 = HEAP32[$22>>2]|0;
      $34 = 1 << $33;
      $35 = ($32|0)<($34|0);
      if ($35) {
       $k$09 = $32;
       label = 8;
      } else {
       break;
      }
     }
    }
    $36 = (($j$112) + 1)|0;
    $exitcond21 = ($j$112|0)==($$maxclass$0$lcssa|0);
    if ($exitcond21) {
     break;
    } else {
     $j$112 = $36;
    }
   }
  }
 }
 $37 = ((($i)) + 832|0);
 $38 = HEAP32[$37>>2]|0;
 $39 = (($38) + -1)|0;
 _oggpack_write($opb,$39,2);
 $40 = (($2) + -1)|0;
 $41 = (_ov_ilog($40)|0);
 _oggpack_write($opb,$41,4);
 $42 = (_ov_ilog($40)|0);
 $43 = HEAP32[$i>>2]|0;
 $44 = ($43|0)>(0);
 if (!($44)) {
  return;
 }
 $45 = ((($i)) + 4|0);
 $46 = ((($i)) + 128|0);
 $60 = $43;$count$03 = 0;$j$25 = 0;$k$14 = 0;
 while(1) {
  $47 = (($45) + ($j$25<<2)|0);
  $48 = HEAP32[$47>>2]|0;
  $49 = (($46) + ($48<<2)|0);
  $50 = HEAP32[$49>>2]|0;
  $51 = (($50) + ($count$03))|0;
  $52 = ($k$14|0)<($51|0);
  if ($52) {
   $k$22 = $k$14;
   while(1) {
    $53 = (($k$22) + 2)|0;
    $54 = (($0) + ($53<<2)|0);
    $55 = HEAP32[$54>>2]|0;
    _oggpack_write($opb,$55,$42);
    $56 = (($k$22) + 1)|0;
    $exitcond = ($56|0)==($51|0);
    if ($exitcond) {
     break;
    } else {
     $k$22 = $56;
    }
   }
   $$pre22 = HEAP32[$i>>2]|0;
   $59 = $$pre22;$k$2$lcssa = $51;
  } else {
   $59 = $60;$k$2$lcssa = $k$14;
  }
  $57 = (($j$25) + 1)|0;
  $58 = ($57|0)<($59|0);
  if ($58) {
   $60 = $59;$count$03 = $51;$j$25 = $57;$k$14 = $k$2$lcssa;
  } else {
   break;
  }
 }
 return;
}
function _floor1_unpack($vi,$opb) {
 $vi = $vi|0;
 $opb = $opb|0;
 var $$01 = 0, $$lcssa = 0, $$maxclass$0 = 0, $$maxclass$0$lcssa = 0, $$phi$trans$insert = 0, $$pre = 0, $$pre$phi50Z2D = 0, $$pre$phi52Z2D = 0, $$pre45 = 0, $$pre47 = 0, $$pre48 = 0, $$pre49 = 0, $$pre51 = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0;
 var $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0;
 var $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0;
 var $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0;
 var $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0;
 var $88 = 0, $89 = 0, $9 = 0, $90 = 0, $count$0$lcssa = 0, $count$023 = 0, $j$037 = 0, $j$132 = 0, $j$225 = 0, $j$315 = 0, $j$414 = 0, $k$029 = 0, $k$124 = 0, $k$2$lcssa = 0, $k$219 = 0, $maxclass$036 = 0, $or$cond = 0, $sortpointer = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 272|0;
 $sortpointer = sp;
 $0 = ((($vi)) + 28|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = (_calloc(1,1120)|0);
 $3 = (_oggpack_read($opb,5)|0);
 HEAP32[$2>>2] = $3;
 $4 = ($3|0)>(0);
 L1: do {
  if ($4) {
   $5 = ((($2)) + 4|0);
   $j$037 = 0;$maxclass$036 = -1;
   while(1) {
    $12 = (_oggpack_read($opb,4)|0);
    $13 = (($5) + ($j$037<<2)|0);
    HEAP32[$13>>2] = $12;
    $14 = ($12|0)<(0);
    if ($14) {
     break L1;
    }
    $15 = ($maxclass$036|0)<($12|0);
    $$maxclass$0 = $15 ? $12 : $maxclass$036;
    $16 = (($j$037) + 1)|0;
    $17 = HEAP32[$2>>2]|0;
    $18 = ($16|0)<($17|0);
    if ($18) {
     $j$037 = $16;$maxclass$036 = $$maxclass$0;
    } else {
     $$maxclass$0$lcssa = $$maxclass$0;
     break;
    }
   }
   $6 = ($$maxclass$0$lcssa|0)>(-1);
   if ($6) {
    $7 = ((($2)) + 128|0);
    $8 = ((($2)) + 192|0);
    $9 = ((($2)) + 256|0);
    $10 = ((($1)) + 24|0);
    $11 = ((($2)) + 320|0);
    $j$132 = 0;
    while(1) {
     $19 = (_oggpack_read($opb,3)|0);
     $20 = (($19) + 1)|0;
     $21 = (($7) + ($j$132<<2)|0);
     HEAP32[$21>>2] = $20;
     $22 = (_oggpack_read($opb,2)|0);
     $23 = (($8) + ($j$132<<2)|0);
     HEAP32[$23>>2] = $22;
     $24 = ($22|0)<(0);
     if ($24) {
      break L1;
     }
     $25 = ($22|0)==(0);
     if ($25) {
      $$phi$trans$insert = (($9) + ($j$132<<2)|0);
      $$pre = HEAP32[$$phi$trans$insert>>2]|0;
      $28 = $$pre;
     } else {
      $26 = (_oggpack_read($opb,8)|0);
      $27 = (($9) + ($j$132<<2)|0);
      HEAP32[$27>>2] = $26;
      $28 = $26;
     }
     $29 = ($28|0)<(0);
     if ($29) {
      break L1;
     }
     $30 = HEAP32[$10>>2]|0;
     $31 = ($28|0)<($30|0);
     if (!($31)) {
      break L1;
     }
     $32 = HEAP32[$23>>2]|0;
     $33 = ($32|0)==(31);
     if (!($33)) {
      $k$029 = 0;
      while(1) {
       $38 = (_oggpack_read($opb,8)|0);
       $39 = (($38) + -1)|0;
       $40 = ((($11) + ($j$132<<5)|0) + ($k$029<<2)|0);
       HEAP32[$40>>2] = $39;
       $41 = ($38|0)<(0);
       if ($41) {
        break L1;
       }
       $42 = HEAP32[$10>>2]|0;
       $43 = ($38|0)>($42|0);
       $36 = (($k$029) + 1)|0;
       if ($43) {
        break L1;
       }
       $34 = HEAP32[$23>>2]|0;
       $35 = 1 << $34;
       $37 = ($36|0)<($35|0);
       if ($37) {
        $k$029 = $36;
       } else {
        break;
       }
      }
     }
     $44 = (($j$132) + 1)|0;
     $45 = ($j$132|0)<($$maxclass$0$lcssa|0);
     if ($45) {
      $j$132 = $44;
     } else {
      label = 18;
      break;
     }
    }
   } else {
    label = 18;
   }
  } else {
   label = 18;
  }
 } while(0);
 L23: do {
  if ((label|0) == 18) {
   $46 = (_oggpack_read($opb,2)|0);
   $47 = (($46) + 1)|0;
   $48 = ((($2)) + 832|0);
   HEAP32[$48>>2] = $47;
   $49 = (_oggpack_read($opb,4)|0);
   $50 = ($49|0)<(0);
   if (!($50)) {
    $51 = HEAP32[$2>>2]|0;
    $52 = ($51|0)>(0);
    if ($52) {
     $53 = ((($2)) + 4|0);
     $54 = ((($2)) + 128|0);
     $55 = ((($2)) + 836|0);
     $56 = 1 << $49;
     $90 = $51;$count$023 = 0;$j$225 = 0;$k$124 = 0;
     while(1) {
      $57 = (($53) + ($j$225<<2)|0);
      $58 = HEAP32[$57>>2]|0;
      $59 = (($54) + ($58<<2)|0);
      $60 = HEAP32[$59>>2]|0;
      $61 = (($60) + ($count$023))|0;
      $62 = ($61|0)>(63);
      if ($62) {
       break L23;
      }
      $63 = ($k$124|0)<($61|0);
      if ($63) {
       $k$219 = $k$124;
       while(1) {
        $64 = (_oggpack_read($opb,$49)|0);
        $65 = (($k$219) + 2)|0;
        $66 = (($55) + ($65<<2)|0);
        HEAP32[$66>>2] = $64;
        $67 = ($64|0)>(-1);
        $68 = ($64|0)<($56|0);
        $or$cond = $67 & $68;
        if (!($or$cond)) {
         break L23;
        }
        $69 = (($k$219) + 1)|0;
        $70 = ($69|0)<($61|0);
        if ($70) {
         $k$219 = $69;
        } else {
         $$lcssa = $69;
         break;
        }
       }
       $$pre45 = HEAP32[$2>>2]|0;
       $73 = $$pre45;$k$2$lcssa = $$lcssa;
      } else {
       $73 = $90;$k$2$lcssa = $k$124;
      }
      $71 = (($j$225) + 1)|0;
      $72 = ($71|0)<($73|0);
      if ($72) {
       $90 = $73;$count$023 = $61;$j$225 = $71;$k$124 = $k$2$lcssa;
      } else {
       $$pre$phi50Z2D = $55;$$pre$phi52Z2D = $56;$count$0$lcssa = $61;
       break;
      }
     }
    } else {
     $$pre49 = ((($2)) + 836|0);
     $$pre51 = 1 << $49;
     $$pre$phi50Z2D = $$pre49;$$pre$phi52Z2D = $$pre51;$count$0$lcssa = 0;
    }
    HEAP32[$$pre$phi50Z2D>>2] = 0;
    $74 = ((($2)) + 840|0);
    HEAP32[$74>>2] = $$pre$phi52Z2D;
    $75 = (($count$0$lcssa) + 2)|0;
    $76 = ($count$0$lcssa|0)>(-2);
    if ($76) {
     $j$315 = 0;
     while(1) {
      $77 = (($$pre$phi50Z2D) + ($j$315<<2)|0);
      $78 = (($sortpointer) + ($j$315<<2)|0);
      HEAP32[$78>>2] = $77;
      $79 = (($j$315) + 1)|0;
      $80 = ($79|0)<($75|0);
      if ($80) {
       $j$315 = $79;
      } else {
       break;
      }
     }
    }
    _qsort($sortpointer,$75,4,8);
    $81 = ($75|0)>(1);
    L43: do {
     if ($81) {
      $$pre47 = HEAP32[$sortpointer>>2]|0;
      $$pre48 = HEAP32[$$pre47>>2]|0;
      $87 = $$pre48;$j$414 = 1;
      while(1) {
       $84 = (($sortpointer) + ($j$414<<2)|0);
       $85 = HEAP32[$84>>2]|0;
       $86 = HEAP32[$85>>2]|0;
       $88 = ($87|0)==($86|0);
       $82 = (($j$414) + 1)|0;
       if ($88) {
        break;
       }
       $83 = ($82|0)<($75|0);
       if ($83) {
        $87 = $86;$j$414 = $82;
       } else {
        break L43;
       }
      }
      $89 = ($2|0)==(0|0);
      if ($89) {
       $$01 = 0;
      } else {
       break L23;
      }
      STACKTOP = sp;return ($$01|0);
     }
    } while(0);
    $$01 = $2;
    STACKTOP = sp;return ($$01|0);
   }
  }
 } while(0);
 _free($2);
 $$01 = 0;
 STACKTOP = sp;return ($$01|0);
}
function _floor1_look($vd,$in) {
 $vd = $vd|0;
 $in = $in|0;
 var $$lcssa = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0;
 var $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0;
 var $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0;
 var $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $8 = 0, $9 = 0, $exitcond = 0, $hi$05 = 0, $hi$1 = 0, $hi$1$lcssa = 0;
 var $hx$07 = 0, $hx$1 = 0, $i$026 = 0, $i$121 = 0, $i$218 = 0, $i$316 = 0, $i$413 = 0, $i$510 = 0, $j$08 = 0, $lo$04 = 0, $lo$1 = 0, $lo$1$lcssa = 0, $lx$06 = 0, $lx$1 = 0, $n$0$lcssa32343639 = 0, $n$0$lcssa33 = 0, $n$025 = 0, $or$cond = 0, $or$cond1 = 0, $sortpointer = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 272|0;
 $sortpointer = sp;
 $0 = (_calloc(1,1312)|0);
 $1 = ((($0)) + 1296|0);
 HEAP32[$1>>2] = $in;
 $2 = ((($in)) + 836|0);
 $3 = ((($in)) + 840|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = ((($0)) + 1288|0);
 HEAP32[$5>>2] = $4;
 $6 = HEAP32[$in>>2]|0;
 $7 = ($6|0)>(0);
 if ($7) {
  $9 = ((($in)) + 4|0);
  $10 = ((($in)) + 128|0);
  $i$026 = 0;$n$025 = 0;
  while(1) {
   $11 = (($9) + ($i$026<<2)|0);
   $12 = HEAP32[$11>>2]|0;
   $13 = (($10) + ($12<<2)|0);
   $14 = HEAP32[$13>>2]|0;
   $15 = (($14) + ($n$025))|0;
   $16 = (($i$026) + 1)|0;
   $17 = ($16|0)<($6|0);
   if ($17) {
    $i$026 = $16;$n$025 = $15;
   } else {
    $$lcssa = $15;
    break;
   }
  }
  $18 = (($$lcssa) + 2)|0;
  $19 = ((($0)) + 1284|0);
  HEAP32[$19>>2] = $18;
  $20 = ($$lcssa|0)>(-2);
  if ($20) {
   $25 = $18;$n$0$lcssa33 = $$lcssa;
   label = 7;
  } else {
   _qsort($sortpointer,$18,4,8);
   $n$0$lcssa32343639 = $$lcssa;
  }
 } else {
  $8 = ((($0)) + 1284|0);
  HEAP32[$8>>2] = 2;
  $25 = 2;$n$0$lcssa33 = 0;
  label = 7;
 }
 if ((label|0) == 7) {
  $i$121 = 0;
  while(1) {
   $21 = (($2) + ($i$121<<2)|0);
   $22 = (($sortpointer) + ($i$121<<2)|0);
   HEAP32[$22>>2] = $21;
   $23 = (($i$121) + 1)|0;
   $24 = ($23|0)<($25|0);
   if ($24) {
    $i$121 = $23;
   } else {
    break;
   }
  }
  _qsort($sortpointer,$25,4,8);
  $26 = $2;
  $27 = ((($0)) + 260|0);
  $i$218 = 0;
  while(1) {
   $30 = (($sortpointer) + ($i$218<<2)|0);
   $31 = HEAP32[$30>>2]|0;
   $32 = $31;
   $33 = (($32) - ($26))|0;
   $34 = $33 >> 2;
   $35 = (($27) + ($i$218<<2)|0);
   HEAP32[$35>>2] = $34;
   $36 = (($i$218) + 1)|0;
   $37 = ($36|0)<($25|0);
   if ($37) {
    $i$218 = $36;
   } else {
    break;
   }
  }
  $28 = ((($0)) + 260|0);
  $29 = ((($0)) + 520|0);
  $i$316 = 0;
  while(1) {
   $39 = (($28) + ($i$316<<2)|0);
   $40 = HEAP32[$39>>2]|0;
   $41 = (($29) + ($40<<2)|0);
   HEAP32[$41>>2] = $i$316;
   $42 = (($i$316) + 1)|0;
   $43 = ($42|0)<($25|0);
   if ($43) {
    $i$316 = $42;
   } else {
    break;
   }
  }
  $38 = ((($0)) + 260|0);
  $i$413 = 0;
  while(1) {
   $44 = (($38) + ($i$413<<2)|0);
   $45 = HEAP32[$44>>2]|0;
   $46 = (($2) + ($45<<2)|0);
   $47 = HEAP32[$46>>2]|0;
   $48 = (($0) + ($i$413<<2)|0);
   HEAP32[$48>>2] = $47;
   $49 = (($i$413) + 1)|0;
   $50 = ($49|0)<($25|0);
   if ($50) {
    $i$413 = $49;
   } else {
    $n$0$lcssa32343639 = $n$0$lcssa33;
    break;
   }
  }
 }
 $51 = ((($in)) + 832|0);
 $52 = HEAP32[$51>>2]|0;
 if ((($52|0) == 4)) {
  $56 = ((($0)) + 1292|0);
  HEAP32[$56>>2] = 64;
 } else if ((($52|0) == 2)) {
  $54 = ((($0)) + 1292|0);
  HEAP32[$54>>2] = 128;
 } else if ((($52|0) == 1)) {
  $53 = ((($0)) + 1292|0);
  HEAP32[$53>>2] = 256;
 } else if ((($52|0) == 3)) {
  $55 = ((($0)) + 1292|0);
  HEAP32[$55>>2] = 86;
 }
 $57 = ($n$0$lcssa32343639|0)>(0);
 if (!($57)) {
  STACKTOP = sp;return ($0|0);
 }
 $58 = ((($0)) + 1032|0);
 $59 = ((($0)) + 780|0);
 $i$510 = 0;
 while(1) {
  $60 = (($i$510) + 2)|0;
  $61 = (($2) + ($60<<2)|0);
  $62 = HEAP32[$61>>2]|0;
  $63 = HEAP32[$5>>2]|0;
  $hi$05 = 1;$hx$07 = $63;$j$08 = 0;$lo$04 = 0;$lx$06 = 0;
  while(1) {
   $64 = (($2) + ($j$08<<2)|0);
   $65 = HEAP32[$64>>2]|0;
   $66 = ($65|0)>($lx$06|0);
   $67 = ($65|0)<($62|0);
   $or$cond = $66 & $67;
   $lo$1 = $or$cond ? $j$08 : $lo$04;
   $lx$1 = $or$cond ? $65 : $lx$06;
   $68 = ($65|0)<($hx$07|0);
   $69 = ($65|0)>($62|0);
   $or$cond1 = $68 & $69;
   $hi$1 = $or$cond1 ? $j$08 : $hi$05;
   $hx$1 = $or$cond1 ? $65 : $hx$07;
   $70 = (($j$08) + 1)|0;
   $71 = ($70|0)<($60|0);
   if ($71) {
    $hi$05 = $hi$1;$hx$07 = $hx$1;$j$08 = $70;$lo$04 = $lo$1;$lx$06 = $lx$1;
   } else {
    $hi$1$lcssa = $hi$1;$lo$1$lcssa = $lo$1;
    break;
   }
  }
  $72 = (($58) + ($i$510<<2)|0);
  HEAP32[$72>>2] = $lo$1$lcssa;
  $73 = (($59) + ($i$510<<2)|0);
  HEAP32[$73>>2] = $hi$1$lcssa;
  $74 = (($i$510) + 1)|0;
  $exitcond = ($74|0)==($n$0$lcssa32343639|0);
  if ($exitcond) {
   break;
  } else {
   $i$510 = $74;
  }
 }
 STACKTOP = sp;return ($0|0);
}
function _floor1_free_info($i) {
 $i = $i|0;
 var $0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ($i|0)==(0|0);
 if (!($0)) {
  _free($i);
 }
 return;
}
function _floor1_free_look($i) {
 $i = $i|0;
 var $0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ($i|0)==(0|0);
 if (!($0)) {
  _free($i);
 }
 return;
}
function _floor1_inverse1($vb,$in) {
 $vb = $vb|0;
 $in = $in|0;
 var $$0 = 0, $$0$i = 0, $$0$p$i = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0;
 var $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0;
 var $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0;
 var $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0;
 var $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0;
 var $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0;
 var $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $cval$1$ph = 0, $cval$15 = 0, $i$09 = 0, $i$14 = 0, $ispos$i = 0, $j$08 = 0, $k$06 = 0, $neg$i = 0, $val$0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($in)) + 1296|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($vb)) + 64|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ((($3)) + 4|0);
 $5 = HEAP32[$4>>2]|0;
 $6 = ((($5)) + 28|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = ((($7)) + 2848|0);
 $9 = HEAP32[$8>>2]|0;
 $10 = ((($vb)) + 4|0);
 $11 = (_oggpack_read($10,1)|0);
 $12 = ($11|0)==(1);
 if (!($12)) {
  $$0 = 0;
  return ($$0|0);
 }
 $13 = ((($in)) + 1284|0);
 $14 = HEAP32[$13>>2]|0;
 $15 = $14 << 2;
 $16 = (__vorbis_block_alloc($vb,$15)|0);
 $17 = ((($in)) + 1292|0);
 $18 = HEAP32[$17>>2]|0;
 $19 = (($18) + -1)|0;
 $20 = (_ov_ilog($19)|0);
 $21 = (_oggpack_read($10,$20)|0);
 HEAP32[$16>>2] = $21;
 $22 = HEAP32[$17>>2]|0;
 $23 = (($22) + -1)|0;
 $24 = (_ov_ilog($23)|0);
 $25 = (_oggpack_read($10,$24)|0);
 $26 = ((($16)) + 4|0);
 HEAP32[$26>>2] = $25;
 $27 = HEAP32[$1>>2]|0;
 $28 = ($27|0)>(0);
 L4: do {
  if ($28) {
   $i$09 = 0;$j$08 = 2;
   L5: while(1) {
    $33 = (((($1)) + 4|0) + ($i$09<<2)|0);
    $34 = HEAP32[$33>>2]|0;
    $35 = (((($1)) + 128|0) + ($34<<2)|0);
    $36 = HEAP32[$35>>2]|0;
    $37 = (((($1)) + 192|0) + ($34<<2)|0);
    $38 = HEAP32[$37>>2]|0;
    $39 = 1 << $38;
    $40 = ($38|0)==(0);
    if ($40) {
     $cval$1$ph = 0;
    } else {
     $41 = (((($1)) + 256|0) + ($34<<2)|0);
     $42 = HEAP32[$41>>2]|0;
     $43 = (($9) + (($42*56)|0)|0);
     $44 = (_vorbis_book_decode($43,$10)|0);
     $45 = ($44|0)==(-1);
     if ($45) {
      $$0 = 0;
      label = 25;
      break;
     } else {
      $cval$1$ph = $44;
     }
    }
    $46 = ($36|0)>(0);
    if ($46) {
     $47 = (($39) + -1)|0;
     $cval$15 = $cval$1$ph;$k$06 = 0;
     while(1) {
      $48 = $cval$15 & $47;
      $49 = ((((($1)) + 320|0) + ($34<<5)|0) + ($48<<2)|0);
      $50 = HEAP32[$49>>2]|0;
      $51 = $cval$15 >> $38;
      $52 = ($50|0)>(-1);
      if ($52) {
       $53 = (($9) + (($50*56)|0)|0);
       $54 = (_vorbis_book_decode($53,$10)|0);
       $55 = (($k$06) + ($j$08))|0;
       $56 = (($16) + ($55<<2)|0);
       HEAP32[$56>>2] = $54;
       $57 = ($54|0)==(-1);
       if ($57) {
        $$0 = 0;
        label = 25;
        break L5;
       }
      } else {
       $58 = (($k$06) + ($j$08))|0;
       $59 = (($16) + ($58<<2)|0);
       HEAP32[$59>>2] = 0;
      }
      $60 = (($k$06) + 1)|0;
      $61 = ($60|0)<($36|0);
      if ($61) {
       $cval$15 = $51;$k$06 = $60;
      } else {
       break;
      }
     }
    }
    $62 = (($36) + ($j$08))|0;
    $63 = (($i$09) + 1)|0;
    $64 = HEAP32[$1>>2]|0;
    $65 = ($63|0)<($64|0);
    if ($65) {
     $i$09 = $63;$j$08 = $62;
    } else {
     break L4;
    }
   }
   if ((label|0) == 25) {
    return ($$0|0);
   }
  }
 } while(0);
 $29 = HEAP32[$13>>2]|0;
 $30 = ($29|0)>(2);
 if (!($30)) {
  $$0 = $16;
  return ($$0|0);
 }
 $31 = ((($in)) + 1032|0);
 $32 = ((($in)) + 780|0);
 $i$14 = 2;
 while(1) {
  $66 = (($i$14) + -2)|0;
  $67 = (($31) + ($66<<2)|0);
  $68 = HEAP32[$67>>2]|0;
  $69 = (((($1)) + 836|0) + ($68<<2)|0);
  $70 = HEAP32[$69>>2]|0;
  $71 = (($32) + ($66<<2)|0);
  $72 = HEAP32[$71>>2]|0;
  $73 = (((($1)) + 836|0) + ($72<<2)|0);
  $74 = HEAP32[$73>>2]|0;
  $75 = (($16) + ($68<<2)|0);
  $76 = HEAP32[$75>>2]|0;
  $77 = (($16) + ($72<<2)|0);
  $78 = HEAP32[$77>>2]|0;
  $79 = (((($1)) + 836|0) + ($i$14<<2)|0);
  $80 = HEAP32[$79>>2]|0;
  $81 = $76 & 32767;
  $82 = $78 & 32767;
  $83 = (($82) - ($81))|0;
  $84 = (($74) - ($70))|0;
  $ispos$i = ($83|0)>(-1);
  $neg$i = (0 - ($83))|0;
  $85 = $ispos$i ? $83 : $neg$i;
  $86 = (($80) - ($70))|0;
  $87 = Math_imul($85, $86)|0;
  $88 = (($87|0) / ($84|0))&-1;
  $89 = ($83|0)<(0);
  $90 = (0 - ($88))|0;
  $$0$p$i = $89 ? $90 : $88;
  $$0$i = (($$0$p$i) + ($81))|0;
  $91 = HEAP32[$17>>2]|0;
  $92 = (($91) - ($$0$i))|0;
  $93 = (($16) + ($i$14<<2)|0);
  $94 = HEAP32[$93>>2]|0;
  $95 = ($94|0)==(0);
  if ($95) {
   $120 = $$0$i | 32768;
   HEAP32[$93>>2] = $120;
  } else {
   $96 = ($92|0)<($$0$i|0);
   $97 = $96 ? $92 : $$0$i;
   $98 = $97 << 1;
   $99 = ($94|0)<($98|0);
   do {
    if ($99) {
     $104 = $94 & 1;
     $105 = ($104|0)==(0);
     if ($105) {
      $109 = $94 >> 1;
      $val$0 = $109;
      break;
     } else {
      $106 = (($94) + 1)|0;
      $107 = $106 >> 1;
      $108 = (0 - ($107))|0;
      $val$0 = $108;
      break;
     }
    } else {
     $100 = ($92|0)>($$0$i|0);
     if ($100) {
      $101 = (($94) - ($$0$i))|0;
      $val$0 = $101;
      break;
     } else {
      $102 = (($94) - ($92))|0;
      $103 = $102 ^ -1;
      $val$0 = $103;
      break;
     }
    }
   } while(0);
   $110 = (($val$0) + ($$0$i))|0;
   $111 = $110 & 32767;
   HEAP32[$93>>2] = $111;
   $112 = HEAP32[$67>>2]|0;
   $113 = (($16) + ($112<<2)|0);
   $114 = HEAP32[$113>>2]|0;
   $115 = $114 & 32767;
   HEAP32[$113>>2] = $115;
   $116 = HEAP32[$71>>2]|0;
   $117 = (($16) + ($116<<2)|0);
   $118 = HEAP32[$117>>2]|0;
   $119 = $118 & 32767;
   HEAP32[$117>>2] = $119;
  }
  $121 = (($i$14) + 1)|0;
  $122 = HEAP32[$13>>2]|0;
  $123 = ($121|0)<($122|0);
  if ($123) {
   $i$14 = $121;
  } else {
   $$0 = $16;
   break;
  }
 }
 return ($$0|0);
}
function _floor1_inverse2($vb,$in,$memo,$out) {
 $vb = $vb|0;
 $in = $in|0;
 $memo = $memo|0;
 $out = $out|0;
 var $$0 = 0, $$pn$i = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0;
 var $25 = 0, $26 = 0, $27 = 0, $28 = 0.0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0;
 var $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0.0, $55 = 0, $56 = 0.0, $57 = 0.0, $58 = 0, $59 = 0, $6 = 0, $60 = 0;
 var $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0.0, $66 = 0, $67 = 0, $68 = 0.0, $69 = 0.0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0.0, $75 = 0.0, $76 = 0, $77 = 0, $8 = 0, $9 = 0;
 var $err$04$i = 0, $err$1$i = 0, $exitcond = 0, $exitcond$i = 0, $hx$0$lcssa = 0, $hx$03 = 0, $hx$1 = 0, $ispos$i = 0, $ispos1$i = 0, $j$02 = 0, $j$11 = 0, $lx$04 = 0, $lx$1 = 0, $ly$0$lcssa = 0, $ly$05 = 0, $ly$1 = 0, $neg$i = 0, $neg2$i = 0, $x1$n$i = 0, $y$03$i = 0;
 var $y$1$i = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($in)) + 1296|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($vb)) + 64|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ((($3)) + 4|0);
 $5 = HEAP32[$4>>2]|0;
 $6 = ((($5)) + 28|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = ((($vb)) + 28|0);
 $9 = HEAP32[$8>>2]|0;
 $10 = (($7) + ($9<<2)|0);
 $11 = HEAP32[$10>>2]|0;
 $12 = (($11|0) / 2)&-1;
 $13 = ($memo|0)==(0|0);
 if ($13) {
  $77 = $12 << 2;
  _memset(($out|0),0,($77|0))|0;
  $$0 = 0;
  return ($$0|0);
 }
 $14 = HEAP32[$memo>>2]|0;
 $15 = ((($1)) + 832|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = Math_imul($16, $14)|0;
 $18 = ($17|0)<(0);
 $19 = ($17|0)>(255);
 $20 = $19 ? 255 : $17;
 $21 = $18 ? 0 : $20;
 $22 = ((($in)) + 1284|0);
 $23 = HEAP32[$22>>2]|0;
 $24 = ($23|0)>(1);
 if ($24) {
  $25 = ((($in)) + 260|0);
  $hx$03 = 0;$j$02 = 1;$lx$04 = 0;$ly$05 = $21;
  while(1) {
   $29 = (($25) + ($j$02<<2)|0);
   $30 = HEAP32[$29>>2]|0;
   $31 = (($memo) + ($30<<2)|0);
   $32 = HEAP32[$31>>2]|0;
   $33 = $32 & 32767;
   $34 = ($33|0)==($32|0);
   if ($34) {
    $35 = (((($1)) + 836|0) + ($30<<2)|0);
    $36 = HEAP32[$35>>2]|0;
    $37 = Math_imul($16, $32)|0;
    $38 = ($37|0)<(0);
    $39 = ($37|0)>(255);
    $40 = $39 ? 255 : $37;
    $41 = $38 ? 0 : $40;
    $42 = (($41) - ($ly$05))|0;
    $43 = (($36) - ($lx$04))|0;
    $ispos$i = ($42|0)>(-1);
    $neg$i = (0 - ($42))|0;
    $44 = $ispos$i ? $42 : $neg$i;
    $45 = (($42|0) / ($43|0))&-1;
    $46 = $42 >> 31;
    $47 = $46 | 1;
    $48 = Math_imul($45, $43)|0;
    $ispos1$i = ($48|0)>(-1);
    $neg2$i = (0 - ($48))|0;
    $49 = $ispos1$i ? $48 : $neg2$i;
    $50 = (($44) - ($49))|0;
    $51 = ($12|0)>($36|0);
    $x1$n$i = $51 ? $36 : $12;
    $52 = ($x1$n$i|0)>($lx$04|0);
    if ($52) {
     $53 = (1768 + ($ly$05<<2)|0);
     $54 = +HEAPF32[$53>>2];
     $55 = (($out) + ($lx$04<<2)|0);
     $56 = +HEAPF32[$55>>2];
     $57 = $56 * $54;
     HEAPF32[$55>>2] = $57;
    }
    $58 = (($lx$04) + 1)|0;
    $59 = ($58|0)<($x1$n$i|0);
    if ($59) {
     $67 = $58;$err$04$i = 0;$y$03$i = $ly$05;
     while(1) {
      $60 = (($err$04$i) + ($50))|0;
      $61 = ($60|0)<($43|0);
      $62 = $61 ? 0 : $47;
      $63 = $61 ? 0 : $43;
      $err$1$i = (($60) - ($63))|0;
      $$pn$i = (($y$03$i) + ($45))|0;
      $y$1$i = (($$pn$i) + ($62))|0;
      $64 = (1768 + ($y$1$i<<2)|0);
      $65 = +HEAPF32[$64>>2];
      $66 = (($out) + ($67<<2)|0);
      $68 = +HEAPF32[$66>>2];
      $69 = $68 * $65;
      HEAPF32[$66>>2] = $69;
      $70 = (($67) + 1)|0;
      $exitcond$i = ($70|0)==($x1$n$i|0);
      if ($exitcond$i) {
       $hx$1 = $36;$lx$1 = $36;$ly$1 = $41;
       break;
      } else {
       $67 = $70;$err$04$i = $err$1$i;$y$03$i = $y$1$i;
      }
     }
    } else {
     $hx$1 = $36;$lx$1 = $36;$ly$1 = $41;
    }
   } else {
    $hx$1 = $hx$03;$lx$1 = $lx$04;$ly$1 = $ly$05;
   }
   $71 = (($j$02) + 1)|0;
   $72 = ($71|0)<($23|0);
   if ($72) {
    $hx$03 = $hx$1;$j$02 = $71;$lx$04 = $lx$1;$ly$05 = $ly$1;
   } else {
    $hx$0$lcssa = $hx$1;$ly$0$lcssa = $ly$1;
    break;
   }
  }
 } else {
  $hx$0$lcssa = 0;$ly$0$lcssa = $21;
 }
 $26 = ($hx$0$lcssa|0)<($12|0);
 if (!($26)) {
  $$0 = 1;
  return ($$0|0);
 }
 $27 = (1768 + ($ly$0$lcssa<<2)|0);
 $28 = +HEAPF32[$27>>2];
 $j$11 = $hx$0$lcssa;
 while(1) {
  $73 = (($out) + ($j$11<<2)|0);
  $74 = +HEAPF32[$73>>2];
  $75 = $74 * $28;
  HEAPF32[$73>>2] = $75;
  $76 = (($j$11) + 1)|0;
  $exitcond = ($76|0)==($12|0);
  if ($exitcond) {
   $$0 = 1;
   break;
  } else {
   $j$11 = $76;
  }
 }
 return ($$0|0);
}
function _icomp($a,$b) {
 $a = $a|0;
 $b = $b|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = HEAP32[$a>>2]|0;
 $1 = HEAP32[$0>>2]|0;
 $2 = HEAP32[$b>>2]|0;
 $3 = HEAP32[$2>>2]|0;
 $4 = (($1) - ($3))|0;
 return ($4|0);
}
function _vorbis_comment_init($vc) {
 $vc = $vc|0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 ;HEAP32[$vc>>2]=0|0;HEAP32[$vc+4>>2]=0|0;HEAP32[$vc+8>>2]=0|0;HEAP32[$vc+12>>2]=0|0;
 return;
}
function _vorbis_comment_add_tag($vc,$tag,$contents) {
 $vc = $vc|0;
 $tag = $tag|0;
 $contents = $contents|0;
 var $$alloca_mul = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0;
 var $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $endptr = 0, $strlen = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = (_strlen(($tag|0))|0);
 $1 = (_strlen(($contents|0))|0);
 $2 = (($0) + 2)|0;
 $3 = (($2) + ($1))|0;
 $$alloca_mul = $3;
 $4 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul)|0)+15)&-16)|0;;
 (_strcpy(($4|0),($tag|0))|0);
 $strlen = (_strlen(($4|0))|0);
 $endptr = (($4) + ($strlen)|0);
 HEAP8[$endptr>>0]=61&255;HEAP8[$endptr+1>>0]=61>>8;
 (_strcat(($4|0),($contents|0))|0);
 $5 = HEAP32[$vc>>2]|0;
 $6 = ((($vc)) + 8|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = $7 << 2;
 $9 = (($8) + 8)|0;
 $10 = (_realloc($5,$9)|0);
 HEAP32[$vc>>2] = $10;
 $11 = ((($vc)) + 4|0);
 $12 = HEAP32[$11>>2]|0;
 $13 = HEAP32[$6>>2]|0;
 $14 = $13 << 2;
 $15 = (($14) + 8)|0;
 $16 = (_realloc($12,$15)|0);
 HEAP32[$11>>2] = $16;
 $17 = (_strlen(($4|0))|0);
 $18 = HEAP32[$6>>2]|0;
 $19 = (($16) + ($18<<2)|0);
 HEAP32[$19>>2] = $17;
 $20 = (($17) + 1)|0;
 $21 = (_malloc($20)|0);
 $22 = HEAP32[$vc>>2]|0;
 $23 = (($22) + ($18<<2)|0);
 HEAP32[$23>>2] = $21;
 $24 = HEAP32[$vc>>2]|0;
 $25 = (($24) + ($18<<2)|0);
 $26 = HEAP32[$25>>2]|0;
 (_strcpy(($26|0),($4|0))|0);
 $27 = HEAP32[$6>>2]|0;
 $28 = (($27) + 1)|0;
 HEAP32[$6>>2] = $28;
 $29 = HEAP32[$vc>>2]|0;
 $30 = (($29) + ($28<<2)|0);
 HEAP32[$30>>2] = 0;
 STACKTOP = sp;return;
}
function _vorbis_comment_clear($vc) {
 $vc = $vc|0;
 var $$pre = 0, $$pre3 = 0, $$pre4 = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $3 = 0, $4 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, $i$01 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ($vc|0)==(0|0);
 if ($0) {
  return;
 }
 $1 = HEAP32[$vc>>2]|0;
 $2 = ($1|0)==(0|0);
 if (!($2)) {
  $3 = ((($vc)) + 8|0);
  $4 = HEAP32[$3>>2]|0;
  $5 = ($4|0)>(0);
  if ($5) {
   $20 = $4;$7 = $1;$i$01 = 0;
   while(1) {
    $6 = (($7) + ($i$01<<2)|0);
    $8 = HEAP32[$6>>2]|0;
    $9 = ($8|0)==(0|0);
    if ($9) {
     $12 = $20;
    } else {
     _free($8);
     $$pre3 = HEAP32[$3>>2]|0;
     $12 = $$pre3;
    }
    $10 = (($i$01) + 1)|0;
    $11 = ($10|0)<($12|0);
    if (!($11)) {
     break;
    }
    $$pre = HEAP32[$vc>>2]|0;
    $20 = $12;$7 = $$pre;$i$01 = $10;
   }
   $$pre4 = HEAP32[$vc>>2]|0;
   $13 = $$pre4;
  } else {
   $13 = $1;
  }
  _free($13);
 }
 $14 = ((($vc)) + 4|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = ($15|0)==(0|0);
 if (!($16)) {
  _free($15);
 }
 $17 = ((($vc)) + 12|0);
 $18 = HEAP32[$17>>2]|0;
 $19 = ($18|0)==(0|0);
 if (!($19)) {
  _free($18);
 }
 ;HEAP32[$vc>>2]=0|0;HEAP32[$vc+4>>2]=0|0;HEAP32[$vc+8>>2]=0|0;HEAP32[$vc+12>>2]=0|0;
 return;
}
function _vorbis_info_init($vi) {
 $vi = $vi|0;
 var $0 = 0, $1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 ;HEAP32[$vi>>2]=0|0;HEAP32[$vi+4>>2]=0|0;HEAP32[$vi+8>>2]=0|0;HEAP32[$vi+12>>2]=0|0;HEAP32[$vi+16>>2]=0|0;HEAP32[$vi+20>>2]=0|0;HEAP32[$vi+24>>2]=0|0;
 $0 = (_calloc(1,3664)|0);
 $1 = ((($vi)) + 28|0);
 HEAP32[$1>>2] = $0;
 return;
}
function _vorbis_info_clear($vi) {
 $vi = $vi|0;
 var $$pre = 0, $$pre18 = 0, $$pre19 = 0, $$pre20 = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0;
 var $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0;
 var $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0;
 var $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0;
 var $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $9 = 0, $i$016 = 0, $i$114 = 0, $i$212 = 0, $i$310 = 0, $i$47 = 0, $i$56 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($vi)) + 28|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ($1|0)==(0|0);
 if ($2) {
  ;HEAP32[$vi>>2]=0|0;HEAP32[$vi+4>>2]=0|0;HEAP32[$vi+8>>2]=0|0;HEAP32[$vi+12>>2]=0|0;HEAP32[$vi+16>>2]=0|0;HEAP32[$vi+20>>2]=0|0;HEAP32[$vi+24>>2]=0|0;HEAP32[$vi+28>>2]=0|0;
  return;
 }
 $3 = ((($1)) + 8|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = ($4|0)>(0);
 if ($5) {
  $80 = $4;$i$016 = 0;
  while(1) {
   $9 = (((($1)) + 32|0) + ($i$016<<2)|0);
   $10 = HEAP32[$9>>2]|0;
   $11 = ($10|0)==(0|0);
   if ($11) {
    $14 = $80;
   } else {
    _free($10);
    $$pre = HEAP32[$3>>2]|0;
    $14 = $$pre;
   }
   $12 = (($i$016) + 1)|0;
   $13 = ($12|0)<($14|0);
   if ($13) {
    $80 = $14;$i$016 = $12;
   } else {
    break;
   }
  }
 }
 $6 = ((($1)) + 12|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = ($7|0)>(0);
 if ($8) {
  $81 = $7;$i$114 = 0;
  while(1) {
   $18 = (((($1)) + 544|0) + ($i$114<<2)|0);
   $19 = HEAP32[$18>>2]|0;
   $20 = ($19|0)==(0|0);
   if ($20) {
    $29 = $81;
   } else {
    $21 = (((($1)) + 288|0) + ($i$114<<2)|0);
    $22 = HEAP32[$21>>2]|0;
    $23 = (25664 + ($22<<2)|0);
    $24 = HEAP32[$23>>2]|0;
    $25 = ((($24)) + 8|0);
    $26 = HEAP32[$25>>2]|0;
    FUNCTION_TABLE_vi[$26 & 7]($19);
    $$pre18 = HEAP32[$6>>2]|0;
    $29 = $$pre18;
   }
   $27 = (($i$114) + 1)|0;
   $28 = ($27|0)<($29|0);
   if ($28) {
    $81 = $29;$i$114 = $27;
   } else {
    break;
   }
  }
 }
 $15 = ((($1)) + 16|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = ($16|0)>(0);
 if ($17) {
  $82 = $16;$i$212 = 0;
  while(1) {
   $33 = (((($1)) + 1056|0) + ($i$212<<2)|0);
   $34 = HEAP32[$33>>2]|0;
   $35 = ($34|0)==(0|0);
   if ($35) {
    $44 = $82;
   } else {
    $36 = (((($1)) + 800|0) + ($i$212<<2)|0);
    $37 = HEAP32[$36>>2]|0;
    $38 = (25640 + ($37<<2)|0);
    $39 = HEAP32[$38>>2]|0;
    $40 = ((($39)) + 12|0);
    $41 = HEAP32[$40>>2]|0;
    FUNCTION_TABLE_vi[$41 & 7]($34);
    $$pre19 = HEAP32[$15>>2]|0;
    $44 = $$pre19;
   }
   $42 = (($i$212) + 1)|0;
   $43 = ($42|0)<($44|0);
   if ($43) {
    $82 = $44;$i$212 = $42;
   } else {
    break;
   }
  }
 }
 $30 = ((($1)) + 20|0);
 $31 = HEAP32[$30>>2]|0;
 $32 = ($31|0)>(0);
 if ($32) {
  $83 = $31;$i$310 = 0;
  while(1) {
   $49 = (((($1)) + 1568|0) + ($i$310<<2)|0);
   $50 = HEAP32[$49>>2]|0;
   $51 = ($50|0)==(0|0);
   if ($51) {
    $60 = $83;
   } else {
    $52 = (((($1)) + 1312|0) + ($i$310<<2)|0);
    $53 = HEAP32[$52>>2]|0;
    $54 = (25648 + ($53<<2)|0);
    $55 = HEAP32[$54>>2]|0;
    $56 = ((($55)) + 12|0);
    $57 = HEAP32[$56>>2]|0;
    FUNCTION_TABLE_vi[$57 & 7]($50);
    $$pre20 = HEAP32[$30>>2]|0;
    $60 = $$pre20;
   }
   $58 = (($i$310) + 1)|0;
   $59 = ($58|0)<($60|0);
   if ($59) {
    $83 = $60;$i$310 = $58;
   } else {
    break;
   }
  }
 }
 $45 = ((($1)) + 24|0);
 $46 = HEAP32[$45>>2]|0;
 $47 = ($46|0)>(0);
 $48 = ((($1)) + 2848|0);
 if ($47) {
  $i$47 = 0;
  while(1) {
   $61 = (((($1)) + 1824|0) + ($i$47<<2)|0);
   $62 = HEAP32[$61>>2]|0;
   $63 = ($62|0)==(0|0);
   if (!($63)) {
    _vorbis_staticbook_destroy($62);
   }
   $64 = HEAP32[$48>>2]|0;
   $65 = ($64|0)==(0|0);
   if (!($65)) {
    $66 = (($64) + (($i$47*56)|0)|0);
    _vorbis_book_clear($66);
   }
   $67 = (($i$47) + 1)|0;
   $68 = HEAP32[$45>>2]|0;
   $69 = ($67|0)<($68|0);
   if ($69) {
    $i$47 = $67;
   } else {
    break;
   }
  }
 }
 $70 = HEAP32[$48>>2]|0;
 $71 = ($70|0)==(0|0);
 if (!($71)) {
  _free($70);
 }
 $72 = ((($1)) + 28|0);
 $73 = HEAP32[$72>>2]|0;
 $74 = ($73|0)>(0);
 if ($74) {
  $i$56 = 0;
  while(1) {
   $75 = (((($1)) + 2852|0) + ($i$56<<2)|0);
   $76 = HEAP32[$75>>2]|0;
   __vi_psy_free($76);
   $77 = (($i$56) + 1)|0;
   $78 = HEAP32[$72>>2]|0;
   $79 = ($77|0)<($78|0);
   if ($79) {
    $i$56 = $77;
   } else {
    break;
   }
  }
 }
 _free($1);
 ;HEAP32[$vi>>2]=0|0;HEAP32[$vi+4>>2]=0|0;HEAP32[$vi+8>>2]=0|0;HEAP32[$vi+12>>2]=0|0;HEAP32[$vi+16>>2]=0|0;HEAP32[$vi+20>>2]=0|0;HEAP32[$vi+24>>2]=0|0;HEAP32[$vi+28>>2]=0|0;
 return;
}
function _vorbis_analysis_headerout($v,$vc,$op,$op_comm,$op_code) {
 $v = $v|0;
 $vc = $vc|0;
 $op = $op|0;
 $op_comm = $op_comm|0;
 $op_code = $op_code|0;
 var $$0 = 0, $$pre = 0, $$pre$phiZ2D = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0;
 var $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0;
 var $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0;
 var $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $17 = 0;
 var $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0;
 var $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0;
 var $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0;
 var $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0;
 var $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $i$015$i = 0, $i$111$i = 0, $i$27$i = 0, $i$33$i = 0, $i$42$i = 0, $opb = 0, $ret$0$ph = 0, $ret$03 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0;
 $opb = sp;
 $0 = ((($v)) + 4|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($v)) + 104|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ($3|0)==(0|0);
 if ($4) {
  ;HEAP32[$op>>2]=0|0;HEAP32[$op+4>>2]=0|0;HEAP32[$op+8>>2]=0|0;HEAP32[$op+12>>2]=0|0;HEAP32[$op+16>>2]=0|0;HEAP32[$op+20>>2]=0|0;HEAP32[$op+24>>2]=0|0;HEAP32[$op+28>>2]=0|0;
  ;HEAP32[$op_comm>>2]=0|0;HEAP32[$op_comm+4>>2]=0|0;HEAP32[$op_comm+8>>2]=0|0;HEAP32[$op_comm+12>>2]=0|0;HEAP32[$op_comm+16>>2]=0|0;HEAP32[$op_comm+20>>2]=0|0;HEAP32[$op_comm+24>>2]=0|0;HEAP32[$op_comm+28>>2]=0|0;
  ;HEAP32[$op_code>>2]=0|0;HEAP32[$op_code+4>>2]=0|0;HEAP32[$op_code+8>>2]=0|0;HEAP32[$op_code+12>>2]=0|0;HEAP32[$op_code+16>>2]=0|0;HEAP32[$op_code+20>>2]=0|0;HEAP32[$op_code+24>>2]=0|0;HEAP32[$op_code+28>>2]=0|0;
  $$0 = -129;
  STACKTOP = sp;return ($$0|0);
 }
 $5 = ((($1)) + 4|0);
 $6 = HEAP32[$5>>2]|0;
 $7 = ($6|0)<(1);
 if ($7) {
  $ret$0$ph = -129;
  label = 27;
 } else {
  _oggpack_writeinit($opb);
  $8 = ((($1)) + 28|0);
  $9 = HEAP32[$8>>2]|0;
  $10 = ($9|0)==(0|0);
  if ($10) {
   $ret$0$ph = -130;
   label = 27;
  } else {
   $11 = HEAP32[$9>>2]|0;
   $12 = ($11|0)<(64);
   if ($12) {
    $ret$0$ph = -130;
    label = 27;
   } else {
    $13 = ((($9)) + 4|0);
    $14 = HEAP32[$13>>2]|0;
    $15 = ($14|0)<($11|0);
    if ($15) {
     $ret$0$ph = -130;
     label = 27;
    } else {
     _oggpack_write($opb,1,8);
     _oggpack_write($opb,118,8);
     _oggpack_write($opb,111,8);
     _oggpack_write($opb,114,8);
     _oggpack_write($opb,98,8);
     _oggpack_write($opb,105,8);
     _oggpack_write($opb,115,8);
     _oggpack_write($opb,0,32);
     $16 = HEAP32[$5>>2]|0;
     _oggpack_write($opb,$16,8);
     $17 = ((($1)) + 8|0);
     $18 = HEAP32[$17>>2]|0;
     _oggpack_write($opb,$18,32);
     $19 = ((($1)) + 12|0);
     $20 = HEAP32[$19>>2]|0;
     _oggpack_write($opb,$20,32);
     $21 = ((($1)) + 16|0);
     $22 = HEAP32[$21>>2]|0;
     _oggpack_write($opb,$22,32);
     $23 = ((($1)) + 20|0);
     $24 = HEAP32[$23>>2]|0;
     _oggpack_write($opb,$24,32);
     $25 = HEAP32[$9>>2]|0;
     $26 = (($25) + -1)|0;
     $27 = (_ov_ilog($26)|0);
     _oggpack_write($opb,$27,4);
     $28 = HEAP32[$13>>2]|0;
     $29 = (($28) + -1)|0;
     $30 = (_ov_ilog($29)|0);
     _oggpack_write($opb,$30,4);
     _oggpack_write($opb,1,1);
     $31 = ((($3)) + 64|0);
     $32 = HEAP32[$31>>2]|0;
     $33 = ($32|0)==(0|0);
     if (!($33)) {
      _free($32);
     }
     $34 = (_oggpack_bytes($opb)|0);
     $35 = (_malloc($34)|0);
     HEAP32[$31>>2] = $35;
     $36 = ((($opb)) + 8|0);
     $37 = HEAP32[$36>>2]|0;
     $38 = (_oggpack_bytes($opb)|0);
     _memcpy(($35|0),($37|0),($38|0))|0;
     $39 = HEAP32[$31>>2]|0;
     HEAP32[$op>>2] = $39;
     $40 = (_oggpack_bytes($opb)|0);
     $41 = ((($op)) + 4|0);
     HEAP32[$41>>2] = $40;
     $42 = ((($op)) + 8|0);
     HEAP32[$42>>2] = 1;
     $43 = ((($op)) + 12|0);
     ;HEAP32[$43>>2]=0|0;HEAP32[$43+4>>2]=0|0;HEAP32[$43+8>>2]=0|0;HEAP32[$43+12>>2]=0|0;HEAP32[$43+16>>2]=0|0;
     _oggpack_reset($opb);
     __vorbis_pack_comment($opb,$vc);
     $44 = ((($3)) + 68|0);
     $45 = HEAP32[$44>>2]|0;
     $46 = ($45|0)==(0|0);
     if (!($46)) {
      _free($45);
     }
     $47 = (_oggpack_bytes($opb)|0);
     $48 = (_malloc($47)|0);
     HEAP32[$44>>2] = $48;
     $49 = HEAP32[$36>>2]|0;
     $50 = (_oggpack_bytes($opb)|0);
     _memcpy(($48|0),($49|0),($50|0))|0;
     $51 = HEAP32[$44>>2]|0;
     HEAP32[$op_comm>>2] = $51;
     $52 = (_oggpack_bytes($opb)|0);
     $53 = ((($op_comm)) + 4|0);
     HEAP32[$53>>2] = $52;
     $54 = ((($op_comm)) + 8|0);
     $55 = ((($op_comm)) + 24|0);
     ;HEAP32[$54>>2]=0|0;HEAP32[$54+4>>2]=0|0;HEAP32[$54+8>>2]=0|0;HEAP32[$54+12>>2]=0|0;
     $56 = $55;
     $57 = $56;
     HEAP32[$57>>2] = 1;
     $58 = (($56) + 4)|0;
     $59 = $58;
     HEAP32[$59>>2] = 0;
     _oggpack_reset($opb);
     $60 = HEAP32[$8>>2]|0;
     $61 = ($60|0)==(0|0);
     L16: do {
      if (!($61)) {
       _oggpack_write($opb,5,8);
       _oggpack_write($opb,118,8);
       _oggpack_write($opb,111,8);
       _oggpack_write($opb,114,8);
       _oggpack_write($opb,98,8);
       _oggpack_write($opb,105,8);
       _oggpack_write($opb,115,8);
       $62 = ((($60)) + 24|0);
       $63 = HEAP32[$62>>2]|0;
       $64 = (($63) + -1)|0;
       _oggpack_write($opb,$64,8);
       $65 = HEAP32[$62>>2]|0;
       $66 = ($65|0)>(0);
       if ($66) {
        $i$015$i = 0;
        while(1) {
         $70 = (((($60)) + 1824|0) + ($i$015$i<<2)|0);
         $71 = HEAP32[$70>>2]|0;
         $72 = (_vorbis_staticbook_pack($71,$opb)|0);
         $73 = ($72|0)==(0);
         $68 = (($i$015$i) + 1)|0;
         if (!($73)) {
          break L16;
         }
         $67 = HEAP32[$62>>2]|0;
         $69 = ($68|0)<($67|0);
         if ($69) {
          $i$015$i = $68;
         } else {
          break;
         }
        }
       }
       _oggpack_write($opb,0,6);
       _oggpack_write($opb,0,16);
       $74 = ((($60)) + 16|0);
       $75 = HEAP32[$74>>2]|0;
       $76 = (($75) + -1)|0;
       _oggpack_write($opb,$76,6);
       $77 = HEAP32[$74>>2]|0;
       $78 = ($77|0)>(0);
       if ($78) {
        $i$111$i = 0;
        while(1) {
         $79 = (((($60)) + 800|0) + ($i$111$i<<2)|0);
         $80 = HEAP32[$79>>2]|0;
         _oggpack_write($opb,$80,16);
         $81 = HEAP32[$79>>2]|0;
         $82 = (25640 + ($81<<2)|0);
         $83 = HEAP32[$82>>2]|0;
         $84 = HEAP32[$83>>2]|0;
         $85 = ($84|0)==(0|0);
         if ($85) {
          break L16;
         }
         $86 = (((($60)) + 1056|0) + ($i$111$i<<2)|0);
         $87 = HEAP32[$86>>2]|0;
         FUNCTION_TABLE_vii[$84 & 3]($87,$opb);
         $88 = (($i$111$i) + 1)|0;
         $89 = HEAP32[$74>>2]|0;
         $90 = ($88|0)<($89|0);
         if ($90) {
          $i$111$i = $88;
         } else {
          break;
         }
        }
       }
       $91 = ((($60)) + 20|0);
       $92 = HEAP32[$91>>2]|0;
       $93 = (($92) + -1)|0;
       _oggpack_write($opb,$93,6);
       $94 = HEAP32[$91>>2]|0;
       $95 = ($94|0)>(0);
       if ($95) {
        $i$27$i = 0;
        while(1) {
         $96 = (((($60)) + 1312|0) + ($i$27$i<<2)|0);
         $97 = HEAP32[$96>>2]|0;
         _oggpack_write($opb,$97,16);
         $98 = HEAP32[$96>>2]|0;
         $99 = (25648 + ($98<<2)|0);
         $100 = HEAP32[$99>>2]|0;
         $101 = HEAP32[$100>>2]|0;
         $102 = (((($60)) + 1568|0) + ($i$27$i<<2)|0);
         $103 = HEAP32[$102>>2]|0;
         FUNCTION_TABLE_vii[$101 & 3]($103,$opb);
         $104 = (($i$27$i) + 1)|0;
         $105 = HEAP32[$91>>2]|0;
         $106 = ($104|0)<($105|0);
         if ($106) {
          $i$27$i = $104;
         } else {
          break;
         }
        }
       }
       $107 = ((($60)) + 12|0);
       $108 = HEAP32[$107>>2]|0;
       $109 = (($108) + -1)|0;
       _oggpack_write($opb,$109,6);
       $110 = HEAP32[$107>>2]|0;
       $111 = ($110|0)>(0);
       if ($111) {
        $i$33$i = 0;
        while(1) {
         $112 = (((($60)) + 288|0) + ($i$33$i<<2)|0);
         $113 = HEAP32[$112>>2]|0;
         _oggpack_write($opb,$113,16);
         $114 = HEAP32[$112>>2]|0;
         $115 = (25664 + ($114<<2)|0);
         $116 = HEAP32[$115>>2]|0;
         $117 = HEAP32[$116>>2]|0;
         $118 = (((($60)) + 544|0) + ($i$33$i<<2)|0);
         $119 = HEAP32[$118>>2]|0;
         FUNCTION_TABLE_viii[$117 & 1]($1,$119,$opb);
         $120 = (($i$33$i) + 1)|0;
         $121 = HEAP32[$107>>2]|0;
         $122 = ($120|0)<($121|0);
         if ($122) {
          $i$33$i = $120;
         } else {
          break;
         }
        }
       }
       $123 = ((($60)) + 8|0);
       $124 = HEAP32[$123>>2]|0;
       $125 = (($124) + -1)|0;
       _oggpack_write($opb,$125,6);
       $126 = HEAP32[$123>>2]|0;
       $127 = ($126|0)>(0);
       if ($127) {
        $i$42$i = 0;
        while(1) {
         $128 = (((($60)) + 32|0) + ($i$42$i<<2)|0);
         $129 = HEAP32[$128>>2]|0;
         $130 = HEAP32[$129>>2]|0;
         _oggpack_write($opb,$130,1);
         $131 = HEAP32[$128>>2]|0;
         $132 = ((($131)) + 4|0);
         $133 = HEAP32[$132>>2]|0;
         _oggpack_write($opb,$133,16);
         $134 = HEAP32[$128>>2]|0;
         $135 = ((($134)) + 8|0);
         $136 = HEAP32[$135>>2]|0;
         _oggpack_write($opb,$136,16);
         $137 = HEAP32[$128>>2]|0;
         $138 = ((($137)) + 12|0);
         $139 = HEAP32[$138>>2]|0;
         _oggpack_write($opb,$139,8);
         $140 = (($i$42$i) + 1)|0;
         $141 = HEAP32[$123>>2]|0;
         $142 = ($140|0)<($141|0);
         if ($142) {
          $i$42$i = $140;
         } else {
          break;
         }
        }
       }
       _oggpack_write($opb,1,1);
       $143 = ((($3)) + 72|0);
       $144 = HEAP32[$143>>2]|0;
       $145 = ($144|0)==(0|0);
       if (!($145)) {
        _free($144);
       }
       $146 = (_oggpack_bytes($opb)|0);
       $147 = (_malloc($146)|0);
       HEAP32[$143>>2] = $147;
       $148 = HEAP32[$36>>2]|0;
       $149 = (_oggpack_bytes($opb)|0);
       _memcpy(($147|0),($148|0),($149|0))|0;
       $150 = HEAP32[$143>>2]|0;
       HEAP32[$op_code>>2] = $150;
       $151 = (_oggpack_bytes($opb)|0);
       $152 = ((($op_code)) + 4|0);
       HEAP32[$152>>2] = $151;
       $153 = ((($op_code)) + 8|0);
       $154 = ((($op_code)) + 24|0);
       ;HEAP32[$153>>2]=0|0;HEAP32[$153+4>>2]=0|0;HEAP32[$153+8>>2]=0|0;HEAP32[$153+12>>2]=0|0;
       $155 = $154;
       $156 = $155;
       HEAP32[$156>>2] = 2;
       $157 = (($155) + 4)|0;
       $158 = $157;
       HEAP32[$158>>2] = 0;
       _oggpack_writeclear($opb);
       $$0 = 0;
       STACKTOP = sp;return ($$0|0);
      }
     } while(0);
     ;HEAP32[$op>>2]=0|0;HEAP32[$op+4>>2]=0|0;HEAP32[$op+8>>2]=0|0;HEAP32[$op+12>>2]=0|0;HEAP32[$op+16>>2]=0|0;HEAP32[$op+20>>2]=0|0;HEAP32[$op+24>>2]=0|0;HEAP32[$op+28>>2]=0|0;
     ;HEAP32[$op_comm>>2]=0|0;HEAP32[$op_comm+4>>2]=0|0;HEAP32[$op_comm+8>>2]=0|0;HEAP32[$op_comm+12>>2]=0|0;HEAP32[$op_comm+16>>2]=0|0;HEAP32[$op_comm+20>>2]=0|0;HEAP32[$op_comm+24>>2]=0|0;HEAP32[$op_comm+28>>2]=0|0;
     ;HEAP32[$op_code>>2]=0|0;HEAP32[$op_code+4>>2]=0|0;HEAP32[$op_code+8>>2]=0|0;HEAP32[$op_code+12>>2]=0|0;HEAP32[$op_code+16>>2]=0|0;HEAP32[$op_code+20>>2]=0|0;HEAP32[$op_code+24>>2]=0|0;HEAP32[$op_code+28>>2]=0|0;
     $$pre$phiZ2D = $31;$ret$03 = -130;
    }
   }
  }
 }
 if ((label|0) == 27) {
  ;HEAP32[$op>>2]=0|0;HEAP32[$op+4>>2]=0|0;HEAP32[$op+8>>2]=0|0;HEAP32[$op+12>>2]=0|0;HEAP32[$op+16>>2]=0|0;HEAP32[$op+20>>2]=0|0;HEAP32[$op+24>>2]=0|0;HEAP32[$op+28>>2]=0|0;
  ;HEAP32[$op_comm>>2]=0|0;HEAP32[$op_comm+4>>2]=0|0;HEAP32[$op_comm+8>>2]=0|0;HEAP32[$op_comm+12>>2]=0|0;HEAP32[$op_comm+16>>2]=0|0;HEAP32[$op_comm+20>>2]=0|0;HEAP32[$op_comm+24>>2]=0|0;HEAP32[$op_comm+28>>2]=0|0;
  ;HEAP32[$op_code>>2]=0|0;HEAP32[$op_code+4>>2]=0|0;HEAP32[$op_code+8>>2]=0|0;HEAP32[$op_code+12>>2]=0|0;HEAP32[$op_code+16>>2]=0|0;HEAP32[$op_code+20>>2]=0|0;HEAP32[$op_code+24>>2]=0|0;HEAP32[$op_code+28>>2]=0|0;
  $$pre = ((($3)) + 64|0);
  $$pre$phiZ2D = $$pre;$ret$03 = $ret$0$ph;
 }
 _oggpack_writeclear($opb);
 $159 = HEAP32[$$pre$phiZ2D>>2]|0;
 $160 = ($159|0)==(0|0);
 if (!($160)) {
  _free($159);
 }
 $161 = ((($3)) + 68|0);
 $162 = HEAP32[$161>>2]|0;
 $163 = ($162|0)==(0|0);
 if (!($163)) {
  _free($162);
 }
 $164 = ((($3)) + 72|0);
 $165 = HEAP32[$164>>2]|0;
 $166 = ($165|0)==(0|0);
 if (!($166)) {
  _free($165);
 }
 HEAP32[$$pre$phiZ2D>>2] = 0;
 HEAP32[$161>>2] = 0;
 HEAP32[$164>>2] = 0;
 $$0 = $ret$03;
 STACKTOP = sp;return ($$0|0);
}
function __vorbis_pack_comment($opb,$vc) {
 $opb = $opb|0;
 $vc = $vc|0;
 var $$012$i2 = 0, $$012$i6 = 0, $$03$i1 = 0, $$03$i5 = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0;
 var $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $i$09 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 _oggpack_write($opb,3,8);
 _oggpack_write($opb,118,8);
 _oggpack_write($opb,111,8);
 _oggpack_write($opb,114,8);
 _oggpack_write($opb,98,8);
 _oggpack_write($opb,105,8);
 _oggpack_write($opb,115,8);
 _oggpack_write($opb,44,32);
 $$012$i2 = 1200;$$03$i1 = 44;
 while(1) {
  $0 = (($$03$i1) + -1)|0;
  $1 = ((($$012$i2)) + 1|0);
  $2 = HEAP8[$$012$i2>>0]|0;
  $3 = $2 << 24 >> 24;
  _oggpack_write($opb,$3,8);
  $4 = ($0|0)==(0);
  if ($4) {
   break;
  } else {
   $$012$i2 = $1;$$03$i1 = $0;
  }
 }
 $5 = ((($vc)) + 8|0);
 $6 = HEAP32[$5>>2]|0;
 _oggpack_write($opb,$6,32);
 $7 = HEAP32[$5>>2]|0;
 $8 = ($7|0)>(0);
 if (!($8)) {
  _oggpack_write($opb,1,1);
  return;
 }
 $9 = ((($vc)) + 4|0);
 $i$09 = 0;
 while(1) {
  $10 = HEAP32[$vc>>2]|0;
  $11 = (($10) + ($i$09<<2)|0);
  $12 = HEAP32[$11>>2]|0;
  $13 = ($12|0)==(0|0);
  if ($13) {
   _oggpack_write($opb,0,32);
  } else {
   $14 = HEAP32[$9>>2]|0;
   $15 = (($14) + ($i$09<<2)|0);
   $16 = HEAP32[$15>>2]|0;
   _oggpack_write($opb,$16,32);
   $17 = HEAP32[$9>>2]|0;
   $18 = (($17) + ($i$09<<2)|0);
   $19 = HEAP32[$18>>2]|0;
   $20 = ($19|0)==(0);
   if (!($20)) {
    $21 = HEAP32[$vc>>2]|0;
    $22 = (($21) + ($i$09<<2)|0);
    $23 = HEAP32[$22>>2]|0;
    $$012$i6 = $23;$$03$i5 = $19;
    while(1) {
     $24 = (($$03$i5) + -1)|0;
     $25 = ((($$012$i6)) + 1|0);
     $26 = HEAP8[$$012$i6>>0]|0;
     $27 = $26 << 24 >> 24;
     _oggpack_write($opb,$27,8);
     $28 = ($24|0)==(0);
     if ($28) {
      break;
     } else {
      $$012$i6 = $25;$$03$i5 = $24;
     }
    }
   }
  }
  $29 = (($i$09) + 1)|0;
  $30 = HEAP32[$5>>2]|0;
  $31 = ($29|0)<($30|0);
  if ($31) {
   $i$09 = $29;
  } else {
   break;
  }
 }
 _oggpack_write($opb,1,1);
 return;
}
function _vorbis_lpc_from_data($data,$lpci,$n,$m) {
 $data = $data|0;
 $lpci = $lpci|0;
 $n = $n|0;
 $m = $m|0;
 var $$alloca_mul = 0, $$alloca_mul1 = 0, $$lcssa = 0.0, $$pre = 0.0, $0 = 0, $1 = 0, $10 = 0.0, $11 = 0, $12 = 0, $13 = 0.0, $14 = 0.0, $15 = 0.0, $16 = 0.0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0.0, $22 = 0.0;
 var $23 = 0.0, $24 = 0.0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0.0, $32 = 0.0, $33 = 0, $34 = 0.0, $35 = 0, $36 = 0, $37 = 0.0, $38 = 0, $39 = 0, $4 = 0, $40 = 0.0;
 var $41 = 0.0, $42 = 0.0, $43 = 0, $44 = 0.0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0.0, $52 = 0, $53 = 0, $54 = 0.0, $55 = 0.0, $56 = 0.0, $57 = 0.0, $58 = 0.0, $59 = 0.0;
 var $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0.0, $66 = 0.0, $67 = 0.0, $68 = 0.0, $69 = 0.0, $7 = 0, $70 = 0.0, $71 = 0.0, $72 = 0, $73 = 0, $74 = 0.0, $75 = 0.0, $76 = 0.0, $77 = 0;
 var $78 = 0, $79 = 0.0, $8 = 0, $80 = 0.0, $81 = 0, $82 = 0, $83 = 0.0, $9 = 0.0, $d$0$lcssa = 0.0, $d$025 = 0.0, $damp$08 = 0.0, $error$021 = 0.0, $error$021$lcssa = 0.0, $error$05 = 0.0, $error$053940 = 0.0, $exitcond = 0, $exitcond36 = 0, $exitcond37 = 0, $exitcond38 = 0, $i$026 = 0;
 var $indvars$iv = 0, $indvars$iv$lcssa = 0, $indvars$iv$next = 0, $j$110 = 0, $j$2$lcssa = 0, $j$215 = 0, $j$37 = 0, $j$46 = 0, $r$011 = 0.0, $smax = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = (($m) + 1)|0;
 $1 = $0 << 3;
 $$alloca_mul = $1;
 $2 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul)|0)+15)&-16)|0;;
 $3 = $m << 3;
 $$alloca_mul1 = $3;
 $4 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul1)|0)+15)&-16)|0;;
 $5 = ($0|0)==(0);
 if ($5) {
  $22 = 0.0;
 } else {
  $6 = $m;
  while(1) {
   $7 = ($6|0)<($n|0);
   if ($7) {
    $d$025 = 0.0;$i$026 = $6;
    while(1) {
     $8 = (($data) + ($i$026<<2)|0);
     $9 = +HEAPF32[$8>>2];
     $10 = $9;
     $11 = (($i$026) - ($6))|0;
     $12 = (($data) + ($11<<2)|0);
     $13 = +HEAPF32[$12>>2];
     $14 = $13;
     $15 = $14 * $10;
     $16 = $15 + $d$025;
     $17 = (($i$026) + 1)|0;
     $exitcond38 = ($17|0)==($n|0);
     if ($exitcond38) {
      $d$0$lcssa = $16;
      break;
     } else {
      $d$025 = $16;$i$026 = $17;
     }
    }
   } else {
    $d$0$lcssa = 0.0;
   }
   $18 = (($2) + ($6<<3)|0);
   HEAPF64[$18>>3] = $d$0$lcssa;
   $19 = (($6) + -1)|0;
   $20 = ($6|0)==(0);
   if ($20) {
    break;
   } else {
    $6 = $19;
   }
  }
  $$pre = +HEAPF64[$2>>3];
  $22 = $$pre;
 }
 $21 = $22 * 1.0000000001;
 $23 = $22 * 1.0000000000000001E-9;
 $24 = $23 + 1.0E-10;
 $25 = ($m|0)>(0);
 if ($25) {
  $error$021 = $21;$indvars$iv = 0;
 } else {
  $error$053940 = $21;
  $83 = $error$053940;
  STACKTOP = sp;return (+$83);
 }
 while(1) {
  $indvars$iv$next = (($indvars$iv) + 1)|0;
  $26 = $error$021 < $24;
  if ($26) {
   $error$021$lcssa = $error$021;$indvars$iv$lcssa = $indvars$iv;
   label = 8;
   break;
  }
  $30 = (($2) + ($indvars$iv$next<<3)|0);
  $31 = +HEAPF64[$30>>3];
  $32 = -$31;
  $33 = ($indvars$iv|0)>(0);
  if ($33) {
   $j$110 = 0;$r$011 = $32;
   while(1) {
    $36 = (($4) + ($j$110<<3)|0);
    $37 = +HEAPF64[$36>>3];
    $38 = (($indvars$iv) - ($j$110))|0;
    $39 = (($2) + ($38<<3)|0);
    $40 = +HEAPF64[$39>>3];
    $41 = $40 * $37;
    $42 = $r$011 - $41;
    $43 = (($j$110) + 1)|0;
    $exitcond37 = ($43|0)==($indvars$iv|0);
    if ($exitcond37) {
     $$lcssa = $42;
     break;
    } else {
     $j$110 = $43;$r$011 = $42;
    }
   }
   $44 = $$lcssa / $error$021;
   $45 = (($4) + ($indvars$iv<<3)|0);
   HEAPF64[$45>>3] = $44;
   $46 = (($indvars$iv|0) / 2)&-1;
   $47 = ($indvars$iv|0)>(1);
   if ($47) {
    $48 = (($indvars$iv) + -1)|0;
    $49 = ($46|0)>(1);
    $j$215 = 0;
    while(1) {
     $50 = (($4) + ($j$215<<3)|0);
     $51 = +HEAPF64[$50>>3];
     $52 = (($48) - ($j$215))|0;
     $53 = (($4) + ($52<<3)|0);
     $54 = +HEAPF64[$53>>3];
     $55 = $54 * $44;
     $56 = $55 + $51;
     HEAPF64[$50>>3] = $56;
     $57 = $51 * $44;
     $58 = +HEAPF64[$53>>3];
     $59 = $58 + $57;
     HEAPF64[$53>>3] = $59;
     $60 = (($j$215) + 1)|0;
     $61 = ($60|0)<($46|0);
     if ($61) {
      $j$215 = $60;
     } else {
      break;
     }
    }
    $smax = $49 ? $46 : 1;
    $67 = $44;$j$2$lcssa = $smax;
   } else {
    $67 = $44;$j$2$lcssa = 0;
   }
  } else {
   $34 = $32 / $error$021;
   $35 = (($4) + ($indvars$iv<<3)|0);
   HEAPF64[$35>>3] = $34;
   $67 = $34;$j$2$lcssa = 0;
  }
  $62 = $indvars$iv & 1;
  $63 = ($62|0)==(0);
  if (!($63)) {
   $64 = (($4) + ($j$2$lcssa<<3)|0);
   $65 = +HEAPF64[$64>>3];
   $66 = $65 * $67;
   $68 = $66 + $65;
   HEAPF64[$64>>3] = $68;
  }
  $69 = $67 * $67;
  $70 = 1.0 - $69;
  $71 = $70 * $error$021;
  $72 = ($indvars$iv$next|0)<($m|0);
  if ($72) {
   $error$021 = $71;$indvars$iv = $indvars$iv$next;
  } else {
   $error$05 = $71;
   break;
  }
 }
 if ((label|0) == 8) {
  $27 = (($4) + ($indvars$iv$lcssa<<3)|0);
  $28 = (($m) - ($indvars$iv$lcssa))|0;
  $29 = $28 << 3;
  _memset(($27|0),0,($29|0))|0;
  $error$05 = $error$021$lcssa;
 }
 if ($25) {
  $damp$08 = 0.98999999999999999;$j$37 = 0;
 } else {
  $error$053940 = $error$05;
  $83 = $error$053940;
  STACKTOP = sp;return (+$83);
 }
 while(1) {
  $73 = (($4) + ($j$37<<3)|0);
  $74 = +HEAPF64[$73>>3];
  $75 = $74 * $damp$08;
  HEAPF64[$73>>3] = $75;
  $76 = $damp$08 * 0.98999999999999999;
  $77 = (($j$37) + 1)|0;
  $exitcond36 = ($77|0)==($m|0);
  if ($exitcond36) {
   break;
  } else {
   $damp$08 = $76;$j$37 = $77;
  }
 }
 if ($25) {
  $j$46 = 0;
 } else {
  $error$053940 = $error$05;
  $83 = $error$053940;
  STACKTOP = sp;return (+$83);
 }
 while(1) {
  $78 = (($4) + ($j$46<<3)|0);
  $79 = +HEAPF64[$78>>3];
  $80 = $79;
  $81 = (($lpci) + ($j$46<<2)|0);
  HEAPF32[$81>>2] = $80;
  $82 = (($j$46) + 1)|0;
  $exitcond = ($82|0)==($m|0);
  if ($exitcond) {
   $error$053940 = $error$05;
   break;
  } else {
   $j$46 = $82;
  }
 }
 $83 = $error$053940;
 STACKTOP = sp;return (+$83);
}
function _vorbis_lpc_predict($coeff,$prime,$m,$data,$n) {
 $coeff = $coeff|0;
 $prime = $prime|0;
 $m = $m|0;
 $data = $data|0;
 $n = $n|0;
 var $$alloca_mul = 0, $$lcssa = 0.0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0.0, $16 = 0, $17 = 0, $18 = 0.0, $19 = 0.0, $2 = 0, $20 = 0.0, $3 = 0, $4 = 0, $5 = 0, $6 = 0;
 var $7 = 0, $8 = 0, $9 = 0, $exitcond = 0, $exitcond19 = 0, $i$210$us = 0, $indvars$iv = 0, $indvars$iv$next = 0, $o$06$us = 0, $p$07$us = 0, $y$08$us = 0.0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = (($n) + ($m))|0;
 $1 = $0 << 2;
 $$alloca_mul = $1;
 $2 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul)|0)+15)&-16)|0;;
 $3 = ($prime|0)==(0|0);
 $4 = ($m|0)>(0);
 if ($3) {
  if ($4) {
   $6 = $m << 2;
   _memset(($2|0),0,($6|0))|0;
  }
 } else {
  if ($4) {
   $5 = $m << 2;
   _memcpy(($2|0),($prime|0),($5|0))|0;
  }
 }
 $7 = ($n|0)>(0);
 if (!($7)) {
  STACKTOP = sp;return;
 }
 $8 = ($m|0)>(0);
 if ($8) {
  $i$210$us = 0;$indvars$iv = $m;
 } else {
  $9 = $n << 2;
  _memset(($2|0),0,($9|0))|0;
  _memset(($data|0),0,($9|0))|0;
  STACKTOP = sp;return;
 }
 while(1) {
  $o$06$us = $i$210$us;$p$07$us = $m;$y$08$us = 0.0;
  while(1) {
   $13 = (($o$06$us) + 1)|0;
   $14 = (($2) + ($o$06$us<<2)|0);
   $15 = +HEAPF32[$14>>2];
   $16 = (($p$07$us) + -1)|0;
   $17 = (($coeff) + ($16<<2)|0);
   $18 = +HEAPF32[$17>>2];
   $19 = $18 * $15;
   $20 = $y$08$us - $19;
   $exitcond = ($13|0)==($indvars$iv|0);
   if ($exitcond) {
    $$lcssa = $20;
    break;
   } else {
    $o$06$us = $13;$p$07$us = $16;$y$08$us = $20;
   }
  }
  $10 = (($2) + ($indvars$iv<<2)|0);
  HEAPF32[$10>>2] = $$lcssa;
  $11 = (($data) + ($i$210$us<<2)|0);
  HEAPF32[$11>>2] = $$lcssa;
  $12 = (($i$210$us) + 1)|0;
  $indvars$iv$next = (($indvars$iv) + 1)|0;
  $exitcond19 = ($12|0)==($n|0);
  if ($exitcond19) {
   break;
  } else {
   $i$210$us = $12;$indvars$iv = $indvars$iv$next;
  }
 }
 STACKTOP = sp;return;
}
function _mapping0_pack($vi,$vm,$opb) {
 $vi = $vi|0;
 $vm = $vm|0;
 $opb = $opb|0;
 var $$pre$pre = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0;
 var $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0;
 var $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $i$05 = 0, $i$13 = 0, $i$22 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = HEAP32[$vm>>2]|0;
 $1 = ($0|0)>(1);
 if ($1) {
  _oggpack_write($opb,1,1);
  $2 = HEAP32[$vm>>2]|0;
  $3 = (($2) + -1)|0;
  _oggpack_write($opb,$3,4);
 } else {
  _oggpack_write($opb,0,1);
 }
 $4 = ((($vm)) + 1156|0);
 $5 = HEAP32[$4>>2]|0;
 $6 = ($5|0)>(0);
 if ($6) {
  _oggpack_write($opb,1,1);
  $7 = HEAP32[$4>>2]|0;
  $8 = (($7) + -1)|0;
  _oggpack_write($opb,$8,8);
  $9 = HEAP32[$4>>2]|0;
  $10 = ($9|0)>(0);
  if ($10) {
   $11 = ((($vm)) + 1160|0);
   $12 = ((($vi)) + 4|0);
   $13 = ((($vm)) + 2184|0);
   $i$05 = 0;
   while(1) {
    $14 = (($11) + ($i$05<<2)|0);
    $15 = HEAP32[$14>>2]|0;
    $16 = HEAP32[$12>>2]|0;
    $17 = (($16) + -1)|0;
    $18 = (_ov_ilog($17)|0);
    _oggpack_write($opb,$15,$18);
    $19 = (($13) + ($i$05<<2)|0);
    $20 = HEAP32[$19>>2]|0;
    $21 = HEAP32[$12>>2]|0;
    $22 = (($21) + -1)|0;
    $23 = (_ov_ilog($22)|0);
    _oggpack_write($opb,$20,$23);
    $24 = (($i$05) + 1)|0;
    $25 = HEAP32[$4>>2]|0;
    $26 = ($24|0)<($25|0);
    if ($26) {
     $i$05 = $24;
    } else {
     break;
    }
   }
  }
 } else {
  _oggpack_write($opb,0,1);
 }
 _oggpack_write($opb,0,2);
 $27 = HEAP32[$vm>>2]|0;
 $28 = ($27|0)>(1);
 if ($28) {
  $29 = ((($vi)) + 4|0);
  $30 = HEAP32[$29>>2]|0;
  $31 = ($30|0)>(0);
  if ($31) {
   $32 = ((($vm)) + 4|0);
   $i$13 = 0;
   while(1) {
    $37 = (($32) + ($i$13<<2)|0);
    $38 = HEAP32[$37>>2]|0;
    _oggpack_write($opb,$38,4);
    $39 = (($i$13) + 1)|0;
    $40 = HEAP32[$29>>2]|0;
    $41 = ($39|0)<($40|0);
    if ($41) {
     $i$13 = $39;
    } else {
     break;
    }
   }
   $$pre$pre = HEAP32[$vm>>2]|0;
   $33 = $$pre$pre;
   label = 13;
  }
 } else {
  $33 = $27;
  label = 13;
 }
 if ((label|0) == 13) {
  $34 = ($33|0)>(0);
  if (!($34)) {
   return;
  }
 }
 $35 = ((($vm)) + 1028|0);
 $36 = ((($vm)) + 1092|0);
 $i$22 = 0;
 while(1) {
  _oggpack_write($opb,0,8);
  $42 = (($35) + ($i$22<<2)|0);
  $43 = HEAP32[$42>>2]|0;
  _oggpack_write($opb,$43,8);
  $44 = (($36) + ($i$22<<2)|0);
  $45 = HEAP32[$44>>2]|0;
  _oggpack_write($opb,$45,8);
  $46 = (($i$22) + 1)|0;
  $47 = HEAP32[$vm>>2]|0;
  $48 = ($46|0)<($47|0);
  if ($48) {
   $i$22 = $46;
  } else {
   break;
  }
 }
 return;
}
function _mapping0_unpack($vi,$opb) {
 $vi = $vi|0;
 $opb = $opb|0;
 var $$0 = 0, $$pre = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0;
 var $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0;
 var $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0;
 var $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $8 = 0, $9 = 0, $i$013 = 0, $i$111 = 0, $i$210 = 0;
 var $or$cond = 0, $or$cond2 = 0, $or$cond3 = 0, $or$cond4 = 0, $or$cond5 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = (_calloc(1,3208)|0);
 $1 = ((($vi)) + 28|0);
 $2 = HEAP32[$1>>2]|0;
 _memset(($0|0),0,3208)|0;
 $3 = ((($vi)) + 4|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = ($4|0)<(1);
 L1: do {
  if ($5) {
   label = 24;
  } else {
   $6 = (_oggpack_read($opb,1)|0);
   $7 = ($6|0)<(0);
   if ($7) {
    label = 24;
   } else {
    $8 = ($6|0)==(0);
    if ($8) {
     HEAP32[$0>>2] = 1;
    } else {
     $9 = (_oggpack_read($opb,4)|0);
     $10 = (($9) + 1)|0;
     HEAP32[$0>>2] = $10;
     $11 = ($9|0)<(0);
     if ($11) {
      break;
     }
    }
    $12 = (_oggpack_read($opb,1)|0);
    $13 = ($12|0)<(0);
    if (!($13)) {
     $14 = ($12|0)==(0);
     if (!($14)) {
      $15 = (_oggpack_read($opb,8)|0);
      $16 = (($15) + 1)|0;
      $17 = ((($0)) + 1156|0);
      HEAP32[$17>>2] = $16;
      $18 = ($15|0)<(0);
      if ($18) {
       break;
      }
      $19 = ((($0)) + 1160|0);
      $20 = ((($0)) + 2184|0);
      $$pre = HEAP32[$3>>2]|0;
      $25 = $$pre;$i$013 = 0;
      while(1) {
       $24 = (($25) + -1)|0;
       $26 = (_ov_ilog($24)|0);
       $27 = (_oggpack_read($opb,$26)|0);
       $28 = (($19) + ($i$013<<2)|0);
       HEAP32[$28>>2] = $27;
       $29 = HEAP32[$3>>2]|0;
       $30 = (($29) + -1)|0;
       $31 = (_ov_ilog($30)|0);
       $32 = (_oggpack_read($opb,$31)|0);
       $33 = (($20) + ($i$013<<2)|0);
       HEAP32[$33>>2] = $32;
       $34 = $32 | $27;
       $35 = ($34|0)<(0);
       $36 = ($27|0)==($32|0);
       $or$cond = $36 | $35;
       if ($or$cond) {
        break L1;
       }
       $37 = HEAP32[$3>>2]|0;
       $38 = ($27|0)<($37|0);
       $39 = ($32|0)<($37|0);
       $or$cond2 = $38 & $39;
       $22 = (($i$013) + 1)|0;
       if (!($or$cond2)) {
        break L1;
       }
       $21 = HEAP32[$17>>2]|0;
       $23 = ($22|0)<($21|0);
       if ($23) {
        $25 = $37;$i$013 = $22;
       } else {
        break;
       }
      }
     }
     $40 = (_oggpack_read($opb,2)|0);
     $41 = ($40|0)==(0);
     if ($41) {
      $42 = HEAP32[$0>>2]|0;
      $43 = ($42|0)>(1);
      if ($43) {
       $44 = HEAP32[$3>>2]|0;
       $45 = ($44|0)>(0);
       if ($45) {
        $46 = ((($0)) + 4|0);
        $i$111 = 0;
        while(1) {
         $56 = (_oggpack_read($opb,4)|0);
         $57 = (($46) + ($i$111<<2)|0);
         HEAP32[$57>>2] = $56;
         $58 = HEAP32[$0>>2]|0;
         $59 = ($56|0)>=($58|0);
         $60 = ($56|0)<(0);
         $or$cond3 = $60 | $59;
         $54 = (($i$111) + 1)|0;
         if ($or$cond3) {
          break L1;
         }
         $53 = HEAP32[$3>>2]|0;
         $55 = ($54|0)<($53|0);
         if ($55) {
          $i$111 = $54;
         } else {
          $47 = $58;
          label = 17;
          break;
         }
        }
       }
      } else {
       $47 = $42;
       label = 17;
      }
      if ((label|0) == 17) {
       $48 = ($47|0)>(0);
       if (!($48)) {
        $$0 = $0;
        return ($$0|0);
       }
      }
      $49 = ((($0)) + 1028|0);
      $50 = ((($2)) + 16|0);
      $51 = ((($0)) + 1092|0);
      $52 = ((($2)) + 20|0);
      $i$210 = 0;
      while(1) {
       (_oggpack_read($opb,8)|0);
       $64 = (_oggpack_read($opb,8)|0);
       $65 = (($49) + ($i$210<<2)|0);
       HEAP32[$65>>2] = $64;
       $66 = HEAP32[$50>>2]|0;
       $67 = ($64|0)>=($66|0);
       $68 = ($64|0)<(0);
       $or$cond4 = $68 | $67;
       if ($or$cond4) {
        break L1;
       }
       $69 = (_oggpack_read($opb,8)|0);
       $70 = (($51) + ($i$210<<2)|0);
       HEAP32[$70>>2] = $69;
       $71 = HEAP32[$52>>2]|0;
       $72 = ($69|0)>=($71|0);
       $73 = ($69|0)<(0);
       $or$cond5 = $73 | $72;
       $62 = (($i$210) + 1)|0;
       if ($or$cond5) {
        break L1;
       }
       $61 = HEAP32[$0>>2]|0;
       $63 = ($62|0)<($61|0);
       if ($63) {
        $i$210 = $62;
       } else {
        $$0 = $0;
        break;
       }
      }
      return ($$0|0);
     }
    }
   }
  }
 } while(0);
 if ((label|0) == 24) {
  $74 = ($0|0)==(0|0);
  if ($74) {
   $$0 = 0;
   return ($$0|0);
  }
 }
 _free($0);
 $$0 = 0;
 return ($$0|0);
}
function _mapping0_free_info($i) {
 $i = $i|0;
 var $0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ($i|0)==(0|0);
 if (!($0)) {
  _free($i);
 }
 return;
}
function _mapping0_forward($vb) {
 $vb = $vb|0;
 var $$ = 0, $$0 = 0, $$alloca_mul = 0, $$alloca_mul1 = 0, $$alloca_mul3 = 0, $$alloca_mul5 = 0, $$lcssa = 0, $$pre = 0, $$pre$phi53Z2D = 0, $$pre$phi55Z2D = 0, $$pre$phiZ2D = 0, $$pre51 = 0, $$pre52 = 0, $$pre54 = 0, $$sum = 0, $$sum1$us = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0.0;
 var $101 = 0.0, $102 = 0, $103 = 0, $104 = 0, $105 = 0.0, $106 = 0, $107 = 0, $108 = 0, $109 = 0.0, $11 = 0, $110 = 0, $111 = 0.0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0, $118 = 0, $119 = 0;
 var $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0.0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0, $136 = 0, $137 = 0;
 var $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0, $154 = 0, $155 = 0;
 var $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $171 = 0, $172 = 0, $173 = 0;
 var $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0, $189 = 0, $19 = 0, $190 = 0, $191 = 0;
 var $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0, $206 = 0, $207 = 0, $208 = 0, $209 = 0;
 var $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0, $224 = 0, $225 = 0, $226 = 0, $227 = 0;
 var $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0.0, $240 = 0, $241 = 0, $242 = 0, $243 = 0, $244 = 0, $245 = 0;
 var $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0, $260 = 0, $261 = 0, $262 = 0, $263 = 0;
 var $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0, $27 = 0, $270 = 0, $271 = 0, $272 = 0, $273 = 0, $274 = 0, $275 = 0, $276 = 0, $277 = 0, $278 = 0, $279 = 0, $28 = 0, $280 = 0, $281 = 0;
 var $282 = 0, $283 = 0, $284 = 0, $285 = 0, $286 = 0, $287 = 0, $288 = 0, $289 = 0, $29 = 0, $290 = 0, $291 = 0, $292 = 0, $293 = 0, $294 = 0, $295 = 0, $296 = 0, $297 = 0, $298 = 0, $299 = 0, $3 = 0;
 var $30 = 0, $300 = 0, $301 = 0, $302 = 0.0, $303 = 0.0, $304 = 0.0, $305 = 0.0, $306 = 0.0, $307 = 0.0, $308 = 0, $309 = 0, $31 = 0, $310 = 0, $311 = 0, $312 = 0, $313 = 0, $314 = 0, $315 = 0, $316 = 0, $317 = 0;
 var $318 = 0, $319 = 0, $32 = 0, $320 = 0, $321 = 0, $322 = 0, $323 = 0, $324 = 0, $325 = 0, $326 = 0, $327 = 0.0, $328 = 0, $329 = 0, $33 = 0, $330 = 0, $331 = 0, $332 = 0, $333 = 0, $334 = 0, $335 = 0;
 var $336 = 0, $337 = 0, $338 = 0, $339 = 0, $34 = 0, $340 = 0, $341 = 0, $342 = 0, $343 = 0, $344 = 0, $345 = 0, $346 = 0, $347 = 0, $348 = 0, $349 = 0, $35 = 0, $350 = 0, $351 = 0, $352 = 0, $353 = 0;
 var $354 = 0, $355 = 0, $356 = 0, $357 = 0, $358 = 0, $359 = 0, $36 = 0, $360 = 0, $361 = 0, $362 = 0, $363 = 0, $364 = 0, $365 = 0, $366 = 0, $367 = 0, $368 = 0, $369 = 0, $37 = 0, $370 = 0, $371 = 0;
 var $372 = 0, $373 = 0, $374 = 0, $375 = 0, $376 = 0, $377 = 0, $378 = 0, $379 = 0, $38 = 0, $380 = 0, $381 = 0, $382 = 0, $383 = 0, $384 = 0, $385 = 0, $386 = 0, $387 = 0, $388 = 0, $389 = 0, $39 = 0;
 var $390 = 0, $391 = 0, $392 = 0, $393 = 0, $394 = 0, $395 = 0, $396 = 0, $397 = 0, $398 = 0, $399 = 0, $4 = 0, $40 = 0, $400 = 0, $401 = 0, $402 = 0, $403 = 0, $404 = 0, $405 = 0, $406 = 0, $407 = 0;
 var $408 = 0, $409 = 0, $41 = 0.0, $410 = 0, $411 = 0, $412 = 0, $413 = 0, $414 = 0, $415 = 0, $416 = 0, $417 = 0, $418 = 0, $419 = 0, $42 = 0.0, $420 = 0, $421 = 0, $422 = 0, $423 = 0, $424 = 0, $425 = 0;
 var $426 = 0, $427 = 0, $428 = 0, $429 = 0, $43 = 0, $430 = 0, $431 = 0, $432 = 0, $433 = 0, $434 = 0, $435 = 0, $436 = 0, $437 = 0, $438 = 0, $439 = 0, $44 = 0, $440 = 0, $441 = 0, $442 = 0, $443 = 0;
 var $444 = 0, $445 = 0, $446 = 0, $447 = 0, $448 = 0, $449 = 0, $45 = 0, $450 = 0, $451 = 0, $452 = 0, $453 = 0, $454 = 0, $455 = 0, $456 = 0, $457 = 0, $458 = 0, $459 = 0, $46 = 0, $460 = 0, $461 = 0;
 var $462 = 0, $463 = 0, $464 = 0, $465 = 0, $466 = 0, $467 = 0, $468 = 0, $469 = 0, $47 = 0.0, $470 = 0, $471 = 0, $472 = 0, $473 = 0, $474 = 0, $475 = 0, $476 = 0, $477 = 0, $478 = 0, $479 = 0, $48 = 0.0;
 var $480 = 0, $481 = 0, $482 = 0, $483 = 0, $484 = 0, $485 = 0, $486 = 0, $487 = 0, $488 = 0, $489 = 0, $49 = 0.0, $490 = 0, $491 = 0, $492 = 0, $493 = 0, $494 = 0, $495 = 0, $496 = 0, $497 = 0, $498 = 0;
 var $499 = 0, $5 = 0, $50 = 0.0, $500 = 0, $501 = 0, $502 = 0, $503 = 0, $504 = 0, $505 = 0, $506 = 0, $507 = 0, $508 = 0, $509 = 0, $51 = 0.0, $510 = 0, $511 = 0, $512 = 0, $513 = 0, $514 = 0, $515 = 0;
 var $516 = 0, $517 = 0, $518 = 0, $519 = 0, $52 = 0.0, $520 = 0, $521 = 0, $522 = 0, $523 = 0, $524 = 0, $525 = 0, $526 = 0, $527 = 0, $528 = 0, $529 = 0, $53 = 0, $530 = 0, $531 = 0, $532 = 0, $533 = 0;
 var $534 = 0, $535 = 0, $536 = 0, $537 = 0, $538 = 0, $539 = 0, $54 = 0, $540 = 0, $541 = 0, $542 = 0, $543 = 0, $544 = 0, $545 = 0, $546 = 0, $547 = 0, $548 = 0, $549 = 0, $55 = 0, $550 = 0, $551 = 0;
 var $552 = 0, $553 = 0, $554 = 0, $555 = 0, $556 = 0, $557 = 0, $558 = 0, $559 = 0, $56 = 0.0, $560 = 0, $561 = 0, $562 = 0, $563 = 0, $564 = 0, $565 = 0, $566 = 0, $567 = 0, $568 = 0, $569 = 0, $57 = 0;
 var $570 = 0, $571 = 0, $572 = 0, $573 = 0, $574 = 0, $575 = 0, $576 = 0, $577 = 0, $578 = 0, $579 = 0, $58 = 0, $580 = 0, $581 = 0, $582 = 0, $583 = 0, $584 = 0, $585 = 0, $586 = 0, $587 = 0, $588 = 0;
 var $589 = 0, $59 = 0.0, $590 = 0, $591 = 0, $592 = 0, $593 = 0, $594 = 0, $595 = 0, $596 = 0, $597 = 0.0, $598 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0;
 var $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0.0, $8 = 0, $80 = 0.0, $81 = 0.0, $82 = 0.0, $83 = 0.0, $84 = 0.0, $85 = 0;
 var $86 = 0, $87 = 0.0, $88 = 0.0, $89 = 0, $9 = 0, $90 = 0, $91 = 0.0, $92 = 0.0, $93 = 0.0, $94 = 0, $95 = 0, $96 = 0.0, $97 = 0.0, $98 = 0.0, $99 = 0.0, $ch_in_bundle$0$lcssa = 0, $ch_in_bundle$07 = 0, $ch_in_bundle$1 = 0, $ch_in_bundle$2$lcssa = 0, $ch_in_bundle$213 = 0;
 var $ch_in_bundle$3 = 0, $global_ampmax$0$lcssa = 0.0, $global_ampmax$037 = 0.0, $global_ampmax$1 = 0.0, $i$038 = 0, $i$129 = 0, $i$129$us = 0, $i$25 = 0, $i$318 = 0, $j$033 = 0, $j$123$us = 0, $j$26 = 0, $j$312 = 0, $k$222 = 0, $not$ = 0, dest = 0, label = 0, sp = 0, stop = 0;
 sp = STACKTOP;
 $0 = ((($vb)) + 64|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 4|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ((($3)) + 28|0);
 $5 = HEAP32[$4>>2]|0;
 $6 = ((($1)) + 104|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = ((($vb)) + 104|0);
 $9 = HEAP32[$8>>2]|0;
 $10 = ((($vb)) + 36|0);
 $11 = HEAP32[$10>>2]|0;
 $12 = ((($3)) + 4|0);
 $13 = HEAP32[$12>>2]|0;
 $14 = $13 << 2;
 $$alloca_mul = $14;
 $15 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul)|0)+15)&-16)|0;;
 $16 = (__vorbis_block_alloc($vb,$14)|0);
 $17 = HEAP32[$12>>2]|0;
 $18 = $17 << 2;
 $19 = (__vorbis_block_alloc($vb,$18)|0);
 $20 = HEAP32[$12>>2]|0;
 $21 = $20 << 2;
 $22 = (__vorbis_block_alloc($vb,$21)|0);
 $23 = ((($9)) + 4|0);
 $24 = +HEAPF32[$23>>2];
 $25 = HEAP32[$12>>2]|0;
 $26 = $25 << 2;
 $$alloca_mul1 = $26;
 $27 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul1)|0)+15)&-16)|0;;
 $28 = ((($9)) + 8|0);
 $29 = HEAP32[$28>>2]|0;
 $30 = ((($vb)) + 28|0);
 $31 = HEAP32[$30>>2]|0;
 $32 = (((($5)) + 544|0) + ($31<<2)|0);
 $33 = HEAP32[$32>>2]|0;
 $34 = ((($7)) + 56|0);
 $35 = HEAP32[$34>>2]|0;
 $36 = ($31|0)!=(0);
 $37 = $36 ? 2 : 0;
 $$sum = (($37) + ($29))|0;
 $38 = (($35) + (($$sum*52)|0)|0);
 $39 = ((($vb)) + 40|0);
 HEAP32[$39>>2] = $31;
 $40 = ($25|0)>(0);
 if ($40) {
  $41 = (+($11|0));
  $42 = 4.0 / $41;
  $43 = (HEAPF32[tempDoublePtr>>2]=$42,HEAP32[tempDoublePtr>>2]|0);
  $44 = (($11|0) / 2)&-1;
  $45 = $44 << 2;
  $46 = $43 & 2147483647;
  $47 = (+($46>>>0));
  $48 = $47 * 7.1771142984289327E-7;
  $49 = $48 + -764.6162109375;
  $50 = $49;
  $51 = $50 + 0.34499999999999997;
  $52 = $51;
  $53 = ((($7)) + 4|0);
  $54 = ((($vb)) + 24|0);
  $55 = ((($vb)) + 32|0);
  $56 = $52 + -764.6162109375;
  $57 = (($11) + -1)|0;
  $58 = ($57|0)>(1);
  $59 = $52 + -382.30810546875;
  $global_ampmax$037 = $24;$i$038 = 0;
  while(1) {
   $60 = HEAP32[$vb>>2]|0;
   $61 = (($60) + ($i$038<<2)|0);
   $62 = HEAP32[$61>>2]|0;
   $63 = (__vorbis_block_alloc($vb,$45)|0);
   $64 = (($19) + ($i$038<<2)|0);
   HEAP32[$64>>2] = $63;
   $65 = (__vorbis_block_alloc($vb,$45)|0);
   $66 = (($16) + ($i$038<<2)|0);
   HEAP32[$66>>2] = $65;
   $67 = HEAP32[$54>>2]|0;
   $68 = HEAP32[$30>>2]|0;
   $69 = HEAP32[$55>>2]|0;
   __vorbis_apply_window($62,$53,$5,$67,$68,$69);
   $70 = HEAP32[$30>>2]|0;
   $71 = (((($7)) + 12|0) + ($70<<2)|0);
   $72 = HEAP32[$71>>2]|0;
   $73 = HEAP32[$72>>2]|0;
   $74 = HEAP32[$66>>2]|0;
   _mdct_forward($73,$62,$74);
   $75 = HEAP32[$30>>2]|0;
   $76 = (((($7)) + 20|0) + (($75*12)|0)|0);
   _drft_forward($76,$62);
   $77 = HEAP32[$62>>2]|0;
   $78 = $77 & 2147483647;
   $79 = (+($78>>>0));
   $80 = $79 * 7.1771142984289327E-7;
   $81 = $56 + $80;
   $82 = $81;
   $83 = $82 + 0.34499999999999997;
   $84 = $83;
   HEAPF32[$62>>2] = $84;
   $85 = (($27) + ($i$038<<2)|0);
   HEAPF32[$85>>2] = $84;
   if ($58) {
    $105 = $84;$j$033 = 1;
    while(1) {
     $86 = (($62) + ($j$033<<2)|0);
     $87 = +HEAPF32[$86>>2];
     $88 = $87 * $87;
     $89 = (($j$033) + 1)|0;
     $90 = (($62) + ($89<<2)|0);
     $91 = +HEAPF32[$90>>2];
     $92 = $91 * $91;
     $93 = $92 + $88;
     $94 = (HEAPF32[tempDoublePtr>>2]=$93,HEAP32[tempDoublePtr>>2]|0);
     $95 = $94 & 2147483647;
     $96 = (+($95>>>0));
     $97 = $96 * 3.5885571492144663E-7;
     $98 = $59 + $97;
     $99 = $98;
     $100 = $99 + 0.34499999999999997;
     $101 = $100;
     $102 = $89 >> 1;
     $103 = (($62) + ($102<<2)|0);
     HEAPF32[$103>>2] = $101;
     $104 = $101 > $105;
     if ($104) {
      HEAPF32[$85>>2] = $101;
      $597 = $101;
     } else {
      $597 = $105;
     }
     $106 = (($j$033) + 2)|0;
     $107 = ($106|0)<($57|0);
     if ($107) {
      $105 = $597;$j$033 = $106;
     } else {
      $109 = $597;
      break;
     }
    }
   } else {
    $109 = $84;
   }
   $108 = $109 > 0.0;
   if ($108) {
    HEAPF32[$85>>2] = 0.0;
    $111 = 0.0;
   } else {
    $111 = $109;
   }
   $110 = $111 > $global_ampmax$037;
   $global_ampmax$1 = $110 ? $111 : $global_ampmax$037;
   $112 = (($i$038) + 1)|0;
   $113 = HEAP32[$12>>2]|0;
   $114 = ($112|0)<($113|0);
   if ($114) {
    $global_ampmax$037 = $global_ampmax$1;$i$038 = $112;
   } else {
    $$pre$phi53Z2D = $45;$$pre$phiZ2D = $44;$global_ampmax$0$lcssa = $global_ampmax$1;
    break;
   }
  }
 } else {
  $$pre51 = (($11|0) / 2)&-1;
  $$pre52 = $$pre51 << 2;
  $$pre$phi53Z2D = $$pre52;$$pre$phiZ2D = $$pre51;$global_ampmax$0$lcssa = $24;
 }
 $115 = (__vorbis_block_alloc($vb,$$pre$phi53Z2D)|0);
 $116 = (__vorbis_block_alloc($vb,$$pre$phi53Z2D)|0);
 $117 = HEAP32[$12>>2]|0;
 $118 = ($117|0)>(0);
 L17: do {
  if ($118) {
   $119 = ($11|0)>(1);
   $120 = ((($7)) + 48|0);
   if ($119) {
    $i$129$us = 0;
   } else {
    $i$129 = 0;
    while(1) {
     $316 = (((($33)) + 4|0) + ($i$129<<2)|0);
     $317 = HEAP32[$316>>2]|0;
     $318 = (($16) + ($i$129<<2)|0);
     $319 = HEAP32[$318>>2]|0;
     $320 = HEAP32[$vb>>2]|0;
     $321 = (($320) + ($i$129<<2)|0);
     $322 = HEAP32[$321>>2]|0;
     $323 = (($322) + ($$pre$phiZ2D<<2)|0);
     HEAP32[$39>>2] = $31;
     $324 = (__vorbis_block_alloc($vb,60)|0);
     $325 = (($22) + ($i$129<<2)|0);
     HEAP32[$325>>2] = $324;
     dest=$324; stop=dest+60|0; do { HEAP32[dest>>2]=0|0; dest=dest+4|0; } while ((dest|0) < (stop|0));
     __vp_noisemask($38,$323,$115);
     $326 = (($27) + ($i$129<<2)|0);
     $327 = +HEAPF32[$326>>2];
     __vp_tonemask($38,$322,$116,$global_ampmax$0$lcssa,$327);
     __vp_offset_and_mix($38,$115,$116,1,$322,$319,$323);
     $328 = (((($33)) + 1028|0) + ($317<<2)|0);
     $329 = HEAP32[$328>>2]|0;
     $330 = (((($5)) + 800|0) + ($329<<2)|0);
     $331 = HEAP32[$330>>2]|0;
     $332 = ($331|0)==(1);
     if (!($332)) {
      $$0 = -1;
      break;
     }
     $333 = HEAP32[$120>>2]|0;
     $334 = (($333) + ($329<<2)|0);
     $335 = HEAP32[$334>>2]|0;
     $336 = (_floor1_fit($vb,$335,$323,$322)|0);
     $337 = HEAP32[$325>>2]|0;
     $338 = ((($337)) + 28|0);
     HEAP32[$338>>2] = $336;
     $339 = (_vorbis_bitrate_managed($vb)|0);
     $340 = ($339|0)==(0);
     if (!($340)) {
      $341 = HEAP32[$325>>2]|0;
      $342 = ((($341)) + 28|0);
      $343 = HEAP32[$342>>2]|0;
      $344 = ($343|0)==(0|0);
      if (!($344)) {
       __vp_offset_and_mix($38,$115,$116,2,$322,$319,$323);
       $345 = HEAP32[$328>>2]|0;
       $346 = HEAP32[$120>>2]|0;
       $347 = (($346) + ($345<<2)|0);
       $348 = HEAP32[$347>>2]|0;
       $349 = (_floor1_fit($vb,$348,$323,$322)|0);
       $350 = HEAP32[$325>>2]|0;
       $351 = ((($350)) + 56|0);
       HEAP32[$351>>2] = $349;
       __vp_offset_and_mix($38,$115,$116,0,$322,$319,$323);
       $352 = HEAP32[$328>>2]|0;
       $353 = HEAP32[$120>>2]|0;
       $354 = (($353) + ($352<<2)|0);
       $355 = HEAP32[$354>>2]|0;
       $356 = (_floor1_fit($vb,$355,$323,$322)|0);
       $357 = HEAP32[$325>>2]|0;
       HEAP32[$357>>2] = $356;
       $358 = HEAP32[$328>>2]|0;
       $359 = HEAP32[$120>>2]|0;
       $360 = (($359) + ($358<<2)|0);
       $361 = HEAP32[$360>>2]|0;
       $362 = HEAP32[$325>>2]|0;
       $363 = HEAP32[$362>>2]|0;
       $364 = ((($362)) + 28|0);
       $365 = HEAP32[$364>>2]|0;
       $366 = (_floor1_interpolate_fit($vb,$361,$363,$365,9362)|0);
       $367 = HEAP32[$325>>2]|0;
       $368 = ((($367)) + 4|0);
       HEAP32[$368>>2] = $366;
       $369 = HEAP32[$328>>2]|0;
       $370 = HEAP32[$120>>2]|0;
       $371 = (($370) + ($369<<2)|0);
       $372 = HEAP32[$371>>2]|0;
       $373 = HEAP32[$325>>2]|0;
       $374 = HEAP32[$373>>2]|0;
       $375 = ((($373)) + 28|0);
       $376 = HEAP32[$375>>2]|0;
       $377 = (_floor1_interpolate_fit($vb,$372,$374,$376,18724)|0);
       $378 = HEAP32[$325>>2]|0;
       $379 = ((($378)) + 8|0);
       HEAP32[$379>>2] = $377;
       $380 = HEAP32[$328>>2]|0;
       $381 = HEAP32[$120>>2]|0;
       $382 = (($381) + ($380<<2)|0);
       $383 = HEAP32[$382>>2]|0;
       $384 = HEAP32[$325>>2]|0;
       $385 = HEAP32[$384>>2]|0;
       $386 = ((($384)) + 28|0);
       $387 = HEAP32[$386>>2]|0;
       $388 = (_floor1_interpolate_fit($vb,$383,$385,$387,28086)|0);
       $389 = HEAP32[$325>>2]|0;
       $390 = ((($389)) + 12|0);
       HEAP32[$390>>2] = $388;
       $391 = HEAP32[$328>>2]|0;
       $392 = HEAP32[$120>>2]|0;
       $393 = (($392) + ($391<<2)|0);
       $394 = HEAP32[$393>>2]|0;
       $395 = HEAP32[$325>>2]|0;
       $396 = HEAP32[$395>>2]|0;
       $397 = ((($395)) + 28|0);
       $398 = HEAP32[$397>>2]|0;
       $399 = (_floor1_interpolate_fit($vb,$394,$396,$398,37449)|0);
       $400 = HEAP32[$325>>2]|0;
       $401 = ((($400)) + 16|0);
       HEAP32[$401>>2] = $399;
       $402 = HEAP32[$328>>2]|0;
       $403 = HEAP32[$120>>2]|0;
       $404 = (($403) + ($402<<2)|0);
       $405 = HEAP32[$404>>2]|0;
       $406 = HEAP32[$325>>2]|0;
       $407 = HEAP32[$406>>2]|0;
       $408 = ((($406)) + 28|0);
       $409 = HEAP32[$408>>2]|0;
       $410 = (_floor1_interpolate_fit($vb,$405,$407,$409,46811)|0);
       $411 = HEAP32[$325>>2]|0;
       $412 = ((($411)) + 20|0);
       HEAP32[$412>>2] = $410;
       $413 = HEAP32[$328>>2]|0;
       $414 = HEAP32[$120>>2]|0;
       $415 = (($414) + ($413<<2)|0);
       $416 = HEAP32[$415>>2]|0;
       $417 = HEAP32[$325>>2]|0;
       $418 = HEAP32[$417>>2]|0;
       $419 = ((($417)) + 28|0);
       $420 = HEAP32[$419>>2]|0;
       $421 = (_floor1_interpolate_fit($vb,$416,$418,$420,56173)|0);
       $422 = HEAP32[$325>>2]|0;
       $423 = ((($422)) + 24|0);
       HEAP32[$423>>2] = $421;
       $424 = HEAP32[$328>>2]|0;
       $425 = HEAP32[$120>>2]|0;
       $426 = (($425) + ($424<<2)|0);
       $427 = HEAP32[$426>>2]|0;
       $428 = HEAP32[$325>>2]|0;
       $429 = ((($428)) + 28|0);
       $430 = HEAP32[$429>>2]|0;
       $431 = ((($428)) + 56|0);
       $432 = HEAP32[$431>>2]|0;
       $433 = (_floor1_interpolate_fit($vb,$427,$430,$432,9362)|0);
       $434 = HEAP32[$325>>2]|0;
       $435 = ((($434)) + 32|0);
       HEAP32[$435>>2] = $433;
       $436 = HEAP32[$328>>2]|0;
       $437 = HEAP32[$120>>2]|0;
       $438 = (($437) + ($436<<2)|0);
       $439 = HEAP32[$438>>2]|0;
       $440 = HEAP32[$325>>2]|0;
       $441 = ((($440)) + 28|0);
       $442 = HEAP32[$441>>2]|0;
       $443 = ((($440)) + 56|0);
       $444 = HEAP32[$443>>2]|0;
       $445 = (_floor1_interpolate_fit($vb,$439,$442,$444,18724)|0);
       $446 = HEAP32[$325>>2]|0;
       $447 = ((($446)) + 36|0);
       HEAP32[$447>>2] = $445;
       $448 = HEAP32[$328>>2]|0;
       $449 = HEAP32[$120>>2]|0;
       $450 = (($449) + ($448<<2)|0);
       $451 = HEAP32[$450>>2]|0;
       $452 = HEAP32[$325>>2]|0;
       $453 = ((($452)) + 28|0);
       $454 = HEAP32[$453>>2]|0;
       $455 = ((($452)) + 56|0);
       $456 = HEAP32[$455>>2]|0;
       $457 = (_floor1_interpolate_fit($vb,$451,$454,$456,28086)|0);
       $458 = HEAP32[$325>>2]|0;
       $459 = ((($458)) + 40|0);
       HEAP32[$459>>2] = $457;
       $460 = HEAP32[$328>>2]|0;
       $461 = HEAP32[$120>>2]|0;
       $462 = (($461) + ($460<<2)|0);
       $463 = HEAP32[$462>>2]|0;
       $464 = HEAP32[$325>>2]|0;
       $465 = ((($464)) + 28|0);
       $466 = HEAP32[$465>>2]|0;
       $467 = ((($464)) + 56|0);
       $468 = HEAP32[$467>>2]|0;
       $469 = (_floor1_interpolate_fit($vb,$463,$466,$468,37449)|0);
       $470 = HEAP32[$325>>2]|0;
       $471 = ((($470)) + 44|0);
       HEAP32[$471>>2] = $469;
       $472 = HEAP32[$328>>2]|0;
       $473 = HEAP32[$120>>2]|0;
       $474 = (($473) + ($472<<2)|0);
       $475 = HEAP32[$474>>2]|0;
       $476 = HEAP32[$325>>2]|0;
       $477 = ((($476)) + 28|0);
       $478 = HEAP32[$477>>2]|0;
       $479 = ((($476)) + 56|0);
       $480 = HEAP32[$479>>2]|0;
       $481 = (_floor1_interpolate_fit($vb,$475,$478,$480,46811)|0);
       $482 = HEAP32[$325>>2]|0;
       $483 = ((($482)) + 48|0);
       HEAP32[$483>>2] = $481;
       $484 = HEAP32[$328>>2]|0;
       $485 = HEAP32[$120>>2]|0;
       $486 = (($485) + ($484<<2)|0);
       $487 = HEAP32[$486>>2]|0;
       $488 = HEAP32[$325>>2]|0;
       $489 = ((($488)) + 28|0);
       $490 = HEAP32[$489>>2]|0;
       $491 = ((($488)) + 56|0);
       $492 = HEAP32[$491>>2]|0;
       $493 = (_floor1_interpolate_fit($vb,$487,$490,$492,56173)|0);
       $494 = HEAP32[$325>>2]|0;
       $495 = ((($494)) + 52|0);
       HEAP32[$495>>2] = $493;
      }
     }
     $496 = (($i$129) + 1)|0;
     $497 = HEAP32[$12>>2]|0;
     $498 = ($496|0)<($497|0);
     if ($498) {
      $i$129 = $496;
     } else {
      $$pre$phi55Z2D = $120;$500 = $497;
      break L17;
     }
    }
    STACKTOP = sp;return ($$0|0);
   }
   while(1) {
    $311 = (((($33)) + 4|0) + ($i$129$us<<2)|0);
    $127 = HEAP32[$311>>2]|0;
    $312 = (($16) + ($i$129$us<<2)|0);
    $125 = HEAP32[$312>>2]|0;
    $313 = HEAP32[$vb>>2]|0;
    $314 = (($313) + ($i$129$us<<2)|0);
    $124 = HEAP32[$314>>2]|0;
    $121 = (($124) + ($$pre$phiZ2D<<2)|0);
    HEAP32[$39>>2] = $31;
    $315 = (__vorbis_block_alloc($vb,60)|0);
    $137 = (($22) + ($i$129$us<<2)|0);
    HEAP32[$137>>2] = $315;
    dest=$315; stop=dest+60|0; do { HEAP32[dest>>2]=0|0; dest=dest+4|0; } while ((dest|0) < (stop|0));
    $j$123$us = 0;
    while(1) {
     $299 = (($125) + ($j$123$us<<2)|0);
     $300 = HEAP32[$299>>2]|0;
     $301 = $300 & 2147483647;
     $302 = (+($301>>>0));
     $303 = $302 * 7.1771142984289327E-7;
     $304 = $303 + -764.6162109375;
     $305 = $304;
     $306 = $305 + 0.34499999999999997;
     $307 = $306;
     $$sum1$us = (($j$123$us) + ($$pre$phiZ2D))|0;
     $308 = (($124) + ($$sum1$us<<2)|0);
     HEAPF32[$308>>2] = $307;
     $309 = (($j$123$us) + 1)|0;
     $310 = ($309|0)<($$pre$phiZ2D|0);
     if ($310) {
      $j$123$us = $309;
     } else {
      break;
     }
    }
    __vp_noisemask($38,$121,$115);
    $122 = (($27) + ($i$129$us<<2)|0);
    $123 = +HEAPF32[$122>>2];
    __vp_tonemask($38,$124,$116,$global_ampmax$0$lcssa,$123);
    __vp_offset_and_mix($38,$115,$116,1,$124,$125,$121);
    $126 = (((($33)) + 1028|0) + ($127<<2)|0);
    $128 = HEAP32[$126>>2]|0;
    $129 = (((($5)) + 800|0) + ($128<<2)|0);
    $130 = HEAP32[$129>>2]|0;
    $131 = ($130|0)==(1);
    if (!($131)) {
     $$0 = -1;
     break;
    }
    $132 = HEAP32[$120>>2]|0;
    $133 = (($132) + ($128<<2)|0);
    $134 = HEAP32[$133>>2]|0;
    $135 = (_floor1_fit($vb,$134,$121,$124)|0);
    $136 = HEAP32[$137>>2]|0;
    $138 = ((($136)) + 28|0);
    HEAP32[$138>>2] = $135;
    $139 = (_vorbis_bitrate_managed($vb)|0);
    $140 = ($139|0)==(0);
    if (!($140)) {
     $141 = HEAP32[$137>>2]|0;
     $142 = ((($141)) + 28|0);
     $143 = HEAP32[$142>>2]|0;
     $144 = ($143|0)==(0|0);
     if (!($144)) {
      __vp_offset_and_mix($38,$115,$116,2,$124,$125,$121);
      $145 = HEAP32[$126>>2]|0;
      $146 = HEAP32[$120>>2]|0;
      $147 = (($146) + ($145<<2)|0);
      $148 = HEAP32[$147>>2]|0;
      $149 = (_floor1_fit($vb,$148,$121,$124)|0);
      $150 = HEAP32[$137>>2]|0;
      $151 = ((($150)) + 56|0);
      HEAP32[$151>>2] = $149;
      __vp_offset_and_mix($38,$115,$116,0,$124,$125,$121);
      $152 = HEAP32[$126>>2]|0;
      $153 = HEAP32[$120>>2]|0;
      $154 = (($153) + ($152<<2)|0);
      $155 = HEAP32[$154>>2]|0;
      $156 = (_floor1_fit($vb,$155,$121,$124)|0);
      $157 = HEAP32[$137>>2]|0;
      HEAP32[$157>>2] = $156;
      $158 = HEAP32[$126>>2]|0;
      $159 = HEAP32[$120>>2]|0;
      $160 = (($159) + ($158<<2)|0);
      $161 = HEAP32[$160>>2]|0;
      $162 = HEAP32[$137>>2]|0;
      $163 = HEAP32[$162>>2]|0;
      $164 = ((($162)) + 28|0);
      $165 = HEAP32[$164>>2]|0;
      $166 = (_floor1_interpolate_fit($vb,$161,$163,$165,9362)|0);
      $167 = HEAP32[$137>>2]|0;
      $168 = ((($167)) + 4|0);
      HEAP32[$168>>2] = $166;
      $169 = HEAP32[$126>>2]|0;
      $170 = HEAP32[$120>>2]|0;
      $171 = (($170) + ($169<<2)|0);
      $172 = HEAP32[$171>>2]|0;
      $173 = HEAP32[$137>>2]|0;
      $174 = HEAP32[$173>>2]|0;
      $175 = ((($173)) + 28|0);
      $176 = HEAP32[$175>>2]|0;
      $177 = (_floor1_interpolate_fit($vb,$172,$174,$176,18724)|0);
      $178 = HEAP32[$137>>2]|0;
      $179 = ((($178)) + 8|0);
      HEAP32[$179>>2] = $177;
      $180 = HEAP32[$126>>2]|0;
      $181 = HEAP32[$120>>2]|0;
      $182 = (($181) + ($180<<2)|0);
      $183 = HEAP32[$182>>2]|0;
      $184 = HEAP32[$137>>2]|0;
      $185 = HEAP32[$184>>2]|0;
      $186 = ((($184)) + 28|0);
      $187 = HEAP32[$186>>2]|0;
      $188 = (_floor1_interpolate_fit($vb,$183,$185,$187,28086)|0);
      $189 = HEAP32[$137>>2]|0;
      $190 = ((($189)) + 12|0);
      HEAP32[$190>>2] = $188;
      $191 = HEAP32[$126>>2]|0;
      $192 = HEAP32[$120>>2]|0;
      $193 = (($192) + ($191<<2)|0);
      $194 = HEAP32[$193>>2]|0;
      $195 = HEAP32[$137>>2]|0;
      $196 = HEAP32[$195>>2]|0;
      $197 = ((($195)) + 28|0);
      $198 = HEAP32[$197>>2]|0;
      $199 = (_floor1_interpolate_fit($vb,$194,$196,$198,37449)|0);
      $200 = HEAP32[$137>>2]|0;
      $201 = ((($200)) + 16|0);
      HEAP32[$201>>2] = $199;
      $202 = HEAP32[$126>>2]|0;
      $203 = HEAP32[$120>>2]|0;
      $204 = (($203) + ($202<<2)|0);
      $205 = HEAP32[$204>>2]|0;
      $206 = HEAP32[$137>>2]|0;
      $207 = HEAP32[$206>>2]|0;
      $208 = ((($206)) + 28|0);
      $209 = HEAP32[$208>>2]|0;
      $210 = (_floor1_interpolate_fit($vb,$205,$207,$209,46811)|0);
      $211 = HEAP32[$137>>2]|0;
      $212 = ((($211)) + 20|0);
      HEAP32[$212>>2] = $210;
      $213 = HEAP32[$126>>2]|0;
      $214 = HEAP32[$120>>2]|0;
      $215 = (($214) + ($213<<2)|0);
      $216 = HEAP32[$215>>2]|0;
      $217 = HEAP32[$137>>2]|0;
      $218 = HEAP32[$217>>2]|0;
      $219 = ((($217)) + 28|0);
      $220 = HEAP32[$219>>2]|0;
      $221 = (_floor1_interpolate_fit($vb,$216,$218,$220,56173)|0);
      $222 = HEAP32[$137>>2]|0;
      $223 = ((($222)) + 24|0);
      HEAP32[$223>>2] = $221;
      $224 = HEAP32[$126>>2]|0;
      $225 = HEAP32[$120>>2]|0;
      $226 = (($225) + ($224<<2)|0);
      $227 = HEAP32[$226>>2]|0;
      $228 = HEAP32[$137>>2]|0;
      $229 = ((($228)) + 28|0);
      $230 = HEAP32[$229>>2]|0;
      $231 = ((($228)) + 56|0);
      $232 = HEAP32[$231>>2]|0;
      $233 = (_floor1_interpolate_fit($vb,$227,$230,$232,9362)|0);
      $234 = HEAP32[$137>>2]|0;
      $235 = ((($234)) + 32|0);
      HEAP32[$235>>2] = $233;
      $236 = HEAP32[$126>>2]|0;
      $237 = HEAP32[$120>>2]|0;
      $238 = (($237) + ($236<<2)|0);
      $239 = HEAP32[$238>>2]|0;
      $240 = HEAP32[$137>>2]|0;
      $241 = ((($240)) + 28|0);
      $242 = HEAP32[$241>>2]|0;
      $243 = ((($240)) + 56|0);
      $244 = HEAP32[$243>>2]|0;
      $245 = (_floor1_interpolate_fit($vb,$239,$242,$244,18724)|0);
      $246 = HEAP32[$137>>2]|0;
      $247 = ((($246)) + 36|0);
      HEAP32[$247>>2] = $245;
      $248 = HEAP32[$126>>2]|0;
      $249 = HEAP32[$120>>2]|0;
      $250 = (($249) + ($248<<2)|0);
      $251 = HEAP32[$250>>2]|0;
      $252 = HEAP32[$137>>2]|0;
      $253 = ((($252)) + 28|0);
      $254 = HEAP32[$253>>2]|0;
      $255 = ((($252)) + 56|0);
      $256 = HEAP32[$255>>2]|0;
      $257 = (_floor1_interpolate_fit($vb,$251,$254,$256,28086)|0);
      $258 = HEAP32[$137>>2]|0;
      $259 = ((($258)) + 40|0);
      HEAP32[$259>>2] = $257;
      $260 = HEAP32[$126>>2]|0;
      $261 = HEAP32[$120>>2]|0;
      $262 = (($261) + ($260<<2)|0);
      $263 = HEAP32[$262>>2]|0;
      $264 = HEAP32[$137>>2]|0;
      $265 = ((($264)) + 28|0);
      $266 = HEAP32[$265>>2]|0;
      $267 = ((($264)) + 56|0);
      $268 = HEAP32[$267>>2]|0;
      $269 = (_floor1_interpolate_fit($vb,$263,$266,$268,37449)|0);
      $270 = HEAP32[$137>>2]|0;
      $271 = ((($270)) + 44|0);
      HEAP32[$271>>2] = $269;
      $272 = HEAP32[$126>>2]|0;
      $273 = HEAP32[$120>>2]|0;
      $274 = (($273) + ($272<<2)|0);
      $275 = HEAP32[$274>>2]|0;
      $276 = HEAP32[$137>>2]|0;
      $277 = ((($276)) + 28|0);
      $278 = HEAP32[$277>>2]|0;
      $279 = ((($276)) + 56|0);
      $280 = HEAP32[$279>>2]|0;
      $281 = (_floor1_interpolate_fit($vb,$275,$278,$280,46811)|0);
      $282 = HEAP32[$137>>2]|0;
      $283 = ((($282)) + 48|0);
      HEAP32[$283>>2] = $281;
      $284 = HEAP32[$126>>2]|0;
      $285 = HEAP32[$120>>2]|0;
      $286 = (($285) + ($284<<2)|0);
      $287 = HEAP32[$286>>2]|0;
      $288 = HEAP32[$137>>2]|0;
      $289 = ((($288)) + 28|0);
      $290 = HEAP32[$289>>2]|0;
      $291 = ((($288)) + 56|0);
      $292 = HEAP32[$291>>2]|0;
      $293 = (_floor1_interpolate_fit($vb,$287,$290,$292,56173)|0);
      $294 = HEAP32[$137>>2]|0;
      $295 = ((($294)) + 52|0);
      HEAP32[$295>>2] = $293;
     }
    }
    $296 = (($i$129$us) + 1)|0;
    $297 = HEAP32[$12>>2]|0;
    $298 = ($296|0)<($297|0);
    if ($298) {
     $i$129$us = $296;
    } else {
     $$pre$phi55Z2D = $120;$500 = $297;
     break L17;
    }
   }
   STACKTOP = sp;return ($$0|0);
  } else {
   $$pre54 = ((($7)) + 48|0);
   $$pre$phi55Z2D = $$pre54;$500 = $117;
  }
 } while(0);
 HEAPF32[$23>>2] = $global_ampmax$0$lcssa;
 $499 = $500 << 2;
 $$alloca_mul3 = $499;
 $501 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul3)|0)+15)&-16)|0;;
 $$alloca_mul5 = $499;
 $502 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul5)|0)+15)&-16)|0;;
 $503 = (_vorbis_bitrate_managed($vb)|0);
 $504 = ($503|0)!=(0);
 $505 = $504 ? 0 : 7;
 $506 = ((($7)) + 44|0);
 $507 = ((($vb)) + 24|0);
 $508 = ((($vb)) + 32|0);
 $509 = ((($5)) + 2868|0);
 $510 = ((($7)) + 52|0);
 $k$222 = $505;
 while(1) {
  $511 = (((($9)) + 12|0) + ($k$222<<2)|0);
  $512 = HEAP32[$511>>2]|0;
  _oggpack_write($512,0,1);
  $513 = HEAP32[$506>>2]|0;
  _oggpack_write($512,$31,$513);
  $514 = HEAP32[$30>>2]|0;
  $515 = ($514|0)==(0);
  if (!($515)) {
   $516 = HEAP32[$507>>2]|0;
   _oggpack_write($512,$516,1);
   $517 = HEAP32[$508>>2]|0;
   _oggpack_write($512,$517,1);
  }
  $518 = HEAP32[$12>>2]|0;
  $519 = ($518|0)>(0);
  if ($519) {
   $i$25 = 0;
   while(1) {
    $520 = (((($33)) + 4|0) + ($i$25<<2)|0);
    $521 = HEAP32[$520>>2]|0;
    $522 = (($19) + ($i$25<<2)|0);
    $523 = HEAP32[$522>>2]|0;
    $524 = (((($33)) + 1028|0) + ($521<<2)|0);
    $525 = HEAP32[$524>>2]|0;
    $526 = HEAP32[$$pre$phi55Z2D>>2]|0;
    $527 = (($526) + ($525<<2)|0);
    $528 = HEAP32[$527>>2]|0;
    $529 = (($22) + ($i$25<<2)|0);
    $530 = HEAP32[$529>>2]|0;
    $531 = (($530) + ($k$222<<2)|0);
    $532 = HEAP32[$531>>2]|0;
    $533 = (_floor1_encode($512,$vb,$528,$532,$523)|0);
    $534 = (($15) + ($i$25<<2)|0);
    HEAP32[$534>>2] = $533;
    $535 = (($i$25) + 1)|0;
    $536 = HEAP32[$12>>2]|0;
    $537 = ($535|0)<($536|0);
    if ($537) {
     $i$25 = $535;
    } else {
     $$lcssa = $536;
     break;
    }
   }
  } else {
   $$lcssa = $518;
  }
  $538 = HEAP32[$30>>2]|0;
  $539 = ((((($5)) + 3240|0) + (($538*60)|0)|0) + ($k$222<<2)|0);
  $540 = HEAP32[$539>>2]|0;
  __vp_couple_quantize_normalize($k$222,$509,$38,$33,$16,$19,$15,$540,$$lcssa);
  $541 = HEAP32[$33>>2]|0;
  $542 = ($541|0)>(0);
  if ($542) {
   $i$318 = 0;
   while(1) {
    $543 = (((($33)) + 1092|0) + ($i$318<<2)|0);
    $544 = HEAP32[$543>>2]|0;
    $545 = HEAP32[$12>>2]|0;
    $546 = ($545|0)>(0);
    if ($546) {
     $598 = $545;$ch_in_bundle$07 = 0;$j$26 = 0;
     while(1) {
      $547 = (((($33)) + 4|0) + ($j$26<<2)|0);
      $548 = HEAP32[$547>>2]|0;
      $549 = ($548|0)==($i$318|0);
      if ($549) {
       $550 = (($502) + ($ch_in_bundle$07<<2)|0);
       $551 = (($15) + ($j$26<<2)|0);
       $552 = HEAP32[$551>>2]|0;
       $not$ = ($552|0)!=(0);
       $$ = $not$&1;
       HEAP32[$550>>2] = $$;
       $553 = (($19) + ($j$26<<2)|0);
       $554 = HEAP32[$553>>2]|0;
       $555 = (($ch_in_bundle$07) + 1)|0;
       $556 = (($501) + ($ch_in_bundle$07<<2)|0);
       HEAP32[$556>>2] = $554;
       $$pre = HEAP32[$12>>2]|0;
       $559 = $$pre;$ch_in_bundle$1 = $555;
      } else {
       $559 = $598;$ch_in_bundle$1 = $ch_in_bundle$07;
      }
      $557 = (($j$26) + 1)|0;
      $558 = ($557|0)<($559|0);
      if ($558) {
       $598 = $559;$ch_in_bundle$07 = $ch_in_bundle$1;$j$26 = $557;
      } else {
       $ch_in_bundle$0$lcssa = $ch_in_bundle$1;
       break;
      }
     }
    } else {
     $ch_in_bundle$0$lcssa = 0;
    }
    $560 = (((($5)) + 1312|0) + ($544<<2)|0);
    $561 = HEAP32[$560>>2]|0;
    $562 = (25648 + ($561<<2)|0);
    $563 = HEAP32[$562>>2]|0;
    $564 = ((($563)) + 20|0);
    $565 = HEAP32[$564>>2]|0;
    $566 = HEAP32[$510>>2]|0;
    $567 = (($566) + ($544<<2)|0);
    $568 = HEAP32[$567>>2]|0;
    $569 = (FUNCTION_TABLE_iiiiii[$565 & 7]($vb,$568,$501,$502,$ch_in_bundle$0$lcssa)|0);
    $570 = HEAP32[$12>>2]|0;
    $571 = ($570|0)>(0);
    if ($571) {
     $ch_in_bundle$213 = 0;$j$312 = 0;
     while(1) {
      $572 = (((($33)) + 4|0) + ($j$312<<2)|0);
      $573 = HEAP32[$572>>2]|0;
      $574 = ($573|0)==($i$318|0);
      if ($574) {
       $575 = (($19) + ($j$312<<2)|0);
       $576 = HEAP32[$575>>2]|0;
       $577 = (($ch_in_bundle$213) + 1)|0;
       $578 = (($501) + ($ch_in_bundle$213<<2)|0);
       HEAP32[$578>>2] = $576;
       $ch_in_bundle$3 = $577;
      } else {
       $ch_in_bundle$3 = $ch_in_bundle$213;
      }
      $579 = (($j$312) + 1)|0;
      $580 = ($579|0)<($570|0);
      if ($580) {
       $ch_in_bundle$213 = $ch_in_bundle$3;$j$312 = $579;
      } else {
       $ch_in_bundle$2$lcssa = $ch_in_bundle$3;
       break;
      }
     }
    } else {
     $ch_in_bundle$2$lcssa = 0;
    }
    $581 = HEAP32[$560>>2]|0;
    $582 = (25648 + ($581<<2)|0);
    $583 = HEAP32[$582>>2]|0;
    $584 = ((($583)) + 24|0);
    $585 = HEAP32[$584>>2]|0;
    $586 = HEAP32[$510>>2]|0;
    $587 = (($586) + ($544<<2)|0);
    $588 = HEAP32[$587>>2]|0;
    (FUNCTION_TABLE_iiiiiiiii[$585 & 3]($512,$vb,$588,$501,$502,$ch_in_bundle$2$lcssa,$569,$i$318)|0);
    $589 = (($i$318) + 1)|0;
    $590 = HEAP32[$33>>2]|0;
    $591 = ($589|0)<($590|0);
    if ($591) {
     $i$318 = $589;
    } else {
     break;
    }
   }
  }
  $592 = (($k$222) + 1)|0;
  $593 = (_vorbis_bitrate_managed($vb)|0);
  $594 = ($593|0)!=(0);
  $595 = $594 ? 14 : 7;
  $596 = ($k$222|0)<($595|0);
  if ($596) {
   $k$222 = $592;
  } else {
   $$0 = 0;
   break;
  }
 }
 STACKTOP = sp;return ($$0|0);
}
function _mapping0_inverse($vb,$l) {
 $vb = $vb|0;
 $l = $l|0;
 var $$ = 0, $$2 = 0, $$alloca_mul = 0, $$alloca_mul1 = 0, $$alloca_mul3 = 0, $$alloca_mul5 = 0, $$lcssa = 0, $$pre31 = 0, $$pre32 = 0, $$pre33 = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0;
 var $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0.0;
 var $125 = 0, $126 = 0.0, $127 = 0, $128 = 0, $129 = 0.0, $13 = 0, $130 = 0.0, $131 = 0.0, $132 = 0.0, $133 = 0, $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0;
 var $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0;
 var $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0;
 var $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0;
 var $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0;
 var $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $ch_in_bundle$0$lcssa = 0;
 var $ch_in_bundle$018 = 0, $ch_in_bundle$1 = 0, $i$027 = 0, $i$124 = 0, $i$222 = 0, $i$315 = 0, $i$315$in = 0, $i$49 = 0, $i$58 = 0, $j$019 = 0, $j$111 = 0, $not$ = 0, $not$3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($vb)) + 64|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 4|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ((($3)) + 28|0);
 $5 = HEAP32[$4>>2]|0;
 $6 = ((($1)) + 104|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = ((($vb)) + 28|0);
 $9 = HEAP32[$8>>2]|0;
 $10 = (($5) + ($9<<2)|0);
 $11 = HEAP32[$10>>2]|0;
 $12 = ((($vb)) + 36|0);
 HEAP32[$12>>2] = $11;
 $13 = ((($3)) + 4|0);
 $14 = HEAP32[$13>>2]|0;
 $15 = $14 << 2;
 $$alloca_mul = $15;
 $16 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul)|0)+15)&-16)|0;;
 $$alloca_mul1 = $15;
 $17 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul1)|0)+15)&-16)|0;;
 $$alloca_mul3 = $15;
 $18 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul3)|0)+15)&-16)|0;;
 $$alloca_mul5 = $15;
 $19 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul5)|0)+15)&-16)|0;;
 $20 = HEAP32[$13>>2]|0;
 $21 = ($20|0)>(0);
 if ($21) {
  $22 = ((($l)) + 4|0);
  $23 = ((($l)) + 1028|0);
  $24 = ((($7)) + 48|0);
  $25 = $11 << 1;
  $26 = $25 & 2147483646;
  $i$027 = 0;
  while(1) {
   $32 = (($22) + ($i$027<<2)|0);
   $33 = HEAP32[$32>>2]|0;
   $34 = (($23) + ($33<<2)|0);
   $35 = HEAP32[$34>>2]|0;
   $36 = (((($5)) + 800|0) + ($35<<2)|0);
   $37 = HEAP32[$36>>2]|0;
   $38 = (25640 + ($37<<2)|0);
   $39 = HEAP32[$38>>2]|0;
   $40 = ((($39)) + 20|0);
   $41 = HEAP32[$40>>2]|0;
   $42 = HEAP32[$24>>2]|0;
   $43 = (($42) + ($35<<2)|0);
   $44 = HEAP32[$43>>2]|0;
   $45 = (FUNCTION_TABLE_iii[$41 & 15]($vb,$44)|0);
   $46 = (($19) + ($i$027<<2)|0);
   HEAP32[$46>>2] = $45;
   $47 = (($18) + ($i$027<<2)|0);
   $not$3 = ($45|0)!=(0|0);
   $$ = $not$3&1;
   HEAP32[$47>>2] = $$;
   $48 = HEAP32[$vb>>2]|0;
   $49 = (($48) + ($i$027<<2)|0);
   $50 = HEAP32[$49>>2]|0;
   _memset(($50|0),0,($26|0))|0;
   $51 = (($i$027) + 1)|0;
   $52 = HEAP32[$13>>2]|0;
   $53 = ($51|0)<($52|0);
   if ($53) {
    $i$027 = $51;
   } else {
    $167 = $52;
    break;
   }
  }
 } else {
  $167 = $20;
 }
 $27 = ((($l)) + 1156|0);
 $28 = HEAP32[$27>>2]|0;
 $29 = ($28|0)>(0);
 if ($29) {
  $30 = ((($l)) + 1160|0);
  $31 = ((($l)) + 2184|0);
  $i$124 = 0;
  while(1) {
   $59 = (($30) + ($i$124<<2)|0);
   $60 = HEAP32[$59>>2]|0;
   $61 = (($18) + ($60<<2)|0);
   $62 = HEAP32[$61>>2]|0;
   $63 = ($62|0)==(0);
   $64 = (($31) + ($i$124<<2)|0);
   $65 = HEAP32[$64>>2]|0;
   if ($63) {
    $66 = (($18) + ($65<<2)|0);
    $67 = HEAP32[$66>>2]|0;
    $68 = ($67|0)==(0);
    if (!($68)) {
     label = 10;
    }
   } else {
    label = 10;
   }
   if ((label|0) == 10) {
    label = 0;
    HEAP32[$61>>2] = 1;
    $69 = (($18) + ($65<<2)|0);
    HEAP32[$69>>2] = 1;
   }
   $70 = (($i$124) + 1)|0;
   $71 = ($70|0)<($28|0);
   if ($71) {
    $i$124 = $70;
   } else {
    break;
   }
  }
 }
 $54 = HEAP32[$l>>2]|0;
 $55 = ($54|0)>(0);
 if ($55) {
  $56 = ((($l)) + 1092|0);
  $57 = ((($7)) + 52|0);
  $58 = ((($l)) + 4|0);
  $72 = $167;$i$222 = 0;
  while(1) {
   $73 = ($72|0)>(0);
   if ($73) {
    $168 = $72;$ch_in_bundle$018 = 0;$j$019 = 0;
    while(1) {
     $74 = (($58) + ($j$019<<2)|0);
     $75 = HEAP32[$74>>2]|0;
     $76 = ($75|0)==($i$222|0);
     if ($76) {
      $77 = (($18) + ($j$019<<2)|0);
      $78 = HEAP32[$77>>2]|0;
      $79 = (($17) + ($ch_in_bundle$018<<2)|0);
      $not$ = ($78|0)!=(0);
      $$2 = $not$&1;
      HEAP32[$79>>2] = $$2;
      $80 = HEAP32[$vb>>2]|0;
      $81 = (($80) + ($j$019<<2)|0);
      $82 = HEAP32[$81>>2]|0;
      $83 = (($ch_in_bundle$018) + 1)|0;
      $84 = (($16) + ($ch_in_bundle$018<<2)|0);
      HEAP32[$84>>2] = $82;
      $$pre32 = HEAP32[$13>>2]|0;
      $87 = $$pre32;$ch_in_bundle$1 = $83;
     } else {
      $87 = $168;$ch_in_bundle$1 = $ch_in_bundle$018;
     }
     $85 = (($j$019) + 1)|0;
     $86 = ($85|0)<($87|0);
     if ($86) {
      $168 = $87;$ch_in_bundle$018 = $ch_in_bundle$1;$j$019 = $85;
     } else {
      $ch_in_bundle$0$lcssa = $ch_in_bundle$1;
      break;
     }
    }
   } else {
    $ch_in_bundle$0$lcssa = 0;
   }
   $88 = (($56) + ($i$222<<2)|0);
   $89 = HEAP32[$88>>2]|0;
   $90 = (((($5)) + 1312|0) + ($89<<2)|0);
   $91 = HEAP32[$90>>2]|0;
   $92 = (25648 + ($91<<2)|0);
   $93 = HEAP32[$92>>2]|0;
   $94 = ((($93)) + 28|0);
   $95 = HEAP32[$94>>2]|0;
   $96 = HEAP32[$57>>2]|0;
   $97 = (($96) + ($89<<2)|0);
   $98 = HEAP32[$97>>2]|0;
   (FUNCTION_TABLE_iiiiii[$95 & 7]($vb,$98,$16,$17,$ch_in_bundle$0$lcssa)|0);
   $99 = (($i$222) + 1)|0;
   $100 = HEAP32[$l>>2]|0;
   $101 = ($99|0)<($100|0);
   if (!($101)) {
    break;
   }
   $$pre31 = HEAP32[$13>>2]|0;
   $72 = $$pre31;$i$222 = $99;
  }
  $$pre33 = HEAP32[$27>>2]|0;
  $102 = $$pre33;
 } else {
  $102 = $28;
 }
 $103 = ($102|0)>(0);
 if ($103) {
  $104 = ((($l)) + 1160|0);
  $105 = HEAP32[$vb>>2]|0;
  $106 = ((($l)) + 2184|0);
  $107 = (($11|0) / 2)&-1;
  $108 = ($11|0)>(1);
  $i$315$in = $102;
  while(1) {
   $i$315 = (($i$315$in) + -1)|0;
   $115 = (($104) + ($i$315<<2)|0);
   $116 = HEAP32[$115>>2]|0;
   $117 = (($105) + ($116<<2)|0);
   $118 = HEAP32[$117>>2]|0;
   $119 = (($106) + ($i$315<<2)|0);
   $120 = HEAP32[$119>>2]|0;
   $121 = (($105) + ($120<<2)|0);
   $122 = HEAP32[$121>>2]|0;
   if ($108) {
    $j$111 = 0;
    while(1) {
     $123 = (($118) + ($j$111<<2)|0);
     $124 = +HEAPF32[$123>>2];
     $125 = (($122) + ($j$111<<2)|0);
     $126 = +HEAPF32[$125>>2];
     $127 = $124 > 0.0;
     $128 = $126 > 0.0;
     do {
      if ($127) {
       if ($128) {
        HEAPF32[$123>>2] = $124;
        $129 = $124 - $126;
        HEAPF32[$125>>2] = $129;
        break;
       } else {
        HEAPF32[$125>>2] = $124;
        $130 = $126 + $124;
        HEAPF32[$123>>2] = $130;
        break;
       }
      } else {
       if ($128) {
        HEAPF32[$123>>2] = $124;
        $131 = $126 + $124;
        HEAPF32[$125>>2] = $131;
        break;
       } else {
        HEAPF32[$125>>2] = $124;
        $132 = $124 - $126;
        HEAPF32[$123>>2] = $132;
        break;
       }
      }
     } while(0);
     $133 = (($j$111) + 1)|0;
     $134 = ($133|0)<($107|0);
     if ($134) {
      $j$111 = $133;
     } else {
      break;
     }
    }
   }
   $109 = ($i$315$in|0)>(1);
   if ($109) {
    $i$315$in = $i$315;
   } else {
    break;
   }
  }
 }
 $110 = HEAP32[$13>>2]|0;
 $111 = ($110|0)>(0);
 if (!($111)) {
  STACKTOP = sp;return 0;
 }
 $112 = ((($l)) + 4|0);
 $113 = ((($l)) + 1028|0);
 $114 = ((($7)) + 48|0);
 $i$49 = 0;
 while(1) {
  $136 = HEAP32[$vb>>2]|0;
  $137 = (($136) + ($i$49<<2)|0);
  $138 = HEAP32[$137>>2]|0;
  $139 = (($112) + ($i$49<<2)|0);
  $140 = HEAP32[$139>>2]|0;
  $141 = (($113) + ($140<<2)|0);
  $142 = HEAP32[$141>>2]|0;
  $143 = (((($5)) + 800|0) + ($142<<2)|0);
  $144 = HEAP32[$143>>2]|0;
  $145 = (25640 + ($144<<2)|0);
  $146 = HEAP32[$145>>2]|0;
  $147 = ((($146)) + 24|0);
  $148 = HEAP32[$147>>2]|0;
  $149 = HEAP32[$114>>2]|0;
  $150 = (($149) + ($142<<2)|0);
  $151 = HEAP32[$150>>2]|0;
  $152 = (($19) + ($i$49<<2)|0);
  $153 = HEAP32[$152>>2]|0;
  (FUNCTION_TABLE_iiiii[$148 & 3]($vb,$151,$153,$138)|0);
  $154 = (($i$49) + 1)|0;
  $155 = HEAP32[$13>>2]|0;
  $156 = ($154|0)<($155|0);
  if ($156) {
   $i$49 = $154;
  } else {
   $$lcssa = $155;
   break;
  }
 }
 $135 = ($$lcssa|0)>(0);
 if (!($135)) {
  STACKTOP = sp;return 0;
 }
 $i$58 = 0;
 while(1) {
  $157 = HEAP32[$vb>>2]|0;
  $158 = (($157) + ($i$58<<2)|0);
  $159 = HEAP32[$158>>2]|0;
  $160 = HEAP32[$8>>2]|0;
  $161 = (((($7)) + 12|0) + ($160<<2)|0);
  $162 = HEAP32[$161>>2]|0;
  $163 = HEAP32[$162>>2]|0;
  _mdct_backward($163,$159,$159);
  $164 = (($i$58) + 1)|0;
  $165 = HEAP32[$13>>2]|0;
  $166 = ($164|0)<($165|0);
  if ($166) {
   $i$58 = $164;
  } else {
   break;
  }
 }
 STACKTOP = sp;return 0;
}
function _mdct_init($lookup,$n) {
 $lookup = $lookup|0;
 $n = $n|0;
 var $0 = 0, $1 = 0, $10 = 0.0, $11 = 0.0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0.0, $18 = 0.0, $19 = 0, $2 = 0, $20 = 0.0, $21 = 0.0, $22 = 0, $23 = 0, $24 = 0.0, $25 = 0.0, $26 = 0;
 var $27 = 0.0, $28 = 0.0, $29 = 0.0, $3 = 0, $30 = 0.0, $31 = 0, $32 = 0, $33 = 0.0, $34 = 0.0, $35 = 0.0, $36 = 0, $37 = 0, $38 = 0.0, $39 = 0.0, $4 = 0, $40 = 0.0, $41 = 0.0, $42 = 0, $43 = 0, $44 = 0.0;
 var $45 = 0.0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0.0, $53 = 0.0, $54 = 0.0, $55 = 0.0, $56 = 0.0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0.0, $61 = 0.0, $62 = 0.0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0.0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0.0, $80 = 0;
 var $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0.0, $9 = 0.0, $90 = 0, $acc$03 = 0, $acc$1 = 0, $acc$1$lcssa = 0, $i$07 = 0, $i$15 = 0, $i1$04 = 0, $j$02 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = (($n|0) / 4)&-1;
 $1 = $0 << 2;
 $2 = (_malloc($1)|0);
 $3 = (($0) + ($n))|0;
 $4 = $3 << 2;
 $5 = (_malloc($4)|0);
 $6 = $n >> 1;
 $7 = (+($n|0));
 $8 = $7;
 $9 = (+Math_log((+$8)));
 $10 = $9 * 1.4426950408889634;
 $11 = (+_rint($10));
 $12 = (~~(($11)));
 $13 = ((($lookup)) + 4|0);
 HEAP32[$13>>2] = $12;
 HEAP32[$lookup>>2] = $n;
 $14 = ((($lookup)) + 8|0);
 HEAP32[$14>>2] = $5;
 $15 = ((($lookup)) + 12|0);
 HEAP32[$15>>2] = $2;
 $16 = ($n|0)>(3);
 if (!($16)) {
  $89 = 4.0 / $7;
  $90 = ((($lookup)) + 16|0);
  HEAPF32[$90>>2] = $89;
  return;
 }
 $17 = (+($n|0));
 $18 = 3.1415926535897931 / $17;
 $19 = $n << 1;
 $20 = (+($19|0));
 $21 = 3.1415926535897931 / $20;
 $i$07 = 0;
 while(1) {
  $26 = $i$07 << 2;
  $27 = (+($26|0));
  $28 = $18 * $27;
  $29 = (+Math_cos((+$28)));
  $30 = $29;
  $31 = $i$07 << 1;
  $32 = (($5) + ($31<<2)|0);
  HEAPF32[$32>>2] = $30;
  $33 = (+Math_sin((+$28)));
  $34 = $33;
  $35 = -$34;
  $36 = $31 | 1;
  $37 = (($5) + ($36<<2)|0);
  HEAPF32[$37>>2] = $35;
  $38 = (+($36|0));
  $39 = $21 * $38;
  $40 = (+Math_cos((+$39)));
  $41 = $40;
  $42 = (($31) + ($6))|0;
  $43 = (($5) + ($42<<2)|0);
  HEAPF32[$43>>2] = $41;
  $44 = (+Math_sin((+$39)));
  $45 = $44;
  $46 = (($42) + 1)|0;
  $47 = (($5) + ($46<<2)|0);
  HEAPF32[$47>>2] = $45;
  $48 = (($i$07) + 1)|0;
  $49 = ($48|0)<($0|0);
  if ($49) {
   $i$07 = $48;
  } else {
   break;
  }
 }
 $22 = (($n|0) / 8)&-1;
 $23 = ($n|0)>(7);
 if (!($23)) {
  $89 = 4.0 / $7;
  $90 = ((($lookup)) + 16|0);
  HEAPF32[$90>>2] = $89;
  return;
 }
 $24 = (+($n|0));
 $25 = 3.1415926535897931 / $24;
 $i$15 = 0;
 while(1) {
  $50 = $i$15 << 2;
  $51 = $50 | 2;
  $52 = (+($51|0));
  $53 = $25 * $52;
  $54 = (+Math_cos((+$53)));
  $55 = $54 * 0.5;
  $56 = $55;
  $57 = $i$15 << 1;
  $58 = (($57) + ($n))|0;
  $59 = (($5) + ($58<<2)|0);
  HEAPF32[$59>>2] = $56;
  $60 = (+Math_sin((+$53)));
  $61 = $60 * -0.5;
  $62 = $61;
  $63 = (($58) + 1)|0;
  $64 = (($5) + ($63<<2)|0);
  HEAPF32[$64>>2] = $62;
  $65 = (($i$15) + 1)|0;
  $66 = ($65|0)<($22|0);
  if ($66) {
   $i$15 = $65;
  } else {
   break;
  }
 }
 $67 = (($12) + -1)|0;
 $68 = 1 << $67;
 $69 = (($68) + -1)|0;
 $70 = (($12) + -2)|0;
 $71 = 1 << $70;
 if ($23) {
  $i1$04 = 0;
 } else {
  $89 = 4.0 / $7;
  $90 = ((($lookup)) + 16|0);
  HEAPF32[$90>>2] = $89;
  return;
 }
 while(1) {
  $73 = $71;$acc$03 = 0;$j$02 = 0;
  while(1) {
   $72 = $73 & $i1$04;
   $74 = ($72|0)==(0);
   $75 = 1 << $j$02;
   $76 = $74 ? 0 : $75;
   $acc$1 = $76 | $acc$03;
   $77 = (($j$02) + 1)|0;
   $78 = $71 >> $77;
   $79 = ($78|0)==(0);
   if ($79) {
    $acc$1$lcssa = $acc$1;
    break;
   } else {
    $73 = $78;$acc$03 = $acc$1;$j$02 = $77;
   }
  }
  $80 = $acc$1$lcssa ^ -1;
  $81 = $69 & $80;
  $82 = (($81) + -1)|0;
  $83 = $i1$04 << 1;
  $84 = (($2) + ($83<<2)|0);
  HEAP32[$84>>2] = $82;
  $85 = $83 | 1;
  $86 = (($2) + ($85<<2)|0);
  HEAP32[$86>>2] = $acc$1$lcssa;
  $87 = (($i1$04) + 1)|0;
  $88 = ($87|0)<($22|0);
  if ($88) {
   $i1$04 = $87;
  } else {
   break;
  }
 }
 $89 = 4.0 / $7;
 $90 = ((($lookup)) + 16|0);
 HEAPF32[$90>>2] = $89;
 return;
}
function _mdct_clear($l) {
 $l = $l|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ($l|0)==(0|0);
 if ($0) {
  return;
 }
 $1 = ((($l)) + 8|0);
 $2 = HEAP32[$1>>2]|0;
 $3 = ($2|0)==(0|0);
 if (!($3)) {
  _free($2);
 }
 $4 = ((($l)) + 12|0);
 $5 = HEAP32[$4>>2]|0;
 $6 = ($5|0)==(0|0);
 if (!($6)) {
  _free($5);
 }
 ;HEAP32[$l>>2]=0|0;HEAP32[$l+4>>2]=0|0;HEAP32[$l+8>>2]=0|0;HEAP32[$l+12>>2]=0|0;HEAP32[$l+16>>2]=0|0;
 return;
}
function _mdct_backward($init,$in,$out) {
 $init = $init|0;
 $in = $in|0;
 $out = $out|0;
 var $$sum = 0, $$sum1 = 0, $$sum2 = 0, $0 = 0, $1 = 0, $10 = 0.0, $100 = 0.0, $101 = 0, $102 = 0.0, $103 = 0.0, $104 = 0.0, $105 = 0.0, $106 = 0, $107 = 0.0, $108 = 0.0, $109 = 0.0, $11 = 0, $110 = 0.0, $111 = 0.0, $112 = 0.0;
 var $113 = 0.0, $114 = 0.0, $115 = 0, $116 = 0.0, $117 = 0, $118 = 0.0, $119 = 0.0, $12 = 0.0, $120 = 0, $121 = 0.0, $122 = 0, $123 = 0.0, $124 = 0.0, $125 = 0.0, $126 = 0, $127 = 0.0, $128 = 0.0, $129 = 0.0, $13 = 0.0, $130 = 0.0;
 var $131 = 0.0, $132 = 0.0, $133 = 0.0, $134 = 0.0, $135 = 0, $136 = 0, $137 = 0.0, $138 = 0, $139 = 0.0, $14 = 0.0, $140 = 0.0, $141 = 0, $142 = 0.0, $143 = 0, $144 = 0.0, $145 = 0.0, $146 = 0.0, $147 = 0, $148 = 0.0, $149 = 0.0;
 var $15 = 0.0, $150 = 0.0, $151 = 0.0, $152 = 0.0, $153 = 0.0, $154 = 0.0, $155 = 0.0, $156 = 0, $157 = 0, $158 = 0.0, $159 = 0, $16 = 0, $160 = 0.0, $161 = 0.0, $162 = 0, $163 = 0.0, $164 = 0, $165 = 0.0, $166 = 0.0, $167 = 0.0;
 var $168 = 0.0, $169 = 0.0, $17 = 0.0, $170 = 0.0, $171 = 0.0, $172 = 0.0, $173 = 0.0, $174 = 0.0, $175 = 0.0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0.0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0.0;
 var $186 = 0, $187 = 0.0, $188 = 0, $189 = 0.0, $19 = 0.0, $190 = 0, $191 = 0.0, $192 = 0, $193 = 0, $194 = 0.0, $195 = 0, $196 = 0.0, $197 = 0, $198 = 0.0, $199 = 0.0, $2 = 0, $20 = 0.0, $200 = 0, $201 = 0, $202 = 0;
 var $203 = 0, $204 = 0, $205 = 0, $206 = 0, $207 = 0, $208 = 0, $209 = 0, $21 = 0.0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $22 = 0.0, $23 = 0.0, $24 = 0.0, $25 = 0.0, $26 = 0.0, $27 = 0;
 var $28 = 0, $29 = 0.0, $3 = 0, $30 = 0, $31 = 0.0, $32 = 0.0, $33 = 0.0, $34 = 0, $35 = 0.0, $36 = 0.0, $37 = 0.0, $38 = 0.0, $39 = 0, $4 = 0, $40 = 0.0, $41 = 0.0, $42 = 0.0, $43 = 0.0, $44 = 0.0, $45 = 0.0;
 var $46 = 0.0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0.0, $56 = 0, $57 = 0.0, $58 = 0.0, $59 = 0, $6 = 0, $60 = 0.0, $61 = 0, $62 = 0.0, $63 = 0.0;
 var $64 = 0.0, $65 = 0.0, $66 = 0.0, $67 = 0.0, $68 = 0.0, $69 = 0.0, $7 = 0, $70 = 0.0, $71 = 0.0, $72 = 0, $73 = 0.0, $74 = 0, $75 = 0.0, $76 = 0.0, $77 = 0, $78 = 0.0, $79 = 0.0, $8 = 0, $80 = 0.0, $81 = 0.0;
 var $82 = 0, $83 = 0.0, $84 = 0.0, $85 = 0.0, $86 = 0.0, $87 = 0.0, $88 = 0.0, $89 = 0.0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0.0, $98 = 0, $99 = 0.0, $T$0 = 0;
 var $T$1 = 0, $T$2 = 0, $iX$0 = 0, $iX$1 = 0, $iX1$0 = 0, $iX1$1 = 0, $iX1$2 = 0, $init$idx = 0, $init$idx$val = 0, $init$idx4$val = 0, $init$idx5$val = 0, $init$idx6 = 0, $init$idx6$val = 0, $oX$0 = 0, $oX$1 = 0, $oX1$0 = 0, $oX1$1 = 0, $oX1$2 = 0, $oX2$0 = 0, $oX2$1 = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 $0 = HEAP32[$init>>2]|0;
 $1 = $0 >> 1;
 $2 = $0 >> 2;
 $$sum = (($1) + -7)|0;
 $3 = (($in) + ($$sum<<2)|0);
 $$sum1 = (($1) + ($2))|0;
 $4 = (($out) + ($$sum1<<2)|0);
 $5 = ((($init)) + 8|0);
 $6 = HEAP32[$5>>2]|0;
 $7 = (($6) + ($2<<2)|0);
 $T$0 = $7;$iX$0 = $3;$oX$0 = $4;
 while(1) {
  $8 = ((($oX$0)) + -16|0);
  $9 = ((($iX$0)) + 8|0);
  $10 = +HEAPF32[$9>>2];
  $11 = ((($T$0)) + 12|0);
  $12 = +HEAPF32[$11>>2];
  $13 = $10 * $12;
  $14 = -$13;
  $15 = +HEAPF32[$iX$0>>2];
  $16 = ((($T$0)) + 8|0);
  $17 = +HEAPF32[$16>>2];
  $18 = $17 * $15;
  $19 = $14 - $18;
  HEAPF32[$8>>2] = $19;
  $20 = +HEAPF32[$iX$0>>2];
  $21 = +HEAPF32[$11>>2];
  $22 = $21 * $20;
  $23 = +HEAPF32[$9>>2];
  $24 = +HEAPF32[$16>>2];
  $25 = $24 * $23;
  $26 = $22 - $25;
  $27 = ((($oX$0)) + -12|0);
  HEAPF32[$27>>2] = $26;
  $28 = ((($iX$0)) + 24|0);
  $29 = +HEAPF32[$28>>2];
  $30 = ((($T$0)) + 4|0);
  $31 = +HEAPF32[$30>>2];
  $32 = $29 * $31;
  $33 = -$32;
  $34 = ((($iX$0)) + 16|0);
  $35 = +HEAPF32[$34>>2];
  $36 = +HEAPF32[$T$0>>2];
  $37 = $36 * $35;
  $38 = $33 - $37;
  $39 = ((($oX$0)) + -8|0);
  HEAPF32[$39>>2] = $38;
  $40 = +HEAPF32[$34>>2];
  $41 = +HEAPF32[$30>>2];
  $42 = $41 * $40;
  $43 = +HEAPF32[$28>>2];
  $44 = +HEAPF32[$T$0>>2];
  $45 = $44 * $43;
  $46 = $42 - $45;
  $47 = ((($oX$0)) + -4|0);
  HEAPF32[$47>>2] = $46;
  $48 = ((($iX$0)) + -32|0);
  $49 = ((($T$0)) + 16|0);
  $50 = ($48>>>0)<($in>>>0);
  if ($50) {
   break;
  } else {
   $T$0 = $49;$iX$0 = $48;$oX$0 = $8;
  }
 }
 $51 = (($out) + ($1<<2)|0);
 $$sum2 = (($1) + -8)|0;
 $52 = (($in) + ($$sum2<<2)|0);
 $T$1 = $7;$iX$1 = $52;$oX$1 = $4;
 while(1) {
  $53 = ((($T$1)) + -16|0);
  $54 = ((($iX$1)) + 16|0);
  $55 = +HEAPF32[$54>>2];
  $56 = ((($T$1)) + -4|0);
  $57 = +HEAPF32[$56>>2];
  $58 = $57 * $55;
  $59 = ((($iX$1)) + 24|0);
  $60 = +HEAPF32[$59>>2];
  $61 = ((($T$1)) + -8|0);
  $62 = +HEAPF32[$61>>2];
  $63 = $62 * $60;
  $64 = $63 + $58;
  HEAPF32[$oX$1>>2] = $64;
  $65 = +HEAPF32[$54>>2];
  $66 = +HEAPF32[$61>>2];
  $67 = $66 * $65;
  $68 = +HEAPF32[$59>>2];
  $69 = +HEAPF32[$56>>2];
  $70 = $69 * $68;
  $71 = $67 - $70;
  $72 = ((($oX$1)) + 4|0);
  HEAPF32[$72>>2] = $71;
  $73 = +HEAPF32[$iX$1>>2];
  $74 = ((($T$1)) + -12|0);
  $75 = +HEAPF32[$74>>2];
  $76 = $75 * $73;
  $77 = ((($iX$1)) + 8|0);
  $78 = +HEAPF32[$77>>2];
  $79 = +HEAPF32[$53>>2];
  $80 = $79 * $78;
  $81 = $80 + $76;
  $82 = ((($oX$1)) + 8|0);
  HEAPF32[$82>>2] = $81;
  $83 = +HEAPF32[$iX$1>>2];
  $84 = +HEAPF32[$53>>2];
  $85 = $84 * $83;
  $86 = +HEAPF32[$77>>2];
  $87 = +HEAPF32[$74>>2];
  $88 = $87 * $86;
  $89 = $85 - $88;
  $90 = ((($oX$1)) + 12|0);
  HEAPF32[$90>>2] = $89;
  $91 = ((($iX$1)) + -32|0);
  $92 = ((($oX$1)) + 16|0);
  $93 = ($91>>>0)<($in>>>0);
  if ($93) {
   break;
  } else {
   $T$1 = $53;$iX$1 = $91;$oX$1 = $92;
  }
 }
 $init$idx = ((($init)) + 4|0);
 $init$idx$val = HEAP32[$init$idx>>2]|0;
 _mdct_butterflies($init$idx$val,$6,$51,$1);
 $init$idx4$val = HEAP32[$init>>2]|0;
 $init$idx5$val = HEAP32[$5>>2]|0;
 $init$idx6 = ((($init)) + 12|0);
 $init$idx6$val = HEAP32[$init$idx6>>2]|0;
 _mdct_bitreverse($init$idx4$val,$init$idx5$val,$init$idx6$val,$out);
 $94 = HEAP32[$5>>2]|0;
 $95 = (($94) + ($1<<2)|0);
 $T$2 = $95;$iX1$0 = $out;$oX1$0 = $4;$oX2$0 = $4;
 while(1) {
  $96 = ((($oX1$0)) + -16|0);
  $97 = +HEAPF32[$iX1$0>>2];
  $98 = ((($T$2)) + 4|0);
  $99 = +HEAPF32[$98>>2];
  $100 = $99 * $97;
  $101 = ((($iX1$0)) + 4|0);
  $102 = +HEAPF32[$101>>2];
  $103 = +HEAPF32[$T$2>>2];
  $104 = $103 * $102;
  $105 = $100 - $104;
  $106 = ((($oX1$0)) + -4|0);
  HEAPF32[$106>>2] = $105;
  $107 = +HEAPF32[$iX1$0>>2];
  $108 = +HEAPF32[$T$2>>2];
  $109 = $108 * $107;
  $110 = +HEAPF32[$101>>2];
  $111 = +HEAPF32[$98>>2];
  $112 = $111 * $110;
  $113 = $109 + $112;
  $114 = -$113;
  HEAPF32[$oX2$0>>2] = $114;
  $115 = ((($iX1$0)) + 8|0);
  $116 = +HEAPF32[$115>>2];
  $117 = ((($T$2)) + 12|0);
  $118 = +HEAPF32[$117>>2];
  $119 = $118 * $116;
  $120 = ((($iX1$0)) + 12|0);
  $121 = +HEAPF32[$120>>2];
  $122 = ((($T$2)) + 8|0);
  $123 = +HEAPF32[$122>>2];
  $124 = $123 * $121;
  $125 = $119 - $124;
  $126 = ((($oX1$0)) + -8|0);
  HEAPF32[$126>>2] = $125;
  $127 = +HEAPF32[$115>>2];
  $128 = +HEAPF32[$122>>2];
  $129 = $128 * $127;
  $130 = +HEAPF32[$120>>2];
  $131 = +HEAPF32[$117>>2];
  $132 = $131 * $130;
  $133 = $129 + $132;
  $134 = -$133;
  $135 = ((($oX2$0)) + 4|0);
  HEAPF32[$135>>2] = $134;
  $136 = ((($iX1$0)) + 16|0);
  $137 = +HEAPF32[$136>>2];
  $138 = ((($T$2)) + 20|0);
  $139 = +HEAPF32[$138>>2];
  $140 = $139 * $137;
  $141 = ((($iX1$0)) + 20|0);
  $142 = +HEAPF32[$141>>2];
  $143 = ((($T$2)) + 16|0);
  $144 = +HEAPF32[$143>>2];
  $145 = $144 * $142;
  $146 = $140 - $145;
  $147 = ((($oX1$0)) + -12|0);
  HEAPF32[$147>>2] = $146;
  $148 = +HEAPF32[$136>>2];
  $149 = +HEAPF32[$143>>2];
  $150 = $149 * $148;
  $151 = +HEAPF32[$141>>2];
  $152 = +HEAPF32[$138>>2];
  $153 = $152 * $151;
  $154 = $150 + $153;
  $155 = -$154;
  $156 = ((($oX2$0)) + 8|0);
  HEAPF32[$156>>2] = $155;
  $157 = ((($iX1$0)) + 24|0);
  $158 = +HEAPF32[$157>>2];
  $159 = ((($T$2)) + 28|0);
  $160 = +HEAPF32[$159>>2];
  $161 = $160 * $158;
  $162 = ((($iX1$0)) + 28|0);
  $163 = +HEAPF32[$162>>2];
  $164 = ((($T$2)) + 24|0);
  $165 = +HEAPF32[$164>>2];
  $166 = $165 * $163;
  $167 = $161 - $166;
  HEAPF32[$96>>2] = $167;
  $168 = +HEAPF32[$157>>2];
  $169 = +HEAPF32[$164>>2];
  $170 = $169 * $168;
  $171 = +HEAPF32[$162>>2];
  $172 = +HEAPF32[$159>>2];
  $173 = $172 * $171;
  $174 = $170 + $173;
  $175 = -$174;
  $176 = ((($oX2$0)) + 12|0);
  HEAPF32[$176>>2] = $175;
  $177 = ((($oX2$0)) + 16|0);
  $178 = ((($iX1$0)) + 32|0);
  $179 = ((($T$2)) + 32|0);
  $180 = ($178>>>0)<($96>>>0);
  if ($180) {
   $T$2 = $179;$iX1$0 = $178;$oX1$0 = $96;$oX2$0 = $177;
  } else {
   break;
  }
 }
 $181 = (($out) + ($2<<2)|0);
 $iX1$1 = $4;$oX1$1 = $181;$oX2$1 = $181;
 while(1) {
  $182 = ((($oX1$1)) + -16|0);
  $183 = ((($iX1$1)) + -16|0);
  $184 = ((($iX1$1)) + -4|0);
  $185 = +HEAPF32[$184>>2];
  $186 = ((($oX1$1)) + -4|0);
  HEAPF32[$186>>2] = $185;
  $187 = -$185;
  HEAPF32[$oX2$1>>2] = $187;
  $188 = ((($iX1$1)) + -8|0);
  $189 = +HEAPF32[$188>>2];
  $190 = ((($oX1$1)) + -8|0);
  HEAPF32[$190>>2] = $189;
  $191 = -$189;
  $192 = ((($oX2$1)) + 4|0);
  HEAPF32[$192>>2] = $191;
  $193 = ((($iX1$1)) + -12|0);
  $194 = +HEAPF32[$193>>2];
  $195 = ((($oX1$1)) + -12|0);
  HEAPF32[$195>>2] = $194;
  $196 = -$194;
  $197 = ((($oX2$1)) + 8|0);
  HEAPF32[$197>>2] = $196;
  $198 = +HEAPF32[$183>>2];
  HEAPF32[$182>>2] = $198;
  $199 = -$198;
  $200 = ((($oX2$1)) + 12|0);
  HEAPF32[$200>>2] = $199;
  $201 = ((($oX2$1)) + 16|0);
  $202 = ($201>>>0)<($183>>>0);
  if ($202) {
   $iX1$1 = $183;$oX1$1 = $182;$oX2$1 = $201;
  } else {
   $iX1$2 = $4;$oX1$2 = $4;
   break;
  }
 }
 while(1) {
  $203 = ((($oX1$2)) + -16|0);
  $204 = ((($iX1$2)) + 12|0);
  $205 = HEAP32[$204>>2]|0;
  HEAP32[$203>>2] = $205;
  $206 = ((($iX1$2)) + 8|0);
  $207 = HEAP32[$206>>2]|0;
  $208 = ((($oX1$2)) + -12|0);
  HEAP32[$208>>2] = $207;
  $209 = ((($iX1$2)) + 4|0);
  $210 = HEAP32[$209>>2]|0;
  $211 = ((($oX1$2)) + -8|0);
  HEAP32[$211>>2] = $210;
  $212 = HEAP32[$iX1$2>>2]|0;
  $213 = ((($oX1$2)) + -4|0);
  HEAP32[$213>>2] = $212;
  $214 = ((($iX1$2)) + 16|0);
  $215 = ($203>>>0)>($51>>>0);
  if ($215) {
   $iX1$2 = $214;$oX1$2 = $203;
  } else {
   break;
  }
 }
 return;
}
function _mdct_forward($init,$in,$out) {
 $init = $init|0;
 $in = $in|0;
 $out = $out|0;
 var $$alloca_mul = 0, $$sum = 0, $$sum1 = 0, $$sum2 = 0, $$sum3 = 0, $$sum4 = 0, $$sum5 = 0, $$sum51 = 0, $$sum6 = 0, $$sum7 = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0.0, $101 = 0, $102 = 0.0, $103 = 0.0, $104 = 0, $105 = 0.0, $106 = 0.0;
 var $107 = 0.0, $108 = 0.0, $109 = 0.0, $11 = 0, $110 = 0, $111 = 0.0, $112 = 0.0, $113 = 0.0, $114 = 0.0, $115 = 0.0, $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0;
 var $125 = 0, $126 = 0, $127 = 0.0, $128 = 0.0, $129 = 0.0, $13 = 0, $130 = 0, $131 = 0.0, $132 = 0, $133 = 0.0, $134 = 0.0, $135 = 0.0, $136 = 0.0, $137 = 0.0, $138 = 0, $139 = 0.0, $14 = 0, $140 = 0.0, $141 = 0.0, $142 = 0.0;
 var $143 = 0.0, $144 = 0.0, $145 = 0.0, $146 = 0.0, $147 = 0.0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0.0, $25 = 0.0;
 var $26 = 0.0, $27 = 0.0, $28 = 0, $29 = 0.0, $3 = 0, $30 = 0.0, $31 = 0, $32 = 0.0, $33 = 0.0, $34 = 0.0, $35 = 0.0, $36 = 0.0, $37 = 0, $38 = 0.0, $39 = 0.0, $4 = 0, $40 = 0.0, $41 = 0.0, $42 = 0.0, $43 = 0;
 var $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0;
 var $62 = 0, $63 = 0, $64 = 0.0, $65 = 0.0, $66 = 0.0, $67 = 0.0, $68 = 0, $69 = 0.0, $7 = 0, $70 = 0.0, $71 = 0, $72 = 0.0, $73 = 0.0, $74 = 0.0, $75 = 0.0, $76 = 0.0, $77 = 0, $78 = 0.0, $79 = 0.0, $8 = 0;
 var $80 = 0.0, $81 = 0.0, $82 = 0.0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0.0, $96 = 0.0, $97 = 0.0, $98 = 0.0;
 var $99 = 0.0, $T$0$lcssa = 0, $T$035 = 0, $T$1$lcssa = 0, $T$126 = 0, $T$219 = 0, $T$315 = 0, $exitcond = 0, $i$0$lcssa = 0, $i$036 = 0, $i$1$lcssa = 0, $i$127 = 0, $i$220 = 0, $i$316 = 0, $init$idx = 0, $init$idx$val = 0, $init$idx10$val = 0, $init$idx11 = 0, $init$idx11$val = 0, $init$idx9$val = 0;
 var $scevgep = 0, $scevgep48 = 0, $scevgep49 = 0, $scevgep50 = 0, $w$013 = 0, $x0$0$lcssa = 0, $x0$033 = 0, $x0$124 = 0, $x0$217 = 0, $x0$314 = 0, $x1$034 = 0, $x1$1$lcssa = 0, $x1$125 = 0, $x1$218 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = HEAP32[$init>>2]|0;
 $1 = $0 >> 1;
 $2 = $0 >> 2;
 $3 = $0 >> 3;
 $4 = $0 << 2;
 $$alloca_mul = $4;
 $5 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul)|0)+15)&-16)|0;;
 $6 = (($5) + ($1<<2)|0);
 $$sum = (($1) + ($2))|0;
 $7 = (($in) + ($$sum<<2)|0);
 $8 = ((($init)) + 8|0);
 $9 = HEAP32[$8>>2]|0;
 $10 = (($9) + ($1<<2)|0);
 $11 = ($3|0)>(0);
 if ($11) {
  $$sum1 = (($$sum) + 1)|0;
  $12 = (($in) + ($$sum1<<2)|0);
  $13 = (($3) + -1)|0;
  $14 = $13 >>> 1;
  $15 = $14 << 1;
  $16 = (($1) + -2)|0;
  $17 = (($16) - ($15))|0;
  $18 = (($$sum) + -4)|0;
  $19 = $14 << 2;
  $20 = (($18) - ($19))|0;
  $T$035 = $10;$i$036 = 0;$x0$033 = $7;$x1$034 = $12;
  while(1) {
   $21 = ((($x0$033)) + -16|0);
   $22 = ((($T$035)) + -8|0);
   $23 = ((($x0$033)) + -8|0);
   $24 = +HEAPF32[$23>>2];
   $25 = +HEAPF32[$x1$034>>2];
   $26 = $25 + $24;
   $27 = +HEAPF32[$21>>2];
   $28 = ((($x1$034)) + 8|0);
   $29 = +HEAPF32[$28>>2];
   $30 = $29 + $27;
   $31 = ((($T$035)) + -4|0);
   $32 = +HEAPF32[$31>>2];
   $33 = $30 * $32;
   $34 = +HEAPF32[$22>>2];
   $35 = $34 * $26;
   $36 = $35 + $33;
   $$sum6 = (($i$036) + ($1))|0;
   $37 = (($5) + ($$sum6<<2)|0);
   HEAPF32[$37>>2] = $36;
   $38 = +HEAPF32[$22>>2];
   $39 = $38 * $30;
   $40 = +HEAPF32[$31>>2];
   $41 = $40 * $26;
   $42 = $39 - $41;
   $43 = $i$036 | 1;
   $$sum7 = (($43) + ($1))|0;
   $44 = (($5) + ($$sum7<<2)|0);
   HEAPF32[$44>>2] = $42;
   $45 = ((($x1$034)) + 16|0);
   $46 = (($i$036) + 2)|0;
   $47 = ($46|0)<($3|0);
   if ($47) {
    $T$035 = $22;$i$036 = $46;$x0$033 = $21;$x1$034 = $45;
   } else {
    break;
   }
  }
  $48 = (($15) + 2)|0;
  $scevgep49 = (($9) + ($17<<2)|0);
  $scevgep50 = (($in) + ($20<<2)|0);
  $89 = $17;$T$0$lcssa = $scevgep49;$i$0$lcssa = $48;$x0$0$lcssa = $scevgep50;
 } else {
  $89 = $1;$T$0$lcssa = $10;$i$0$lcssa = 0;$x0$0$lcssa = $7;
 }
 $49 = ((($in)) + 4|0);
 $50 = (($1) - ($3))|0;
 $51 = ($i$0$lcssa|0)<($50|0);
 if ($51) {
  $52 = (($1) + -1)|0;
  $53 = (($52) - ($i$0$lcssa))|0;
  $54 = (($53) - ($3))|0;
  $55 = $54 >>> 1;
  $56 = $55 << 1;
  $57 = (($i$0$lcssa) + ($56))|0;
  $58 = $55 << 2;
  $59 = (($58) + 5)|0;
  $60 = (-2 - ($56))|0;
  $T$126 = $T$0$lcssa;$i$127 = $i$0$lcssa;$x0$124 = $x0$0$lcssa;$x1$125 = $49;
  while(1) {
   $61 = ((($T$126)) + -8|0);
   $62 = ((($x0$124)) + -16|0);
   $63 = ((($x0$124)) + -8|0);
   $64 = +HEAPF32[$63>>2];
   $65 = +HEAPF32[$x1$125>>2];
   $66 = $64 - $65;
   $67 = +HEAPF32[$62>>2];
   $68 = ((($x1$125)) + 8|0);
   $69 = +HEAPF32[$68>>2];
   $70 = $67 - $69;
   $71 = ((($T$126)) + -4|0);
   $72 = +HEAPF32[$71>>2];
   $73 = $70 * $72;
   $74 = +HEAPF32[$61>>2];
   $75 = $74 * $66;
   $76 = $75 + $73;
   $$sum4 = (($i$127) + ($1))|0;
   $77 = (($5) + ($$sum4<<2)|0);
   HEAPF32[$77>>2] = $76;
   $78 = +HEAPF32[$61>>2];
   $79 = $78 * $70;
   $80 = +HEAPF32[$71>>2];
   $81 = $80 * $66;
   $82 = $79 - $81;
   $83 = $i$127 | 1;
   $$sum5 = (($83) + ($1))|0;
   $84 = (($5) + ($$sum5<<2)|0);
   HEAPF32[$84>>2] = $82;
   $85 = ((($x1$125)) + 16|0);
   $86 = (($i$127) + 2)|0;
   $87 = ($86|0)<($50|0);
   if ($87) {
    $T$126 = $61;$i$127 = $86;$x0$124 = $62;$x1$125 = $85;
   } else {
    break;
   }
  }
  $88 = (($57) + 2)|0;
  $scevgep = (($in) + ($59<<2)|0);
  $$sum51 = (($89) + ($60))|0;
  $scevgep48 = (($9) + ($$sum51<<2)|0);
  $T$1$lcssa = $scevgep48;$i$1$lcssa = $88;$x1$1$lcssa = $scevgep;
 } else {
  $T$1$lcssa = $T$0$lcssa;$i$1$lcssa = $i$0$lcssa;$x1$1$lcssa = $49;
 }
 $90 = ($i$1$lcssa|0)<($1|0);
 if ($90) {
  $91 = (($in) + ($0<<2)|0);
  $T$219 = $T$1$lcssa;$i$220 = $i$1$lcssa;$x0$217 = $91;$x1$218 = $x1$1$lcssa;
  while(1) {
   $92 = ((($T$219)) + -8|0);
   $93 = ((($x0$217)) + -16|0);
   $94 = ((($x0$217)) + -8|0);
   $95 = +HEAPF32[$94>>2];
   $96 = -$95;
   $97 = +HEAPF32[$x1$218>>2];
   $98 = $96 - $97;
   $99 = +HEAPF32[$93>>2];
   $100 = -$99;
   $101 = ((($x1$218)) + 8|0);
   $102 = +HEAPF32[$101>>2];
   $103 = $100 - $102;
   $104 = ((($T$219)) + -4|0);
   $105 = +HEAPF32[$104>>2];
   $106 = $103 * $105;
   $107 = +HEAPF32[$92>>2];
   $108 = $107 * $98;
   $109 = $108 + $106;
   $$sum2 = (($i$220) + ($1))|0;
   $110 = (($5) + ($$sum2<<2)|0);
   HEAPF32[$110>>2] = $109;
   $111 = +HEAPF32[$92>>2];
   $112 = $111 * $103;
   $113 = +HEAPF32[$104>>2];
   $114 = $113 * $98;
   $115 = $112 - $114;
   $116 = $i$220 | 1;
   $$sum3 = (($116) + ($1))|0;
   $117 = (($5) + ($$sum3<<2)|0);
   HEAPF32[$117>>2] = $115;
   $118 = ((($x1$218)) + 16|0);
   $119 = (($i$220) + 2)|0;
   $120 = ($119|0)<($1|0);
   if ($120) {
    $T$219 = $92;$i$220 = $119;$x0$217 = $93;$x1$218 = $118;
   } else {
    break;
   }
  }
 }
 $init$idx = ((($init)) + 4|0);
 $init$idx$val = HEAP32[$init$idx>>2]|0;
 _mdct_butterflies($init$idx$val,$9,$6,$1);
 $init$idx9$val = HEAP32[$init>>2]|0;
 $init$idx10$val = HEAP32[$8>>2]|0;
 $init$idx11 = ((($init)) + 12|0);
 $init$idx11$val = HEAP32[$init$idx11>>2]|0;
 _mdct_bitreverse($init$idx9$val,$init$idx10$val,$init$idx11$val,$5);
 $121 = ($2|0)>(0);
 if (!($121)) {
  STACKTOP = sp;return;
 }
 $122 = (($out) + ($1<<2)|0);
 $123 = HEAP32[$8>>2]|0;
 $124 = (($123) + ($1<<2)|0);
 $125 = ((($init)) + 16|0);
 $T$315 = $124;$i$316 = 0;$w$013 = $5;$x0$314 = $122;
 while(1) {
  $126 = ((($x0$314)) + -4|0);
  $127 = +HEAPF32[$w$013>>2];
  $128 = +HEAPF32[$T$315>>2];
  $129 = $128 * $127;
  $130 = ((($w$013)) + 4|0);
  $131 = +HEAPF32[$130>>2];
  $132 = ((($T$315)) + 4|0);
  $133 = +HEAPF32[$132>>2];
  $134 = $133 * $131;
  $135 = $134 + $129;
  $136 = +HEAPF32[$125>>2];
  $137 = $135 * $136;
  $138 = (($out) + ($i$316<<2)|0);
  HEAPF32[$138>>2] = $137;
  $139 = +HEAPF32[$w$013>>2];
  $140 = +HEAPF32[$132>>2];
  $141 = $140 * $139;
  $142 = +HEAPF32[$130>>2];
  $143 = +HEAPF32[$T$315>>2];
  $144 = $143 * $142;
  $145 = $141 - $144;
  $146 = +HEAPF32[$125>>2];
  $147 = $145 * $146;
  HEAPF32[$126>>2] = $147;
  $148 = ((($w$013)) + 8|0);
  $149 = ((($T$315)) + 8|0);
  $150 = (($i$316) + 1)|0;
  $exitcond = ($150|0)==($2|0);
  if ($exitcond) {
   break;
  } else {
   $T$315 = $149;$i$316 = $150;$w$013 = $148;$x0$314 = $126;
  }
 }
 STACKTOP = sp;return;
}
function _mdct_butterflies($init$0$1$val,$init$0$2$val,$x,$points) {
 $init$0$1$val = $init$0$1$val|0;
 $init$0$2$val = $init$0$2$val|0;
 $x = $x|0;
 $points = $points|0;
 var $$0$i = 0, $$0$i5 = 0, $$sum = 0, $$sum$i = 0, $$sum$i1 = 0, $$sum1 = 0, $$sum1$i = 0, $$sum1$i2 = 0, $$sum10 = 0, $$sum11 = 0, $$sum12 = 0, $$sum13 = 0, $$sum14 = 0, $$sum15 = 0, $$sum16 = 0, $$sum17 = 0, $$sum18 = 0, $$sum19 = 0, $$sum2 = 0, $$sum2$i = 0;
 var $$sum20 = 0, $$sum21 = 0, $$sum22 = 0, $$sum23 = 0, $$sum24 = 0, $$sum25 = 0, $$sum26 = 0, $$sum27 = 0, $$sum28 = 0, $$sum29 = 0, $$sum3 = 0, $$sum3$i = 0, $$sum30 = 0, $$sum31 = 0, $$sum32 = 0, $$sum4 = 0, $$sum45$i = 0, $$sum5 = 0, $$sum6 = 0, $$sum6$i = 0;
 var $$sum7 = 0, $$sum7$i = 0, $$sum8 = 0, $$sum8$i = 0, $$sum9 = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0.0, $101 = 0.0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0.0, $110 = 0;
 var $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0, $118 = 0.0, $119 = 0, $12 = 0, $120 = 0.0, $121 = 0.0, $122 = 0, $123 = 0.0, $124 = 0, $125 = 0.0, $126 = 0.0, $127 = 0.0, $128 = 0.0, $129 = 0.0;
 var $13 = 0.0, $130 = 0, $131 = 0.0, $132 = 0.0, $133 = 0.0, $134 = 0.0, $135 = 0.0, $136 = 0.0, $137 = 0.0, $138 = 0.0, $139 = 0.0, $14 = 0.0, $140 = 0.0, $141 = 0, $142 = 0, $143 = 0.0, $144 = 0, $145 = 0.0, $146 = 0.0, $147 = 0;
 var $148 = 0.0, $149 = 0, $15 = 0.0, $150 = 0.0, $151 = 0.0, $152 = 0.0, $153 = 0.0, $154 = 0.0, $155 = 0, $156 = 0.0, $157 = 0.0, $158 = 0.0, $159 = 0.0, $16 = 0.0, $160 = 0.0, $161 = 0.0, $162 = 0.0, $163 = 0.0, $164 = 0.0, $165 = 0.0;
 var $166 = 0, $167 = 0, $168 = 0.0, $169 = 0, $17 = 0.0, $170 = 0.0, $171 = 0.0, $172 = 0, $173 = 0.0, $174 = 0, $175 = 0.0, $176 = 0.0, $177 = 0.0, $178 = 0.0, $179 = 0.0, $18 = 0, $180 = 0, $181 = 0.0, $182 = 0.0, $183 = 0.0;
 var $184 = 0.0, $185 = 0.0, $186 = 0.0, $187 = 0.0, $188 = 0.0, $189 = 0.0, $19 = 0.0, $190 = 0.0, $191 = 0, $192 = 0.0, $193 = 0.0, $194 = 0.0, $195 = 0, $196 = 0.0, $197 = 0, $198 = 0.0, $199 = 0.0, $2 = 0, $20 = 0.0, $200 = 0.0;
 var $201 = 0.0, $202 = 0.0, $203 = 0, $204 = 0.0, $205 = 0.0, $206 = 0.0, $207 = 0.0, $208 = 0.0, $209 = 0.0, $21 = 0.0, $210 = 0.0, $211 = 0.0, $212 = 0.0, $213 = 0.0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0;
 var $22 = 0.0, $220 = 0, $221 = 0, $222 = 0, $223 = 0.0, $224 = 0, $225 = 0.0, $226 = 0.0, $227 = 0, $228 = 0.0, $229 = 0, $23 = 0.0, $230 = 0.0, $231 = 0.0, $232 = 0.0, $233 = 0.0, $234 = 0, $235 = 0.0, $236 = 0, $237 = 0.0;
 var $238 = 0.0, $239 = 0, $24 = 0.0, $240 = 0.0, $241 = 0, $242 = 0.0, $243 = 0.0, $244 = 0.0, $245 = 0.0, $246 = 0.0, $247 = 0.0, $248 = 0.0, $249 = 0.0, $25 = 0.0, $250 = 0.0, $251 = 0.0, $252 = 0, $253 = 0.0, $254 = 0, $255 = 0.0;
 var $256 = 0.0, $257 = 0, $258 = 0.0, $259 = 0, $26 = 0.0, $260 = 0.0, $261 = 0.0, $262 = 0.0, $263 = 0.0, $264 = 0.0, $265 = 0.0, $266 = 0.0, $267 = 0.0, $268 = 0, $269 = 0.0, $27 = 0.0, $270 = 0, $271 = 0.0, $272 = 0.0, $273 = 0;
 var $274 = 0.0, $275 = 0, $276 = 0.0, $277 = 0.0, $278 = 0.0, $279 = 0.0, $28 = 0.0, $280 = 0.0, $281 = 0.0, $282 = 0.0, $283 = 0.0, $284 = 0.0, $285 = 0.0, $286 = 0, $287 = 0.0, $288 = 0, $289 = 0.0, $29 = 0, $290 = 0.0, $291 = 0;
 var $292 = 0.0, $293 = 0, $294 = 0.0, $295 = 0.0, $296 = 0.0, $297 = 0.0, $298 = 0, $299 = 0.0, $3 = 0, $30 = 0.0, $300 = 0, $301 = 0.0, $302 = 0.0, $303 = 0, $304 = 0.0, $305 = 0, $306 = 0.0, $307 = 0.0, $308 = 0.0, $309 = 0.0;
 var $31 = 0, $310 = 0.0, $311 = 0.0, $312 = 0.0, $313 = 0.0, $314 = 0.0, $315 = 0.0, $316 = 0, $317 = 0.0, $318 = 0, $319 = 0.0, $32 = 0.0, $320 = 0.0, $321 = 0, $322 = 0.0, $323 = 0, $324 = 0.0, $325 = 0.0, $326 = 0.0, $327 = 0.0;
 var $328 = 0.0, $329 = 0.0, $33 = 0.0, $330 = 0.0, $331 = 0.0, $332 = 0.0, $333 = 0, $334 = 0.0, $335 = 0.0, $336 = 0, $337 = 0.0, $338 = 0, $339 = 0.0, $34 = 0, $340 = 0.0, $341 = 0.0, $342 = 0.0, $343 = 0.0, $344 = 0.0, $345 = 0.0;
 var $346 = 0.0, $347 = 0.0, $348 = 0.0, $349 = 0.0, $35 = 0.0, $350 = 0.0, $351 = 0.0, $352 = 0.0, $353 = 0.0, $354 = 0.0, $355 = 0.0, $356 = 0.0, $357 = 0.0, $358 = 0.0, $359 = 0.0, $36 = 0, $360 = 0.0, $361 = 0.0, $362 = 0.0, $363 = 0.0;
 var $364 = 0.0, $365 = 0.0, $366 = 0.0, $367 = 0.0, $368 = 0.0, $369 = 0.0, $37 = 0.0, $370 = 0.0, $371 = 0.0, $372 = 0.0, $373 = 0.0, $374 = 0.0, $375 = 0.0, $376 = 0.0, $377 = 0.0, $378 = 0.0, $379 = 0.0, $38 = 0.0, $380 = 0.0, $381 = 0.0;
 var $382 = 0.0, $383 = 0.0, $384 = 0.0, $385 = 0.0, $386 = 0.0, $387 = 0.0, $388 = 0.0, $389 = 0.0, $39 = 0.0, $390 = 0.0, $391 = 0.0, $392 = 0.0, $393 = 0.0, $394 = 0.0, $395 = 0.0, $396 = 0.0, $397 = 0.0, $398 = 0.0, $399 = 0.0, $4 = 0;
 var $40 = 0.0, $400 = 0.0, $401 = 0.0, $402 = 0.0, $403 = 0.0, $404 = 0.0, $405 = 0.0, $406 = 0.0, $407 = 0.0, $408 = 0.0, $409 = 0.0, $41 = 0.0, $410 = 0.0, $411 = 0.0, $412 = 0.0, $413 = 0.0, $414 = 0.0, $415 = 0.0, $416 = 0.0, $417 = 0.0;
 var $418 = 0.0, $419 = 0.0, $42 = 0, $420 = 0.0, $421 = 0.0, $422 = 0.0, $423 = 0.0, $424 = 0.0, $425 = 0.0, $426 = 0.0, $427 = 0.0, $428 = 0.0, $429 = 0.0, $43 = 0.0, $430 = 0.0, $431 = 0.0, $432 = 0.0, $433 = 0.0, $434 = 0.0, $435 = 0.0;
 var $436 = 0.0, $437 = 0.0, $438 = 0.0, $439 = 0.0, $44 = 0.0, $440 = 0.0, $441 = 0.0, $442 = 0.0, $443 = 0.0, $444 = 0.0, $445 = 0.0, $446 = 0.0, $447 = 0.0, $448 = 0.0, $449 = 0.0, $45 = 0, $450 = 0.0, $451 = 0.0, $452 = 0.0, $453 = 0.0;
 var $454 = 0.0, $455 = 0.0, $456 = 0.0, $457 = 0.0, $458 = 0.0, $459 = 0.0, $46 = 0.0, $460 = 0.0, $461 = 0.0, $462 = 0.0, $463 = 0.0, $464 = 0.0, $465 = 0.0, $466 = 0.0, $467 = 0.0, $468 = 0.0, $469 = 0.0, $47 = 0.0, $470 = 0.0, $471 = 0.0;
 var $472 = 0.0, $473 = 0.0, $474 = 0.0, $475 = 0.0, $476 = 0.0, $477 = 0.0, $478 = 0.0, $479 = 0.0, $48 = 0.0, $480 = 0.0, $481 = 0, $482 = 0, $49 = 0.0, $5 = 0, $50 = 0.0, $51 = 0.0, $52 = 0.0, $53 = 0.0, $54 = 0, $55 = 0.0;
 var $56 = 0, $57 = 0.0, $58 = 0.0, $59 = 0, $6 = 0.0, $60 = 0.0, $61 = 0, $62 = 0.0, $63 = 0.0, $64 = 0.0, $65 = 0.0, $66 = 0.0, $67 = 0, $68 = 0.0, $69 = 0.0, $7 = 0, $70 = 0, $71 = 0.0, $72 = 0.0, $73 = 0.0;
 var $74 = 0.0, $75 = 0.0, $76 = 0.0, $77 = 0.0, $78 = 0.0, $79 = 0.0, $8 = 0.0, $80 = 0.0, $81 = 0.0, $82 = 0, $83 = 0.0, $84 = 0, $85 = 0.0, $86 = 0.0, $87 = 0.0, $88 = 0.0, $89 = 0.0, $9 = 0.0, $90 = 0, $91 = 0.0;
 var $92 = 0.0, $93 = 0, $94 = 0.0, $95 = 0.0, $96 = 0.0, $97 = 0.0, $98 = 0.0, $99 = 0.0, $exitcond = 0, $i$038 = 0, $j$035 = 0, $j$134 = 0, $x1$0$i = 0, $x1$0$i4 = 0, $x2$0$i = 0, $x2$0$i3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = (($init$0$1$val) + -6)|0;
 $1 = ($init$0$1$val|0)>(6);
 if ($1) {
  $$sum$i = (($points) + -8)|0;
  $2 = (($x) + ($$sum$i<<2)|0);
  $3 = $points >> 1;
  $$sum1$i = (($3) + -8)|0;
  $4 = (($x) + ($$sum1$i<<2)|0);
  $$0$i = $init$0$2$val;$x1$0$i = $2;$x2$0$i = $4;
  while(1) {
   $5 = ((($x1$0$i)) + 24|0);
   $6 = +HEAPF32[$5>>2];
   $7 = ((($x2$0$i)) + 24|0);
   $8 = +HEAPF32[$7>>2];
   $9 = $6 - $8;
   $10 = ((($x1$0$i)) + 28|0);
   $11 = +HEAPF32[$10>>2];
   $12 = ((($x2$0$i)) + 28|0);
   $13 = +HEAPF32[$12>>2];
   $14 = $11 - $13;
   $15 = $8 + $6;
   HEAPF32[$5>>2] = $15;
   $16 = +HEAPF32[$12>>2];
   $17 = $16 + $11;
   HEAPF32[$10>>2] = $17;
   $18 = ((($$0$i)) + 4|0);
   $19 = +HEAPF32[$18>>2];
   $20 = $19 * $14;
   $21 = +HEAPF32[$$0$i>>2];
   $22 = $21 * $9;
   $23 = $22 + $20;
   HEAPF32[$7>>2] = $23;
   $24 = +HEAPF32[$$0$i>>2];
   $25 = $24 * $14;
   $26 = +HEAPF32[$18>>2];
   $27 = $26 * $9;
   $28 = $25 - $27;
   HEAPF32[$12>>2] = $28;
   $29 = ((($x1$0$i)) + 16|0);
   $30 = +HEAPF32[$29>>2];
   $31 = ((($x2$0$i)) + 16|0);
   $32 = +HEAPF32[$31>>2];
   $33 = $30 - $32;
   $34 = ((($x1$0$i)) + 20|0);
   $35 = +HEAPF32[$34>>2];
   $36 = ((($x2$0$i)) + 20|0);
   $37 = +HEAPF32[$36>>2];
   $38 = $35 - $37;
   $39 = $32 + $30;
   HEAPF32[$29>>2] = $39;
   $40 = +HEAPF32[$36>>2];
   $41 = $40 + $35;
   HEAPF32[$34>>2] = $41;
   $42 = ((($$0$i)) + 20|0);
   $43 = +HEAPF32[$42>>2];
   $44 = $43 * $38;
   $45 = ((($$0$i)) + 16|0);
   $46 = +HEAPF32[$45>>2];
   $47 = $46 * $33;
   $48 = $47 + $44;
   HEAPF32[$31>>2] = $48;
   $49 = +HEAPF32[$45>>2];
   $50 = $49 * $38;
   $51 = +HEAPF32[$42>>2];
   $52 = $51 * $33;
   $53 = $50 - $52;
   HEAPF32[$36>>2] = $53;
   $54 = ((($x1$0$i)) + 8|0);
   $55 = +HEAPF32[$54>>2];
   $56 = ((($x2$0$i)) + 8|0);
   $57 = +HEAPF32[$56>>2];
   $58 = $55 - $57;
   $59 = ((($x1$0$i)) + 12|0);
   $60 = +HEAPF32[$59>>2];
   $61 = ((($x2$0$i)) + 12|0);
   $62 = +HEAPF32[$61>>2];
   $63 = $60 - $62;
   $64 = $57 + $55;
   HEAPF32[$54>>2] = $64;
   $65 = +HEAPF32[$61>>2];
   $66 = $65 + $60;
   HEAPF32[$59>>2] = $66;
   $67 = ((($$0$i)) + 36|0);
   $68 = +HEAPF32[$67>>2];
   $69 = $68 * $63;
   $70 = ((($$0$i)) + 32|0);
   $71 = +HEAPF32[$70>>2];
   $72 = $71 * $58;
   $73 = $72 + $69;
   HEAPF32[$56>>2] = $73;
   $74 = +HEAPF32[$70>>2];
   $75 = $74 * $63;
   $76 = +HEAPF32[$67>>2];
   $77 = $76 * $58;
   $78 = $75 - $77;
   HEAPF32[$61>>2] = $78;
   $79 = +HEAPF32[$x1$0$i>>2];
   $80 = +HEAPF32[$x2$0$i>>2];
   $81 = $79 - $80;
   $82 = ((($x1$0$i)) + 4|0);
   $83 = +HEAPF32[$82>>2];
   $84 = ((($x2$0$i)) + 4|0);
   $85 = +HEAPF32[$84>>2];
   $86 = $83 - $85;
   $87 = $80 + $79;
   HEAPF32[$x1$0$i>>2] = $87;
   $88 = +HEAPF32[$84>>2];
   $89 = $88 + $83;
   HEAPF32[$82>>2] = $89;
   $90 = ((($$0$i)) + 52|0);
   $91 = +HEAPF32[$90>>2];
   $92 = $91 * $86;
   $93 = ((($$0$i)) + 48|0);
   $94 = +HEAPF32[$93>>2];
   $95 = $94 * $81;
   $96 = $95 + $92;
   HEAPF32[$x2$0$i>>2] = $96;
   $97 = +HEAPF32[$93>>2];
   $98 = $97 * $86;
   $99 = +HEAPF32[$90>>2];
   $100 = $99 * $81;
   $101 = $98 - $100;
   HEAPF32[$84>>2] = $101;
   $102 = ((($x1$0$i)) + -32|0);
   $103 = ((($x2$0$i)) + -32|0);
   $104 = ((($$0$i)) + 64|0);
   $105 = ($103>>>0)<($x>>>0);
   if ($105) {
    break;
   } else {
    $$0$i = $104;$x1$0$i = $102;$x2$0$i = $103;
   }
  }
 }
 $106 = ($0|0)>(1);
 if ($106) {
  $i$038 = 1;
  while(1) {
   $107 = 1 << $i$038;
   $108 = ($i$038|0)==(31);
   if (!($108)) {
    $109 = $points >> $i$038;
    $110 = 4 << $i$038;
    $$sum$i1 = (($109) + -8)|0;
    $111 = $109 >> 1;
    $$sum1$i2 = (($111) + -8)|0;
    $$sum2$i = (($110) + 1)|0;
    $$sum3$i = $110 << 1;
    $$sum45$i = $$sum3$i | 1;
    $$sum6$i = ($110*3)|0;
    $$sum7$i = (($$sum6$i) + 1)|0;
    $$sum8$i = $110 << 2;
    $j$035 = 0;
    while(1) {
     $113 = Math_imul($j$035, $109)|0;
     $114 = (($x) + ($113<<2)|0);
     $$sum = (($$sum$i1) + ($113))|0;
     $115 = (($x) + ($$sum<<2)|0);
     $$sum32 = (($$sum1$i2) + ($113))|0;
     $116 = (($x) + ($$sum32<<2)|0);
     $$0$i5 = $init$0$2$val;$x1$0$i4 = $115;$x2$0$i3 = $116;
     while(1) {
      $117 = ((($x1$0$i4)) + 24|0);
      $118 = +HEAPF32[$117>>2];
      $119 = ((($x2$0$i3)) + 24|0);
      $120 = +HEAPF32[$119>>2];
      $121 = $118 - $120;
      $122 = ((($x1$0$i4)) + 28|0);
      $123 = +HEAPF32[$122>>2];
      $124 = ((($x2$0$i3)) + 28|0);
      $125 = +HEAPF32[$124>>2];
      $126 = $123 - $125;
      $127 = $120 + $118;
      HEAPF32[$117>>2] = $127;
      $128 = +HEAPF32[$124>>2];
      $129 = $128 + $123;
      HEAPF32[$122>>2] = $129;
      $130 = ((($$0$i5)) + 4|0);
      $131 = +HEAPF32[$130>>2];
      $132 = $131 * $126;
      $133 = +HEAPF32[$$0$i5>>2];
      $134 = $133 * $121;
      $135 = $134 + $132;
      HEAPF32[$119>>2] = $135;
      $136 = +HEAPF32[$$0$i5>>2];
      $137 = $136 * $126;
      $138 = +HEAPF32[$130>>2];
      $139 = $138 * $121;
      $140 = $137 - $139;
      HEAPF32[$124>>2] = $140;
      $141 = (($$0$i5) + ($110<<2)|0);
      $142 = ((($x1$0$i4)) + 16|0);
      $143 = +HEAPF32[$142>>2];
      $144 = ((($x2$0$i3)) + 16|0);
      $145 = +HEAPF32[$144>>2];
      $146 = $143 - $145;
      $147 = ((($x1$0$i4)) + 20|0);
      $148 = +HEAPF32[$147>>2];
      $149 = ((($x2$0$i3)) + 20|0);
      $150 = +HEAPF32[$149>>2];
      $151 = $148 - $150;
      $152 = $145 + $143;
      HEAPF32[$142>>2] = $152;
      $153 = +HEAPF32[$149>>2];
      $154 = $153 + $148;
      HEAPF32[$147>>2] = $154;
      $155 = (($$0$i5) + ($$sum2$i<<2)|0);
      $156 = +HEAPF32[$155>>2];
      $157 = $156 * $151;
      $158 = +HEAPF32[$141>>2];
      $159 = $158 * $146;
      $160 = $159 + $157;
      HEAPF32[$144>>2] = $160;
      $161 = +HEAPF32[$141>>2];
      $162 = $161 * $151;
      $163 = +HEAPF32[$155>>2];
      $164 = $163 * $146;
      $165 = $162 - $164;
      HEAPF32[$149>>2] = $165;
      $166 = (($$0$i5) + ($$sum3$i<<2)|0);
      $167 = ((($x1$0$i4)) + 8|0);
      $168 = +HEAPF32[$167>>2];
      $169 = ((($x2$0$i3)) + 8|0);
      $170 = +HEAPF32[$169>>2];
      $171 = $168 - $170;
      $172 = ((($x1$0$i4)) + 12|0);
      $173 = +HEAPF32[$172>>2];
      $174 = ((($x2$0$i3)) + 12|0);
      $175 = +HEAPF32[$174>>2];
      $176 = $173 - $175;
      $177 = $170 + $168;
      HEAPF32[$167>>2] = $177;
      $178 = +HEAPF32[$174>>2];
      $179 = $178 + $173;
      HEAPF32[$172>>2] = $179;
      $180 = (($$0$i5) + ($$sum45$i<<2)|0);
      $181 = +HEAPF32[$180>>2];
      $182 = $181 * $176;
      $183 = +HEAPF32[$166>>2];
      $184 = $183 * $171;
      $185 = $184 + $182;
      HEAPF32[$169>>2] = $185;
      $186 = +HEAPF32[$166>>2];
      $187 = $186 * $176;
      $188 = +HEAPF32[$180>>2];
      $189 = $188 * $171;
      $190 = $187 - $189;
      HEAPF32[$174>>2] = $190;
      $191 = (($$0$i5) + ($$sum6$i<<2)|0);
      $192 = +HEAPF32[$x1$0$i4>>2];
      $193 = +HEAPF32[$x2$0$i3>>2];
      $194 = $192 - $193;
      $195 = ((($x1$0$i4)) + 4|0);
      $196 = +HEAPF32[$195>>2];
      $197 = ((($x2$0$i3)) + 4|0);
      $198 = +HEAPF32[$197>>2];
      $199 = $196 - $198;
      $200 = $193 + $192;
      HEAPF32[$x1$0$i4>>2] = $200;
      $201 = +HEAPF32[$197>>2];
      $202 = $201 + $196;
      HEAPF32[$195>>2] = $202;
      $203 = (($$0$i5) + ($$sum7$i<<2)|0);
      $204 = +HEAPF32[$203>>2];
      $205 = $204 * $199;
      $206 = +HEAPF32[$191>>2];
      $207 = $206 * $194;
      $208 = $207 + $205;
      HEAPF32[$x2$0$i3>>2] = $208;
      $209 = +HEAPF32[$191>>2];
      $210 = $209 * $199;
      $211 = +HEAPF32[$203>>2];
      $212 = $211 * $194;
      $213 = $210 - $212;
      HEAPF32[$197>>2] = $213;
      $214 = (($$0$i5) + ($$sum8$i<<2)|0);
      $215 = ((($x1$0$i4)) + -32|0);
      $216 = ((($x2$0$i3)) + -32|0);
      $217 = ($216>>>0)<($114>>>0);
      if ($217) {
       break;
      } else {
       $$0$i5 = $214;$x1$0$i4 = $215;$x2$0$i3 = $216;
      }
     }
     $218 = (($j$035) + 1)|0;
     $219 = ($218|0)<($107|0);
     if ($219) {
      $j$035 = $218;
     } else {
      break;
     }
    }
   }
   $220 = (($i$038) + 1)|0;
   $exitcond = ($220|0)==($0|0);
   if ($exitcond) {
    break;
   } else {
    $i$038 = $220;
   }
  }
 }
 $112 = ($points|0)>(0);
 if ($112) {
  $j$134 = 0;
 } else {
  return;
 }
 while(1) {
  $221 = (($x) + ($j$134<<2)|0);
  $$sum1 = $j$134 | 30;
  $222 = (($x) + ($$sum1<<2)|0);
  $223 = +HEAPF32[$222>>2];
  $$sum2 = $j$134 | 14;
  $224 = (($x) + ($$sum2<<2)|0);
  $225 = +HEAPF32[$224>>2];
  $226 = $223 - $225;
  $$sum3 = $j$134 | 31;
  $227 = (($x) + ($$sum3<<2)|0);
  $228 = +HEAPF32[$227>>2];
  $$sum4 = $j$134 | 15;
  $229 = (($x) + ($$sum4<<2)|0);
  $230 = +HEAPF32[$229>>2];
  $231 = $228 - $230;
  $232 = $225 + $223;
  HEAPF32[$222>>2] = $232;
  $233 = $230 + $228;
  HEAPF32[$227>>2] = $233;
  HEAPF32[$224>>2] = $226;
  HEAPF32[$229>>2] = $231;
  $$sum5 = $j$134 | 28;
  $234 = (($x) + ($$sum5<<2)|0);
  $235 = +HEAPF32[$234>>2];
  $$sum6 = $j$134 | 12;
  $236 = (($x) + ($$sum6<<2)|0);
  $237 = +HEAPF32[$236>>2];
  $238 = $235 - $237;
  $$sum7 = $j$134 | 29;
  $239 = (($x) + ($$sum7<<2)|0);
  $240 = +HEAPF32[$239>>2];
  $$sum8 = $j$134 | 13;
  $241 = (($x) + ($$sum8<<2)|0);
  $242 = +HEAPF32[$241>>2];
  $243 = $240 - $242;
  $244 = $237 + $235;
  HEAPF32[$234>>2] = $244;
  $245 = $242 + $240;
  HEAPF32[$239>>2] = $245;
  $246 = $238 * 0.92387950420379638;
  $247 = $243 * 0.38268342614173889;
  $248 = $246 - $247;
  HEAPF32[$236>>2] = $248;
  $249 = $238 * 0.38268342614173889;
  $250 = $243 * 0.92387950420379638;
  $251 = $250 + $249;
  HEAPF32[$241>>2] = $251;
  $$sum9 = $j$134 | 26;
  $252 = (($x) + ($$sum9<<2)|0);
  $253 = +HEAPF32[$252>>2];
  $$sum10 = $j$134 | 10;
  $254 = (($x) + ($$sum10<<2)|0);
  $255 = +HEAPF32[$254>>2];
  $256 = $253 - $255;
  $$sum11 = $j$134 | 27;
  $257 = (($x) + ($$sum11<<2)|0);
  $258 = +HEAPF32[$257>>2];
  $$sum12 = $j$134 | 11;
  $259 = (($x) + ($$sum12<<2)|0);
  $260 = +HEAPF32[$259>>2];
  $261 = $258 - $260;
  $262 = $255 + $253;
  HEAPF32[$252>>2] = $262;
  $263 = $260 + $258;
  HEAPF32[$257>>2] = $263;
  $264 = $256 - $261;
  $265 = $264 * 0.70710676908493042;
  HEAPF32[$254>>2] = $265;
  $266 = $261 + $256;
  $267 = $266 * 0.70710676908493042;
  HEAPF32[$259>>2] = $267;
  $$sum13 = $j$134 | 24;
  $268 = (($x) + ($$sum13<<2)|0);
  $269 = +HEAPF32[$268>>2];
  $$sum14 = $j$134 | 8;
  $270 = (($x) + ($$sum14<<2)|0);
  $271 = +HEAPF32[$270>>2];
  $272 = $269 - $271;
  $$sum15 = $j$134 | 25;
  $273 = (($x) + ($$sum15<<2)|0);
  $274 = +HEAPF32[$273>>2];
  $$sum16 = $j$134 | 9;
  $275 = (($x) + ($$sum16<<2)|0);
  $276 = +HEAPF32[$275>>2];
  $277 = $274 - $276;
  $278 = $271 + $269;
  HEAPF32[$268>>2] = $278;
  $279 = $276 + $274;
  HEAPF32[$273>>2] = $279;
  $280 = $272 * 0.38268342614173889;
  $281 = $277 * 0.92387950420379638;
  $282 = $280 - $281;
  $283 = $277 * 0.38268342614173889;
  $284 = $272 * 0.92387950420379638;
  $285 = $283 + $284;
  $$sum17 = $j$134 | 22;
  $286 = (($x) + ($$sum17<<2)|0);
  $287 = +HEAPF32[$286>>2];
  $$sum18 = $j$134 | 6;
  $288 = (($x) + ($$sum18<<2)|0);
  $289 = +HEAPF32[$288>>2];
  $290 = $287 - $289;
  $$sum19 = $j$134 | 7;
  $291 = (($x) + ($$sum19<<2)|0);
  $292 = +HEAPF32[$291>>2];
  $$sum20 = $j$134 | 23;
  $293 = (($x) + ($$sum20<<2)|0);
  $294 = +HEAPF32[$293>>2];
  $295 = $292 - $294;
  $296 = $289 + $287;
  HEAPF32[$286>>2] = $296;
  $297 = $294 + $292;
  HEAPF32[$293>>2] = $297;
  HEAPF32[$288>>2] = $295;
  HEAPF32[$291>>2] = $290;
  $$sum21 = $j$134 | 4;
  $298 = (($x) + ($$sum21<<2)|0);
  $299 = +HEAPF32[$298>>2];
  $$sum22 = $j$134 | 20;
  $300 = (($x) + ($$sum22<<2)|0);
  $301 = +HEAPF32[$300>>2];
  $302 = $299 - $301;
  $$sum23 = $j$134 | 5;
  $303 = (($x) + ($$sum23<<2)|0);
  $304 = +HEAPF32[$303>>2];
  $$sum24 = $j$134 | 21;
  $305 = (($x) + ($$sum24<<2)|0);
  $306 = +HEAPF32[$305>>2];
  $307 = $304 - $306;
  $308 = $301 + $299;
  HEAPF32[$300>>2] = $308;
  $309 = $306 + $304;
  HEAPF32[$305>>2] = $309;
  $310 = $307 * 0.92387950420379638;
  $311 = $302 * 0.38268342614173889;
  $312 = $310 + $311;
  $313 = $307 * 0.38268342614173889;
  $314 = $302 * 0.92387950420379638;
  $315 = $313 - $314;
  $$sum25 = $j$134 | 2;
  $316 = (($x) + ($$sum25<<2)|0);
  $317 = +HEAPF32[$316>>2];
  $$sum26 = $j$134 | 18;
  $318 = (($x) + ($$sum26<<2)|0);
  $319 = +HEAPF32[$318>>2];
  $320 = $317 - $319;
  $$sum27 = $j$134 | 3;
  $321 = (($x) + ($$sum27<<2)|0);
  $322 = +HEAPF32[$321>>2];
  $$sum28 = $j$134 | 19;
  $323 = (($x) + ($$sum28<<2)|0);
  $324 = +HEAPF32[$323>>2];
  $325 = $322 - $324;
  $326 = $319 + $317;
  HEAPF32[$318>>2] = $326;
  $327 = $324 + $322;
  HEAPF32[$323>>2] = $327;
  $328 = $325 + $320;
  $329 = $328 * 0.70710676908493042;
  $330 = $325 - $320;
  $331 = $330 * 0.70710676908493042;
  $332 = +HEAPF32[$221>>2];
  $$sum29 = $j$134 | 16;
  $333 = (($x) + ($$sum29<<2)|0);
  $334 = +HEAPF32[$333>>2];
  $335 = $332 - $334;
  $$sum30 = $j$134 | 1;
  $336 = (($x) + ($$sum30<<2)|0);
  $337 = +HEAPF32[$336>>2];
  $$sum31 = $j$134 | 17;
  $338 = (($x) + ($$sum31<<2)|0);
  $339 = +HEAPF32[$338>>2];
  $340 = $337 - $339;
  $341 = $334 + $332;
  HEAPF32[$333>>2] = $341;
  $342 = $339 + $337;
  HEAPF32[$338>>2] = $342;
  $343 = $340 * 0.38268342614173889;
  $344 = $335 * 0.92387950420379638;
  $345 = $343 + $344;
  $346 = $340 * 0.92387950420379638;
  $347 = $335 * 0.38268342614173889;
  $348 = $346 - $347;
  $349 = $348 - $285;
  $350 = $345 - $282;
  $351 = $345 + $282;
  $352 = $348 + $285;
  $353 = $350 + $349;
  $354 = $349 - $350;
  $355 = +HEAPF32[$259>>2];
  $356 = $331 - $355;
  $357 = +HEAPF32[$254>>2];
  $358 = $357 - $329;
  $359 = $357 + $329;
  $360 = $355 + $331;
  $361 = +HEAPF32[$236>>2];
  $362 = $361 - $312;
  $363 = +HEAPF32[$241>>2];
  $364 = $363 - $315;
  $365 = $361 + $312;
  $366 = $363 + $315;
  $367 = $362 - $364;
  $368 = $364 + $362;
  $369 = +HEAPF32[$224>>2];
  $370 = $369 - $295;
  $371 = +HEAPF32[$229>>2];
  $372 = $371 - $290;
  $373 = $295 + $369;
  $374 = $290 + $371;
  $375 = $370 + $356;
  $376 = $370 - $356;
  $377 = $367 + $353;
  $378 = $377 * 0.70710676908493042;
  $379 = $367 - $353;
  $380 = $379 * 0.70710676908493042;
  $381 = $378 + $375;
  HEAPF32[$288>>2] = $381;
  $382 = $375 - $378;
  HEAPF32[$298>>2] = $382;
  $383 = $368 - $354;
  $384 = $383 * 0.70710676908493042;
  $385 = $372 - $358;
  $386 = $384 + $376;
  HEAPF32[$221>>2] = $386;
  $387 = $376 - $384;
  HEAPF32[$316>>2] = $387;
  $388 = $368 + $354;
  $389 = $388 * 0.70710676908493042;
  $390 = $372 + $358;
  $391 = $385 + $380;
  HEAPF32[$321>>2] = $391;
  $392 = $385 - $380;
  HEAPF32[$336>>2] = $392;
  $393 = $390 + $389;
  HEAPF32[$291>>2] = $393;
  $394 = $390 - $389;
  HEAPF32[$303>>2] = $394;
  $395 = $373 + $359;
  $396 = $373 - $359;
  $397 = $351 + $365;
  $398 = $365 - $351;
  $399 = $395 + $397;
  HEAPF32[$224>>2] = $399;
  $400 = $395 - $397;
  HEAPF32[$236>>2] = $400;
  $401 = $366 - $352;
  $402 = $374 - $360;
  $403 = $396 + $401;
  HEAPF32[$270>>2] = $403;
  $404 = $396 - $401;
  HEAPF32[$254>>2] = $404;
  $405 = $366 + $352;
  $406 = $374 + $360;
  $407 = $402 + $398;
  HEAPF32[$259>>2] = $407;
  $408 = $402 - $398;
  HEAPF32[$275>>2] = $408;
  $409 = $406 + $405;
  HEAPF32[$229>>2] = $409;
  $410 = $406 - $405;
  HEAPF32[$241>>2] = $410;
  $411 = +HEAPF32[$273>>2];
  $412 = $342 - $411;
  $413 = +HEAPF32[$268>>2];
  $414 = $341 - $413;
  $415 = $413 + $341;
  $416 = $411 + $342;
  $417 = $414 + $412;
  $418 = $412 - $414;
  $419 = +HEAPF32[$323>>2];
  $420 = +HEAPF32[$257>>2];
  $421 = $419 - $420;
  $422 = +HEAPF32[$252>>2];
  $423 = +HEAPF32[$318>>2];
  $424 = $422 - $423;
  $425 = $423 + $422;
  $426 = $420 + $419;
  $427 = +HEAPF32[$234>>2];
  $428 = +HEAPF32[$300>>2];
  $429 = $427 - $428;
  $430 = +HEAPF32[$239>>2];
  $431 = +HEAPF32[$305>>2];
  $432 = $430 - $431;
  $433 = $428 + $427;
  $434 = $431 + $430;
  $435 = $429 - $432;
  $436 = $432 + $429;
  $437 = +HEAPF32[$222>>2];
  $438 = +HEAPF32[$286>>2];
  $439 = $437 - $438;
  $440 = +HEAPF32[$227>>2];
  $441 = +HEAPF32[$293>>2];
  $442 = $440 - $441;
  $443 = $438 + $437;
  $444 = $441 + $440;
  $445 = $439 + $421;
  $446 = $439 - $421;
  $447 = $435 + $417;
  $448 = $447 * 0.70710676908493042;
  $449 = $435 - $417;
  $450 = $449 * 0.70710676908493042;
  $451 = $448 + $445;
  HEAPF32[$286>>2] = $451;
  $452 = $445 - $448;
  HEAPF32[$300>>2] = $452;
  $453 = $436 - $418;
  $454 = $453 * 0.70710676908493042;
  $455 = $442 - $424;
  $456 = $454 + $446;
  HEAPF32[$333>>2] = $456;
  $457 = $446 - $454;
  HEAPF32[$318>>2] = $457;
  $458 = $436 + $418;
  $459 = $458 * 0.70710676908493042;
  $460 = $442 + $424;
  $461 = $455 + $450;
  HEAPF32[$323>>2] = $461;
  $462 = $455 - $450;
  HEAPF32[$338>>2] = $462;
  $463 = $460 + $459;
  HEAPF32[$293>>2] = $463;
  $464 = $460 - $459;
  HEAPF32[$305>>2] = $464;
  $465 = $443 + $425;
  $466 = $443 - $425;
  $467 = $433 + $415;
  $468 = $433 - $415;
  $469 = $465 + $467;
  HEAPF32[$222>>2] = $469;
  $470 = $465 - $467;
  HEAPF32[$234>>2] = $470;
  $471 = $434 - $416;
  $472 = $444 - $426;
  $473 = $466 + $471;
  HEAPF32[$268>>2] = $473;
  $474 = $466 - $471;
  HEAPF32[$252>>2] = $474;
  $475 = $434 + $416;
  $476 = $444 + $426;
  $477 = $472 + $468;
  HEAPF32[$257>>2] = $477;
  $478 = $472 - $468;
  HEAPF32[$273>>2] = $478;
  $479 = $476 + $475;
  HEAPF32[$227>>2] = $479;
  $480 = $476 - $475;
  HEAPF32[$239>>2] = $480;
  $481 = (($j$134) + 32)|0;
  $482 = ($481|0)<($points|0);
  if ($482) {
   $j$134 = $481;
  } else {
   break;
  }
 }
 return;
}
function _mdct_bitreverse($init$0$0$val,$init$0$2$val,$init$0$3$val,$x) {
 $init$0$0$val = $init$0$0$val|0;
 $init$0$2$val = $init$0$2$val|0;
 $init$0$3$val = $init$0$3$val|0;
 $x = $x|0;
 var $$sum = 0, $$sum1 = 0, $$sum2 = 0, $$sum3 = 0, $$sum4 = 0, $$sum5 = 0, $$sum6 = 0, $$sum7 = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0.0, $12 = 0.0, $13 = 0.0, $14 = 0.0, $15 = 0.0, $16 = 0.0, $17 = 0.0, $18 = 0, $19 = 0.0;
 var $2 = 0, $20 = 0.0, $21 = 0.0, $22 = 0.0, $23 = 0.0, $24 = 0.0, $25 = 0, $26 = 0.0, $27 = 0.0, $28 = 0.0, $29 = 0.0, $3 = 0, $30 = 0.0, $31 = 0.0, $32 = 0, $33 = 0.0, $34 = 0, $35 = 0.0, $36 = 0, $37 = 0;
 var $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0.0, $45 = 0, $46 = 0.0, $47 = 0.0, $48 = 0.0, $49 = 0.0, $5 = 0, $50 = 0.0, $51 = 0, $52 = 0.0, $53 = 0.0, $54 = 0, $55 = 0.0;
 var $56 = 0.0, $57 = 0.0, $58 = 0.0, $59 = 0.0, $6 = 0, $60 = 0.0, $61 = 0.0, $62 = 0.0, $63 = 0.0, $64 = 0.0, $65 = 0.0, $66 = 0, $67 = 0.0, $68 = 0.0, $69 = 0, $7 = 0, $70 = 0.0, $71 = 0, $72 = 0, $73 = 0;
 var $74 = 0, $75 = 0, $8 = 0, $9 = 0.0, $T$0 = 0, $bit$0 = 0, $w0$0 = 0, $w1$0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = $init$0$0$val >> 1;
 $1 = (($x) + ($0<<2)|0);
 $2 = (($init$0$2$val) + ($init$0$0$val<<2)|0);
 $T$0 = $2;$bit$0 = $init$0$3$val;$w0$0 = $x;$w1$0 = $1;
 while(1) {
  $3 = HEAP32[$bit$0>>2]|0;
  $$sum = (($3) + ($0))|0;
  $4 = (($x) + ($$sum<<2)|0);
  $5 = ((($bit$0)) + 4|0);
  $6 = HEAP32[$5>>2]|0;
  $$sum1 = (($6) + ($0))|0;
  $7 = (($x) + ($$sum1<<2)|0);
  $$sum2 = (($$sum) + 1)|0;
  $8 = (($x) + ($$sum2<<2)|0);
  $9 = +HEAPF32[$8>>2];
  $$sum3 = (($$sum1) + 1)|0;
  $10 = (($x) + ($$sum3<<2)|0);
  $11 = +HEAPF32[$10>>2];
  $12 = $9 - $11;
  $13 = +HEAPF32[$4>>2];
  $14 = +HEAPF32[$7>>2];
  $15 = $14 + $13;
  $16 = +HEAPF32[$T$0>>2];
  $17 = $15 * $16;
  $18 = ((($T$0)) + 4|0);
  $19 = +HEAPF32[$18>>2];
  $20 = $19 * $12;
  $21 = $20 + $17;
  $22 = $19 * $15;
  $23 = $16 * $12;
  $24 = $22 - $23;
  $25 = ((($w1$0)) + -16|0);
  $26 = $11 + $9;
  $27 = $26 * 0.5;
  $28 = $13 - $14;
  $29 = $28 * 0.5;
  $30 = $21 + $27;
  HEAPF32[$w0$0>>2] = $30;
  $31 = $27 - $21;
  $32 = ((($w1$0)) + -8|0);
  HEAPF32[$32>>2] = $31;
  $33 = $24 + $29;
  $34 = ((($w0$0)) + 4|0);
  HEAPF32[$34>>2] = $33;
  $35 = $24 - $29;
  $36 = ((($w1$0)) + -4|0);
  HEAPF32[$36>>2] = $35;
  $37 = ((($bit$0)) + 8|0);
  $38 = HEAP32[$37>>2]|0;
  $$sum4 = (($38) + ($0))|0;
  $39 = (($x) + ($$sum4<<2)|0);
  $40 = ((($bit$0)) + 12|0);
  $41 = HEAP32[$40>>2]|0;
  $$sum5 = (($41) + ($0))|0;
  $42 = (($x) + ($$sum5<<2)|0);
  $$sum6 = (($$sum4) + 1)|0;
  $43 = (($x) + ($$sum6<<2)|0);
  $44 = +HEAPF32[$43>>2];
  $$sum7 = (($$sum5) + 1)|0;
  $45 = (($x) + ($$sum7<<2)|0);
  $46 = +HEAPF32[$45>>2];
  $47 = $44 - $46;
  $48 = +HEAPF32[$39>>2];
  $49 = +HEAPF32[$42>>2];
  $50 = $49 + $48;
  $51 = ((($T$0)) + 8|0);
  $52 = +HEAPF32[$51>>2];
  $53 = $50 * $52;
  $54 = ((($T$0)) + 12|0);
  $55 = +HEAPF32[$54>>2];
  $56 = $55 * $47;
  $57 = $56 + $53;
  $58 = $55 * $50;
  $59 = $52 * $47;
  $60 = $58 - $59;
  $61 = $46 + $44;
  $62 = $61 * 0.5;
  $63 = $48 - $49;
  $64 = $63 * 0.5;
  $65 = $57 + $62;
  $66 = ((($w0$0)) + 8|0);
  HEAPF32[$66>>2] = $65;
  $67 = $62 - $57;
  HEAPF32[$25>>2] = $67;
  $68 = $60 + $64;
  $69 = ((($w0$0)) + 12|0);
  HEAPF32[$69>>2] = $68;
  $70 = $60 - $64;
  $71 = ((($w1$0)) + -12|0);
  HEAPF32[$71>>2] = $70;
  $72 = ((($T$0)) + 16|0);
  $73 = ((($bit$0)) + 16|0);
  $74 = ((($w0$0)) + 16|0);
  $75 = ($74>>>0)<($25>>>0);
  if ($75) {
   $T$0 = $72;$bit$0 = $73;$w0$0 = $74;$w1$0 = $25;
  } else {
   break;
  }
 }
 return;
}
function __vp_global_look($vi) {
 $vi = $vi|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($vi)) + 28|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 2868|0);
 $3 = (_calloc(1,36)|0);
 $4 = ((($vi)) + 4|0);
 $5 = HEAP32[$4>>2]|0;
 $6 = ((($3)) + 4|0);
 HEAP32[$6>>2] = $5;
 HEAPF32[$3>>2] = -9999.0;
 $7 = ((($3)) + 8|0);
 HEAP32[$7>>2] = $2;
 return ($3|0);
}
function __vp_global_free($look) {
 $look = $look|0;
 var $0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ($look|0)==(0|0);
 if ($0) {
  return;
 }
 _free($look);
 return;
}
function __vi_psy_free($i) {
 $i = $i|0;
 var $0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ($i|0)==(0|0);
 if (!($0)) {
  _free($i);
 }
 return;
}
function __vp_psy_init($p,$vi,$gi,$n,$rate) {
 $p = $p|0;
 $vi = $vi|0;
 $gi = $gi|0;
 $n = $n|0;
 $rate = $rate|0;
 var $$inv = 0, $$lcssa = 0, $$lcssa85 = 0, $$not = 0, $$not75 = 0, $$phi$trans$insert = 0, $$phi$trans$insert52 = 0, $$pre = 0, $$pre$phiZ2D = 0.0, $$pre51 = 0, $$pre53 = 0, $$pre54 = 0.0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0.0, $103 = 0, $104 = 0;
 var $105 = 0, $106 = 0.0, $107 = 0, $108 = 0.0, $109 = 0.0, $11 = 0.0, $110 = 0.0, $111 = 0.0, $112 = 0.0, $113 = 0, $114 = 0.0, $115 = 0.0, $116 = 0.0, $117 = 0.0, $118 = 0.0, $119 = 0.0, $12 = 0.0, $120 = 0.0, $121 = 0.0, $122 = 0.0;
 var $123 = 0.0, $124 = 0, $125 = 0, $126 = 0.0, $127 = 0.0, $128 = 0.0, $129 = 0, $13 = 0.0, $130 = 0.0, $131 = 0.0, $132 = 0.0, $133 = 0.0, $134 = 0.0, $135 = 0, $136 = 0.0, $137 = 0.0, $138 = 0.0, $139 = 0.0, $14 = 0.0, $140 = 0.0;
 var $141 = 0.0, $142 = 0.0, $143 = 0.0, $144 = 0.0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0.0, $150 = 0, $151 = 0, $152 = 0, $153 = 0, $154 = 0.0, $155 = 0.0, $156 = 0.0, $157 = 0.0, $158 = 0.0, $159 = 0;
 var $16 = 0.0, $160 = 0.0, $161 = 0.0, $162 = 0.0, $163 = 0.0, $164 = 0.0, $165 = 0.0, $166 = 0.0, $167 = 0.0, $168 = 0.0, $169 = 0.0, $17 = 0.0, $170 = 0.0, $171 = 0.0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0;
 var $178 = 0, $179 = 0, $18 = 0.0, $180 = 0.0, $181 = 0.0, $182 = 0.0, $183 = 0.0, $184 = 0.0, $185 = 0.0, $186 = 0.0, $187 = 0.0, $188 = 0.0, $189 = 0.0, $19 = 0.0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0.0, $195 = 0.0;
 var $196 = 0, $197 = 0.0, $198 = 0, $199 = 0.0, $2 = 0.0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0, $206 = 0, $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0.0, $211 = 0.0, $212 = 0.0;
 var $213 = 0.0, $214 = 0.0, $215 = 0.0, $216 = 0.0, $217 = 0.0, $218 = 0, $219 = 0, $22 = 0.0, $220 = 0.0, $221 = 0.0, $222 = 0.0, $223 = 0.0, $224 = 0, $225 = 0, $226 = 0.0, $227 = 0.0, $228 = 0.0, $229 = 0, $23 = 0.0, $230 = 0.0;
 var $231 = 0.0, $232 = 0.0, $233 = 0.0, $234 = 0.0, $235 = 0, $236 = 0, $237 = 0.0, $238 = 0.0, $239 = 0.0, $24 = 0.0, $240 = 0, $241 = 0.0, $242 = 0.0, $243 = 0.0, $244 = 0.0, $245 = 0.0, $246 = 0, $247 = 0, $248 = 0.0, $249 = 0.0;
 var $25 = 0.0, $250 = 0.0, $251 = 0, $252 = 0.0, $253 = 0.0, $254 = 0.0, $255 = 0.0, $256 = 0.0, $257 = 0, $258 = 0, $26 = 0, $27 = 0, $28 = 0.0, $29 = 0.0, $3 = 0.0, $30 = 0.0, $31 = 0.0, $32 = 0.0, $33 = 0.0, $34 = 0.0;
 var $35 = 0.0, $36 = 0.0, $37 = 0.0, $38 = 0.0, $39 = 0, $4 = 0.0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0.0, $50 = 0, $51 = 0, $52 = 0;
 var $53 = 0, $54 = 0, $55 = 0, $56 = 0.0, $57 = 0.0, $58 = 0, $59 = 0, $6 = 0.0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0.0, $66 = 0.0, $67 = 0.0, $68 = 0.0, $69 = 0.0, $7 = 0.0, $70 = 0.0;
 var $71 = 0.0, $72 = 0, $73 = 0, $74 = 0, $75 = 0.0, $76 = 0, $77 = 0.0, $78 = 0.0, $79 = 0, $8 = 0.0, $80 = 0.0, $81 = 0.0, $82 = 0, $83 = 0, $84 = 0, $85 = 0.0, $86 = 0, $87 = 0.0, $88 = 0, $89 = 0;
 var $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $base$032 = 0.0, $brmerge = 0, $exitcond = 0, $exitcond46 = 0, $exitcond47 = 0, $exitcond48 = 0, $exitcond50 = 0, $halfoc$0 = 0.0, $halfoc$1 = 0.0;
 var $hi$024 = 0, $hi$1$lcssa = 0, $hi$120 = 0, $i$0$ph$ph74 = 0, $i$070 = 0, $i$070$lcssa = 0, $i$126 = 0, $i$212 = 0, $i$410 = 0, $j$0$ph$ph$lcssa = 0, $j$0$ph$ph73 = 0, $j$133 = 0, $j$328 = 0, $lo$025 = 0, $lo$1$lcssa = 0, $lo$115 = 0, $umax = 0, dest = 0, label = 0, sp = 0;
 var stop = 0;
 sp = STACKTOP;
 dest=$p; stop=dest+48|0; do { HEAP32[dest>>2]=0|0; dest=dest+4|0; } while ((dest|0) < (stop|0));
 $0 = HEAP32[$gi>>2]|0;
 $1 = ((($p)) + 36|0);
 HEAP32[$1>>2] = $0;
 $2 = (+($0|0));
 $3 = $2 * 8.0;
 $4 = $3;
 $5 = (+Math_log((+$4)));
 $6 = $5 * 1.4426950408889634;
 $7 = (+_rint($6));
 $8 = $7 + -1.0;
 $9 = (~~(($8)));
 $10 = ((($p)) + 32|0);
 HEAP32[$10>>2] = $9;
 $11 = (+($rate|0));
 $12 = $11 * 0.25;
 $13 = $12;
 $14 = $13 * 0.5;
 $15 = (+($n|0));
 $16 = $14 / $15;
 $17 = (+Math_log((+$16)));
 $18 = $17 * 1.4426950216293335;
 $19 = $18 + -5.9657840728759766;
 $20 = (($9) + 1)|0;
 $21 = 1 << $20;
 $22 = (+($21|0));
 $23 = $22 * $19;
 $24 = (+($0|0));
 $25 = $23 - $24;
 $26 = (~~(($25)));
 $27 = ((($p)) + 28|0);
 HEAP32[$27>>2] = $26;
 $28 = (+($n|0));
 $29 = $28 + 0.25;
 $30 = $29 * $11;
 $31 = $30;
 $32 = $31 * 0.5;
 $33 = $32 / $15;
 $34 = (+Math_log((+$33)));
 $35 = $34 * 1.4426950216293335;
 $36 = $35 + -5.9657840728759766;
 $37 = $22 * $36;
 $38 = $37 + 0.5;
 $39 = (~~(($38)));
 $40 = (1 - ($26))|0;
 $41 = (($40) + ($39))|0;
 $42 = ((($p)) + 40|0);
 HEAP32[$42>>2] = $41;
 $43 = $n << 2;
 $44 = (_malloc($43)|0);
 $45 = ((($p)) + 16|0);
 HEAP32[$45>>2] = $44;
 $46 = (_malloc($43)|0);
 $47 = ((($p)) + 20|0);
 HEAP32[$47>>2] = $46;
 $48 = (_malloc($43)|0);
 $49 = ((($p)) + 24|0);
 HEAP32[$49>>2] = $48;
 $50 = ((($p)) + 4|0);
 HEAP32[$50>>2] = $vi;
 HEAP32[$p>>2] = $n;
 $51 = ((($p)) + 44|0);
 HEAP32[$51>>2] = $rate;
 $52 = ((($p)) + 48|0);
 HEAPF32[$52>>2] = 1.0;
 $53 = ($rate|0)<(26000);
 do {
  if ($53) {
   HEAPF32[$52>>2] = 0.0;
  } else {
   $54 = ($rate|0)<(38000);
   if ($54) {
    HEAPF32[$52>>2] = 0.93999999761581421;
    break;
   }
   $55 = ($rate|0)>(46000);
   if ($55) {
    HEAPF32[$52>>2] = 1.2749999761581421;
   }
  }
 } while(0);
 $56 = $15 * 2.0;
 $57 = (+($rate|0));
 $58 = ($n|0)>(0);
 $62 = $58;$i$0$ph$ph74 = 0;$j$0$ph$ph73 = 0;
 L9: while(1) {
  $$not75 = $62 ^ 1;
  $i$070 = $i$0$ph$ph74;
  while(1) {
   $64 = (($i$070) + 1)|0;
   $65 = (+($64|0));
   $66 = $65 * 0.08664337545633316;
   $67 = $66 + 2.7488713472395148;
   $68 = (+Math_exp((+$67)));
   $69 = $56 * $68;
   $70 = $69 / $57;
   $71 = (+_rint($70));
   $72 = (~~(($71)));
   $$not = ($72|0)<=($j$0$ph$ph73|0);
   $brmerge = $$not | $$not75;
   if (!($brmerge)) {
    $$lcssa = $64;$$lcssa85 = $72;$i$070$lcssa = $i$070;
    break;
   }
   $73 = ($64|0)<(87);
   if ($73) {
    $i$070 = $64;
   } else {
    $j$0$ph$ph$lcssa = $j$0$ph$ph73;
    break L9;
   }
  }
  $74 = (1272 + ($i$070$lcssa<<2)|0);
  $75 = +HEAPF32[$74>>2];
  $76 = (1272 + ($$lcssa<<2)|0);
  $77 = +HEAPF32[$76>>2];
  $78 = $77 - $75;
  $79 = (($$lcssa85) - ($j$0$ph$ph73))|0;
  $80 = (+($79|0));
  $81 = $78 / $80;
  $82 = (($j$0$ph$ph73) - ($$lcssa85))|0;
  $83 = (($j$0$ph$ph73) - ($n))|0;
  $84 = ($82>>>0)>($83>>>0);
  $umax = $84 ? $82 : $83;
  $59 = (($j$0$ph$ph73) - ($umax))|0;
  $base$032 = $75;$j$133 = $j$0$ph$ph73;
  while(1) {
   $85 = $base$032 + 100.0;
   $86 = (($44) + ($j$133<<2)|0);
   HEAPF32[$86>>2] = $85;
   $87 = $base$032 + $81;
   $88 = (($j$133) + 1)|0;
   $exitcond50 = ($88|0)==($59|0);
   if ($exitcond50) {
    break;
   } else {
    $base$032 = $87;$j$133 = $88;
   }
  }
  $60 = ($59|0)<($n|0);
  $61 = ($$lcssa|0)<(87);
  if ($61) {
   $62 = $60;$i$0$ph$ph74 = $$lcssa;$j$0$ph$ph73 = $59;
  } else {
   $j$0$ph$ph$lcssa = $59;
   break;
  }
 }
 $63 = ($j$0$ph$ph$lcssa|0)<($n|0);
 if ($63) {
  $j$328 = $j$0$ph$ph$lcssa;
  while(1) {
   $97 = (($j$328) + -1)|0;
   $98 = (($44) + ($97<<2)|0);
   $99 = HEAP32[$98>>2]|0;
   $100 = (($44) + ($j$328<<2)|0);
   HEAP32[$100>>2] = $99;
   $101 = (($j$328) + 1)|0;
   $exitcond48 = ($101|0)==($n|0);
   if ($exitcond48) {
    break;
   } else {
    $j$328 = $101;
   }
  }
 }
 $89 = ($n|0)>(0);
 if ($89) {
  $90 = $n << 1;
  $91 = (($rate|0) / ($90|0))&-1;
  $92 = ((($vi)) + 120|0);
  $93 = HEAP32[$92>>2]|0;
  $94 = ((($vi)) + 124|0);
  $95 = ((($vi)) + 116|0);
  $96 = ((($vi)) + 112|0);
  $hi$024 = 1;$i$126 = 0;$lo$025 = -99;
  while(1) {
   $107 = Math_imul($91, $i$126)|0;
   $108 = (+($107|0));
   $109 = $108 * 7.3999998858198524E-4;
   $110 = $109;
   $111 = (+Math_atan((+$110)));
   $112 = $111 * 13.100000381469727;
   $113 = Math_imul($107, $107)|0;
   $114 = (+($113|0));
   $115 = $114 * 1.8499999754340024E-8;
   $116 = $115;
   $117 = (+Math_atan((+$116)));
   $118 = $117 * 2.2400000095367432;
   $119 = $118 + $112;
   $120 = $108 * 9.9999997473787516E-5;
   $121 = $120;
   $122 = $119 + $121;
   $123 = $122;
   $124 = (($93) + ($lo$025))|0;
   $125 = ($124|0)<($i$126|0);
   L27: do {
    if ($125) {
     $126 = +HEAPF32[$96>>2];
     $127 = $123 - $126;
     $128 = $127;
     $lo$115 = $lo$025;
     while(1) {
      $129 = Math_imul($lo$115, $91)|0;
      $130 = (+($129|0));
      $131 = $130 * 7.3999998858198524E-4;
      $132 = $131;
      $133 = (+Math_atan((+$132)));
      $134 = $133 * 13.100000381469727;
      $135 = Math_imul($129, $129)|0;
      $136 = (+($135|0));
      $137 = $136 * 1.8499999754340024E-8;
      $138 = $137;
      $139 = (+Math_atan((+$138)));
      $140 = $139 * 2.2400000095367432;
      $141 = $130 * 9.9999997473787516E-5;
      $142 = $141;
      $143 = $134 + $142;
      $144 = $143 + $140;
      $145 = $144 < $128;
      if (!($145)) {
       $lo$1$lcssa = $lo$115;
       break L27;
      }
      $149 = (($lo$115) + 1)|0;
      $150 = (($93) + ($149))|0;
      $151 = ($150|0)<($i$126|0);
      if ($151) {
       $lo$115 = $149;
      } else {
       $lo$1$lcssa = $149;
       break;
      }
     }
    } else {
     $lo$1$lcssa = $lo$025;
    }
   } while(0);
   $146 = ($hi$024|0)>($n|0);
   L33: do {
    if ($146) {
     $hi$1$lcssa = $hi$024;
    } else {
     $147 = HEAP32[$94>>2]|0;
     $148 = (($147) + ($i$126))|0;
     $hi$120 = $hi$024;
     while(1) {
      $152 = ($hi$120|0)<($148|0);
      if (!($152)) {
       $153 = Math_imul($hi$120, $91)|0;
       $154 = (+($153|0));
       $155 = $154 * 7.3999998858198524E-4;
       $156 = $155;
       $157 = (+Math_atan((+$156)));
       $158 = $157 * 13.100000381469727;
       $159 = Math_imul($153, $153)|0;
       $160 = (+($159|0));
       $161 = $160 * 1.8499999754340024E-8;
       $162 = $161;
       $163 = (+Math_atan((+$162)));
       $164 = $163 * 2.2400000095367432;
       $165 = $154 * 9.9999997473787516E-5;
       $166 = $165;
       $167 = $158 + $166;
       $168 = $167 + $164;
       $169 = +HEAPF32[$95>>2];
       $170 = $169 + $123;
       $171 = $170;
       $172 = $168 < $171;
       if (!($172)) {
        $hi$1$lcssa = $hi$120;
        break L33;
       }
      }
      $173 = (($hi$120) + 1)|0;
      $174 = ($hi$120|0)<($n|0);
      if ($174) {
       $hi$120 = $173;
      } else {
       $hi$1$lcssa = $173;
       break;
      }
     }
    }
   } while(0);
   $175 = $lo$1$lcssa << 16;
   $176 = (($175) + -65537)|0;
   $177 = (($176) + ($hi$1$lcssa))|0;
   $178 = (($48) + ($i$126<<2)|0);
   HEAP32[$178>>2] = $177;
   $179 = (($i$126) + 1)|0;
   $exitcond47 = ($179|0)==($n|0);
   if ($exitcond47) {
    break;
   } else {
    $hi$024 = $hi$1$lcssa;$i$126 = $179;$lo$025 = $lo$1$lcssa;
   }
  }
  if ($89) {
   $102 = $57 * 0.5;
   $103 = HEAP32[$10>>2]|0;
   $104 = (($103) + 1)|0;
   $105 = 1 << $104;
   $106 = (+($105|0));
   $i$212 = 0;
   while(1) {
    $180 = (+($i$212|0));
    $181 = $180 + 0.25;
    $182 = $181;
    $183 = $102 * $182;
    $184 = $183 / $15;
    $185 = (+Math_log((+$184)));
    $186 = $185 * 1.4426950216293335;
    $187 = $186 + -5.9657840728759766;
    $188 = $106 * $187;
    $189 = $188 + 0.5;
    $190 = (~~(($189)));
    $191 = (($46) + ($i$212<<2)|0);
    HEAP32[$191>>2] = $190;
    $192 = (($i$212) + 1)|0;
    $exitcond46 = ($192|0)==($n|0);
    if ($exitcond46) {
     $$pre$phiZ2D = $102;
     break;
    } else {
     $i$212 = $192;
    }
   }
  } else {
   label = 19;
  }
 } else {
  label = 19;
 }
 if ((label|0) == 19) {
  $$pre54 = $57 * 0.5;
  $$pre$phiZ2D = $$pre54;
 }
 $193 = ((($vi)) + 36|0);
 $194 = $$pre$phiZ2D / $15;
 $195 = $194;
 $196 = ((($vi)) + 24|0);
 $197 = +HEAPF32[$196>>2];
 $198 = ((($vi)) + 28|0);
 $199 = +HEAPF32[$198>>2];
 $200 = (_setup_tone_curves($193,$195,$n,$197,$199)|0);
 $201 = ((($p)) + 8|0);
 HEAP32[$201>>2] = $200;
 $202 = (_malloc(12)|0);
 $203 = ((($p)) + 12|0);
 HEAP32[$203>>2] = $202;
 $204 = (_malloc($43)|0);
 HEAP32[$202>>2] = $204;
 $205 = (_malloc($43)|0);
 $206 = ((($202)) + 4|0);
 HEAP32[$206>>2] = $205;
 $207 = (_malloc($43)|0);
 $208 = ((($202)) + 8|0);
 HEAP32[$208>>2] = $207;
 if (!($89)) {
  return;
 }
 $209 = HEAP32[$50>>2]|0;
 $$pre = HEAP32[$202>>2]|0;
 $$phi$trans$insert = ((($202)) + 4|0);
 $$pre51 = HEAP32[$$phi$trans$insert>>2]|0;
 $$phi$trans$insert52 = ((($202)) + 8|0);
 $$pre53 = HEAP32[$$phi$trans$insert52>>2]|0;
 $i$410 = 0;
 while(1) {
  $210 = (+($i$410|0));
  $211 = $210 + 0.5;
  $212 = $211 * $57;
  $213 = $212 / $56;
  $214 = (+Math_log((+$213)));
  $215 = $214 * 2.885390043258667;
  $216 = $215 + -11.931568145751953;
  $217 = $216;
  $218 = $217 < 0.0;
  $halfoc$0 = $218 ? 0.0 : $217;
  $$inv = $halfoc$0 >= 16.0;
  $halfoc$1 = $$inv ? 16.0 : $halfoc$0;
  $219 = (~~(($halfoc$1)));
  $220 = (+($219|0));
  $221 = $halfoc$1 - $220;
  $222 = $221;
  $223 = 1.0 - $222;
  $224 = (($219) + 1)|0;
  $225 = (((($209)) + 132|0) + ($219<<2)|0);
  $226 = +HEAPF32[$225>>2];
  $227 = $226;
  $228 = $227 * $223;
  $229 = (((($209)) + 132|0) + ($224<<2)|0);
  $230 = +HEAPF32[$229>>2];
  $231 = $230 * $221;
  $232 = $231;
  $233 = $232 + $228;
  $234 = $233;
  $235 = (($$pre) + ($i$410<<2)|0);
  HEAPF32[$235>>2] = $234;
  $236 = (((($209)) + 200|0) + ($219<<2)|0);
  $237 = +HEAPF32[$236>>2];
  $238 = $237;
  $239 = $238 * $223;
  $240 = (((($209)) + 200|0) + ($224<<2)|0);
  $241 = +HEAPF32[$240>>2];
  $242 = $241 * $221;
  $243 = $242;
  $244 = $243 + $239;
  $245 = $244;
  $246 = (($$pre51) + ($i$410<<2)|0);
  HEAPF32[$246>>2] = $245;
  $247 = (((($209)) + 268|0) + ($219<<2)|0);
  $248 = +HEAPF32[$247>>2];
  $249 = $248;
  $250 = $249 * $223;
  $251 = (((($209)) + 268|0) + ($224<<2)|0);
  $252 = +HEAPF32[$251>>2];
  $253 = $252 * $221;
  $254 = $253;
  $255 = $254 + $250;
  $256 = $255;
  $257 = (($$pre53) + ($i$410<<2)|0);
  HEAPF32[$257>>2] = $256;
  $258 = (($i$410) + 1)|0;
  $exitcond = ($258|0)==($n|0);
  if ($exitcond) {
   break;
  } else {
   $i$410 = $258;
  }
 }
 return;
}
function __vp_psy_clear($p) {
 $p = $p|0;
 var $$pre = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0;
 var $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0;
 var $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0;
 var $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $7 = 0, $8 = 0, $9 = 0, $exitcond = 0, $i$05 = 0, dest = 0, label = 0, sp = 0, stop = 0;
 sp = STACKTOP;
 $0 = ($p|0)==(0|0);
 if ($0) {
  return;
 }
 $1 = ((($p)) + 16|0);
 $2 = HEAP32[$1>>2]|0;
 $3 = ($2|0)==(0|0);
 if (!($3)) {
  _free($2);
 }
 $4 = ((($p)) + 20|0);
 $5 = HEAP32[$4>>2]|0;
 $6 = ($5|0)==(0|0);
 if (!($6)) {
  _free($5);
 }
 $7 = ((($p)) + 24|0);
 $8 = HEAP32[$7>>2]|0;
 $9 = ($8|0)==(0|0);
 if (!($9)) {
  _free($8);
 }
 $10 = ((($p)) + 8|0);
 $11 = HEAP32[$10>>2]|0;
 $12 = ($11|0)==(0|0);
 if (!($12)) {
  $14 = $11;$i$05 = 0;
  while(1) {
   $13 = (($14) + ($i$05<<2)|0);
   $15 = HEAP32[$13>>2]|0;
   $16 = HEAP32[$15>>2]|0;
   _free($16);
   $17 = HEAP32[$10>>2]|0;
   $18 = (($17) + ($i$05<<2)|0);
   $19 = HEAP32[$18>>2]|0;
   $20 = ((($19)) + 4|0);
   $21 = HEAP32[$20>>2]|0;
   _free($21);
   $22 = HEAP32[$10>>2]|0;
   $23 = (($22) + ($i$05<<2)|0);
   $24 = HEAP32[$23>>2]|0;
   $25 = ((($24)) + 8|0);
   $26 = HEAP32[$25>>2]|0;
   _free($26);
   $27 = HEAP32[$10>>2]|0;
   $28 = (($27) + ($i$05<<2)|0);
   $29 = HEAP32[$28>>2]|0;
   $30 = ((($29)) + 12|0);
   $31 = HEAP32[$30>>2]|0;
   _free($31);
   $32 = HEAP32[$10>>2]|0;
   $33 = (($32) + ($i$05<<2)|0);
   $34 = HEAP32[$33>>2]|0;
   $35 = ((($34)) + 16|0);
   $36 = HEAP32[$35>>2]|0;
   _free($36);
   $37 = HEAP32[$10>>2]|0;
   $38 = (($37) + ($i$05<<2)|0);
   $39 = HEAP32[$38>>2]|0;
   $40 = ((($39)) + 20|0);
   $41 = HEAP32[$40>>2]|0;
   _free($41);
   $42 = HEAP32[$10>>2]|0;
   $43 = (($42) + ($i$05<<2)|0);
   $44 = HEAP32[$43>>2]|0;
   $45 = ((($44)) + 24|0);
   $46 = HEAP32[$45>>2]|0;
   _free($46);
   $47 = HEAP32[$10>>2]|0;
   $48 = (($47) + ($i$05<<2)|0);
   $49 = HEAP32[$48>>2]|0;
   $50 = ((($49)) + 28|0);
   $51 = HEAP32[$50>>2]|0;
   _free($51);
   $52 = HEAP32[$10>>2]|0;
   $53 = (($52) + ($i$05<<2)|0);
   $54 = HEAP32[$53>>2]|0;
   _free($54);
   $55 = (($i$05) + 1)|0;
   $exitcond = ($55|0)==(17);
   if ($exitcond) {
    break;
   }
   $$pre = HEAP32[$10>>2]|0;
   $14 = $$pre;$i$05 = $55;
  }
  $56 = HEAP32[$10>>2]|0;
  _free($56);
 }
 $57 = ((($p)) + 12|0);
 $58 = HEAP32[$57>>2]|0;
 $59 = ($58|0)==(0|0);
 if (!($59)) {
  $60 = HEAP32[$58>>2]|0;
  _free($60);
  $61 = HEAP32[$57>>2]|0;
  $62 = ((($61)) + 4|0);
  $63 = HEAP32[$62>>2]|0;
  _free($63);
  $64 = HEAP32[$57>>2]|0;
  $65 = ((($64)) + 8|0);
  $66 = HEAP32[$65>>2]|0;
  _free($66);
  $67 = HEAP32[$57>>2]|0;
  _free($67);
 }
 dest=$p; stop=dest+52|0; do { HEAP32[dest>>2]=0|0; dest=dest+4|0; } while ((dest|0) < (stop|0));
 return;
}
function __vp_noisemask($p,$logmdct,$logmask) {
 $p = $p|0;
 $logmdct = $logmdct|0;
 $logmask = $logmask|0;
 var $$ = 0, $$$ = 0, $$alloca_mul = 0, $0 = 0, $1 = 0, $10 = 0.0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0.0, $21 = 0, $22 = 0.0, $23 = 0.0;
 var $24 = 0, $25 = 0, $26 = 0.0, $27 = 0.0, $28 = 0.0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0.0, $34 = 0, $35 = 0.0, $36 = 0.0, $37 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0.0, $8 = 0;
 var $9 = 0.0, $exitcond = 0, $exitcond10 = 0, $exitcond9 = 0, $i$05 = 0, $i$12 = 0, $i$21 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = HEAP32[$p>>2]|0;
 $1 = $0 << 2;
 $$alloca_mul = $1;
 $2 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul)|0)+15)&-16)|0;;
 $3 = ((($p)) + 24|0);
 $4 = HEAP32[$3>>2]|0;
 _bark_noise_hybridmp($0,$4,$logmdct,$logmask,140.0,-1);
 $5 = ($0|0)>(0);
 if ($5) {
  $i$05 = 0;
  while(1) {
   $6 = (($logmdct) + ($i$05<<2)|0);
   $7 = +HEAPF32[$6>>2];
   $8 = (($logmask) + ($i$05<<2)|0);
   $9 = +HEAPF32[$8>>2];
   $10 = $7 - $9;
   $11 = (($2) + ($i$05<<2)|0);
   HEAPF32[$11>>2] = $10;
   $12 = (($i$05) + 1)|0;
   $exitcond10 = ($12|0)==($0|0);
   if ($exitcond10) {
    break;
   } else {
    $i$05 = $12;
   }
  }
 }
 $13 = HEAP32[$3>>2]|0;
 $14 = ((($p)) + 4|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = ((($15)) + 128|0);
 $17 = HEAP32[$16>>2]|0;
 _bark_noise_hybridmp($0,$13,$2,$logmask,0.0,$17);
 if ($5) {
  $i$12 = 0;
 } else {
  STACKTOP = sp;return;
 }
 while(1) {
  $19 = (($logmdct) + ($i$12<<2)|0);
  $20 = +HEAPF32[$19>>2];
  $21 = (($2) + ($i$12<<2)|0);
  $22 = +HEAPF32[$21>>2];
  $23 = $20 - $22;
  HEAPF32[$21>>2] = $23;
  $24 = (($i$12) + 1)|0;
  $exitcond9 = ($24|0)==($0|0);
  if ($exitcond9) {
   break;
  } else {
   $i$12 = $24;
  }
 }
 if (!($5)) {
  STACKTOP = sp;return;
 }
 $18 = HEAP32[$14>>2]|0;
 $i$21 = 0;
 while(1) {
  $25 = (($logmask) + ($i$21<<2)|0);
  $26 = +HEAPF32[$25>>2];
  $27 = $26;
  $28 = $27 + 0.5;
  $29 = (~~(($28)));
  $30 = ($29|0)>(39);
  $$ = $30 ? 39 : $29;
  $31 = ($$|0)<(0);
  $$$ = $31 ? 0 : $$;
  $32 = (($2) + ($i$21<<2)|0);
  $33 = +HEAPF32[$32>>2];
  $34 = (((($18)) + 336|0) + ($$$<<2)|0);
  $35 = +HEAPF32[$34>>2];
  $36 = $35 + $33;
  HEAPF32[$25>>2] = $36;
  $37 = (($i$21) + 1)|0;
  $exitcond = ($37|0)==($0|0);
  if ($exitcond) {
   break;
  } else {
   $i$21 = $37;
  }
 }
 STACKTOP = sp;return;
}
function __vp_tonemask($p,$logfft,$logmask,$global_specmax,$local_specmax) {
 $p = $p|0;
 $logfft = $logfft|0;
 $logmask = $logmask|0;
 $global_specmax = +$global_specmax;
 $local_specmax = +$local_specmax;
 var $$$$i = 0, $$$i = 0, $$alloca_mul = 0, $$in$i = 0, $$in28$i = 0, $$lcssa = 0, $$lcssa33 = 0, $$lcssa68 = 0.0, $$lcssa73 = 0, $$phi$trans$insert$i = 0, $$phi$trans$insert37$i = 0, $$pre = 0, $$pre$i = 0, $$pre$phiZ2D = 0, $$pre38$i = 0, $$sum$i$i = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0;
 var $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0.0, $116 = 0, $117 = 0, $118 = 0, $119 = 0;
 var $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0.0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0.0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0, $136 = 0, $137 = 0;
 var $138 = 0.0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0.0, $147 = 0, $148 = 0, $149 = 0.0, $15 = 0.0, $150 = 0, $151 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0;
 var $2 = 0, $20 = 0, $21 = 0.0, $22 = 0.0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0.0, $29 = 0.0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0.0, $37 = 0;
 var $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0.0, $46 = 0, $47 = 0.0, $48 = 0, $49 = 0.0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0;
 var $56 = 0, $57 = 0, $58 = 0.0, $59 = 0.0, $6 = 0, $60 = 0.0, $61 = 0.0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0.0, $71 = 0, $72 = 0.0, $73 = 0;
 var $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0.0, $8 = 0.0, $80 = 0, $81 = 0.0, $82 = 0.0, $83 = 0.0, $84 = 0.0, $85 = 0.0, $86 = 0.0, $87 = 0, $88 = 0, $89 = 0, $9 = 0.0, $90 = 0.0, $91 = 0.0;
 var $92 = 0, $93 = 0.0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $att$0 = 0.0, $exitcond = 0, $exitcond36 = 0, $i$02$i$i = 0, $i$020 = 0, $i$04$i = 0, $i$1$i = 0, $i$1$i$lcssa = 0, $i$1$ph$i = 0, $i$118 = 0, $linpos$0$lcssa$i = 0, $linpos$023$i = 0;
 var $linpos$1$lcssa$i = 0, $linpos$116$i16 = 0, $linpos$27$i = 0, $max$0$ph$i = 0.0, $max$0$ph$i$lcssa = 0.0, $minV$0$ph$i = 0.0, $minV$0$ph3$lcssa$i = 0.0, $minV$0$ph313$i = 0.0, $or$cond = 0, $or$cond$i = 0, $or$cond$i$i = 0, $pos$022$i = 0, $pos$1$lcssa$i = 0, $seedptr$01$i$i = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = HEAP32[$p>>2]|0;
 $1 = ((($p)) + 40|0);
 $2 = HEAP32[$1>>2]|0;
 $3 = $2 << 2;
 $$alloca_mul = $3;
 $4 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul)|0)+15)&-16)|0;;
 $5 = ((($p)) + 4|0);
 $6 = HEAP32[$5>>2]|0;
 $7 = ((($6)) + 4|0);
 $8 = +HEAPF32[$7>>2];
 $9 = $8 + $local_specmax;
 $10 = ($2|0)>(0);
 if ($10) {
  $i$020 = 0;
  while(1) {
   $11 = (($4) + ($i$020<<2)|0);
   HEAPF32[$11>>2] = -9999.0;
   $12 = (($i$020) + 1)|0;
   $13 = ($12|0)<($2|0);
   if ($13) {
    $i$020 = $12;
   } else {
    break;
   }
  }
 }
 $14 = ((($6)) + 8|0);
 $15 = +HEAPF32[$14>>2];
 $16 = $9 < $15;
 $att$0 = $16 ? $15 : $9;
 $17 = ($0|0)>(0);
 if ($17) {
  $18 = ((($p)) + 16|0);
  $19 = HEAP32[$18>>2]|0;
  $i$118 = 0;
  while(1) {
   $20 = (($19) + ($i$118<<2)|0);
   $21 = +HEAPF32[$20>>2];
   $22 = $21 + $att$0;
   $23 = (($logmask) + ($i$118<<2)|0);
   HEAPF32[$23>>2] = $22;
   $24 = (($i$118) + 1)|0;
   $exitcond36 = ($24|0)==($0|0);
   if ($exitcond36) {
    break;
   } else {
    $i$118 = $24;
   }
  }
  $25 = ((($p)) + 8|0);
  $26 = HEAP32[$25>>2]|0;
  $27 = ((($6)) + 496|0);
  $28 = +HEAPF32[$27>>2];
  $29 = $28 - $global_specmax;
  if ($17) {
   $30 = ((($p)) + 20|0);
   $31 = HEAP32[$30>>2]|0;
   $32 = ((($p)) + 32|0);
   $33 = ((($p)) + 36|0);
   $34 = ((($p)) + 28|0);
   $i$04$i = 0;
   while(1) {
    $35 = (($logfft) + ($i$04$i<<2)|0);
    $36 = +HEAPF32[$35>>2];
    $37 = (($31) + ($i$04$i<<2)|0);
    $38 = HEAP32[$37>>2]|0;
    $i$1$ph$i = $i$04$i;$max$0$ph$i = $36;
    L13: while(1) {
     $i$1$i = $i$1$ph$i;
     while(1) {
      $39 = (($i$1$i) + 1)|0;
      $40 = ($39|0)<($0|0);
      if (!($40)) {
       $$lcssa33 = 0;$$lcssa73 = $39;$i$1$i$lcssa = $i$1$i;$max$0$ph$i$lcssa = $max$0$ph$i;
       break L13;
      }
      $41 = (($31) + ($39<<2)|0);
      $42 = HEAP32[$41>>2]|0;
      $43 = ($42|0)==($38|0);
      if (!($43)) {
       $$lcssa33 = 1;$$lcssa73 = $39;$i$1$i$lcssa = $i$1$i;$max$0$ph$i$lcssa = $max$0$ph$i;
       break L13;
      }
      $44 = (($logfft) + ($39<<2)|0);
      $45 = +HEAPF32[$44>>2];
      $46 = $45 > $max$0$ph$i;
      if ($46) {
       $i$1$ph$i = $39;$max$0$ph$i = $45;
       continue L13;
      } else {
       $i$1$i = $39;
      }
     }
    }
    $47 = $max$0$ph$i$lcssa + 6.0;
    $48 = (($logmask) + ($i$1$i$lcssa<<2)|0);
    $49 = +HEAPF32[$48>>2];
    $50 = $47 > $49;
    if ($50) {
     $51 = HEAP32[$32>>2]|0;
     $52 = $38 >> $51;
     $53 = ($52|0)>(16);
     $$$i = $53 ? 16 : $52;
     $54 = ($$$i|0)<(0);
     $$$$i = $54 ? 0 : $$$i;
     $55 = (($26) + ($$$$i<<2)|0);
     $56 = HEAP32[$55>>2]|0;
     $57 = HEAP32[$33>>2]|0;
     $58 = $29 + $max$0$ph$i$lcssa;
     $59 = $58;
     $60 = $59 + -30.0;
     $61 = $60 * 0.10000000149011612;
     $62 = (~~(($61)));
     $63 = ($62|0)<(0);
     $64 = $63 ? 0 : $62;
     $65 = ($64|0)>(7);
     $66 = $65 ? 7 : $64;
     $67 = (($56) + ($66<<2)|0);
     $68 = HEAP32[$67>>2]|0;
     $69 = ((($68)) + 4|0);
     $70 = +HEAPF32[$69>>2];
     $71 = (~~(($70)));
     $72 = +HEAPF32[$68>>2];
     $73 = (~~(($72)));
     $74 = ($73|0)<($71|0);
     if ($74) {
      $75 = (($31) + ($i$1$i$lcssa<<2)|0);
      $76 = HEAP32[$75>>2]|0;
      $77 = HEAP32[$34>>2]|0;
      $78 = (($76) - ($77))|0;
      $79 = (+($78|0));
      $80 = $57 >> 1;
      $81 = (+($80|0));
      $82 = $72 + -16.0;
      $83 = (+($57|0));
      $84 = $82 * $83;
      $85 = $84 - $81;
      $86 = $85 + $79;
      $87 = (~~(($86)));
      $i$02$i$i = $73;$seedptr$01$i$i = $87;
      while(1) {
       $88 = ($seedptr$01$i$i|0)>(0);
       if ($88) {
        $$sum$i$i = (($i$02$i$i) + 2)|0;
        $89 = (($68) + ($$sum$i$i<<2)|0);
        $90 = +HEAPF32[$89>>2];
        $91 = $90 + $max$0$ph$i$lcssa;
        $92 = (($4) + ($seedptr$01$i$i<<2)|0);
        $93 = +HEAPF32[$92>>2];
        $94 = $93 < $91;
        if ($94) {
         HEAPF32[$92>>2] = $91;
        }
       }
       $95 = (($seedptr$01$i$i) + ($57))|0;
       $96 = ($95|0)<($2|0);
       $97 = (($i$02$i$i) + 1)|0;
       $98 = ($97|0)<($71|0);
       $or$cond$i$i = $98 & $96;
       if ($or$cond$i$i) {
        $i$02$i$i = $97;$seedptr$01$i$i = $95;
       } else {
        break;
       }
      }
     }
    }
    if ($$lcssa33) {
     $i$04$i = $$lcssa73;
    } else {
     $$pre$phiZ2D = $33;
     break;
    }
   }
  } else {
   label = 7;
  }
 } else {
  label = 7;
 }
 if ((label|0) == 7) {
  $$pre = ((($p)) + 36|0);
  $$pre$phiZ2D = $$pre;
 }
 $99 = HEAP32[$$pre$phiZ2D>>2]|0;
 _seed_chase($4,$99,$2);
 $100 = HEAP32[$p>>2]|0;
 $101 = ($100|0)>(1);
 L33: do {
  if ($101) {
   $102 = ((($p)) + 20|0);
   $103 = ((($p)) + 28|0);
   $104 = HEAP32[$102>>2]|0;
   $105 = HEAP32[$104>>2]|0;
   $106 = $99 >> 1;
   $107 = (($105) - ($106))|0;
   $108 = HEAP32[$103>>2]|0;
   $109 = (($107) - ($108))|0;
   $110 = HEAP32[$5>>2]|0;
   $111 = ((($110)) + 32|0);
   $117 = 1;$120 = $105;$linpos$023$i = 0;$pos$022$i = $109;
   while(1) {
    $114 = (($4) + ($pos$022$i<<2)|0);
    $115 = +HEAPF32[$114>>2];
    $116 = (($104) + ($117<<2)|0);
    $118 = HEAP32[$116>>2]|0;
    $119 = (($118) + ($120))|0;
    $121 = $119 >> 1;
    $122 = (($121) - ($108))|0;
    $123 = +HEAPF32[$111>>2];
    $124 = $115 > $123;
    $minV$0$ph$i = $124 ? $123 : $115;
    $125 = ($pos$022$i|0)<($122|0);
    L37: do {
     if ($125) {
      $$in$i = $pos$022$i;$minV$0$ph313$i = $minV$0$ph$i;
      while(1) {
       $126 = $minV$0$ph313$i == -9999.0;
       $$in28$i = $$in$i;
       while(1) {
        $127 = (($$in28$i) + 1)|0;
        $128 = (($4) + ($127<<2)|0);
        $129 = +HEAPF32[$128>>2];
        $130 = $129 > -9999.0;
        if ($130) {
         $131 = $129 < $minV$0$ph313$i;
         $or$cond$i = $126 | $131;
         if ($or$cond$i) {
          $$lcssa = $127;$$lcssa68 = $129;
          break;
         }
        } else {
         if ($126) {
          $$lcssa = $127;$$lcssa68 = $129;
          break;
         }
        }
        $132 = ($127|0)<($122|0);
        if ($132) {
         $$in28$i = $127;
        } else {
         $minV$0$ph3$lcssa$i = $minV$0$ph313$i;$pos$1$lcssa$i = $127;
         break L37;
        }
       }
       $133 = ($$lcssa|0)<($122|0);
       if ($133) {
        $$in$i = $$lcssa;$minV$0$ph313$i = $$lcssa68;
       } else {
        $minV$0$ph3$lcssa$i = $$lcssa68;$pos$1$lcssa$i = $$lcssa;
        break;
       }
      }
     } else {
      $minV$0$ph3$lcssa$i = $minV$0$ph$i;$pos$1$lcssa$i = $pos$022$i;
     }
    } while(0);
    $134 = (($pos$1$lcssa$i) + ($108))|0;
    $135 = ($linpos$023$i|0)>=($100|0);
    $136 = ($120|0)>($134|0);
    $or$cond = $135 | $136;
    L48: do {
     if ($or$cond) {
      $linpos$1$lcssa$i = $linpos$023$i;
     } else {
      $linpos$116$i16 = $linpos$023$i;
      while(1) {
       $137 = (($logmask) + ($linpos$116$i16<<2)|0);
       $138 = +HEAPF32[$137>>2];
       $139 = $138 < $minV$0$ph3$lcssa$i;
       if ($139) {
        HEAPF32[$137>>2] = $minV$0$ph3$lcssa$i;
       }
       $140 = (($linpos$116$i16) + 1)|0;
       $141 = ($140|0)<($100|0);
       if (!($141)) {
        $linpos$1$lcssa$i = $140;
        break L48;
       }
       $$phi$trans$insert37$i = (($104) + ($140<<2)|0);
       $$pre38$i = HEAP32[$$phi$trans$insert37$i>>2]|0;
       $142 = ($$pre38$i|0)>($134|0);
       if ($142) {
        $linpos$1$lcssa$i = $140;
        break;
       } else {
        $linpos$116$i16 = $140;
       }
      }
     }
    } while(0);
    $112 = (($linpos$1$lcssa$i) + 1)|0;
    $113 = ($112|0)<($100|0);
    if (!($113)) {
     $linpos$0$lcssa$i = $linpos$1$lcssa$i;
     break L33;
    }
    $$phi$trans$insert$i = (($104) + ($linpos$1$lcssa$i<<2)|0);
    $$pre$i = HEAP32[$$phi$trans$insert$i>>2]|0;
    $117 = $112;$120 = $$pre$i;$linpos$023$i = $linpos$1$lcssa$i;$pos$022$i = $pos$1$lcssa$i;
   }
  } else {
   $linpos$0$lcssa$i = 0;
  }
 } while(0);
 $143 = HEAP32[$1>>2]|0;
 $144 = (($143) + -1)|0;
 $145 = (($4) + ($144<<2)|0);
 $146 = +HEAPF32[$145>>2];
 $147 = ($linpos$0$lcssa$i|0)<($100|0);
 if ($147) {
  $linpos$27$i = $linpos$0$lcssa$i;
 } else {
  STACKTOP = sp;return;
 }
 while(1) {
  $148 = (($logmask) + ($linpos$27$i<<2)|0);
  $149 = +HEAPF32[$148>>2];
  $150 = $149 < $146;
  if ($150) {
   HEAPF32[$148>>2] = $146;
  }
  $151 = (($linpos$27$i) + 1)|0;
  $exitcond = ($151|0)==($100|0);
  if ($exitcond) {
   break;
  } else {
   $linpos$27$i = $151;
  }
 }
 STACKTOP = sp;return;
}
function __vp_offset_and_mix($p,$noise,$tone,$offset_select,$logmask,$mdct,$logmdct) {
 $p = $p|0;
 $noise = $noise|0;
 $tone = $tone|0;
 $offset_select = $offset_select|0;
 $logmask = $logmask|0;
 $mdct = $mdct|0;
 $logmdct = $logmdct|0;
 var $$val$0 = 0.0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0.0, $15 = 0.0, $16 = 0.0, $17 = 0, $18 = 0.0, $19 = 0, $2 = 0, $20 = 0.0, $21 = 0.0, $22 = 0.0, $23 = 0, $24 = 0, $25 = 0.0;
 var $26 = 0.0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0.0, $31 = 0.0, $32 = 0, $33 = 0.0, $34 = 0.0, $35 = 0.0, $36 = 0.0, $37 = 0.0, $38 = 0, $39 = 0.0, $4 = 0.0, $40 = 0.0, $41 = 0.0, $42 = 0, $43 = 0.0;
 var $44 = 0.0, $45 = 0, $5 = 0, $6 = 0, $7 = 0.0, $8 = 0, $9 = 0, $de$0 = 0.0, $exitcond = 0, $i$01 = 0, $val$0 = 0.0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = HEAP32[$p>>2]|0;
 $1 = ((($p)) + 4|0);
 $2 = HEAP32[$1>>2]|0;
 $3 = (((($2)) + 12|0) + ($offset_select<<2)|0);
 $4 = +HEAPF32[$3>>2];
 $5 = ($0|0)>(0);
 if (!($5)) {
  return;
 }
 $6 = ((($p)) + 48|0);
 $7 = +HEAPF32[$6>>2];
 $8 = ((($p)) + 12|0);
 $9 = HEAP32[$8>>2]|0;
 $10 = (($9) + ($offset_select<<2)|0);
 $11 = HEAP32[$10>>2]|0;
 $12 = ((($2)) + 108|0);
 $13 = ($offset_select|0)==(1);
 $14 = $7;
 $15 = $14 * 0.0050000000000000001;
 $16 = $14 * 2.9999999999999997E-4;
 $i$01 = 0;
 while(1) {
  $17 = (($noise) + ($i$01<<2)|0);
  $18 = +HEAPF32[$17>>2];
  $19 = (($11) + ($i$01<<2)|0);
  $20 = +HEAPF32[$19>>2];
  $21 = $20 + $18;
  $22 = +HEAPF32[$12>>2];
  $23 = $21 > $22;
  $val$0 = $23 ? $22 : $21;
  $24 = (($tone) + ($i$01<<2)|0);
  $25 = +HEAPF32[$24>>2];
  $26 = $25 + $4;
  $27 = $val$0 < $26;
  $$val$0 = $27 ? $26 : $val$0;
  $28 = (($logmask) + ($i$01<<2)|0);
  HEAPF32[$28>>2] = $$val$0;
  if ($13) {
   $29 = (($logmdct) + ($i$01<<2)|0);
   $30 = +HEAPF32[$29>>2];
   $31 = $val$0 - $30;
   $32 = $31 > -17.200000762939453;
   $33 = $31 + 17.200000762939453;
   $34 = $33;
   if ($32) {
    $35 = $15 * $34;
    $36 = 1.0 - $35;
    $37 = $36;
    $38 = $37 < 0.0;
    if ($38) {
     $de$0 = 9.9999997473787516E-5;
    } else {
     $de$0 = $37;
    }
   } else {
    $39 = $16 * $34;
    $40 = 1.0 - $39;
    $41 = $40;
    $de$0 = $41;
   }
   $42 = (($mdct) + ($i$01<<2)|0);
   $43 = +HEAPF32[$42>>2];
   $44 = $43 * $de$0;
   HEAPF32[$42>>2] = $44;
  }
  $45 = (($i$01) + 1)|0;
  $exitcond = ($45|0)==($0|0);
  if ($exitcond) {
   break;
  } else {
   $i$01 = $45;
  }
 }
 return;
}
function __vp_ampmax_decay($amp,$vd) {
 $amp = +$amp;
 $vd = $vd|0;
 var $$0 = 0.0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0.0, $13 = 0.0, $14 = 0, $15 = 0.0, $16 = 0.0, $17 = 0.0, $18 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0.0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($vd)) + 4|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ((($1)) + 28|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ((($vd)) + 40|0);
 $5 = HEAP32[$4>>2]|0;
 $6 = (($3) + ($5<<2)|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = (($7|0) / 2)&-1;
 $9 = (+($8|0));
 $10 = ((($1)) + 8|0);
 $11 = HEAP32[$10>>2]|0;
 $12 = (+($11|0));
 $13 = $9 / $12;
 $14 = ((($3)) + 2936|0);
 $15 = +HEAPF32[$14>>2];
 $16 = $15 * $13;
 $17 = $16 + $amp;
 $18 = $17 < -9999.0;
 $$0 = $18 ? -9999.0 : $17;
 return (+$$0);
}
function __vp_couple_quantize_normalize($blobno,$g,$p,$vi,$mdct,$iwork,$nonzero,$sliding_lowpass,$ch) {
 $blobno = $blobno|0;
 $g = $g|0;
 $p = $p|0;
 $vi = $vi|0;
 $mdct = $mdct|0;
 $iwork = $iwork|0;
 $nonzero = $nonzero|0;
 $sliding_lowpass = $sliding_lowpass|0;
 $ch = $ch|0;
 var $$ = 0, $$$i = 0, $$alloca_mul = 0, $$alloca_mul1 = 0, $$alloca_mul11 = 0, $$alloca_mul13 = 0, $$alloca_mul15 = 0, $$alloca_mul3 = 0, $$alloca_mul5 = 0, $$alloca_mul7 = 0, $$alloca_mul9 = 0, $$phi$trans$insert67 = 0, $$pre = 0, $$pre$phi76Z2D = 0, $$pre$phiZ2D = 0, $$pre63 = 0, $$pre64 = 0, $$pre65 = 0, $$pre68 = 0, $$pre69 = 0;
 var $$pre70 = 0, $$pre71 = 0, $$pre72 = 0, $$pre75 = 0, $$sum = 0, $$sum11 = 0, $$sum12 = 0, $$sum14 = 0, $$sum5 = 0, $$v = 0.0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0.0, $102 = 0.0, $103 = 0, $104 = 0, $105 = 0, $106 = 0;
 var $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0.0, $112 = 0.0, $113 = 0, $114 = 0, $115 = 0.0, $116 = 0, $117 = 0.0, $118 = 0.0, $119 = 0, $12 = 0, $120 = 0.0, $121 = 0.0, $122 = 0, $123 = 0, $124 = 0;
 var $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0.0, $140 = 0, $141 = 0, $142 = 0;
 var $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0;
 var $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $171 = 0.0, $172 = 0, $173 = 0.0, $174 = 0.0, $175 = 0, $176 = 0.0, $177 = 0, $178 = 0.0, $179 = 0.0;
 var $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0, $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0;
 var $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0.0, $206 = 0, $207 = 0.0, $208 = 0.0, $209 = 0, $21 = 0, $210 = 0, $211 = 0.0, $212 = 0, $213 = 0.0, $214 = 0.0;
 var $215 = 0, $216 = 0.0, $217 = 0, $218 = 0.0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0.0, $223 = 0, $224 = 0.0, $225 = 0.0, $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0;
 var $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0, $242 = 0, $243 = 0, $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0;
 var $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0.0, $98 = 0, $99 = 0.0;
 var $exitcond = 0, $exitcond$i = 0, $exitcond50 = 0, $exitcond54 = 0, $exitcond56 = 0, $exitcond60 = 0, $exitcond61 = 0, $exitcond6189 = 0, $fabsf = 0.0, $fabsf$i = 0.0, $fabsf1 = 0.0, $fabsf2 = 0.0, $fabsf3 = 0.0, $fabsf4 = 0.0, $i$242 = 0, $i$320 = 0, $indvars$iv$next58 = 0, $indvars$iv57 = 0, $ispos = 0, $ispos7 = 0;
 var $ispos9 = 0, $j$01$i = 0, $j$022 = 0, $j$125 = 0, $j$227 = 0, $j$333 = 0, $k$030 = 0, $neg = 0, $neg10 = 0, $neg8 = 0, $not$$i = 0, $p$idx$val = 0, $p$idx13$val = 0, $postpoint$0$in = 0.0, $postpoint$0$in$in = 0, $smax59 = 0, $step$039 = 0, $stereo_threshholds_limited$stereo_threshholds = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = HEAP32[$p>>2]|0;
 $1 = ((($p)) + 4|0);
 $2 = HEAP32[$1>>2]|0;
 $3 = ((($2)) + 500|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = ($4|0)==(0);
 if ($5) {
  $26 = 16;
 } else {
  $6 = ((($2)) + 508|0);
  $7 = HEAP32[$6>>2]|0;
  $26 = $7;
 }
 $8 = HEAP32[$2>>2]|0;
 $9 = ((((($g)) + 132|0) + (($8*60)|0)|0) + ($blobno<<2)|0);
 $10 = HEAP32[$9>>2]|0;
 $11 = (((($g)) + 252|0) + ($blobno<<2)|0);
 $12 = HEAP32[$11>>2]|0;
 $13 = (1624 + ($12<<3)|0);
 $14 = +HEAPF64[$13>>3];
 $15 = (((($g)) + 312|0) + ($blobno<<2)|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = $ch << 2;
 $$alloca_mul = $17;
 $18 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul)|0)+15)&-16)|0;;
 $$alloca_mul1 = $17;
 $19 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul1)|0)+15)&-16)|0;;
 $$alloca_mul3 = $17;
 $20 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul3)|0)+15)&-16)|0;;
 $$alloca_mul5 = $17;
 $21 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul5)|0)+15)&-16)|0;;
 $$alloca_mul7 = $17;
 $22 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul7)|0)+15)&-16)|0;;
 $23 = ((($vi)) + 1156|0);
 $24 = ($0|0)>(1000);
 $stereo_threshholds_limited$stereo_threshholds = $24 ? 1696 : 1624;
 $postpoint$0$in$in = (($stereo_threshholds_limited$stereo_threshholds) + ($16<<3)|0);
 $postpoint$0$in = +HEAPF64[$postpoint$0$in$in>>3];
 $25 = Math_imul($17, $26)|0;
 $$alloca_mul9 = $25;
 $27 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul9)|0)+15)&-16)|0;;
 HEAP32[$18>>2] = $27;
 $$alloca_mul11 = $25;
 $28 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul11)|0)+15)&-16)|0;;
 HEAP32[$19>>2] = $28;
 $$alloca_mul13 = $25;
 $29 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul13)|0)+15)&-16)|0;;
 HEAP32[$20>>2] = $29;
 $$alloca_mul15 = $25;
 $30 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul15)|0)+15)&-16)|0;;
 HEAP32[$21>>2] = $30;
 $31 = ($ch|0)>(1);
 if ($31) {
  $32 = (($27) + ($26<<2)|0);
  $33 = ((($18)) + 4|0);
  HEAP32[$33>>2] = $32;
  $34 = (($28) + ($26<<2)|0);
  $35 = ((($19)) + 4|0);
  HEAP32[$35>>2] = $34;
  $36 = (($29) + ($26<<2)|0);
  $37 = ((($20)) + 4|0);
  HEAP32[$37>>2] = $36;
  $38 = (($30) + ($26<<2)|0);
  $39 = ((($21)) + 4|0);
  HEAP32[$39>>2] = $38;
  $exitcond6189 = ($ch|0)==(2);
  if (!($exitcond6189)) {
   $43 = 2;
   while(1) {
    $$pre = HEAP32[$18>>2]|0;
    $$pre63 = HEAP32[$19>>2]|0;
    $$pre64 = HEAP32[$20>>2]|0;
    $$pre65 = HEAP32[$21>>2]|0;
    $42 = Math_imul($43, $26)|0;
    $44 = (($$pre) + ($42<<2)|0);
    $45 = (($18) + ($43<<2)|0);
    HEAP32[$45>>2] = $44;
    $46 = (($$pre63) + ($42<<2)|0);
    $47 = (($19) + ($43<<2)|0);
    HEAP32[$47>>2] = $46;
    $48 = (($$pre64) + ($42<<2)|0);
    $49 = (($20) + ($43<<2)|0);
    HEAP32[$49>>2] = $48;
    $50 = (($$pre65) + ($42<<2)|0);
    $51 = (($21) + ($43<<2)|0);
    HEAP32[$51>>2] = $50;
    $52 = (($43) + 1)|0;
    $exitcond61 = ($52|0)==($ch|0);
    if ($exitcond61) {
     break;
    } else {
     $43 = $52;
    }
   }
  }
 }
 $40 = HEAP32[$23>>2]|0;
 $41 = ($0|0)>(0);
 if ($41) {
  $53 = HEAP32[$21>>2]|0;
  $54 = ($ch|0)>(0);
  $55 = $0 ^ -1;
  $56 = $26 ^ -1;
  $i$242 = 0;$indvars$iv57 = $55;
  while(1) {
   $59 = ($indvars$iv57|0)>($56|0);
   $smax59 = $59 ? $indvars$iv57 : $56;
   $60 = $smax59 ^ -1;
   $61 = (($0) - ($i$242))|0;
   $62 = ($26|0)>($61|0);
   $$ = $62 ? $61 : $26;
   _memcpy(($22|0),($nonzero|0),($17|0))|0;
   _memset(($53|0),0,($25|0))|0;
   if ($54) {
    $63 = ($$|0)>(0);
    $64 = (($10) - ($i$242))|0;
    $k$030 = 0;
    while(1) {
     $70 = (($iwork) + ($k$030<<2)|0);
     $71 = HEAP32[$70>>2]|0;
     $72 = (($71) + ($i$242<<2)|0);
     $73 = (($22) + ($k$030<<2)|0);
     $74 = HEAP32[$73>>2]|0;
     $75 = ($74|0)==(0);
     if ($75) {
      if ($63) {
       $78 = (($20) + ($k$030<<2)|0);
       $79 = HEAP32[$78>>2]|0;
       $80 = (($18) + ($k$030<<2)|0);
       $81 = HEAP32[$80>>2]|0;
       $82 = (($19) + ($k$030<<2)|0);
       $83 = HEAP32[$82>>2]|0;
       $84 = (($21) + ($k$030<<2)|0);
       $85 = HEAP32[$84>>2]|0;
       $j$227 = 0;
       while(1) {
        $125 = (($79) + ($j$227<<2)|0);
        HEAPF32[$125>>2] = 1.000000013351432E-10;
        $126 = (($81) + ($j$227<<2)|0);
        HEAPF32[$126>>2] = 0.0;
        $127 = (($83) + ($j$227<<2)|0);
        HEAPF32[$127>>2] = 0.0;
        $128 = (($85) + ($j$227<<2)|0);
        HEAP32[$128>>2] = 0;
        $$sum11 = (($j$227) + ($i$242))|0;
        $129 = (($71) + ($$sum11<<2)|0);
        HEAP32[$129>>2] = 0;
        $130 = (($j$227) + 1)|0;
        $exitcond54 = ($130|0)==($60|0);
        if ($exitcond54) {
         break;
        } else {
         $j$227 = $130;
        }
       }
      }
     } else {
      $76 = (($20) + ($k$030<<2)|0);
      $77 = HEAP32[$76>>2]|0;
      if ($63) {
       $j$022 = 0;
       while(1) {
        $$sum12 = (($j$022) + ($i$242))|0;
        $86 = (($71) + ($$sum12<<2)|0);
        $87 = HEAP32[$86>>2]|0;
        $88 = (1768 + ($87<<2)|0);
        $89 = HEAP32[$88>>2]|0;
        $90 = (($77) + ($j$022<<2)|0);
        HEAP32[$90>>2] = $89;
        $91 = (($j$022) + 1)|0;
        $exitcond = ($91|0)==($60|0);
        if ($exitcond) {
         break;
        } else {
         $j$022 = $91;
        }
       }
       $92 = (($mdct) + ($k$030<<2)|0);
       $93 = HEAP32[$92>>2]|0;
       $94 = (($21) + ($k$030<<2)|0);
       $95 = HEAP32[$94>>2]|0;
       if ($63) {
        $j$01$i = 0;
        while(1) {
         $96 = ($j$01$i|0)>=($64|0);
         $$v = $96 ? $postpoint$0$in : $14;
         $97 = $$v;
         $$sum14 = (($j$01$i) + ($i$242))|0;
         $98 = (($93) + ($$sum14<<2)|0);
         $99 = +HEAPF32[$98>>2];
         $fabsf$i = (+Math_abs((+$99)));
         $100 = (($77) + ($j$01$i<<2)|0);
         $101 = +HEAPF32[$100>>2];
         $102 = $fabsf$i / $101;
         $103 = (($95) + ($j$01$i<<2)|0);
         $not$$i = !($102 < $97);
         $$$i = $not$$i&1;
         HEAP32[$103>>2] = $$$i;
         $104 = (($j$01$i) + 1)|0;
         $exitcond$i = ($104|0)==($$|0);
         if ($exitcond$i) {
          break;
         } else {
          $j$01$i = $104;
         }
        }
        if ($63) {
         $105 = (($18) + ($k$030<<2)|0);
         $106 = HEAP32[$105>>2]|0;
         $107 = (($19) + ($k$030<<2)|0);
         $108 = HEAP32[$107>>2]|0;
         $j$125 = 0;
         while(1) {
          $109 = (($j$125) + ($i$242))|0;
          $110 = (($93) + ($109<<2)|0);
          $111 = +HEAPF32[$110>>2];
          $112 = $111 * $111;
          $113 = (($106) + ($j$125<<2)|0);
          HEAPF32[$113>>2] = $112;
          $114 = (($108) + ($j$125<<2)|0);
          HEAPF32[$114>>2] = $112;
          $115 = +HEAPF32[$110>>2];
          $116 = $115 < 0.0;
          if ($116) {
           $117 = +HEAPF32[$113>>2];
           $118 = -$117;
           HEAPF32[$113>>2] = $118;
          }
          $119 = (($77) + ($j$125<<2)|0);
          $120 = +HEAPF32[$119>>2];
          $121 = $120 * $120;
          HEAPF32[$119>>2] = $121;
          $122 = (($j$125) + 1)|0;
          $exitcond50 = ($122|0)==($60|0);
          if ($exitcond50) {
           $$pre$phi76Z2D = $107;$124 = $106;
           break;
          } else {
           $j$125 = $122;
          }
         }
        } else {
         label = 21;
        }
       } else {
        label = 21;
       }
      } else {
       label = 21;
      }
      if ((label|0) == 21) {
       label = 0;
       $$phi$trans$insert67 = (($18) + ($k$030<<2)|0);
       $$pre68 = HEAP32[$$phi$trans$insert67>>2]|0;
       $$pre75 = (($19) + ($k$030<<2)|0);
       $$pre$phi76Z2D = $$pre75;$124 = $$pre68;
      }
      $123 = HEAP32[$$pre$phi76Z2D>>2]|0;
      $p$idx$val = HEAP32[$1>>2]|0;
      (+_noise_normalize($p$idx$val,$10,$124,$123,$77,0,$i$242,$$,$72));
     }
     $131 = (($k$030) + 1)|0;
     $exitcond56 = ($131|0)==($ch|0);
     if ($exitcond56) {
      break;
     } else {
      $k$030 = $131;
     }
    }
   }
   $65 = HEAP32[$23>>2]|0;
   $66 = ($65|0)>(0);
   if ($66) {
    $67 = ($$|0)>(0);
    $68 = (($sliding_lowpass) - ($i$242))|0;
    $69 = (($10) - ($i$242))|0;
    $249 = $65;$step$039 = 0;
    while(1) {
     $132 = (((($vi)) + 1160|0) + ($step$039<<2)|0);
     $133 = HEAP32[$132>>2]|0;
     $134 = (((($vi)) + 2184|0) + ($step$039<<2)|0);
     $135 = HEAP32[$134>>2]|0;
     $136 = (($iwork) + ($133<<2)|0);
     $137 = HEAP32[$136>>2]|0;
     $138 = (($137) + ($i$242<<2)|0);
     $139 = (($iwork) + ($135<<2)|0);
     $140 = HEAP32[$139>>2]|0;
     $141 = (($18) + ($133<<2)|0);
     $142 = HEAP32[$141>>2]|0;
     $143 = (($18) + ($135<<2)|0);
     $144 = HEAP32[$143>>2]|0;
     $145 = (($19) + ($133<<2)|0);
     $146 = HEAP32[$145>>2]|0;
     $147 = (($19) + ($135<<2)|0);
     $148 = HEAP32[$147>>2]|0;
     $149 = (($20) + ($133<<2)|0);
     $150 = HEAP32[$149>>2]|0;
     $151 = (($20) + ($135<<2)|0);
     $152 = HEAP32[$151>>2]|0;
     $153 = (($21) + ($133<<2)|0);
     $154 = HEAP32[$153>>2]|0;
     $155 = (($21) + ($135<<2)|0);
     $156 = HEAP32[$155>>2]|0;
     $157 = (($22) + ($133<<2)|0);
     $158 = HEAP32[$157>>2]|0;
     $159 = ($158|0)==(0);
     $160 = (($22) + ($135<<2)|0);
     if ($159) {
      $161 = HEAP32[$160>>2]|0;
      $162 = ($161|0)==(0);
      if ($162) {
       $229 = $249;
      } else {
       label = 31;
      }
     } else {
      label = 31;
     }
     if ((label|0) == 31) {
      label = 0;
      HEAP32[$160>>2] = 1;
      HEAP32[$157>>2] = 1;
      if ($67) {
       $j$333 = 0;
       while(1) {
        $163 = ($j$333|0)<($68|0);
        do {
         if ($163) {
          $164 = (($154) + ($j$333<<2)|0);
          $165 = HEAP32[$164>>2]|0;
          $166 = ($165|0)==(0);
          $167 = (($156) + ($j$333<<2)|0);
          if ($166) {
           $168 = HEAP32[$167>>2]|0;
           $169 = ($168|0)==(0);
           if ($169) {
            $203 = ($j$333|0)<($69|0);
            do {
             if ($203) {
              $204 = (($144) + ($j$333<<2)|0);
              $205 = +HEAPF32[$204>>2];
              $206 = (($142) + ($j$333<<2)|0);
              $207 = +HEAPF32[$206>>2];
              $208 = $207 + $205;
              HEAPF32[$206>>2] = $208;
              $fabsf2 = (+Math_abs((+$208)));
              $209 = (($146) + ($j$333<<2)|0);
              HEAPF32[$209>>2] = $fabsf2;
              $$pre$phiZ2D = $204;
             } else {
              $210 = (($142) + ($j$333<<2)|0);
              $211 = +HEAPF32[$210>>2];
              $212 = (($144) + ($j$333<<2)|0);
              $213 = +HEAPF32[$212>>2];
              $214 = $213 + $211;
              $215 = $214 < 0.0;
              $fabsf = (+Math_abs((+$211)));
              $fabsf1 = (+Math_abs((+$213)));
              $216 = $fabsf1 + $fabsf;
              $217 = (($146) + ($j$333<<2)|0);
              HEAPF32[$217>>2] = $216;
              if ($215) {
               $218 = -$216;
               HEAPF32[$210>>2] = $218;
               $$pre$phiZ2D = $212;
               break;
              } else {
               HEAPF32[$210>>2] = $216;
               $$pre$phiZ2D = $212;
               break;
              }
             }
            } while(0);
            $219 = (($148) + ($j$333<<2)|0);
            HEAPF32[$219>>2] = 0.0;
            HEAPF32[$$pre$phiZ2D>>2] = 0.0;
            HEAP32[$167>>2] = 1;
            $$sum = (($j$333) + ($i$242))|0;
            $220 = (($140) + ($$sum<<2)|0);
            HEAP32[$220>>2] = 0;
            break;
           }
          }
          $170 = (($142) + ($j$333<<2)|0);
          $171 = +HEAPF32[$170>>2];
          $fabsf3 = (+Math_abs((+$171)));
          $172 = (($144) + ($j$333<<2)|0);
          $173 = +HEAPF32[$172>>2];
          $fabsf4 = (+Math_abs((+$173)));
          $174 = $fabsf4 + $fabsf3;
          HEAPF32[$170>>2] = $174;
          $175 = (($146) + ($j$333<<2)|0);
          $176 = +HEAPF32[$175>>2];
          $177 = (($148) + ($j$333<<2)|0);
          $178 = +HEAPF32[$177>>2];
          $179 = $178 + $176;
          HEAPF32[$175>>2] = $179;
          HEAP32[$167>>2] = 1;
          HEAP32[$164>>2] = 1;
          $$sum5 = (($j$333) + ($i$242))|0;
          $180 = (($137) + ($$sum5<<2)|0);
          $181 = HEAP32[$180>>2]|0;
          $182 = (($140) + ($$sum5<<2)|0);
          $183 = HEAP32[$182>>2]|0;
          $ispos = ($181|0)>(-1);
          $neg = (0 - ($181))|0;
          $184 = $ispos ? $181 : $neg;
          $ispos7 = ($183|0)>(-1);
          $neg8 = (0 - ($183))|0;
          $185 = $ispos7 ? $183 : $neg8;
          $186 = ($184|0)>($185|0);
          if ($186) {
           $187 = ($181|0)>(0);
           $188 = (($181) - ($183))|0;
           $189 = (($183) - ($181))|0;
           $190 = $187 ? $188 : $189;
           HEAP32[$182>>2] = $190;
           $$pre70 = HEAP32[$180>>2]|0;
           $195 = $$pre70;$198 = $190;
          } else {
           $191 = ($183|0)>(0);
           $192 = (($181) - ($183))|0;
           $193 = (($183) - ($181))|0;
           $194 = $191 ? $192 : $193;
           HEAP32[$182>>2] = $194;
           HEAP32[$180>>2] = $183;
           $$pre69 = HEAP32[$182>>2]|0;
           $195 = $183;$198 = $$pre69;
          }
          $ispos9 = ($195|0)>(-1);
          $neg10 = (0 - ($195))|0;
          $196 = $ispos9 ? $195 : $neg10;
          $197 = $196 << 1;
          $199 = ($198|0)<($197|0);
          if (!($199)) {
           $200 = (0 - ($198))|0;
           HEAP32[$182>>2] = $200;
           $201 = HEAP32[$180>>2]|0;
           $202 = (0 - ($201))|0;
           HEAP32[$180>>2] = $202;
          }
         }
        } while(0);
        $221 = (($150) + ($j$333<<2)|0);
        $222 = +HEAPF32[$221>>2];
        $223 = (($152) + ($j$333<<2)|0);
        $224 = +HEAPF32[$223>>2];
        $225 = $224 + $222;
        HEAPF32[$223>>2] = $225;
        HEAPF32[$221>>2] = $225;
        $226 = (($j$333) + 1)|0;
        $exitcond60 = ($226|0)==($60|0);
        if ($exitcond60) {
         break;
        } else {
         $j$333 = $226;
        }
       }
      }
      $p$idx13$val = HEAP32[$1>>2]|0;
      (+_noise_normalize($p$idx13$val,$10,$142,$146,$150,$154,$i$242,$$,$138));
      $$pre71 = HEAP32[$23>>2]|0;
      $229 = $$pre71;
     }
     $227 = (($step$039) + 1)|0;
     $228 = ($227|0)<($229|0);
     if ($228) {
      $249 = $229;$step$039 = $227;
     } else {
      $248 = $229;
      break;
     }
    }
   } else {
    $248 = $65;
   }
   $230 = (($i$242) + ($26))|0;
   $231 = ($0|0)>($230|0);
   $indvars$iv$next58 = (($indvars$iv57) + ($26))|0;
   if ($231) {
    $i$242 = $230;$indvars$iv57 = $indvars$iv$next58;
   } else {
    $57 = $248;
    break;
   }
  }
 } else {
  $57 = $40;
 }
 $58 = ($57|0)>(0);
 if ($58) {
  $247 = $57;$i$320 = 0;
 } else {
  STACKTOP = sp;return;
 }
 while(1) {
  $232 = (((($vi)) + 1160|0) + ($i$320<<2)|0);
  $233 = HEAP32[$232>>2]|0;
  $234 = (($nonzero) + ($233<<2)|0);
  $235 = HEAP32[$234>>2]|0;
  $236 = ($235|0)==(0);
  $237 = (((($vi)) + 2184|0) + ($i$320<<2)|0);
  if ($236) {
   $238 = HEAP32[$237>>2]|0;
   $239 = (($nonzero) + ($238<<2)|0);
   $240 = HEAP32[$239>>2]|0;
   $241 = ($240|0)==(0);
   if ($241) {
    $246 = $247;
   } else {
    label = 52;
   }
  } else {
   label = 52;
  }
  if ((label|0) == 52) {
   label = 0;
   HEAP32[$234>>2] = 1;
   $242 = HEAP32[$237>>2]|0;
   $243 = (($nonzero) + ($242<<2)|0);
   HEAP32[$243>>2] = 1;
   $$pre72 = HEAP32[$23>>2]|0;
   $246 = $$pre72;
  }
  $244 = (($i$320) + 1)|0;
  $245 = ($244|0)<($246|0);
  if ($245) {
   $247 = $246;$i$320 = $244;
  } else {
   break;
  }
 }
 STACKTOP = sp;return;
}
function _setup_tone_curves($curveatt_dB,$binHz,$n,$center_boost,$center_decay_rate) {
 $curveatt_dB = $curveatt_dB|0;
 $binHz = +$binHz;
 $n = $n|0;
 $center_boost = +$center_boost;
 $center_decay_rate = +$center_decay_rate;
 var $$$$us$us$us = 0.0, $$$$us68 = 0.0, $$$us$us$us = 0.0, $$$us$us81 = 0.0, $$5 = 0, $$6 = 0, $$8 = 0, $$alloca_mul = 0, $$op = 0.0, $$op$op$op = 0.0, $$op123 = 0, $$op124 = 0, $$op125 = 0, $$op126 = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0.0, $101 = 0, $102 = 0.0;
 var $103 = 0, $104 = 0, $105 = 0, $106 = 0.0, $107 = 0, $108 = 0.0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0.0, $116 = 0.0, $117 = 0.0, $118 = 0.0, $119 = 0.0, $12 = 0, $120 = 0.0;
 var $121 = 0.0, $122 = 0, $123 = 0.0, $124 = 0.0, $125 = 0.0, $126 = 0.0, $127 = 0.0, $128 = 0.0, $129 = 0.0, $13 = 0, $130 = 0.0, $131 = 0, $132 = 0, $133 = 0.0, $134 = 0.0, $135 = 0.0, $136 = 0.0, $137 = 0.0, $138 = 0.0, $139 = 0.0;
 var $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0.0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0.0, $153 = 0.0, $154 = 0, $155 = 0, $156 = 0.0, $157 = 0.0;
 var $158 = 0.0, $159 = 0.0, $16 = 0, $160 = 0.0, $161 = 0.0, $162 = 0.0, $163 = 0.0, $164 = 0, $165 = 0.0, $166 = 0.0, $167 = 0.0, $168 = 0.0, $169 = 0.0, $17 = 0, $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0;
 var $176 = 0, $177 = 0, $178 = 0, $179 = 0.0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0, $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0;
 var $194 = 0, $195 = 0, $196 = 0.0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0.0, $202 = 0, $203 = 0, $204 = 0, $205 = 0, $206 = 0, $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0;
 var $211 = 0.0, $212 = 0.0, $213 = 0.0, $214 = 0.0, $215 = 0.0, $216 = 0.0, $217 = 0.0, $218 = 0.0, $219 = 0, $22 = 0, $220 = 0.0, $221 = 0.0, $222 = 0.0, $223 = 0.0, $224 = 0.0, $225 = 0, $226 = 0, $227 = 0, $228 = 0, $229 = 0;
 var $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0.0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0, $242 = 0, $243 = 0, $244 = 0, $245 = 0, $246 = 0, $247 = 0;
 var $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0.0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0.0, $257 = 0, $258 = 0, $259 = 0, $26 = 0.0, $260 = 0.0, $261 = 0, $262 = 0.0, $263 = 0.0, $264 = 0.0, $265 = 0.0;
 var $266 = 0.0, $267 = 0.0, $268 = 0, $269 = 0, $27 = 0, $270 = 0, $271 = 0, $272 = 0, $273 = 0, $274 = 0, $275 = 0, $276 = 0, $277 = 0, $278 = 0, $279 = 0, $28 = 0, $280 = 0, $281 = 0, $282 = 0, $283 = 0;
 var $284 = 0.0, $285 = 0, $286 = 0, $287 = 0, $288 = 0.0, $289 = 0, $29 = 0, $290 = 0, $291 = 0, $292 = 0.0, $293 = 0, $294 = 0, $295 = 0, $296 = 0.0, $297 = 0, $298 = 0, $299 = 0.0, $3 = 0, $30 = 0, $300 = 0;
 var $301 = 0, $302 = 0.0, $303 = 0, $304 = 0, $305 = 0.0, $306 = 0, $307 = 0, $308 = 0.0, $309 = 0, $31 = 0, $310 = 0, $311 = 0.0, $312 = 0, $313 = 0, $314 = 0.0, $315 = 0, $316 = 0, $317 = 0.0, $318 = 0, $319 = 0;
 var $32 = 0.0, $320 = 0.0, $321 = 0, $322 = 0, $323 = 0.0, $324 = 0, $325 = 0, $326 = 0.0, $327 = 0, $328 = 0, $329 = 0.0, $33 = 0.0, $330 = 0, $331 = 0, $332 = 0.0, $333 = 0, $334 = 0, $335 = 0.0, $336 = 0, $337 = 0;
 var $338 = 0, $339 = 0.0, $34 = 0.0, $340 = 0, $341 = 0, $342 = 0, $343 = 0, $344 = 0, $345 = 0.0, $346 = 0, $347 = 0, $348 = 0, $349 = 0, $35 = 0, $350 = 0, $351 = 0.0, $352 = 0, $353 = 0, $354 = 0, $36 = 0;
 var $37 = 0.0, $38 = 0.0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0.0, $43 = 0.0, $44 = 0.0, $45 = 0, $46 = 0, $47 = 0, $48 = 0.0, $49 = 0.0, $5 = 0.0, $50 = 0, $51 = 0, $52 = 0.0, $53 = 0.0, $54 = 0;
 var $55 = 0, $56 = 0.0, $57 = 0.0, $58 = 0.0, $59 = 0, $6 = 0, $60 = 0, $61 = 0.0, $62 = 0.0, $63 = 0, $64 = 0, $65 = 0, $66 = 0.0, $67 = 0.0, $68 = 0.0, $69 = 0, $7 = 0, $70 = 0.0, $71 = 0.0, $72 = 0;
 var $73 = 0, $74 = 0, $75 = 0.0, $76 = 0.0, $77 = 0.0, $78 = 0.0, $79 = 0, $8 = 0, $80 = 0.0, $81 = 0.0, $82 = 0, $83 = 0, $84 = 0.0, $85 = 0.0, $86 = 0.0, $87 = 0, $88 = 0.0, $89 = 0.0, $9 = 0, $90 = 0;
 var $91 = 0, $92 = 0.0, $93 = 0, $94 = 0.0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $ath = 0, $athc = 0, $exitcond = 0, $exitcond$i = 0, $exitcond$i11 = 0, $exitcond$i13 = 0, $exitcond$i16 = 0, $exitcond$i18 = 0, $exitcond104 = 0, $exitcond105 = 0, $exitcond106 = 0;
 var $exitcond107 = 0, $exitcond108 = 0, $exitcond109 = 0, $exitcond111 = 0, $exitcond113 = 0, $exitcond114 = 0, $exitcond115 = 0, $exitcond116 = 0, $exitcond117 = 0, $exitcond118 = 0, $exitcond119 = 0, $exitcond120 = 0, $exitcond121 = 0, $exitcond95 = 0, $exitcond96 = 0, $exitcond97 = 0, $hi_bin$0 = 0, $hi_bin3$0 = 0, $i$01$i = 0, $i$01$i10 = 0;
 var $i$01$i12 = 0, $i$01$i15 = 0, $i$01$i17 = 0, $i$088 = 0, $i$1$ = 0, $i$158 = 0, $ispos = 0, $ispos$us$us$us = 0, $ispos$us$us79 = 0, $ispos$us65 = 0, $j$061 = 0, $j$10$lcssa = 0, $j$1054 = 0, $j$269 = 0, $j$269$us = 0, $j$386 = 0, $j$487 = 0, $j$533 = 0, $j$638 = 0, $j$749 = 0;
 var $j$852 = 0, $j$9$lcssa = 0.0, $k$163 = 0, $k$163$us$us$us = 0, $k$163$us$us78 = 0, $k$163$us64 = 0, $k$241 = 0, $l$037 = 0, $l$2$lcssa = 0, $l$2$lcssa$lcssa = 0, $l$235 = 0, $l$339 = 0, $l1$048 = 0, $l1$2$lcssa = 0, $l1$2$lcssa$lcssa = 0, $l1$244 = 0, $l1$350 = 0, $lo_bin$1 = 0, $lo_bin$1$l$0 = 0, $lo_bin2$1 = 0;
 var $lo_bin2$1$l1$0 = 0, $lo_curve$1 = 0, $m$055 = 0, $min$1 = 0.0, $min$1$1 = 0.0, $min$1$2 = 0.0, $min$1$3 = 0.0, $n$hi_bin$0 = 0, $n$hi_bin3$0 = 0, $neg = 0, $neg$us$us$us = 0, $neg$us$us80 = 0, $neg$us66 = 0, $or$cond734 = 0, $or$cond943 = 0, $smax100 = 0, $smax102 = 0, $smax92 = 0, $smax94 = 0, $umax = 0;
 var $umax103 = 0, $workc = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32480|0;
 $ath = sp + 32256|0;
 $workc = sp + 1792|0;
 $athc = sp;
 $0 = $n << 2;
 $$alloca_mul = $0;
 $1 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul)|0)+15)&-16)|0;;
 $2 = (_malloc(68)|0);
 _memset(($workc|0),0,30464)|0;
 $3 = $center_boost > 0.0;
 $4 = $center_boost < 0.0;
 $i$088 = 0;
 while(1) {
  $8 = $i$088 << 2;
  $j$061 = 0;
  while(1) {
   $23 = (($j$061) + ($8))|0;
   $24 = ($23|0)<(88);
   if ($24) {
    $25 = (1272 + ($23<<2)|0);
    $26 = +HEAPF32[$25>>2];
    $min$1 = $26;
   } else {
    $min$1 = -30.0;
   }
   $27 = (($23) + 1)|0;
   $28 = ($27|0)<(88);
   if ($28) {
    $338 = (1272 + ($27<<2)|0);
    $339 = +HEAPF32[$338>>2];
    $340 = $min$1 > $339;
    if ($340) {
     $min$1$1 = $339;
    } else {
     $min$1$1 = $min$1;
    }
   } else {
    $337 = $min$1 > -30.0;
    if ($337) {
     $min$1$1 = -30.0;
    } else {
     $min$1$1 = $min$1;
    }
   }
   $341 = (($23) + 2)|0;
   $342 = ($341|0)<(88);
   if ($342) {
    $344 = (1272 + ($341<<2)|0);
    $345 = +HEAPF32[$344>>2];
    $346 = $min$1$1 > $345;
    if ($346) {
     $min$1$2 = $345;
    } else {
     $min$1$2 = $min$1$1;
    }
   } else {
    $343 = $min$1$1 > -30.0;
    if ($343) {
     $min$1$2 = -30.0;
    } else {
     $min$1$2 = $min$1$1;
    }
   }
   $347 = (($23) + 3)|0;
   $348 = ($347|0)<(88);
   if ($348) {
    $350 = (1272 + ($347<<2)|0);
    $351 = +HEAPF32[$350>>2];
    $352 = $min$1$2 > $351;
    if ($352) {
     $min$1$3 = $351;
    } else {
     $min$1$3 = $min$1$2;
    }
   } else {
    $349 = $min$1$2 > -30.0;
    if ($349) {
     $min$1$3 = -30.0;
    } else {
     $min$1$3 = $min$1$2;
    }
   }
   $353 = (($ath) + ($j$061<<2)|0);
   HEAPF32[$353>>2] = $min$1$3;
   $354 = (($j$061) + 1)|0;
   $exitcond111 = ($354|0)==(56);
   if ($exitcond111) {
    break;
   } else {
    $j$061 = $354;
   }
  }
  $9 = (((($workc) + (($i$088*1792)|0)|0)) + 448|0);
  $10 = (2792 + (($i$088*1344)|0)|0);
  _memcpy(($9|0),($10|0),224)|0;
  $11 = (((($workc) + (($i$088*1792)|0)|0)) + 672|0);
  $12 = (((2792 + (($i$088*1344)|0)|0)) + 224|0);
  _memcpy(($11|0),($12|0),224)|0;
  $13 = (((($workc) + (($i$088*1792)|0)|0)) + 896|0);
  $14 = (((2792 + (($i$088*1344)|0)|0)) + 448|0);
  _memcpy(($13|0),($14|0),224)|0;
  $15 = (((($workc) + (($i$088*1792)|0)|0)) + 1120|0);
  $16 = (((2792 + (($i$088*1344)|0)|0)) + 672|0);
  _memcpy(($15|0),($16|0),224)|0;
  $17 = (((($workc) + (($i$088*1792)|0)|0)) + 1344|0);
  $18 = (((2792 + (($i$088*1344)|0)|0)) + 896|0);
  _memcpy(($17|0),($18|0),224)|0;
  $19 = (((($workc) + (($i$088*1792)|0)|0)) + 1568|0);
  $20 = (((2792 + (($i$088*1344)|0)|0)) + 1120|0);
  _memcpy(($19|0),($20|0),224)|0;
  $21 = (($workc) + (($i$088*1792)|0)|0);
  _memcpy(($21|0),($10|0),224)|0;
  $22 = (((($workc) + (($i$088*1792)|0)|0)) + 224|0);
  _memcpy(($22|0),($10|0),224)|0;
  if ($3) {
   $j$269$us = 0;
   while(1) {
    if ($4) {
     $k$163$us$us$us = 0;
     while(1) {
      $40 = (16 - ($k$163$us$us$us))|0;
      $ispos$us$us$us = ($40|0)>(-1);
      $neg$us$us$us = (0 - ($40))|0;
      $41 = $ispos$us$us$us ? $40 : $neg$us$us$us;
      $42 = (+($41|0));
      $43 = $42 * $center_decay_rate;
      $44 = $43 + $center_boost;
      $45 = $44 < 0.0;
      $$$us$us$us = $45 ? 0.0 : $44;
      $46 = $$$us$us$us > 0.0;
      $$$$us$us$us = $46 ? 0.0 : $$$us$us$us;
      $47 = (((($workc) + (($i$088*1792)|0)|0) + (($j$269$us*224)|0)|0) + ($k$163$us$us$us<<2)|0);
      $48 = +HEAPF32[$47>>2];
      $49 = $48 + $$$$us$us$us;
      HEAPF32[$47>>2] = $49;
      $50 = (($k$163$us$us$us) + 1)|0;
      $exitcond119 = ($50|0)==(56);
      if ($exitcond119) {
       break;
      } else {
       $k$163$us$us$us = $50;
      }
     }
    } else {
     $k$163$us$us78 = 0;
     while(1) {
      $30 = (16 - ($k$163$us$us78))|0;
      $ispos$us$us79 = ($30|0)>(-1);
      $neg$us$us80 = (0 - ($30))|0;
      $31 = $ispos$us$us79 ? $30 : $neg$us$us80;
      $32 = (+($31|0));
      $33 = $32 * $center_decay_rate;
      $34 = $33 + $center_boost;
      $35 = $34 < 0.0;
      $$$us$us81 = $35 ? 0.0 : $34;
      $36 = (((($workc) + (($i$088*1792)|0)|0) + (($j$269$us*224)|0)|0) + ($k$163$us$us78<<2)|0);
      $37 = +HEAPF32[$36>>2];
      $38 = $37 + $$$us$us81;
      HEAPF32[$36>>2] = $38;
      $39 = (($k$163$us$us78) + 1)|0;
      $exitcond118 = ($39|0)==(56);
      if ($exitcond118) {
       break;
      } else {
       $k$163$us$us78 = $39;
      }
     }
    }
    $29 = (($j$269$us) + 1)|0;
    $exitcond120 = ($29|0)==(8);
    if ($exitcond120) {
     break;
    } else {
     $j$269$us = $29;
    }
   }
  } else {
   $j$269 = 0;
   while(1) {
    if ($4) {
     $k$163$us64 = 0;
     while(1) {
      $54 = (16 - ($k$163$us64))|0;
      $ispos$us65 = ($54|0)>(-1);
      $neg$us66 = (0 - ($54))|0;
      $55 = $ispos$us65 ? $54 : $neg$us66;
      $56 = (+($55|0));
      $57 = $56 * $center_decay_rate;
      $58 = $57 + $center_boost;
      $59 = $58 > 0.0;
      $$$$us68 = $59 ? 0.0 : $58;
      $60 = (((($workc) + (($i$088*1792)|0)|0) + (($j$269*224)|0)|0) + ($k$163$us64<<2)|0);
      $61 = +HEAPF32[$60>>2];
      $62 = $61 + $$$$us68;
      HEAPF32[$60>>2] = $62;
      $63 = (($k$163$us64) + 1)|0;
      $exitcond114 = ($63|0)==(56);
      if ($exitcond114) {
       break;
      } else {
       $k$163$us64 = $63;
      }
     }
    } else {
     $k$163 = 0;
     while(1) {
      $64 = (16 - ($k$163))|0;
      $ispos = ($64|0)>(-1);
      $neg = (0 - ($64))|0;
      $65 = $ispos ? $64 : $neg;
      $66 = (+($65|0));
      $67 = $66 * $center_decay_rate;
      $68 = $67 + $center_boost;
      $69 = (((($workc) + (($i$088*1792)|0)|0) + (($j$269*224)|0)|0) + ($k$163<<2)|0);
      $70 = +HEAPF32[$69>>2];
      $71 = $70 + $68;
      HEAPF32[$69>>2] = $71;
      $72 = (($k$163) + 1)|0;
      $exitcond113 = ($72|0)==(56);
      if ($exitcond113) {
       break;
      } else {
       $k$163 = $72;
      }
     }
    }
    $73 = (($j$269) + 1)|0;
    $exitcond115 = ($73|0)==(8);
    if ($exitcond115) {
     break;
    } else {
     $j$269 = $73;
    }
   }
  }
  $51 = (($curveatt_dB) + ($i$088<<2)|0);
  $52 = +HEAPF32[$51>>2];
  $53 = $52;
  $j$386 = 0;
  while(1) {
   $74 = ($j$386|0)<(2);
   $75 = (+($j$386|0));
   $$op = $75 * 10.0;
   $$op$op$op = 70.0 - $$op;
   $76 = $74 ? 50.0 : $$op$op$op;
   $77 = $76 + $53;
   $78 = $77;
   $i$01$i = 0;
   while(1) {
    $79 = (((($workc) + (($i$088*1792)|0)|0) + (($j$386*224)|0)|0) + ($i$01$i<<2)|0);
    $80 = +HEAPF32[$79>>2];
    $81 = $80 + $78;
    HEAPF32[$79>>2] = $81;
    $82 = (($i$01$i) + 1)|0;
    $exitcond$i = ($82|0)==(56);
    if ($exitcond$i) {
     break;
    } else {
     $i$01$i = $82;
    }
   }
   $83 = (($athc) + (($j$386*224)|0)|0);
   _memcpy(($83|0),($ath|0),224)|0;
   $84 = (+($j$386|0));
   $85 = $84 * 10.0;
   $86 = 70.0 - $85;
   $i$01$i17 = 0;
   while(1) {
    $87 = ((($athc) + (($j$386*224)|0)|0) + ($i$01$i17<<2)|0);
    $88 = +HEAPF32[$87>>2];
    $89 = $86 + $88;
    HEAPF32[$87>>2] = $89;
    $90 = (($i$01$i17) + 1)|0;
    $exitcond$i18 = ($90|0)==(56);
    if ($exitcond$i18) {
     $i$01$i15 = 0;
     break;
    } else {
     $i$01$i17 = $90;
    }
   }
   while(1) {
    $91 = (((($workc) + (($i$088*1792)|0)|0) + (($j$386*224)|0)|0) + ($i$01$i15<<2)|0);
    $92 = +HEAPF32[$91>>2];
    $93 = ((($athc) + (($j$386*224)|0)|0) + ($i$01$i15<<2)|0);
    $94 = +HEAPF32[$93>>2];
    $95 = $92 > $94;
    if ($95) {
     HEAPF32[$93>>2] = $92;
    }
    $96 = (($i$01$i15) + 1)|0;
    $exitcond$i16 = ($96|0)==(56);
    if ($exitcond$i16) {
     break;
    } else {
     $i$01$i15 = $96;
    }
   }
   $97 = (($j$386) + 1)|0;
   $exitcond116 = ($97|0)==(8);
   if ($exitcond116) {
    $j$487 = 1;
    break;
   } else {
    $j$386 = $97;
   }
  }
  while(1) {
   $98 = (($j$487) + -1)|0;
   $i$01$i12 = 0;
   while(1) {
    $99 = ((($athc) + (($98*224)|0)|0) + ($i$01$i12<<2)|0);
    $100 = +HEAPF32[$99>>2];
    $101 = ((($athc) + (($j$487*224)|0)|0) + ($i$01$i12<<2)|0);
    $102 = +HEAPF32[$101>>2];
    $103 = $100 < $102;
    if ($103) {
     HEAPF32[$101>>2] = $100;
    }
    $104 = (($i$01$i12) + 1)|0;
    $exitcond$i13 = ($104|0)==(56);
    if ($exitcond$i13) {
     $i$01$i10 = 0;
     break;
    } else {
     $i$01$i12 = $104;
    }
   }
   while(1) {
    $105 = ((($athc) + (($j$487*224)|0)|0) + ($i$01$i10<<2)|0);
    $106 = +HEAPF32[$105>>2];
    $107 = (((($workc) + (($i$088*1792)|0)|0) + (($j$487*224)|0)|0) + ($i$01$i10<<2)|0);
    $108 = +HEAPF32[$107>>2];
    $109 = $106 < $108;
    if ($109) {
     HEAPF32[$107>>2] = $106;
    }
    $110 = (($i$01$i10) + 1)|0;
    $exitcond$i11 = ($110|0)==(56);
    if ($exitcond$i11) {
     break;
    } else {
     $i$01$i10 = $110;
    }
   }
   $111 = (($j$487) + 1)|0;
   $exitcond117 = ($111|0)==(8);
   if ($exitcond117) {
    break;
   } else {
    $j$487 = $111;
   }
  }
  $112 = (($i$088) + 1)|0;
  $exitcond121 = ($112|0)==(17);
  if ($exitcond121) {
   break;
  } else {
   $i$088 = $112;
  }
 }
 $5 = $binHz;
 $6 = ($n|0)>(0);
 $7 = $n ^ -1;
 $i$158 = 0;
 while(1) {
  $113 = (_malloc(32)|0);
  $114 = (($2) + ($i$158<<2)|0);
  HEAP32[$114>>2] = $113;
  $115 = (+($i$158|0));
  $116 = $115 * 0.5;
  $117 = $115 * 0.34657350182533264;
  $118 = $117 + 4.1351653545408453;
  $119 = (+Math_exp((+$118)));
  $120 = $119 / $5;
  $121 = (+Math_floor((+$120)));
  $122 = (~~(($121)));
  $123 = (+($122|0));
  $124 = $123 * $binHz;
  $125 = $124 + 1.0;
  $126 = $125;
  $127 = (+Math_log((+$126)));
  $128 = $127 * 2.885390043258667;
  $129 = $128 + -11.931568145751953;
  $130 = (+Math_ceil((+$129)));
  $131 = (~~(($130)));
  $132 = (($122) + 1)|0;
  $133 = (+($132|0));
  $134 = $133 * $binHz;
  $135 = $134;
  $136 = (+Math_log((+$135)));
  $137 = $136 * 2.885390043258667;
  $138 = $137 + -11.931568145751953;
  $139 = (+Math_floor((+$138)));
  $140 = (~~(($139)));
  $141 = ($131|0)>($i$158|0);
  $i$1$ = $141 ? $i$158 : $131;
  $142 = ($i$1$|0)<(0);
  $lo_curve$1 = $142 ? 0 : $i$1$;
  $143 = ($140|0)>(16);
  $$5 = $143 ? 16 : $140;
  $144 = ($lo_curve$1|0)>($$5|0);
  $145 = (($i$158) + 1)|0;
  $146 = ($145|0)<(17);
  $147 = $116 + 3.9657840728759766;
  $m$055 = 0;
  while(1) {
   $148 = (_malloc(232)|0);
   $149 = (($113) + ($m$055<<2)|0);
   HEAP32[$149>>2] = $148;
   if ($6) {
    $j$533 = 0;
    while(1) {
     $150 = (($1) + ($j$533<<2)|0);
     HEAPF32[$150>>2] = 999.0;
     $151 = (($j$533) + 1)|0;
     $exitcond = ($151|0)==($n|0);
     if ($exitcond) {
      break;
     } else {
      $j$533 = $151;
     }
    }
   }
   if (!($144)) {
    $k$241 = $lo_curve$1;
    while(1) {
     $152 = (+($k$241|0));
     $153 = $152 * 0.5;
     $j$638 = 0;$l$037 = 0;
     while(1) {
      $157 = (+($j$638|0));
      $158 = $157 * 0.125;
      $159 = $158 + $153;
      $160 = $159 + 3.9032840728759766;
      $161 = $160 * 0.69314700365066528;
      $162 = (+Math_exp((+$161)));
      $163 = $162 / $5;
      $164 = (~~(($163)));
      $165 = $159 + 4.0282840728759766;
      $166 = $165 * 0.69314700365066528;
      $167 = (+Math_exp((+$166)));
      $168 = $167 / $5;
      $169 = $168 + 1.0;
      $170 = (~~(($169)));
      $171 = ($164|0)<(0);
      $$6 = $171 ? 0 : $164;
      $172 = ($$6|0)>($n|0);
      $lo_bin$1 = $172 ? $n : $$6;
      $173 = ($lo_bin$1|0)<($l$037|0);
      $lo_bin$1$l$0 = $173 ? $lo_bin$1 : $l$037;
      $174 = ($170|0)<(0);
      $hi_bin$0 = $174 ? 0 : $170;
      $175 = ($hi_bin$0|0)>($n|0);
      $n$hi_bin$0 = $175 ? $n : $hi_bin$0;
      $176 = ($lo_bin$1$l$0|0)<($n$hi_bin$0|0);
      $177 = ($lo_bin$1$l$0|0)<($n|0);
      $or$cond734 = $176 & $177;
      if ($or$cond734) {
       $178 = (((($workc) + (($k$241*1792)|0)|0) + (($m$055*224)|0)|0) + ($j$638<<2)|0);
       $179 = +HEAPF32[$178>>2];
       $180 = ($l$037|0)<($n|0);
       $181 = $180 ? $l$037 : $n;
       $182 = $181 ^ -1;
       $183 = ($164|0)>(0);
       $$op125 = $164 ^ -1;
       $184 = $183 ? $$op125 : -1;
       $185 = ($184|0)<($182|0);
       $smax92 = $185 ? $182 : $184;
       $186 = $smax92 ^ -1;
       $187 = ($170|0)>(0);
       $$op126 = $170 ^ -1;
       $188 = $187 ? $$op126 : -1;
       $189 = ($188|0)<($7|0);
       $smax94 = $189 ? $7 : $188;
       $190 = (($smax94) - ($smax92))|0;
       $191 = (($smax92) + ($n))|0;
       $192 = $191 ^ -1;
       $193 = ($190>>>0)>($192>>>0);
       $umax = $193 ? $190 : $192;
       $194 = (($186) - ($umax))|0;
       $l$235 = $lo_bin$1$l$0;
       while(1) {
        $195 = (($1) + ($l$235<<2)|0);
        $196 = +HEAPF32[$195>>2];
        $197 = $196 > $179;
        if ($197) {
         HEAPF32[$195>>2] = $179;
        }
        $198 = (($l$235) + 1)|0;
        $exitcond95 = ($198|0)==($194|0);
        if ($exitcond95) {
         $l$2$lcssa = $194;
         break;
        } else {
         $l$235 = $198;
        }
       }
      } else {
       $l$2$lcssa = $lo_bin$1$l$0;
      }
      $199 = (($j$638) + 1)|0;
      $exitcond96 = ($199|0)==(56);
      if ($exitcond96) {
       $l$2$lcssa$lcssa = $l$2$lcssa;
       break;
      } else {
       $j$638 = $199;$l$037 = $l$2$lcssa;
      }
     }
     $154 = ($l$2$lcssa$lcssa|0)<($n|0);
     if ($154) {
      $155 = ((((($workc) + (($k$241*1792)|0)|0) + (($m$055*224)|0)|0)) + 220|0);
      $156 = +HEAPF32[$155>>2];
      $l$339 = $l$2$lcssa$lcssa;
      while(1) {
       $200 = (($1) + ($l$339<<2)|0);
       $201 = +HEAPF32[$200>>2];
       $202 = $201 > $156;
       if ($202) {
        HEAPF32[$200>>2] = $156;
       }
       $203 = (($l$339) + 1)|0;
       $exitcond97 = ($203|0)==($n|0);
       if ($exitcond97) {
        break;
       } else {
        $l$339 = $203;
       }
      }
     }
     $204 = (($k$241) + 1)|0;
     $205 = ($k$241|0)<($$5|0);
     if ($205) {
      $k$241 = $204;
     } else {
      break;
     }
    }
   }
   if ($146) {
    $j$749 = 0;$l1$048 = 0;
    while(1) {
     $212 = (+($j$749|0));
     $213 = $212 * 0.125;
     $214 = $213 + $116;
     $215 = $214 + 3.9032840728759766;
     $216 = $215 * 0.69314700365066528;
     $217 = (+Math_exp((+$216)));
     $218 = $217 / $5;
     $219 = (~~(($218)));
     $220 = $214 + 4.0282840728759766;
     $221 = $220 * 0.69314700365066528;
     $222 = (+Math_exp((+$221)));
     $223 = $222 / $5;
     $224 = $223 + 1.0;
     $225 = (~~(($224)));
     $226 = ($219|0)<(0);
     $$8 = $226 ? 0 : $219;
     $227 = ($$8|0)>($n|0);
     $lo_bin2$1 = $227 ? $n : $$8;
     $228 = ($lo_bin2$1|0)<($l1$048|0);
     $lo_bin2$1$l1$0 = $228 ? $lo_bin2$1 : $l1$048;
     $229 = ($225|0)<(0);
     $hi_bin3$0 = $229 ? 0 : $225;
     $230 = ($hi_bin3$0|0)>($n|0);
     $n$hi_bin3$0 = $230 ? $n : $hi_bin3$0;
     $231 = ($lo_bin2$1$l1$0|0)<($n$hi_bin3$0|0);
     $232 = ($lo_bin2$1$l1$0|0)<($n|0);
     $or$cond943 = $231 & $232;
     if ($or$cond943) {
      $233 = (((($workc) + (($145*1792)|0)|0) + (($m$055*224)|0)|0) + ($j$749<<2)|0);
      $234 = +HEAPF32[$233>>2];
      $235 = ($l1$048|0)<($n|0);
      $236 = $235 ? $l1$048 : $n;
      $237 = $236 ^ -1;
      $238 = ($219|0)>(0);
      $$op123 = $219 ^ -1;
      $239 = $238 ? $$op123 : -1;
      $240 = ($239|0)<($237|0);
      $smax100 = $240 ? $237 : $239;
      $241 = $smax100 ^ -1;
      $242 = ($225|0)>(0);
      $$op124 = $225 ^ -1;
      $243 = $242 ? $$op124 : -1;
      $244 = ($243|0)<($7|0);
      $smax102 = $244 ? $7 : $243;
      $245 = (($smax102) - ($smax100))|0;
      $246 = (($smax100) + ($n))|0;
      $247 = $246 ^ -1;
      $248 = ($245>>>0)>($247>>>0);
      $umax103 = $248 ? $245 : $247;
      $249 = (($241) - ($umax103))|0;
      $l1$244 = $lo_bin2$1$l1$0;
      while(1) {
       $250 = (($1) + ($l1$244<<2)|0);
       $251 = +HEAPF32[$250>>2];
       $252 = $251 > $234;
       if ($252) {
        HEAPF32[$250>>2] = $234;
       }
       $253 = (($l1$244) + 1)|0;
       $exitcond104 = ($253|0)==($249|0);
       if ($exitcond104) {
        $l1$2$lcssa = $249;
        break;
       } else {
        $l1$244 = $253;
       }
      }
     } else {
      $l1$2$lcssa = $lo_bin2$1$l1$0;
     }
     $254 = (($j$749) + 1)|0;
     $exitcond105 = ($254|0)==(56);
     if ($exitcond105) {
      $l1$2$lcssa$lcssa = $l1$2$lcssa;
      break;
     } else {
      $j$749 = $254;$l1$048 = $l1$2$lcssa;
     }
    }
    $209 = ($l1$2$lcssa$lcssa|0)<($n|0);
    if ($209) {
     $210 = ((((($workc) + (($145*1792)|0)|0) + (($m$055*224)|0)|0)) + 220|0);
     $211 = +HEAPF32[$210>>2];
     $l1$350 = $l1$2$lcssa$lcssa;
     while(1) {
      $255 = (($1) + ($l1$350<<2)|0);
      $256 = +HEAPF32[$255>>2];
      $257 = $256 > $211;
      if ($257) {
       HEAPF32[$255>>2] = $211;
      }
      $258 = (($l1$350) + 1)|0;
      $exitcond106 = ($258|0)==($n|0);
      if ($exitcond106) {
       break;
      } else {
       $l1$350 = $258;
      }
     }
    }
   }
   $206 = (($113) + ($m$055<<2)|0);
   $207 = (($113) + ($m$055<<2)|0);
   $208 = (($113) + ($m$055<<2)|0);
   $j$852 = 0;
   while(1) {
    $262 = (+($j$852|0));
    $263 = $262 * 0.125;
    $264 = $147 + $263;
    $265 = $264 * 0.69314700365066528;
    $266 = (+Math_exp((+$265)));
    $267 = $266 / $5;
    $268 = (~~(($267)));
    $269 = ($268|0)<(0);
    do {
     if ($269) {
      $270 = (($j$852) + 2)|0;
      $271 = HEAP32[$206>>2]|0;
      $272 = (($271) + ($270<<2)|0);
      HEAPF32[$272>>2] = -999.0;
     } else {
      $273 = ($268|0)<($n|0);
      if ($273) {
       $277 = (($1) + ($268<<2)|0);
       $278 = HEAP32[$277>>2]|0;
       $279 = (($j$852) + 2)|0;
       $280 = HEAP32[$207>>2]|0;
       $281 = (($280) + ($279<<2)|0);
       HEAP32[$281>>2] = $278;
       break;
      } else {
       $274 = (($j$852) + 2)|0;
       $275 = HEAP32[$208>>2]|0;
       $276 = (($275) + ($274<<2)|0);
       HEAPF32[$276>>2] = -999.0;
       break;
      }
     }
    } while(0);
    $282 = (($j$852) + 1)|0;
    $exitcond107 = ($282|0)==(56);
    if ($exitcond107) {
     break;
    } else {
     $j$852 = $282;
    }
   }
   $259 = ((($148)) + 8|0);
   $260 = +HEAPF32[$259>>2];
   $261 = $260 > -200.0;
   do {
    if ($261) {
     $j$9$lcssa = 0.0;
    } else {
     $283 = ((($148)) + 12|0);
     $284 = +HEAPF32[$283>>2];
     $285 = $284 > -200.0;
     if ($285) {
      $j$9$lcssa = 1.0;
     } else {
      $295 = ((($148)) + 16|0);
      $296 = +HEAPF32[$295>>2];
      $297 = $296 > -200.0;
      if ($297) {
       $j$9$lcssa = 2.0;
      } else {
       $298 = ((($148)) + 20|0);
       $299 = +HEAPF32[$298>>2];
       $300 = $299 > -200.0;
       if ($300) {
        $j$9$lcssa = 3.0;
       } else {
        $301 = ((($148)) + 24|0);
        $302 = +HEAPF32[$301>>2];
        $303 = $302 > -200.0;
        if ($303) {
         $j$9$lcssa = 4.0;
        } else {
         $304 = ((($148)) + 28|0);
         $305 = +HEAPF32[$304>>2];
         $306 = $305 > -200.0;
         if ($306) {
          $j$9$lcssa = 5.0;
         } else {
          $307 = ((($148)) + 32|0);
          $308 = +HEAPF32[$307>>2];
          $309 = $308 > -200.0;
          if ($309) {
           $j$9$lcssa = 6.0;
          } else {
           $310 = ((($148)) + 36|0);
           $311 = +HEAPF32[$310>>2];
           $312 = $311 > -200.0;
           if ($312) {
            $j$9$lcssa = 7.0;
           } else {
            $313 = ((($148)) + 40|0);
            $314 = +HEAPF32[$313>>2];
            $315 = $314 > -200.0;
            if ($315) {
             $j$9$lcssa = 8.0;
            } else {
             $316 = ((($148)) + 44|0);
             $317 = +HEAPF32[$316>>2];
             $318 = $317 > -200.0;
             if ($318) {
              $j$9$lcssa = 9.0;
             } else {
              $319 = ((($148)) + 48|0);
              $320 = +HEAPF32[$319>>2];
              $321 = $320 > -200.0;
              if ($321) {
               $j$9$lcssa = 10.0;
              } else {
               $322 = ((($148)) + 52|0);
               $323 = +HEAPF32[$322>>2];
               $324 = $323 > -200.0;
               if ($324) {
                $j$9$lcssa = 11.0;
               } else {
                $325 = ((($148)) + 56|0);
                $326 = +HEAPF32[$325>>2];
                $327 = $326 > -200.0;
                if ($327) {
                 $j$9$lcssa = 12.0;
                } else {
                 $328 = ((($148)) + 60|0);
                 $329 = +HEAPF32[$328>>2];
                 $330 = $329 > -200.0;
                 if ($330) {
                  $j$9$lcssa = 13.0;
                 } else {
                  $331 = ((($148)) + 64|0);
                  $332 = +HEAPF32[$331>>2];
                  $333 = $332 > -200.0;
                  if ($333) {
                   $j$9$lcssa = 14.0;
                   break;
                  }
                  $334 = ((($148)) + 68|0);
                  $335 = +HEAPF32[$334>>2];
                  $336 = $335 > -200.0;
                  if ($336) {
                   $j$9$lcssa = 15.0;
                   break;
                  }
                  $j$9$lcssa = 16.0;
                 }
                }
               }
              }
             }
            }
           }
          }
         }
        }
       }
      }
     }
    }
   } while(0);
   HEAPF32[$148>>2] = $j$9$lcssa;
   $j$1054 = 55;
   while(1) {
    $286 = (($j$1054) + 2)|0;
    $287 = (($148) + ($286<<2)|0);
    $288 = +HEAPF32[$287>>2];
    $289 = $288 > -200.0;
    if ($289) {
     $j$10$lcssa = $j$1054;
     break;
    }
    $290 = (($j$1054) + -1)|0;
    $291 = ($290|0)>(17);
    if ($291) {
     $j$1054 = $290;
    } else {
     $j$10$lcssa = $290;
     break;
    }
   }
   $292 = (+($j$10$lcssa|0));
   $293 = ((($148)) + 4|0);
   HEAPF32[$293>>2] = $292;
   $294 = (($m$055) + 1)|0;
   $exitcond108 = ($294|0)==(8);
   if ($exitcond108) {
    break;
   } else {
    $m$055 = $294;
   }
  }
  $exitcond109 = ($145|0)==(17);
  if ($exitcond109) {
   break;
  } else {
   $i$158 = $145;
  }
 }
 STACKTOP = sp;return ($2|0);
}
function _bark_noise_hybridmp($n,$b,$f,$noise,$offset,$fixed) {
 $n = $n|0;
 $b = $b|0;
 $f = $f|0;
 $noise = $noise|0;
 $offset = +$offset;
 $fixed = $fixed|0;
 var $$alloca_mul = 0, $$alloca_mul1 = 0, $$alloca_mul3 = 0, $$alloca_mul5 = 0, $$alloca_mul7 = 0, $$in = 0, $$pn = 0, $0 = 0, $1 = 0, $10 = 0.0, $100 = 0, $101 = 0.0, $102 = 0.0, $103 = 0, $104 = 0.0, $105 = 0, $106 = 0.0, $107 = 0.0, $108 = 0, $109 = 0.0;
 var $11 = 0.0, $110 = 0, $111 = 0.0, $112 = 0.0, $113 = 0, $114 = 0.0, $115 = 0, $116 = 0.0, $117 = 0.0, $118 = 0.0, $119 = 0.0, $12 = 0, $120 = 0.0, $121 = 0.0, $122 = 0.0, $123 = 0.0, $124 = 0.0, $125 = 0.0, $126 = 0.0, $127 = 0.0;
 var $128 = 0.0, $129 = 0.0, $13 = 0, $130 = 0, $131 = 0.0, $132 = 0, $133 = 0, $134 = 0.0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0.0, $14 = 0, $140 = 0.0, $141 = 0.0, $142 = 0, $143 = 0.0, $144 = 0, $145 = 0;
 var $146 = 0.0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0.0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0.0, $162 = 0.0, $163 = 0;
 var $164 = 0.0, $165 = 0, $166 = 0.0, $167 = 0.0, $168 = 0, $169 = 0.0, $17 = 0.0, $170 = 0, $171 = 0.0, $172 = 0.0, $173 = 0, $174 = 0.0, $175 = 0, $176 = 0.0, $177 = 0.0, $178 = 0, $179 = 0.0, $18 = 0.0, $180 = 0, $181 = 0.0;
 var $182 = 0.0, $183 = 0.0, $184 = 0.0, $185 = 0.0, $186 = 0.0, $187 = 0.0, $188 = 0.0, $189 = 0.0, $19 = 0, $190 = 0.0, $191 = 0.0, $192 = 0.0, $193 = 0.0, $194 = 0.0, $195 = 0.0, $196 = 0, $197 = 0.0, $198 = 0, $199 = 0, $2 = 0;
 var $20 = 0.0, $200 = 0.0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0, $206 = 0.0, $207 = 0, $208 = 0.0, $209 = 0.0, $21 = 0.0, $210 = 0, $211 = 0.0, $212 = 0, $213 = 0.0, $214 = 0.0, $215 = 0, $216 = 0.0, $217 = 0;
 var $218 = 0.0, $219 = 0.0, $22 = 0.0, $220 = 0, $221 = 0.0, $222 = 0, $223 = 0.0, $224 = 0.0, $225 = 0, $226 = 0.0, $227 = 0, $228 = 0.0, $229 = 0.0, $23 = 0.0, $230 = 0.0, $231 = 0.0, $232 = 0.0, $233 = 0.0, $234 = 0.0, $235 = 0.0;
 var $236 = 0.0, $237 = 0.0, $238 = 0.0, $239 = 0.0, $24 = 0.0, $240 = 0.0, $241 = 0.0, $242 = 0.0, $243 = 0, $244 = 0.0, $245 = 0, $246 = 0, $247 = 0.0, $248 = 0, $249 = 0.0, $25 = 0.0, $250 = 0.0, $251 = 0.0, $252 = 0.0, $253 = 0;
 var $254 = 0.0, $255 = 0, $256 = 0, $257 = 0.0, $26 = 0.0, $27 = 0.0, $28 = 0.0, $29 = 0.0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0.0, $37 = 0, $38 = 0, $39 = 0, $4 = 0;
 var $40 = 0, $41 = 0, $42 = 0, $43 = 0.0, $44 = 0, $45 = 0, $46 = 0, $47 = 0.0, $48 = 0.0, $49 = 0, $5 = 0, $50 = 0.0, $51 = 0, $52 = 0.0, $53 = 0.0, $54 = 0, $55 = 0.0, $56 = 0, $57 = 0.0, $58 = 0.0;
 var $59 = 0, $6 = 0.0, $60 = 0.0, $61 = 0, $62 = 0.0, $63 = 0.0, $64 = 0, $65 = 0.0, $66 = 0, $67 = 0.0, $68 = 0.0, $69 = 0.0, $7 = 0.0, $70 = 0.0, $71 = 0.0, $72 = 0.0, $73 = 0.0, $74 = 0.0, $75 = 0.0, $76 = 0.0;
 var $77 = 0.0, $78 = 0.0, $79 = 0.0, $8 = 0, $80 = 0.0, $81 = 0, $82 = 0.0, $83 = 0, $84 = 0, $85 = 0.0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0.0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0.0;
 var $95 = 0, $96 = 0.0, $97 = 0.0, $98 = 0, $99 = 0.0, $A$0$lcssa = 0.0, $A$1$lcssa = 0.0, $A$2$lcssa = 0.0, $A$3$lcssa = 0.0, $B$0$lcssa = 0.0, $B$1$lcssa = 0.0, $B$2$lcssa = 0.0, $B$3$lcssa = 0.0, $D$0$lcssa = 0.0, $D$1$lcssa = 0.0, $D$2$lcssa = 0.0, $D$3$lcssa = 0.0, $R$0 = 0.0, $R$1 = 0.0, $R$2 = 0.0;
 var $exitcond = 0, $exitcond71 = 0, $exitcond72 = 0, $exitcond73 = 0, $exitcond74 = 0, $i$048 = 0, $i$1$lcssa = 0, $i$135 = 0, $i$2$lcssa = 0, $i$227 = 0, $i$324 = 0, $i$4$lcssa = 0, $i$415 = 0, $i$5$lcssa = 0, $i$58 = 0, $i$66 = 0, $tN$043 = 0.0, $tX$044 = 0.0, $tXX$045 = 0.0, $tXY$047 = 0.0;
 var $tY$046 = 0.0, $x$049 = 0.0, $x$1$lcssa = 0.0, $x$136 = 0.0, $x$2$lcssa = 0.0, $x$228 = 0.0, $x$325 = 0.0, $x$4$lcssa = 0.0, $x$416 = 0.0, $x$5$lcssa = 0.0, $x$59 = 0.0, $x$67 = 0.0, $y$0 = 0.0, $y$1 = 0.0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = $n << 2;
 $$alloca_mul = $0;
 $1 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul)|0)+15)&-16)|0;;
 $$alloca_mul1 = $0;
 $2 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul1)|0)+15)&-16)|0;;
 $$alloca_mul3 = $0;
 $3 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul3)|0)+15)&-16)|0;;
 $$alloca_mul5 = $0;
 $4 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul5)|0)+15)&-16)|0;;
 $$alloca_mul7 = $0;
 $5 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul7)|0)+15)&-16)|0;;
 $6 = +HEAPF32[$f>>2];
 $7 = $6 + $offset;
 $8 = $7 < 1.0;
 $y$0 = $8 ? 1.0 : $7;
 $9 = $y$0 * $y$0;
 $10 = $9 * 0.5;
 $11 = $10 * $y$0;
 HEAPF32[$1>>2] = $10;
 HEAPF32[$2>>2] = $10;
 HEAPF32[$3>>2] = 0.0;
 HEAPF32[$4>>2] = $11;
 HEAPF32[$5>>2] = 0.0;
 $12 = ($n|0)>(1);
 if ($12) {
  $i$048 = 1;$tN$043 = $10;$tX$044 = $10;$tXX$045 = 0.0;$tXY$047 = 0.0;$tY$046 = $11;$x$049 = 1.0;
  while(1) {
   $16 = (($f) + ($i$048<<2)|0);
   $17 = +HEAPF32[$16>>2];
   $18 = $17 + $offset;
   $19 = $18 < 1.0;
   $y$1 = $19 ? 1.0 : $18;
   $20 = $y$1 * $y$1;
   $21 = $20 + $tN$043;
   $22 = $20 * $x$049;
   $23 = $22 + $tX$044;
   $24 = $22 * $x$049;
   $25 = $24 + $tXX$045;
   $26 = $20 * $y$1;
   $27 = $26 + $tY$046;
   $28 = $22 * $y$1;
   $29 = $28 + $tXY$047;
   $30 = (($1) + ($i$048<<2)|0);
   HEAPF32[$30>>2] = $21;
   $31 = (($2) + ($i$048<<2)|0);
   HEAPF32[$31>>2] = $23;
   $32 = (($3) + ($i$048<<2)|0);
   HEAPF32[$32>>2] = $25;
   $33 = (($4) + ($i$048<<2)|0);
   HEAPF32[$33>>2] = $27;
   $34 = (($5) + ($i$048<<2)|0);
   HEAPF32[$34>>2] = $29;
   $35 = (($i$048) + 1)|0;
   $36 = $x$049 + 1.0;
   $exitcond74 = ($35|0)==($n|0);
   if ($exitcond74) {
    break;
   } else {
    $i$048 = $35;$tN$043 = $21;$tX$044 = $23;$tXX$045 = $25;$tXY$047 = $29;$tY$046 = $27;$x$049 = $36;
   }
  }
 }
 $13 = HEAP32[$b>>2]|0;
 $14 = $13 >> 16;
 $15 = ($14|0)>(-1);
 if ($15) {
  $38 = $13;$A$0$lcssa = 0.0;$B$0$lcssa = 0.0;$D$0$lcssa = 1.0;$i$1$lcssa = 0;$x$1$lcssa = 0.0;
 } else {
  $41 = $13;$45 = $14;$i$135 = 0;$x$136 = 0.0;
  while(1) {
   $40 = $41 & 65535;
   $42 = (($1) + ($40<<2)|0);
   $43 = +HEAPF32[$42>>2];
   $44 = (0 - ($45))|0;
   $46 = (($1) + ($44<<2)|0);
   $47 = +HEAPF32[$46>>2];
   $48 = $47 + $43;
   $49 = (($2) + ($40<<2)|0);
   $50 = +HEAPF32[$49>>2];
   $51 = (($2) + ($44<<2)|0);
   $52 = +HEAPF32[$51>>2];
   $53 = $50 - $52;
   $54 = (($3) + ($40<<2)|0);
   $55 = +HEAPF32[$54>>2];
   $56 = (($3) + ($44<<2)|0);
   $57 = +HEAPF32[$56>>2];
   $58 = $57 + $55;
   $59 = (($4) + ($40<<2)|0);
   $60 = +HEAPF32[$59>>2];
   $61 = (($4) + ($44<<2)|0);
   $62 = +HEAPF32[$61>>2];
   $63 = $62 + $60;
   $64 = (($5) + ($40<<2)|0);
   $65 = +HEAPF32[$64>>2];
   $66 = (($5) + ($44<<2)|0);
   $67 = +HEAPF32[$66>>2];
   $68 = $65 - $67;
   $69 = $63 * $58;
   $70 = $68 * $53;
   $71 = $69 - $70;
   $72 = $68 * $48;
   $73 = $63 * $53;
   $74 = $72 - $73;
   $75 = $58 * $48;
   $76 = $53 * $53;
   $77 = $75 - $76;
   $78 = $74 * $x$136;
   $79 = $78 + $71;
   $80 = $79 / $77;
   $81 = $80 < 0.0;
   $R$0 = $81 ? 0.0 : $80;
   $82 = $R$0 - $offset;
   $83 = (($noise) + ($i$135<<2)|0);
   HEAPF32[$83>>2] = $82;
   $84 = (($i$135) + 1)|0;
   $85 = $x$136 + 1.0;
   $86 = (($b) + ($84<<2)|0);
   $87 = HEAP32[$86>>2]|0;
   $88 = $87 >> 16;
   $89 = ($88|0)>(-1);
   if ($89) {
    $38 = $87;$A$0$lcssa = $71;$B$0$lcssa = $74;$D$0$lcssa = $77;$i$1$lcssa = $84;$x$1$lcssa = $85;
    break;
   } else {
    $41 = $87;$45 = $88;$i$135 = $84;$x$136 = $85;
   }
  }
 }
 $37 = $38 & 65535;
 $39 = ($37|0)<($n|0);
 if ($39) {
  $$in = $38;$93 = $37;$i$227 = $i$1$lcssa;$x$228 = $x$1$lcssa;
  while(1) {
   $91 = $$in >> 16;
   $92 = (($1) + ($93<<2)|0);
   $94 = +HEAPF32[$92>>2];
   $95 = (($1) + ($91<<2)|0);
   $96 = +HEAPF32[$95>>2];
   $97 = $94 - $96;
   $98 = (($2) + ($93<<2)|0);
   $99 = +HEAPF32[$98>>2];
   $100 = (($2) + ($91<<2)|0);
   $101 = +HEAPF32[$100>>2];
   $102 = $99 - $101;
   $103 = (($3) + ($93<<2)|0);
   $104 = +HEAPF32[$103>>2];
   $105 = (($3) + ($91<<2)|0);
   $106 = +HEAPF32[$105>>2];
   $107 = $104 - $106;
   $108 = (($4) + ($93<<2)|0);
   $109 = +HEAPF32[$108>>2];
   $110 = (($4) + ($91<<2)|0);
   $111 = +HEAPF32[$110>>2];
   $112 = $109 - $111;
   $113 = (($5) + ($93<<2)|0);
   $114 = +HEAPF32[$113>>2];
   $115 = (($5) + ($91<<2)|0);
   $116 = +HEAPF32[$115>>2];
   $117 = $114 - $116;
   $118 = $112 * $107;
   $119 = $117 * $102;
   $120 = $118 - $119;
   $121 = $117 * $97;
   $122 = $112 * $102;
   $123 = $121 - $122;
   $124 = $107 * $97;
   $125 = $102 * $102;
   $126 = $124 - $125;
   $127 = $123 * $x$228;
   $128 = $127 + $120;
   $129 = $128 / $126;
   $130 = $129 < 0.0;
   $R$1 = $130 ? 0.0 : $129;
   $131 = $R$1 - $offset;
   $132 = (($noise) + ($i$227<<2)|0);
   HEAPF32[$132>>2] = $131;
   $133 = (($i$227) + 1)|0;
   $134 = $x$228 + 1.0;
   $135 = (($b) + ($133<<2)|0);
   $136 = HEAP32[$135>>2]|0;
   $137 = $136 & 65535;
   $138 = ($137|0)<($n|0);
   if ($138) {
    $$in = $136;$93 = $137;$i$227 = $133;$x$228 = $134;
   } else {
    $A$1$lcssa = $120;$B$1$lcssa = $123;$D$1$lcssa = $126;$i$2$lcssa = $133;$x$2$lcssa = $134;
    break;
   }
  }
 } else {
  $A$1$lcssa = $A$0$lcssa;$B$1$lcssa = $B$0$lcssa;$D$1$lcssa = $D$0$lcssa;$i$2$lcssa = $i$1$lcssa;$x$2$lcssa = $x$1$lcssa;
 }
 $90 = ($i$2$lcssa|0)<($n|0);
 if ($90) {
  $i$324 = $i$2$lcssa;$x$325 = $x$2$lcssa;
  while(1) {
   $139 = $x$325 * $B$1$lcssa;
   $140 = $139 + $A$1$lcssa;
   $141 = $140 / $D$1$lcssa;
   $142 = $141 < 0.0;
   $R$2 = $142 ? 0.0 : $141;
   $143 = $R$2 - $offset;
   $144 = (($noise) + ($i$324<<2)|0);
   HEAPF32[$144>>2] = $143;
   $145 = (($i$324) + 1)|0;
   $146 = $x$325 + 1.0;
   $exitcond73 = ($145|0)==($n|0);
   if ($exitcond73) {
    break;
   } else {
    $i$324 = $145;$x$325 = $146;
   }
  }
 }
 $147 = ($fixed|0)<(1);
 if ($147) {
  STACKTOP = sp;return;
 }
 $148 = (($fixed|0) / 2)&-1;
 $149 = (($148) - ($fixed))|0;
 $150 = ($149|0)>(-1);
 if ($150) {
  $A$2$lcssa = $A$1$lcssa;$B$2$lcssa = $B$1$lcssa;$D$2$lcssa = $D$1$lcssa;$i$4$lcssa = 0;$x$4$lcssa = 0.0;
 } else {
  $151 = (($fixed) - ($148))|0;
  $156 = $148;$159 = $149;$i$415 = 0;$x$416 = 0.0;
  while(1) {
   $155 = (($1) + ($156<<2)|0);
   $157 = +HEAPF32[$155>>2];
   $158 = (0 - ($159))|0;
   $160 = (($1) + ($158<<2)|0);
   $161 = +HEAPF32[$160>>2];
   $162 = $161 + $157;
   $163 = (($2) + ($156<<2)|0);
   $164 = +HEAPF32[$163>>2];
   $165 = (($2) + ($158<<2)|0);
   $166 = +HEAPF32[$165>>2];
   $167 = $164 - $166;
   $168 = (($3) + ($156<<2)|0);
   $169 = +HEAPF32[$168>>2];
   $170 = (($3) + ($158<<2)|0);
   $171 = +HEAPF32[$170>>2];
   $172 = $171 + $169;
   $173 = (($4) + ($156<<2)|0);
   $174 = +HEAPF32[$173>>2];
   $175 = (($4) + ($158<<2)|0);
   $176 = +HEAPF32[$175>>2];
   $177 = $176 + $174;
   $178 = (($5) + ($156<<2)|0);
   $179 = +HEAPF32[$178>>2];
   $180 = (($5) + ($158<<2)|0);
   $181 = +HEAPF32[$180>>2];
   $182 = $179 - $181;
   $183 = $177 * $172;
   $184 = $182 * $167;
   $185 = $183 - $184;
   $186 = $182 * $162;
   $187 = $177 * $167;
   $188 = $186 - $187;
   $189 = $172 * $162;
   $190 = $167 * $167;
   $191 = $189 - $190;
   $192 = $188 * $x$416;
   $193 = $192 + $185;
   $194 = $193 / $191;
   $195 = $194 - $offset;
   $196 = (($noise) + ($i$415<<2)|0);
   $197 = +HEAPF32[$196>>2];
   $198 = $195 < $197;
   if ($198) {
    HEAPF32[$196>>2] = $195;
   }
   $199 = (($i$415) + 1)|0;
   $200 = $x$416 + 1.0;
   $201 = (($148) + ($199))|0;
   $202 = (($201) - ($fixed))|0;
   $exitcond72 = ($199|0)==($151|0);
   if ($exitcond72) {
    $A$2$lcssa = $185;$B$2$lcssa = $188;$D$2$lcssa = $191;$i$4$lcssa = $151;$x$4$lcssa = $200;
    break;
   } else {
    $156 = $201;$159 = $202;$i$415 = $199;$x$416 = $200;
   }
  }
 }
 $152 = (($i$4$lcssa) + ($148))|0;
 $153 = ($152|0)<($n|0);
 if ($153) {
  $154 = (($n) - ($148))|0;
  $$pn = $152;$i$58 = $i$4$lcssa;$x$59 = $x$4$lcssa;
  while(1) {
   $204 = (($$pn) - ($fixed))|0;
   $205 = (($1) + ($$pn<<2)|0);
   $206 = +HEAPF32[$205>>2];
   $207 = (($1) + ($204<<2)|0);
   $208 = +HEAPF32[$207>>2];
   $209 = $206 - $208;
   $210 = (($2) + ($$pn<<2)|0);
   $211 = +HEAPF32[$210>>2];
   $212 = (($2) + ($204<<2)|0);
   $213 = +HEAPF32[$212>>2];
   $214 = $211 - $213;
   $215 = (($3) + ($$pn<<2)|0);
   $216 = +HEAPF32[$215>>2];
   $217 = (($3) + ($204<<2)|0);
   $218 = +HEAPF32[$217>>2];
   $219 = $216 - $218;
   $220 = (($4) + ($$pn<<2)|0);
   $221 = +HEAPF32[$220>>2];
   $222 = (($4) + ($204<<2)|0);
   $223 = +HEAPF32[$222>>2];
   $224 = $221 - $223;
   $225 = (($5) + ($$pn<<2)|0);
   $226 = +HEAPF32[$225>>2];
   $227 = (($5) + ($204<<2)|0);
   $228 = +HEAPF32[$227>>2];
   $229 = $226 - $228;
   $230 = $224 * $219;
   $231 = $229 * $214;
   $232 = $230 - $231;
   $233 = $229 * $209;
   $234 = $224 * $214;
   $235 = $233 - $234;
   $236 = $219 * $209;
   $237 = $214 * $214;
   $238 = $236 - $237;
   $239 = $235 * $x$59;
   $240 = $239 + $232;
   $241 = $240 / $238;
   $242 = $241 - $offset;
   $243 = (($noise) + ($i$58<<2)|0);
   $244 = +HEAPF32[$243>>2];
   $245 = $242 < $244;
   if ($245) {
    HEAPF32[$243>>2] = $242;
   }
   $246 = (($i$58) + 1)|0;
   $247 = $x$59 + 1.0;
   $248 = (($246) + ($148))|0;
   $exitcond71 = ($246|0)==($154|0);
   if ($exitcond71) {
    $A$3$lcssa = $232;$B$3$lcssa = $235;$D$3$lcssa = $238;$i$5$lcssa = $154;$x$5$lcssa = $247;
    break;
   } else {
    $$pn = $248;$i$58 = $246;$x$59 = $247;
   }
  }
 } else {
  $A$3$lcssa = $A$2$lcssa;$B$3$lcssa = $B$2$lcssa;$D$3$lcssa = $D$2$lcssa;$i$5$lcssa = $i$4$lcssa;$x$5$lcssa = $x$4$lcssa;
 }
 $203 = ($i$5$lcssa|0)<($n|0);
 if ($203) {
  $i$66 = $i$5$lcssa;$x$67 = $x$5$lcssa;
 } else {
  STACKTOP = sp;return;
 }
 while(1) {
  $249 = $x$67 * $B$3$lcssa;
  $250 = $249 + $A$3$lcssa;
  $251 = $250 / $D$3$lcssa;
  $252 = $251 - $offset;
  $253 = (($noise) + ($i$66<<2)|0);
  $254 = +HEAPF32[$253>>2];
  $255 = $252 < $254;
  if ($255) {
   HEAPF32[$253>>2] = $252;
  }
  $256 = (($i$66) + 1)|0;
  $257 = $x$67 + 1.0;
  $exitcond = ($256|0)==($n|0);
  if ($exitcond) {
   break;
  } else {
   $i$66 = $256;$x$67 = $257;
  }
 }
 STACKTOP = sp;return;
}
function _seed_chase($seeds,$linesper,$n) {
 $seeds = $seeds|0;
 $linesper = $linesper|0;
 $n = $n|0;
 var $$alloca_mul = 0, $$alloca_mul1 = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0.0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0;
 var $25 = 0, $26 = 0.0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0.0, $39 = 0, $4 = 0, $40 = 0.0, $41 = 0, $42 = 0;
 var $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $6 = 0, $7 = 0, $8 = 0.0, $9 = 0, $endpos$0 = 0, $exitcond = 0;
 var $exitcond18 = 0, $exitcond19 = 0, $i$012 = 0, $i$17 = 0, $n$endpos$0 = 0, $or$cond = 0, $pos$06 = 0, $pos$1$lcssa = 0, $pos$15 = 0, $stack$011 = 0, $stack$1 = 0, $stack$1$lcssa = 0, $stack$1$lcssa23 = 0, $stack$2 = 0, $stack$2$in = 0, $stack$2$in$lcssa = 0, $stack$2$lcssa = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = $n << 2;
 $$alloca_mul = $0;
 $1 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul)|0)+15)&-16)|0;;
 $$alloca_mul1 = $0;
 $2 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul1)|0)+15)&-16)|0;;
 $3 = ($n|0)>(0);
 if ($3) {
  $i$012 = 0;$stack$011 = 0;
 } else {
  STACKTOP = sp;return;
 }
 while(1) {
  $6 = ($stack$011|0)<(2);
  do {
   if ($6) {
    $9 = (($1) + ($stack$011<<2)|0);
    HEAP32[$9>>2] = $i$012;
    $10 = (($seeds) + ($i$012<<2)|0);
    $11 = HEAP32[$10>>2]|0;
    $12 = (($2) + ($stack$011<<2)|0);
    HEAP32[$12>>2] = $11;
    $stack$2$in = $stack$011;
   } else {
    $7 = (($seeds) + ($i$012<<2)|0);
    $8 = +HEAPF32[$7>>2];
    $stack$1 = $stack$011;
    while(1) {
     $13 = (($stack$1) + -1)|0;
     $14 = (($2) + ($13<<2)|0);
     $15 = +HEAPF32[$14>>2];
     $16 = $8 < $15;
     if ($16) {
      $stack$1$lcssa = $stack$1;
      label = 8;
      break;
     }
     $19 = (($1) + ($13<<2)|0);
     $20 = HEAP32[$19>>2]|0;
     $21 = (($20) + ($linesper))|0;
     $22 = ($i$012|0)<($21|0);
     $23 = ($stack$1|0)>(1);
     $or$cond = $23 & $22;
     if (!($or$cond)) {
      $stack$1$lcssa23 = $stack$1;
      label = 12;
      break;
     }
     $24 = (($stack$1) + -2)|0;
     $25 = (($2) + ($24<<2)|0);
     $26 = +HEAPF32[$25>>2];
     $27 = !($15 <= $26);
     if ($27) {
      $stack$1$lcssa23 = $stack$1;
      label = 12;
      break;
     }
     $28 = (($1) + ($24<<2)|0);
     $29 = HEAP32[$28>>2]|0;
     $30 = (($29) + ($linesper))|0;
     $31 = ($i$012|0)<($30|0);
     if ($31) {
      $stack$1 = $13;
     } else {
      $stack$1$lcssa23 = $stack$1;
      label = 12;
      break;
     }
    }
    if ((label|0) == 8) {
     label = 0;
     $17 = (($1) + ($stack$1$lcssa<<2)|0);
     HEAP32[$17>>2] = $i$012;
     $18 = (($2) + ($stack$1$lcssa<<2)|0);
     HEAPF32[$18>>2] = $8;
     $stack$2$in = $stack$1$lcssa;
     break;
    }
    else if ((label|0) == 12) {
     label = 0;
     $32 = (($1) + ($stack$1$lcssa23<<2)|0);
     HEAP32[$32>>2] = $i$012;
     $33 = (($2) + ($stack$1$lcssa23<<2)|0);
     HEAPF32[$33>>2] = $8;
     $stack$2$in = $stack$1$lcssa23;
     break;
    }
   }
  } while(0);
  $stack$2 = (($stack$2$in) + 1)|0;
  $34 = (($i$012) + 1)|0;
  $exitcond19 = ($34|0)==($n|0);
  if ($exitcond19) {
   $stack$2$in$lcssa = $stack$2$in;$stack$2$lcssa = $stack$2;
   break;
  } else {
   $i$012 = $34;$stack$011 = $stack$2;
  }
 }
 $4 = ($stack$2$in$lcssa|0)>(-1);
 if (!($4)) {
  STACKTOP = sp;return;
 }
 $5 = (($linesper) + 1)|0;
 $i$17 = 0;$pos$06 = 0;
 while(1) {
  $35 = ($i$17|0)<($stack$2$in$lcssa|0);
  if ($35) {
   $36 = (($i$17) + 1)|0;
   $37 = (($2) + ($36<<2)|0);
   $38 = +HEAPF32[$37>>2];
   $39 = (($2) + ($i$17<<2)|0);
   $40 = +HEAPF32[$39>>2];
   $41 = $38 > $40;
   if ($41) {
    $42 = (($1) + ($36<<2)|0);
    $43 = HEAP32[$42>>2]|0;
    $endpos$0 = $43;
   } else {
    label = 17;
   }
  } else {
   label = 17;
  }
  if ((label|0) == 17) {
   label = 0;
   $44 = (($1) + ($i$17<<2)|0);
   $45 = HEAP32[$44>>2]|0;
   $46 = (($5) + ($45))|0;
   $endpos$0 = $46;
  }
  $47 = ($endpos$0|0)>($n|0);
  $n$endpos$0 = $47 ? $n : $endpos$0;
  $48 = ($pos$06|0)<($n$endpos$0|0);
  if ($48) {
   $49 = (($2) + ($i$17<<2)|0);
   $50 = HEAP32[$49>>2]|0;
   $51 = ($endpos$0|0)<($n|0);
   $52 = $51 ? $endpos$0 : $n;
   $pos$15 = $pos$06;
   while(1) {
    $53 = (($seeds) + ($pos$15<<2)|0);
    HEAP32[$53>>2] = $50;
    $54 = (($pos$15) + 1)|0;
    $exitcond = ($54|0)==($52|0);
    if ($exitcond) {
     $pos$1$lcssa = $52;
     break;
    } else {
     $pos$15 = $54;
    }
   }
  } else {
   $pos$1$lcssa = $pos$06;
  }
  $55 = (($i$17) + 1)|0;
  $exitcond18 = ($55|0)==($stack$2$lcssa|0);
  if ($exitcond18) {
   break;
  } else {
   $i$17 = $55;$pos$06 = $pos$1$lcssa;
  }
 }
 STACKTOP = sp;return;
}
function _noise_normalize($p$0$1$val,$limit,$r,$q,$f,$flags,$i,$n,$out) {
 $p$0$1$val = $p$0$1$val|0;
 $limit = $limit|0;
 $r = $r|0;
 $q = $q|0;
 $f = $f|0;
 $flags = $flags|0;
 $i = $i|0;
 $n = $n|0;
 $out = $out|0;
 var $$06 = 0.0, $$1 = 0.0, $$1$lcssa = 0.0, $$22 = 0.0, $$3 = 0.0, $$4 = 0.0, $$alloca_mul = 0, $$sink = 0, $$sink$in = 0.0, $$sink17 = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0;
 var $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0.0, $22 = 0, $23 = 0.0, $24 = 0.0, $25 = 0, $26 = 0.0, $27 = 0, $28 = 0.0, $29 = 0.0, $3 = 0, $30 = 0.0, $31 = 0.0, $32 = 0, $33 = 0, $34 = 0, $35 = 0;
 var $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0.0, $42 = 0, $43 = 0.0, $44 = 0.0, $45 = 0, $46 = 0, $47 = 0.0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0.0, $52 = 0, $53 = 0.0;
 var $54 = 0.0, $55 = 0.0, $56 = 0.0, $57 = 0, $58 = 0, $59 = 0.0, $6 = 0, $60 = 0.0, $61 = 0.0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0.0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0;
 var $72 = 0, $73 = 0.0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0.0, $8 = 0, $80 = 0, $81 = 0.0, $82 = 0, $83 = 0.0, $84 = 0, $85 = 0, $9 = 0, $count$03 = 0, $count$1 = 0, $count$1$lcssa = 0, $exitcond = 0;
 var $exitcond15 = 0, $exitcond16 = 0, $j$0$lcssa = 0, $j$010 = 0, $j$14 = 0, $j$21 = 0, $n$ = 0, $or$cond = 0, $or$cond18 = 0, $storemerge = 0.0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = $n << 2;
 $$alloca_mul = $0;
 $1 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul)|0)+15)&-16)|0;;
 $2 = ((($p$0$1$val)) + 500|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ($3|0)==(0);
 if ($4) {
  $8 = $n;
 } else {
  $5 = ((($p$0$1$val)) + 504|0);
  $6 = HEAP32[$5>>2]|0;
  $7 = (($6) - ($i))|0;
  $8 = $7;
 }
 $9 = ($8|0)>($n|0);
 $n$ = $9 ? $n : $8;
 $10 = ($n$|0)>(0);
 if ($10) {
  $11 = ($flags|0)==(0|0);
  $12 = ($8|0)<($n|0);
  $13 = $12 ? $8 : $n;
  $j$010 = 0;
  while(1) {
   if ($11) {
    label = 9;
   } else {
    $17 = (($flags) + ($j$010<<2)|0);
    $18 = HEAP32[$17>>2]|0;
    $19 = ($18|0)==(0);
    if ($19) {
     label = 9;
    }
   }
   do {
    if ((label|0) == 9) {
     label = 0;
     $20 = (($q) + ($j$010<<2)|0);
     $21 = +HEAPF32[$20>>2];
     $22 = (($f) + ($j$010<<2)|0);
     $23 = +HEAPF32[$22>>2];
     $24 = $21 / $23;
     $25 = (($r) + ($j$010<<2)|0);
     $26 = +HEAPF32[$25>>2];
     $27 = $26 < 0.0;
     $28 = $24;
     $29 = (+Math_sqrt((+$28)));
     $30 = (+_rint($29));
     if ($27) {
      $31 = -$30;
      $32 = (~~(($31)));
      $33 = (($out) + ($j$010<<2)|0);
      HEAP32[$33>>2] = $32;
      break;
     } else {
      $34 = (~~(($30)));
      $35 = (($out) + ($j$010<<2)|0);
      HEAP32[$35>>2] = $34;
      break;
     }
    }
   } while(0);
   $36 = (($j$010) + 1)|0;
   $exitcond16 = ($36|0)==($13|0);
   if ($exitcond16) {
    $j$0$lcssa = $13;
    break;
   } else {
    $j$010 = $36;
   }
  }
 } else {
  $j$0$lcssa = 0;
 }
 $14 = ($j$0$lcssa|0)<($n|0);
 if (!($14)) {
  $$4 = 0.0;
  STACKTOP = sp;return (+$$4);
 }
 $15 = ($flags|0)!=(0|0);
 $16 = (($limit) - ($i))|0;
 $$06 = 0.0;$count$03 = 0;$j$14 = $j$0$lcssa;
 while(1) {
  if ($15) {
   $37 = (($flags) + ($j$14<<2)|0);
   $38 = HEAP32[$37>>2]|0;
   $39 = ($38|0)==(0);
   if ($39) {
    label = 15;
   } else {
    $$1 = $$06;$count$1 = $count$03;
   }
  } else {
   label = 15;
  }
  do {
   if ((label|0) == 15) {
    label = 0;
    $40 = (($q) + ($j$14<<2)|0);
    $41 = +HEAPF32[$40>>2];
    $42 = (($f) + ($j$14<<2)|0);
    $43 = +HEAPF32[$42>>2];
    $44 = $41 / $43;
    $45 = !($44 < 0.25);
    $46 = ($j$14|0)<($16|0);
    $or$cond = $15 & $46;
    $or$cond18 = $45 | $or$cond;
    if ($or$cond18) {
     $50 = (($r) + ($j$14<<2)|0);
     $51 = +HEAPF32[$50>>2];
     $52 = $51 < 0.0;
     $53 = $44;
     $54 = (+Math_sqrt((+$53)));
     $55 = (+_rint($54));
     $56 = -$55;
     $$sink$in = $52 ? $56 : $55;
     $$sink = (~~(($$sink$in)));
     $57 = (($out) + ($j$14<<2)|0);
     HEAP32[$57>>2] = $$sink;
     $58 = Math_imul($$sink, $$sink)|0;
     $59 = (+($58|0));
     $60 = +HEAPF32[$42>>2];
     $61 = $59 * $60;
     HEAPF32[$40>>2] = $61;
     $$1 = $$06;$count$1 = $count$03;
     break;
    } else {
     $47 = $44 + $$06;
     $48 = (($count$03) + 1)|0;
     $49 = (($1) + ($count$03<<2)|0);
     HEAP32[$49>>2] = $40;
     $$1 = $47;$count$1 = $48;
     break;
    }
   }
  } while(0);
  $62 = (($j$14) + 1)|0;
  $exitcond15 = ($62|0)==($n|0);
  if ($exitcond15) {
   $$1$lcssa = $$1;$count$1$lcssa = $count$1;
   break;
  } else {
   $$06 = $$1;$count$03 = $count$1;$j$14 = $62;
  }
 }
 $63 = ($count$1$lcssa|0)==(0);
 if ($63) {
  $$4 = $$1$lcssa;
  STACKTOP = sp;return (+$$4);
 }
 _qsort($1,$count$1$lcssa,4,9);
 $64 = ($count$1$lcssa|0)>(0);
 if (!($64)) {
  $$4 = $$1$lcssa;
  STACKTOP = sp;return (+$$4);
 }
 $65 = $q;
 $66 = ((($p$0$1$val)) + 512|0);
 $67 = +HEAPF64[$66>>3];
 $$22 = $$1$lcssa;$j$21 = 0;
 while(1) {
  $68 = (($1) + ($j$21<<2)|0);
  $69 = HEAP32[$68>>2]|0;
  $70 = $69;
  $71 = (($70) - ($65))|0;
  $72 = $71 >> 2;
  $73 = $$22;
  $74 = !($73 >= $67);
  if ($74) {
   $$3 = $$22;$$sink17 = 0;$storemerge = 0.0;
  } else {
   $75 = (($r) + ($72<<2)|0);
   $76 = HEAP32[$75>>2]|0;
   $77 = $76 & -2147483648;
   $78 = $77 | 1065353216;
   $79 = (HEAP32[tempDoublePtr>>2]=$78,+HEAPF32[tempDoublePtr>>2]);
   $80 = (~~(($79)));
   $81 = $$22 + -1.0;
   $82 = (($f) + ($72<<2)|0);
   $83 = +HEAPF32[$82>>2];
   $$3 = $81;$$sink17 = $80;$storemerge = $83;
  }
  $84 = (($out) + ($72<<2)|0);
  HEAP32[$84>>2] = $$sink17;
  HEAPF32[$69>>2] = $storemerge;
  $85 = (($j$21) + 1)|0;
  $exitcond = ($85|0)==($count$1$lcssa|0);
  if ($exitcond) {
   $$4 = $$3;
   break;
  } else {
   $$22 = $$3;$j$21 = $85;
  }
 }
 STACKTOP = sp;return (+$$4);
}
function _apsort($a,$b) {
 $a = $a|0;
 $b = $b|0;
 var $0 = 0, $1 = 0.0, $2 = 0, $3 = 0.0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = HEAP32[$a>>2]|0;
 $1 = +HEAPF32[$0>>2];
 $2 = HEAP32[$b>>2]|0;
 $3 = +HEAPF32[$2>>2];
 $4 = $1 < $3;
 $5 = $4&1;
 $6 = $1 > $3;
 $7 = $6&1;
 $8 = (($5) - ($7))|0;
 return ($8|0);
}
function _res0_free_info($i) {
 $i = $i|0;
 var $0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ($i|0)==(0|0);
 if (!($0)) {
  _free($i);
 }
 return;
}
function _res0_free_look($i) {
 $i = $i|0;
 var $$pre = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0;
 var $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $j$03 = 0, $j$12 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ($i|0)==(0|0);
 if ($0) {
  return;
 }
 $1 = ((($i)) + 4|0);
 $2 = HEAP32[$1>>2]|0;
 $3 = ($2|0)>(0);
 $4 = ((($i)) + 20|0);
 if ($3) {
  $24 = $2;$j$03 = 0;
  while(1) {
   $5 = HEAP32[$4>>2]|0;
   $6 = (($5) + ($j$03<<2)|0);
   $7 = HEAP32[$6>>2]|0;
   $8 = ($7|0)==(0|0);
   if ($8) {
    $11 = $24;
   } else {
    _free($7);
    $$pre = HEAP32[$1>>2]|0;
    $11 = $$pre;
   }
   $9 = (($j$03) + 1)|0;
   $10 = ($9|0)<($11|0);
   if ($10) {
    $24 = $11;$j$03 = $9;
   } else {
    break;
   }
  }
 }
 $12 = HEAP32[$4>>2]|0;
 _free($12);
 $13 = ((($i)) + 24|0);
 $14 = HEAP32[$13>>2]|0;
 $15 = ($14|0)>(0);
 $16 = ((($i)) + 28|0);
 if ($15) {
  $j$12 = 0;
  while(1) {
   $17 = HEAP32[$16>>2]|0;
   $18 = (($17) + ($j$12<<2)|0);
   $19 = HEAP32[$18>>2]|0;
   _free($19);
   $20 = (($j$12) + 1)|0;
   $21 = HEAP32[$13>>2]|0;
   $22 = ($20|0)<($21|0);
   if ($22) {
    $j$12 = $20;
   } else {
    break;
   }
  }
 }
 $23 = HEAP32[$16>>2]|0;
 _free($23);
 _free($i);
 return;
}
function _res0_pack($vr,$opb) {
 $vr = $vr|0;
 $opb = $opb|0;
 var $$01$i = 0, $$lcssa10 = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0;
 var $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $acc$03 = 0, $exitcond = 0;
 var $j$02 = 0, $j$11 = 0, $ret$0$lcssa$i = 0, $ret$02$i = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = HEAP32[$vr>>2]|0;
 _oggpack_write($opb,$0,24);
 $1 = ((($vr)) + 4|0);
 $2 = HEAP32[$1>>2]|0;
 _oggpack_write($opb,$2,24);
 $3 = ((($vr)) + 8|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = (($4) + -1)|0;
 _oggpack_write($opb,$5,24);
 $6 = ((($vr)) + 12|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = (($7) + -1)|0;
 _oggpack_write($opb,$8,6);
 $9 = ((($vr)) + 20|0);
 $10 = HEAP32[$9>>2]|0;
 _oggpack_write($opb,$10,8);
 $11 = HEAP32[$6>>2]|0;
 $12 = ($11|0)>(0);
 if (!($12)) {
  return;
 }
 $13 = ((($vr)) + 24|0);
 $acc$03 = 0;$j$02 = 0;
 while(1) {
  $16 = (($13) + ($j$02<<2)|0);
  $17 = HEAP32[$16>>2]|0;
  $18 = (_ov_ilog($17)|0);
  $19 = ($18|0)>(3);
  $20 = HEAP32[$16>>2]|0;
  if ($19) {
   _oggpack_write($opb,$20,3);
   _oggpack_write($opb,1,1);
   $21 = HEAP32[$16>>2]|0;
   $22 = $21 >> 3;
   _oggpack_write($opb,$22,5);
  } else {
   _oggpack_write($opb,$20,4);
  }
  $23 = HEAP32[$16>>2]|0;
  $24 = ($23|0)==(0);
  if ($24) {
   $ret$0$lcssa$i = 0;
  } else {
   $$01$i = $23;$ret$02$i = 0;
   while(1) {
    $25 = $$01$i & 1;
    $26 = (($25) + ($ret$02$i))|0;
    $27 = $$01$i >>> 1;
    $28 = ($27|0)==(0);
    if ($28) {
     $ret$0$lcssa$i = $26;
     break;
    } else {
     $$01$i = $27;$ret$02$i = $26;
    }
   }
  }
  $29 = (($ret$0$lcssa$i) + ($acc$03))|0;
  $30 = (($j$02) + 1)|0;
  $31 = HEAP32[$6>>2]|0;
  $32 = ($30|0)<($31|0);
  if ($32) {
   $acc$03 = $29;$j$02 = $30;
  } else {
   $$lcssa10 = $29;
   break;
  }
 }
 $14 = ($$lcssa10|0)>(0);
 if (!($14)) {
  return;
 }
 $15 = ((($vr)) + 280|0);
 $j$11 = 0;
 while(1) {
  $33 = (($15) + ($j$11<<2)|0);
  $34 = HEAP32[$33>>2]|0;
  _oggpack_write($opb,$34,8);
  $35 = (($j$11) + 1)|0;
  $exitcond = ($35|0)==($$lcssa10|0);
  if ($exitcond) {
   break;
  } else {
   $j$11 = $35;
  }
 }
 return;
}
function _res0_unpack($vi,$opb) {
 $vi = $vi|0;
 $opb = $opb|0;
 var $$0 = 0, $$01$i = 0, $$lcssa36 = 0, $$lcssa37 = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0;
 var $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0;
 var $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0;
 var $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $8 = 0, $9 = 0, $acc$0$lcssa23 = 0, $acc$017 = 0, $cascade$0 = 0, $dim$09 = 0, $j$018 = 0;
 var $j$114 = 0, $j$211 = 0, $partvals$010 = 0, $ret$0$lcssa$i = 0, $ret$02$i = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = (_calloc(1,2840)|0);
 $1 = ((($vi)) + 28|0);
 $2 = HEAP32[$1>>2]|0;
 $3 = (_oggpack_read($opb,24)|0);
 HEAP32[$0>>2] = $3;
 $4 = (_oggpack_read($opb,24)|0);
 $5 = ((($0)) + 4|0);
 HEAP32[$5>>2] = $4;
 $6 = (_oggpack_read($opb,24)|0);
 $7 = (($6) + 1)|0;
 $8 = ((($0)) + 8|0);
 HEAP32[$8>>2] = $7;
 $9 = (_oggpack_read($opb,6)|0);
 $10 = (($9) + 1)|0;
 $11 = ((($0)) + 12|0);
 HEAP32[$11>>2] = $10;
 $12 = (_oggpack_read($opb,8)|0);
 $13 = ((($0)) + 20|0);
 HEAP32[$13>>2] = $12;
 $14 = ($12|0)<(0);
 L1: do {
  if ($14) {
   label = 26;
  } else {
   $15 = ($9|0)>(-1);
   if ($15) {
    $16 = ((($0)) + 24|0);
    $acc$017 = 0;$j$018 = 0;
    while(1) {
     $19 = (_oggpack_read($opb,3)|0);
     $20 = (_oggpack_read($opb,1)|0);
     $21 = ($20|0)<(0);
     if ($21) {
      label = 26;
      break L1;
     }
     $22 = ($20|0)==(0);
     if ($22) {
      $cascade$0 = $19;
     } else {
      $23 = (_oggpack_read($opb,5)|0);
      $24 = ($23|0)<(0);
      if ($24) {
       label = 26;
       break L1;
      }
      $25 = $23 << 3;
      $26 = $25 | $19;
      $cascade$0 = $26;
     }
     $27 = (($16) + ($j$018<<2)|0);
     HEAP32[$27>>2] = $cascade$0;
     $28 = ($cascade$0|0)==(0);
     if ($28) {
      $ret$0$lcssa$i = 0;
     } else {
      $$01$i = $cascade$0;$ret$02$i = 0;
      while(1) {
       $29 = $$01$i & 1;
       $30 = (($29) + ($ret$02$i))|0;
       $31 = $$01$i >>> 1;
       $32 = ($31|0)==(0);
       if ($32) {
        $ret$0$lcssa$i = $30;
        break;
       } else {
        $$01$i = $31;$ret$02$i = $30;
       }
      }
     }
     $33 = (($ret$0$lcssa$i) + ($acc$017))|0;
     $34 = (($j$018) + 1)|0;
     $35 = HEAP32[$11>>2]|0;
     $36 = ($34|0)<($35|0);
     if ($36) {
      $acc$017 = $33;$j$018 = $34;
     } else {
      $$lcssa37 = $33;
      break;
     }
    }
    $17 = ($$lcssa37|0)>(0);
    if ($17) {
     $18 = ((($0)) + 280|0);
     $j$114 = 0;
     while(1) {
      $37 = (_oggpack_read($opb,8)|0);
      $38 = ($37|0)<(0);
      if ($38) {
       break L1;
      }
      $39 = (($18) + ($j$114<<2)|0);
      HEAP32[$39>>2] = $37;
      $40 = (($j$114) + 1)|0;
      $41 = ($40|0)<($$lcssa37|0);
      if ($41) {
       $j$114 = $40;
      } else {
       $70 = $17;$acc$0$lcssa23 = $$lcssa37;
       break;
      }
     }
    } else {
     $70 = 0;$acc$0$lcssa23 = $$lcssa37;
    }
   } else {
    $70 = 0;$acc$0$lcssa23 = 0;
   }
   $42 = HEAP32[$13>>2]|0;
   $43 = ((($2)) + 24|0);
   $44 = HEAP32[$43>>2]|0;
   $45 = ($42|0)<($44|0);
   if ($45) {
    if ($70) {
     $46 = ((($0)) + 280|0);
     $j$211 = 0;
     while(1) {
      $49 = (($46) + ($j$211<<2)|0);
      $50 = HEAP32[$49>>2]|0;
      $51 = ($50|0)<($44|0);
      if (!($51)) {
       break L1;
      }
      $52 = (((($2)) + 1824|0) + ($50<<2)|0);
      $53 = HEAP32[$52>>2]|0;
      $54 = ((($53)) + 12|0);
      $55 = HEAP32[$54>>2]|0;
      $56 = ($55|0)==(0);
      $47 = (($j$211) + 1)|0;
      if ($56) {
       break L1;
      }
      $48 = ($47|0)<($acc$0$lcssa23|0);
      if ($48) {
       $j$211 = $47;
      } else {
       break;
      }
     }
    }
    $57 = (((($2)) + 1824|0) + ($42<<2)|0);
    $58 = HEAP32[$57>>2]|0;
    $59 = ((($58)) + 4|0);
    $60 = HEAP32[$59>>2]|0;
    $61 = HEAP32[$58>>2]|0;
    $62 = ($61|0)<(1);
    if (!($62)) {
     $63 = HEAP32[$11>>2]|0;
     $dim$09 = $61;$partvals$010 = 1;
     while(1) {
      $66 = Math_imul($63, $partvals$010)|0;
      $67 = ($66|0)>($60|0);
      if ($67) {
       break L1;
      }
      $64 = (($dim$09) + -1)|0;
      $65 = ($dim$09|0)>(1);
      if ($65) {
       $dim$09 = $64;$partvals$010 = $66;
      } else {
       $$lcssa36 = $66;
       break;
      }
     }
     $68 = ((($0)) + 16|0);
     HEAP32[$68>>2] = $$lcssa36;
     $$0 = $0;
     return ($$0|0);
    }
   }
  }
 } while(0);
 if ((label|0) == 26) {
  $69 = ($0|0)==(0|0);
  if ($69) {
   $$0 = 0;
   return ($$0|0);
  }
 }
 _free($0);
 $$0 = 0;
 return ($$0|0);
}
function _res0_look($vd,$vr) {
 $vd = $vd|0;
 $vr = $vr|0;
 var $$lcssa = 0, $$maxstage$0 = 0, $$pn = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0;
 var $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0;
 var $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0;
 var $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $8 = 0, $9 = 0, $acc$016 = 0, $acc$112 = 0, $acc$2 = 0, $acc$3 = 0;
 var $exitcond = 0, $exitcond23 = 0, $exitcond24 = 0, $j$018 = 0, $j$18 = 0, $j$24 = 0, $j$24$us = 0, $k$013 = 0, $k$11$us = 0, $maxstage$0$lcssa = 0, $maxstage$017 = 0, $maxstage$2 = 0, $mult$03$us = 0, $val$02$us = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = (_calloc(1,44)|0);
 $1 = ((($vd)) + 4|0);
 $2 = HEAP32[$1>>2]|0;
 $3 = ((($2)) + 28|0);
 $4 = HEAP32[$3>>2]|0;
 HEAP32[$0>>2] = $vr;
 $5 = ((($vr)) + 12|0);
 $6 = HEAP32[$5>>2]|0;
 $7 = ((($0)) + 4|0);
 HEAP32[$7>>2] = $6;
 $8 = ((($4)) + 2848|0);
 $9 = HEAP32[$8>>2]|0;
 $10 = ((($0)) + 12|0);
 HEAP32[$10>>2] = $9;
 $11 = $9;
 $12 = ((($vr)) + 20|0);
 $13 = HEAP32[$12>>2]|0;
 $14 = (($11) + (($13*56)|0)|0);
 $15 = ((($0)) + 16|0);
 HEAP32[$15>>2] = $14;
 $16 = HEAP32[$14>>2]|0;
 $17 = (_calloc($6,4)|0);
 $18 = ((($0)) + 20|0);
 HEAP32[$18>>2] = $17;
 $19 = ($6|0)>(0);
 if ($19) {
  $20 = ((($vr)) + 24|0);
  $21 = ((($vr)) + 280|0);
  $acc$016 = 0;$j$018 = 0;$maxstage$017 = 0;
  while(1) {
   $22 = (($20) + ($j$018<<2)|0);
   $23 = HEAP32[$22>>2]|0;
   $24 = (_ov_ilog($23)|0);
   $25 = ($24|0)==(0);
   if ($25) {
    $acc$3 = $acc$016;$maxstage$2 = $maxstage$017;
   } else {
    $26 = ($24|0)>($maxstage$017|0);
    $$maxstage$0 = $26 ? $24 : $maxstage$017;
    $27 = (_calloc($24,4)|0);
    $28 = (($17) + ($j$018<<2)|0);
    HEAP32[$28>>2] = $27;
    $29 = ($24|0)>(0);
    if ($29) {
     $30 = HEAP32[$22>>2]|0;
     $31 = (($17) + ($j$018<<2)|0);
     $acc$112 = $acc$016;$k$013 = 0;
     while(1) {
      $32 = 1 << $k$013;
      $33 = $30 & $32;
      $34 = ($33|0)==(0);
      if ($34) {
       $acc$2 = $acc$112;
      } else {
       $35 = HEAP32[$8>>2]|0;
       $36 = (($acc$112) + 1)|0;
       $37 = (($21) + ($acc$112<<2)|0);
       $38 = HEAP32[$37>>2]|0;
       $39 = (($35) + (($38*56)|0)|0);
       $40 = HEAP32[$31>>2]|0;
       $41 = (($40) + ($k$013<<2)|0);
       HEAP32[$41>>2] = $39;
       $acc$2 = $36;
      }
      $42 = (($k$013) + 1)|0;
      $exitcond23 = ($42|0)==($24|0);
      if ($exitcond23) {
       $acc$3 = $acc$2;$maxstage$2 = $$maxstage$0;
       break;
      } else {
       $acc$112 = $acc$2;$k$013 = $42;
      }
     }
    } else {
     $acc$3 = $acc$016;$maxstage$2 = $$maxstage$0;
    }
   }
   $43 = (($j$018) + 1)|0;
   $44 = ($43|0)<($6|0);
   if ($44) {
    $acc$016 = $acc$3;$j$018 = $43;$maxstage$017 = $maxstage$2;
   } else {
    $maxstage$0$lcssa = $maxstage$2;
    break;
   }
  }
 } else {
  $maxstage$0$lcssa = 0;
 }
 $45 = ((($0)) + 24|0);
 HEAP32[$45>>2] = 1;
 $46 = ($16|0)>(0);
 if ($46) {
  $48 = 1;$j$18 = 0;
  while(1) {
   $47 = Math_imul($48, $6)|0;
   $49 = (($j$18) + 1)|0;
   $exitcond = ($49|0)==($16|0);
   if ($exitcond) {
    $$lcssa = $47;
    break;
   } else {
    $48 = $47;$j$18 = $49;
   }
  }
  HEAP32[$45>>2] = $$lcssa;
  $52 = $$lcssa;
 } else {
  $52 = 1;
 }
 $50 = ((($0)) + 8|0);
 HEAP32[$50>>2] = $maxstage$0$lcssa;
 $51 = $52 << 2;
 $53 = (_malloc($51)|0);
 $54 = ((($0)) + 28|0);
 HEAP32[$54>>2] = $53;
 $55 = ($52|0)>(0);
 if (!($55)) {
  return ($0|0);
 }
 $56 = $16 << 2;
 if (!($46)) {
  $j$24 = 0;
  while(1) {
   $69 = (_malloc($56)|0);
   $70 = (($53) + ($j$24<<2)|0);
   HEAP32[$70>>2] = $69;
   $71 = (($j$24) + 1)|0;
   $72 = ($71|0)<($52|0);
   if ($72) {
    $j$24 = $71;
   } else {
    break;
   }
  }
  return ($0|0);
 }
 $57 = HEAP32[$54>>2]|0;
 $j$24$us = 0;
 while(1) {
  $66 = (_malloc($56)|0);
  $67 = (($53) + ($j$24$us<<2)|0);
  HEAP32[$67>>2] = $66;
  $68 = (($57) + ($j$24$us<<2)|0);
  $64 = HEAP32[$68>>2]|0;
  $$pn = $52;$k$11$us = 0;$val$02$us = $j$24$us;
  while(1) {
   $mult$03$us = (($$pn|0) / ($6|0))&-1;
   $60 = (($val$02$us|0) / ($mult$03$us|0))&-1;
   $61 = Math_imul($60, $mult$03$us)|0;
   $62 = (($val$02$us) - ($61))|0;
   $63 = (($64) + ($k$11$us<<2)|0);
   HEAP32[$63>>2] = $60;
   $65 = (($k$11$us) + 1)|0;
   $exitcond24 = ($65|0)==($16|0);
   if ($exitcond24) {
    break;
   } else {
    $$pn = $mult$03$us;$k$11$us = $65;$val$02$us = $62;
   }
  }
  $58 = (($j$24$us) + 1)|0;
  $59 = ($58|0)<($52|0);
  if ($59) {
   $j$24$us = $58;
  } else {
   break;
  }
 }
 return ($0|0);
}
function _res0_inverse($vb,$vl,$in,$nonzero,$ch) {
 $vb = $vb|0;
 $vl = $vl|0;
 $in = $in|0;
 $nonzero = $nonzero|0;
 $ch = $ch|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $exitcond = 0, $i$01 = 0, $used$02 = 0, $used$1 = 0, $used$1$lcssa = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ($ch|0)>(0);
 if ($0) {
  $i$01 = 0;$used$02 = 0;
 } else {
  return 0;
 }
 while(1) {
  $1 = (($nonzero) + ($i$01<<2)|0);
  $2 = HEAP32[$1>>2]|0;
  $3 = ($2|0)==(0);
  if ($3) {
   $used$1 = $used$02;
  } else {
   $4 = (($in) + ($i$01<<2)|0);
   $5 = HEAP32[$4>>2]|0;
   $6 = (($used$02) + 1)|0;
   $7 = (($in) + ($used$02<<2)|0);
   HEAP32[$7>>2] = $5;
   $used$1 = $6;
  }
  $8 = (($i$01) + 1)|0;
  $exitcond = ($8|0)==($ch|0);
  if ($exitcond) {
   $used$1$lcssa = $used$1;
   break;
  } else {
   $i$01 = $8;$used$02 = $used$1;
  }
 }
 $9 = ($used$1$lcssa|0)==(0);
 if ($9) {
  return 0;
 }
 __01inverse($vb,$vl,$in,$used$1$lcssa,2);
 return 0;
}
function _res1_forward($opb,$vb,$vl,$in,$nonzero,$ch,$partword,$submap) {
 $opb = $opb|0;
 $vb = $vb|0;
 $vl = $vl|0;
 $in = $in|0;
 $nonzero = $nonzero|0;
 $ch = $ch|0;
 $partword = $partword|0;
 $submap = $submap|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $exitcond = 0, $i$01 = 0, $used$02 = 0, $used$1 = 0, $used$1$lcssa = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ($ch|0)>(0);
 if ($0) {
  $i$01 = 0;$used$02 = 0;
 } else {
  return 0;
 }
 while(1) {
  $1 = (($nonzero) + ($i$01<<2)|0);
  $2 = HEAP32[$1>>2]|0;
  $3 = ($2|0)==(0);
  if ($3) {
   $used$1 = $used$02;
  } else {
   $4 = (($in) + ($i$01<<2)|0);
   $5 = HEAP32[$4>>2]|0;
   $6 = (($used$02) + 1)|0;
   $7 = (($in) + ($used$02<<2)|0);
   HEAP32[$7>>2] = $5;
   $used$1 = $6;
  }
  $8 = (($i$01) + 1)|0;
  $exitcond = ($8|0)==($ch|0);
  if ($exitcond) {
   $used$1$lcssa = $used$1;
   break;
  } else {
   $i$01 = $8;$used$02 = $used$1;
  }
 }
 $9 = ($used$1$lcssa|0)==(0);
 if ($9) {
  return 0;
 }
 __01forward($opb,$vl,$in,$used$1$lcssa,$partword);
 return 0;
}
function _res1_class($vb,$vl,$in,$nonzero,$ch) {
 $vb = $vb|0;
 $vl = $vl|0;
 $in = $in|0;
 $nonzero = $nonzero|0;
 $ch = $ch|0;
 var $$0 = 0, $$max$0$i = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0.0, $23 = 0.0, $24 = 0.0;
 var $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0;
 var $43 = 0, $44 = 0, $45 = 0, $46 = 0.0, $47 = 0.0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0;
 var $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $7 = 0, $8 = 0, $9 = 0, $ent$0$lcssa$i = 0, $ent$06$i = 0, $exitcond = 0, $exitcond$i = 0, $exitcond25$i = 0, $exitcond26$i = 0, $exitcond27$i = 0, $i$02 = 0, $i$020$i = 0, $i$117$i = 0, $ispos$i = 0, $j$015$i = 0;
 var $k$04$i = 0, $k$1$lcssa$i = 0, $k$18$i = 0, $max$0$lcssa$i = 0, $max$05$i = 0, $neg$i = 0, $or$cond$i = 0, $used$03 = 0, $used$1 = 0, $used$1$lcssa = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ($ch|0)>(0);
 if ($0) {
  $i$02 = 0;$used$03 = 0;
 } else {
  $$0 = 0;
  return ($$0|0);
 }
 while(1) {
  $1 = (($nonzero) + ($i$02<<2)|0);
  $2 = HEAP32[$1>>2]|0;
  $3 = ($2|0)==(0);
  if ($3) {
   $used$1 = $used$03;
  } else {
   $4 = (($in) + ($i$02<<2)|0);
   $5 = HEAP32[$4>>2]|0;
   $6 = (($used$03) + 1)|0;
   $7 = (($in) + ($used$03<<2)|0);
   HEAP32[$7>>2] = $5;
   $used$1 = $6;
  }
  $8 = (($i$02) + 1)|0;
  $exitcond = ($8|0)==($ch|0);
  if ($exitcond) {
   $used$1$lcssa = $used$1;
   break;
  } else {
   $i$02 = $8;$used$03 = $used$1;
  }
 }
 $9 = ($used$1$lcssa|0)==(0);
 if ($9) {
  $$0 = 0;
  return ($$0|0);
 }
 $10 = HEAP32[$vl>>2]|0;
 $11 = ((($10)) + 8|0);
 $12 = HEAP32[$11>>2]|0;
 $13 = ((($10)) + 12|0);
 $14 = HEAP32[$13>>2]|0;
 $15 = ((($10)) + 4|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = HEAP32[$10>>2]|0;
 $18 = (($16) - ($17))|0;
 $19 = (($18|0) / ($12|0))&-1;
 $20 = $used$1$lcssa << 2;
 $21 = (__vorbis_block_alloc($vb,$20)|0);
 $22 = (+($12|0));
 $23 = 100.0 / $22;
 $24 = $23;
 $25 = ($used$1$lcssa|0)>(0);
 if ($25) {
  $26 = $19 << 2;
  $i$020$i = 0;
  while(1) {
   $31 = (__vorbis_block_alloc($vb,$26)|0);
   $32 = (($21) + ($i$020$i<<2)|0);
   HEAP32[$32>>2] = $31;
   _memset(($31|0),0,($26|0))|0;
   $33 = (($i$020$i) + 1)|0;
   $exitcond27$i = ($33|0)==($used$1$lcssa|0);
   if ($exitcond27$i) {
    break;
   } else {
    $i$020$i = $33;
   }
  }
 }
 $27 = ($19|0)>(0);
 if ($27) {
  $28 = ($12|0)>(0);
  $29 = (($14) + -1)|0;
  $30 = ($14|0)>(1);
  $i$117$i = 0;
  while(1) {
   $34 = Math_imul($i$117$i, $12)|0;
   $35 = HEAP32[$10>>2]|0;
   $36 = (($35) + ($34))|0;
   if ($25) {
    $j$015$i = 0;
    while(1) {
     if ($28) {
      $37 = (($in) + ($j$015$i<<2)|0);
      $38 = HEAP32[$37>>2]|0;
      $ent$06$i = 0;$k$04$i = 0;$max$05$i = 0;
      while(1) {
       $39 = (($36) + ($k$04$i))|0;
       $40 = (($38) + ($39<<2)|0);
       $41 = HEAP32[$40>>2]|0;
       $ispos$i = ($41|0)>(-1);
       $neg$i = (0 - ($41))|0;
       $42 = $ispos$i ? $41 : $neg$i;
       $43 = ($42|0)>($max$05$i|0);
       $$max$0$i = $43 ? $42 : $max$05$i;
       $44 = (($42) + ($ent$06$i))|0;
       $45 = (($k$04$i) + 1)|0;
       $exitcond$i = ($45|0)==($12|0);
       if ($exitcond$i) {
        $ent$0$lcssa$i = $44;$max$0$lcssa$i = $$max$0$i;
        break;
       } else {
        $ent$06$i = $44;$k$04$i = $45;$max$05$i = $$max$0$i;
       }
      }
     } else {
      $ent$0$lcssa$i = 0;$max$0$lcssa$i = 0;
     }
     $46 = (+($ent$0$lcssa$i|0));
     $47 = $46 * $24;
     $48 = (~~(($47)));
     L29: do {
      if ($30) {
       $k$18$i = 0;
       while(1) {
        $49 = (((($10)) + 2328|0) + ($k$18$i<<2)|0);
        $50 = HEAP32[$49>>2]|0;
        $51 = ($max$0$lcssa$i|0)>($50|0);
        if (!($51)) {
         $52 = (((($10)) + 2584|0) + ($k$18$i<<2)|0);
         $53 = HEAP32[$52>>2]|0;
         $54 = ($53|0)<(0);
         $55 = ($48|0)<($53|0);
         $or$cond$i = $54 | $55;
         if ($or$cond$i) {
          $k$1$lcssa$i = $k$18$i;
          break L29;
         }
        }
        $56 = (($k$18$i) + 1)|0;
        $57 = ($56|0)<($29|0);
        if ($57) {
         $k$18$i = $56;
        } else {
         $k$1$lcssa$i = $56;
         break;
        }
       }
      } else {
       $k$1$lcssa$i = 0;
      }
     } while(0);
     $58 = (($21) + ($j$015$i<<2)|0);
     $59 = HEAP32[$58>>2]|0;
     $60 = (($59) + ($i$117$i<<2)|0);
     HEAP32[$60>>2] = $k$1$lcssa$i;
     $61 = (($j$015$i) + 1)|0;
     $exitcond25$i = ($61|0)==($used$1$lcssa|0);
     if ($exitcond25$i) {
      break;
     } else {
      $j$015$i = $61;
     }
    }
   }
   $62 = (($i$117$i) + 1)|0;
   $exitcond26$i = ($62|0)==($19|0);
   if ($exitcond26$i) {
    break;
   } else {
    $i$117$i = $62;
   }
  }
 }
 $63 = ((($vl)) + 40|0);
 $64 = HEAP32[$63>>2]|0;
 $65 = (($64) + 1)|0;
 HEAP32[$63>>2] = $65;
 $$0 = $21;
 return ($$0|0);
}
function _res1_inverse($vb,$vl,$in,$nonzero,$ch) {
 $vb = $vb|0;
 $vl = $vl|0;
 $in = $in|0;
 $nonzero = $nonzero|0;
 $ch = $ch|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $exitcond = 0, $i$01 = 0, $used$02 = 0, $used$1 = 0, $used$1$lcssa = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ($ch|0)>(0);
 if ($0) {
  $i$01 = 0;$used$02 = 0;
 } else {
  return 0;
 }
 while(1) {
  $1 = (($nonzero) + ($i$01<<2)|0);
  $2 = HEAP32[$1>>2]|0;
  $3 = ($2|0)==(0);
  if ($3) {
   $used$1 = $used$02;
  } else {
   $4 = (($in) + ($i$01<<2)|0);
   $5 = HEAP32[$4>>2]|0;
   $6 = (($used$02) + 1)|0;
   $7 = (($in) + ($used$02<<2)|0);
   HEAP32[$7>>2] = $5;
   $used$1 = $6;
  }
  $8 = (($i$01) + 1)|0;
  $exitcond = ($8|0)==($ch|0);
  if ($exitcond) {
   $used$1$lcssa = $used$1;
   break;
  } else {
   $i$01 = $8;$used$02 = $used$1;
  }
 }
 $9 = ($used$1$lcssa|0)==(0);
 if ($9) {
  return 0;
 }
 __01inverse($vb,$vl,$in,$used$1$lcssa,3);
 return 0;
}
function _res2_class($vb,$vl,$in,$nonzero,$ch) {
 $vb = $vb|0;
 $vl = $vl|0;
 $in = $in|0;
 $nonzero = $nonzero|0;
 $ch = $ch|0;
 var $$0 = 0, $$angmax$1$i = 0, $$magmax$0$i = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0;
 var $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0;
 var $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $angmax$0$lcssa$i = 0, $angmax$09$i = 0, $angmax$1$lcssa$i = 0;
 var $angmax$15$i = 0, $exitcond = 0, $exitcond$i = 0, $exitcond25$i = 0, $i$01 = 0, $i$021$i = 0, $ispos$i = 0, $ispos1$i = 0, $j$07$i = 0, $j$1$lcssa$i = 0, $j$114$i = 0, $k$04$i = 0, $l$020$i = 0, $l$1$lcssa$i = 0, $l$16$i = 0, $magmax$0$lcssa$i = 0, $magmax$08$i = 0, $neg$i = 0, $neg2$i = 0, $not$ = 0;
 var $phitmp = 0, $used$0$ = 0, $used$0$$lcssa = 0, $used$02 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ($ch|0)>(0);
 if ($0) {
  $i$01 = 0;$used$02 = 0;
 } else {
  $$0 = 0;
  return ($$0|0);
 }
 while(1) {
  $1 = (($nonzero) + ($i$01<<2)|0);
  $2 = HEAP32[$1>>2]|0;
  $not$ = ($2|0)!=(0);
  $3 = $not$&1;
  $used$0$ = (($3) + ($used$02))|0;
  $4 = (($i$01) + 1)|0;
  $exitcond = ($4|0)==($ch|0);
  if ($exitcond) {
   $used$0$$lcssa = $used$0$;
   break;
  } else {
   $i$01 = $4;$used$02 = $used$0$;
  }
 }
 $phitmp = ($used$0$$lcssa|0)==(0);
 if ($phitmp) {
  $$0 = 0;
  return ($$0|0);
 }
 $5 = HEAP32[$vl>>2]|0;
 $6 = ((($5)) + 8|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = ((($5)) + 12|0);
 $9 = HEAP32[$8>>2]|0;
 $10 = ((($5)) + 4|0);
 $11 = HEAP32[$10>>2]|0;
 $12 = HEAP32[$5>>2]|0;
 $13 = (($11) - ($12))|0;
 $14 = (($13|0) / ($7|0))&-1;
 $15 = (__vorbis_block_alloc($vb,4)|0);
 $16 = $14 << 2;
 $17 = (__vorbis_block_alloc($vb,$16)|0);
 HEAP32[$15>>2] = $17;
 _memset(($17|0),0,($16|0))|0;
 $18 = ($14|0)>(0);
 if ($18) {
  $19 = HEAP32[$5>>2]|0;
  $20 = (($19|0) / ($ch|0))&-1;
  $21 = ($7|0)>(0);
  $22 = (($9) + -1)|0;
  $23 = ($9|0)>(1);
  $24 = HEAP32[$15>>2]|0;
  $25 = ($ch|0)>(1);
  $i$021$i = 0;$l$020$i = $20;
  while(1) {
   if ($21) {
    $26 = HEAP32[$in>>2]|0;
    $angmax$09$i = 0;$j$07$i = 0;$l$16$i = $l$020$i;$magmax$08$i = 0;
    while(1) {
     $27 = (($26) + ($l$16$i<<2)|0);
     $28 = HEAP32[$27>>2]|0;
     $ispos$i = ($28|0)>(-1);
     $neg$i = (0 - ($28))|0;
     $29 = $ispos$i ? $28 : $neg$i;
     $30 = ($29|0)>($magmax$08$i|0);
     $$magmax$0$i = $30 ? $29 : $magmax$08$i;
     if ($25) {
      $angmax$15$i = $angmax$09$i;$k$04$i = 1;
      while(1) {
       $31 = (($in) + ($k$04$i<<2)|0);
       $32 = HEAP32[$31>>2]|0;
       $33 = (($32) + ($l$16$i<<2)|0);
       $34 = HEAP32[$33>>2]|0;
       $ispos1$i = ($34|0)>(-1);
       $neg2$i = (0 - ($34))|0;
       $35 = $ispos1$i ? $34 : $neg2$i;
       $36 = ($35|0)>($angmax$15$i|0);
       $$angmax$1$i = $36 ? $35 : $angmax$15$i;
       $37 = (($k$04$i) + 1)|0;
       $exitcond$i = ($37|0)==($ch|0);
       if ($exitcond$i) {
        $angmax$1$lcssa$i = $$angmax$1$i;
        break;
       } else {
        $angmax$15$i = $$angmax$1$i;$k$04$i = $37;
       }
      }
     } else {
      $angmax$1$lcssa$i = $angmax$09$i;
     }
     $38 = (($l$16$i) + 1)|0;
     $39 = (($j$07$i) + ($ch))|0;
     $40 = ($39|0)<($7|0);
     if ($40) {
      $angmax$09$i = $angmax$1$lcssa$i;$j$07$i = $39;$l$16$i = $38;$magmax$08$i = $$magmax$0$i;
     } else {
      $angmax$0$lcssa$i = $angmax$1$lcssa$i;$l$1$lcssa$i = $38;$magmax$0$lcssa$i = $$magmax$0$i;
      break;
     }
    }
   } else {
    $angmax$0$lcssa$i = 0;$l$1$lcssa$i = $l$020$i;$magmax$0$lcssa$i = 0;
   }
   L22: do {
    if ($23) {
     $j$114$i = 0;
     while(1) {
      $41 = (((($5)) + 2328|0) + ($j$114$i<<2)|0);
      $42 = HEAP32[$41>>2]|0;
      $43 = ($magmax$0$lcssa$i|0)>($42|0);
      if (!($43)) {
       $44 = (((($5)) + 2584|0) + ($j$114$i<<2)|0);
       $45 = HEAP32[$44>>2]|0;
       $46 = ($angmax$0$lcssa$i|0)>($45|0);
       if (!($46)) {
        $j$1$lcssa$i = $j$114$i;
        break L22;
       }
      }
      $47 = (($j$114$i) + 1)|0;
      $48 = ($47|0)<($22|0);
      if ($48) {
       $j$114$i = $47;
      } else {
       $j$1$lcssa$i = $47;
       break;
      }
     }
    } else {
     $j$1$lcssa$i = 0;
    }
   } while(0);
   $49 = (($24) + ($i$021$i<<2)|0);
   HEAP32[$49>>2] = $j$1$lcssa$i;
   $50 = (($i$021$i) + 1)|0;
   $exitcond25$i = ($50|0)==($14|0);
   if ($exitcond25$i) {
    break;
   } else {
    $i$021$i = $50;$l$020$i = $l$1$lcssa$i;
   }
  }
 }
 $51 = ((($vl)) + 40|0);
 $52 = HEAP32[$51>>2]|0;
 $53 = (($52) + 1)|0;
 HEAP32[$51>>2] = $53;
 $$0 = $15;
 return ($$0|0);
}
function _res2_forward($opb,$vb,$vl,$in,$nonzero,$ch,$partword,$submap) {
 $opb = $opb|0;
 $vb = $vb|0;
 $vl = $vl|0;
 $in = $in|0;
 $nonzero = $nonzero|0;
 $ch = $ch|0;
 $partword = $partword|0;
 $submap = $submap|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0;
 var $exitcond = 0, $i$03 = 0, $j$01 = 0, $k$02 = 0, $not$ = 0, $phitmp = 0, $used$0$ = 0, $used$0$$lcssa = 0, $used$04 = 0, $work = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0;
 $work = sp;
 $0 = ((($vb)) + 36|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = (($1|0) / 2)&-1;
 $3 = $ch << 2;
 $4 = Math_imul($3, $2)|0;
 $5 = (__vorbis_block_alloc($vb,$4)|0);
 HEAP32[$work>>2] = $5;
 $6 = ($ch|0)>(0);
 if (!($6)) {
  STACKTOP = sp;return 0;
 }
 $7 = ($1|0)>(1);
 $i$03 = 0;$used$04 = 0;
 while(1) {
  $8 = (($in) + ($i$03<<2)|0);
  $9 = HEAP32[$8>>2]|0;
  $10 = (($nonzero) + ($i$03<<2)|0);
  $11 = HEAP32[$10>>2]|0;
  $not$ = ($11|0)!=(0);
  $12 = $not$&1;
  $used$0$ = (($12) + ($used$04))|0;
  if ($7) {
   $j$01 = 0;$k$02 = $i$03;
   while(1) {
    $13 = (($9) + ($j$01<<2)|0);
    $14 = HEAP32[$13>>2]|0;
    $15 = (($5) + ($k$02<<2)|0);
    HEAP32[$15>>2] = $14;
    $16 = (($j$01) + 1)|0;
    $17 = (($k$02) + ($ch))|0;
    $18 = ($16|0)<($2|0);
    if ($18) {
     $j$01 = $16;$k$02 = $17;
    } else {
     break;
    }
   }
  }
  $19 = (($i$03) + 1)|0;
  $exitcond = ($19|0)==($ch|0);
  if ($exitcond) {
   $used$0$$lcssa = $used$0$;
   break;
  } else {
   $i$03 = $19;$used$04 = $used$0$;
  }
 }
 $phitmp = ($used$0$$lcssa|0)==(0);
 if ($phitmp) {
  STACKTOP = sp;return 0;
 }
 __01forward($opb,$vl,$work,1,$partword);
 STACKTOP = sp;return 0;
}
function _res2_inverse($vb,$vl,$in,$nonzero,$ch) {
 $vb = $vb|0;
 $vl = $vl|0;
 $in = $in|0;
 $nonzero = $nonzero|0;
 $ch = $ch|0;
 var $$ = 0, $$pre = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0;
 var $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0;
 var $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0;
 var $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0;
 var $8 = 0, $9 = 0, $i$0$lcssa = 0, $i$014 = 0, $i$110 = 0, $i$2$lcssa = 0, $i$28 = 0, $k$07 = 0, $l$09 = 0, $or$cond = 0, $or$cond6 = 0, $s$012 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = HEAP32[$vl>>2]|0;
 $1 = ((($0)) + 8|0);
 $2 = HEAP32[$1>>2]|0;
 $3 = ((($vl)) + 16|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = HEAP32[$4>>2]|0;
 $6 = ((($vb)) + 36|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = Math_imul($7, $ch)|0;
 $9 = $8 >> 1;
 $10 = ((($0)) + 4|0);
 $11 = HEAP32[$10>>2]|0;
 $12 = ($11|0)<($9|0);
 $$ = $12 ? $11 : $9;
 $13 = HEAP32[$0>>2]|0;
 $14 = (($$) - ($13))|0;
 $15 = ($14|0)>(0);
 if (!($15)) {
  return 0;
 }
 $16 = (($14|0) / ($2|0))&-1;
 $17 = (($5) + -1)|0;
 $18 = (($17) + ($16))|0;
 $19 = (($18|0) / ($5|0))&-1;
 $20 = $19 << 2;
 $21 = (__vorbis_block_alloc($vb,$20)|0);
 $22 = ($ch|0)>(0);
 L4: do {
  if ($22) {
   $i$014 = 0;
   while(1) {
    $23 = (($nonzero) + ($i$014<<2)|0);
    $24 = HEAP32[$23>>2]|0;
    $25 = ($24|0)==(0);
    if (!($25)) {
     $i$0$lcssa = $i$014;
     break L4;
    }
    $26 = (($i$014) + 1)|0;
    $27 = ($26|0)<($ch|0);
    if ($27) {
     $i$014 = $26;
    } else {
     $i$0$lcssa = $26;
     break;
    }
   }
  } else {
   $i$0$lcssa = 0;
  }
 } while(0);
 $28 = ($i$0$lcssa|0)==($ch|0);
 if ($28) {
  return 0;
 }
 $29 = ((($vl)) + 8|0);
 $30 = HEAP32[$29>>2]|0;
 $31 = ($30|0)>(0);
 if (!($31)) {
  return 0;
 }
 $32 = ($16|0)>(0);
 $33 = ((($vb)) + 4|0);
 $34 = ((($0)) + 16|0);
 $35 = ((($vl)) + 28|0);
 $36 = ($5|0)>(0);
 $37 = ((($vl)) + 20|0);
 $79 = $30;$s$012 = 0;
 L15: while(1) {
  if ($32) {
   $38 = ($s$012|0)==(0);
   $39 = 1 << $s$012;
   $i$110 = 0;$l$09 = 0;
   while(1) {
    if ($38) {
     $40 = HEAP32[$3>>2]|0;
     $41 = (_vorbis_book_decode($40,$33)|0);
     $42 = ($41|0)==(-1);
     if ($42) {
      label = 23;
      break L15;
     }
     $43 = HEAP32[$34>>2]|0;
     $44 = ($41|0)<($43|0);
     if (!($44)) {
      label = 23;
      break L15;
     }
     $45 = HEAP32[$35>>2]|0;
     $46 = (($45) + ($41<<2)|0);
     $47 = HEAP32[$46>>2]|0;
     $48 = (($21) + ($l$09<<2)|0);
     HEAP32[$48>>2] = $47;
     $49 = ($47|0)==(0|0);
     if ($49) {
      label = 23;
      break L15;
     }
    }
    $50 = ($i$110|0)<($16|0);
    $or$cond6 = $36 & $50;
    if ($or$cond6) {
     $51 = (($21) + ($l$09<<2)|0);
     $i$28 = $i$110;$k$07 = 0;
     while(1) {
      $52 = HEAP32[$51>>2]|0;
      $53 = (($52) + ($k$07<<2)|0);
      $54 = HEAP32[$53>>2]|0;
      $55 = (((($0)) + 24|0) + ($54<<2)|0);
      $56 = HEAP32[$55>>2]|0;
      $57 = $56 & $39;
      $58 = ($57|0)==(0);
      if (!($58)) {
       $59 = HEAP32[$37>>2]|0;
       $60 = (($59) + ($54<<2)|0);
       $61 = HEAP32[$60>>2]|0;
       $62 = (($61) + ($s$012<<2)|0);
       $63 = HEAP32[$62>>2]|0;
       $64 = ($63|0)==(0|0);
       if (!($64)) {
        $65 = Math_imul($i$28, $2)|0;
        $66 = HEAP32[$0>>2]|0;
        $67 = (($66) + ($65))|0;
        $68 = (_vorbis_book_decodevv_add($63,$in,$67,$ch,$33,$2)|0);
        $69 = ($68|0)==(-1);
        if ($69) {
         label = 23;
         break L15;
        }
       }
      }
      $70 = (($k$07) + 1)|0;
      $71 = (($i$28) + 1)|0;
      $72 = ($70|0)<($5|0);
      $73 = ($71|0)<($16|0);
      $or$cond = $72 & $73;
      if ($or$cond) {
       $i$28 = $71;$k$07 = $70;
      } else {
       $i$2$lcssa = $71;
       break;
      }
     }
    } else {
     $i$2$lcssa = $i$110;
    }
    $74 = (($l$09) + 1)|0;
    $75 = ($i$2$lcssa|0)<($16|0);
    if ($75) {
     $i$110 = $i$2$lcssa;$l$09 = $74;
    } else {
     break;
    }
   }
   $$pre = HEAP32[$29>>2]|0;
   $78 = $$pre;
  } else {
   $78 = $79;
  }
  $76 = (($s$012) + 1)|0;
  $77 = ($76|0)<($78|0);
  if ($77) {
   $79 = $78;$s$012 = $76;
  } else {
   label = 23;
   break;
  }
 }
 if ((label|0) == 23) {
  return 0;
 }
 return (0)|0;
}
function __01inverse($vb,$vl,$in,$ch,$decodepart) {
 $vb = $vb|0;
 $vl = $vl|0;
 $in = $in|0;
 $ch = $ch|0;
 $decodepart = $decodepart|0;
 var $$ = 0, $$alloca_mul = 0, $$not = 0, $$not31 = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0;
 var $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0;
 var $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0;
 var $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0;
 var $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $brmerge = 0, $exitcond = 0, $i$017 = 0, $i$1$lcssa = 0, $i$113 = 0, $i$113$us = 0;
 var $j$022 = 0, $j$18 = 0, $j$29$us = 0, $k$012 = 0, $k$012$us = 0, $l$014 = 0, $or$cond = 0, $or$cond$us = 0, $or$cond11 = 0, $s$020 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = HEAP32[$vl>>2]|0;
 $1 = ((($0)) + 8|0);
 $2 = HEAP32[$1>>2]|0;
 $3 = ((($vl)) + 16|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = HEAP32[$4>>2]|0;
 $6 = ((($vb)) + 36|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = $7 >> 1;
 $9 = ((($0)) + 4|0);
 $10 = HEAP32[$9>>2]|0;
 $11 = ($10|0)<($8|0);
 $$ = $11 ? $10 : $8;
 $12 = HEAP32[$0>>2]|0;
 $13 = (($$) - ($12))|0;
 $14 = ($13|0)>(0);
 if (!($14)) {
  STACKTOP = sp;return;
 }
 $15 = (($13|0) / ($2|0))&-1;
 $16 = $ch << 2;
 $$alloca_mul = $16;
 $17 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul)|0)+15)&-16)|0;;
 $18 = ($ch|0)>(0);
 if ($18) {
  $19 = (($5) + -1)|0;
  $20 = (($19) + ($15))|0;
  $21 = (($20|0) / ($5|0))&-1;
  $22 = $21 << 2;
  $j$022 = 0;
  while(1) {
   $32 = (__vorbis_block_alloc($vb,$22)|0);
   $33 = (($17) + ($j$022<<2)|0);
   HEAP32[$33>>2] = $32;
   $34 = (($j$022) + 1)|0;
   $exitcond = ($34|0)==($ch|0);
   if ($exitcond) {
    break;
   } else {
    $j$022 = $34;
   }
  }
 }
 $23 = ((($vl)) + 8|0);
 $24 = HEAP32[$23>>2]|0;
 $25 = ($24|0)>(0);
 if (!($25)) {
  STACKTOP = sp;return;
 }
 $26 = ($15|0)>(0);
 $27 = ((($vb)) + 4|0);
 $28 = ((($0)) + 16|0);
 $29 = ((($vl)) + 28|0);
 $30 = ($5|0)>(0);
 $31 = ((($vl)) + 20|0);
 $$not31 = $18 ^ 1;
 $s$020 = 0;
 L12: while(1) {
  if ($26) {
   $35 = 1 << $s$020;
   $$not = ($s$020|0)!=(0);
   $brmerge = $$not | $$not31;
   $i$017 = 0;$l$014 = 0;
   while(1) {
    if (!($brmerge)) {
     $j$18 = 0;
     while(1) {
      $69 = HEAP32[$3>>2]|0;
      $70 = (_vorbis_book_decode($69,$27)|0);
      $71 = ($70|0)==(-1);
      if ($71) {
       label = 25;
       break L12;
      }
      $72 = HEAP32[$28>>2]|0;
      $73 = ($70|0)<($72|0);
      if (!($73)) {
       label = 25;
       break L12;
      }
      $74 = HEAP32[$29>>2]|0;
      $75 = (($74) + ($70<<2)|0);
      $76 = HEAP32[$75>>2]|0;
      $77 = (($17) + ($j$18<<2)|0);
      $78 = HEAP32[$77>>2]|0;
      $79 = (($78) + ($l$014<<2)|0);
      HEAP32[$79>>2] = $76;
      $80 = ($76|0)==(0);
      $67 = (($j$18) + 1)|0;
      if ($80) {
       label = 25;
       break L12;
      }
      $68 = ($67|0)<($ch|0);
      if ($68) {
       $j$18 = $67;
      } else {
       break;
      }
     }
    }
    $36 = ($i$017|0)<($15|0);
    $or$cond11 = $30 & $36;
    L25: do {
     if ($or$cond11) {
      if ($18) {
       $i$113$us = $i$017;$k$012$us = 0;
      } else {
       $i$113 = $i$017;$k$012 = 0;
       while(1) {
        $81 = (($k$012) + 1)|0;
        $82 = (($i$113) + 1)|0;
        $83 = ($81|0)<($5|0);
        $84 = ($82|0)<($15|0);
        $or$cond = $83 & $84;
        if ($or$cond) {
         $i$113 = $82;$k$012 = $81;
        } else {
         $i$1$lcssa = $82;
         break L25;
        }
       }
      }
      while(1) {
       $43 = Math_imul($i$113$us, $2)|0;
       $j$29$us = 0;
       while(1) {
        $41 = HEAP32[$0>>2]|0;
        $42 = (($41) + ($43))|0;
        $44 = (($17) + ($j$29$us<<2)|0);
        $45 = HEAP32[$44>>2]|0;
        $46 = (($45) + ($l$014<<2)|0);
        $47 = HEAP32[$46>>2]|0;
        $48 = (($47) + ($k$012$us<<2)|0);
        $49 = HEAP32[$48>>2]|0;
        $50 = (((($0)) + 24|0) + ($49<<2)|0);
        $51 = HEAP32[$50>>2]|0;
        $52 = $51 & $35;
        $53 = ($52|0)==(0);
        if (!($53)) {
         $54 = HEAP32[$31>>2]|0;
         $55 = (($54) + ($49<<2)|0);
         $56 = HEAP32[$55>>2]|0;
         $57 = (($56) + ($s$020<<2)|0);
         $58 = HEAP32[$57>>2]|0;
         $59 = ($58|0)==(0|0);
         if (!($59)) {
          $60 = (($in) + ($j$29$us<<2)|0);
          $61 = HEAP32[$60>>2]|0;
          $62 = (($61) + ($42<<2)|0);
          $63 = (FUNCTION_TABLE_iiiii[$decodepart & 3]($58,$62,$27,$2)|0);
          $64 = ($63|0)==(-1);
          if ($64) {
           label = 25;
           break L12;
          }
         }
        }
        $65 = (($j$29$us) + 1)|0;
        $66 = ($65|0)<($ch|0);
        if ($66) {
         $j$29$us = $65;
        } else {
         break;
        }
       }
       $37 = (($k$012$us) + 1)|0;
       $38 = (($i$113$us) + 1)|0;
       $39 = ($37|0)<($5|0);
       $40 = ($38|0)<($15|0);
       $or$cond$us = $39 & $40;
       if ($or$cond$us) {
        $i$113$us = $38;$k$012$us = $37;
       } else {
        $i$1$lcssa = $38;
        break;
       }
      }
     } else {
      $i$1$lcssa = $i$017;
     }
    } while(0);
    $85 = (($l$014) + 1)|0;
    $86 = ($i$1$lcssa|0)<($15|0);
    if ($86) {
     $i$017 = $i$1$lcssa;$l$014 = $85;
    } else {
     break;
    }
   }
  }
  $87 = (($s$020) + 1)|0;
  $88 = HEAP32[$23>>2]|0;
  $89 = ($87|0)<($88|0);
  if ($89) {
   $s$020 = $87;
  } else {
   label = 25;
   break;
  }
 }
 if ((label|0) == 25) {
  STACKTOP = sp;return;
 }
}
function __01forward($opb,$vl,$in,$ch,$partword) {
 $opb = $opb|0;
 $vl = $vl|0;
 $in = $in|0;
 $ch = $ch|0;
 $partword = $partword|0;
 var $$09$i$i = 0, $$lcssa$i$i = 0, $$lcssa7$i$i = 0, $$lcssa72 = 0, $$pre$i = 0, $$pre43 = 0, $$pre44 = 0, $$sum = 0, $$sum1 = 0, $$sum2 = 0, $$sum3 = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0;
 var $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0;
 var $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0;
 var $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0;
 var $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0;
 var $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0, $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0;
 var $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0, $206 = 0, $207 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0;
 var $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0;
 var $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0;
 var $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $best$020$i$i = 0;
 var $best$1$i$i = 0, $bits$0$lcssa$i = 0, $bits$08$i = 0, $brmerge$demorgan = 0, $e$i$i = 0, $exitcond = 0, $exitcond$i = 0, $exitcond$i$i = 0, $exitcond15$i = 0, $exitcond35 = 0, $exitcond36 = 0, $exitcond37 = 0, $exitcond38 = 0, $exitcond41$i$i = 0, $exitcond42$i$i = 0, $exitcond43$i$i = 0, $i$024 = 0, $i$033$i$i = 0, $i$09$i = 0, $i$1$lcssa = 0;
 var $i$121 = 0, $i$128$i$i = 0, $i$221$i$i = 0, $i$38$i$i = 0, $index$031$i$i = 0, $index$126$i$i = 0, $index$2$i$i = 0, $index$319$i$i = 0, $index$4$i$i = 0, $index$5$i$i = 0, $j$010$i$i = 0, $j$013 = 0, $j$013$us = 0, $j$113$i$i = 0, $j$115 = 0, $k$012$us = 0, $k$120 = 0, $o$032$i$i = 0, $o$127$i$i = 0, $or$cond$i$i = 0;
 var $or$cond19 = 0, $or$cond50$i$i = 0, $p$i$i = 0, $resbits = 0, $resvals = 0, $s$026 = 0, $this$0$lcssa$i$i = 0, $this$011$i$i = 0, $umax = 0, $val$011$us = 0, $val$1$us = 0, $val$1$us$lcssa = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 1088|0;
 $p$i$i = sp + 1056|0;
 $e$i$i = sp + 1024|0;
 $resbits = sp + 512|0;
 $resvals = sp;
 $0 = HEAP32[$vl>>2]|0;
 $1 = ((($0)) + 8|0);
 $2 = HEAP32[$1>>2]|0;
 $3 = ((($0)) + 12|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = ((($vl)) + 16|0);
 $6 = HEAP32[$5>>2]|0;
 $7 = HEAP32[$6>>2]|0;
 $8 = ((($0)) + 4|0);
 $9 = HEAP32[$8>>2]|0;
 $10 = HEAP32[$0>>2]|0;
 $11 = (($9) - ($10))|0;
 $12 = (($11|0) / ($2|0))&-1;
 _memset(($resbits|0),0,512)|0;
 _memset(($resvals|0),0,512)|0;
 $13 = ((($vl)) + 8|0);
 $14 = HEAP32[$13>>2]|0;
 $15 = ($14|0)>(0);
 if (!($15)) {
  STACKTOP = sp;return;
 }
 $16 = ($12|0)>(0);
 $17 = ($ch|0)>(0);
 $18 = ($7|0)>(1);
 $19 = ((($vl)) + 36|0);
 $20 = ($7|0)>(0);
 $21 = ((($vl)) + 20|0);
 $22 = ((($vl)) + 32|0);
 $23 = (0 - ($7))|0;
 $207 = $14;$s$026 = 0;
 while(1) {
  if ($16) {
   $24 = ($s$026|0)==(0);
   $25 = 1 << $s$026;
   $brmerge$demorgan = $24 & $17;
   $i$024 = 0;
   while(1) {
    L10: do {
     if ($brmerge$demorgan) {
      if ($18) {
       $j$013$us = 0;
      } else {
       $j$013 = 0;
       while(1) {
        $51 = (($partword) + ($j$013<<2)|0);
        $52 = HEAP32[$51>>2]|0;
        $53 = (($52) + ($i$024<<2)|0);
        $54 = HEAP32[$53>>2]|0;
        $55 = HEAP32[$5>>2]|0;
        $56 = ((($55)) + 4|0);
        $57 = HEAP32[$56>>2]|0;
        $58 = ($54|0)<($57|0);
        if ($58) {
         $59 = (_vorbis_book_encode($55,$54,$opb)|0);
         $60 = HEAP32[$19>>2]|0;
         $61 = (($60) + ($59))|0;
         HEAP32[$19>>2] = $61;
        }
        $62 = (($j$013) + 1)|0;
        $exitcond = ($62|0)==($ch|0);
        if ($exitcond) {
         break L10;
        } else {
         $j$013 = $62;
        }
       }
      }
      while(1) {
       $44 = (($partword) + ($j$013$us<<2)|0);
       $40 = HEAP32[$44>>2]|0;
       $45 = (($40) + ($i$024<<2)|0);
       $46 = HEAP32[$45>>2]|0;
       $k$012$us = 1;$val$011$us = $46;
       while(1) {
        $36 = Math_imul($val$011$us, $4)|0;
        $37 = (($k$012$us) + ($i$024))|0;
        $38 = ($37|0)<($12|0);
        if ($38) {
         $39 = (($40) + ($37<<2)|0);
         $41 = HEAP32[$39>>2]|0;
         $42 = (($41) + ($36))|0;
         $val$1$us = $42;
        } else {
         $val$1$us = $36;
        }
        $43 = (($k$012$us) + 1)|0;
        $exitcond37 = ($43|0)==($7|0);
        if ($exitcond37) {
         $val$1$us$lcssa = $val$1$us;
         break;
        } else {
         $k$012$us = $43;$val$011$us = $val$1$us;
        }
       }
       $28 = HEAP32[$5>>2]|0;
       $29 = ((($28)) + 4|0);
       $30 = HEAP32[$29>>2]|0;
       $31 = ($val$1$us$lcssa|0)<($30|0);
       if ($31) {
        $32 = (_vorbis_book_encode($28,$val$1$us$lcssa,$opb)|0);
        $33 = HEAP32[$19>>2]|0;
        $34 = (($33) + ($32))|0;
        HEAP32[$19>>2] = $34;
       }
       $35 = (($j$013$us) + 1)|0;
       $exitcond38 = ($35|0)==($ch|0);
       if ($exitcond38) {
        break;
       } else {
        $j$013$us = $35;
       }
      }
     }
    } while(0);
    $47 = ($i$024|0)<($12|0);
    $or$cond19 = $20 & $47;
    if ($or$cond19) {
     $48 = (($i$024) - ($12))|0;
     $49 = ($48>>>0)<($23>>>0);
     $umax = $49 ? $23 : $48;
     $50 = (0 - ($umax))|0;
     $i$121 = $i$024;$k$120 = 0;
     while(1) {
      $63 = Math_imul($i$121, $2)|0;
      $64 = HEAP32[$0>>2]|0;
      $65 = (($64) + ($63))|0;
      if ($17) {
       $j$115 = 0;
       while(1) {
        $66 = (($partword) + ($j$115<<2)|0);
        $67 = HEAP32[$66>>2]|0;
        $68 = (($67) + ($i$121<<2)|0);
        $69 = HEAP32[$68>>2]|0;
        if ($24) {
         $70 = (($resvals) + ($69<<2)|0);
         $71 = HEAP32[$70>>2]|0;
         $72 = (($71) + ($2))|0;
         HEAP32[$70>>2] = $72;
        }
        $73 = (((($0)) + 24|0) + ($69<<2)|0);
        $74 = HEAP32[$73>>2]|0;
        $75 = $74 & $25;
        $76 = ($75|0)==(0);
        if (!($76)) {
         $77 = HEAP32[$21>>2]|0;
         $78 = (($77) + ($69<<2)|0);
         $79 = HEAP32[$78>>2]|0;
         $80 = (($79) + ($s$026<<2)|0);
         $81 = HEAP32[$80>>2]|0;
         $82 = ($81|0)==(0|0);
         if (!($82)) {
          $83 = (($in) + ($j$115<<2)|0);
          $84 = HEAP32[$83>>2]|0;
          $85 = HEAP32[$81>>2]|0;
          $86 = (($2|0) / ($85|0))&-1;
          $87 = ($86|0)>(0);
          if ($87) {
           $88 = ((($81)) + 48|0);
           $89 = ((($81)) + 52|0);
           $90 = ((($81)) + 44|0);
           $91 = ((($81)) + 12|0);
           $92 = ((($81)) + 4|0);
           $100 = $85;$bits$08$i = 0;$i$09$i = 0;
           while(1) {
            $93 = Math_imul($i$09$i, $85)|0;
            $$sum = (($93) + ($65))|0;
            $94 = (($84) + ($$sum<<2)|0);
            $95 = HEAP32[$88>>2]|0;
            $96 = HEAP32[$89>>2]|0;
            $97 = HEAP32[$90>>2]|0;
            $98 = $97 >> 1;
            ;HEAP32[$p$i$i>>2]=0|0;HEAP32[$p$i$i+4>>2]=0|0;HEAP32[$p$i$i+8>>2]=0|0;HEAP32[$p$i$i+12>>2]=0|0;HEAP32[$p$i$i+16>>2]=0|0;HEAP32[$p$i$i+20>>2]=0|0;HEAP32[$p$i$i+24>>2]=0|0;HEAP32[$p$i$i+28>>2]=0|0;
            $99 = ($96|0)==(1);
            $101 = ($100|0)>(0);
            do {
             if ($99) {
              if (!($101)) {
               $index$2$i$i = 0;
               break;
              }
              $105 = (($97) + -1)|0;
              $i$128$i$i = 0;$index$126$i$i = 0;$o$127$i$i = $100;
              while(1) {
               $128 = (($o$127$i$i) + -1)|0;
               $$sum3 = (($$sum) + ($128))|0;
               $129 = (($84) + ($$sum3<<2)|0);
               $130 = HEAP32[$129>>2]|0;
               $131 = (($130) - ($95))|0;
               $132 = ($131|0)<($98|0);
               if ($132) {
                $133 = (($98) - ($131))|0;
                $134 = $133 << 1;
                $135 = (($134) + -1)|0;
                $139 = $135;
               } else {
                $136 = (($131) - ($98))|0;
                $137 = $136 << 1;
                $139 = $137;
               }
               $138 = Math_imul($index$126$i$i, $97)|0;
               $140 = ($139|0)<(0);
               $141 = ($139|0)>=($97|0);
               $142 = $141 ? $105 : $139;
               $143 = $140 ? 0 : $142;
               $144 = (($143) + ($138))|0;
               $145 = (($p$i$i) + ($128<<2)|0);
               HEAP32[$145>>2] = $130;
               $146 = (($i$128$i$i) + 1)|0;
               $exitcond42$i$i = ($146|0)==($100|0);
               if ($exitcond42$i$i) {
                $index$2$i$i = $144;
                break;
               } else {
                $i$128$i$i = $146;$index$126$i$i = $144;$o$127$i$i = $128;
               }
              }
             } else {
              if (!($101)) {
               $index$2$i$i = 0;
               break;
              }
              $102 = $96 >> 1;
              $103 = (($102) - ($95))|0;
              $104 = (($97) + -1)|0;
              $i$033$i$i = 0;$index$031$i$i = 0;$o$032$i$i = $100;
              while(1) {
               $106 = (($o$032$i$i) + -1)|0;
               $$sum2 = (($$sum) + ($106))|0;
               $107 = (($84) + ($$sum2<<2)|0);
               $108 = HEAP32[$107>>2]|0;
               $109 = (($103) + ($108))|0;
               $110 = (($109|0) / ($96|0))&-1;
               $111 = ($110|0)<($98|0);
               if ($111) {
                $112 = (($98) - ($110))|0;
                $113 = $112 << 1;
                $114 = (($113) + -1)|0;
                $118 = $114;
               } else {
                $115 = (($110) - ($98))|0;
                $116 = $115 << 1;
                $118 = $116;
               }
               $117 = Math_imul($index$031$i$i, $97)|0;
               $119 = ($118|0)<(0);
               $120 = ($118|0)>=($97|0);
               $121 = $120 ? $104 : $118;
               $122 = $119 ? 0 : $121;
               $123 = (($122) + ($117))|0;
               $124 = Math_imul($110, $96)|0;
               $125 = (($124) + ($95))|0;
               $126 = (($p$i$i) + ($106<<2)|0);
               HEAP32[$126>>2] = $125;
               $127 = (($i$033$i$i) + 1)|0;
               $exitcond43$i$i = ($127|0)==($100|0);
               if ($exitcond43$i$i) {
                $index$2$i$i = $123;
                break;
               } else {
                $i$033$i$i = $127;$index$031$i$i = $123;$o$032$i$i = $106;
               }
              }
             }
            } while(0);
            $147 = HEAP32[$91>>2]|0;
            $148 = ((($147)) + 8|0);
            $149 = HEAP32[$148>>2]|0;
            $150 = (($149) + ($index$2$i$i)|0);
            $151 = HEAP8[$150>>0]|0;
            $152 = ($151<<24>>24)<(1);
            do {
             if ($152) {
              ;HEAP32[$e$i$i>>2]=0|0;HEAP32[$e$i$i+4>>2]=0|0;HEAP32[$e$i$i+8>>2]=0|0;HEAP32[$e$i$i+12>>2]=0|0;HEAP32[$e$i$i+16>>2]=0|0;HEAP32[$e$i$i+20>>2]=0|0;HEAP32[$e$i$i+24>>2]=0|0;HEAP32[$e$i$i+28>>2]=0|0;
              $153 = (($97) + -1)|0;
              $154 = Math_imul($153, $96)|0;
              $155 = (($154) + ($95))|0;
              $156 = HEAP32[$92>>2]|0;
              $157 = ($156|0)>(0);
              if ($157) {
               $best$020$i$i = -1;$i$221$i$i = 0;$index$319$i$i = $index$2$i$i;
              } else {
               $index$5$i$i = $index$2$i$i;
               break;
              }
              while(1) {
               $158 = (($149) + ($i$221$i$i)|0);
               $159 = HEAP8[$158>>0]|0;
               $160 = ($159<<24>>24)>(0);
               do {
                if ($160) {
                 if ($101) {
                  $j$010$i$i = 0;$this$011$i$i = 0;
                  while(1) {
                   $161 = (($e$i$i) + ($j$010$i$i<<2)|0);
                   $162 = HEAP32[$161>>2]|0;
                   $$sum1 = (($$sum) + ($j$010$i$i))|0;
                   $163 = (($84) + ($$sum1<<2)|0);
                   $164 = HEAP32[$163>>2]|0;
                   $165 = (($162) - ($164))|0;
                   $166 = Math_imul($165, $165)|0;
                   $167 = (($166) + ($this$011$i$i))|0;
                   $168 = (($j$010$i$i) + 1)|0;
                   $exitcond41$i$i = ($168|0)==($100|0);
                   if ($exitcond41$i$i) {
                    $this$0$lcssa$i$i = $167;
                    break;
                   } else {
                    $j$010$i$i = $168;$this$011$i$i = $167;
                   }
                  }
                 } else {
                  $this$0$lcssa$i$i = 0;
                 }
                 $169 = ($best$020$i$i|0)==(-1);
                 $170 = ($this$0$lcssa$i$i|0)<($best$020$i$i|0);
                 $or$cond$i$i = $169 | $170;
                 if (!($or$cond$i$i)) {
                  $best$1$i$i = $best$020$i$i;$index$4$i$i = $index$319$i$i;
                  break;
                 }
                 ;HEAP32[$p$i$i>>2]=HEAP32[$e$i$i>>2]|0;HEAP32[$p$i$i+4>>2]=HEAP32[$e$i$i+4>>2]|0;HEAP32[$p$i$i+8>>2]=HEAP32[$e$i$i+8>>2]|0;HEAP32[$p$i$i+12>>2]=HEAP32[$e$i$i+12>>2]|0;HEAP32[$p$i$i+16>>2]=HEAP32[$e$i$i+16>>2]|0;HEAP32[$p$i$i+20>>2]=HEAP32[$e$i$i+20>>2]|0;HEAP32[$p$i$i+24>>2]=HEAP32[$e$i$i+24>>2]|0;HEAP32[$p$i$i+28>>2]=HEAP32[$e$i$i+28>>2]|0;
                 $best$1$i$i = $this$0$lcssa$i$i;$index$4$i$i = $i$221$i$i;
                } else {
                 $best$1$i$i = $best$020$i$i;$index$4$i$i = $index$319$i$i;
                }
               } while(0);
               $171 = HEAP32[$e$i$i>>2]|0;
               $172 = ($171|0)<($155|0);
               if ($172) {
                $$lcssa$i$i = $e$i$i;$$lcssa7$i$i = $171;
               } else {
                $174 = $e$i$i;$j$113$i$i = 0;
                while(1) {
                 $173 = (($j$113$i$i) + 1)|0;
                 HEAP32[$174>>2] = 0;
                 $175 = (($e$i$i) + ($173<<2)|0);
                 $176 = HEAP32[$175>>2]|0;
                 $177 = ($176|0)<($155|0);
                 if ($177) {
                  $$lcssa$i$i = $175;$$lcssa7$i$i = $176;
                  break;
                 } else {
                  $174 = $175;$j$113$i$i = $173;
                 }
                }
               }
               $178 = ($$lcssa7$i$i|0)>(-1);
               if ($178) {
                $179 = (($$lcssa7$i$i) + ($96))|0;
                HEAP32[$$lcssa$i$i>>2] = $179;
                $181 = $179;
               } else {
                $181 = $$lcssa7$i$i;
               }
               $180 = (0 - ($181))|0;
               HEAP32[$$lcssa$i$i>>2] = $180;
               $182 = (($i$221$i$i) + 1)|0;
               $exitcond$i = ($182|0)==($156|0);
               if ($exitcond$i) {
                $index$5$i$i = $index$4$i$i;
                break;
               } else {
                $best$020$i$i = $best$1$i$i;$i$221$i$i = $182;$index$319$i$i = $index$4$i$i;
               }
              }
             } else {
              $index$5$i$i = $index$2$i$i;
             }
            } while(0);
            $183 = ($index$5$i$i|0)>(-1);
            $or$cond50$i$i = $101 & $183;
            if ($or$cond50$i$i) {
             $$09$i$i = $94;$i$38$i$i = 0;
             while(1) {
              $184 = (($p$i$i) + ($i$38$i$i<<2)|0);
              $185 = HEAP32[$184>>2]|0;
              $186 = ((($$09$i$i)) + 4|0);
              $187 = HEAP32[$$09$i$i>>2]|0;
              $188 = (($187) - ($185))|0;
              HEAP32[$$09$i$i>>2] = $188;
              $189 = (($i$38$i$i) + 1)|0;
              $exitcond$i$i = ($189|0)==($100|0);
              if ($exitcond$i$i) {
               break;
              } else {
               $$09$i$i = $186;$i$38$i$i = $189;
              }
             }
            }
            $190 = (_vorbis_book_encode($81,$index$5$i$i,$opb)|0);
            $191 = (($190) + ($bits$08$i))|0;
            $192 = (($i$09$i) + 1)|0;
            $exitcond15$i = ($192|0)==($86|0);
            if ($exitcond15$i) {
             $$lcssa72 = $191;
             break;
            }
            $$pre$i = HEAP32[$81>>2]|0;
            $100 = $$pre$i;$bits$08$i = $191;$i$09$i = $192;
           }
           $$pre43 = HEAP32[$66>>2]|0;
           $196 = $$pre43;$bits$0$lcssa$i = $$lcssa72;
          } else {
           $196 = $67;$bits$0$lcssa$i = 0;
          }
          $193 = HEAP32[$22>>2]|0;
          $194 = (($193) + ($bits$0$lcssa$i))|0;
          HEAP32[$22>>2] = $194;
          $195 = (($196) + ($i$121<<2)|0);
          $197 = HEAP32[$195>>2]|0;
          $198 = (($resbits) + ($197<<2)|0);
          $199 = HEAP32[$198>>2]|0;
          $200 = (($199) + ($bits$0$lcssa$i))|0;
          HEAP32[$198>>2] = $200;
         }
        }
        $201 = (($j$115) + 1)|0;
        $exitcond35 = ($201|0)==($ch|0);
        if ($exitcond35) {
         break;
        } else {
         $j$115 = $201;
        }
       }
      }
      $202 = (($k$120) + 1)|0;
      $203 = (($i$121) + 1)|0;
      $exitcond36 = ($202|0)==($50|0);
      if ($exitcond36) {
       break;
      } else {
       $i$121 = $203;$k$120 = $202;
      }
     }
     $26 = (($i$024) - ($umax))|0;
     $i$1$lcssa = $26;
    } else {
     $i$1$lcssa = $i$024;
    }
    $27 = ($i$1$lcssa|0)<($12|0);
    if ($27) {
     $i$024 = $i$1$lcssa;
    } else {
     break;
    }
   }
   $$pre44 = HEAP32[$13>>2]|0;
   $206 = $$pre44;
  } else {
   $206 = $207;
  }
  $204 = (($s$026) + 1)|0;
  $205 = ($204|0)<($206|0);
  if ($205) {
   $207 = $206;$s$026 = $204;
  } else {
   break;
  }
 }
 STACKTOP = sp;return;
}
function _ov_ilog($v) {
 $v = $v|0;
 var $$01 = 0, $0 = 0, $1 = 0, $2 = 0, $3 = 0, $ret$0$lcssa = 0, $ret$02 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ($v|0)==(0);
 if ($0) {
  $ret$0$lcssa = 0;
 } else {
  $$01 = $v;$ret$02 = 0;
  while(1) {
   $1 = $$01 >>> 1;
   $2 = (($ret$02) + 1)|0;
   $3 = ($1|0)==(0);
   if ($3) {
    $ret$0$lcssa = $2;
    break;
   } else {
    $$01 = $1;$ret$02 = $2;
   }
  }
 }
 return ($ret$0$lcssa|0);
}
function __make_words($l,$n,$sparsecount) {
 $l = $l|0;
 $n = $n|0;
 $sparsecount = $sparsecount|0;
 var $$0 = 0, $$lcssa47 = 0, $$phi$trans$insert = 0, $$pn = 0, $$pre = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0;
 var $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0;
 var $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0;
 var $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0;
 var $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $9 = 0, $count$024 = 0, $count$1 = 0, $count$1$lcssa = 0, $count$212 = 0, $count$212$us = 0, $count$3$us = 0;
 var $entry$020 = 0, $exitcond = 0, $exitcond34 = 0, $i$025 = 0, $i$114 = 0, $i$213 = 0, $i$213$us = 0, $j$015$lcssa = 0, $j$01549 = 0, $j$1 = 0, $j$1$in19 = 0, $j$1$in19$phi = 0, $j$118 = 0, $j$121 = 0, $j$29 = 0, $j$29$us = 0, $marker = 0, $or$cond = 0, $phitmp = 0, $temp$0$lcssa = 0;
 var $temp$0$lcssa$us = 0, $temp$010 = 0, $temp$010$us = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 144|0;
 $marker = sp;
 $0 = ($sparsecount|0)!=(0);
 $1 = $0 ? $sparsecount : $n;
 $2 = $1 << 2;
 $3 = (_malloc($2)|0);
 _memset(($marker|0),0,132)|0;
 $4 = ($n|0)>(0);
 do {
  if ($4) {
   $5 = ((($marker)) + 4|0);
   $6 = ($sparsecount|0)==(0);
   $7 = $6&1;
   $count$024 = 0;$i$025 = 0;
   L3: while(1) {
    $8 = (($l) + ($i$025)|0);
    $9 = HEAP8[$8>>0]|0;
    $10 = $9 << 24 >> 24;
    $11 = ($9<<24>>24)>(0);
    L5: do {
     if ($11) {
      $12 = (($marker) + ($10<<2)|0);
      $13 = HEAP32[$12>>2]|0;
      $14 = ($9<<24>>24)>(31);
      $15 = $13 >>> $10;
      $16 = ($15|0)==(0);
      $or$cond = $14 | $16;
      if (!($or$cond)) {
       label = 5;
       break L3;
      }
      $17 = (($3) + ($count$024<<2)|0);
      HEAP32[$17>>2] = $13;
      $18 = (($marker) + ($10<<2)|0);
      $19 = $13 & 1;
      $20 = ($19|0)==(0);
      L8: do {
       if ($20) {
        $30 = $13;$31 = $18;$j$01549 = $10;
        while(1) {
         $29 = (($30) + 1)|0;
         HEAP32[$31>>2] = $29;
         $32 = (($j$01549) + -1)|0;
         $33 = ($j$01549|0)>(1);
         if (!($33)) {
          break L8;
         }
         $$phi$trans$insert = (($marker) + ($32<<2)|0);
         $$pre = HEAP32[$$phi$trans$insert>>2]|0;
         $34 = (($marker) + ($32<<2)|0);
         $35 = $$pre & 1;
         $36 = ($35|0)==(0);
         if ($36) {
          $30 = $$pre;$31 = $34;$j$01549 = $32;
         } else {
          $$lcssa47 = $34;$j$015$lcssa = $32;
          label = 8;
          break;
         }
        }
       } else {
        $$lcssa47 = $18;$j$015$lcssa = $10;
        label = 8;
       }
      } while(0);
      do {
       if ((label|0) == 8) {
        label = 0;
        $22 = ($j$015$lcssa|0)==(1);
        if ($22) {
         $23 = HEAP32[$5>>2]|0;
         $24 = (($23) + 1)|0;
         HEAP32[$5>>2] = $24;
         break;
        } else {
         $25 = (($j$015$lcssa) + -1)|0;
         $26 = (($marker) + ($25<<2)|0);
         $27 = HEAP32[$26>>2]|0;
         $28 = $27 << 1;
         HEAP32[$$lcssa47>>2] = $28;
         break;
        }
       }
      } while(0);
      $j$118 = (($10) + 1)|0;
      $21 = ($j$118|0)<(33);
      if ($21) {
       $entry$020 = $13;$j$1$in19 = $10;$j$121 = $j$118;
       while(1) {
        $37 = (($marker) + ($j$121<<2)|0);
        $38 = HEAP32[$37>>2]|0;
        $39 = $38 >>> 1;
        $40 = ($39|0)==($entry$020|0);
        if (!($40)) {
         $$pn = 1;
         break L5;
        }
        $41 = (($marker) + ($j$1$in19<<2)|0);
        $42 = HEAP32[$41>>2]|0;
        $43 = $42 << 1;
        HEAP32[$37>>2] = $43;
        $j$1 = (($j$121) + 1)|0;
        $44 = ($j$1|0)<(33);
        if ($44) {
         $j$1$in19$phi = $j$121;$entry$020 = $38;$j$121 = $j$1;$j$1$in19 = $j$1$in19$phi;
        } else {
         $$pn = 1;
         break;
        }
       }
      } else {
       $$pn = 1;
      }
     } else {
      $$pn = $7;
     }
    } while(0);
    $count$1 = (($count$024) + ($$pn))|0;
    $45 = (($i$025) + 1)|0;
    $46 = ($45|0)<($n|0);
    if ($46) {
     $count$024 = $count$1;$i$025 = $45;
    } else {
     $count$1$lcssa = $count$1;
     label = 16;
     break;
    }
   }
   if ((label|0) == 5) {
    _free($3);
    $$0 = 0;
    STACKTOP = sp;return ($$0|0);
   }
   else if ((label|0) == 16) {
    $phitmp = ($count$1$lcssa|0)==(1);
    if (!($phitmp)) {
     $i$114 = 1;
     label = 27;
     break;
    }
    $47 = ((($marker)) + 8|0);
    $48 = HEAP32[$47>>2]|0;
    $49 = ($48|0)==(2);
    if ($49) {
     break;
    } else {
     $i$114 = 1;
     label = 27;
     break;
    }
   }
  } else {
   $i$114 = 1;
   label = 27;
  }
 } while(0);
 L27: do {
  if ((label|0) == 27) {
   while(1) {
    label = 0;
    $68 = (($marker) + ($i$114<<2)|0);
    $69 = HEAP32[$68>>2]|0;
    $70 = (32 - ($i$114))|0;
    $71 = -1 >>> $70;
    $72 = $69 & $71;
    $73 = ($72|0)==(0);
    $66 = (($i$114) + 1)|0;
    if (!($73)) {
     break;
    }
    $67 = ($66|0)<(33);
    if ($67) {
     $i$114 = $66;
     label = 27;
    } else {
     break L27;
    }
   }
   _free($3);
   $$0 = 0;
   STACKTOP = sp;return ($$0|0);
  }
 } while(0);
 if (!($4)) {
  $$0 = $3;
  STACKTOP = sp;return ($$0|0);
 }
 if ($0) {
  $count$212$us = 0;$i$213$us = 0;
 } else {
  $count$212 = 0;$i$213 = 0;
  while(1) {
   $74 = (($l) + ($i$213)|0);
   $75 = HEAP8[$74>>0]|0;
   $76 = ($75<<24>>24)>(0);
   if ($76) {
    $77 = (($3) + ($count$212<<2)|0);
    $78 = HEAP32[$77>>2]|0;
    $79 = $75 << 24 >> 24;
    $j$29 = 0;$temp$010 = 0;
    while(1) {
     $80 = $temp$010 << 1;
     $81 = $78 >>> $j$29;
     $82 = $81 & 1;
     $83 = $82 | $80;
     $84 = (($j$29) + 1)|0;
     $85 = ($84|0)<($79|0);
     if ($85) {
      $j$29 = $84;$temp$010 = $83;
     } else {
      $temp$0$lcssa = $83;
      break;
     }
    }
   } else {
    $temp$0$lcssa = 0;
   }
   $86 = (($count$212) + 1)|0;
   $87 = (($3) + ($count$212<<2)|0);
   HEAP32[$87>>2] = $temp$0$lcssa;
   $88 = (($i$213) + 1)|0;
   $exitcond = ($88|0)==($n|0);
   if ($exitcond) {
    $$0 = $3;
    break;
   } else {
    $count$212 = $86;$i$213 = $88;
   }
  }
  STACKTOP = sp;return ($$0|0);
 }
 while(1) {
  $50 = (($l) + ($i$213$us)|0);
  $51 = HEAP8[$50>>0]|0;
  $52 = ($51<<24>>24)>(0);
  if ($52) {
   $65 = (($3) + ($count$212$us<<2)|0);
   $59 = HEAP32[$65>>2]|0;
   $64 = $51 << 24 >> 24;
   $j$29$us = 0;$temp$010$us = 0;
   while(1) {
    $57 = $temp$010$us << 1;
    $58 = $59 >>> $j$29$us;
    $60 = $58 & 1;
    $61 = $60 | $57;
    $62 = (($j$29$us) + 1)|0;
    $63 = ($62|0)<($64|0);
    if ($63) {
     $j$29$us = $62;$temp$010$us = $61;
    } else {
     $temp$0$lcssa$us = $61;
     break;
    }
   }
  } else {
   $temp$0$lcssa$us = 0;
  }
  $53 = ($51<<24>>24)==(0);
  if ($53) {
   $count$3$us = $count$212$us;
  } else {
   $54 = (($count$212$us) + 1)|0;
   $55 = (($3) + ($count$212$us<<2)|0);
   HEAP32[$55>>2] = $temp$0$lcssa$us;
   $count$3$us = $54;
  }
  $56 = (($i$213$us) + 1)|0;
  $exitcond34 = ($56|0)==($n|0);
  if ($exitcond34) {
   $$0 = $3;
   break;
  } else {
   $count$212$us = $count$3$us;$i$213$us = $56;
  }
 }
 STACKTOP = sp;return ($$0|0);
}
function __book_maptype1_quantvals($b) {
 $b = $b|0;
 var $$lcssa = 0, $$lcssa10 = 0, $0 = 0, $1 = 0, $10 = 0.0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $3 = 0, $4 = 0.0, $5 = 0.0, $6 = 0.0, $7 = 0.0;
 var $8 = 0.0, $9 = 0.0, $acc$01$us = 0, $acc1$02$us = 0, $i$03$us = 0, $or$cond$us = 0, $vals$0$us = 0, $vals$0$us$be = 0, $vals$0$us$be$v = 0, $vals$0$us$lcssa = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($b)) + 4|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = HEAP32[$b>>2]|0;
 $3 = ($2|0)>(0);
 if (!($3)) {
  while(1) {
  }
 }
 $4 = (+($1|0));
 $5 = $4;
 $6 = (+($2|0));
 $7 = 1.0 / $6;
 $8 = $7;
 $9 = (+Math_pow((+$5),(+$8)));
 $10 = (+Math_floor((+$9)));
 $11 = (~~(($10)));
 $vals$0$us = $11;
 while(1) {
  $17 = (($vals$0$us) + 1)|0;
  $acc$01$us = 1;$acc1$02$us = 1;$i$03$us = 0;
  while(1) {
   $15 = Math_imul($acc$01$us, $vals$0$us)|0;
   $16 = Math_imul($acc1$02$us, $17)|0;
   $18 = (($i$03$us) + 1)|0;
   $19 = ($18|0)<($2|0);
   if ($19) {
    $acc$01$us = $15;$acc1$02$us = $16;$i$03$us = $18;
   } else {
    $$lcssa = $15;$$lcssa10 = $16;
    break;
   }
  }
  $12 = ($$lcssa|0)<=($1|0);
  $13 = ($$lcssa10|0)>($1|0);
  $or$cond$us = $12 & $13;
  if ($or$cond$us) {
   $vals$0$us$lcssa = $vals$0$us;
   break;
  }
  $14 = ($$lcssa|0)>($1|0);
  $vals$0$us$be$v = $14 ? -1 : 1;
  $vals$0$us$be = (($vals$0$us) + ($vals$0$us$be$v))|0;
  $vals$0$us = $vals$0$us$be;
 }
 return ($vals$0$us$lcssa|0);
}
function __book_unquantize($b,$n,$sparsemap) {
 $b = $b|0;
 $n = $n|0;
 $sparsemap = $sparsemap|0;
 var $$$i = 0.0, $$$i6 = 0.0, $$0 = 0, $$lcssa = 0, $$lcssa53 = 0, $$off = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0.0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0.0;
 var $110 = 0.0, $111 = 0.0, $112 = 0.0, $113 = 0.0, $114 = 0.0, $115 = 0.0, $116 = 0.0, $117 = 0, $118 = 0, $119 = 0, $12 = 0.0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0;
 var $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0.0, $139 = 0.0, $14 = 0, $140 = 0.0, $141 = 0.0, $142 = 0.0, $143 = 0.0, $144 = 0.0, $145 = 0, $146 = 0;
 var $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0, $154 = 0, $155 = 0, $16 = 0.0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0.0, $21 = 0, $22 = 0.0, $23 = 0.0, $24 = 0;
 var $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0.0, $34 = 0.0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0.0, $41 = 0.0, $42 = 0.0;
 var $43 = 0.0, $44 = 0.0, $45 = 0.0, $46 = 0.0, $47 = 0, $48 = 0, $49 = 0, $5 = 0.0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0.0, $55 = 0.0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0;
 var $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0;
 var $8 = 0, $80 = 0.0, $81 = 0.0, $82 = 0.0, $83 = 0.0, $84 = 0.0, $85 = 0.0, $86 = 0.0, $87 = 0, $88 = 0, $89 = 0, $9 = 0.0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0.0, $97 = 0.0;
 var $98 = 0.0, $99 = 0.0, $acc$01$us$i = 0, $acc1$02$us$i = 0, $count$019 = 0, $count$1 = 0, $count$233 = 0, $count$3 = 0, $exitcond = 0, $fabsf = 0.0, $fabsf5 = 0.0, $fabsf5$us = 0.0, $fabsf5$us17 = 0.0, $i$03$us$i = 0, $indexdiv$013 = 0, $indexdiv$013$us = 0, $indexdiv$013$us14 = 0, $j$023 = 0, $j$135 = 0, $k$011 = 0;
 var $k$011$us = 0, $k$011$us16 = 0, $k$129 = 0, $last$0$$us = 0.0, $last$012 = 0.0, $last$012$us = 0.0, $last1$0$ = 0.0, $last1$030 = 0.0, $or$cond$us$i = 0, $switch = 0, $vals$0$us$be$i = 0, $vals$0$us$be$v$i = 0, $vals$0$us$i = 0, $vals$0$us$i$lcssa = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($b)) + 12|0);
 $1 = HEAP32[$0>>2]|0;
 $$off = (($1) + -1)|0;
 $switch = ($$off>>>0)<(2);
 if (!($switch)) {
  $$0 = 0;
  return ($$0|0);
 }
 $2 = ((($b)) + 16|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = $3 & 2097151;
 $5 = (+($4|0));
 $6 = $3 >>> 21;
 $7 = $6 & 1023;
 $8 = ($3|0)<(0);
 $9 = -$5;
 $$$i = $8 ? $9 : $5;
 $10 = (($7) + -788)|0;
 $11 = (+_ldexp($$$i,$10));
 $12 = $11;
 $13 = ((($b)) + 20|0);
 $14 = HEAP32[$13>>2]|0;
 $15 = $14 & 2097151;
 $16 = (+($15|0));
 $17 = $14 >>> 21;
 $18 = $17 & 1023;
 $19 = ($14|0)<(0);
 $20 = -$16;
 $$$i6 = $19 ? $20 : $16;
 $21 = (($18) + -788)|0;
 $22 = (+_ldexp($$$i6,$21));
 $23 = $22;
 $24 = HEAP32[$b>>2]|0;
 $25 = Math_imul($24, $n)|0;
 $26 = (_calloc($25,4)|0);
 if ((($1|0) == 1)) {
  $37 = ((($b)) + 4|0);
  $38 = HEAP32[$37>>2]|0;
  $39 = ($24|0)>(0);
  if (!($39)) {
   while(1) {
   }
  }
  $40 = (+($38|0));
  $41 = $40;
  $42 = (+($24|0));
  $43 = 1.0 / $42;
  $44 = $43;
  $45 = (+Math_pow((+$41),(+$44)));
  $46 = (+Math_floor((+$45)));
  $47 = (~~(($46)));
  $vals$0$us$i = $47;
  while(1) {
   $60 = (($vals$0$us$i) + 1)|0;
   $acc$01$us$i = 1;$acc1$02$us$i = 1;$i$03$us$i = 0;
   while(1) {
    $58 = Math_imul($acc$01$us$i, $vals$0$us$i)|0;
    $59 = Math_imul($acc1$02$us$i, $60)|0;
    $61 = (($i$03$us$i) + 1)|0;
    $exitcond = ($61|0)==($24|0);
    if ($exitcond) {
     $$lcssa = $58;$$lcssa53 = $59;
     break;
    } else {
     $acc$01$us$i = $58;$acc1$02$us$i = $59;$i$03$us$i = $61;
    }
   }
   $48 = ($$lcssa|0)<=($38|0);
   $49 = ($$lcssa53|0)>($38|0);
   $or$cond$us$i = $49 & $48;
   if ($or$cond$us$i) {
    $vals$0$us$i$lcssa = $vals$0$us$i;
    break;
   }
   $57 = ($$lcssa|0)>($38|0);
   $vals$0$us$be$v$i = $57 ? -1 : 1;
   $vals$0$us$be$i = (($vals$0$us$be$v$i) + ($vals$0$us$i))|0;
   $vals$0$us$i = $vals$0$us$be$i;
  }
  $50 = ($38|0)>(0);
  if (!($50)) {
   $$0 = $26;
   return ($$0|0);
  }
  $51 = ($sparsemap|0)==(0|0);
  $52 = ((($b)) + 8|0);
  $53 = ((($b)) + 32|0);
  $54 = $23;
  $55 = $12;
  $56 = ((($b)) + 28|0);
  $count$019 = 0;$j$023 = 0;
  while(1) {
   if ($51) {
    $66 = HEAP32[$53>>2]|0;
    $67 = HEAP32[$56>>2]|0;
    $68 = ($67|0)==(0);
    $69 = Math_imul($24, $count$019)|0;
    if ($68) {
     $indexdiv$013$us14 = 1;$k$011$us16 = 0;
     while(1) {
      $92 = (($j$023|0) / ($indexdiv$013$us14|0))&-1;
      $93 = (($92|0) % ($vals$0$us$i$lcssa|0))&-1;
      $94 = (($66) + ($93<<2)|0);
      $95 = HEAP32[$94>>2]|0;
      $96 = (+($95|0));
      $fabsf5$us17 = (+Math_abs((+$96)));
      $97 = $fabsf5$us17;
      $98 = $97 * $54;
      $99 = $55 + $98;
      $100 = $99;
      $101 = (($69) + ($k$011$us16))|0;
      $102 = (($26) + ($101<<2)|0);
      HEAPF32[$102>>2] = $100;
      $103 = Math_imul($indexdiv$013$us14, $vals$0$us$i$lcssa)|0;
      $104 = (($k$011$us16) + 1)|0;
      $105 = ($104|0)<($24|0);
      if ($105) {
       $indexdiv$013$us14 = $103;$k$011$us16 = $104;
      } else {
       label = 21;
       break;
      }
     }
    } else {
     $indexdiv$013 = 1;$k$011 = 0;$last$012 = 0.0;
     while(1) {
      $106 = (($j$023|0) / ($indexdiv$013|0))&-1;
      $107 = (($106|0) % ($vals$0$us$i$lcssa|0))&-1;
      $108 = (($66) + ($107<<2)|0);
      $109 = HEAP32[$108>>2]|0;
      $110 = (+($109|0));
      $fabsf5 = (+Math_abs((+$110)));
      $111 = $fabsf5;
      $112 = $111 * $54;
      $113 = $last$012;
      $114 = $113 + $55;
      $115 = $114 + $112;
      $116 = $115;
      $117 = (($69) + ($k$011))|0;
      $118 = (($26) + ($117<<2)|0);
      HEAPF32[$118>>2] = $116;
      $119 = Math_imul($indexdiv$013, $vals$0$us$i$lcssa)|0;
      $120 = (($k$011) + 1)|0;
      $121 = ($120|0)<($24|0);
      if ($121) {
       $indexdiv$013 = $119;$k$011 = $120;$last$012 = $116;
      } else {
       label = 21;
       break;
      }
     }
    }
   } else {
    $62 = HEAP32[$52>>2]|0;
    $63 = (($62) + ($j$023)|0);
    $64 = HEAP8[$63>>0]|0;
    $65 = ($64<<24>>24)==(0);
    if ($65) {
     $count$1 = $count$019;
    } else {
     $70 = HEAP32[$53>>2]|0;
     $71 = HEAP32[$56>>2]|0;
     $72 = ($71|0)==(0);
     $73 = (($sparsemap) + ($count$019<<2)|0);
     $74 = HEAP32[$73>>2]|0;
     $75 = Math_imul($74, $24)|0;
     $indexdiv$013$us = 1;$k$011$us = 0;$last$012$us = 0.0;
     while(1) {
      $76 = (($j$023|0) / ($indexdiv$013$us|0))&-1;
      $77 = (($76|0) % ($vals$0$us$i$lcssa|0))&-1;
      $78 = (($70) + ($77<<2)|0);
      $79 = HEAP32[$78>>2]|0;
      $80 = (+($79|0));
      $fabsf5$us = (+Math_abs((+$80)));
      $81 = $fabsf5$us;
      $82 = $81 * $54;
      $83 = $last$012$us;
      $84 = $83 + $55;
      $85 = $84 + $82;
      $86 = $85;
      $last$0$$us = $72 ? $last$012$us : $86;
      $87 = (($75) + ($k$011$us))|0;
      $88 = (($26) + ($87<<2)|0);
      HEAPF32[$88>>2] = $86;
      $89 = Math_imul($indexdiv$013$us, $vals$0$us$i$lcssa)|0;
      $90 = (($k$011$us) + 1)|0;
      $91 = ($90|0)<($24|0);
      if ($91) {
       $indexdiv$013$us = $89;$k$011$us = $90;$last$012$us = $last$0$$us;
      } else {
       label = 21;
       break;
      }
     }
    }
   }
   if ((label|0) == 21) {
    label = 0;
    $122 = (($count$019) + 1)|0;
    $count$1 = $122;
   }
   $123 = (($j$023) + 1)|0;
   $124 = ($123|0)<($38|0);
   if ($124) {
    $count$019 = $count$1;$j$023 = $123;
   } else {
    $$0 = $26;
    break;
   }
  }
  return ($$0|0);
 } else if ((($1|0) == 2)) {
  $27 = ((($b)) + 4|0);
  $28 = HEAP32[$27>>2]|0;
  $29 = ($28|0)>(0);
  if (!($29)) {
   $$0 = $26;
   return ($$0|0);
  }
  $30 = ($sparsemap|0)!=(0|0);
  $31 = ((($b)) + 8|0);
  $32 = ((($b)) + 32|0);
  $33 = $23;
  $34 = $12;
  $35 = ((($b)) + 28|0);
  $36 = ($24|0)>(0);
  $count$233 = 0;$j$135 = 0;
  while(1) {
   if ($30) {
    $125 = HEAP32[$31>>2]|0;
    $126 = (($125) + ($j$135)|0);
    $127 = HEAP8[$126>>0]|0;
    $128 = ($127<<24>>24)==(0);
    if ($128) {
     $count$3 = $count$233;
    } else {
     label = 25;
    }
   } else {
    label = 25;
   }
   if ((label|0) == 25) {
    label = 0;
    if ($36) {
     $129 = HEAP32[$32>>2]|0;
     $130 = HEAP32[$35>>2]|0;
     $131 = ($130|0)==(0);
     $132 = (($sparsemap) + ($count$233<<2)|0);
     $133 = Math_imul($24, $j$135)|0;
     $134 = Math_imul($24, $count$233)|0;
     $k$129 = 0;$last1$030 = 0.0;
     while(1) {
      $135 = (($133) + ($k$129))|0;
      $136 = (($129) + ($135<<2)|0);
      $137 = HEAP32[$136>>2]|0;
      $138 = (+($137|0));
      $fabsf = (+Math_abs((+$138)));
      $139 = $fabsf;
      $140 = $139 * $33;
      $141 = $last1$030;
      $142 = $141 + $34;
      $143 = $142 + $140;
      $144 = $143;
      $last1$0$ = $131 ? $last1$030 : $144;
      if ($30) {
       $145 = HEAP32[$132>>2]|0;
       $146 = Math_imul($145, $24)|0;
       $147 = (($146) + ($k$129))|0;
       $148 = (($26) + ($147<<2)|0);
       HEAPF32[$148>>2] = $144;
      } else {
       $149 = (($134) + ($k$129))|0;
       $150 = (($26) + ($149<<2)|0);
       HEAPF32[$150>>2] = $144;
      }
      $151 = (($k$129) + 1)|0;
      $152 = ($151|0)<($24|0);
      if ($152) {
       $k$129 = $151;$last1$030 = $last1$0$;
      } else {
       break;
      }
     }
    }
    $153 = (($count$233) + 1)|0;
    $count$3 = $153;
   }
   $154 = (($j$135) + 1)|0;
   $155 = ($154|0)<($28|0);
   if ($155) {
    $count$233 = $count$3;$j$135 = $154;
   } else {
    $$0 = $26;
    break;
   }
  }
  return ($$0|0);
 } else {
  $$0 = $26;
  return ($$0|0);
 }
 return (0)|0;
}
function _vorbis_staticbook_destroy($b) {
 $b = $b|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ((($b)) + 36|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ($1|0)==(0);
 if ($2) {
  return;
 }
 $3 = ((($b)) + 32|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = ($4|0)==(0|0);
 if (!($5)) {
  _free($4);
 }
 $6 = ((($b)) + 8|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = ($7|0)==(0|0);
 if (!($8)) {
  _free($7);
 }
 _free($b);
 return;
}
function _vorbis_book_clear($b) {
 $b = $b|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, dest = 0, label = 0, sp = 0, stop = 0;
 sp = STACKTOP;
 $0 = ((($b)) + 16|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ($1|0)==(0|0);
 if (!($2)) {
  _free($1);
 }
 $3 = ((($b)) + 20|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = ($4|0)==(0|0);
 if (!($5)) {
  _free($4);
 }
 $6 = ((($b)) + 24|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = ($7|0)==(0|0);
 if (!($8)) {
  _free($7);
 }
 $9 = ((($b)) + 28|0);
 $10 = HEAP32[$9>>2]|0;
 $11 = ($10|0)==(0|0);
 if (!($11)) {
  _free($10);
 }
 $12 = ((($b)) + 32|0);
 $13 = HEAP32[$12>>2]|0;
 $14 = ($13|0)==(0|0);
 if (!($14)) {
  _free($13);
 }
 dest=$b; stop=dest+56|0; do { HEAP32[dest>>2]=0|0; dest=dest+4|0; } while ((dest|0) < (stop|0));
 return;
}
function _vorbis_book_init_encode($c,$s) {
 $c = $c|0;
 $s = $s|0;
 var $$$i = 0.0, $$$i2 = 0.0, $$lcssa = 0, $$lcssa8 = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0.0, $14 = 0.0, $15 = 0.0, $16 = 0.0, $17 = 0.0, $18 = 0.0, $19 = 0.0, $2 = 0, $20 = 0, $21 = 0, $22 = 0;
 var $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0.0, $33 = 0, $34 = 0, $35 = 0, $36 = 0.0, $37 = 0, $38 = 0.0, $39 = 0.0, $4 = 0, $40 = 0;
 var $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0.0, $46 = 0, $47 = 0, $48 = 0, $49 = 0.0, $5 = 0, $50 = 0, $51 = 0.0, $52 = 0.0, $53 = 0, $54 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $acc$01$us$i = 0;
 var $acc1$02$us$i = 0, $exitcond = 0, $i$03$us$i = 0, $or$cond$us$i = 0, $rintf = 0.0, $rintf1 = 0.0, $vals$0$us$be$i = 0, $vals$0$us$be$v$i = 0, $vals$0$us$i = 0, $vals$0$us$i$lcssa = 0, dest = 0, label = 0, sp = 0, stop = 0;
 sp = STACKTOP;
 dest=$c; stop=dest+56|0; do { HEAP32[dest>>2]=0|0; dest=dest+4|0; } while ((dest|0) < (stop|0));
 $0 = ((($c)) + 12|0);
 HEAP32[$0>>2] = $s;
 $1 = ((($s)) + 4|0);
 $2 = HEAP32[$1>>2]|0;
 $3 = ((($c)) + 4|0);
 HEAP32[$3>>2] = $2;
 $4 = ((($c)) + 8|0);
 HEAP32[$4>>2] = $2;
 $5 = HEAP32[$s>>2]|0;
 HEAP32[$c>>2] = $5;
 $6 = ((($s)) + 8|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = (__make_words($7,$2,0)|0);
 $9 = ((($c)) + 20|0);
 HEAP32[$9>>2] = $8;
 $10 = HEAP32[$1>>2]|0;
 $11 = HEAP32[$s>>2]|0;
 $12 = ($11|0)>(0);
 if (!($12)) {
  while(1) {
  }
 }
 $13 = (+($10|0));
 $14 = $13;
 $15 = (+($11|0));
 $16 = 1.0 / $15;
 $17 = $16;
 $18 = (+Math_pow((+$14),(+$17)));
 $19 = (+Math_floor((+$18)));
 $20 = (~~(($19)));
 $vals$0$us$i = $20;
 while(1) {
  $26 = (($vals$0$us$i) + 1)|0;
  $acc$01$us$i = 1;$acc1$02$us$i = 1;$i$03$us$i = 0;
  while(1) {
   $24 = Math_imul($acc$01$us$i, $vals$0$us$i)|0;
   $25 = Math_imul($acc1$02$us$i, $26)|0;
   $27 = (($i$03$us$i) + 1)|0;
   $exitcond = ($27|0)==($11|0);
   if ($exitcond) {
    $$lcssa = $24;$$lcssa8 = $25;
    break;
   } else {
    $acc$01$us$i = $24;$acc1$02$us$i = $25;$i$03$us$i = $27;
   }
  }
  $21 = ($$lcssa|0)<=($10|0);
  $22 = ($$lcssa8|0)>($10|0);
  $or$cond$us$i = $22 & $21;
  if ($or$cond$us$i) {
   $vals$0$us$i$lcssa = $vals$0$us$i;
   break;
  }
  $23 = ($$lcssa|0)>($10|0);
  $vals$0$us$be$v$i = $23 ? -1 : 1;
  $vals$0$us$be$i = (($vals$0$us$be$v$i) + ($vals$0$us$i))|0;
  $vals$0$us$i = $vals$0$us$be$i;
 }
 $28 = ((($c)) + 44|0);
 HEAP32[$28>>2] = $vals$0$us$i$lcssa;
 $29 = ((($s)) + 16|0);
 $30 = HEAP32[$29>>2]|0;
 $31 = $30 & 2097151;
 $32 = (+($31|0));
 $33 = $30 >>> 21;
 $34 = $33 & 1023;
 $35 = ($30|0)<(0);
 $36 = -$32;
 $$$i = $35 ? $36 : $32;
 $37 = (($34) + -788)|0;
 $38 = (+_ldexp($$$i,$37));
 $39 = $38;
 $rintf = (+_rintf($39));
 $40 = (~~(($rintf)));
 $41 = ((($c)) + 48|0);
 HEAP32[$41>>2] = $40;
 $42 = ((($s)) + 20|0);
 $43 = HEAP32[$42>>2]|0;
 $44 = $43 & 2097151;
 $45 = (+($44|0));
 $46 = $43 >>> 21;
 $47 = $46 & 1023;
 $48 = ($43|0)<(0);
 $49 = -$45;
 $$$i2 = $48 ? $49 : $45;
 $50 = (($47) + -788)|0;
 $51 = (+_ldexp($$$i2,$50));
 $52 = $51;
 $rintf1 = (+_rintf($52));
 $53 = (~~(($rintf1)));
 $54 = ((($c)) + 52|0);
 HEAP32[$54>>2] = $53;
 return 0;
}
function _vorbis_book_init_decode($c,$s) {
 $c = $c|0;
 $s = $s|0;
 var $$ = 0, $$0 = 0, $$01$i = 0, $$alloca_mul = 0, $$alloca_mul1 = 0, $$lcssa63 = 0, $$n$0 = 0, $$pre = 0, $$pre52 = 0, $$pre54 = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0;
 var $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0;
 var $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0;
 var $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0;
 var $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0;
 var $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0, $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0;
 var $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0, $206 = 0, $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0;
 var $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0, $224 = 0, $225 = 0, $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0;
 var $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0;
 var $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0;
 var $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0;
 var $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0;
 var $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $exitcond = 0, $exitcond48 = 0, $exitcond49 = 0, $exitcond50 = 0, $hi$012 = 0, $hi$1$lcssa = 0, $hi$18 = 0, $hi$2 = 0, $hival$0 = 0, $i$040 = 0;
 var $i$136 = 0, $i$233 = 0, $i$330 = 0, $i$425 = 0, $i$519 = 0, $i$616 = 0, $i$710 = 0, $j$014 = 0, $lo$011 = 0, $lo$1 = 0, $lo$1$lcssa = 0, $lo$1$op = 0, $lo$1$op$op = 0, $lo$2 = 0, $n$039 = 0, $n$2$lcssa = 0, $n$224 = 0, $n$3 = 0, $n$4$lcssa55 = 0, $n$418 = 0;
 var $n$5 = 0, $n$5$lcssa = 0, $phitmp = 0, $ret$0$lcssa$i = 0, $ret$02$i = 0, $ret$02$i$lcssa = 0, $storemerge2 = 0, dest = 0, label = 0, sp = 0, stop = 0;
 sp = STACKTOP;
 dest=$c; stop=dest+56|0; do { HEAP32[dest>>2]=0|0; dest=dest+4|0; } while ((dest|0) < (stop|0));
 $0 = ((($s)) + 4|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ($1|0)>(0);
 if ($2) {
  $3 = ((($s)) + 8|0);
  $4 = HEAP32[$3>>2]|0;
  $i$040 = 0;$n$039 = 0;
  while(1) {
   $5 = (($4) + ($i$040)|0);
   $6 = HEAP8[$5>>0]|0;
   $7 = ($6<<24>>24)>(0);
   $8 = $7&1;
   $$n$0 = (($8) + ($n$039))|0;
   $9 = (($i$040) + 1)|0;
   $10 = ($9|0)<($1|0);
   if ($10) {
    $i$040 = $9;$n$039 = $$n$0;
   } else {
    $13 = $$n$0;
    break;
   }
  }
 } else {
  $13 = 0;
 }
 $11 = ((($c)) + 4|0);
 HEAP32[$11>>2] = $1;
 $12 = ((($c)) + 8|0);
 HEAP32[$12>>2] = $13;
 $14 = HEAP32[$s>>2]|0;
 HEAP32[$c>>2] = $14;
 $15 = ($13|0)>(0);
 if (!($15)) {
  $$0 = 0;
  STACKTOP = sp;return ($$0|0);
 }
 $16 = ((($s)) + 8|0);
 $17 = HEAP32[$16>>2]|0;
 $18 = (__make_words($17,$1,$13)|0);
 $19 = $13 << 2;
 $$alloca_mul = $19;
 $20 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul)|0)+15)&-16)|0;;
 $21 = ($18|0)==(0|0);
 if ($21) {
  $221 = ((($c)) + 16|0);
  $222 = HEAP32[$221>>2]|0;
  $223 = ($222|0)==(0|0);
  if (!($223)) {
   _free($222);
  }
  $224 = ((($c)) + 20|0);
  $225 = HEAP32[$224>>2]|0;
  $226 = ($225|0)==(0|0);
  if (!($226)) {
   _free($225);
  }
  $227 = ((($c)) + 24|0);
  $228 = HEAP32[$227>>2]|0;
  $229 = ($228|0)==(0|0);
  if (!($229)) {
   _free($228);
  }
  $230 = ((($c)) + 28|0);
  $231 = HEAP32[$230>>2]|0;
  $232 = ($231|0)==(0|0);
  if (!($232)) {
   _free($231);
  }
  $233 = ((($c)) + 32|0);
  $234 = HEAP32[$233>>2]|0;
  $235 = ($234|0)==(0|0);
  if (!($235)) {
   _free($234);
  }
  dest=$c; stop=dest+56|0; do { HEAP32[dest>>2]=0|0; dest=dest+4|0; } while ((dest|0) < (stop|0));
  $$0 = -1;
  STACKTOP = sp;return ($$0|0);
 } else {
  $i$136 = 0;
 }
 while(1) {
  $22 = (($18) + ($i$136<<2)|0);
  $23 = HEAP32[$22>>2]|0;
  $24 = $23 >>> 16;
  $25 = $23 << 16;
  $26 = $24 | $25;
  $27 = $26 >>> 8;
  $28 = $27 & 16711935;
  $29 = $26 << 8;
  $30 = $29 & -16711936;
  $31 = $28 | $30;
  $32 = $31 >>> 4;
  $33 = $32 & 252645135;
  $34 = $31 << 4;
  $35 = $34 & -252645136;
  $36 = $33 | $35;
  $37 = $36 >>> 2;
  $38 = $37 & 858993459;
  $39 = $36 << 2;
  $40 = $39 & -858993460;
  $41 = $38 | $40;
  $42 = $41 >>> 1;
  $43 = $42 & 1431655765;
  $44 = $41 << 1;
  $45 = $44 & -1431655766;
  $46 = $43 | $45;
  HEAP32[$22>>2] = $46;
  $47 = (($20) + ($i$136<<2)|0);
  HEAP32[$47>>2] = $22;
  $48 = (($i$136) + 1)|0;
  $exitcond50 = ($48|0)==($13|0);
  if ($exitcond50) {
   break;
  } else {
   $i$136 = $48;
  }
 }
 _qsort($20,$13,4,10);
 $$alloca_mul1 = $19;
 $49 = STACKTOP; STACKTOP = STACKTOP + ((((1*$$alloca_mul1)|0)+15)&-16)|0;;
 $50 = (_malloc($19)|0);
 $51 = ((($c)) + 20|0);
 HEAP32[$51>>2] = $50;
 $52 = $18;
 $i$233 = 0;
 while(1) {
  $53 = (($20) + ($i$233<<2)|0);
  $54 = HEAP32[$53>>2]|0;
  $55 = $54;
  $56 = (($55) - ($52))|0;
  $57 = $56 >> 2;
  $58 = (($49) + ($57<<2)|0);
  HEAP32[$58>>2] = $i$233;
  $59 = (($i$233) + 1)|0;
  $exitcond49 = ($59|0)==($13|0);
  if ($exitcond49) {
   $i$330 = 0;
   break;
  } else {
   $i$233 = $59;
  }
 }
 while(1) {
  $60 = (($18) + ($i$330<<2)|0);
  $61 = HEAP32[$60>>2]|0;
  $62 = (($49) + ($i$330<<2)|0);
  $63 = HEAP32[$62>>2]|0;
  $64 = (($50) + ($63<<2)|0);
  HEAP32[$64>>2] = $61;
  $65 = (($i$330) + 1)|0;
  $exitcond48 = ($65|0)==($13|0);
  if ($exitcond48) {
   break;
  } else {
   $i$330 = $65;
  }
 }
 _free($18);
 $66 = (__book_unquantize($s,$13,$49)|0);
 $67 = ((($c)) + 16|0);
 HEAP32[$67>>2] = $66;
 $68 = (_malloc($19)|0);
 $69 = ((($c)) + 24|0);
 HEAP32[$69>>2] = $68;
 $70 = HEAP32[$0>>2]|0;
 $71 = ($70|0)>(0);
 if ($71) {
  $$pre = HEAP32[$16>>2]|0;
  $i$425 = 0;$n$224 = 0;
  while(1) {
   $72 = (($$pre) + ($i$425)|0);
   $73 = HEAP8[$72>>0]|0;
   $74 = ($73<<24>>24)>(0);
   if ($74) {
    $75 = (($n$224) + 1)|0;
    $76 = (($49) + ($n$224<<2)|0);
    $77 = HEAP32[$76>>2]|0;
    $78 = (($68) + ($77<<2)|0);
    HEAP32[$78>>2] = $i$425;
    $n$3 = $75;
   } else {
    $n$3 = $n$224;
   }
   $79 = (($i$425) + 1)|0;
   $80 = ($79|0)<($70|0);
   if ($80) {
    $i$425 = $79;$n$224 = $n$3;
   } else {
    $n$2$lcssa = $n$3;
    break;
   }
  }
 } else {
  $n$2$lcssa = 0;
 }
 $81 = (_malloc($n$2$lcssa)|0);
 $82 = ((($c)) + 28|0);
 HEAP32[$82>>2] = $81;
 $83 = ((($c)) + 40|0);
 HEAP32[$83>>2] = 0;
 if ($71) {
  $$pre52 = HEAP32[$16>>2]|0;
  $236 = 0;$85 = $$pre52;$i$519 = 0;$n$418 = 0;
  while(1) {
   $84 = (($85) + ($i$519)|0);
   $86 = HEAP8[$84>>0]|0;
   $87 = ($86<<24>>24)>(0);
   if ($87) {
    $88 = (($n$418) + 1)|0;
    $89 = (($49) + ($n$418<<2)|0);
    $90 = HEAP32[$89>>2]|0;
    $91 = HEAP32[$82>>2]|0;
    $92 = (($91) + ($90)|0);
    HEAP8[$92>>0] = $86;
    $93 = HEAP32[$16>>2]|0;
    $94 = (($93) + ($i$519)|0);
    $95 = HEAP8[$94>>0]|0;
    $96 = $95 << 24 >> 24;
    $97 = HEAP32[$83>>2]|0;
    $98 = ($96|0)>($97|0);
    if ($98) {
     HEAP32[$83>>2] = $96;
     $237 = $96;$238 = $93;$n$5 = $88;
    } else {
     $237 = $97;$238 = $93;$n$5 = $88;
    }
   } else {
    $237 = $236;$238 = $85;$n$5 = $n$418;
   }
   $99 = (($i$519) + 1)|0;
   $100 = HEAP32[$0>>2]|0;
   $101 = ($99|0)<($100|0);
   if ($101) {
    $236 = $237;$85 = $238;$i$519 = $99;$n$418 = $n$5;
   } else {
    $$lcssa63 = $237;$n$5$lcssa = $n$5;
    break;
   }
  }
  $102 = ($n$5$lcssa|0)==(1);
  if ($102) {
   $103 = ($$lcssa63|0)==(1);
   if ($103) {
    $104 = ((($c)) + 36|0);
    HEAP32[$104>>2] = 1;
    $105 = (_calloc(2,4)|0);
    $106 = ((($c)) + 32|0);
    HEAP32[$106>>2] = $105;
    $107 = ((($105)) + 4|0);
    HEAP32[$107>>2] = 1;
    HEAP32[$105>>2] = 1;
    $$0 = 0;
    STACKTOP = sp;return ($$0|0);
   } else {
    $n$4$lcssa55 = 1;
   }
  } else {
   $n$4$lcssa55 = $n$5$lcssa;
  }
 } else {
  $n$4$lcssa55 = 0;
 }
 $108 = HEAP32[$12>>2]|0;
 $109 = ($108|0)==(0);
 if ($109) {
  $ret$0$lcssa$i = -4;
 } else {
  $$01$i = $108;$ret$02$i = 0;
  while(1) {
   $110 = $$01$i >>> 1;
   $111 = (($ret$02$i) + 1)|0;
   $112 = ($110|0)==(0);
   if ($112) {
    $ret$02$i$lcssa = $ret$02$i;
    break;
   } else {
    $$01$i = $110;$ret$02$i = $111;
   }
  }
  $phitmp = (($ret$02$i$lcssa) + -3)|0;
  $ret$0$lcssa$i = $phitmp;
 }
 $113 = ((($c)) + 36|0);
 $114 = ($ret$0$lcssa$i|0)<(5);
 $$ = $114 ? 5 : $ret$0$lcssa$i;
 $115 = ($$|0)>(8);
 $storemerge2 = $115 ? 8 : $$;
 HEAP32[$113>>2] = $storemerge2;
 $116 = 1 << $storemerge2;
 $117 = (_calloc($116,4)|0);
 $118 = ((($c)) + 32|0);
 HEAP32[$118>>2] = $117;
 $119 = ($n$4$lcssa55|0)>(0);
 if ($119) {
  $124 = $storemerge2;$i$616 = 0;
  while(1) {
   $120 = HEAP32[$82>>2]|0;
   $121 = (($120) + ($i$616)|0);
   $122 = HEAP8[$121>>0]|0;
   $123 = $122 << 24 >> 24;
   $125 = ($124|0)<($123|0);
   if ($125) {
    $239 = $124;
   } else {
    $126 = HEAP32[$51>>2]|0;
    $127 = (($126) + ($i$616<<2)|0);
    $128 = HEAP32[$127>>2]|0;
    $129 = $128 >>> 16;
    $130 = $128 << 16;
    $131 = $129 | $130;
    $132 = $131 >>> 8;
    $133 = $132 & 16711935;
    $134 = $131 << 8;
    $135 = $134 & -16711936;
    $136 = $133 | $135;
    $137 = $136 >>> 4;
    $138 = $137 & 252645135;
    $139 = $136 << 4;
    $140 = $139 & -252645136;
    $141 = $138 | $140;
    $142 = $141 >>> 2;
    $143 = $142 & 858993459;
    $144 = $141 << 2;
    $145 = $144 & -858993460;
    $146 = $143 | $145;
    $147 = $146 >>> 1;
    $148 = $147 & 1431655765;
    $149 = $146 << 1;
    $150 = $149 & -1431655766;
    $151 = $148 | $150;
    $152 = (($124) - ($123))|0;
    $153 = ($152|0)==(31);
    if ($153) {
     $239 = $124;
    } else {
     $154 = (($i$616) + 1)|0;
     $156 = $123;$j$014 = 0;
     while(1) {
      $155 = $j$014 << $156;
      $157 = $151 | $155;
      $158 = (($117) + ($157<<2)|0);
      HEAP32[$158>>2] = $154;
      $159 = (($j$014) + 1)|0;
      $160 = HEAP32[$113>>2]|0;
      $161 = HEAP8[$121>>0]|0;
      $162 = $161 << 24 >> 24;
      $163 = (($160) - ($162))|0;
      $164 = 1 << $163;
      $165 = ($159|0)<($164|0);
      if ($165) {
       $156 = $162;$j$014 = $159;
      } else {
       $239 = $160;
       break;
      }
     }
    }
   }
   $166 = (($i$616) + 1)|0;
   $exitcond = ($166|0)==($n$4$lcssa55|0);
   if ($exitcond) {
    $168 = $239;
    break;
   } else {
    $124 = $239;$i$616 = $166;
   }
  }
 } else {
  $168 = $storemerge2;
 }
 $167 = (31 - ($168))|0;
 $169 = -2 << $167;
 $170 = ($storemerge2|0)==(31);
 if ($170) {
  $$0 = 0;
  STACKTOP = sp;return ($$0|0);
 } else {
  $172 = $168;$hi$012 = 0;$i$710 = 0;$lo$011 = 0;
 }
 while(1) {
  $171 = (32 - ($172))|0;
  $173 = $i$710 << $171;
  $174 = $173 >>> 16;
  $175 = $173 << 16;
  $176 = $174 | $175;
  $177 = $176 >>> 8;
  $178 = $177 & 16711935;
  $179 = $176 << 8;
  $180 = $179 & -16711936;
  $181 = $178 | $180;
  $182 = $181 >>> 4;
  $183 = $182 & 252645135;
  $184 = $181 << 4;
  $185 = $184 & -252645136;
  $186 = $183 | $185;
  $187 = $186 >>> 2;
  $188 = $187 & 858993459;
  $189 = $186 << 2;
  $190 = $189 & -858993460;
  $191 = $188 | $190;
  $192 = $191 >>> 1;
  $193 = $192 & 1431655765;
  $194 = $191 << 1;
  $195 = $194 & -1431655766;
  $196 = $193 | $195;
  $197 = (($117) + ($196<<2)|0);
  $198 = HEAP32[$197>>2]|0;
  $199 = ($198|0)==(0);
  if ($199) {
   $lo$1 = $lo$011;
   while(1) {
    $200 = (($lo$1) + 1)|0;
    $201 = ($200|0)<($n$4$lcssa55|0);
    if (!($201)) {
     $lo$1$lcssa = $lo$1;
     break;
    }
    $202 = HEAP32[$51>>2]|0;
    $203 = (($202) + ($200<<2)|0);
    $204 = HEAP32[$203>>2]|0;
    $205 = ($204>>>0)>($173>>>0);
    if ($205) {
     $lo$1$lcssa = $lo$1;
     break;
    } else {
     $lo$1 = $200;
    }
   }
   $206 = ($n$4$lcssa55|0)>($hi$012|0);
   L80: do {
    if ($206) {
     $207 = HEAP32[$51>>2]|0;
     $hi$18 = $hi$012;
     while(1) {
      $208 = (($207) + ($hi$18<<2)|0);
      $209 = HEAP32[$208>>2]|0;
      $210 = $209 & $169;
      $211 = ($173>>>0)<($210>>>0);
      if ($211) {
       $hi$1$lcssa = $hi$18;
       break L80;
      }
      $212 = (($hi$18) + 1)|0;
      $213 = ($n$4$lcssa55|0)>($212|0);
      if ($213) {
       $hi$18 = $212;
      } else {
       $hi$1$lcssa = $212;
       break;
      }
     }
    } else {
     $hi$1$lcssa = $hi$012;
    }
   } while(0);
   $214 = (($n$4$lcssa55) - ($hi$1$lcssa))|0;
   $215 = ($lo$1$lcssa>>>0)>(32767);
   $216 = ($214>>>0)>(32767);
   $hival$0 = $216 ? 32767 : $214;
   $lo$1$op = $lo$1$lcssa << 15;
   $lo$1$op$op = $lo$1$op | -2147483648;
   $217 = $215 ? -1073774592 : $lo$1$op$op;
   $218 = $217 | $hival$0;
   HEAP32[$197>>2] = $218;
   $hi$2 = $hi$1$lcssa;$lo$2 = $lo$1$lcssa;
  } else {
   $hi$2 = $hi$012;$lo$2 = $lo$011;
  }
  $219 = (($i$710) + 1)|0;
  $220 = ($219|0)<($116|0);
  if (!($220)) {
   $$0 = 0;
   break;
  }
  $$pre54 = HEAP32[$113>>2]|0;
  $172 = $$pre54;$hi$012 = $hi$2;$i$710 = $219;$lo$011 = $lo$2;
 }
 STACKTOP = sp;return ($$0|0);
}
function _sort32a($a,$b) {
 $a = $a|0;
 $b = $b|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = HEAP32[$a>>2]|0;
 $1 = HEAP32[$0>>2]|0;
 $2 = HEAP32[$b>>2]|0;
 $3 = HEAP32[$2>>2]|0;
 $4 = ($1>>>0)>($3>>>0);
 $5 = $4&1;
 $6 = ($1>>>0)<($3>>>0);
 $7 = $6&1;
 $8 = (($5) - ($7))|0;
 return ($8|0);
}
function _drft_forward($l,$data) {
 $l = $l|0;
 $data = $data|0;
 var $$sum = 0, $$sum1 = 0, $$sum2 = 0, $$sum2$i = 0, $$sum3 = 0, $$sum4 = 0, $$sum8$i = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0;
 var $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $4 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, $exitcond$i = 0, $exitcond17$i = 0, $i$010$i = 0, $iw$011$i = 0, $k1$014$i = 0, $l2$013$i = 0, $na$0$$i = 0, $na$012$i = 0, $na$2$i = 0, $na$2$i$lcssa = 0, $or$cond$i = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = HEAP32[$l>>2]|0;
 $1 = ($0|0)==(1);
 if ($1) {
  return;
 }
 $2 = ((($l)) + 4|0);
 $3 = HEAP32[$2>>2]|0;
 $4 = ((($l)) + 8|0);
 $5 = HEAP32[$4>>2]|0;
 $6 = ((($5)) + 4|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = ($7|0)>(0);
 if (!($8)) {
  return;
 }
 $9 = (($7) + 1)|0;
 $$sum8$i = (($0) + -1)|0;
 $iw$011$i = $0;$k1$014$i = 0;$l2$013$i = $0;$na$012$i = 1;
 while(1) {
  $10 = (($9) - ($k1$014$i))|0;
  $11 = (($5) + ($10<<2)|0);
  $12 = HEAP32[$11>>2]|0;
  $13 = (($l2$013$i|0) / ($12|0))&-1;
  $14 = (($0|0) / ($l2$013$i|0))&-1;
  $15 = Math_imul($14, $13)|0;
  $16 = (($12) + -1)|0;
  $17 = Math_imul($14, $16)|0;
  $18 = (($iw$011$i) - ($17))|0;
  $19 = (1 - ($na$012$i))|0;
  do {
   if ((($12|0) == 2)) {
    $25 = ($19|0)==(0);
    $$sum = (($$sum8$i) + ($18))|0;
    $26 = (($3) + ($$sum<<2)|0);
    if ($25) {
     _dradf2($14,$13,$data,$3,$26);
     $na$2$i = 0;
     break;
    } else {
     _dradf2($14,$13,$3,$data,$26);
     $na$2$i = $19;
     break;
    }
   } else if ((($12|0) == 4)) {
    $20 = (($18) + ($14))|0;
    $21 = ($19|0)==(0);
    $$sum1 = (($$sum8$i) + ($18))|0;
    $22 = (($3) + ($$sum1<<2)|0);
    $$sum2 = (($$sum8$i) + ($20))|0;
    $23 = (($3) + ($$sum2<<2)|0);
    $$sum2$i = (($$sum8$i) + ($14))|0;
    $$sum3 = (($$sum2$i) + ($20))|0;
    $24 = (($3) + ($$sum3<<2)|0);
    if ($21) {
     _dradf4($14,$13,$data,$3,$22,$23,$24);
     $na$2$i = 0;
     break;
    } else {
     _dradf4($14,$13,$3,$data,$22,$23,$24);
     $na$2$i = $19;
     break;
    }
   } else {
    $27 = ($14|0)==(1);
    $na$0$$i = $27 ? $na$012$i : $19;
    $28 = ($na$0$$i|0)==(0);
    $$sum4 = (($$sum8$i) + ($18))|0;
    $29 = (($3) + ($$sum4<<2)|0);
    if ($28) {
     _dradfg($14,$12,$13,$15,$data,$data,$data,$3,$3,$29);
     $na$2$i = 1;
     break;
    } else {
     _dradfg($14,$12,$13,$15,$3,$3,$3,$data,$data,$29);
     $na$2$i = 0;
     break;
    }
   }
  } while(0);
  $30 = (($k1$014$i) + 1)|0;
  $exitcond17$i = ($30|0)==($7|0);
  if ($exitcond17$i) {
   $na$2$i$lcssa = $na$2$i;
   break;
  } else {
   $iw$011$i = $18;$k1$014$i = $30;$l2$013$i = $13;$na$012$i = $na$2$i;
  }
 }
 $31 = ($na$2$i$lcssa|0)!=(1);
 $32 = ($0|0)>(0);
 $or$cond$i = $32 & $31;
 if ($or$cond$i) {
  $i$010$i = 0;
 } else {
  return;
 }
 while(1) {
  $33 = (($3) + ($i$010$i<<2)|0);
  $34 = HEAP32[$33>>2]|0;
  $35 = (($data) + ($i$010$i<<2)|0);
  HEAP32[$35>>2] = $34;
  $36 = (($i$010$i) + 1)|0;
  $exitcond$i = ($36|0)==($0|0);
  if ($exitcond$i) {
   break;
  } else {
   $i$010$i = $36;
  }
 }
 return;
}
function _drft_init($l,$n) {
 $l = $l|0;
 $n = $n|0;
 var $$lcssa = 0, $$not$i$i = 0, $$sum$i = 0, $$sum1$i = 0, $0 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0;
 var $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0.0, $3 = 0, $30 = 0.0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0;
 var $41 = 0, $42 = 0.0, $43 = 0.0, $44 = 0.0, $45 = 0.0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0;
 var $cosf$i$i = 0.0, $exitcond$i$i = 0, $exitcond28$i$i = 0, $exitcond29$i$i = 0, $fi$010$i$i = 0.0, $i$021$i$i = 0, $i$19$i$i = 0, $ii$08$i$i = 0, $indvars$iv$i$i = 0, $indvars$iv$i$i$lcssa18 = 0, $indvars$iv$in$i$i = 0, $indvars$iv$in$i$i$lcssa16 = 0, $is$018$i$i = 0, $is$1$lcssa$i$i = 0, $is$112$i$i = 0, $j$0$i$i = 0, $j$113$i$i = 0, $k1$019$i$i = 0, $l1$017$i$i = 0, $ld$011$i$i = 0;
 var $nf$0$i$i = 0, $nl$0$i$i = 0, $nl$1$i$i = 0, $ntry$0$i$i = 0, $ntry$1$ph$i$i = 0, $or$cond$i$i = 0, $or$cond33$i$i = 0, $sinf$i$i = 0.0, label = 0, sp = 0;
 sp = STACKTOP;
 HEAP32[$l>>2] = $n;
 $0 = ($n*3)|0;
 $1 = (_calloc($0,4)|0);
 $2 = ((($l)) + 4|0);
 HEAP32[$2>>2] = $1;
 $3 = (_calloc(32,4)|0);
 $4 = ((($l)) + 8|0);
 HEAP32[$4>>2] = $3;
 $5 = ($n|0)==(1);
 if ($5) {
  return;
 }
 $6 = ((($3)) + 8|0);
 $j$0$i$i = -1;$nf$0$i$i = 0;$nl$0$i$i = $n;$ntry$0$i$i = 0;
 L4: while(1) {
  $7 = (($j$0$i$i) + 1)|0;
  $8 = ($7|0)<(4);
  if ($8) {
   $9 = (25768 + ($7<<2)|0);
   $10 = HEAP32[$9>>2]|0;
   $ntry$1$ph$i$i = $10;
  } else {
   $11 = (($ntry$0$i$i) + 2)|0;
   $ntry$1$ph$i$i = $11;
  }
  $12 = ($ntry$1$ph$i$i|0)!=(2);
  $indvars$iv$in$i$i = $nf$0$i$i;$nl$1$i$i = $nl$0$i$i;
  while(1) {
   $indvars$iv$i$i = (($indvars$iv$in$i$i) + 1)|0;
   $13 = (($nl$1$i$i|0) / ($ntry$1$ph$i$i|0))&-1;
   $14 = Math_imul($13, $ntry$1$ph$i$i)|0;
   $15 = ($nl$1$i$i|0)==($14|0);
   if (!($15)) {
    $j$0$i$i = $7;$nf$0$i$i = $indvars$iv$in$i$i;$nl$0$i$i = $nl$1$i$i;$ntry$0$i$i = $ntry$1$ph$i$i;
    continue L4;
   }
   $16 = (($indvars$iv$in$i$i) + 2)|0;
   $17 = (($3) + ($16<<2)|0);
   HEAP32[$17>>2] = $ntry$1$ph$i$i;
   $18 = ($indvars$iv$in$i$i|0)==(0);
   $or$cond$i$i = $12 | $18;
   if (!($or$cond$i$i)) {
    $19 = ($indvars$iv$in$i$i|0)<(1);
    if (!($19)) {
     $i$021$i$i = 1;
     while(1) {
      $20 = (($indvars$iv$i$i) - ($i$021$i$i))|0;
      $21 = (($20) + 1)|0;
      $22 = (($3) + ($21<<2)|0);
      $23 = HEAP32[$22>>2]|0;
      $24 = (($20) + 2)|0;
      $25 = (($3) + ($24<<2)|0);
      HEAP32[$25>>2] = $23;
      $26 = (($i$021$i$i) + 1)|0;
      $exitcond29$i$i = ($26|0)==($indvars$iv$i$i|0);
      if ($exitcond29$i$i) {
       break;
      } else {
       $i$021$i$i = $26;
      }
     }
    }
    HEAP32[$6>>2] = 2;
   }
   $27 = ($13|0)==(1);
   if ($27) {
    $$lcssa = $18;$indvars$iv$i$i$lcssa18 = $indvars$iv$i$i;$indvars$iv$in$i$i$lcssa16 = $indvars$iv$in$i$i;
    break L4;
   } else {
    $indvars$iv$in$i$i = $indvars$iv$i$i;$nl$1$i$i = $13;
   }
  }
 }
 HEAP32[$3>>2] = $n;
 $28 = ((($3)) + 4|0);
 HEAP32[$28>>2] = $indvars$iv$i$i$lcssa18;
 $29 = (+($n|0));
 $30 = 6.2831854820251465 / $29;
 $$not$i$i = $$lcssa ^ 1;
 $31 = ($indvars$iv$in$i$i$lcssa16|0)>(0);
 $or$cond33$i$i = $31 & $$not$i$i;
 if (!($or$cond33$i$i)) {
  return;
 }
 $32 = (($n) + 1)|0;
 $is$018$i$i = 0;$k1$019$i$i = 0;$l1$017$i$i = 1;
 while(1) {
  $33 = (($k1$019$i$i) + 2)|0;
  $34 = (($3) + ($33<<2)|0);
  $35 = HEAP32[$34>>2]|0;
  $36 = Math_imul($35, $l1$017$i$i)|0;
  $37 = (($n|0) / ($36|0))&-1;
  $38 = ($35|0)>(1);
  if ($38) {
   $39 = ($37|0)>(2);
   $40 = (($35) + -1)|0;
   $is$112$i$i = $is$018$i$i;$j$113$i$i = 0;$ld$011$i$i = 0;
   while(1) {
    $41 = (($ld$011$i$i) + ($l1$017$i$i))|0;
    $42 = (+($41|0));
    $43 = $42 * $30;
    if ($39) {
     $fi$010$i$i = 0.0;$i$19$i$i = $is$112$i$i;$ii$08$i$i = 2;
     while(1) {
      $44 = $fi$010$i$i + 1.0;
      $45 = $43 * $44;
      $cosf$i$i = (+Math_cos((+$45)));
      $$sum$i = (($i$19$i$i) + ($n))|0;
      $46 = (($1) + ($$sum$i<<2)|0);
      HEAPF32[$46>>2] = $cosf$i$i;
      $sinf$i$i = (+Math_sin((+$45)));
      $47 = (($i$19$i$i) + 2)|0;
      $$sum1$i = (($32) + ($i$19$i$i))|0;
      $48 = (($1) + ($$sum1$i<<2)|0);
      HEAPF32[$48>>2] = $sinf$i$i;
      $49 = (($ii$08$i$i) + 2)|0;
      $50 = ($49|0)<($37|0);
      if ($50) {
       $fi$010$i$i = $44;$i$19$i$i = $47;$ii$08$i$i = $49;
      } else {
       break;
      }
     }
    }
    $51 = (($is$112$i$i) + ($37))|0;
    $52 = (($j$113$i$i) + 1)|0;
    $exitcond$i$i = ($52|0)==($40|0);
    if ($exitcond$i$i) {
     break;
    } else {
     $is$112$i$i = $51;$j$113$i$i = $52;$ld$011$i$i = $41;
    }
   }
   $53 = Math_imul($37, $40)|0;
   $54 = (($53) + ($is$018$i$i))|0;
   $is$1$lcssa$i$i = $54;
  } else {
   $is$1$lcssa$i$i = $is$018$i$i;
  }
  $55 = (($k1$019$i$i) + 1)|0;
  $exitcond28$i$i = ($55|0)==($indvars$iv$in$i$i$lcssa16|0);
  if ($exitcond28$i$i) {
   break;
  } else {
   $is$018$i$i = $is$1$lcssa$i$i;$k1$019$i$i = $55;$l1$017$i$i = $36;
  }
 }
 return;
}
function _drft_clear($l) {
 $l = $l|0;
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = ($l|0)==(0|0);
 if ($0) {
  return;
 }
 $1 = ((($l)) + 4|0);
 $2 = HEAP32[$1>>2]|0;
 $3 = ($2|0)==(0|0);
 if (!($3)) {
  _free($2);
 }
 $4 = ((($l)) + 8|0);
 $5 = HEAP32[$4>>2]|0;
 $6 = ($5|0)==(0|0);
 if (!($6)) {
  _free($5);
 }
 ;HEAP32[$l>>2]=0|0;HEAP32[$l+4>>2]=0|0;HEAP32[$l+8>>2]=0|0;
 return;
}
function _dradf4($ido,$l1,$cc,$ch,$wa1,$wa2,$wa3) {
 $ido = $ido|0;
 $l1 = $l1|0;
 $cc = $cc|0;
 $ch = $ch|0;
 $wa1 = $wa1|0;
 $wa2 = $wa2|0;
 $wa3 = $wa3|0;
 var $0 = 0, $1 = 0, $10 = 0.0, $100 = 0, $101 = 0.0, $102 = 0.0, $103 = 0.0, $104 = 0, $105 = 0, $106 = 0.0, $107 = 0.0, $108 = 0.0, $109 = 0.0, $11 = 0.0, $110 = 0, $111 = 0, $112 = 0.0, $113 = 0, $114 = 0.0, $115 = 0;
 var $116 = 0, $117 = 0.0, $118 = 0, $119 = 0.0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0.0, $124 = 0, $125 = 0.0, $126 = 0, $127 = 0, $128 = 0, $129 = 0.0, $13 = 0.0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0.0, $144 = 0, $145 = 0.0, $146 = 0.0, $147 = 0.0, $148 = 0.0, $149 = 0.0, $15 = 0.0, $150 = 0, $151 = 0;
 var $152 = 0.0, $153 = 0.0, $154 = 0, $155 = 0, $156 = 0.0, $157 = 0.0, $158 = 0, $159 = 0, $16 = 0.0, $160 = 0, $161 = 0, $162 = 0, $163 = 0.0, $164 = 0.0, $165 = 0, $166 = 0.0, $167 = 0.0, $168 = 0, $169 = 0, $17 = 0.0;
 var $170 = 0, $171 = 0, $172 = 0, $173 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0.0, $21 = 0, $22 = 0, $23 = 0.0, $24 = 0.0, $25 = 0.0, $26 = 0, $27 = 0, $28 = 0, $29 = 0.0, $3 = 0, $30 = 0.0, $31 = 0.0;
 var $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0.0, $5 = 0;
 var $50 = 0, $51 = 0, $52 = 0.0, $53 = 0.0, $54 = 0, $55 = 0, $56 = 0.0, $57 = 0, $58 = 0.0, $59 = 0.0, $6 = 0, $60 = 0.0, $61 = 0.0, $62 = 0.0, $63 = 0.0, $64 = 0, $65 = 0, $66 = 0.0, $67 = 0, $68 = 0;
 var $69 = 0.0, $7 = 0, $70 = 0.0, $71 = 0, $72 = 0.0, $73 = 0, $74 = 0.0, $75 = 0.0, $76 = 0.0, $77 = 0.0, $78 = 0.0, $79 = 0.0, $8 = 0.0, $80 = 0, $81 = 0, $82 = 0.0, $83 = 0, $84 = 0, $85 = 0.0, $86 = 0.0;
 var $87 = 0, $88 = 0.0, $89 = 0, $9 = 0, $90 = 0.0, $91 = 0.0, $92 = 0.0, $93 = 0.0, $94 = 0.0, $95 = 0.0, $96 = 0.0, $97 = 0.0, $98 = 0.0, $99 = 0.0, $exitcond = 0, $exitcond24 = 0, $exitcond25 = 0, $i$09$us = 0, $k$019 = 0, $k$112$us = 0;
 var $k$25 = 0, $t1$018 = 0, $t1$111$us = 0, $t1$24 = 0, $t2$017 = 0, $t2$18$us = 0, $t2$23 = 0, $t3$016 = 0, $t4$015 = 0, $t4$17$us = 0, $t4$22 = 0, $t5$06$us = 0, $t6$01 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = Math_imul($l1, $ido)|0;
 $1 = $0 << 1;
 $2 = ($l1|0)>(0);
 if ($2) {
  $3 = ($0*3)|0;
  $4 = $ido << 2;
  $5 = (($4) + -1)|0;
  $6 = $ido << 1;
  $k$019 = 0;$t1$018 = $0;$t2$017 = $3;$t3$016 = 0;$t4$015 = $1;
  while(1) {
   $7 = (($cc) + ($t1$018<<2)|0);
   $8 = +HEAPF32[$7>>2];
   $9 = (($cc) + ($t2$017<<2)|0);
   $10 = +HEAPF32[$9>>2];
   $11 = $10 + $8;
   $12 = (($cc) + ($t3$016<<2)|0);
   $13 = +HEAPF32[$12>>2];
   $14 = (($cc) + ($t4$015<<2)|0);
   $15 = +HEAPF32[$14>>2];
   $16 = $15 + $13;
   $17 = $16 + $11;
   $18 = $t3$016 << 2;
   $19 = (($ch) + ($18<<2)|0);
   HEAPF32[$19>>2] = $17;
   $20 = $16 - $11;
   $21 = (($5) + ($18))|0;
   $22 = (($ch) + ($21<<2)|0);
   HEAPF32[$22>>2] = $20;
   $23 = +HEAPF32[$12>>2];
   $24 = +HEAPF32[$14>>2];
   $25 = $23 - $24;
   $26 = (($18) + ($6))|0;
   $27 = (($26) + -1)|0;
   $28 = (($ch) + ($27<<2)|0);
   HEAPF32[$28>>2] = $25;
   $29 = +HEAPF32[$9>>2];
   $30 = +HEAPF32[$7>>2];
   $31 = $29 - $30;
   $32 = (($ch) + ($26<<2)|0);
   HEAPF32[$32>>2] = $31;
   $33 = (($t1$018) + ($ido))|0;
   $34 = (($t2$017) + ($ido))|0;
   $35 = (($t3$016) + ($ido))|0;
   $36 = (($t4$015) + ($ido))|0;
   $37 = (($k$019) + 1)|0;
   $exitcond24 = ($37|0)==($l1|0);
   if ($exitcond24) {
    break;
   } else {
    $k$019 = $37;$t1$018 = $33;$t2$017 = $34;$t3$016 = $35;$t4$015 = $36;
   }
  }
 }
 $38 = ($ido|0)<(2);
 if ($38) {
  return;
 }
 $39 = ($ido|0)==(2);
 if (!($39)) {
  if ($2) {
   $40 = $ido << 1;
   $k$112$us = 0;$t1$111$us = 0;
   while(1) {
    $133 = $t1$111$us << 2;
    $134 = (($133) + ($40))|0;
    $i$09$us = 2;$t2$18$us = $t1$111$us;$t4$17$us = $133;$t5$06$us = $134;
    while(1) {
     $43 = (($t2$18$us) + 2)|0;
     $44 = (($t4$17$us) + 2)|0;
     $45 = (($t5$06$us) + -2)|0;
     $46 = (($43) + ($0))|0;
     $47 = (($i$09$us) + -2)|0;
     $48 = (($wa1) + ($47<<2)|0);
     $49 = +HEAPF32[$48>>2];
     $50 = (($46) + -1)|0;
     $51 = (($cc) + ($50<<2)|0);
     $52 = +HEAPF32[$51>>2];
     $53 = $52 * $49;
     $54 = (($i$09$us) + -1)|0;
     $55 = (($wa1) + ($54<<2)|0);
     $56 = +HEAPF32[$55>>2];
     $57 = (($cc) + ($46<<2)|0);
     $58 = +HEAPF32[$57>>2];
     $59 = $58 * $56;
     $60 = $59 + $53;
     $61 = $58 * $49;
     $62 = $56 * $52;
     $63 = $61 - $62;
     $64 = (($46) + ($0))|0;
     $65 = (($wa2) + ($47<<2)|0);
     $66 = +HEAPF32[$65>>2];
     $67 = (($64) + -1)|0;
     $68 = (($cc) + ($67<<2)|0);
     $69 = +HEAPF32[$68>>2];
     $70 = $69 * $66;
     $71 = (($wa2) + ($54<<2)|0);
     $72 = +HEAPF32[$71>>2];
     $73 = (($cc) + ($64<<2)|0);
     $74 = +HEAPF32[$73>>2];
     $75 = $74 * $72;
     $76 = $75 + $70;
     $77 = $74 * $66;
     $78 = $72 * $69;
     $79 = $77 - $78;
     $80 = (($64) + ($0))|0;
     $81 = (($wa3) + ($47<<2)|0);
     $82 = +HEAPF32[$81>>2];
     $83 = (($80) + -1)|0;
     $84 = (($cc) + ($83<<2)|0);
     $85 = +HEAPF32[$84>>2];
     $86 = $85 * $82;
     $87 = (($wa3) + ($54<<2)|0);
     $88 = +HEAPF32[$87>>2];
     $89 = (($cc) + ($80<<2)|0);
     $90 = +HEAPF32[$89>>2];
     $91 = $90 * $88;
     $92 = $91 + $86;
     $93 = $90 * $82;
     $94 = $88 * $85;
     $95 = $93 - $94;
     $96 = $92 + $60;
     $97 = $92 - $60;
     $98 = $95 + $63;
     $99 = $63 - $95;
     $100 = (($cc) + ($43<<2)|0);
     $101 = +HEAPF32[$100>>2];
     $102 = $101 + $79;
     $103 = $101 - $79;
     $104 = (($t2$18$us) + 1)|0;
     $105 = (($cc) + ($104<<2)|0);
     $106 = +HEAPF32[$105>>2];
     $107 = $106 + $76;
     $108 = $106 - $76;
     $109 = $96 + $107;
     $110 = $t4$17$us | 1;
     $111 = (($ch) + ($110<<2)|0);
     HEAPF32[$111>>2] = $109;
     $112 = $98 + $102;
     $113 = (($ch) + ($44<<2)|0);
     HEAPF32[$113>>2] = $112;
     $114 = $108 - $99;
     $115 = (($t5$06$us) + -3)|0;
     $116 = (($ch) + ($115<<2)|0);
     HEAPF32[$116>>2] = $114;
     $117 = $97 - $103;
     $118 = (($ch) + ($45<<2)|0);
     HEAPF32[$118>>2] = $117;
     $119 = $99 + $108;
     $120 = (($44) + ($40))|0;
     $121 = (($120) + -1)|0;
     $122 = (($ch) + ($121<<2)|0);
     HEAPF32[$122>>2] = $119;
     $123 = $97 + $103;
     $124 = (($ch) + ($120<<2)|0);
     HEAPF32[$124>>2] = $123;
     $125 = $107 - $96;
     $126 = (($45) + ($40))|0;
     $127 = (($126) + -1)|0;
     $128 = (($ch) + ($127<<2)|0);
     HEAPF32[$128>>2] = $125;
     $129 = $98 - $102;
     $130 = (($ch) + ($126<<2)|0);
     HEAPF32[$130>>2] = $129;
     $131 = (($i$09$us) + 2)|0;
     $132 = ($131|0)<($ido|0);
     if ($132) {
      $i$09$us = $131;$t2$18$us = $43;$t4$17$us = $44;$t5$06$us = $45;
     } else {
      break;
     }
    }
    $41 = (($t1$111$us) + ($ido))|0;
    $42 = (($k$112$us) + 1)|0;
    $exitcond25 = ($42|0)==($l1|0);
    if ($exitcond25) {
     break;
    } else {
     $k$112$us = $42;$t1$111$us = $41;
    }
   }
  }
  $135 = $ido & 1;
  $136 = ($135|0)==(0);
  if (!($136)) {
   return;
  }
 }
 $137 = (($ido) + -1)|0;
 $138 = (($137) + ($0))|0;
 $139 = $ido << 2;
 $140 = $ido << 1;
 if (!($2)) {
  return;
 }
 $141 = (($138) + ($1))|0;
 $k$25 = 0;$t1$24 = $138;$t2$23 = $141;$t4$22 = $ido;$t6$01 = $ido;
 while(1) {
  $142 = (($cc) + ($t1$24<<2)|0);
  $143 = +HEAPF32[$142>>2];
  $144 = (($cc) + ($t2$23<<2)|0);
  $145 = +HEAPF32[$144>>2];
  $146 = $145 + $143;
  $147 = $146 * -0.70710676908493042;
  $148 = $143 - $145;
  $149 = $148 * 0.70710676908493042;
  $150 = (($t6$01) + -1)|0;
  $151 = (($cc) + ($150<<2)|0);
  $152 = +HEAPF32[$151>>2];
  $153 = $149 + $152;
  $154 = (($t4$22) + -1)|0;
  $155 = (($ch) + ($154<<2)|0);
  HEAPF32[$155>>2] = $153;
  $156 = +HEAPF32[$151>>2];
  $157 = $156 - $149;
  $158 = (($t4$22) + ($140))|0;
  $159 = (($158) + -1)|0;
  $160 = (($ch) + ($159<<2)|0);
  HEAPF32[$160>>2] = $157;
  $161 = (($t1$24) + ($0))|0;
  $162 = (($cc) + ($161<<2)|0);
  $163 = +HEAPF32[$162>>2];
  $164 = $147 - $163;
  $165 = (($ch) + ($t4$22<<2)|0);
  HEAPF32[$165>>2] = $164;
  $166 = +HEAPF32[$162>>2];
  $167 = $166 + $147;
  $168 = (($ch) + ($158<<2)|0);
  HEAPF32[$168>>2] = $167;
  $169 = (($t1$24) + ($ido))|0;
  $170 = (($t2$23) + ($ido))|0;
  $171 = (($t4$22) + ($139))|0;
  $172 = (($t6$01) + ($ido))|0;
  $173 = (($k$25) + 1)|0;
  $exitcond = ($173|0)==($l1|0);
  if ($exitcond) {
   break;
  } else {
   $k$25 = $173;$t1$24 = $169;$t2$23 = $170;$t4$22 = $171;$t6$01 = $172;
  }
 }
 return;
}
function _dradf2($ido,$l1,$cc,$ch,$wa1) {
 $ido = $ido|0;
 $l1 = $l1|0;
 $cc = $cc|0;
 $ch = $ch|0;
 $wa1 = $wa1|0;
 var $0 = 0, $1 = 0, $10 = 0, $11 = 0.0, $12 = 0.0, $13 = 0.0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0.0, $31 = 0, $32 = 0, $33 = 0.0, $34 = 0.0, $35 = 0, $36 = 0, $37 = 0.0, $38 = 0, $39 = 0.0, $4 = 0, $40 = 0.0, $41 = 0.0, $42 = 0.0, $43 = 0.0, $44 = 0.0;
 var $45 = 0, $46 = 0.0, $47 = 0.0, $48 = 0, $49 = 0.0, $5 = 0.0, $50 = 0.0, $51 = 0, $52 = 0, $53 = 0, $54 = 0.0, $55 = 0.0, $56 = 0, $57 = 0, $58 = 0.0, $59 = 0.0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0.0, $70 = 0, $71 = 0.0, $72 = 0.0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0.0, $80 = 0;
 var $81 = 0, $9 = 0, $exitcond = 0, $exitcond23 = 0, $exitcond24 = 0, $i$05$us = 0, $k$016 = 0, $k$111$us = 0, $k$21 = 0, $t1$017 = 0, $t1$112$us = 0, $t1$22 = 0, $t2$018 = 0, $t2$113$us = 0, $t2$23 = 0, $t3$06$us = 0, $t3$14 = 0, $t4$07$us = 0, $t5$08$us = 0, $t6$09$us = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 $0 = Math_imul($l1, $ido)|0;
 $1 = $ido << 1;
 $2 = ($l1|0)>(0);
 if ($2) {
  $3 = (($1) + -1)|0;
  $k$016 = 0;$t1$017 = 0;$t2$018 = $0;
  while(1) {
   $4 = (($cc) + ($t1$017<<2)|0);
   $5 = +HEAPF32[$4>>2];
   $6 = (($cc) + ($t2$018<<2)|0);
   $7 = +HEAPF32[$6>>2];
   $8 = $7 + $5;
   $9 = $t1$017 << 1;
   $10 = (($ch) + ($9<<2)|0);
   HEAPF32[$10>>2] = $8;
   $11 = +HEAPF32[$4>>2];
   $12 = +HEAPF32[$6>>2];
   $13 = $11 - $12;
   $14 = (($3) + ($9))|0;
   $15 = (($ch) + ($14<<2)|0);
   HEAPF32[$15>>2] = $13;
   $16 = (($t1$017) + ($ido))|0;
   $17 = (($t2$018) + ($ido))|0;
   $18 = (($k$016) + 1)|0;
   $exitcond23 = ($18|0)==($l1|0);
   if ($exitcond23) {
    break;
   } else {
    $k$016 = $18;$t1$017 = $16;$t2$018 = $17;
   }
  }
 }
 $19 = ($ido|0)<(2);
 if ($19) {
  return;
 }
 $20 = ($ido|0)==(2);
 if (!($20)) {
  if ($2) {
   $k$111$us = 0;$t1$112$us = 0;$t2$113$us = $0;
   while(1) {
    $64 = $t1$112$us << 1;
    $65 = (($64) + ($1))|0;
    $i$05$us = 2;$t3$06$us = $t2$113$us;$t4$07$us = $65;$t5$08$us = $t1$112$us;$t6$09$us = $64;
    while(1) {
     $24 = (($t3$06$us) + 2)|0;
     $25 = (($t4$07$us) + -2)|0;
     $26 = (($t5$08$us) + 2)|0;
     $27 = (($t6$09$us) + 2)|0;
     $28 = (($i$05$us) + -2)|0;
     $29 = (($wa1) + ($28<<2)|0);
     $30 = +HEAPF32[$29>>2];
     $31 = (($t3$06$us) + 1)|0;
     $32 = (($cc) + ($31<<2)|0);
     $33 = +HEAPF32[$32>>2];
     $34 = $33 * $30;
     $35 = (($i$05$us) + -1)|0;
     $36 = (($wa1) + ($35<<2)|0);
     $37 = +HEAPF32[$36>>2];
     $38 = (($cc) + ($24<<2)|0);
     $39 = +HEAPF32[$38>>2];
     $40 = $39 * $37;
     $41 = $40 + $34;
     $42 = $39 * $30;
     $43 = $37 * $33;
     $44 = $42 - $43;
     $45 = (($cc) + ($26<<2)|0);
     $46 = +HEAPF32[$45>>2];
     $47 = $44 + $46;
     $48 = (($ch) + ($27<<2)|0);
     HEAPF32[$48>>2] = $47;
     $49 = +HEAPF32[$45>>2];
     $50 = $44 - $49;
     $51 = (($ch) + ($25<<2)|0);
     HEAPF32[$51>>2] = $50;
     $52 = (($t5$08$us) + 1)|0;
     $53 = (($cc) + ($52<<2)|0);
     $54 = +HEAPF32[$53>>2];
     $55 = $54 + $41;
     $56 = $t6$09$us | 1;
     $57 = (($ch) + ($56<<2)|0);
     HEAPF32[$57>>2] = $55;
     $58 = +HEAPF32[$53>>2];
     $59 = $58 - $41;
     $60 = (($t4$07$us) + -3)|0;
     $61 = (($ch) + ($60<<2)|0);
     HEAPF32[$61>>2] = $59;
     $62 = (($i$05$us) + 2)|0;
     $63 = ($62|0)<($ido|0);
     if ($63) {
      $i$05$us = $62;$t3$06$us = $24;$t4$07$us = $25;$t5$08$us = $26;$t6$09$us = $27;
     } else {
      break;
     }
    }
    $21 = (($t1$112$us) + ($ido))|0;
    $22 = (($t2$113$us) + ($ido))|0;
    $23 = (($k$111$us) + 1)|0;
    $exitcond24 = ($23|0)==($l1|0);
    if ($exitcond24) {
     break;
    } else {
     $k$111$us = $23;$t1$112$us = $21;$t2$113$us = $22;
    }
   }
  }
  $66 = (($ido|0) % 2)&-1;
  $67 = ($66|0)==(1);
  if ($67) {
   return;
  }
 }
 $68 = (($ido) + -1)|0;
 if (!($2)) {
  return;
 }
 $69 = (($0) + ($68))|0;
 $k$21 = 0;$t1$22 = $ido;$t2$23 = $69;$t3$14 = $68;
 while(1) {
  $70 = (($cc) + ($t2$23<<2)|0);
  $71 = +HEAPF32[$70>>2];
  $72 = -$71;
  $73 = (($ch) + ($t1$22<<2)|0);
  HEAPF32[$73>>2] = $72;
  $74 = (($cc) + ($t3$14<<2)|0);
  $75 = HEAP32[$74>>2]|0;
  $76 = (($t1$22) + -1)|0;
  $77 = (($ch) + ($76<<2)|0);
  HEAP32[$77>>2] = $75;
  $78 = (($t1$22) + ($1))|0;
  $79 = (($t2$23) + ($ido))|0;
  $80 = (($t3$14) + ($ido))|0;
  $81 = (($k$21) + 1)|0;
  $exitcond = ($81|0)==($l1|0);
  if ($exitcond) {
   break;
  } else {
   $k$21 = $81;$t1$22 = $78;$t2$23 = $79;$t3$14 = $80;
  }
 }
 return;
}
function _dradfg($ido,$ip,$l1,$idl1,$cc,$c1,$c2,$ch,$ch2,$wa) {
 $ido = $ido|0;
 $ip = $ip|0;
 $l1 = $l1|0;
 $idl1 = $idl1|0;
 $cc = $cc|0;
 $c1 = $c1|0;
 $c2 = $c2|0;
 $ch = $ch|0;
 $ch2 = $ch2|0;
 $wa = $wa|0;
 var $$not = 0, $$not241 = 0, $0 = 0.0, $1 = 0.0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0.0, $113 = 0;
 var $114 = 0, $115 = 0.0, $116 = 0.0, $117 = 0, $118 = 0, $119 = 0.0, $12 = 0, $120 = 0, $121 = 0.0, $122 = 0.0, $123 = 0, $124 = 0.0, $125 = 0.0, $126 = 0.0, $127 = 0, $128 = 0.0, $129 = 0.0, $13 = 0, $130 = 0.0, $131 = 0;
 var $132 = 0, $133 = 0, $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0.0, $143 = 0, $144 = 0, $145 = 0.0, $146 = 0.0, $147 = 0, $148 = 0, $149 = 0.0, $15 = 0;
 var $150 = 0, $151 = 0.0, $152 = 0.0, $153 = 0, $154 = 0.0, $155 = 0.0, $156 = 0.0, $157 = 0, $158 = 0.0, $159 = 0.0, $16 = 0, $160 = 0.0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0;
 var $169 = 0, $17 = 0, $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0.0, $183 = 0, $184 = 0.0, $185 = 0.0, $186 = 0;
 var $187 = 0.0, $188 = 0.0, $189 = 0.0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0.0, $199 = 0.0, $2 = 0, $20 = 0, $200 = 0.0, $201 = 0.0, $202 = 0.0, $203 = 0.0;
 var $204 = 0, $205 = 0.0, $206 = 0, $207 = 0, $208 = 0.0, $209 = 0.0, $21 = 0, $210 = 0.0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0.0, $216 = 0.0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0;
 var $222 = 0.0, $223 = 0.0, $224 = 0.0, $225 = 0.0, $226 = 0.0, $227 = 0.0, $228 = 0, $229 = 0, $23 = 0, $230 = 0.0, $231 = 0.0, $232 = 0, $233 = 0, $234 = 0.0, $235 = 0.0, $236 = 0, $237 = 0, $238 = 0.0, $239 = 0.0, $24 = 0;
 var $240 = 0, $241 = 0, $242 = 0.0, $243 = 0.0, $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0.0, $251 = 0, $252 = 0.0, $253 = 0.0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0;
 var $259 = 0, $26 = 0, $260 = 0, $261 = 0, $262 = 0, $263 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0, $27 = 0, $270 = 0, $271 = 0, $272 = 0, $273 = 0, $274 = 0, $275 = 0, $276 = 0;
 var $277 = 0, $278 = 0, $279 = 0, $28 = 0, $280 = 0, $281 = 0, $282 = 0, $283 = 0, $284 = 0, $285 = 0, $286 = 0, $287 = 0, $288 = 0, $289 = 0, $29 = 0, $290 = 0, $291 = 0, $292 = 0, $293 = 0, $294 = 0;
 var $295 = 0, $296 = 0, $297 = 0, $298 = 0, $299 = 0, $3 = 0, $30 = 0, $300 = 0, $301 = 0, $302 = 0, $303 = 0, $304 = 0, $305 = 0, $306 = 0, $307 = 0, $308 = 0, $309 = 0, $31 = 0, $310 = 0, $311 = 0;
 var $312 = 0.0, $313 = 0, $314 = 0, $315 = 0, $316 = 0.0, $317 = 0.0, $318 = 0, $319 = 0, $32 = 0, $320 = 0, $321 = 0.0, $322 = 0.0, $323 = 0.0, $324 = 0, $325 = 0, $326 = 0, $327 = 0, $328 = 0.0, $329 = 0, $33 = 0;
 var $330 = 0.0, $331 = 0.0, $332 = 0, $333 = 0.0, $334 = 0.0, $335 = 0.0, $336 = 0, $337 = 0, $338 = 0, $339 = 0, $34 = 0, $340 = 0, $341 = 0, $342 = 0, $343 = 0, $344 = 0, $345 = 0, $346 = 0, $347 = 0, $348 = 0;
 var $349 = 0.0, $35 = 0, $350 = 0, $351 = 0, $352 = 0.0, $353 = 0.0, $354 = 0, $355 = 0, $356 = 0.0, $357 = 0.0, $358 = 0.0, $359 = 0, $36 = 0, $360 = 0, $361 = 0, $362 = 0.0, $363 = 0, $364 = 0.0, $365 = 0.0, $366 = 0;
 var $367 = 0.0, $368 = 0.0, $369 = 0.0, $37 = 0, $370 = 0, $371 = 0, $372 = 0, $373 = 0, $374 = 0, $375 = 0, $376 = 0, $377 = 0, $378 = 0, $379 = 0, $38 = 0, $380 = 0, $39 = 0.0, $4 = 0, $40 = 0, $41 = 0;
 var $42 = 0.0, $43 = 0.0, $44 = 0, $45 = 0.0, $46 = 0, $47 = 0.0, $48 = 0.0, $49 = 0.0, $5 = 0, $50 = 0, $51 = 0.0, $52 = 0.0, $53 = 0.0, $54 = 0.0, $55 = 0.0, $56 = 0.0, $57 = 0.0, $58 = 0, $59 = 0, $6 = 0;
 var $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0.0, $72 = 0, $73 = 0, $74 = 0.0, $75 = 0.0, $76 = 0.0, $77 = 0, $78 = 0.0;
 var $79 = 0.0, $8 = 0, $80 = 0.0, $81 = 0, $82 = 0.0, $83 = 0.0, $84 = 0.0, $85 = 0.0, $86 = 0.0, $87 = 0.0, $88 = 0.0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0;
 var $97 = 0, $98 = 0, $99 = 0, $ai1$0112 = 0.0, $ai2$0107 = 0.0, $ar1$0113 = 0.0, $ar2$0108 = 0.0, $brmerge = 0, $cosf = 0.0, $exitcond = 0, $exitcond204 = 0, $exitcond206 = 0, $exitcond207 = 0, $exitcond208 = 0, $exitcond209 = 0, $exitcond210 = 0, $exitcond211 = 0, $exitcond212 = 0, $exitcond214 = 0, $exitcond215 = 0;
 var $exitcond216 = 0, $exitcond217 = 0, $exitcond218 = 0, $exitcond219 = 0, $exitcond220 = 0, $exitcond221 = 0, $exitcond222 = 0, $exitcond223 = 0, $exitcond225 = 0, $exitcond226 = 0, $exitcond227 = 0, $exitcond228 = 0, $exitcond229 = 0, $exitcond230 = 0, $exitcond231 = 0, $exitcond232 = 0, $exitcond233 = 0, $exitcond234 = 0, $exitcond235 = 0, $i$0164 = 0;
 var $i$1184 = 0, $i$2142 = 0, $i$3152 = 0, $i$475 = 0, $i$572 = 0, $i$638$us = 0, $i$728$us = 0, $idij$0165 = 0, $idij$1185 = 0, $ik$0202 = 0, $ik$1131 = 0, $ik$294 = 0, $ik$3101 = 0, $ik$482 = 0, $is$0175 = 0, $is$1190 = 0, $j$0199 = 0, $j$1036 = 0, $j$1176 = 0, $j$2191 = 0;
 var $j$3148 = 0, $j$4161 = 0, $j$5127 = 0, $j$6109 = 0, $j$787 = 0, $j$863 = 0, $j$951 = 0, $k$0194 = 0, $k$1027$us = 0, $k$1170 = 0, $k$2179 = 0, $k$3136 = 0, $k$4157 = 0, $k$5121 = 0, $k$680 = 0, $k$769 = 0, $k$856 = 0, $k$945$us = 0, $l$0116 = 0, $sinf = 0.0;
 var $t1$0198 = 0, $t1$1062 = 0, $t1$1150 = 0, $t1$1174 = 0, $t1$1235 = 0, $t1$2189 = 0, $t1$3147 = 0, $t1$4160 = 0, $t1$5126 = 0, $t1$6115 = 0, $t1$786 = 0, $t1$879 = 0, $t1$968 = 0, $t2$0193 = 0, $t2$1169 = 0, $t2$2183 = 0, $t2$3146 = 0, $t2$4159 = 0, $t2$5125 = 0, $t2$6114 = 0;
 var $t2$781 = 0, $t2$878 = 0, $t2$967 = 0, $t3$0163 = 0, $t3$1178 = 0, $t3$2141 = 0, $t3$3156 = 0, $t3$4120 = 0, $t3$574 = 0, $t3$661 = 0, $t3$749 = 0, $t3$834 = 0, $t4$0140 = 0, $t4$1155 = 0, $t4$2119 = 0, $t4$393 = 0, $t4$4106 = 0, $t4$573 = 0, $t4$660 = 0, $t4$748 = 0;
 var $t4$833 = 0, $t5$0134 = 0, $t5$1150 = 0, $t5$290 = 0, $t5$3105 = 0, $t5$453 = 0, $t5$547 = 0, $t5$632 = 0, $t6$0135 = 0, $t6$1151 = 0, $t6$291 = 0, $t6$397 = 0, $t6$454 = 0, $t6$541$us = 0, $t6$623$us = 0, $t7$092 = 0, $t7$198 = 0, $t7$255 = 0, $t7$342$us = 0, $t7$424$us = 0;
 var $t8$099 = 0, $t8$143$us = 0, $t8$225$us = 0, $t9$0100 = 0, $t9$144$us = 0, $t9$226$us = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = (+($ip|0));
 $1 = 6.2831854820251465 / $0;
 $cosf = (+Math_cos((+$1)));
 $sinf = (+Math_sin((+$1)));
 $2 = (($ip) + 1)|0;
 $3 = $2 >> 1;
 $4 = (($ido) + -1)|0;
 $5 = $4 >> 1;
 $6 = Math_imul($l1, $ido)|0;
 $7 = Math_imul($ip, $ido)|0;
 $8 = ($ido|0)==(1);
 L1: do {
  if (!($8)) {
   $9 = ($idl1|0)>(0);
   if ($9) {
    $ik$0202 = 0;
    while(1) {
     $13 = (($c2) + ($ik$0202<<2)|0);
     $14 = HEAP32[$13>>2]|0;
     $15 = (($ch2) + ($ik$0202<<2)|0);
     HEAP32[$15>>2] = $14;
     $16 = (($ik$0202) + 1)|0;
     $exitcond235 = ($16|0)==($idl1|0);
     if ($exitcond235) {
      break;
     } else {
      $ik$0202 = $16;
     }
    }
   }
   $11 = ($ip|0)>(1);
   if ($11) {
    $12 = ($l1|0)>(0);
    $j$0199 = 1;$t1$0198 = 0;
    while(1) {
     $17 = (($t1$0198) + ($6))|0;
     if ($12) {
      $k$0194 = 0;$t2$0193 = $17;
      while(1) {
       $18 = (($c1) + ($t2$0193<<2)|0);
       $19 = HEAP32[$18>>2]|0;
       $20 = (($ch) + ($t2$0193<<2)|0);
       HEAP32[$20>>2] = $19;
       $21 = (($t2$0193) + ($ido))|0;
       $22 = (($k$0194) + 1)|0;
       $exitcond233 = ($22|0)==($l1|0);
       if ($exitcond233) {
        break;
       } else {
        $k$0194 = $22;$t2$0193 = $21;
       }
      }
     }
     $23 = (($j$0199) + 1)|0;
     $exitcond234 = ($23|0)==($ip|0);
     if ($exitcond234) {
      break;
     } else {
      $j$0199 = $23;$t1$0198 = $17;
     }
    }
   }
   $24 = (0 - ($ido))|0;
   $25 = ($5|0)>($l1|0);
   if ($25) {
    if ($11) {
     $28 = ($l1|0)>(0);
     $29 = ($ido|0)>(2);
     $is$0175 = $24;$j$1176 = 1;$t1$1174 = 0;
     while(1) {
      $30 = (($t1$1174) + ($6))|0;
      $31 = (($is$0175) + ($ido))|0;
      if ($28) {
       $32 = (($30) - ($ido))|0;
       $33 = (($31) + -1)|0;
       $k$1170 = 0;$t2$1169 = $32;
       while(1) {
        $34 = (($t2$1169) + ($ido))|0;
        if ($29) {
         $i$0164 = 2;$idij$0165 = $33;$t3$0163 = $34;
         while(1) {
          $35 = (($idij$0165) + 2)|0;
          $36 = (($t3$0163) + 2)|0;
          $37 = (($idij$0165) + 1)|0;
          $38 = (($wa) + ($37<<2)|0);
          $39 = +HEAPF32[$38>>2];
          $40 = (($t3$0163) + 1)|0;
          $41 = (($c1) + ($40<<2)|0);
          $42 = +HEAPF32[$41>>2];
          $43 = $42 * $39;
          $44 = (($wa) + ($35<<2)|0);
          $45 = +HEAPF32[$44>>2];
          $46 = (($c1) + ($36<<2)|0);
          $47 = +HEAPF32[$46>>2];
          $48 = $47 * $45;
          $49 = $48 + $43;
          $50 = (($ch) + ($40<<2)|0);
          HEAPF32[$50>>2] = $49;
          $51 = +HEAPF32[$38>>2];
          $52 = +HEAPF32[$46>>2];
          $53 = $52 * $51;
          $54 = +HEAPF32[$44>>2];
          $55 = +HEAPF32[$41>>2];
          $56 = $55 * $54;
          $57 = $53 - $56;
          $58 = (($ch) + ($36<<2)|0);
          HEAPF32[$58>>2] = $57;
          $59 = (($i$0164) + 2)|0;
          $60 = ($59|0)<($ido|0);
          if ($60) {
           $i$0164 = $59;$idij$0165 = $35;$t3$0163 = $36;
          } else {
           break;
          }
         }
        }
        $61 = (($k$1170) + 1)|0;
        $exitcond229 = ($61|0)==($l1|0);
        if ($exitcond229) {
         break;
        } else {
         $k$1170 = $61;$t2$1169 = $34;
        }
       }
      }
      $62 = (($j$1176) + 1)|0;
      $exitcond230 = ($62|0)==($ip|0);
      if ($exitcond230) {
       break;
      } else {
       $is$0175 = $31;$j$1176 = $62;$t1$1174 = $30;
      }
     }
    }
   } else {
    if ($11) {
     $26 = ($ido|0)>(2);
     $27 = ($l1|0)>(0);
     $is$1190 = $24;$j$2191 = 1;$t1$2189 = 0;
     while(1) {
      $63 = (($is$1190) + ($ido))|0;
      $64 = (($t1$2189) + ($6))|0;
      if ($26) {
       $65 = (($63) + -1)|0;
       $i$1184 = 2;$idij$1185 = $65;$t2$2183 = $64;
       while(1) {
        $66 = (($idij$1185) + 2)|0;
        $67 = (($t2$2183) + 2)|0;
        if ($27) {
         $68 = (($idij$1185) + 1)|0;
         $69 = (($wa) + ($68<<2)|0);
         $70 = (($wa) + ($66<<2)|0);
         $k$2179 = 0;$t3$1178 = $67;
         while(1) {
          $71 = +HEAPF32[$69>>2];
          $72 = (($t3$1178) + -1)|0;
          $73 = (($c1) + ($72<<2)|0);
          $74 = +HEAPF32[$73>>2];
          $75 = $74 * $71;
          $76 = +HEAPF32[$70>>2];
          $77 = (($c1) + ($t3$1178<<2)|0);
          $78 = +HEAPF32[$77>>2];
          $79 = $78 * $76;
          $80 = $79 + $75;
          $81 = (($ch) + ($72<<2)|0);
          HEAPF32[$81>>2] = $80;
          $82 = +HEAPF32[$69>>2];
          $83 = +HEAPF32[$77>>2];
          $84 = $83 * $82;
          $85 = +HEAPF32[$70>>2];
          $86 = +HEAPF32[$73>>2];
          $87 = $86 * $85;
          $88 = $84 - $87;
          $89 = (($ch) + ($t3$1178<<2)|0);
          HEAPF32[$89>>2] = $88;
          $90 = (($t3$1178) + ($ido))|0;
          $91 = (($k$2179) + 1)|0;
          $exitcond231 = ($91|0)==($l1|0);
          if ($exitcond231) {
           break;
          } else {
           $k$2179 = $91;$t3$1178 = $90;
          }
         }
        }
        $92 = (($i$1184) + 2)|0;
        $93 = ($92|0)<($ido|0);
        if ($93) {
         $i$1184 = $92;$idij$1185 = $66;$t2$2183 = $67;
        } else {
         break;
        }
       }
      }
      $94 = (($j$2191) + 1)|0;
      $exitcond232 = ($94|0)==($ip|0);
      if ($exitcond232) {
       break;
      } else {
       $is$1190 = $63;$j$2191 = $94;$t1$2189 = $64;
      }
     }
    }
   }
   $95 = Math_imul($6, $ip)|0;
   $96 = ($5|0)<($l1|0);
   $97 = ($3|0)>(1);
   if (!($96)) {
    if (!($97)) {
     break;
    }
    $98 = ($l1|0)>(0);
    $99 = ($ido|0)>(2);
    $j$4161 = 1;$t1$4160 = 0;$t2$4159 = $95;
    while(1) {
     $136 = (($t1$4160) + ($6))|0;
     $137 = (($t2$4159) - ($6))|0;
     if ($98) {
      $k$4157 = 0;$t3$3156 = $136;$t4$1155 = $137;
      while(1) {
       if ($99) {
        $i$3152 = 2;$t5$1150 = $t3$3156;$t6$1151 = $t4$1155;
        while(1) {
         $138 = (($t5$1150) + 2)|0;
         $139 = (($t6$1151) + 2)|0;
         $140 = (($t5$1150) + 1)|0;
         $141 = (($ch) + ($140<<2)|0);
         $142 = +HEAPF32[$141>>2];
         $143 = (($t6$1151) + 1)|0;
         $144 = (($ch) + ($143<<2)|0);
         $145 = +HEAPF32[$144>>2];
         $146 = $145 + $142;
         $147 = (($c1) + ($140<<2)|0);
         HEAPF32[$147>>2] = $146;
         $148 = (($ch) + ($138<<2)|0);
         $149 = +HEAPF32[$148>>2];
         $150 = (($ch) + ($139<<2)|0);
         $151 = +HEAPF32[$150>>2];
         $152 = $149 - $151;
         $153 = (($c1) + ($143<<2)|0);
         HEAPF32[$153>>2] = $152;
         $154 = +HEAPF32[$148>>2];
         $155 = +HEAPF32[$150>>2];
         $156 = $155 + $154;
         $157 = (($c1) + ($138<<2)|0);
         HEAPF32[$157>>2] = $156;
         $158 = +HEAPF32[$144>>2];
         $159 = +HEAPF32[$141>>2];
         $160 = $158 - $159;
         $161 = (($c1) + ($139<<2)|0);
         HEAPF32[$161>>2] = $160;
         $162 = (($i$3152) + 2)|0;
         $163 = ($162|0)<($ido|0);
         if ($163) {
          $i$3152 = $162;$t5$1150 = $138;$t6$1151 = $139;
         } else {
          break;
         }
        }
       }
       $164 = (($t3$3156) + ($ido))|0;
       $165 = (($t4$1155) + ($ido))|0;
       $166 = (($k$4157) + 1)|0;
       $exitcond227 = ($166|0)==($l1|0);
       if ($exitcond227) {
        break;
       } else {
        $k$4157 = $166;$t3$3156 = $164;$t4$1155 = $165;
       }
      }
     }
     $167 = (($j$4161) + 1)|0;
     $exitcond228 = ($167|0)==($3|0);
     if ($exitcond228) {
      break L1;
     } else {
      $j$4161 = $167;$t1$4160 = $136;$t2$4159 = $137;
     }
    }
   }
   if ($97) {
    $100 = ($ido|0)>(2);
    $101 = ($l1|0)>(0);
    $j$3148 = 1;$t1$3147 = 0;$t2$3146 = $95;
    while(1) {
     $102 = (($t1$3147) + ($6))|0;
     $103 = (($t2$3146) - ($6))|0;
     if ($100) {
      $i$2142 = 2;$t3$2141 = $102;$t4$0140 = $103;
      while(1) {
       $104 = (($t3$2141) + 2)|0;
       $105 = (($t4$0140) + 2)|0;
       if ($101) {
        $106 = (($105) - ($ido))|0;
        $107 = (($104) - ($ido))|0;
        $k$3136 = 0;$t5$0134 = $107;$t6$0135 = $106;
        while(1) {
         $108 = (($t5$0134) + ($ido))|0;
         $109 = (($t6$0135) + ($ido))|0;
         $110 = (($108) + -1)|0;
         $111 = (($ch) + ($110<<2)|0);
         $112 = +HEAPF32[$111>>2];
         $113 = (($109) + -1)|0;
         $114 = (($ch) + ($113<<2)|0);
         $115 = +HEAPF32[$114>>2];
         $116 = $115 + $112;
         $117 = (($c1) + ($110<<2)|0);
         HEAPF32[$117>>2] = $116;
         $118 = (($ch) + ($108<<2)|0);
         $119 = +HEAPF32[$118>>2];
         $120 = (($ch) + ($109<<2)|0);
         $121 = +HEAPF32[$120>>2];
         $122 = $119 - $121;
         $123 = (($c1) + ($113<<2)|0);
         HEAPF32[$123>>2] = $122;
         $124 = +HEAPF32[$118>>2];
         $125 = +HEAPF32[$120>>2];
         $126 = $125 + $124;
         $127 = (($c1) + ($108<<2)|0);
         HEAPF32[$127>>2] = $126;
         $128 = +HEAPF32[$114>>2];
         $129 = +HEAPF32[$111>>2];
         $130 = $128 - $129;
         $131 = (($c1) + ($109<<2)|0);
         HEAPF32[$131>>2] = $130;
         $132 = (($k$3136) + 1)|0;
         $exitcond225 = ($132|0)==($l1|0);
         if ($exitcond225) {
          break;
         } else {
          $k$3136 = $132;$t5$0134 = $108;$t6$0135 = $109;
         }
        }
       }
       $133 = (($i$2142) + 2)|0;
       $134 = ($133|0)<($ido|0);
       if ($134) {
        $i$2142 = $133;$t3$2141 = $104;$t4$0140 = $105;
       } else {
        break;
       }
      }
     }
     $135 = (($j$3148) + 1)|0;
     $exitcond226 = ($135|0)==($3|0);
     if ($exitcond226) {
      break;
     } else {
      $j$3148 = $135;$t1$3147 = $102;$t2$3146 = $103;
     }
    }
   }
  }
 } while(0);
 $10 = ($idl1|0)>(0);
 if ($10) {
  $ik$1131 = 0;
  while(1) {
   $168 = (($ch2) + ($ik$1131<<2)|0);
   $169 = HEAP32[$168>>2]|0;
   $170 = (($c2) + ($ik$1131<<2)|0);
   HEAP32[$170>>2] = $169;
   $171 = (($ik$1131) + 1)|0;
   $exitcond223 = ($171|0)==($idl1|0);
   if ($exitcond223) {
    break;
   } else {
    $ik$1131 = $171;
   }
  }
 }
 $172 = Math_imul($idl1, $ip)|0;
 $173 = ($3|0)>(1);
 if ($173) {
  $174 = ($l1|0)>(0);
  $j$5127 = 1;$t1$5126 = 0;$t2$5125 = $172;
  while(1) {
   $175 = (($t1$5126) + ($6))|0;
   $176 = (($t2$5125) - ($6))|0;
   if ($174) {
    $177 = (($176) - ($ido))|0;
    $178 = (($175) - ($ido))|0;
    $k$5121 = 0;$t3$4120 = $178;$t4$2119 = $177;
    while(1) {
     $179 = (($t3$4120) + ($ido))|0;
     $180 = (($t4$2119) + ($ido))|0;
     $181 = (($ch) + ($179<<2)|0);
     $182 = +HEAPF32[$181>>2];
     $183 = (($ch) + ($180<<2)|0);
     $184 = +HEAPF32[$183>>2];
     $185 = $184 + $182;
     $186 = (($c1) + ($179<<2)|0);
     HEAPF32[$186>>2] = $185;
     $187 = +HEAPF32[$183>>2];
     $188 = +HEAPF32[$181>>2];
     $189 = $187 - $188;
     $190 = (($c1) + ($180<<2)|0);
     HEAPF32[$190>>2] = $189;
     $191 = (($k$5121) + 1)|0;
     $exitcond221 = ($191|0)==($l1|0);
     if ($exitcond221) {
      break;
     } else {
      $k$5121 = $191;$t3$4120 = $179;$t4$2119 = $180;
     }
    }
   }
   $192 = (($j$5127) + 1)|0;
   $exitcond222 = ($192|0)==($3|0);
   if ($exitcond222) {
    break;
   } else {
    $j$5127 = $192;$t1$5126 = $175;$t2$5125 = $176;
   }
  }
  $193 = (($ip) + -1)|0;
  $194 = Math_imul($193, $idl1)|0;
  if ($173) {
   $195 = ($3|0)>(2);
   $ai1$0112 = 0.0;$ar1$0113 = 1.0;$l$0116 = 1;$t1$6115 = 0;$t2$6114 = $172;
   while(1) {
    $196 = (($t1$6115) + ($idl1))|0;
    $197 = (($t2$6114) - ($idl1))|0;
    $198 = $ar1$0113 * $cosf;
    $199 = $ai1$0112 * $sinf;
    $200 = $198 - $199;
    $201 = $ai1$0112 * $cosf;
    $202 = $ar1$0113 * $sinf;
    $203 = $202 + $201;
    if ($10) {
     $ik$294 = 0;$t4$393 = $196;$t5$290 = $197;$t6$291 = $194;$t7$092 = $idl1;
     while(1) {
      $204 = (($c2) + ($ik$294<<2)|0);
      $205 = +HEAPF32[$204>>2];
      $206 = (($t7$092) + 1)|0;
      $207 = (($c2) + ($t7$092<<2)|0);
      $208 = +HEAPF32[$207>>2];
      $209 = $208 * $200;
      $210 = $209 + $205;
      $211 = (($t4$393) + 1)|0;
      $212 = (($ch2) + ($t4$393<<2)|0);
      HEAPF32[$212>>2] = $210;
      $213 = (($t6$291) + 1)|0;
      $214 = (($c2) + ($t6$291<<2)|0);
      $215 = +HEAPF32[$214>>2];
      $216 = $215 * $203;
      $217 = (($t5$290) + 1)|0;
      $218 = (($ch2) + ($t5$290<<2)|0);
      HEAPF32[$218>>2] = $216;
      $219 = (($ik$294) + 1)|0;
      $exitcond217 = ($219|0)==($idl1|0);
      if ($exitcond217) {
       break;
      } else {
       $ik$294 = $219;$t4$393 = $211;$t5$290 = $217;$t6$291 = $213;$t7$092 = $206;
      }
     }
    }
    if ($195) {
     $ai2$0107 = $203;$ar2$0108 = $200;$j$6109 = 2;$t4$4106 = $idl1;$t5$3105 = $194;
     while(1) {
      $220 = (($t4$4106) + ($idl1))|0;
      $221 = (($t5$3105) - ($idl1))|0;
      $222 = $ar2$0108 * $200;
      $223 = $ai2$0107 * $203;
      $224 = $222 - $223;
      $225 = $ai2$0107 * $200;
      $226 = $ar2$0108 * $203;
      $227 = $226 + $225;
      if ($10) {
       $ik$3101 = 0;$t6$397 = $196;$t7$198 = $197;$t8$099 = $220;$t9$0100 = $221;
       while(1) {
        $228 = (($t8$099) + 1)|0;
        $229 = (($c2) + ($t8$099<<2)|0);
        $230 = +HEAPF32[$229>>2];
        $231 = $230 * $224;
        $232 = (($t6$397) + 1)|0;
        $233 = (($ch2) + ($t6$397<<2)|0);
        $234 = +HEAPF32[$233>>2];
        $235 = $234 + $231;
        HEAPF32[$233>>2] = $235;
        $236 = (($t9$0100) + 1)|0;
        $237 = (($c2) + ($t9$0100<<2)|0);
        $238 = +HEAPF32[$237>>2];
        $239 = $238 * $227;
        $240 = (($t7$198) + 1)|0;
        $241 = (($ch2) + ($t7$198<<2)|0);
        $242 = +HEAPF32[$241>>2];
        $243 = $242 + $239;
        HEAPF32[$241>>2] = $243;
        $244 = (($ik$3101) + 1)|0;
        $exitcond218 = ($244|0)==($idl1|0);
        if ($exitcond218) {
         break;
        } else {
         $ik$3101 = $244;$t6$397 = $232;$t7$198 = $240;$t8$099 = $228;$t9$0100 = $236;
        }
       }
      }
      $245 = (($j$6109) + 1)|0;
      $exitcond219 = ($245|0)==($3|0);
      if ($exitcond219) {
       break;
      } else {
       $ai2$0107 = $227;$ar2$0108 = $224;$j$6109 = $245;$t4$4106 = $220;$t5$3105 = $221;
      }
     }
    }
    $246 = (($l$0116) + 1)|0;
    $exitcond220 = ($246|0)==($3|0);
    if ($exitcond220) {
     break;
    } else {
     $ai1$0112 = $203;$ar1$0113 = $200;$l$0116 = $246;$t1$6115 = $196;$t2$6114 = $197;
    }
   }
   if ($173) {
    $j$787 = 1;$t1$786 = 0;
    while(1) {
     $247 = (($t1$786) + ($idl1))|0;
     if ($10) {
      $ik$482 = 0;$t2$781 = $247;
      while(1) {
       $248 = (($t2$781) + 1)|0;
       $249 = (($c2) + ($t2$781<<2)|0);
       $250 = +HEAPF32[$249>>2];
       $251 = (($ch2) + ($ik$482<<2)|0);
       $252 = +HEAPF32[$251>>2];
       $253 = $252 + $250;
       HEAPF32[$251>>2] = $253;
       $254 = (($ik$482) + 1)|0;
       $exitcond215 = ($254|0)==($idl1|0);
       if ($exitcond215) {
        break;
       } else {
        $ik$482 = $254;$t2$781 = $248;
       }
      }
     }
     $255 = (($j$787) + 1)|0;
     $exitcond216 = ($255|0)==($3|0);
     if ($exitcond216) {
      break;
     } else {
      $j$787 = $255;$t1$786 = $247;
     }
    }
   }
  }
 }
 $256 = ($ido|0)<($l1|0);
 if ($256) {
  $259 = ($ido|0)>(0);
  if ($259) {
   $260 = ($l1|0)>(0);
   $i$572 = 0;
   while(1) {
    if ($260) {
     $k$769 = 0;$t1$968 = $i$572;$t2$967 = $i$572;
     while(1) {
      $270 = (($ch) + ($t1$968<<2)|0);
      $271 = HEAP32[$270>>2]|0;
      $272 = (($cc) + ($t2$967<<2)|0);
      HEAP32[$272>>2] = $271;
      $273 = (($t1$968) + ($ido))|0;
      $274 = (($t2$967) + ($7))|0;
      $275 = (($k$769) + 1)|0;
      $exitcond210 = ($275|0)==($l1|0);
      if ($exitcond210) {
       break;
      } else {
       $k$769 = $275;$t1$968 = $273;$t2$967 = $274;
      }
     }
    }
    $276 = (($i$572) + 1)|0;
    $exitcond211 = ($276|0)==($ido|0);
    if ($exitcond211) {
     break;
    } else {
     $i$572 = $276;
    }
   }
  }
 } else {
  $257 = ($l1|0)>(0);
  if ($257) {
   $258 = ($ido|0)>(0);
   $k$680 = 0;$t1$879 = 0;$t2$878 = 0;
   while(1) {
    if ($258) {
     $i$475 = 0;$t3$574 = $t1$879;$t4$573 = $t2$878;
     while(1) {
      $261 = (($t3$574) + 1)|0;
      $262 = (($ch) + ($t3$574<<2)|0);
      $263 = HEAP32[$262>>2]|0;
      $264 = (($t4$573) + 1)|0;
      $265 = (($cc) + ($t4$573<<2)|0);
      HEAP32[$265>>2] = $263;
      $266 = (($i$475) + 1)|0;
      $exitcond212 = ($266|0)==($ido|0);
      if ($exitcond212) {
       break;
      } else {
       $i$475 = $266;$t3$574 = $261;$t4$573 = $264;
      }
     }
    }
    $267 = (($t1$879) + ($ido))|0;
    $268 = (($t2$878) + ($7))|0;
    $269 = (($k$680) + 1)|0;
    $exitcond214 = ($269|0)==($l1|0);
    if ($exitcond214) {
     break;
    } else {
     $k$680 = $269;$t1$879 = $267;$t2$878 = $268;
    }
   }
  }
 }
 $277 = $ido << 1;
 $278 = Math_imul($6, $ip)|0;
 if ($173) {
  $279 = ($l1|0)>(0);
  $j$863 = 1;$t1$1062 = 0;$t3$661 = 0;$t4$660 = $278;
  while(1) {
   $280 = (($t1$1062) + ($277))|0;
   $281 = (($t3$661) + ($6))|0;
   $282 = (($t4$660) - ($6))|0;
   if ($279) {
    $k$856 = 0;$t5$453 = $280;$t6$454 = $281;$t7$255 = $282;
    while(1) {
     $283 = (($ch) + ($t6$454<<2)|0);
     $284 = HEAP32[$283>>2]|0;
     $285 = (($t5$453) + -1)|0;
     $286 = (($cc) + ($285<<2)|0);
     HEAP32[$286>>2] = $284;
     $287 = (($ch) + ($t7$255<<2)|0);
     $288 = HEAP32[$287>>2]|0;
     $289 = (($cc) + ($t5$453<<2)|0);
     HEAP32[$289>>2] = $288;
     $290 = (($t5$453) + ($7))|0;
     $291 = (($t6$454) + ($ido))|0;
     $292 = (($t7$255) + ($ido))|0;
     $293 = (($k$856) + 1)|0;
     $exitcond208 = ($293|0)==($l1|0);
     if ($exitcond208) {
      break;
     } else {
      $k$856 = $293;$t5$453 = $290;$t6$454 = $291;$t7$255 = $292;
     }
    }
   }
   $294 = (($j$863) + 1)|0;
   $exitcond209 = ($294|0)==($3|0);
   if ($exitcond209) {
    break;
   } else {
    $j$863 = $294;$t1$1062 = $280;$t3$661 = $281;$t4$660 = $282;
   }
  }
 }
 if ($8) {
  return;
 }
 $295 = ($5|0)<($l1|0);
 $296 = (0 - ($ido))|0;
 if (!($295)) {
  if (!($173)) {
   return;
  }
  $$not = ($l1|0)<(1);
  $$not241 = ($ido|0)<(3);
  $brmerge = $$not | $$not241;
  $j$951 = 1;$t1$1150 = $296;$t3$749 = 0;$t4$748 = 0;$t5$547 = $278;
  while(1) {
   $299 = (($t1$1150) + ($277))|0;
   $300 = (($t3$749) + ($277))|0;
   $301 = (($t4$748) + ($6))|0;
   $302 = (($t5$547) - ($6))|0;
   if (!($brmerge)) {
    $k$945$us = 0;$t6$541$us = $299;$t7$342$us = $300;$t8$143$us = $301;$t9$144$us = $302;
    while(1) {
     $i$638$us = 2;
     while(1) {
      $308 = (($ido) - ($i$638$us))|0;
      $309 = (($i$638$us) + ($t8$143$us))|0;
      $310 = (($309) + -1)|0;
      $311 = (($ch) + ($310<<2)|0);
      $312 = +HEAPF32[$311>>2];
      $313 = (($i$638$us) + ($t9$144$us))|0;
      $314 = (($313) + -1)|0;
      $315 = (($ch) + ($314<<2)|0);
      $316 = +HEAPF32[$315>>2];
      $317 = $316 + $312;
      $318 = (($i$638$us) + ($t7$342$us))|0;
      $319 = (($318) + -1)|0;
      $320 = (($cc) + ($319<<2)|0);
      HEAPF32[$320>>2] = $317;
      $321 = +HEAPF32[$311>>2];
      $322 = +HEAPF32[$315>>2];
      $323 = $321 - $322;
      $324 = (($308) + ($t6$541$us))|0;
      $325 = (($324) + -1)|0;
      $326 = (($cc) + ($325<<2)|0);
      HEAPF32[$326>>2] = $323;
      $327 = (($ch) + ($309<<2)|0);
      $328 = +HEAPF32[$327>>2];
      $329 = (($ch) + ($313<<2)|0);
      $330 = +HEAPF32[$329>>2];
      $331 = $330 + $328;
      $332 = (($cc) + ($318<<2)|0);
      HEAPF32[$332>>2] = $331;
      $333 = +HEAPF32[$329>>2];
      $334 = +HEAPF32[$327>>2];
      $335 = $333 - $334;
      $336 = (($cc) + ($324<<2)|0);
      HEAPF32[$336>>2] = $335;
      $337 = (($i$638$us) + 2)|0;
      $338 = ($337|0)<($ido|0);
      if ($338) {
       $i$638$us = $337;
      } else {
       break;
      }
     }
     $303 = (($t6$541$us) + ($7))|0;
     $304 = (($t7$342$us) + ($7))|0;
     $305 = (($t8$143$us) + ($ido))|0;
     $306 = (($t9$144$us) + ($ido))|0;
     $307 = (($k$945$us) + 1)|0;
     $exitcond206 = ($307|0)==($l1|0);
     if ($exitcond206) {
      break;
     } else {
      $k$945$us = $307;$t6$541$us = $303;$t7$342$us = $304;$t8$143$us = $305;$t9$144$us = $306;
     }
    }
   }
   $339 = (($j$951) + 1)|0;
   $exitcond207 = ($339|0)==($3|0);
   if ($exitcond207) {
    break;
   } else {
    $j$951 = $339;$t1$1150 = $299;$t3$749 = $300;$t4$748 = $301;$t5$547 = $302;
   }
  }
  return;
 }
 if (!($173)) {
  return;
 }
 $297 = ($ido|0)>(2);
 $298 = ($l1|0)>(0);
 $j$1036 = 1;$t1$1235 = $296;$t3$834 = 0;$t4$833 = 0;$t5$632 = $278;
 while(1) {
  $340 = (($t1$1235) + ($277))|0;
  $341 = (($t3$834) + ($277))|0;
  $342 = (($t4$833) + ($6))|0;
  $343 = (($t5$632) - ($6))|0;
  if ($297) {
   $344 = (($340) + ($ido))|0;
   if ($298) {
    $i$728$us = 2;
    while(1) {
     $376 = (($i$728$us) + ($343))|0;
     $377 = (($i$728$us) + ($342))|0;
     $378 = (($i$728$us) + ($341))|0;
     $379 = (($344) - ($i$728$us))|0;
     $k$1027$us = 0;$t6$623$us = $379;$t7$424$us = $378;$t8$225$us = $377;$t9$226$us = $376;
     while(1) {
      $347 = (($t8$225$us) + -1)|0;
      $348 = (($ch) + ($347<<2)|0);
      $349 = +HEAPF32[$348>>2];
      $350 = (($t9$226$us) + -1)|0;
      $351 = (($ch) + ($350<<2)|0);
      $352 = +HEAPF32[$351>>2];
      $353 = $352 + $349;
      $354 = (($t7$424$us) + -1)|0;
      $355 = (($cc) + ($354<<2)|0);
      HEAPF32[$355>>2] = $353;
      $356 = +HEAPF32[$348>>2];
      $357 = +HEAPF32[$351>>2];
      $358 = $356 - $357;
      $359 = (($t6$623$us) + -1)|0;
      $360 = (($cc) + ($359<<2)|0);
      HEAPF32[$360>>2] = $358;
      $361 = (($ch) + ($t8$225$us<<2)|0);
      $362 = +HEAPF32[$361>>2];
      $363 = (($ch) + ($t9$226$us<<2)|0);
      $364 = +HEAPF32[$363>>2];
      $365 = $364 + $362;
      $366 = (($cc) + ($t7$424$us<<2)|0);
      HEAPF32[$366>>2] = $365;
      $367 = +HEAPF32[$363>>2];
      $368 = +HEAPF32[$361>>2];
      $369 = $367 - $368;
      $370 = (($cc) + ($t6$623$us<<2)|0);
      HEAPF32[$370>>2] = $369;
      $371 = (($t6$623$us) + ($7))|0;
      $372 = (($t7$424$us) + ($7))|0;
      $373 = (($t8$225$us) + ($ido))|0;
      $374 = (($t9$226$us) + ($ido))|0;
      $375 = (($k$1027$us) + 1)|0;
      $exitcond = ($375|0)==($l1|0);
      if ($exitcond) {
       break;
      } else {
       $k$1027$us = $375;$t6$623$us = $371;$t7$424$us = $372;$t8$225$us = $373;$t9$226$us = $374;
      }
     }
     $345 = (($i$728$us) + 2)|0;
     $346 = ($345|0)<($ido|0);
     if ($346) {
      $i$728$us = $345;
     } else {
      break;
     }
    }
   }
  }
  $380 = (($j$1036) + 1)|0;
  $exitcond204 = ($380|0)==($3|0);
  if ($exitcond204) {
   break;
  } else {
   $j$1036 = $380;$t1$1235 = $340;$t3$834 = $341;$t4$833 = $342;$t5$632 = $343;
  }
 }
 return;
}
function _vorbis_encode_setup_init($vi) {
 $vi = $vi|0;
 var $$ = 0, $$$i = 0, $$$i17 = 0.0, $$$i21 = 0.0, $$$i27 = 0.0, $$$i33 = 0.0, $$$i6 = 0.0, $$0 = 0, $$0$i = 0, $$0$i$i$i = 0, $$0$i14$1$i$i = 0, $$0$i14$2$i$i = 0, $$0$i14$3$i$i = 0, $$0$i14$i$i = 0, $$0$i4$1$i$i = 0, $$0$i4$2$i$i = 0, $$0$i4$3$i$i = 0, $$0$i4$i$i = 0, $$0$i9$i$i = 0, $$2$i = 0;
 var $$2$i18 = 0, $$2$i22 = 0, $$2$i28 = 0, $$2$i34 = 0, $$ch$2$i$i = 0, $$maxbook$0$i = 0, $$maxbook$2$i = 0, $$maxclass$0$i = 0, $$maxclass$0$i$lcssa = 0, $$pre = 0.0, $$pre$i = 0, $$pre$i$i = 0, $$pre$i8 = 0, $$pre$phi68$i$iZ2D = 0, $$pre11$i = 0, $$pre21$i = 0, $$pre63$i$i = 0, $$pre64$i$i = 0, $$pre65$i$i = 0, $$pre66$i$i = 0;
 var $$pre67 = 0, $$pre67$i$i = 0, $$pre68 = 0, $$sink = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $1000 = 0, $1001 = 0, $1002 = 0, $1003 = 0, $1004 = 0, $1005 = 0, $1006 = 0, $1007 = 0, $1008 = 0, $1009 = 0, $101 = 0, $1010 = 0;
 var $1011 = 0, $1012 = 0, $1013 = 0, $1014 = 0, $1015 = 0, $1016 = 0, $1017 = 0, $1018 = 0, $1019 = 0, $102 = 0, $1020 = 0, $1021 = 0, $1022 = 0, $1023 = 0, $1024 = 0, $1025 = 0, $1026 = 0, $1027 = 0.0, $1028 = 0.0, $1029 = 0.0;
 var $103 = 0, $1030 = 0.0, $1031 = 0, $1032 = 0.0, $1033 = 0.0, $1034 = 0.0, $1035 = 0, $1036 = 0, $1037 = 0, $1038 = 0, $1039 = 0, $104 = 0, $1040 = 0, $1041 = 0, $1042 = 0.0, $1043 = 0.0, $1044 = 0, $1045 = 0.0, $1046 = 0.0, $1047 = 0.0;
 var $1048 = 0, $1049 = 0, $105 = 0, $1050 = 0, $1051 = 0, $1052 = 0, $1053 = 0, $1054 = 0, $1055 = 0, $1056 = 0, $1057 = 0, $1058 = 0, $1059 = 0, $106 = 0.0, $1060 = 0, $1061 = 0, $1062 = 0, $1063 = 0, $1064 = 0, $1065 = 0;
 var $1066 = 0, $1067 = 0, $1068 = 0, $1069 = 0, $107 = 0, $1070 = 0, $1071 = 0, $1072 = 0, $1073 = 0, $1074 = 0, $1075 = 0, $1076 = 0, $1077 = 0, $1078 = 0, $1079 = 0, $108 = 0, $1080 = 0, $1081 = 0, $1082 = 0, $1083 = 0;
 var $1084 = 0, $1085 = 0, $1086 = 0, $1087 = 0, $1088 = 0, $1089 = 0, $109 = 0, $1090 = 0, $1091 = 0, $1092 = 0, $1093 = 0, $1094 = 0, $1095 = 0, $1096 = 0, $1097 = 0, $1098 = 0, $1099 = 0, $11 = 0.0, $110 = 0, $1100 = 0;
 var $1101 = 0, $1102 = 0, $1103 = 0, $1104 = 0, $1105 = 0, $1106 = 0, $1107 = 0, $1108 = 0, $1109 = 0, $111 = 0, $1110 = 0, $1111 = 0, $1112 = 0, $1113 = 0, $1114 = 0, $1115 = 0, $1116 = 0, $1117 = 0, $1118 = 0, $1119 = 0;
 var $112 = 0.0, $1120 = 0, $1121 = 0, $1122 = 0, $1123 = 0, $1124 = 0, $1125 = 0, $1126 = 0, $1127 = 0, $1128 = 0, $1129 = 0, $113 = 0.0, $1130 = 0, $1131 = 0, $1132 = 0, $1133 = 0, $1134 = 0, $1135 = 0, $1136 = 0, $1137 = 0;
 var $1138 = 0, $1139 = 0, $114 = 0, $1140 = 0, $1141 = 0, $1142 = 0, $1143 = 0, $1144 = 0, $1145 = 0, $1146 = 0, $1147 = 0, $1148 = 0, $1149 = 0, $115 = 0, $1150 = 0, $1151 = 0, $1152 = 0, $1153 = 0, $1154 = 0, $1155 = 0;
 var $1156 = 0, $1157 = 0, $1158 = 0, $1159 = 0, $116 = 0, $1160 = 0, $1161 = 0, $1162 = 0, $1163 = 0, $1164 = 0, $1165 = 0, $1166 = 0, $1167 = 0, $1168 = 0, $1169 = 0, $117 = 0.0, $1170 = 0, $1171 = 0, $1172 = 0, $1173 = 0;
 var $1174 = 0, $1175 = 0, $1176 = 0, $1177 = 0, $1178 = 0, $1179 = 0, $118 = 0, $1180 = 0, $1181 = 0, $1182 = 0, $1183 = 0, $1184 = 0, $1185 = 0, $1186 = 0, $1187 = 0, $1188 = 0, $1189 = 0, $119 = 0, $1190 = 0, $1191 = 0;
 var $1192 = 0.0, $1193 = 0, $1194 = 0.0, $1195 = 0.0, $1196 = 0, $1197 = 0, $1198 = 0, $1199 = 0, $12 = 0, $120 = 0.0, $1200 = 0, $1201 = 0.0, $1202 = 0.0, $1203 = 0.0, $1204 = 0, $1205 = 0, $1206 = 0.0, $1207 = 0.0, $1208 = 0.0, $1209 = 0.0;
 var $121 = 0.0, $1210 = 0.0, $1211 = 0, $1212 = 0, $1213 = 0, $1214 = 0, $1215 = 0, $1216 = 0, $1217 = 0, $1218 = 0, $1219 = 0, $122 = 0.0, $1220 = 0, $1221 = 0.0, $1222 = 0.0, $1223 = 0.0, $1224 = 0, $1225 = 0, $1226 = 0, $1227 = 0;
 var $1228 = 0, $1229 = 0, $123 = 0, $1230 = 0, $1231 = 0, $1232 = 0, $1233 = 0, $1234 = 0, $1235 = 0, $1236 = 0, $1237 = 0, $1238 = 0, $1239 = 0.0, $124 = 0, $1240 = 0, $1241 = 0, $1242 = 0.0, $1243 = 0, $1244 = 0, $125 = 0.0;
 var $126 = 0.0, $127 = 0.0, $128 = 0, $129 = 0.0, $13 = 0, $130 = 0.0, $131 = 0, $132 = 0, $133 = 0, $134 = 0.0, $135 = 0, $136 = 0, $137 = 0.0, $138 = 0.0, $139 = 0.0, $14 = 0, $140 = 0, $141 = 0.0, $142 = 0.0, $143 = 0.0;
 var $144 = 0.0, $145 = 0.0, $146 = 0, $147 = 0, $148 = 0.0, $149 = 0.0, $15 = 0, $150 = 0.0, $151 = 0, $152 = 0.0, $153 = 0.0, $154 = 0.0, $155 = 0.0, $156 = 0.0, $157 = 0, $158 = 0, $159 = 0.0, $16 = 0, $160 = 0.0, $161 = 0.0;
 var $162 = 0, $163 = 0.0, $164 = 0.0, $165 = 0.0, $166 = 0.0, $167 = 0.0, $168 = 0, $169 = 0, $17 = 0, $170 = 0.0, $171 = 0.0, $172 = 0.0, $173 = 0, $174 = 0.0, $175 = 0.0, $176 = 0.0, $177 = 0.0, $178 = 0.0, $179 = 0, $18 = 0;
 var $180 = 0, $181 = 0.0, $182 = 0.0, $183 = 0.0, $184 = 0, $185 = 0.0, $186 = 0.0, $187 = 0.0, $188 = 0.0, $189 = 0.0, $19 = 0.0, $190 = 0, $191 = 0, $192 = 0.0, $193 = 0.0, $194 = 0.0, $195 = 0, $196 = 0.0, $197 = 0.0, $198 = 0.0;
 var $199 = 0.0, $2 = 0, $20 = 0, $200 = 0.0, $201 = 0, $202 = 0, $203 = 0.0, $204 = 0.0, $205 = 0.0, $206 = 0, $207 = 0.0, $208 = 0.0, $209 = 0.0, $21 = 0, $210 = 0.0, $211 = 0.0, $212 = 0, $213 = 0, $214 = 0.0, $215 = 0.0;
 var $216 = 0.0, $217 = 0, $218 = 0.0, $219 = 0.0, $22 = 0, $220 = 0.0, $221 = 0.0, $222 = 0.0, $223 = 0, $224 = 0, $225 = 0.0, $226 = 0.0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0.0, $232 = 0.0, $233 = 0;
 var $234 = 0.0, $235 = 0.0, $236 = 0.0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0, $242 = 0, $243 = 0, $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0;
 var $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0, $260 = 0, $261 = 0, $262 = 0, $263 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0, $27 = 0;
 var $270 = 0, $271 = 0, $272 = 0, $273 = 0, $274 = 0, $275 = 0, $276 = 0, $277 = 0, $278 = 0, $279 = 0.0, $28 = 0, $280 = 0, $281 = 0, $282 = 0, $283 = 0.0, $284 = 0, $285 = 0.0, $286 = 0.0, $287 = 0.0, $288 = 0;
 var $289 = 0.0, $29 = 0, $290 = 0.0, $291 = 0.0, $292 = 0.0, $293 = 0.0, $294 = 0.0, $295 = 0.0, $296 = 0.0, $297 = 0, $298 = 0.0, $299 = 0.0, $3 = 0, $30 = 0, $300 = 0, $301 = 0, $302 = 0, $303 = 0.0, $304 = 0.0, $305 = 0;
 var $306 = 0, $307 = 0, $308 = 0, $309 = 0, $31 = 0, $310 = 0.0, $311 = 0.0, $312 = 0.0, $313 = 0, $314 = 0.0, $315 = 0.0, $316 = 0.0, $317 = 0.0, $318 = 0.0, $319 = 0.0, $32 = 0, $320 = 0.0, $321 = 0.0, $322 = 0, $323 = 0.0;
 var $324 = 0.0, $325 = 0, $326 = 0, $327 = 0, $328 = 0.0, $329 = 0.0, $33 = 0, $330 = 0, $331 = 0, $332 = 0, $333 = 0, $334 = 0.0, $335 = 0.0, $336 = 0.0, $337 = 0.0, $338 = 0, $339 = 0, $34 = 0, $340 = 0.0, $341 = 0.0;
 var $342 = 0.0, $343 = 0.0, $344 = 0.0, $345 = 0.0, $346 = 0.0, $347 = 0, $348 = 0, $349 = 0, $35 = 0, $350 = 0.0, $351 = 0.0, $352 = 0, $353 = 0.0, $354 = 0.0, $355 = 0, $356 = 0, $357 = 0, $358 = 0.0, $359 = 0.0, $36 = 0;
 var $360 = 0, $361 = 0, $362 = 0, $363 = 0, $364 = 0, $365 = 0.0, $366 = 0.0, $367 = 0.0, $368 = 0, $369 = 0.0, $37 = 0, $370 = 0.0, $371 = 0.0, $372 = 0.0, $373 = 0.0, $374 = 0.0, $375 = 0.0, $376 = 0.0, $377 = 0, $378 = 0.0;
 var $379 = 0.0, $38 = 0.0, $380 = 0, $381 = 0, $382 = 0, $383 = 0.0, $384 = 0.0, $385 = 0, $386 = 0, $387 = 0, $388 = 0.0, $389 = 0, $39 = 0, $390 = 0, $391 = 0, $392 = 0, $393 = 0, $394 = 0, $395 = 0, $396 = 0;
 var $397 = 0, $398 = 0, $399 = 0, $4 = 0, $40 = 0, $400 = 0, $401 = 0, $402 = 0, $403 = 0, $404 = 0, $405 = 0, $406 = 0, $407 = 0, $408 = 0, $409 = 0, $41 = 0, $410 = 0, $411 = 0, $412 = 0, $413 = 0;
 var $414 = 0, $415 = 0.0, $416 = 0, $417 = 0.0, $418 = 0, $419 = 0, $42 = 0, $420 = 0, $421 = 0, $422 = 0, $423 = 0, $424 = 0, $425 = 0, $426 = 0, $427 = 0, $428 = 0, $429 = 0, $43 = 0, $430 = 0, $431 = 0;
 var $432 = 0, $433 = 0, $434 = 0, $435 = 0, $436 = 0, $437 = 0, $438 = 0, $439 = 0, $44 = 0, $440 = 0, $441 = 0.0, $442 = 0, $443 = 0.0, $444 = 0, $445 = 0, $446 = 0, $447 = 0, $448 = 0, $449 = 0, $45 = 0;
 var $450 = 0, $451 = 0, $452 = 0, $453 = 0, $454 = 0, $455 = 0, $456 = 0, $457 = 0, $458 = 0, $459 = 0, $46 = 0, $460 = 0, $461 = 0, $462 = 0, $463 = 0, $464 = 0, $465 = 0, $466 = 0, $467 = 0, $468 = 0;
 var $469 = 0.0, $47 = 0, $470 = 0, $471 = 0.0, $472 = 0, $473 = 0, $474 = 0, $475 = 0, $476 = 0, $477 = 0, $478 = 0, $479 = 0, $48 = 0, $480 = 0, $481 = 0, $482 = 0, $483 = 0, $484 = 0, $485 = 0, $486 = 0;
 var $487 = 0, $488 = 0, $489 = 0, $49 = 0, $490 = 0, $491 = 0, $492 = 0, $493 = 0, $494 = 0, $495 = 0.0, $496 = 0, $497 = 0, $498 = 0.0, $499 = 0, $5 = 0, $50 = 0, $500 = 0, $501 = 0, $502 = 0, $503 = 0;
 var $504 = 0, $505 = 0, $506 = 0.0, $507 = 0, $508 = 0, $509 = 0, $51 = 0, $510 = 0, $511 = 0, $512 = 0.0, $513 = 0, $514 = 0, $515 = 0, $516 = 0, $517 = 0.0, $518 = 0, $519 = 0, $52 = 0, $520 = 0, $521 = 0;
 var $522 = 0, $523 = 0.0, $524 = 0, $525 = 0, $526 = 0, $527 = 0, $528 = 0, $529 = 0.0, $53 = 0, $530 = 0.0, $531 = 0, $532 = 0, $533 = 0, $534 = 0, $535 = 0.0, $536 = 0.0, $537 = 0.0, $538 = 0, $539 = 0, $54 = 0;
 var $540 = 0.0, $541 = 0.0, $542 = 0.0, $543 = 0, $544 = 0.0, $545 = 0.0, $546 = 0, $547 = 0, $548 = 0, $549 = 0.0, $55 = 0, $550 = 0, $551 = 0, $552 = 0, $553 = 0.0, $554 = 0.0, $555 = 0, $556 = 0, $557 = 0.0, $558 = 0.0;
 var $559 = 0.0, $56 = 0, $560 = 0.0, $561 = 0, $562 = 0, $563 = 0, $564 = 0.0, $565 = 0, $566 = 0.0, $567 = 0.0, $568 = 0, $569 = 0, $57 = 0, $570 = 0, $571 = 0.0, $572 = 0.0, $573 = 0.0, $574 = 0, $575 = 0, $576 = 0.0;
 var $577 = 0.0, $578 = 0.0, $579 = 0, $58 = 0, $580 = 0.0, $581 = 0.0, $582 = 0, $583 = 0, $584 = 0, $585 = 0.0, $586 = 0, $587 = 0, $588 = 0, $589 = 0.0, $59 = 0, $590 = 0.0, $591 = 0, $592 = 0, $593 = 0.0, $594 = 0.0;
 var $595 = 0.0, $596 = 0.0, $597 = 0, $598 = 0, $599 = 0, $6 = 0, $60 = 0, $600 = 0.0, $601 = 0, $602 = 0, $603 = 0, $604 = 0.0, $605 = 0.0, $606 = 0, $607 = 0, $608 = 0, $609 = 0.0, $61 = 0, $610 = 0.0, $611 = 0.0;
 var $612 = 0, $613 = 0, $614 = 0.0, $615 = 0.0, $616 = 0.0, $617 = 0, $618 = 0.0, $619 = 0.0, $62 = 0, $620 = 0, $621 = 0, $622 = 0, $623 = 0.0, $624 = 0, $625 = 0, $626 = 0, $627 = 0.0, $628 = 0.0, $629 = 0, $63 = 0;
 var $630 = 0, $631 = 0.0, $632 = 0.0, $633 = 0.0, $634 = 0.0, $635 = 0, $636 = 0, $637 = 0, $638 = 0.0, $639 = 0, $64 = 0, $640 = 0.0, $641 = 0.0, $642 = 0, $643 = 0, $644 = 0, $645 = 0.0, $646 = 0.0, $647 = 0.0, $648 = 0;
 var $649 = 0, $65 = 0, $650 = 0.0, $651 = 0.0, $652 = 0.0, $653 = 0, $654 = 0.0, $655 = 0.0, $656 = 0, $657 = 0, $658 = 0, $659 = 0.0, $66 = 0, $660 = 0, $661 = 0, $662 = 0, $663 = 0.0, $664 = 0.0, $665 = 0, $666 = 0;
 var $667 = 0.0, $668 = 0.0, $669 = 0.0, $67 = 0, $670 = 0.0, $671 = 0, $672 = 0, $673 = 0, $674 = 0.0, $675 = 0, $676 = 0, $677 = 0, $678 = 0.0, $679 = 0.0, $68 = 0, $680 = 0, $681 = 0, $682 = 0.0, $683 = 0.0, $684 = 0.0;
 var $685 = 0, $686 = 0, $687 = 0, $688 = 0.0, $689 = 0.0, $69 = 0, $690 = 0.0, $691 = 0.0, $692 = 0, $693 = 0, $694 = 0.0, $695 = 0, $696 = 0.0, $697 = 0.0, $698 = 0, $699 = 0, $7 = 0.0, $70 = 0, $700 = 0.0, $701 = 0.0;
 var $702 = 0.0, $703 = 0, $704 = 0, $705 = 0, $706 = 0.0, $707 = 0.0, $708 = 0.0, $709 = 0.0, $71 = 0, $710 = 0, $711 = 0, $712 = 0.0, $713 = 0, $714 = 0.0, $715 = 0.0, $716 = 0, $717 = 0, $718 = 0, $719 = 0, $72 = 0;
 var $720 = 0.0, $721 = 0.0, $722 = 0.0, $723 = 0, $724 = 0, $725 = 0, $726 = 0.0, $727 = 0.0, $728 = 0.0, $729 = 0.0, $73 = 0, $730 = 0, $731 = 0, $732 = 0.0, $733 = 0, $734 = 0.0, $735 = 0.0, $736 = 0, $737 = 0, $738 = 0;
 var $739 = 0, $74 = 0, $740 = 0.0, $741 = 0.0, $742 = 0.0, $743 = 0, $744 = 0, $745 = 0, $746 = 0.0, $747 = 0.0, $748 = 0.0, $749 = 0.0, $75 = 0, $750 = 0, $751 = 0, $752 = 0.0, $753 = 0, $754 = 0, $755 = 0, $756 = 0;
 var $757 = 0, $758 = 0, $759 = 0, $76 = 0, $760 = 0.0, $761 = 0.0, $762 = 0, $763 = 0.0, $764 = 0, $765 = 0, $766 = 0, $767 = 0, $768 = 0, $769 = 0.0, $77 = 0, $770 = 0, $771 = 0, $772 = 0, $773 = 0, $774 = 0;
 var $775 = 0.0, $776 = 0, $777 = 0, $778 = 0, $779 = 0, $78 = 0, $780 = 0, $781 = 0, $782 = 0, $783 = 0, $784 = 0.0, $785 = 0.0, $786 = 0, $787 = 0, $788 = 0.0, $789 = 0.0, $79 = 0, $790 = 0, $791 = 0, $792 = 0;
 var $793 = 0, $794 = 0, $795 = 0, $796 = 0, $797 = 0, $798 = 0, $799 = 0, $8 = 0, $80 = 0, $800 = 0, $801 = 0, $802 = 0, $803 = 0, $804 = 0, $805 = 0, $806 = 0, $807 = 0.0, $808 = 0.0, $809 = 0, $81 = 0;
 var $810 = 0, $811 = 0.0, $812 = 0.0, $813 = 0, $814 = 0, $815 = 0, $816 = 0, $817 = 0, $818 = 0.0, $819 = 0, $82 = 0, $820 = 0, $821 = 0, $822 = 0, $823 = 0, $824 = 0, $825 = 0, $826 = 0, $827 = 0, $828 = 0;
 var $829 = 0, $83 = 0, $830 = 0, $831 = 0, $832 = 0, $833 = 0, $834 = 0, $835 = 0, $836 = 0, $837 = 0, $838 = 0, $839 = 0, $84 = 0, $840 = 0, $841 = 0, $842 = 0, $843 = 0, $844 = 0, $845 = 0, $846 = 0;
 var $847 = 0, $848 = 0, $849 = 0, $85 = 0, $850 = 0, $851 = 0, $852 = 0, $853 = 0, $854 = 0, $855 = 0, $856 = 0, $857 = 0, $858 = 0, $859 = 0, $86 = 0, $860 = 0, $861 = 0, $862 = 0, $863 = 0, $864 = 0;
 var $865 = 0, $866 = 0, $867 = 0, $868 = 0, $869 = 0, $87 = 0, $870 = 0, $871 = 0, $872 = 0, $873 = 0, $874 = 0, $875 = 0, $876 = 0, $877 = 0, $878 = 0, $879 = 0, $88 = 0, $880 = 0, $881 = 0, $882 = 0;
 var $883 = 0, $884 = 0, $885 = 0, $886 = 0, $887 = 0, $888 = 0, $889 = 0, $89 = 0, $890 = 0, $891 = 0, $892 = 0, $893 = 0, $894 = 0, $895 = 0, $896 = 0, $897 = 0, $898 = 0, $899 = 0, $9 = 0, $90 = 0;
 var $900 = 0, $901 = 0, $902 = 0, $903 = 0, $904 = 0, $905 = 0, $906 = 0, $907 = 0, $908 = 0, $909 = 0, $91 = 0, $910 = 0, $911 = 0, $912 = 0, $913 = 0, $914 = 0, $915 = 0, $916 = 0, $917 = 0, $918 = 0;
 var $919 = 0, $92 = 0, $920 = 0, $921 = 0, $922 = 0, $923 = 0, $924 = 0, $925 = 0, $926 = 0, $927 = 0, $928 = 0, $929 = 0, $93 = 0, $930 = 0, $931 = 0, $932 = 0, $933 = 0, $934 = 0, $935 = 0, $936 = 0;
 var $937 = 0, $938 = 0, $939 = 0, $94 = 0, $940 = 0, $941 = 0, $942 = 0, $943 = 0, $944 = 0, $945 = 0, $946 = 0, $947 = 0, $948 = 0, $949 = 0, $95 = 0, $950 = 0, $951 = 0, $952 = 0, $953 = 0, $954 = 0;
 var $955 = 0, $956 = 0, $957 = 0, $958 = 0, $959 = 0, $96 = 0, $960 = 0, $961 = 0, $962 = 0, $963 = 0, $964 = 0, $965 = 0, $966 = 0, $967 = 0, $968 = 0, $969 = 0, $97 = 0, $970 = 0, $971 = 0, $972 = 0;
 var $973 = 0, $974 = 0, $975 = 0, $976 = 0, $977 = 0.0, $978 = 0.0, $979 = 0, $98 = 0, $980 = 0, $981 = 0, $982 = 0.0, $983 = 0.0, $984 = 0, $985 = 0, $986 = 0, $987 = 0, $988 = 0.0, $989 = 0.0, $99 = 0, $990 = 0.0;
 var $991 = 0, $992 = 0, $993 = 0, $994 = 0, $995 = 0, $996 = 0, $997 = 0, $998 = 0, $999 = 0, $booklist$053$i$i = 0, $booklist$2$1$i$i = 0, $booklist$2$2$i$i = 0, $booklist$2$3$i$i = 0, $booklist$2$i$i = 0, $booklist$344$i$i = 0, $booklist$5$1$i$i = 0, $booklist$5$2$i$i = 0, $booklist$5$3$i$i = 0, $booklist$5$i$i = 0, $ch$0$lcssa$i$i = 0;
 var $ch$1$lcssa$i$i = 0, $ch$231$i$i = 0, $ch$4$i$i = 0, $exitcond$i = 0, $exitcond$i19 = 0, $exitcond$i24 = 0, $exitcond$i30 = 0, $exitcond$i36 = 0, $exitcond$i4 = 0, $exitcond$i452 = 0, $exitcond$i9 = 0, $exitcond10$i = 0, $exitcond18$i = 0, $exitcond19$i = 0, $exitcond9$i = 0, $freq$0$i$i = 0.0, $freq$1$i$i = 0.0, $freq$1$in$i$i = 0.0, $freq$1$in$in$i$i = 0, $freq$1$in$in$in$i$i = 0;
 var $freq$2$i$i = 0.0, $i$013$i = 0, $i$014$i = 0, $i$03$i = 0, $i$03$i23 = 0, $i$03$i29 = 0, $i$03$i35 = 0, $i$05$i$i$i = 0, $i$05$i1$1$i$i = 0, $i$05$i1$2$i$i = 0, $i$05$i1$3$i$i = 0, $i$05$i1$i$i = 0, $i$05$i11$1$i$i = 0, $i$05$i11$2$i$i = 0, $i$05$i11$3$i$i = 0, $i$05$i11$i$i = 0, $i$05$i6$i$i = 0, $i$054 = 0, $i$056$i$i = 0, $i$07$i = 0;
 var $i$154$i$i = 0, $i$16$i = 0, $i$18$i = 0, $i$22$i53 = 0, $i$247$i$i = 0, $i$25$i = 0, $i$345$i$i = 0, $i$437$i$i = 0, $j$013$i = 0, $j$032$i$i = 0, $k$03$i = 0, $k2$030$i$i = 0, $maxbook$010$i = 0, $maxbook$2$lcssa$i = 0, $maxbook$2$lcssa$i$lcssa = 0, $maxbook$24$i = 0, $maxclass$014$i = 0, $or$cond$i = 0, $or$cond$i16 = 0, $or$cond$i20 = 0;
 var $or$cond$i26 = 0, $or$cond$i32 = 0, $p$0$i = 0, $p$0$i10 = 0, $p$0$i12 = 0, $p$0$i14 = 0, $phitmp = 0, dest = 0, label = 0, sp = 0, src = 0, stop = 0;
 sp = STACKTOP;
 $0 = ((($vi)) + 28|0);
 $1 = HEAP32[$0>>2]|0;
 $2 = ($1|0)==(0|0);
 if ($2) {
  $$0 = -131;
  return ($$0|0);
 }
 $3 = ((($1)) + 3456|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = ($4|0)==(0);
 $$ = $5&1;
 $6 = ((($1)) + 3496|0);
 $7 = +HEAPF64[$6>>3];
 $8 = $7 > -80.0;
 if ($8) {
  HEAPF64[$6>>3] = -80.0;
 } else {
  $9 = $7 < -200.0;
  if ($9) {
   HEAPF64[$6>>3] = -200.0;
  }
 }
 $10 = ((($1)) + 3512|0);
 $11 = +HEAPF64[$10>>3];
 $12 = $11 > 0.0;
 if ($12) {
  HEAPF64[$10>>3] = 0.0;
 } else {
  $13 = $11 < -99999.0;
  if ($13) {
   HEAPF64[$10>>3] = -99999.0;
  }
 }
 $14 = ((($1)) + 3396|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = ($15|0)==(0|0);
 if ($16) {
  $$0 = -131;
  return ($$0|0);
 }
 $17 = ((($1)) + 3392|0);
 HEAP32[$17>>2] = 1;
 $18 = ((($1)) + 3400|0);
 $19 = +HEAPF64[$18>>3];
 $20 = ((($15)) + 24|0);
 $21 = HEAP32[$20>>2]|0;
 $22 = ((($15)) + 28|0);
 $23 = HEAP32[$22>>2]|0;
 $24 = (~~(($19)));
 $25 = (($21) + ($24<<2)|0);
 $26 = HEAP32[$25>>2]|0;
 $27 = (($23) + ($24<<2)|0);
 $28 = HEAP32[$27>>2]|0;
 HEAP32[$1>>2] = $26;
 $29 = ((($1)) + 4|0);
 HEAP32[$29>>2] = $28;
 $30 = ($26|0)==($28|0);
 $31 = ((($15)) + 144|0);
 $32 = HEAP32[$31>>2]|0;
 $33 = ($32|0)>(0);
 if ($33) {
  $34 = ((($15)) + 136|0);
  $35 = ((($15)) + 140|0);
  $36 = ((($15)) + 148|0);
  $38 = $19;$54 = $1;$i$054 = 0;
  while(1) {
   $37 = (~~(($38)));
   $39 = HEAP32[$34>>2]|0;
   $40 = HEAP32[$35>>2]|0;
   $41 = HEAP32[$36>>2]|0;
   $42 = (($41) + ($i$054<<2)|0);
   $43 = HEAP32[$42>>2]|0;
   $44 = (_calloc(1,1120)|0);
   $45 = (($43) + ($37<<2)|0);
   $46 = HEAP32[$45>>2]|0;
   $47 = (($40) + (($46*1120)|0)|0);
   _memcpy(($44|0),($47|0),1120)|0;
   $48 = HEAP32[$44>>2]|0;
   $49 = ($48|0)>(0);
   if ($49) {
    $50 = ((($44)) + 4|0);
    $i$013$i = 0;$maxclass$014$i = -1;
    while(1) {
     $57 = (($50) + ($i$013$i<<2)|0);
     $58 = HEAP32[$57>>2]|0;
     $59 = ($58|0)>($maxclass$014$i|0);
     $$maxclass$0$i = $59 ? $58 : $maxclass$014$i;
     $60 = (($i$013$i) + 1)|0;
     $exitcond19$i = ($60|0)==($48|0);
     if ($exitcond19$i) {
      $$maxclass$0$i$lcssa = $$maxclass$0$i;
      break;
     } else {
      $i$013$i = $60;$maxclass$014$i = $$maxclass$0$i;
     }
    }
    $51 = ($$maxclass$0$i$lcssa|0)<(0);
    if (!($51)) {
     $52 = ((($44)) + 256|0);
     $53 = ((($54)) + 24|0);
     $55 = ((($44)) + 192|0);
     $56 = ((($44)) + 320|0);
     $i$18$i = 0;$maxbook$010$i = -1;
     while(1) {
      $68 = (($52) + ($i$18$i<<2)|0);
      $69 = HEAP32[$68>>2]|0;
      $70 = ($69|0)>($maxbook$010$i|0);
      $$maxbook$0$i = $70 ? $69 : $maxbook$010$i;
      $71 = HEAP32[$53>>2]|0;
      $72 = (($71) + ($69))|0;
      HEAP32[$68>>2] = $72;
      $73 = (($55) + ($i$18$i<<2)|0);
      $74 = HEAP32[$73>>2]|0;
      $75 = ($74|0)==(31);
      if ($75) {
       $maxbook$2$lcssa$i = $$maxbook$0$i;
      } else {
       $1244 = $74;$k$03$i = 0;$maxbook$24$i = $$maxbook$0$i;
       while(1) {
        $76 = ((($56) + ($i$18$i<<5)|0) + ($k$03$i<<2)|0);
        $77 = HEAP32[$76>>2]|0;
        $78 = ($77|0)>($maxbook$24$i|0);
        $$maxbook$2$i = $78 ? $77 : $maxbook$24$i;
        $79 = ($77|0)>(-1);
        if ($79) {
         $80 = HEAP32[$53>>2]|0;
         $81 = (($80) + ($77))|0;
         HEAP32[$76>>2] = $81;
         $$pre$i = HEAP32[$73>>2]|0;
         $84 = $$pre$i;
        } else {
         $84 = $1244;
        }
        $82 = (($k$03$i) + 1)|0;
        $83 = 1 << $84;
        $85 = ($82|0)<($83|0);
        if ($85) {
         $1244 = $84;$k$03$i = $82;$maxbook$24$i = $$maxbook$2$i;
        } else {
         $maxbook$2$lcssa$i = $$maxbook$2$i;
         break;
        }
       }
      }
      $86 = (($i$18$i) + 1)|0;
      $exitcond18$i = ($i$18$i|0)==($$maxclass$0$i$lcssa|0);
      if ($exitcond18$i) {
       $maxbook$2$lcssa$i$lcssa = $maxbook$2$lcssa$i;
       break;
      } else {
       $i$18$i = $86;$maxbook$010$i = $maxbook$2$lcssa$i;
      }
     }
     $61 = ($maxbook$2$lcssa$i$lcssa|0)<(0);
     if (!($61)) {
      $62 = (($39) + ($46<<2)|0);
      $63 = HEAP32[$62>>2]|0;
      $64 = HEAP32[$63>>2]|0;
      $65 = HEAP32[$53>>2]|0;
      $66 = (($65) + 1)|0;
      HEAP32[$53>>2] = $66;
      $67 = (((($54)) + 1824|0) + ($65<<2)|0);
      HEAP32[$67>>2] = $64;
      $exitcond$i452 = ($maxbook$2$lcssa$i$lcssa|0)==(0);
      if (!($exitcond$i452)) {
       $i$22$i53 = 0;
       while(1) {
        $87 = (($i$22$i53) + 1)|0;
        $$pre21$i = HEAP32[$45>>2]|0;
        $88 = (($39) + ($$pre21$i<<2)|0);
        $89 = HEAP32[$88>>2]|0;
        $90 = (($89) + ($87<<2)|0);
        $91 = HEAP32[$90>>2]|0;
        $92 = HEAP32[$53>>2]|0;
        $93 = (($92) + 1)|0;
        HEAP32[$53>>2] = $93;
        $94 = (((($54)) + 1824|0) + ($92<<2)|0);
        HEAP32[$94>>2] = $91;
        $exitcond$i4 = ($87|0)==($maxbook$2$lcssa$i$lcssa|0);
        if ($exitcond$i4) {
         break;
        } else {
         $i$22$i53 = $87;
        }
       }
      }
     }
    }
   }
   $95 = ((($54)) + 16|0);
   $96 = HEAP32[$95>>2]|0;
   $97 = (((($54)) + 800|0) + ($96<<2)|0);
   HEAP32[$97>>2] = 1;
   $98 = HEAP32[$95>>2]|0;
   $99 = (((($54)) + 1056|0) + ($98<<2)|0);
   HEAP32[$99>>2] = $44;
   $100 = HEAP32[$95>>2]|0;
   $101 = (($100) + 1)|0;
   HEAP32[$95>>2] = $101;
   $102 = (($i$054) + 1)|0;
   $103 = HEAP32[$31>>2]|0;
   $104 = ($102|0)<($103|0);
   if (!($104)) {
    break;
   }
   $$pre = +HEAPF64[$18>>3];
   $$pre67 = HEAP32[$0>>2]|0;
   $38 = $$pre;$54 = $$pre67;$i$054 = $102;
  }
  $$pre68 = HEAP32[$0>>2]|0;
  $115 = $$pre68;
 } else {
  $115 = $1;
 }
 $105 = ((($1)) + 3520|0);
 $106 = +HEAPF64[$105>>3];
 $107 = ((($15)) + 124|0);
 $108 = HEAP32[$107>>2]|0;
 $109 = ((($15)) + 128|0);
 $110 = HEAP32[$109>>2]|0;
 $111 = (~~(($106)));
 $112 = (+($111|0));
 $113 = $106 - $112;
 $114 = ((($115)) + 2868|0);
 $116 = (($110) + ($111<<3)|0);
 $117 = +HEAPF64[$116>>3];
 $118 = (~~(($117)));
 $119 = (($108) + (($118*492)|0)|0);
 _memcpy(($114|0),($119|0),492)|0;
 $120 = +HEAPF64[$116>>3];
 $121 = 1.0 - $113;
 $122 = $120 * $121;
 $123 = (($111) + 1)|0;
 $124 = (($110) + ($123<<3)|0);
 $125 = +HEAPF64[$124>>3];
 $126 = $125 * $113;
 $127 = $126 + $122;
 $128 = (~~(($127)));
 $129 = (+($128|0));
 $130 = $127 - $129;
 $131 = $130 == 0.0;
 $132 = ($128|0)>(0);
 $or$cond$i = $132 & $131;
 $$$i6 = $or$cond$i ? 1.0 : $130;
 $133 = $or$cond$i << 31 >> 31;
 $$2$i = (($133) + ($128))|0;
 $134 = 1.0 - $$$i6;
 $135 = (($$2$i) + 1)|0;
 $136 = (((($108) + (($$2$i*492)|0)|0)) + 4|0);
 $137 = +HEAPF32[$136>>2];
 $138 = $137;
 $139 = $134 * $138;
 $140 = (((($108) + (($135*492)|0)|0)) + 4|0);
 $141 = +HEAPF32[$140>>2];
 $142 = $141;
 $143 = $$$i6 * $142;
 $144 = $139 + $143;
 $145 = $144;
 $146 = ((($115)) + 2872|0);
 HEAPF32[$146>>2] = $145;
 $147 = (((($108) + (($$2$i*492)|0)|0)) + 32|0);
 $148 = +HEAPF32[$147>>2];
 $149 = $148;
 $150 = $134 * $149;
 $151 = (((($108) + (($135*492)|0)|0)) + 32|0);
 $152 = +HEAPF32[$151>>2];
 $153 = $152;
 $154 = $$$i6 * $153;
 $155 = $150 + $154;
 $156 = $155;
 $157 = ((($115)) + 2900|0);
 HEAPF32[$157>>2] = $156;
 $158 = (((($108) + (($$2$i*492)|0)|0)) + 8|0);
 $159 = +HEAPF32[$158>>2];
 $160 = $159;
 $161 = $134 * $160;
 $162 = (((($108) + (($135*492)|0)|0)) + 8|0);
 $163 = +HEAPF32[$162>>2];
 $164 = $163;
 $165 = $$$i6 * $164;
 $166 = $161 + $165;
 $167 = $166;
 $168 = ((($115)) + 2876|0);
 HEAPF32[$168>>2] = $167;
 $169 = (((($108) + (($$2$i*492)|0)|0)) + 36|0);
 $170 = +HEAPF32[$169>>2];
 $171 = $170;
 $172 = $134 * $171;
 $173 = (((($108) + (($135*492)|0)|0)) + 36|0);
 $174 = +HEAPF32[$173>>2];
 $175 = $174;
 $176 = $175 * $$$i6;
 $177 = $176 + $172;
 $178 = $177;
 $179 = ((($115)) + 2904|0);
 HEAPF32[$179>>2] = $178;
 $180 = (((($108) + (($$2$i*492)|0)|0)) + 12|0);
 $181 = +HEAPF32[$180>>2];
 $182 = $181;
 $183 = $182 * $134;
 $184 = (((($108) + (($135*492)|0)|0)) + 12|0);
 $185 = +HEAPF32[$184>>2];
 $186 = $185;
 $187 = $186 * $$$i6;
 $188 = $187 + $183;
 $189 = $188;
 $190 = ((($115)) + 2880|0);
 HEAPF32[$190>>2] = $189;
 $191 = (((($108) + (($$2$i*492)|0)|0)) + 40|0);
 $192 = +HEAPF32[$191>>2];
 $193 = $192;
 $194 = $193 * $134;
 $195 = (((($108) + (($135*492)|0)|0)) + 40|0);
 $196 = +HEAPF32[$195>>2];
 $197 = $196;
 $198 = $197 * $$$i6;
 $199 = $198 + $194;
 $200 = $199;
 $201 = ((($115)) + 2908|0);
 HEAPF32[$201>>2] = $200;
 $202 = (((($108) + (($$2$i*492)|0)|0)) + 16|0);
 $203 = +HEAPF32[$202>>2];
 $204 = $203;
 $205 = $204 * $134;
 $206 = (((($108) + (($135*492)|0)|0)) + 16|0);
 $207 = +HEAPF32[$206>>2];
 $208 = $207;
 $209 = $208 * $$$i6;
 $210 = $209 + $205;
 $211 = $210;
 $212 = ((($115)) + 2884|0);
 HEAPF32[$212>>2] = $211;
 $213 = (((($108) + (($$2$i*492)|0)|0)) + 44|0);
 $214 = +HEAPF32[$213>>2];
 $215 = $214;
 $216 = $215 * $134;
 $217 = (((($108) + (($135*492)|0)|0)) + 44|0);
 $218 = +HEAPF32[$217>>2];
 $219 = $218;
 $220 = $219 * $$$i6;
 $221 = $220 + $216;
 $222 = $221;
 $223 = ((($115)) + 2912|0);
 HEAPF32[$223>>2] = $222;
 $224 = ((($115)) + 3512|0);
 $225 = +HEAPF64[$224>>3];
 $226 = $225;
 $227 = ((($115)) + 2936|0);