<?php
// +----------------------------------------------------------------------
// | HkCms SEO配置
// +----------------------------------------------------------------------
// | Copyright (c) 2020-2021 http://www.hkcms.cn, All rights reserved.
// +----------------------------------------------------------------------
// | Author: 广州恒企教育科技有限公司 <admin@hkcms.cn>
// +----------------------------------------------------------------------

declare (strict_types=1);

namespace app\admin\controller\routine;

use app\admin\controller\BaseController;
use think\facade\Db;

class Seo extends BaseController
{
    protected $rules = [
        //['/:catname/$','/:catname/:id$.html'],
        ['/:catname/$,/:catname/list_:page$.html','/:catname/:id$.html'],
        ['/[:lang]/:catname/$,/[:lang]/:catname/list_:page$.html','/[:lang]/:catname/:id$.html'],
        ['/[:catdir]/:catname/$','/[:catdir]/:catname/:id$.html'],
        ['/[:lang]/[:catdir]/:catname/$','/[:lang]/[:catdir]/:catname/:id$.html'],
        ['/:model/:catname/$','/:model/:id$.html'],
    ];

    public function index()
    {
        if ($this->request->isPost()) {
            $row = $this->request->post('row');
            if ($row['url_mode']==0) { // 动态
                Db::name('config')->where(['name'=>'url_file'])->save(['value'=>$row['url_file']]);
            } else if ($row['url_format']!=0) { // 伪静态、使用内置规则
                $rule = $this->rules[$row['url_format']-1];
                $info = Db::name('config')->where(['name'=>'url_rewrite'])->find();
                $rewrite = json_decode($info['value'], true);
                $rewrite['index/lists'] = $rule[0];
                $rewrite['index/show'] = $rule[1];
                if (($row['url_format']==4||$row['url_format']==2) && empty($rewrite['/'])) { // 多语言
                    $newRe = ['/'=>'/[:lang]/$'];
                    $rewrite = array_merge($newRe,$rewrite);
                } else if (in_array($row['url_format'],['1','3','4']) && !empty($rewrite['/']) && $rewrite['/']=='/[:lang]/$') {
                    unset($rewrite['/']);
                }
                Db::name('config')->where(['name'=>'url_rewrite'])->update(['value'=>json_encode($rewrite)]);
            }

            if (($row['category_format']==-1 && empty($row['category_format_diy'])) || ($row['content_format']==-1 && empty($row['content_format_diy']))) {
                $this->error(__('Custom content cannot be empty'));
            }

            Db::name('config')->where(['name'=>'category_format'])->save(['value'=>$row['category_format']==-1?$row['category_format_diy']:$row['category_format']]);
            Db::name('config')->where(['name'=>'content_format'])->save(['value'=>$row['content_format']==-1?$row['content_format_diy']:$row['content_format']]);
            Db::name('config')->where(['name'=>'url_mode'])->save(['value'=>$row['url_mode']]);
            $this->cache->clear();
            $this->success();
        }

        $config = Db::name('config')->select();
        $field = [];
        foreach ($config as $key=>$value) {
            $field[$value['name']] = $value['value'];
            if ($value['name']=='url_rewrite') {
                $rewrite = json_decode($value['value'], true);
                if (!isset($rewrite['index/lists']) || !isset($rewrite['index/show'])) {
                    continue;
                }
                foreach ($this->rules as $k=>$v) {
                    if ($v[0]==$rewrite['index/lists'] && $v[1]==$rewrite['index/show']) {
                        $field[$value['name']] = $k+1;
                        break;
                    }
                }
            }
        }

        $this->view->assign('field', $field);
        return $this->view->fetch();
    }
}