<?php
// +----------------------------------------------------------------------
// | HkCms 附件管理
// +----------------------------------------------------------------------
// | Copyright (c) 2020-2021 http://www.hkcms.cn, All rights reserved.
// +----------------------------------------------------------------------
// | Author: 广州恒企教育科技有限公司 <admin@hkcms.cn>
// +----------------------------------------------------------------------

declare (strict_types=1);

namespace app\admin\controller\routine;

use app\admin\controller\BaseController;

class Attachment extends BaseController
{
    protected $middleware = [
        'login',
        'auth' => ['except'=>['select']]
    ];

    /**
     * @var \app\admin\model\routine\Attachment
     */
    protected $model;

    public function initialize()
    {
        parent::initialize();

        $this->model = new \app\admin\model\routine\Attachment;
    }

    public function index()
    {
        if ($this->request->isAjax()) {
            list($map, $limit, $offset, $order, $sort) = $this->buildparams();

            $data = $this->model->where($map)->order($sort, $order)->limit($offset, $limit)->select()->append(['size_text','user_name','cdn_url'])->toArray();
            $total = $this->model->where($map)->order($sort, $order)->count();
            return json(['total'=>$total,'rows'=>$data]);
        }

        $ext = $this->model->group('ext')->column('ext');
        return $this->view->fetch('', compact('ext'));
    }

    /**
     * 文件选择
     * @return string|void
     * @throws \Exception
     */
    public function select()
    {
        if ($this->request->isAjax()) {
            list($map, $limit, $offset, $order, $sort) = $this->buildparams();

            $data = $this->model->where($map)->order($sort, $order)->limit($offset, $limit)->select()->append(['size_text','user_name','cdn_url'])->toArray();
            $total = $this->model->where($map)->order($sort, $order)->count();
            return json(['total'=>$total,'rows'=>$data]);
        }
        $param = $this->request->param();
        $this->view->assign($param);
        $this->view->assign('ext',$this->model->group('ext')->column('ext'));
        return $this->view->fetch();
    }
}