/**
 * Copyright 2020 OPSLI 快速开发平台 https://www.opsli.com
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.opsli.core.log.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 日志级别枚举
 *
 * @author Parker
 * @date 2021年7月15日20:28:24
 */
@Getter
@AllArgsConstructor
public enum LogLevelEnum {

    /**
     * 日志级别枚举
     */
    DEBUG("-1"),
    INFO("0"),
    WARN("1"),
    ERROR("2"),
    TRACE("3");

    private final String value;
}
