# use gperf to generate Chinese symbol pcm hash table

use strict;
use utf8;
#use eGuideDog::Dict::Korean;

open(SYMBOL_ARRAY, '>', 'symbol_array.cpp');
printf SYMBOL_ARRAY "// Don't edit. This file is generated by gen_gperf_symbol_pcm.pl\n";
printf SYMBOL_ARRAY "#include \"stdafx.h\"\n";
printf SYMBOL_ARRAY "#include \"ekho_dict.h\"\n";
#printf SYMBOL_ARRAY "#define P(X) PhoneticSymbol(X);\n";
printf SYMBOL_ARRAY "ekho::PhoneticSymbol ekho::Dict::mSymbolArray[8000] = {\n";

#===== generate zhy_symbol_map.h =====
open(HEADER, '>', 'zhy_symbol_map.h');
printf HEADER << 'END_H';
// Don't edit. This file is generated by gen_gperf_symbol_pcm.pl
#ifndef ZHY_SYMBOL_MAP_H
#define ZHY_SYMBOL_MAP_H

#include "phonetic_symbol.h"
class ZHY_PHash {
private:
  static inline unsigned int hash (const char *str, unsigned int len);
public:
  static ekho::SymbolCode* in_word_set (const char *str, unsigned int len);
};

#endif
END_H
close(HEADER);

#===== generate zh_symbol_pcm.h =====
open(HEADER, '>', 'zh_symbol_map.h');
printf HEADER << 'END_H';
// Don't edit. This file is generated by gen_gperf_symbol_pcm.pl
#ifndef ZH_SYMBOL_MAP_H
#define ZH_SYMBOL_MAP_H

#include "phonetic_symbol.h"
class ZH_PHash {
private:
  static inline unsigned int hash (const char *str, unsigned int len);
public:
  static ekho::SymbolCode* in_word_set (const char *str, unsigned int len);
};

#endif
END_H
close(HEADER);

#===== generate kr_symbol_pcm.h =====
#open(HEADER, '>', 'ko_symbol_pcm.h');
#printf HEADER << 'END_H';
##ifndef KO_SYMBOL_PCM_H
##define KO_SYMBOL_PCM_H

#class Perfect_KO_Hash {
#private:
#  static inline unsigned int hash (const char *str, unsigned int len);
#public:
#  static struct symbol_pcm *in_word_set (const char *str, unsigned int len);
#};

##endif
#END_H
#close(HEADER);

#===== generate ZHY_SYMBOL_PCM ===== 
open(DICT, '>', 'zhy_symbol_map');
printf DICT "\%{\n";
#printf DICT '#include <string>';
#printf DICT "\n";
printf DICT '#include "stdafx.h"' . "\n";
printf DICT '#include "phonetic_symbol.h"' . "\n";
printf DICT '#include "zhy_symbol_map.h"';
printf DICT "\n\%}\n";
printf DICT 'struct ekho::SymbolCode;';
printf DICT "\n\%\%\%\n";
#open(LIST, '<', 'jyutping_phon_list.txt');
#while (my $file = <LIST>) {
#  if ($file =~ /^([^:]*):/) {
#    printf DICT "$1, NULL, 0\n";
#  }
#}
#close(LIST);
my @files = `ls -1 ~/e-guidedog/jyutping-wong/`;
my $index = 0;
for my $file (@files) {
  chomp($file);
  if ($file =~ /^([a-z0-9]*)\.wav$/) {
    printf DICT "$1, $index\n";
    printf SYMBOL_ARRAY "PhoneticSymbol(\"$1\"), ";
    $index++;
  }
}
close(DICT);
sleep(1);
system("gperf -L C++ -t zhy_symbol_map>zhy_symbol_map.cpp.tmp");
sleep(1);
modify_perfect_hash('zhy_symbol_map.cpp.tmp', 'ZHY');
system("rm zhy_symbol_map.cpp.tmp");
system("rm zhy_symbol_map");

#===== generate ZH_SYMBOL_PCM ===== 
open(DICT, '>', 'zh_symbol_map');
printf DICT "\%{\n";
#printf DICT '#include <string>';
#printf DICT "\n";
printf DICT '#include "stdafx.h"' . "\n";
printf DICT '#include "phonetic_symbol.h"' . "\n";
printf DICT '#include "zh_symbol_map.h"';
printf DICT "\n\%}\n";
printf DICT 'struct ekho::SymbolCode;';
#printf DICT 'struct symbol_pcm;';
printf DICT "\n\%\%\%\n";
#open(LIST, '<', 'pinyin_phon_list.txt');
#while (my $file = <LIST>) {
#  if ($file =~ /^([^:]*):/) {
#    printf DICT "$1, NULL, 0\n";
#  }
#}
#close(LIST);
my @files = `ls -1 ~/e-guidedog/ssb22/yali-voice/wav-syllables`;
for my $file (@files) {
  chomp($file);
  if ($file =~ /^([a-z0-9]*)\.wav$/) {
    printf DICT "$1, $index\n";
    printf SYMBOL_ARRAY "PhoneticSymbol(\"$1\"), ";
    $index++;
  }
}

close(DICT);
sleep(1);
system("gperf -L C++ -t zh_symbol_map>zh_symbol_map.cpp.tmp");
sleep(1);
modify_perfect_hash('zh_symbol_map.cpp.tmp', 'ZH');
system("rm zh_symbol_map.cpp.tmp");
system("rm zh_symbol_map");

printf SYMBOL_ARRAY "\n};\n";
close(SYMBOL_ARRAY);

#===== generate KO_SYMBOL_PCM =====
#my $korean_dict = eGuideDog::Dict::Korean->new();

#open(DICT, '>:utf8', 'ko_symbol_pcm');
#printf DICT "\%{\n";
#printf DICT '#include <string>';
#printf DICT "\n";
#printf DICT '#include "symbol_pcm.h"';
#printf DICT "\n";
#printf DICT '#include "ko_symbol_pcm.h"';
#printf DICT "\n\%}\n";
#printf DICT 'struct symbol_pcm;';
#printf DICT "\n\%\%\%\n";
#open(LIST, '<:utf8', 'hangul2350_list.txt');
#while (my $file = <LIST>) {
#  if ($file =~ /^([^:]*):/) {
#    my $char = $1;
#    my $symbol = $korean_dict->get_lead($char) . $korean_dict->get_vowel($char) . $korean_dict->get_tail($char);
#    print DICT "$symbol, NULL, 0\n";
#  }
#}
#close(LIST);
#close(DICT);
#sleep(1);
#system("gperf -L C++ -t ko_symbol_pcm>ko_symbol_pcm.cpp.tmp");
#sleep(1);
#modify_perfect_hash('ko_symbol_pcm.cpp.tmp', 'KO');
#system("rm ko_symbol_pcm.cpp.tmp");

# delete definition of class Perfect_Hash
# change Perfect_Hash into Perfect_xxx_Hash
sub modify_perfect_hash() {
    my $source_file = shift;
    $source_file =~ /(.*)[.]tmp$/;
    my $target_file = $1;
    my $class_id = shift;

    open(SOURCE, '<', $source_file);
    open(TARGET, '>', $target_file);

    while (my $line = <SOURCE>) {
        if ($line eq "class Perfect_Hash\n") {
            <SOURCE> for (1 .. 7);
        } elsif ($line =~ /^Perfect_Hash::(.*)/) {
            printf TARGET $class_id . "_PHash::" . $1;
        } else {
            printf TARGET $line;
        }
    }
    
    close(TARGET);
    close(SOURCE);
}
