
Представьте, что у нас есть ряд чисел от 0 до 9. Мы хотим сложить эти числа. Мы могли бы сделать это так:

```python
sum = 0
i = 0

while i < 10:
    sum += i
    i += 1

print(sum) # => 45
```

Сначала мы устанавливаем начальную сумму 0. Далее запускается цикл, в котором переменная `i` начинает принимать значения начиная с 0 и доходя до 10. На каждом шаге мы прибавляем значение `i` к нашей сумме и увеличиваем `i` на 1. Как только `i` становится равным 10, цикл заканчивается и программа выдаёт нам сумму всех чисел от 0 до 9 равную 45.

Такой код мы можем переписать на цикл `for`

```python
sum = 0

for i in range(10):
    sum += i

print(sum) # => 45
```

Первый пример использует `while`, который продолжает работать пока `i < 10`. Второй использует `for` и выполняет итерацию от 0 до 9 с помощью функции `range()`. Оба выполняют одно и то же: складывают числа от 0 до 9 в переменную `sum`, но используют разные способы выполнения итераций.

## Функция `range()`

Функция range в Python является встроенной функцией, которая создает последовательность чисел внутри определенного диапазона. Ее можно использовать в цикле for для контроля количества итераций.

У `range()` есть несколько вариантов использования:

* `range(stop)` создает последовательность от 0 до `stop - 1`
* `range(start, stop)` создает последовательность от start до `stop - 1`
* `range(start, stop, step)` создает последовательность из чисел от start до `stop - 1`, с шагом `step`

Пример с одним конечным значением мы рассмотрели выше. Рассмотрим другой - распечатаем на экран числа от 1 до 3:

```python

for i in range(1, 4):
    print(i)

# => 1
# => 2
# => 3
```

Теперь попробуем вывести числа в обратном порядке

```python
for i in range(3, 0, -1):
    print(i)

# => 3
# => 2
# => 1
```

На примерах выше мы видим, что итерация завершается до конечного значения
