
С помощью цикла `while` решают любую задачу перебора элементов, но его отличает многословность. Для `while` нужно задавать условие остановки и вводить счетчик. Когда циклов немного, то это нормально, но в реальном коде циклы встречаются на каждом шагу. Поэтому управлять условиями вручную утомительно, особенно когда условие остановки очевидно.

Например, если мы хотим перебрать символы в строке, то компьютер сам может понять, когда строка заканчивается. Для таких ситуаций в Python ввели цикл `for`. Он сам знает, когда нужно остановиться, так как работает только с коллекциями — наборами элементов, которые нужно перебрать.

Строка — это коллекция, так как состоит из набора символов. Остальные виды коллекций подробно изучаются в другом курсе.

Пример:

```python
text = 'code'
for symbol in text:
    print(symbol)

# => c
# => o
# => d
# => e
```

В коде выше `for` проходит по каждому символу в строке, записывает его в переменную `symbol` и вызывает внутренний блок кода, где эта переменная используется. Имя этой переменной может быть любым. Общая структура цикла `for` выглядит так: `for <переменная> in <коллекция>`.

Посмотрим, как реализовать функцию переворота строки через цикл `for`:

```python
def reverse_string(text):
    # Начальное значение
    result = ''
    # char - переменная, в которую записывается текущий символ
    for char in text:
        # Соединяем в обратном порядке
        result = char + result
    # Цикл заканчивается, когда пройдена вся строка
    return result


reverse_string('go!')  # => '!og'
```

Разберем подробно как отрабатывает цикл в примере выше на каждом шаге итераций:

1. В первой итерации в цикле `result` равен пустой строке, `char` равен первому символу 'g'. Поэтому в `result` присваивается символ 'g' плюс пустая строка, в итоге сохраняется только символ 'g'
2. На второй итерации `result` уже хранит символ 'g', а `char` равен следующему символу 'o'. В `result` записывается `char + result`, то есть `'o' + 'g'`
3. На последней итерации в `result` хранится строка 'og', а `char` равен последнему символу '!'. В `result` теперь сохраняется `'!' + 'og'`

Теперь посчитаем количество упоминаний символа в строке без учета регистра:

```python
# text - произвольный текст
# char - символ, который нужно учитывать
def chars_count(text, char):
    # Так как ищем сумму, то начальное значение 0
    result = 0
    for current_char in text:
        # приводим все к нижнему регистру,
        # чтобы не зависеть от текущего регистра
        if current_char.lower() == char.lower():
            result += 1
    return result


chars_count('hexlet!', 'e')  # 2
chars_count('hExlet!', 'e')  # 2
chars_count('hExlet!', 'E')  # 2

chars_count('hexlet!', 'a')  # 0
```

Советуем поэкспериментировать с примерами выше в интерактивном [Replit](https://replit.com/@hexlet/python-basics-for-loop#main.py).
