
Working with loops usually comes down to two scenarios:

1. Aggregation. Accumulation of result during iterations and working with it after the cycle. Line reversal refers to this variant.
2. Executing the loop until the desired result is achieved and exiting. For example, the problem of searching for prime numbers - which are divided without remainder by themselves and by one

Consider the algorithm for checking the simplicity of a number. We will divide the sought number `x` by all numbers in the range from two to `x - 1` and see the remainder. If no divisor is found in this range, which divides the number `x` without a remainder, then we have a prime number.

In this case it is enough to check the numbers not up to `x - 1`, but up to half a number. For example, 11 is not divisible by 2, 3, 4, 5. But further will not divide by numbers greater than its half. So, we can optimize the algorithm and check the division only up to `x / 2`:

```python
def is_prime(number):
    if number < 2:
        return False

    divider = 2

    while divider <= number / 2:
        if number % divider == 0:
            return False

        divider += 1

    return True

print(is_prime(1))  # => False
print(is_prime(2))  # => True
print(is_prime(3))  # => True
print(is_prime(4))  # => False
```

Imagine that the algorithm of consecutive division by numbers up to `x / 2` has found one that divides without a remainder. So the argument passed is not a prime number, and further calculations do not make sense. At this point it returns `False`.

If the whole cycle worked and no number was found that divides without a remainder, it means that the number is prime.
