
Еще циклы можно использовать, чтобы формировать строки. Подобная задача часто встречается в веб-программировании. Она сводится к обычной агрегации, когда применяется интерполяция или конкатенация.

Переворот строки — алгоритмическая задача, которую задают на собеседованиях. Правильный способ перевернуть строку — использовать функцию из стандартной библиотеки. Но важно знать, как ее реализовать.

Один из алгоритмов выглядит так:

1. Строим новую строку

2. Перебираем символы исходной строки в обратном порядке

```python
def reverse_string(string):
    index = len(string) - 1
    reversed_string = ''

    while index >= 0:
        current_char = string[index]
        reversed_string = reversed_string + current_char
        # То же самое через интерполяцию
        # reversed_string = f'{reversed_string}{current_char}'
        index = index - 1

    return reversed_string

reverse_string('Game Of Thrones')  # 'senorhT fO emaG'
# Проверка нейтрального элемента
reverse_string('')  # ''
```

Разберем функцию построчно:

* `index = len(string) - 1` — записываем в новую переменную индекс последнего символа строки (индексы начинаются с нуля)
* `reversed_string = ''` — инициализируем строку, куда будем записывать результат
* `while index >= 0:` — условие: повторяем тело цикла, пока текущий индекс не дошел до `0` — до первого символа
* `current_char = string[index]` — берем из строки символ по текущему индексу
* `reversed_string = reversed_string + current_char` — записываем в строку-результат новое значение: текущая строка-результат + новый символ
* `index = index - 1` — обновляем счетчик
* `return reversed_string` — когда цикл завершился, возвращаем строку-результат

Советуем скопировать эту функцию в [https://replit.com/languages/python3](https://replit.com/languages/python3) и поэкспериментировать с ней.

Работая со строками, программисты часто допускают ошибку — выходят за границы строки. Если неправильно подобрать начальное значение счетчика или допустить ошибку в предикате цикла, функция может обращаться к несуществующему символу.

Особенно часто забывают, что индекс последнего элемента всегда меньше на единицу размера строки. В строках начальный индекс равен `0`, значит, индекс последнего элемента — `len(str) - 1`.
