
You can execute instructions in the bodies of loops like you can in functions. This means you can use everything you learned before inside loops, such as conditional constructions.

Imagine a function that counts how many times a letter occurs in a sentence. Example of how it works:

```python
count_chars('Fear cuts deeper than swords.', 'e')  # 4
# If nothing is found, the result is 0 matches
count_chars('Sansa', 'y')  # 0
```

Before you look at the contents of a function, think about this:

* Is this an aggregation operation?
* How will it check if a character occurs in a sentence?

```python
def count_chars(string, char):
    index = 0
    count = 0
    while index < len(string):
        if string[index] == char:
            # We only count the matching characters
            count = count + 1
        # The counter is incremented anyway
        index = index + 1
    return count
```

This is an aggregation task. Although it doesn't count all the characters to calculate the amount, you still have to analyze each character. The key difference between this loop and the ones we looked at before is that there's a condition inside the body.

The `count` variable is incremented only when the character in question is the same as the expected one. Otherwise, it's a typical aggregate function that returns the number of characters you want.
