
Реализуйте функцию `normalize_url()`, которая выполняет нормализацию данных. Она принимает адрес сайта и возвращает его с `https://` в начале.

Функция принимает адреса в виде `АДРЕС` или `http://АДРЕС`, но всегда возвращает адрес в виде `https://АДРЕС`. На вход функции также может поступить адрес в уже нормализованном виде `https://АДРЕС`, в этом случае ничего менять не надо.

Примеры вызова:

```python
print(normalize_url('https://ya.ru'))  # => 'https://ya.ru'
print(normalize_url('google.com'))     # => 'https://google.com'
print(normalize_url('http://ai.fi'))   # => 'https://ai.fi'
```

Есть несколько способов решить задачу. Один из них — сравнивать первые 7 символов строки-аргумента со строкой `http://`, а потом на основе этого добавлять или не добавлять к ней `https://`.

Также вам скорее всего потребуется отбросить ненужную часть в начале строки. Помните, мы рассматривали способ получения кусочка от строки с помощью среза? Если нет, напоминаю:

```python
# Берём 6 символов от начала
print('Winterfell'[:6])  # => 'Winter'
```

Так вот, с помощью срезов можно также отбросить определённое количество символов:

```python
# Отбрасываем первые 6 символов
print('Winterfell'[6:])  # => 'fell'
```
