
Наряду с логическими операторами **И** и **ИЛИ**, часто используется операция «**отрицание**». Она меняет логическое значение на противоположное. В программировании отрицанию соответствует унарный оператор `not`:

```python
not True   # False
not False  # True
```

Например, если есть функция, которая проверяет четность числа, то с помощью отрицания можно выполнить проверку нечетности:

```python
def is_even(number):
    return number % 2 == 0

print(is_even(10))      # => True
print(not is_even(10))  # => False
```

В примере выше мы добавили `not` слева от вызова функции и получили обратное действие.

Отрицание — инструмент, с которым можно выражать задуманные правила в коде и не писать новые функции.

Если написать `not not is_even(10)`, то код сработает даже в таком случае:

```python
print(not not is_even(10))  # => True
```

https://replit.com/@hexlet/python-basics-logic-logical-negation

В логике двойное отрицание — это отсутствие отрицания:

```python
not not True   # True
not not False  # False

print(not not is_even(10))  # => True
print(not not is_even(11))  # => False
```

Теперь вы знаете, что означают операторы **И**, **ИЛИ** и `not`. С их помощью вы сможете задавать составные условия из двух и более логических выражений.
