
Мы уже умеем писать функции, которые проверяют одиночные условия. А в этом уроке научимся строить составные условия.

Предположим, что сайт при регистрации требует, чтобы пароль был длиннее восьми символов и содержал хотя бы одну заглавную букву. Попробуем написать два отдельных логических выражения и соединим их специальным оператором «И»:

> Пароль длиннее 8 символов **И** пароль содержит хотя бы одну заглавную букву

Вот функция, которая принимает пароль и говорит, соответствует ли он условиям (`True`) или не соответствует (`False`):

```python
def has_capital_letter(string):
    # Проверяет наличие хотя бы одной заглавной буквы в строке

def is_correct_password(password):
   length = len(password)
   return length > 8 and has_capital_letter(password)

print(is_correct_password('Qwerty'))                   # => False
print(is_correct_password('Qwerty1234'))               # => True
print(is_correct_password('qwerty1234'))               # => False
```

`and` — означает «И». В математической логике это называют конъюнкцией. Все выражение считается истинным, если истинен каждый **операнд** — каждое из составных выражений. Иными словами, `and` означает «и то, и другое». Приоритет этого оператора ниже, чем приоритет операторов сравнения. Поэтому выражение `has_capital_letter(password) and length > 8` тоже правильно отрабатывает без скобок.

Кроме `and` часто используется оператор `or` — «ИЛИ» (дизъюнкция). Он означает «или то, или другое, или оба». Выражение `a or b` считается истинным, если хотя бы один из операндов или одновременно все — истинные. В другом случае выражение ложное.

Операторы можно комбинировать в любом количестве и любой последовательности. Если в коде одновременно встречаются `and` и `or`, то приоритет лучше задавать скобками. Ниже пример расширенной функции, которая определяет корректность пароля:

```python
def has_capital_letter(string):
    # Проверяет наличие хотя бы одной заглавной буквы в строке
def has_special_chars(string):
    # Проверяет содержание специальных символов в строке

def is_strong_password(password):
    length = len(password)
    # Скобки задают приоритет. Понятно, что к чему относится.
    return (length > 8 and has_capital_letter(password)) and has_special_chars(password)
```

Теперь представим, что мы хотим купить квартиру, которая удовлетворяет таким условиям: площадь от 100 квадратных метров и больше на любой улице **ИЛИ** площадь от 80 квадратных метров и больше, но на центральной улице `Main Street`.

Напишем функцию, которая проверит квартиру. Она принимает два аргумента: площадь — число и название улицы — строку:

```python
def is_good_apartment(area, street):
    return area >= 100 or (area >= 80 and street == 'Main Street')

print(is_good_apartment(91, 'Queens Street'))  # => False
print(is_good_apartment(78, 'Queens Street'))  # => False
print(is_good_apartment(70, 'Main Street'))    # => False

print(is_good_apartment(120, 'Queens Street'))  # => True
print(is_good_apartment(120, 'Main Street'))    # => True
print(is_good_apartment(80, 'Main Street'))     # => True
```

https://replit.com/@hexlet/python-basics-logic-logical-operators

Область математики, в которой изучаются логические операторы, называется булевой алгеброй. Ниже увидите **таблицы истинности** — по ним можно определить, каким будет результат, если применить оператора:

#### И `and`

| A     | B     | A and B  |
| ----- | ----- | -------  |
| True  | True  | **True** |
| True  | False | False    |
| False | True  | False    |
| False | False | False    |

#### ИЛИ `or`

| A     | B     | A or B   |
| ----- | ----- | -------- |
| True  | True  | **True** |
| True  | False | **True** |
| False | True  | **True** |
| False | False | False    |
