
**Логические операции** — это выражения, значит, их можно комбинировать с другими выражениями. Например, мы хотим проверить четность числа — кратность двум. В программировании используют такой подход: проверяют остаток от деления на два:

* если остаток `0` — число четное
* если остаток не `0` — число нечетное

Остаток от деления — простая, но важная концепция в арифметике, алгебре, в теории чисел и криптографии. Нужно разделить число на несколько равных групп, и если в конце что-то останется — это остаток от деления.

Делим конфеты поровну между людьми:

* 7 конфет, 2 человека: 2 x 3 + остаток 1 — 7 не кратно 2
* 21 конфету, 3 человека: 3 x 7 + остаток 0 — 21 кратно 3
* 19 конфет, 5 человек: 5 x 3 + остаток 4 — 19 не кратно 5

Оператор `%` вычисляет остаток от деления:

* `7 % 2` → `1`
* `21 % 3` → `0`
* `19 % 5` → `4`

Скомбинируем в одном выражении логический оператор «проверка равенства» `==` и арифметический оператор `%` и напишем функцию проверки четности:

```python
def is_even(number):
    return number % 2 == 0

print(is_even(10))  # => True
print(is_even(3))   # => False
```

Приоритет арифметических операций выше логических. Значит, сначала вычисляется арифметическое выражение `number % 2`, а затем результат сравнивается с нулем и возвращается результат проверки равенства.

Теперь напишем функцию, которая принимает строку и проверяет, начинается ли эта строка с латинской буквы `a`.

Алгоритм:

1. Получим и запишем в переменную первый символ из строки-аргумента
2. Сравним, равен ли символ латинской букве `a`
3. Вернем результат

```python
def is_first_letter_an_a(string):
    first_letter = string[0]
    return first_letter == 'a'

print(is_first_letter_an_a('orange'))  # => False
print(is_first_letter_an_a('apple'))   # => True
```

https://replit.com/@hexlet/python-basics-logic-combine-expression

Чтобы было понятно, что тут происходит, попробуйте проговорить происходящее аналогично тому, как мы расшифровывали процесс в примере с `is_even()`.

Теперь вы знаете, что операции сравнения применяются в программировании наравне с арифметическими. Но помните, что равенство обозначается `==`. Так вы не спутаете эту операцию с присваиванием значения переменной.
