
**Logical operations** are expressions, which means they can be combined with other expressions. For example, if we want to check if a number is odd or even. The approach used in programming is to check the remainder of a division by two:

* if the remainder is `0`, it's an even number
* if the remainder isn't `0`, it's an odd number

The remainder of division is a simple but important concept in arithmetic, algebra, number theory, and cryptography. You need to divide the number into several equal groups, and if there's something left over at the end, it's the remainder of the division.

Split some candies equally among individuals:

* 7 candies, 2 people: 2 x 3 + a remainder of 1 - 7 is not a multiple of 2
* 21 candy, 3 people: 3 x 7 + a remainder of 0 - 21 is a multiple of 3
* 19 candies, 5 people: 5 x 3 + a remainder of 4 - 19 is not a multiple of 5

The `%` operator calculates the remainder of the division:

* `7 % 2` → `1`
* `21 % 3` → `0`
* `19 % 5` → `4`

Let's combine the equality check `==` and the arithmetic operator `%` into one expression and write a function that checks if a number is odd or even:

```python
def is_even(number):
    return number % 2 == 0

print(is_even(10))  # => True
print(is_even(3))   # => False
```

Arithmetic operators have higher priority than logical ones. So, first the arithmetic expression `number % 2` is calculated and the result is compared to zero, then the result of the equality check is returned.

Now write a function that takes a string and checks if the string starts with the letter `a`.

Algorithm:

1. Get the first character of the argument string, and write it to the variable
2. Compare whether the symbol is equal to the letter `a`.
3. Return the result

```python
def is_first_letter_an_a(string):
    first_letter = string[0]
    return first_letter == 'a'

print(is_first_letter_an_a('orange'))  # => False
print(is_first_letter_an_a('apple'))   # => True
```

To make it clear what's going on here, try saying what's going on in the same way as we decoded the process in the `is_even()` example.

You now know that comparison operations are used in programming alongside arithmetic operations. But remember that equality is indicated using this symbol: `==`. This way, you won't confuse this operation with assigning a value to a variable.
