
Кроме арифметических операций в математике есть операции сравнения, например, `5 > 4` или `3 < 1`. Они есть и в программировании. Допустим, когда мы заходим на сайт, введенные логин и пароль сравниваются с теми, какие есть в базе. Если они есть, нас пускают внутрь — аутентифицируют. В этом уроке разберем операции сравнения.

Языки программирования адаптировали все математические операции сравнения в неизменном виде, кроме операторов равенства и неравенства. В математике для этого используется обычное равно `=`, но в программировании такое встречается редко.

Во многих языках символ `=` используется, чтобы присвоить переменным значения. Поэтому в Python сравнивают с помощью `==`.

Список операций сравнения:

* `<`  — меньше
* `<=` — меньше или равно
* `>`  — больше
* `>=` — больше или равно
* `==` — равно
* `!=` — не равно

Эти операции применяются не только к числам. Например, с помощью оператора равенства можно сравнить строки: `password == text` — это сравнение идентичности строк, которые записаны в разных переменных.

Логическая операция типа `5 > 4` или `password == text` — это выражение. Его результат — специальное значение `True` («истина») или `False` («ложь»). Это новый для нас тип данных — `bool`.

```python
result = 5 > 4
print(result)  # => True
print('one' != 'one')  # => False
```

Наряду со строками (`str`) и целыми и рациональными числами, **тип `bool` (булев)** — это один из примитивных типов данных в Python.

Попробуем написать простую функцию, которая принимает на вход возраст ребенка и определяет, младенец ли он. Младенцами считаются дети до года:

```python
def is_infant(age):
    return age < 1

print(is_infant(3))  # => False
```

https://replit.com/@hexlet/python-basics-logic-bool-type

Любая операция — это выражение, поэтому единственной строчкой функции пишем «вернуть то значение, которое получится в результате сравнения `age < 1`». В зависимости от того, какой аргумент пришел, сравнение будет истинным (`True`) или ложным (`False`), а `return` вернет этот результат.

А теперь проверим ребенка, которому полгода:

```python
print(is_infant(0.5))  # => True
```

Результат операции `True`. Значит, ребенок действительно младенец.
