
В программировании у многих функций и методов есть параметры, которые редко меняются. В таких случаях этим параметрам задают значения по умолчанию, которые можно поменять по необходимости. С помощью этого сокращается количество одинакового кода. Рассмотрим, как это выглядит на практике.

Разберем пример:

```python
# Функция возведения в степень
# Второй параметр имеет значение по умолчанию два
def pow(x, base=2):
    return x ** base

# Три во второй степени (двойка задана по умолчанию)
pow(3)  # 3 * 3 = 9
# Три в третьей степени
pow(3, 3)  # 3 * 3 * 3 = 27
```

https://replit.com/@hexlet/python-basics-define-functions-default-parameters

Значение по умолчанию выглядит как обычное присваивание в определении. Оно срабатывает только в том случае, если параметр не передали.

Представьте, что вы не привезли с собой в автосервис запчасти для вашего автомобиля. Тогда автомеханик предложит вам поставить те, которые есть у него — по умолчанию.

Значение по умолчанию может быть даже в том случае, когда параметр один:

```python
def my_print(text='nothing'):
    print(text)

my_print()  # => "nothing"
my_print("Hexlet")  # => "Hexlet"
```

Параметров со значениями по умолчанию может быть любое количество:

```python
def f(a=5, b=10, c=100):
```

У значений по умолчанию есть одно ограничение. Они должны идти в самом конце списка параметров. С точки зрения синтаксиса, невозможно создать функцию, у которой после необязательного параметра идет обязательный:

```python
# Такой код завершится с ошибкой
def f(a=5, b=10, c=100, x):
# И такой
def f(a=5, b=10, x, c=100):

# Этот код сработает
def f(x, a=5, b=10, c=100):

# Этот тоже сработает
def f(x, y, a=5, b=10, c=100):
```

Теперь вы умеете работать со значениями параметров по умолчанию. Они могут быть как у нескольких параметров, так и у одного. И помните, что значения по умолчанию должны быть в самом конце списка параметров. Эти знания помогут сократить количество одинакового кода.
