
Функции могут не только возвращать значения, но и принимать параметры. В этом уроке мы научимся создавать такие функции.

Напомним, что с параметрами функций мы уже сталкивались:

```python
# Принимает на вход один параметр любого типа
print('я параметр')
# Принимает на вход два строковых параметра
# первый — что ищем, второй — на что меняем
'google'.replace('go', 'mo')  # moogle
# Принимает на вход два числовых параметра
# первый — округляемое число, второй — число знаков после запятой, которые нужно оставить
round(10.23456, 3)  # 10.235
```

А теперь представим, что нам нужно реализовать функцию `get_last_char()`, которая возвращает последний символ в строке, переданной ему на вход как параметр.

Вот как будет выглядеть использование этой функции:

```python
# Передача параметров напрямую без переменных
get_last_char("Hexlet")  # t
# Передача параметров через переменные
name1 = 'Hexlet'
get_last_char(name1)  # t
name2 = 'Goo'
get_last_char(name2)  # o
```

Из этого примера можно сделать следующие выводы:

* Нам нужно определить функцию `get_last_char()`
* Функция должна принимать на вход один параметр строкового типа
* Функция должна возвращать значение строкового типа

Определяем функцию:

```python
def get_last_char(text):
    return text[-1]
```

В скобках указывается имя переменной `text`, которая служит параметром. Имя параметра может быть любым. Главное, чтобы оно отражало смысл значения, которое содержится внутри. Например:

```python
def get_last_char(string):
    return string[-1]
```

Значение параметра будет зависеть от вызова этой функции:

```python
# Внутри функции string будет равна 'hexlet'
get_last_char('hexlet')  # t

# Внутри функции string будет равна 'code'
get_last_char('code')  # e

# Внутри функции string будет равна 'Winter is coming'
# Имя переменной снаружи не связанно с именем переменной в определении функции
text = 'Winter is coming'
get_last_char(text)  # g
```

https://replit.com/@hexlet/python-basics-define-functions-parameters

Параметр нужно обязательно указывать. Если вызвать функцию без него, то интерпретатор выдаст ошибку:

```python
get_last_char()  # У такого кода нет смысла

TypeError: get_last_char() missing 1 required positional argument: 'string'
```

Многие функции работают одновременно с несколькими параметрами. Например, чтобы округлить числа, нужно указать не только само число, но и количество знаков после запятой:

```python
round(10.23456, 3)  # 10.235
```

То же самое относится и к методам. Они могут требовать на вход любое количество параметров, которое им нужно для работы:

```python
# Первый параметр — что ищем
# Второй параметр — на что меняем
'google'.replace('go', 'mo')  # moogle
````

Чтобы создать такие функции и методы, в определении нужно указать необходимое количество параметров через запятую. Еще им нужно дать понятные имена.

Ниже пример определения функции `replace()`, которая заменяет в слове одну часть строки на другую:

```python
def replace(text, from, to):
    # Здесь тело функции, но мы его
    # опускаем, чтобы не отвлекаться

replace('google', 'go', 'mo')  # moogle
```

Когда параметров два и более, то практически для всех функций важен порядок передачи этих параметров. Если его поменять, то функция отработает по-другому:

```python
# Ничего не заменилось,
# так как внутри google нет mo
replace('google', 'mo', 'go')  # google
```

Теперь вы знаете, как создавать функции, которые могут принимать на вход параметры.
