
С помощью определения собственных функций писать и поддерживать программы проще. Они позволяют объединять составные операции в одну. Поэтому в этом уроке поговорим, как создавать собственные функции.

Допустим, мы хотим отправить письма на сайте — это достаточно сложный процесс, который включает взаимодействие с внешними системами. Но если определить функцию, вся сложность скроется за одной простой функцией:

```python
# Гипотетический пример
# Место откуда берется функция
from emails import send

email = 'support@hexlet.io'
title = 'Помогите'
body = 'Я написал историю успеха, как я могу получить скидку?'

# Один маленький вызов — много логики внутри
send(email, title, body)
```

Внутри себя этот вызов выполняет много логики: соединяется с почтовым сервером, формирует правильный запрос на основе заголовка и тела сообщения, а затем все отправляет, не забыв закрыть соединение.

Создадим нашу первую функцию. Ее задача — вывести на экран приветствие:

```bash
Hello, Hexlet!
```

```python
# Определение функции
# Определение не вызывает и не выполняет функцию
# Мы лишь говорим, что теперь такая функция существует
def show_greeting():
    # Внутри тела отступ четыре пробела
    text = 'Hello, Hexlet!'
    print(text)

# Вызов функции
show_greeting()  # => 'Hello, Hexlet!'
```

https://replit.com/@hexlet/python-basics-define-function

В отличие от обычных данных, функции выполняют действия. Поэтому их имена нужно указывать через глаголы: «построить что-то», «нарисовать что-то», «открыть что-то».

Описание, которое находится ниже имени функции с отступом, называется **телом функции**. Внутри тела можно описывать любой код. Это как небольшая самостоятельная программа — набор произвольных инструкций.

Тело выполняется в тот момент, когда запускается функция. При этом каждый вызов функции запускает тело независимо от других вызовов.

Тело функции может быть пустым, тогда внутри него используется ключевое слово `pass`:

```python
# Минимальное определение функции
def noop():
    pass

noop()
```

У понятия «создать функцию» много синонимов: «реализовать», «определить» и даже «заимплементить». Они часто встречаются на практике. Создавая свою функцию, вы облегчите сложные операции и сделаете разработку проще.
