
В этом уроке мы рассмотрим, как комбинировать различные подходы, когда пишем код, а также разберем типичные ошибки новичков.

У нас есть следующий код:

```python
name = 'Tirion'
print(name.upper().lower())  # => `tirion`
```

Он напечатал на экране `tirion`.

Синтаксис нескольких подряд идущих точек мы видим впервые, но все операции, которые здесь встречаются, нам знакомы. В этом коде объединились известные возможности языка.

Такое в программировании происходит часто. Если вы не знаете синтаксис, то можно все равно пробовать комбинировать различные подходы, и есть вероятность, что они заработают.

Чтобы понять, как работает этот код, нужно разбить цепочку на отдельные операции:

```python
name = 'Tirion'
upper_name = name.upper()  # 'TIRION'
print(upper_name.lower())  # 'tirion'
```

Первый и второй примеры эквивалентны. Мы можем выполнять операции последовательно с промежуточным созданием переменных, а можем строить непрерывную цепочку из атрибутов и методов. В цепочках вычисления всегда идут слева направо.

Еще один пример для закрепления:

```python
name = 'Tirion'
print(name.replace('Ti', 'Ki').lower())  # => ?
```

Над этим кодом нужно хорошо подумать. `.lower()` применяется к результату вызова метода, который находится левее. А метод `replace()` возвращает строку. Новички часто делают ошибки в цепочках с методами и забывают ставить вызов:

```python
name = 'Tirion'
# Этот код отработает неверно!
print(name.upper.lower())
```

Также возможно строить бесконечно длинные и бесполезные цепочки, которые включают в себя срезы:

```python
name = 'Tirion'
# Чему равен результат такого вызова?
print(name[1:5].upper().find('I'))
```

С функциями это не сработает, так как обычно они вкладываются друг в друга — `f(f(f()))`. Это значительно ухудшает анализ. Но это не значит, что нельзя сделать красиво. В других языках это реализуется через композицию функций или пайплайн-оператор.
