
En esta lección veremos cómo combinar diferentes enfoques al escribir código, así como también analizaremos los errores típicos de los principiantes.

Tenemos el siguiente código:

```python
name = 'Tirion'
print(name.upper().lower())  # => `tirion`
```

Imprime en la pantalla `tirion`.

Es la primera vez que vemos la sintaxis de varios puntos seguidos, pero todas las operaciones que aparecen aquí nos son familiares. En este código se combinan las capacidades conocidas hasta el momento del lenguaje estudiado.

Esto ocurre a menudo en la programación. Si no conoces la sintaxis, aún puedes intentar combinar diferentes enfoques y existe la posibilidad de que funcionen.

Para entender cómo funciona este código, debemos descomponer la cadena de llamadas en operaciones individuales:

```python
name = 'Tirion'
upper_name = name.upper()  # 'TIRION'
print(upper_name.lower())  # 'tirion'
```

Los primeros dos ejemplos son equivalentes. Podemos realizar operaciones secuencialmente con la creación intermedia de variables, o podemos construir una cadena continua de atributos y métodos. En las cadenas de llamadas, los cálculos siempre se realizan de izquierda a derecha.

Otro ejemplo para reforzar el concepto:

```python
name = 'Tirion'
print(name.replace('Ti', 'Ki').lower())  # => ?
```

Necesitamos pensar bien en este código. `.lower()` se aplica al resultado de la llamada al método que está a la izquierda. Y el método `replace()` devuelve una cadena. Los principiantes a menudo cometen errores en las cadenas de llamadas y olvidan hacer la ejecución:

```python
name = 'Tirion'
# ¡Este código no funcionará correctamente!
print(name.upper.lower())
```

También es posible construir cadenas infinitamente largas e inútiles que incluyen listas o slices:

```python
name = 'Tirion'
# ¿Cuál es el resultado de esta ejecución?
print(name[1:5].upper().find('I'))
```

Esto no funciona con las funciones, ya que generalmente se anidan unas dentro de otras: `f(f(f()))`. Esto dificulta mucho el análisis. Pero esto no significa que no se pueda hacer de manera elegante. En otros lenguajes, esto se logra a través de la composición de funciones o el operador de canalización.
