
У данных, которыми мы оперируем в программах, есть важные атрибуты. В Python они встроены прямо в язык. Еще у данных есть методы — функции внутри свойств. Свойства и методы — такие же выражения, как переменные или вызовы функции. Все это можно по-разному комбинировать. В этом уроке изучим их основы.

В программировании мы оперируем данными, создаем числа и строки, выполняем над ними различные операции и используем полученный результат. Чтобы выполнить операцию, мы применяем либо операторы, либо функции:

```python
# Сложение с помощью оператора +
1 + 3 # 4

# Подсчет длины с помощью функции len()
name = 'Hexlet'
len(name)  # 6
```

В примере выше есть четкое разделение: данные отдельно, функции отдельно. Но это не единственный способ организации кода. В Python наравне с таким разделением, используется и другой подход — **объектно-ориентированный (ОО)**.

Объектно-ориентированный код строится на объединении данных и функций в одну сущность — **объект**. Данные в таком случае называются атрибутами, а функции — методами.

Так это выглядит:

```python
name = 'Hexlet'
# Метод upper()
upper_name = name.upper()
print(upper_name)  # => 'HEXLET'
```

Строки в Python — это объекты. В примере выше мы вызываем метод, то есть функцию, которая связана со строкой. Вызов происходит через точку, которая идет сразу за именем переменной. В остальном методы работают как обычные функции.

Также вызов можно делать и напрямую:

```python
'Hexlet'.upper()  # 'HEXLET'
```

В строки встроено много методов, которые постоянно нужны разработчику. Посмотреть их список можно в [документации](https://python.readthedocs.io/en/latest/library/stdtypes.html#string-methods). Вот несколько полезных примеров:

```python
name = 'Python'

# Возвращает индекс первого вхождения буквы в строку
name.find('t')  # 2

# Переводит в нижний регистр
name.lower()  # 'python'

# Заменяет одну подстроку другой
name.replace('on', 'off')  # 'Pythoff'
```

То же самое касается чисел и остальных типов данных, которые мы пока не изучали. Можно сказать, что в Python почти все — объекты:

```python
x = -5
# Возвращает модуль числа
# Имя выглядит странно, но это действительно имя метода
x.__abs__()
```

В примере выше есть имя метода с двумя подчеркиваниями в начале и в конце. В Python так называют методы, которые не предназначены для прямого вызова. Для них создали функции, которые внутри себя уже сами вызывают методы:

```python
x = -5
abs(x)  # вызывает x.__abs__()
# -5 в 3 степени
pow(x, 3)  # вызывает x.__pow__(3)
```

Создатель Python [решил](https://stackoverflow.com/questions/83983/why-isnt-the-len-function-inherited-by-dictionaries-and-lists-in-python), что будет нагляднее, если математические или похожие на математические операции выразить функциями. Он хотел, чтобы такие функции воспринимались как операции, типа сложения или вычитания. Так привычнее для тех, кто изучал математику.

Так же работает и функция `len()`:

```python
len('Hexlet')  # Вызывает 'Hexlet'.__len__()
```

Кроме методов у объектов есть атрибуты, но у встроенных в Python объектов их мало. Например, атрибут `__doc__`, который возвращает документацию функции. Поэтому функции тоже считаются объектами:

```python
len.__doc__ # 'Return the number of items in a container.'
```

Атрибуты работают и выглядят как переменные, только указываются через точку после объекта.
