
Python comes with a set of useful functions that make up the **standard library**. It usually includes thousands of functions that are impossible to remember. So the programmer needs to know where to find documentation on these functions, as well as have an idea of the result he or she wants to get. For these reasons, it is difficult to program without the Internet.

Beginners often do not understand how and where to find out about the functions to be used. There is no way to solve this problem. As they work, developers become more experienced and add to their knowledge and practice. Gradually they become familiar with more interesting features that solve their problems differently.

Here are tips to help increase professionalism:

* Always keep track of which data type you are working with. That way, you will find the function you need in the appropriate section of the documentation. For example, to work with strings, you have to learn string functions

* Periodically open a section with standard features on your topic, learn the signatures and how to use them

* Read other people's code on GitHub more often. Pay special attention to the code of the libraries you use

If you follow these tips and pay close attention to detail, you will soon notice how you develop and grow as a professional.
