
У функций внутри каждого языка программирования есть фундаментальные свойства. Эти свойства помогают прогнозировать поведение функций, способы их тестирования и место использования. К таким свойствам относится детерминированность.

Детерминированная функция возвращает один и тот же результат для одинаковых входных параметров. Например, детерминированной можно назвать функцию, которая считает количество символов:

```python
len('hexlet')  # 6
len('hexlet')  # 6

len('wow')  # 3
len('wow')  # 3
```

Можно бесконечно вызывать эту функцию и передавать туда значение `'hexlet'` — она всегда вернет `6`.

Посмотрим и обратный случай — недетерминированные функции. Например, к этой категории относится функция, которая возвращает случайное число: у одного и того же входа мы получим всегда разный результат. Если хотя бы один из миллиона вызовов функция вернет другой результат, она считается недетерминированной. Это работает и в том случае, если параметры не принимаются:

```python
# Синтаксис импортов будет изучаться позже на Хекслете
from random import random

# Функция, которая возвращает случайное число
random()  # 0.09856613113197676
random()  # 0.8839904367241888
```

Детерминированность — это важное свойство функции, так как она влияет на многие аспекты. Например, детерминированные функции удобны в работе — их легко оптимизировать и тестировать. Если возможно, то лучше сделать функцию детерминированной.
