
В этом уроке мы разберем функцию `max()`, а также посмотрим, как она работает в Python.

У некоторых функций есть особенность — они принимают переменное число параметров. И мы говорим не о значениях по умолчанию. Посмотрите на этот пример:

```python
max(1, 10, 3)  # 10
```

В примере выше функция `max()` находит максимальное значение среди переданных параметров. Чтобы узнать, сколько параметров можно передавать на вход, нужно изучить [документацию](https://docs.python.org/3/library/functions.html?highlight=pow#max) этой функции. Там мы увидим такую конструкцию:

```
max(arg1, arg2, *args[, key])
```

Это значит, что `max()` принимает на вход два параметра и больше:

```python
max(1, -3, 2, 3, 2)  # 3
```

Если функция найдет несколько параметров с максимальным значением, значит, она вернет самый первый из них.
