
Продолжаем разбираться с функцией и ее составляющими. Сегодня на очереди выражение. Рассмотрим, что это такое и можно ли вызов функции принять за выражение.

Выражение в программировании возвращает результат, который можно использовать. Скорее всего, вы уже знаете многое о выражениях и принципах, по которым они строятся. Например, такие математические операции, как сложение и вычитание, строковые операции, как конкатенация — все это выражения:

```python
1 + 5 * 3
'He' + 'Let'
# Переменные могут быть частью выражения
rate * 5
```

Особенность выражений в том, что они возвращают результат, который можно использовать дальше: например, присвоить переменной или вывести на экран. Так это выглядит в коде:

```python
# Тут выражение это 1 + 5
sum = 1 + 5
print(1 + 5)
```

Но не все в программировании выражение. Определение переменной — это инструкция, а значит она не может быть частью выражения. То есть такой код выдаст ошибку:

```python
# Бессмысленный код, который не сработает
10 + sum = 1 + 5
```

Теперь разберемся, принимается ли за выражение вызов функции.

Мы знаем, что функции возвращают результат — значит, они выражения. Из этого автоматически следует много интересного. Например, мы можем использовать вызов функции прямо в математических операциях. Вот как можно получить индекс последнего символа в слове:

```python
name = 'python'
# Индексы начинаются с нуля
# Вызов функции и вычитание вместе!
last_index = len(name) - 1
print(last_index)  # => 5
```

В этом коде нет нового синтаксиса. Мы всего лишь соединили уже известные части, опираясь на их природу. Можно пойти еще дальше:

```python
print(len(name) - 1)  # => 5
```

Все это справедливо для любых функций, например строковых:

```python
name = 'python'
# Используется интерполяция
print(f'Последний символ: {name[len(name) - 1]}')
# 'Последний символ: n'
```

Как вы увидите дальше, выражения можно комбинировать, получая все более сложное поведение в разных местах и любым образом. Чем глубже вы будете изучать Python и практиковаться в нем, тем лучше вы будете понимать работу с выражениями. Со временем вы поймете, как соединять части кода, чтобы получить нужный результат.
