
Рассмотрим функцию `round()`, которая округляет переданное ей число:

```python
result = round(10.25, 0)  # 10.0
```

Мы передали в нее два параметра:

* Число, которое нужно округлить
* Точность округления

`0` означает, что округление будет до целого значения. Чаще всего нужно округлять именно до целого числа, а не до десятых. Поэтому создатели функции `round` сделали второй параметр **необязательным** и задали ему внутри функции **значение по умолчанию `0`**. Значит, можно не указывать второй параметр, а результат будет тем же:

```python
result = round(10.25)  # 10.0
```

А если нужна другая точность, то можно передать параметр:

```python
# округление до одного знака после запятой
result = round(10.25, 1)  # 10.2
```

Если функция в Python принимает необязательные аргументы, то они всегда стоят после обязательных. Их количество может быть любым. Это зависит от самой функции, но они всегда идут рядом и в конце списка аргументов.
