
Сложение, конкатенация, нахождение остатка от деления и остальные рассмотренные операции — это базовые возможности языков программирования. Математика не ограничена арифметикой, кроме нее есть и другие разделы со своими операциями ⎯ например, геометрия. То же самое касается и строк: их можно переворачивать, менять регистр букв, удалять лишние символы — и это только самое простое.

Еще на более высоком уровне есть прикладная логика конкретного приложения. Программы списывают деньги, считают налоги, формируют отчеты. Количество подобных операций бесконечно и индивидуально для каждой программы. И их нужно уметь выражать в коде.

Чтобы выразить любую произвольную операцию, в программировании существует понятие **функция**. Функции бывают встроенные и добавленные программистом. С одной встроенной функцией мы уже знакомы ⎯ это `print()`.

Функции — одна из ключевых конструкций в программировании. Без них невозможно сделать практически ничего. Знакомство с ними нужно начинать как можно раньше, так как весь дальнейший материал оперирует функциями по максимуму. Сначала мы научимся пользоваться уже созданными функциями, а потом научимся создавать собственные.

Начнем с простых функций для работы над строками.

Функция `len()` считает количество символов в строке. Ниже пример ее вызова:

```python
# Вызов функции len с параметром 'Hello!'
result = len('Hello!')
print(result)  # => 6
```

**Параметры или аргументы** — это информация, которую функция получает при вызове. На основе этой информации функция обычно вычисляет и выдает результат.

Мы создали переменную `result` и указали интерпретатору конкретное действие: надо записать в нее результат, который возвращается функцией `len()` при ее вызове. В этом смысле функции подобны операциям — они всегда возвращают результат своей работы. Запись `len('Hello!')` означает, что вызывается функция с именем *len*, в которую передали параметр `'Hello!'`. Функция `len()` считает длину той строки, которую ей передали.

Вызов функции всегда обозначается скобками `()`, которые идут сразу за именем функции. В скобках может быть любое количество параметров, а иногда ни одного. Количество зависит от используемой функции.

Возьмем для примера функцию `pow()`, которая возводит указанное число в нужную степень. Она принимает на вход два параметра: берет первый параметр и возводит его в степень, переданную вторым параметром:

```python
result = pow(2, 3)  # 2 * 2 * 2
print(result)  # => 8
```

Мы разобрались, как пользоваться простыми встроенными функциями. Но это не весь их перечень. Больше о функциях вы узнаете в следующих уроках
