
В программировании регулярно встречаются задачи, когда один тип данных нужно преобразовать в другой — например, при работе с формами на сайтах. Данные формы всегда приходят в текстовом виде, даже если значение — число. Вот как его можно преобразовать:

```python
# str станет int
number = int('345')
print(number)  # => 345
```

`int()` — это функция, в которую передается значение, чтобы его преобразовать. Функция ведет себя подобно арифметическим операциям, но делает особые действия. Вот еще несколько примеров:

```python
value = '0'
# Внутри скобок можно указывать переменную
converted_value = int(value)
print(converted_value)  # => 0

# Или конкретное значение
converted_value2 = int('10')
print(converted_value2)  # => 10

converted_value3 = int(False)
print(converted_value3)  # => 0

converted_value4 = int(True)
print(converted_value4)  # => 1

# Если преобразуется число с плавающей точкой
# то отбрасывается вся дробная часть
converted_value5 = int(3.5)
print(converted_value5)  # => 3
```

https://replit.com/@hexlet/python-basics-data-types-casting

Точно так же можно преобразовать данные в строки `str()` и число с плавающей точкой `float()`:

```python
value = str(10)
print(value)  # '10'

value2 = str(True)
print(value2)  # 'True'

value3 = float(5)
print(value3)  # 5.0
```

Некоторые преобразования Python выполняет автоматически. Например, в операциях, где встречается одновременно целое число и число с плавающей точкой. Python автоматически все приводит к **float** — числу с плавающей точкой:

```python
# Неявно выполняется код float(3) + 1.2
value = 3 + 1.2
print(value)  # => 4.2
```
