
Представим, что нам нужно изменить символ в строке. Вот, что из этого выйдет:

```python
first_name = 'Alexander'
first_name[0] = 'B'
# Ошибка: TypeError: 'str' object does not support item assignment
```

Такое происходит из-за неизменяемости примитивных типов в Python — язык не дает никакой физической возможности поменять строку. Неизменяемость примитивных типов важна по многим причинам. Ключевая причина — производительность.

Но иногда нам нужно изменить строку. Для этого и существуют переменные:

```python
first_name = 'Alexander'
first_name = 'Blexander'
print(first_name)  # => Blexander
```

Есть большая разница между *изменением значения переменной* и *изменением самого значения*. Примитивные типы в Python поменять нельзя, а составные — можно. Также можно без проблем заменить значение переменной.
