
Python — один из языков, который строго относится к типам данных. Поэтому на любую несовместимость типов он ответит ошибкой. Все дело в сильной типизации.

Нам известно про два разных типа данных: числа и строки. Например, мы могли складывать числа, потому что операция сложения — это операция для типа «числа». А что, если применить эту операцию не к двум числам, а к числу и строке?

```python
print(1 + '7')  # TypeError: unsupported operand type(s)...
```

Python не разрешит сложить число `1` и строку `'7'`, потому что это значения разных типов. Нужно сначала либо сделать строку числом, либо число строкой. Как это сделать, мы поговорим позже.

Такое педантичное отношение к совместимости типов называется **строгой типизацией** или **сильной типизацией**. Python — язык со строгой типизацией.

Не все языки так делают. Например, PHP — это язык со **слабой типизацией**. Он знает о существовании разных типов, но относится к их использованию не очень строго. PHP пытается преобразовывать информацию, когда это кажется разумным. То же самое относится к JavaScript:

```javascript
// Как тебе такое, Илон Маск?
// Число 1 + Строка 7 = Строка 17
1 + '7'; // '17'
```

С одной стороны, автоматическое неявное преобразование типов и правда кажется удобным. Но на практике это свойство языка создает множество ошибок и проблем, которые трудно найти. Код может иногда работать, а иногда не работать — в зависимости от того, «повезло» ли с автоматическим преобразованием. Программист это заметит не сразу и потратит много времени на отладку.
