
Бывают разные способы представлять данные в программах. Есть **строки** — наборы символов в кавычках вроде `"Hello, World!"`. Есть **целые числа** — например, `7`, `-198`, `0`. Это две разные категории информации — два разных **типа данных**. Операция умножения имеет смысл для категории «целые числа», но не для категории «строки»: нет смысла умножать слово «мама» на слово «блокнот».

Тип данных определяет, что можно делать с элементами конкретного множества информации. В этом уроке мы изучим типы данных и узнаем, как работает типизация в Python.

Язык программирования распознает типы данных, поэтому Python не позволит нам умножать строку на строку — нельзя умножать текст на текст. При этом можно умножать целое число на другое целое число. Наличие типов и таких ограничений в языке защищает программы от случайных ошибок.

В отличие от строк, числа оборачивать в кавычки не нужно. Чтобы напечатать число 5, достаточно написать:

```python
print(5)  # => 5
```

Число `5` и строка `'5'` — совершенно разные вещи, хотя вывод у `print()` для этих данных идентичный. Целые числа (`1`, `34`, `-19` и т.д.) и рациональные числа (`1.3`, `1.0`, `-14.324` и т.д.) — это два отдельных **типа данных**. Такое разделение связано с особенностями устройства компьютеров. Есть и другие типы, с ними мы познакомимся позже.

Вот еще один пример, но уже с рациональным числом:

```python
print(10.234)  # => 10.234
```

Типы данных «строка», «целое число» и «рациональное число» — это *примитивные типы*, то есть они встроены в сам язык Python. В язык встроены также и некоторые составные типы, но пока мы будем работать только с примитивными. Программисты также могут создавать собственные типы данных.

По-английски строки в программировании называются strings, а строчки текстовых файлов — lines. Например, в коде кода выше есть строчка (line), но нет никаких строк (strings). В русском иногда может быть путаница, поэтому во всех уроках мы будем говорить **строка** для обозначения типа данных «строка», и **строчка** для обозначения строчек кода (lines) в файлах.
