
There are different ways to represent data in programs. There are **strings** - sets of characters in quotes like `"Hello, World!"`. There are **integers** - for example, `7`, `-198`, `0`. These are two different categories of information - two different **types of data**. The multiplication operation makes sense for the “integers” category, but not for the “strings” category: it makes no sense to multiply the word “mom” by the word “notepad”.

The data type determines what can be done with the elements of a particular set of information. In this lesson we'll learn about data types and how typing works in Python.

The programming language recognizes data types, so Python won't let us multiply a string by another string - you can't multiply text by text. You can multiply an integer by another integer. The existence of types and these restrictions in the language protects programs from accidental errors.

Unlike strings, numbers don't need to be wrapped in quotes. To print the number 5, all you have to do is write:

```python
print(5)  # => 5
```

The number `5` and the string `'5'` are completely different things, although the output given by `print()` for this data is identical. Whole numbers (`1`, `34`, `-19`, etc.) and rational numbers (`1.3`, `1.0`, `14.324`, etc.) are two separate **types of data**. This division is due to the peculiarities of how computers are set up. There are other types, which we'll get to know later.

Here's another example, but with a rational number:

```python
print(10.234)  # => 10.234
```

The data types “string”, “integer” and “rational number” are *primitive types*, i.e., they're built into the Python language itself. Some composite types are also built into the language, but for now, we'll only be working with the primitive ones. Programmers can also create their own data types.

In English, strings in programming are called strings, and lines in text files are called lines. For example, in the code above there is a line, but no strings. In Russian there can sometimes be confusion, so in all the lessons we will say **string** to indicate the data type "string", and **string** to indicate lines in the code (lines) in the files.
